/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.CollectorRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public abstract class Collector {
    public static final double NANOSECONDS_PER_SECOND = 1.0E9;
    public static final double MILLISECONDS_PER_SECOND = 1000.0;
    protected static final Pattern METRIC_NAME_RE = Pattern.compile("[a-zA-Z_:][a-zA-Z0-9_:]*");
    protected static final Pattern METRIC_LABEL_NAME_RE = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    protected static final Pattern RESERVED_METRIC_LABEL_NAME_RE = Pattern.compile("__.*");

    public abstract List<MetricFamilySamples> collect();

    public <T extends Collector> T register() {
        return this.register(CollectorRegistry.defaultRegistry);
    }

    public <T extends Collector> T register(CollectorRegistry registry) {
        registry.register(this);
        return (T)this;
    }

    protected static void checkMetricName(String name2) {
        if (!METRIC_NAME_RE.matcher(name2).matches()) {
            throw new IllegalArgumentException("Invalid metric name: " + name2);
        }
    }

    protected static void checkMetricLabelName(String name2) {
        if (!METRIC_LABEL_NAME_RE.matcher(name2).matches()) {
            throw new IllegalArgumentException("Invalid metric label name: " + name2);
        }
        if (RESERVED_METRIC_LABEL_NAME_RE.matcher(name2).matches()) {
            throw new IllegalArgumentException("Invalid metric label name, reserved for internal use: " + name2);
        }
    }

    public static String doubleToGoString(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return "+Inf";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        return Double.toString(d);
    }

    public static class MetricFamilySamples {
        public final String name;
        public final Type type;
        public final String help;
        public final List<Sample> samples;

        public MetricFamilySamples(String name2, Type type2, String help, List<Sample> samples) {
            this.name = name2;
            this.type = type2;
            this.help = help;
            this.samples = samples;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof MetricFamilySamples)) {
                return false;
            }
            MetricFamilySamples other = (MetricFamilySamples)obj;
            return other.name.equals(this.name) && other.type.equals((Object)this.type) && other.help.equals(this.help) && other.samples.equals(this.samples);
        }

        public int hashCode() {
            int hash2 = 1;
            hash2 = 37 * hash2 + this.name.hashCode();
            hash2 = 37 * hash2 + this.type.hashCode();
            hash2 = 37 * hash2 + this.help.hashCode();
            hash2 = 37 * hash2 + this.samples.hashCode();
            return hash2;
        }

        public String toString() {
            return "Name: " + this.name + " Type: " + (Object)((Object)this.type) + " Help: " + this.help + " Samples: " + this.samples;
        }

        public static class Sample {
            public final String name;
            public final List<String> labelNames;
            public final List<String> labelValues;
            public final double value;

            public Sample(String name2, List<String> labelNames, List<String> labelValues, double value) {
                this.name = name2;
                this.labelNames = labelNames;
                this.labelValues = labelValues;
                this.value = value;
            }

            public boolean equals(Object obj) {
                if (obj == null || !(obj instanceof Sample)) {
                    return false;
                }
                Sample other = (Sample)obj;
                return other.name.equals(this.name) && other.labelNames.equals(this.labelNames) && other.labelValues.equals(this.labelValues) && other.value == this.value;
            }

            public int hashCode() {
                int hash2 = 1;
                hash2 = 37 * hash2 + this.name.hashCode();
                hash2 = 37 * hash2 + this.labelNames.hashCode();
                hash2 = 37 * hash2 + this.labelValues.hashCode();
                long d = Double.doubleToLongBits(this.value);
                hash2 = 37 * hash2 + (int)(d ^ d >>> 32);
                return hash2;
            }

            public String toString() {
                return "Name: " + this.name + " LabelNames: " + Arrays.asList(this.labelNames) + " labelValues: " + this.labelValues + " Value: " + this.value;
            }
        }
    }

    public static enum Type {
        COUNTER,
        GAUGE,
        SUMMARY,
        HISTOGRAM;

    }
}

