/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class SimpleCollector<Child>
extends Collector {
    protected final String fullname;
    protected final String help;
    protected final List<String> labelNames;
    protected final ConcurrentMap<List<String>, Child> children = new ConcurrentHashMap<List<String>, Child>();
    protected Child noLabelsChild;

    public Child labels(String ... labelValues) {
        if (labelValues.length != this.labelNames.size()) {
            throw new IllegalArgumentException("Incorrect number of labels.");
        }
        for (String label : labelValues) {
            if (label != null) continue;
            throw new IllegalArgumentException("Label cannot be null.");
        }
        List<String> key2 = Arrays.asList(labelValues);
        Object c = this.children.get(key2);
        if (c != null) {
            return (Child)c;
        }
        this.children.putIfAbsent(key2, this.newChild());
        return (Child)this.children.get(key2);
    }

    public void remove(String ... labelValues) {
        this.children.remove(Arrays.asList(labelValues));
        this.initializeNoLabelsChild();
    }

    public void clear() {
        this.children.clear();
        this.initializeNoLabelsChild();
    }

    protected void initializeNoLabelsChild() {
        if (this.labelNames.size() == 0) {
            this.noLabelsChild = this.labels(new String[0]);
        }
    }

    public <T extends Collector> T setChild(Child child, String ... labelValues) {
        if (labelValues.length != this.labelNames.size()) {
            throw new IllegalArgumentException("Incorrect number of labels.");
        }
        this.children.put(Arrays.asList(labelValues), child);
        return (T)this;
    }

    protected abstract Child newChild();

    protected SimpleCollector(Builder b) {
        if (b.name.isEmpty()) {
            throw new IllegalStateException("Name hasn't been set.");
        }
        String name2 = b.name;
        if (!b.subsystem.isEmpty()) {
            name2 = b.subsystem + '_' + name2;
        }
        if (!b.namespace.isEmpty()) {
            name2 = b.namespace + '_' + name2;
        }
        this.fullname = name2;
        SimpleCollector.checkMetricName(this.fullname);
        if (b.help.isEmpty()) {
            throw new IllegalStateException("Help hasn't been set.");
        }
        this.help = b.help;
        this.labelNames = Arrays.asList(b.labelNames);
        for (String n : this.labelNames) {
            SimpleCollector.checkMetricLabelName(n);
        }
        if (!b.dontInitializeNoLabelsChild) {
            this.initializeNoLabelsChild();
        }
    }

    public static abstract class Builder<B extends Builder<B, C>, C extends SimpleCollector> {
        String namespace = "";
        String subsystem = "";
        String name = "";
        String fullname = "";
        String help = "";
        String[] labelNames = new String[0];
        boolean dontInitializeNoLabelsChild;

        public B name(String name2) {
            this.name = name2;
            return (B)this;
        }

        public B subsystem(String subsystem) {
            this.subsystem = subsystem;
            return (B)this;
        }

        public B namespace(String namespace2) {
            this.namespace = namespace2;
            return (B)this;
        }

        public B help(String help) {
            this.help = help;
            return (B)this;
        }

        public B labelNames(String ... labelNames) {
            this.labelNames = labelNames;
            return (B)this;
        }

        public abstract C create();

        public C register() {
            return this.register(CollectorRegistry.defaultRegistry);
        }

        public C register(CollectorRegistry registry) {
            C sc = this.create();
            registry.register((Collector)sc);
            return sc;
        }
    }
}

