/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.exporter.common;

import io.prometheus.client.Collector;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;

public class TextFormat {
    public static final String CONTENT_TYPE_004 = "text/plain; version=0.0.4; charset=utf-8";

    public static void write004(Writer writer2, Enumeration<Collector.MetricFamilySamples> mfs) throws IOException {
        for (Collector.MetricFamilySamples metricFamilySamples : Collections.list(mfs)) {
            writer2.write("# HELP " + metricFamilySamples.name + " " + TextFormat.escapeHelp(metricFamilySamples.help) + "\n");
            writer2.write("# TYPE " + metricFamilySamples.name + " " + TextFormat.typeString(metricFamilySamples.type) + "\n");
            for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
                writer2.write(sample.name);
                if (sample.labelNames.size() > 0) {
                    writer2.write("{");
                    for (int i = 0; i < sample.labelNames.size(); ++i) {
                        writer2.write(String.format("%s=\"%s\",", sample.labelNames.get(i), TextFormat.escapeLabelValue(sample.labelValues.get(i))));
                    }
                    writer2.write("}");
                }
                writer2.write(" " + Collector.doubleToGoString(sample.value) + "\n");
            }
        }
    }

    static String escapeHelp(String s) {
        return s.replace("\\", "\\\\").replace("\n", "\\n");
    }

    static String escapeLabelValue(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n");
    }

    static String typeString(Collector.Type t) {
        switch (t) {
            case GAUGE: {
                return "gauge";
            }
            case COUNTER: {
                return "counter";
            }
            case SUMMARY: {
                return "summary";
            }
            case HISTOGRAM: {
                return "histogram";
            }
        }
        return "untyped";
    }
}

