(ns schopfhirsch.injector)
 
(defprotocol Context
  (add-deps [this deps])
  (make [this id]))
 
(deftype context [ctx]
  Context
  (add-deps
   ;; Merge dependencies into ctx
   [this deps]
   (swap! ctx merge deps))
  (make
   ;; Do dependency injection (i.e. call the referenced function with
   ;; the right arguments)
   [this dependency]
   (if (map? dependency)
    (:val dependency)
    (let [dep (get @ctx dependency)]
      (apply (:f dep) (map #(make this %) (:p dep)))))))
 
(defn create-context
  "Returns a function that can be used to call functions with dependencies"
  []
  (context. (atom {})))
