(ns vrksasana.clojisr.r
  (:require [vrksasana.core :as v]
            [vrksasana.impl.r.core :as vr]
            [vrksasana.catalog :as catalog]))

(v/setup-ground vr/ground)

(v/end)

(defn r
  [form-or-code]
  ())

(v/current-season vr/ground)

(catalog/seasons)

(def tree1 (v/plant '(+ 1 2)))

(v/pick tree1)

;; setup global ground for DSL
(setup-ground r/ground)

(def r v/plant)

(def tree1 (r '(* 1 10))) ;; bind object under current ground
(def tree2 (r '(* 2 100))) ;; bind another under current ground
(let [small-data [3000]
      big-data (range 40000 40100)]
  (def tree (r `(+ ~tree1 ~tree2 ~small-data (min ~big-data) 500000)))) ;; and another, relying on above

tree1 ;; returns TREE, since there is no season open

(v/get-or-make-season :s1) ;; create first season under current ground

tree1 ;; executes and returns value under `s1`

(v/get-or-make-season :s2)

tree2 ;; executes and returns value under `s2`

(v/get-or-make-season :s1)

tree ;; executes and returns value under `s1`



;; some session, let's say :s1
(require-r '[base :as b]
           '[dplyr :as d])
(def my-val (b/rnorm 10))
my-val ;; this gives me some vector (RObject) of 10 random doubles

;; some other session, let's say :s2
;; I want to call:
(d/tibble my-val) 
