goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e52330){var e = e52330;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4742__auto__ = [];
var len__4736__auto___52465 = arguments.length;
var i__4737__auto___52466 = (0);
while(true){
if((i__4737__auto___52466 < len__4736__auto___52465)){
args__4742__auto__.push((arguments[i__4737__auto___52466]));

var G__52467 = (i__4737__auto___52466 + (1));
i__4737__auto___52466 = G__52467;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__52337){
var vec__52339 = p__52337;
var map__52342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52339,(0),null);
var map__52342__$1 = (((((!((map__52342 == null))))?(((((map__52342.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52342.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52342):map__52342);
var opts = map__52342__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52342__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52342__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52342__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52342__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__52344 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4126__auto__ = read_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4126__auto__ = write_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__52344__$1 = (((((!((map__52344 == null))))?(((((map__52344.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52344.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52344):map__52344);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52344__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52344__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__52331_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__52331_SHARP_);
}));

(web_socket.onclose = (function (p1__52332_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__52332_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__42854__auto___52470 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_52414){
var state_val_52415 = (state_52414[(1)]);
if((state_val_52415 === (7))){
var inst_52410 = (state_52414[(2)]);
var state_52414__$1 = state_52414;
var statearr_52416_52471 = state_52414__$1;
(statearr_52416_52471[(2)] = inst_52410);

(statearr_52416_52471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (20))){
var state_52414__$1 = state_52414;
var statearr_52417_52473 = state_52414__$1;
(statearr_52417_52473[(2)] = null);

(statearr_52417_52473[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (1))){
var inst_52347 = false;
var state_52414__$1 = (function (){var statearr_52419 = state_52414;
(statearr_52419[(7)] = inst_52347);

return statearr_52419;
})();
var statearr_52420_52474 = state_52414__$1;
(statearr_52420_52474[(2)] = null);

(statearr_52420_52474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (4))){
var inst_52361 = (state_52414[(8)]);
var inst_52363 = (state_52414[(9)]);
var inst_52361__$1 = (state_52414[(2)]);
var inst_52362 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_52361__$1,(0),null);
var inst_52363__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_52361__$1,(1),null);
var inst_52364 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_52363__$1,open_ch);
var state_52414__$1 = (function (){var statearr_52424 = state_52414;
(statearr_52424[(8)] = inst_52361__$1);

(statearr_52424[(10)] = inst_52362);

(statearr_52424[(9)] = inst_52363__$1);

return statearr_52424;
})();
if(inst_52364){
var statearr_52425_52476 = state_52414__$1;
(statearr_52425_52476[(1)] = (5));

} else {
var statearr_52426_52477 = state_52414__$1;
(statearr_52426_52477[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (15))){
var inst_52395 = (state_52414[(2)]);
var state_52414__$1 = state_52414;
var statearr_52427_52478 = state_52414__$1;
(statearr_52427_52478[(2)] = inst_52395);

(statearr_52427_52478[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (21))){
var inst_52406 = (state_52414[(2)]);
var state_52414__$1 = state_52414;
var statearr_52429_52479 = state_52414__$1;
(statearr_52429_52479[(2)] = inst_52406);

(statearr_52429_52479[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (13))){
var state_52414__$1 = state_52414;
var statearr_52433_52481 = state_52414__$1;
(statearr_52433_52481[(2)] = null);

(statearr_52433_52481[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (6))){
var inst_52363 = (state_52414[(9)]);
var inst_52378 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_52363,close_ch);
var state_52414__$1 = state_52414;
if(inst_52378){
var statearr_52435_52483 = state_52414__$1;
(statearr_52435_52483[(1)] = (9));

} else {
var statearr_52436_52484 = state_52414__$1;
(statearr_52436_52484[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (17))){
var state_52414__$1 = state_52414;
var statearr_52437_52485 = state_52414__$1;
(statearr_52437_52485[(2)] = initial_ch);

(statearr_52437_52485[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (3))){
var inst_52412 = (state_52414[(2)]);
var state_52414__$1 = state_52414;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52414__$1,inst_52412);
} else {
if((state_val_52415 === (12))){
var inst_52347 = (state_52414[(7)]);
var state_52414__$1 = state_52414;
if(cljs.core.truth_(inst_52347)){
var statearr_52438_52486 = state_52414__$1;
(statearr_52438_52486[(1)] = (16));

} else {
var statearr_52439_52487 = state_52414__$1;
(statearr_52439_52487[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (2))){
var inst_52357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52358 = [open_ch,close_ch];
var inst_52359 = (new cljs.core.PersistentVector(null,2,(5),inst_52357,inst_52358,null));
var state_52414__$1 = state_52414;
return cljs.core.async.ioc_alts_BANG_(state_52414__$1,(4),inst_52359);
} else {
if((state_val_52415 === (19))){
var inst_52362 = (state_52414[(10)]);
var state_52414__$1 = state_52414;
var statearr_52441_52489 = state_52414__$1;
(statearr_52441_52489[(2)] = inst_52362);

(statearr_52441_52489[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (11))){
var inst_52408 = (state_52414[(2)]);
var state_52414__$1 = state_52414;
var statearr_52442_52490 = state_52414__$1;
(statearr_52442_52490[(2)] = inst_52408);

(statearr_52442_52490[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (9))){
var inst_52361 = (state_52414[(8)]);
var inst_52384 = (state_52414[(11)]);
var inst_52383 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_52361,(0),null);
var inst_52384__$1 = chord.client.close_event__GT_maybe_error(inst_52383);
var state_52414__$1 = (function (){var statearr_52445 = state_52414;
(statearr_52445[(11)] = inst_52384__$1);

return statearr_52445;
})();
if(cljs.core.truth_(inst_52384__$1)){
var statearr_52446_52491 = state_52414__$1;
(statearr_52446_52491[(1)] = (12));

} else {
var statearr_52447_52492 = state_52414__$1;
(statearr_52447_52492[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (5))){
var inst_52361 = (state_52414[(8)]);
var inst_52369 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_52361,(0),null);
var inst_52370 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_52371 = [ws_chan];
var inst_52372 = cljs.core.PersistentHashMap.fromArrays(inst_52370,inst_52371);
var state_52414__$1 = (function (){var statearr_52449 = state_52414;
(statearr_52449[(12)] = inst_52369);

return statearr_52449;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52414__$1,(8),initial_ch,inst_52372);
} else {
if((state_val_52415 === (14))){
var inst_52398 = (state_52414[(2)]);
var inst_52399 = cljs.core.async.close_BANG_(ws_chan);
var inst_52400 = cljs.core.async.close_BANG_(initial_ch);
var state_52414__$1 = (function (){var statearr_52450 = state_52414;
(statearr_52450[(13)] = inst_52398);

(statearr_52450[(14)] = inst_52399);

return statearr_52450;
})();
var statearr_52451_52494 = state_52414__$1;
(statearr_52451_52494[(2)] = inst_52400);

(statearr_52451_52494[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (16))){
var state_52414__$1 = state_52414;
var statearr_52452_52495 = state_52414__$1;
(statearr_52452_52495[(2)] = read_ch__$1);

(statearr_52452_52495[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (10))){
var inst_52363 = (state_52414[(9)]);
var inst_52402 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_52363,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_52414__$1 = state_52414;
if(inst_52402){
var statearr_52454_52497 = state_52414__$1;
(statearr_52454_52497[(1)] = (19));

} else {
var statearr_52455_52498 = state_52414__$1;
(statearr_52455_52498[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52415 === (18))){
var inst_52384 = (state_52414[(11)]);
var inst_52389 = (state_52414[(2)]);
var inst_52390 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_52392 = [inst_52384];
var inst_52393 = cljs.core.PersistentHashMap.fromArrays(inst_52390,inst_52392);
var state_52414__$1 = state_52414;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52414__$1,(15),inst_52389,inst_52393);
} else {
if((state_val_52415 === (8))){
var inst_52374 = (state_52414[(2)]);
var inst_52375 = cljs.core.async.close_BANG_(initial_ch);
var inst_52347 = true;
var state_52414__$1 = (function (){var statearr_52456 = state_52414;
(statearr_52456[(7)] = inst_52347);

(statearr_52456[(15)] = inst_52375);

(statearr_52456[(16)] = inst_52374);

return statearr_52456;
})();
var statearr_52457_52499 = state_52414__$1;
(statearr_52457_52499[(2)] = null);

(statearr_52457_52499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__42649__auto__ = null;
var chord$client$state_machine__42649__auto____0 = (function (){
var statearr_52459 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52459[(0)] = chord$client$state_machine__42649__auto__);

(statearr_52459[(1)] = (1));

return statearr_52459;
});
var chord$client$state_machine__42649__auto____1 = (function (state_52414){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_52414);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e52460){if((e52460 instanceof Object)){
var ex__42652__auto__ = e52460;
var statearr_52461_52503 = state_52414;
(statearr_52461_52503[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52414);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52460;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52504 = state_52414;
state_52414 = G__52504;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
chord$client$state_machine__42649__auto__ = function(state_52414){
switch(arguments.length){
case 0:
return chord$client$state_machine__42649__auto____0.call(this);
case 1:
return chord$client$state_machine__42649__auto____1.call(this,state_52414);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__42649__auto____0;
chord$client$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__42649__auto____1;
return chord$client$state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_52462 = f__42855__auto__();
(statearr_52462[(6)] = c__42854__auto___52470);

return statearr_52462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq52334){
var G__52335 = cljs.core.first(seq52334);
var seq52334__$1 = cljs.core.next(seq52334);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__52335,seq52334__$1);
}));


//# sourceMappingURL=chord.client.js.map
