goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__42967 = arguments.length;
switch (G__42967) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42973 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42973 = (function (f,blockable,meta42974){
this.f = f;
this.blockable = blockable;
this.meta42974 = meta42974;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42973.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42975,meta42974__$1){
var self__ = this;
var _42975__$1 = this;
return (new cljs.core.async.t_cljs$core$async42973(self__.f,self__.blockable,meta42974__$1));
}));

(cljs.core.async.t_cljs$core$async42973.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42975){
var self__ = this;
var _42975__$1 = this;
return self__.meta42974;
}));

(cljs.core.async.t_cljs$core$async42973.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42973.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42973.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async42973.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async42973.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta42974","meta42974",1811822493,null)], null);
}));

(cljs.core.async.t_cljs$core$async42973.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42973.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42973");

(cljs.core.async.t_cljs$core$async42973.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async42973");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42973.
 */
cljs.core.async.__GT_t_cljs$core$async42973 = (function cljs$core$async$__GT_t_cljs$core$async42973(f__$1,blockable__$1,meta42974){
return (new cljs.core.async.t_cljs$core$async42973(f__$1,blockable__$1,meta42974));
});

}

return (new cljs.core.async.t_cljs$core$async42973(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__42997 = arguments.length;
switch (G__42997) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__43016 = arguments.length;
switch (G__43016) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__43034 = arguments.length;
switch (G__43034) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_45682 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_45682) : fn1.call(null,val_45682));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_45682) : fn1.call(null,val_45682));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__43057 = arguments.length;
switch (G__43057) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___45687 = n;
var x_45688 = (0);
while(true){
if((x_45688 < n__4613__auto___45687)){
(a[x_45688] = x_45688);

var G__45689 = (x_45688 + (1));
x_45688 = G__45689;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43090 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43090 = (function (flag,meta43091){
this.flag = flag;
this.meta43091 = meta43091;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43090.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43092,meta43091__$1){
var self__ = this;
var _43092__$1 = this;
return (new cljs.core.async.t_cljs$core$async43090(self__.flag,meta43091__$1));
}));

(cljs.core.async.t_cljs$core$async43090.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43092){
var self__ = this;
var _43092__$1 = this;
return self__.meta43091;
}));

(cljs.core.async.t_cljs$core$async43090.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43090.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async43090.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43090.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async43090.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta43091","meta43091",1908006698,null)], null);
}));

(cljs.core.async.t_cljs$core$async43090.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43090.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43090");

(cljs.core.async.t_cljs$core$async43090.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async43090");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43090.
 */
cljs.core.async.__GT_t_cljs$core$async43090 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async43090(flag__$1,meta43091){
return (new cljs.core.async.t_cljs$core$async43090(flag__$1,meta43091));
});

}

return (new cljs.core.async.t_cljs$core$async43090(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43137 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43137 = (function (flag,cb,meta43138){
this.flag = flag;
this.cb = cb;
this.meta43138 = meta43138;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43137.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43139,meta43138__$1){
var self__ = this;
var _43139__$1 = this;
return (new cljs.core.async.t_cljs$core$async43137(self__.flag,self__.cb,meta43138__$1));
}));

(cljs.core.async.t_cljs$core$async43137.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43139){
var self__ = this;
var _43139__$1 = this;
return self__.meta43138;
}));

(cljs.core.async.t_cljs$core$async43137.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43137.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async43137.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43137.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async43137.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta43138","meta43138",-1583537459,null)], null);
}));

(cljs.core.async.t_cljs$core$async43137.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43137.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43137");

(cljs.core.async.t_cljs$core$async43137.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async43137");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43137.
 */
cljs.core.async.__GT_t_cljs$core$async43137 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async43137(flag__$1,cb__$1,meta43138){
return (new cljs.core.async.t_cljs$core$async43137(flag__$1,cb__$1,meta43138));
});

}

return (new cljs.core.async.t_cljs$core$async43137(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__43146_SHARP_){
var G__43154 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__43146_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__43154) : fret.call(null,G__43154));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__43147_SHARP_){
var G__43155 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__43147_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__43155) : fret.call(null,G__43155));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__45698 = (i + (1));
i = G__45698;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___45701 = arguments.length;
var i__4737__auto___45702 = (0);
while(true){
if((i__4737__auto___45702 < len__4736__auto___45701)){
args__4742__auto__.push((arguments[i__4737__auto___45702]));

var G__45703 = (i__4737__auto___45702 + (1));
i__4737__auto___45702 = G__45703;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__43168){
var map__43169 = p__43168;
var map__43169__$1 = (((((!((map__43169 == null))))?(((((map__43169.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43169.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43169):map__43169);
var opts = map__43169__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq43160){
var G__43161 = cljs.core.first(seq43160);
var seq43160__$1 = cljs.core.next(seq43160);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43161,seq43160__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__43179 = arguments.length;
switch (G__43179) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__42854__auto___45709 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_43212){
var state_val_43213 = (state_43212[(1)]);
if((state_val_43213 === (7))){
var inst_43208 = (state_43212[(2)]);
var state_43212__$1 = state_43212;
var statearr_43214_45710 = state_43212__$1;
(statearr_43214_45710[(2)] = inst_43208);

(statearr_43214_45710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43213 === (1))){
var state_43212__$1 = state_43212;
var statearr_43216_45711 = state_43212__$1;
(statearr_43216_45711[(2)] = null);

(statearr_43216_45711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43213 === (4))){
var inst_43185 = (state_43212[(7)]);
var inst_43185__$1 = (state_43212[(2)]);
var inst_43186 = (inst_43185__$1 == null);
var state_43212__$1 = (function (){var statearr_43221 = state_43212;
(statearr_43221[(7)] = inst_43185__$1);

return statearr_43221;
})();
if(cljs.core.truth_(inst_43186)){
var statearr_43223_45712 = state_43212__$1;
(statearr_43223_45712[(1)] = (5));

} else {
var statearr_43224_45713 = state_43212__$1;
(statearr_43224_45713[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43213 === (13))){
var state_43212__$1 = state_43212;
var statearr_43225_45715 = state_43212__$1;
(statearr_43225_45715[(2)] = null);

(statearr_43225_45715[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43213 === (6))){
var inst_43185 = (state_43212[(7)]);
var state_43212__$1 = state_43212;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43212__$1,(11),to,inst_43185);
} else {
if((state_val_43213 === (3))){
var inst_43210 = (state_43212[(2)]);
var state_43212__$1 = state_43212;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43212__$1,inst_43210);
} else {
if((state_val_43213 === (12))){
var state_43212__$1 = state_43212;
var statearr_43226_45717 = state_43212__$1;
(statearr_43226_45717[(2)] = null);

(statearr_43226_45717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43213 === (2))){
var state_43212__$1 = state_43212;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43212__$1,(4),from);
} else {
if((state_val_43213 === (11))){
var inst_43198 = (state_43212[(2)]);
var state_43212__$1 = state_43212;
if(cljs.core.truth_(inst_43198)){
var statearr_43227_45718 = state_43212__$1;
(statearr_43227_45718[(1)] = (12));

} else {
var statearr_43228_45719 = state_43212__$1;
(statearr_43228_45719[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43213 === (9))){
var state_43212__$1 = state_43212;
var statearr_43230_45720 = state_43212__$1;
(statearr_43230_45720[(2)] = null);

(statearr_43230_45720[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43213 === (5))){
var state_43212__$1 = state_43212;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43238_45721 = state_43212__$1;
(statearr_43238_45721[(1)] = (8));

} else {
var statearr_43239_45722 = state_43212__$1;
(statearr_43239_45722[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43213 === (14))){
var inst_43206 = (state_43212[(2)]);
var state_43212__$1 = state_43212;
var statearr_43247_45723 = state_43212__$1;
(statearr_43247_45723[(2)] = inst_43206);

(statearr_43247_45723[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43213 === (10))){
var inst_43195 = (state_43212[(2)]);
var state_43212__$1 = state_43212;
var statearr_43249_45725 = state_43212__$1;
(statearr_43249_45725[(2)] = inst_43195);

(statearr_43249_45725[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43213 === (8))){
var inst_43192 = cljs.core.async.close_BANG_(to);
var state_43212__$1 = state_43212;
var statearr_43251_45727 = state_43212__$1;
(statearr_43251_45727[(2)] = inst_43192);

(statearr_43251_45727[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42649__auto__ = null;
var cljs$core$async$state_machine__42649__auto____0 = (function (){
var statearr_43257 = [null,null,null,null,null,null,null,null];
(statearr_43257[(0)] = cljs$core$async$state_machine__42649__auto__);

(statearr_43257[(1)] = (1));

return statearr_43257;
});
var cljs$core$async$state_machine__42649__auto____1 = (function (state_43212){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_43212);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e43258){if((e43258 instanceof Object)){
var ex__42652__auto__ = e43258;
var statearr_43261_45728 = state_43212;
(statearr_43261_45728[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43212);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43258;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45731 = state_43212;
state_43212 = G__45731;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$state_machine__42649__auto__ = function(state_43212){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42649__auto____1.call(this,state_43212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42649__auto____0;
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42649__auto____1;
return cljs$core$async$state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_43266 = f__42855__auto__();
(statearr_43266[(6)] = c__42854__auto___45709);

return statearr_43266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__43273){
var vec__43274 = p__43273;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43274,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43274,(1),null);
var job = vec__43274;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__42854__auto___45743 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_43281){
var state_val_43282 = (state_43281[(1)]);
if((state_val_43282 === (1))){
var state_43281__$1 = state_43281;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43281__$1,(2),res,v);
} else {
if((state_val_43282 === (2))){
var inst_43278 = (state_43281[(2)]);
var inst_43279 = cljs.core.async.close_BANG_(res);
var state_43281__$1 = (function (){var statearr_43287 = state_43281;
(statearr_43287[(7)] = inst_43278);

return statearr_43287;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_43281__$1,inst_43279);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0 = (function (){
var statearr_43289 = [null,null,null,null,null,null,null,null];
(statearr_43289[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__);

(statearr_43289[(1)] = (1));

return statearr_43289;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1 = (function (state_43281){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_43281);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e43290){if((e43290 instanceof Object)){
var ex__42652__auto__ = e43290;
var statearr_43292_45745 = state_43281;
(statearr_43292_45745[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43281);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43290;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45746 = state_43281;
state_43281 = G__45746;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__ = function(state_43281){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1.call(this,state_43281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_43300 = f__42855__auto__();
(statearr_43300[(6)] = c__42854__auto___45743);

return statearr_43300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__43301){
var vec__43302 = p__43301;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43302,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43302,(1),null);
var job = vec__43302;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___45748 = n;
var __45749 = (0);
while(true){
if((__45749 < n__4613__auto___45748)){
var G__43306_45750 = type;
var G__43306_45751__$1 = (((G__43306_45750 instanceof cljs.core.Keyword))?G__43306_45750.fqn:null);
switch (G__43306_45751__$1) {
case "compute":
var c__42854__auto___45753 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__45749,c__42854__auto___45753,G__43306_45750,G__43306_45751__$1,n__4613__auto___45748,jobs,results,process,async){
return (function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = ((function (__45749,c__42854__auto___45753,G__43306_45750,G__43306_45751__$1,n__4613__auto___45748,jobs,results,process,async){
return (function (state_43324){
var state_val_43325 = (state_43324[(1)]);
if((state_val_43325 === (1))){
var state_43324__$1 = state_43324;
var statearr_43326_45756 = state_43324__$1;
(statearr_43326_45756[(2)] = null);

(statearr_43326_45756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43325 === (2))){
var state_43324__$1 = state_43324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43324__$1,(4),jobs);
} else {
if((state_val_43325 === (3))){
var inst_43322 = (state_43324[(2)]);
var state_43324__$1 = state_43324;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43324__$1,inst_43322);
} else {
if((state_val_43325 === (4))){
var inst_43311 = (state_43324[(2)]);
var inst_43312 = process(inst_43311);
var state_43324__$1 = state_43324;
if(cljs.core.truth_(inst_43312)){
var statearr_43327_45765 = state_43324__$1;
(statearr_43327_45765[(1)] = (5));

} else {
var statearr_43328_45770 = state_43324__$1;
(statearr_43328_45770[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43325 === (5))){
var state_43324__$1 = state_43324;
var statearr_43332_45771 = state_43324__$1;
(statearr_43332_45771[(2)] = null);

(statearr_43332_45771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43325 === (6))){
var state_43324__$1 = state_43324;
var statearr_43333_45772 = state_43324__$1;
(statearr_43333_45772[(2)] = null);

(statearr_43333_45772[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43325 === (7))){
var inst_43320 = (state_43324[(2)]);
var state_43324__$1 = state_43324;
var statearr_43338_45775 = state_43324__$1;
(statearr_43338_45775[(2)] = inst_43320);

(statearr_43338_45775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__45749,c__42854__auto___45753,G__43306_45750,G__43306_45751__$1,n__4613__auto___45748,jobs,results,process,async))
;
return ((function (__45749,switch__42648__auto__,c__42854__auto___45753,G__43306_45750,G__43306_45751__$1,n__4613__auto___45748,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0 = (function (){
var statearr_43339 = [null,null,null,null,null,null,null];
(statearr_43339[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__);

(statearr_43339[(1)] = (1));

return statearr_43339;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1 = (function (state_43324){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_43324);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e43340){if((e43340 instanceof Object)){
var ex__42652__auto__ = e43340;
var statearr_43341_45778 = state_43324;
(statearr_43341_45778[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43324);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43340;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45779 = state_43324;
state_43324 = G__45779;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__ = function(state_43324){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1.call(this,state_43324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__;
})()
;})(__45749,switch__42648__auto__,c__42854__auto___45753,G__43306_45750,G__43306_45751__$1,n__4613__auto___45748,jobs,results,process,async))
})();
var state__42856__auto__ = (function (){var statearr_43342 = f__42855__auto__();
(statearr_43342[(6)] = c__42854__auto___45753);

return statearr_43342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
});})(__45749,c__42854__auto___45753,G__43306_45750,G__43306_45751__$1,n__4613__auto___45748,jobs,results,process,async))
);


break;
case "async":
var c__42854__auto___45780 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__45749,c__42854__auto___45780,G__43306_45750,G__43306_45751__$1,n__4613__auto___45748,jobs,results,process,async){
return (function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = ((function (__45749,c__42854__auto___45780,G__43306_45750,G__43306_45751__$1,n__4613__auto___45748,jobs,results,process,async){
return (function (state_43358){
var state_val_43359 = (state_43358[(1)]);
if((state_val_43359 === (1))){
var state_43358__$1 = state_43358;
var statearr_43360_45781 = state_43358__$1;
(statearr_43360_45781[(2)] = null);

(statearr_43360_45781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43359 === (2))){
var state_43358__$1 = state_43358;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43358__$1,(4),jobs);
} else {
if((state_val_43359 === (3))){
var inst_43356 = (state_43358[(2)]);
var state_43358__$1 = state_43358;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43358__$1,inst_43356);
} else {
if((state_val_43359 === (4))){
var inst_43347 = (state_43358[(2)]);
var inst_43348 = async(inst_43347);
var state_43358__$1 = state_43358;
if(cljs.core.truth_(inst_43348)){
var statearr_43362_45783 = state_43358__$1;
(statearr_43362_45783[(1)] = (5));

} else {
var statearr_43363_45786 = state_43358__$1;
(statearr_43363_45786[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43359 === (5))){
var state_43358__$1 = state_43358;
var statearr_43364_45791 = state_43358__$1;
(statearr_43364_45791[(2)] = null);

(statearr_43364_45791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43359 === (6))){
var state_43358__$1 = state_43358;
var statearr_43366_45792 = state_43358__$1;
(statearr_43366_45792[(2)] = null);

(statearr_43366_45792[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43359 === (7))){
var inst_43354 = (state_43358[(2)]);
var state_43358__$1 = state_43358;
var statearr_43367_45793 = state_43358__$1;
(statearr_43367_45793[(2)] = inst_43354);

(statearr_43367_45793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__45749,c__42854__auto___45780,G__43306_45750,G__43306_45751__$1,n__4613__auto___45748,jobs,results,process,async))
;
return ((function (__45749,switch__42648__auto__,c__42854__auto___45780,G__43306_45750,G__43306_45751__$1,n__4613__auto___45748,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0 = (function (){
var statearr_43368 = [null,null,null,null,null,null,null];
(statearr_43368[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__);

(statearr_43368[(1)] = (1));

return statearr_43368;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1 = (function (state_43358){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_43358);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e43369){if((e43369 instanceof Object)){
var ex__42652__auto__ = e43369;
var statearr_43370_45797 = state_43358;
(statearr_43370_45797[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43358);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43369;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45798 = state_43358;
state_43358 = G__45798;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__ = function(state_43358){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1.call(this,state_43358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__;
})()
;})(__45749,switch__42648__auto__,c__42854__auto___45780,G__43306_45750,G__43306_45751__$1,n__4613__auto___45748,jobs,results,process,async))
})();
var state__42856__auto__ = (function (){var statearr_43371 = f__42855__auto__();
(statearr_43371[(6)] = c__42854__auto___45780);

return statearr_43371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
});})(__45749,c__42854__auto___45780,G__43306_45750,G__43306_45751__$1,n__4613__auto___45748,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43306_45751__$1)].join('')));

}

var G__45806 = (__45749 + (1));
__45749 = G__45806;
continue;
} else {
}
break;
}

var c__42854__auto___45813 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_43394){
var state_val_43395 = (state_43394[(1)]);
if((state_val_43395 === (7))){
var inst_43390 = (state_43394[(2)]);
var state_43394__$1 = state_43394;
var statearr_43396_45815 = state_43394__$1;
(statearr_43396_45815[(2)] = inst_43390);

(statearr_43396_45815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43395 === (1))){
var state_43394__$1 = state_43394;
var statearr_43397_45819 = state_43394__$1;
(statearr_43397_45819[(2)] = null);

(statearr_43397_45819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43395 === (4))){
var inst_43375 = (state_43394[(7)]);
var inst_43375__$1 = (state_43394[(2)]);
var inst_43376 = (inst_43375__$1 == null);
var state_43394__$1 = (function (){var statearr_43398 = state_43394;
(statearr_43398[(7)] = inst_43375__$1);

return statearr_43398;
})();
if(cljs.core.truth_(inst_43376)){
var statearr_43399_45827 = state_43394__$1;
(statearr_43399_45827[(1)] = (5));

} else {
var statearr_43400_45828 = state_43394__$1;
(statearr_43400_45828[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43395 === (6))){
var inst_43380 = (state_43394[(8)]);
var inst_43375 = (state_43394[(7)]);
var inst_43380__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_43381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43382 = [inst_43375,inst_43380__$1];
var inst_43383 = (new cljs.core.PersistentVector(null,2,(5),inst_43381,inst_43382,null));
var state_43394__$1 = (function (){var statearr_43401 = state_43394;
(statearr_43401[(8)] = inst_43380__$1);

return statearr_43401;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43394__$1,(8),jobs,inst_43383);
} else {
if((state_val_43395 === (3))){
var inst_43392 = (state_43394[(2)]);
var state_43394__$1 = state_43394;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43394__$1,inst_43392);
} else {
if((state_val_43395 === (2))){
var state_43394__$1 = state_43394;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43394__$1,(4),from);
} else {
if((state_val_43395 === (9))){
var inst_43387 = (state_43394[(2)]);
var state_43394__$1 = (function (){var statearr_43402 = state_43394;
(statearr_43402[(9)] = inst_43387);

return statearr_43402;
})();
var statearr_43403_45835 = state_43394__$1;
(statearr_43403_45835[(2)] = null);

(statearr_43403_45835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43395 === (5))){
var inst_43378 = cljs.core.async.close_BANG_(jobs);
var state_43394__$1 = state_43394;
var statearr_43407_45836 = state_43394__$1;
(statearr_43407_45836[(2)] = inst_43378);

(statearr_43407_45836[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43395 === (8))){
var inst_43380 = (state_43394[(8)]);
var inst_43385 = (state_43394[(2)]);
var state_43394__$1 = (function (){var statearr_43408 = state_43394;
(statearr_43408[(10)] = inst_43385);

return statearr_43408;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43394__$1,(9),results,inst_43380);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0 = (function (){
var statearr_43413 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43413[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__);

(statearr_43413[(1)] = (1));

return statearr_43413;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1 = (function (state_43394){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_43394);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e43415){if((e43415 instanceof Object)){
var ex__42652__auto__ = e43415;
var statearr_43416_45846 = state_43394;
(statearr_43416_45846[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43394);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43415;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45854 = state_43394;
state_43394 = G__45854;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__ = function(state_43394){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1.call(this,state_43394);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_43421 = f__42855__auto__();
(statearr_43421[(6)] = c__42854__auto___45813);

return statearr_43421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


var c__42854__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_43460){
var state_val_43461 = (state_43460[(1)]);
if((state_val_43461 === (7))){
var inst_43456 = (state_43460[(2)]);
var state_43460__$1 = state_43460;
var statearr_43462_45858 = state_43460__$1;
(statearr_43462_45858[(2)] = inst_43456);

(statearr_43462_45858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (20))){
var state_43460__$1 = state_43460;
var statearr_43463_45859 = state_43460__$1;
(statearr_43463_45859[(2)] = null);

(statearr_43463_45859[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (1))){
var state_43460__$1 = state_43460;
var statearr_43464_45860 = state_43460__$1;
(statearr_43464_45860[(2)] = null);

(statearr_43464_45860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (4))){
var inst_43425 = (state_43460[(7)]);
var inst_43425__$1 = (state_43460[(2)]);
var inst_43426 = (inst_43425__$1 == null);
var state_43460__$1 = (function (){var statearr_43465 = state_43460;
(statearr_43465[(7)] = inst_43425__$1);

return statearr_43465;
})();
if(cljs.core.truth_(inst_43426)){
var statearr_43473_45864 = state_43460__$1;
(statearr_43473_45864[(1)] = (5));

} else {
var statearr_43474_45865 = state_43460__$1;
(statearr_43474_45865[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (15))){
var inst_43438 = (state_43460[(8)]);
var state_43460__$1 = state_43460;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43460__$1,(18),to,inst_43438);
} else {
if((state_val_43461 === (21))){
var inst_43451 = (state_43460[(2)]);
var state_43460__$1 = state_43460;
var statearr_43492_45866 = state_43460__$1;
(statearr_43492_45866[(2)] = inst_43451);

(statearr_43492_45866[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (13))){
var inst_43453 = (state_43460[(2)]);
var state_43460__$1 = (function (){var statearr_43499 = state_43460;
(statearr_43499[(9)] = inst_43453);

return statearr_43499;
})();
var statearr_43507_45868 = state_43460__$1;
(statearr_43507_45868[(2)] = null);

(statearr_43507_45868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (6))){
var inst_43425 = (state_43460[(7)]);
var state_43460__$1 = state_43460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43460__$1,(11),inst_43425);
} else {
if((state_val_43461 === (17))){
var inst_43446 = (state_43460[(2)]);
var state_43460__$1 = state_43460;
if(cljs.core.truth_(inst_43446)){
var statearr_43522_45869 = state_43460__$1;
(statearr_43522_45869[(1)] = (19));

} else {
var statearr_43527_45870 = state_43460__$1;
(statearr_43527_45870[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (3))){
var inst_43458 = (state_43460[(2)]);
var state_43460__$1 = state_43460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43460__$1,inst_43458);
} else {
if((state_val_43461 === (12))){
var inst_43435 = (state_43460[(10)]);
var state_43460__$1 = state_43460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43460__$1,(14),inst_43435);
} else {
if((state_val_43461 === (2))){
var state_43460__$1 = state_43460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43460__$1,(4),results);
} else {
if((state_val_43461 === (19))){
var state_43460__$1 = state_43460;
var statearr_43536_45871 = state_43460__$1;
(statearr_43536_45871[(2)] = null);

(statearr_43536_45871[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (11))){
var inst_43435 = (state_43460[(2)]);
var state_43460__$1 = (function (){var statearr_43549 = state_43460;
(statearr_43549[(10)] = inst_43435);

return statearr_43549;
})();
var statearr_43551_45872 = state_43460__$1;
(statearr_43551_45872[(2)] = null);

(statearr_43551_45872[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (9))){
var state_43460__$1 = state_43460;
var statearr_43562_45874 = state_43460__$1;
(statearr_43562_45874[(2)] = null);

(statearr_43562_45874[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (5))){
var state_43460__$1 = state_43460;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43566_45876 = state_43460__$1;
(statearr_43566_45876[(1)] = (8));

} else {
var statearr_43567_45877 = state_43460__$1;
(statearr_43567_45877[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (14))){
var inst_43438 = (state_43460[(8)]);
var inst_43438__$1 = (state_43460[(2)]);
var inst_43439 = (inst_43438__$1 == null);
var inst_43440 = cljs.core.not(inst_43439);
var state_43460__$1 = (function (){var statearr_43572 = state_43460;
(statearr_43572[(8)] = inst_43438__$1);

return statearr_43572;
})();
if(inst_43440){
var statearr_43573_45878 = state_43460__$1;
(statearr_43573_45878[(1)] = (15));

} else {
var statearr_43574_45879 = state_43460__$1;
(statearr_43574_45879[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (16))){
var state_43460__$1 = state_43460;
var statearr_43575_45880 = state_43460__$1;
(statearr_43575_45880[(2)] = false);

(statearr_43575_45880[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (10))){
var inst_43432 = (state_43460[(2)]);
var state_43460__$1 = state_43460;
var statearr_43576_45881 = state_43460__$1;
(statearr_43576_45881[(2)] = inst_43432);

(statearr_43576_45881[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (18))){
var inst_43443 = (state_43460[(2)]);
var state_43460__$1 = state_43460;
var statearr_43579_45882 = state_43460__$1;
(statearr_43579_45882[(2)] = inst_43443);

(statearr_43579_45882[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43461 === (8))){
var inst_43429 = cljs.core.async.close_BANG_(to);
var state_43460__$1 = state_43460;
var statearr_43580_45883 = state_43460__$1;
(statearr_43580_45883[(2)] = inst_43429);

(statearr_43580_45883[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0 = (function (){
var statearr_43584 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43584[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__);

(statearr_43584[(1)] = (1));

return statearr_43584;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1 = (function (state_43460){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_43460);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e43585){if((e43585 instanceof Object)){
var ex__42652__auto__ = e43585;
var statearr_43586_45884 = state_43460;
(statearr_43586_45884[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43460);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43585;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45885 = state_43460;
state_43460 = G__45885;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__ = function(state_43460){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1.call(this,state_43460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42649__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_43588 = f__42855__auto__();
(statearr_43588[(6)] = c__42854__auto__);

return statearr_43588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));

return c__42854__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__43595 = arguments.length;
switch (G__43595) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__43615 = arguments.length;
switch (G__43615) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__43635 = arguments.length;
switch (G__43635) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__42854__auto___45903 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_43678){
var state_val_43679 = (state_43678[(1)]);
if((state_val_43679 === (7))){
var inst_43671 = (state_43678[(2)]);
var state_43678__$1 = state_43678;
var statearr_43683_45904 = state_43678__$1;
(statearr_43683_45904[(2)] = inst_43671);

(statearr_43683_45904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43679 === (1))){
var state_43678__$1 = state_43678;
var statearr_43684_45905 = state_43678__$1;
(statearr_43684_45905[(2)] = null);

(statearr_43684_45905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43679 === (4))){
var inst_43649 = (state_43678[(7)]);
var inst_43649__$1 = (state_43678[(2)]);
var inst_43650 = (inst_43649__$1 == null);
var state_43678__$1 = (function (){var statearr_43687 = state_43678;
(statearr_43687[(7)] = inst_43649__$1);

return statearr_43687;
})();
if(cljs.core.truth_(inst_43650)){
var statearr_43689_45910 = state_43678__$1;
(statearr_43689_45910[(1)] = (5));

} else {
var statearr_43694_45912 = state_43678__$1;
(statearr_43694_45912[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43679 === (13))){
var state_43678__$1 = state_43678;
var statearr_43696_45913 = state_43678__$1;
(statearr_43696_45913[(2)] = null);

(statearr_43696_45913[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43679 === (6))){
var inst_43649 = (state_43678[(7)]);
var inst_43658 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_43649) : p.call(null,inst_43649));
var state_43678__$1 = state_43678;
if(cljs.core.truth_(inst_43658)){
var statearr_43699_45920 = state_43678__$1;
(statearr_43699_45920[(1)] = (9));

} else {
var statearr_43700_45927 = state_43678__$1;
(statearr_43700_45927[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43679 === (3))){
var inst_43673 = (state_43678[(2)]);
var state_43678__$1 = state_43678;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43678__$1,inst_43673);
} else {
if((state_val_43679 === (12))){
var state_43678__$1 = state_43678;
var statearr_43705_45948 = state_43678__$1;
(statearr_43705_45948[(2)] = null);

(statearr_43705_45948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43679 === (2))){
var state_43678__$1 = state_43678;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43678__$1,(4),ch);
} else {
if((state_val_43679 === (11))){
var inst_43649 = (state_43678[(7)]);
var inst_43662 = (state_43678[(2)]);
var state_43678__$1 = state_43678;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43678__$1,(8),inst_43662,inst_43649);
} else {
if((state_val_43679 === (9))){
var state_43678__$1 = state_43678;
var statearr_43712_45956 = state_43678__$1;
(statearr_43712_45956[(2)] = tc);

(statearr_43712_45956[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43679 === (5))){
var inst_43652 = cljs.core.async.close_BANG_(tc);
var inst_43653 = cljs.core.async.close_BANG_(fc);
var state_43678__$1 = (function (){var statearr_43719 = state_43678;
(statearr_43719[(8)] = inst_43652);

return statearr_43719;
})();
var statearr_43726_45963 = state_43678__$1;
(statearr_43726_45963[(2)] = inst_43653);

(statearr_43726_45963[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43679 === (14))){
var inst_43669 = (state_43678[(2)]);
var state_43678__$1 = state_43678;
var statearr_43729_45965 = state_43678__$1;
(statearr_43729_45965[(2)] = inst_43669);

(statearr_43729_45965[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43679 === (10))){
var state_43678__$1 = state_43678;
var statearr_43732_45966 = state_43678__$1;
(statearr_43732_45966[(2)] = fc);

(statearr_43732_45966[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43679 === (8))){
var inst_43664 = (state_43678[(2)]);
var state_43678__$1 = state_43678;
if(cljs.core.truth_(inst_43664)){
var statearr_43734_45968 = state_43678__$1;
(statearr_43734_45968[(1)] = (12));

} else {
var statearr_43735_45969 = state_43678__$1;
(statearr_43735_45969[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42649__auto__ = null;
var cljs$core$async$state_machine__42649__auto____0 = (function (){
var statearr_43738 = [null,null,null,null,null,null,null,null,null];
(statearr_43738[(0)] = cljs$core$async$state_machine__42649__auto__);

(statearr_43738[(1)] = (1));

return statearr_43738;
});
var cljs$core$async$state_machine__42649__auto____1 = (function (state_43678){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_43678);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e43740){if((e43740 instanceof Object)){
var ex__42652__auto__ = e43740;
var statearr_43741_45975 = state_43678;
(statearr_43741_45975[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43678);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43740;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45976 = state_43678;
state_43678 = G__45976;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$state_machine__42649__auto__ = function(state_43678){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42649__auto____1.call(this,state_43678);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42649__auto____0;
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42649__auto____1;
return cljs$core$async$state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_43742 = f__42855__auto__();
(statearr_43742[(6)] = c__42854__auto___45903);

return statearr_43742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__42854__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_43778){
var state_val_43779 = (state_43778[(1)]);
if((state_val_43779 === (7))){
var inst_43774 = (state_43778[(2)]);
var state_43778__$1 = state_43778;
var statearr_43781_45983 = state_43778__$1;
(statearr_43781_45983[(2)] = inst_43774);

(statearr_43781_45983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43779 === (1))){
var inst_43753 = init;
var state_43778__$1 = (function (){var statearr_43784 = state_43778;
(statearr_43784[(7)] = inst_43753);

return statearr_43784;
})();
var statearr_43785_45985 = state_43778__$1;
(statearr_43785_45985[(2)] = null);

(statearr_43785_45985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43779 === (4))){
var inst_43759 = (state_43778[(8)]);
var inst_43759__$1 = (state_43778[(2)]);
var inst_43761 = (inst_43759__$1 == null);
var state_43778__$1 = (function (){var statearr_43788 = state_43778;
(statearr_43788[(8)] = inst_43759__$1);

return statearr_43788;
})();
if(cljs.core.truth_(inst_43761)){
var statearr_43789_45986 = state_43778__$1;
(statearr_43789_45986[(1)] = (5));

} else {
var statearr_43791_45987 = state_43778__$1;
(statearr_43791_45987[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43779 === (6))){
var inst_43765 = (state_43778[(9)]);
var inst_43759 = (state_43778[(8)]);
var inst_43753 = (state_43778[(7)]);
var inst_43765__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_43753,inst_43759) : f.call(null,inst_43753,inst_43759));
var inst_43766 = cljs.core.reduced_QMARK_(inst_43765__$1);
var state_43778__$1 = (function (){var statearr_43797 = state_43778;
(statearr_43797[(9)] = inst_43765__$1);

return statearr_43797;
})();
if(inst_43766){
var statearr_43798_45988 = state_43778__$1;
(statearr_43798_45988[(1)] = (8));

} else {
var statearr_43799_45989 = state_43778__$1;
(statearr_43799_45989[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43779 === (3))){
var inst_43776 = (state_43778[(2)]);
var state_43778__$1 = state_43778;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43778__$1,inst_43776);
} else {
if((state_val_43779 === (2))){
var state_43778__$1 = state_43778;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43778__$1,(4),ch);
} else {
if((state_val_43779 === (9))){
var inst_43765 = (state_43778[(9)]);
var inst_43753 = inst_43765;
var state_43778__$1 = (function (){var statearr_43804 = state_43778;
(statearr_43804[(7)] = inst_43753);

return statearr_43804;
})();
var statearr_43805_45990 = state_43778__$1;
(statearr_43805_45990[(2)] = null);

(statearr_43805_45990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43779 === (5))){
var inst_43753 = (state_43778[(7)]);
var state_43778__$1 = state_43778;
var statearr_43807_45991 = state_43778__$1;
(statearr_43807_45991[(2)] = inst_43753);

(statearr_43807_45991[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43779 === (10))){
var inst_43772 = (state_43778[(2)]);
var state_43778__$1 = state_43778;
var statearr_43808_45999 = state_43778__$1;
(statearr_43808_45999[(2)] = inst_43772);

(statearr_43808_45999[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43779 === (8))){
var inst_43765 = (state_43778[(9)]);
var inst_43768 = cljs.core.deref(inst_43765);
var state_43778__$1 = state_43778;
var statearr_43809_46000 = state_43778__$1;
(statearr_43809_46000[(2)] = inst_43768);

(statearr_43809_46000[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__42649__auto__ = null;
var cljs$core$async$reduce_$_state_machine__42649__auto____0 = (function (){
var statearr_43812 = [null,null,null,null,null,null,null,null,null,null];
(statearr_43812[(0)] = cljs$core$async$reduce_$_state_machine__42649__auto__);

(statearr_43812[(1)] = (1));

return statearr_43812;
});
var cljs$core$async$reduce_$_state_machine__42649__auto____1 = (function (state_43778){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_43778);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e43818){if((e43818 instanceof Object)){
var ex__42652__auto__ = e43818;
var statearr_43819_46003 = state_43778;
(statearr_43819_46003[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43778);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43818;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46004 = state_43778;
state_43778 = G__46004;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__42649__auto__ = function(state_43778){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__42649__auto____1.call(this,state_43778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__42649__auto____0;
cljs$core$async$reduce_$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__42649__auto____1;
return cljs$core$async$reduce_$_state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_43823 = f__42855__auto__();
(statearr_43823[(6)] = c__42854__auto__);

return statearr_43823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));

return c__42854__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__42854__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_43831){
var state_val_43832 = (state_43831[(1)]);
if((state_val_43832 === (1))){
var inst_43825 = cljs.core.async.reduce(f__$1,init,ch);
var state_43831__$1 = state_43831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43831__$1,(2),inst_43825);
} else {
if((state_val_43832 === (2))){
var inst_43827 = (state_43831[(2)]);
var inst_43828 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_43827) : f__$1.call(null,inst_43827));
var state_43831__$1 = state_43831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43831__$1,inst_43828);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__42649__auto__ = null;
var cljs$core$async$transduce_$_state_machine__42649__auto____0 = (function (){
var statearr_43841 = [null,null,null,null,null,null,null];
(statearr_43841[(0)] = cljs$core$async$transduce_$_state_machine__42649__auto__);

(statearr_43841[(1)] = (1));

return statearr_43841;
});
var cljs$core$async$transduce_$_state_machine__42649__auto____1 = (function (state_43831){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_43831);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e43843){if((e43843 instanceof Object)){
var ex__42652__auto__ = e43843;
var statearr_43844_46013 = state_43831;
(statearr_43844_46013[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43831);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43843;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46014 = state_43831;
state_43831 = G__46014;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__42649__auto__ = function(state_43831){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__42649__auto____1.call(this,state_43831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__42649__auto____0;
cljs$core$async$transduce_$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__42649__auto____1;
return cljs$core$async$transduce_$_state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_43851 = f__42855__auto__();
(statearr_43851[(6)] = c__42854__auto__);

return statearr_43851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));

return c__42854__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__43861 = arguments.length;
switch (G__43861) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__42854__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_43891){
var state_val_43892 = (state_43891[(1)]);
if((state_val_43892 === (7))){
var inst_43871 = (state_43891[(2)]);
var state_43891__$1 = state_43891;
var statearr_43894_46016 = state_43891__$1;
(statearr_43894_46016[(2)] = inst_43871);

(statearr_43894_46016[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43892 === (1))){
var inst_43865 = cljs.core.seq(coll);
var inst_43866 = inst_43865;
var state_43891__$1 = (function (){var statearr_43898 = state_43891;
(statearr_43898[(7)] = inst_43866);

return statearr_43898;
})();
var statearr_43900_46017 = state_43891__$1;
(statearr_43900_46017[(2)] = null);

(statearr_43900_46017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43892 === (4))){
var inst_43866 = (state_43891[(7)]);
var inst_43869 = cljs.core.first(inst_43866);
var state_43891__$1 = state_43891;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43891__$1,(7),ch,inst_43869);
} else {
if((state_val_43892 === (13))){
var inst_43885 = (state_43891[(2)]);
var state_43891__$1 = state_43891;
var statearr_43908_46021 = state_43891__$1;
(statearr_43908_46021[(2)] = inst_43885);

(statearr_43908_46021[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43892 === (6))){
var inst_43874 = (state_43891[(2)]);
var state_43891__$1 = state_43891;
if(cljs.core.truth_(inst_43874)){
var statearr_43909_46022 = state_43891__$1;
(statearr_43909_46022[(1)] = (8));

} else {
var statearr_43910_46023 = state_43891__$1;
(statearr_43910_46023[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43892 === (3))){
var inst_43889 = (state_43891[(2)]);
var state_43891__$1 = state_43891;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43891__$1,inst_43889);
} else {
if((state_val_43892 === (12))){
var state_43891__$1 = state_43891;
var statearr_43914_46025 = state_43891__$1;
(statearr_43914_46025[(2)] = null);

(statearr_43914_46025[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43892 === (2))){
var inst_43866 = (state_43891[(7)]);
var state_43891__$1 = state_43891;
if(cljs.core.truth_(inst_43866)){
var statearr_43916_46026 = state_43891__$1;
(statearr_43916_46026[(1)] = (4));

} else {
var statearr_43917_46027 = state_43891__$1;
(statearr_43917_46027[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43892 === (11))){
var inst_43882 = cljs.core.async.close_BANG_(ch);
var state_43891__$1 = state_43891;
var statearr_43918_46030 = state_43891__$1;
(statearr_43918_46030[(2)] = inst_43882);

(statearr_43918_46030[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43892 === (9))){
var state_43891__$1 = state_43891;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43923_46032 = state_43891__$1;
(statearr_43923_46032[(1)] = (11));

} else {
var statearr_43924_46034 = state_43891__$1;
(statearr_43924_46034[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43892 === (5))){
var inst_43866 = (state_43891[(7)]);
var state_43891__$1 = state_43891;
var statearr_43925_46035 = state_43891__$1;
(statearr_43925_46035[(2)] = inst_43866);

(statearr_43925_46035[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43892 === (10))){
var inst_43887 = (state_43891[(2)]);
var state_43891__$1 = state_43891;
var statearr_43926_46036 = state_43891__$1;
(statearr_43926_46036[(2)] = inst_43887);

(statearr_43926_46036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43892 === (8))){
var inst_43866 = (state_43891[(7)]);
var inst_43876 = cljs.core.next(inst_43866);
var inst_43866__$1 = inst_43876;
var state_43891__$1 = (function (){var statearr_43933 = state_43891;
(statearr_43933[(7)] = inst_43866__$1);

return statearr_43933;
})();
var statearr_43934_46042 = state_43891__$1;
(statearr_43934_46042[(2)] = null);

(statearr_43934_46042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42649__auto__ = null;
var cljs$core$async$state_machine__42649__auto____0 = (function (){
var statearr_43945 = [null,null,null,null,null,null,null,null];
(statearr_43945[(0)] = cljs$core$async$state_machine__42649__auto__);

(statearr_43945[(1)] = (1));

return statearr_43945;
});
var cljs$core$async$state_machine__42649__auto____1 = (function (state_43891){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_43891);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e43950){if((e43950 instanceof Object)){
var ex__42652__auto__ = e43950;
var statearr_43951_46046 = state_43891;
(statearr_43951_46046[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43891);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43950;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46047 = state_43891;
state_43891 = G__46047;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$state_machine__42649__auto__ = function(state_43891){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42649__auto____1.call(this,state_43891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42649__auto____0;
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42649__auto____1;
return cljs$core$async$state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_43956 = f__42855__auto__();
(statearr_43956[(6)] = c__42854__auto__);

return statearr_43956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));

return c__42854__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_46050 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_46050(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_46051 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_46051(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_46065 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_46065(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_46072 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_46072(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43985 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43985 = (function (ch,cs,meta43986){
this.ch = ch;
this.cs = cs;
this.meta43986 = meta43986;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43985.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43987,meta43986__$1){
var self__ = this;
var _43987__$1 = this;
return (new cljs.core.async.t_cljs$core$async43985(self__.ch,self__.cs,meta43986__$1));
}));

(cljs.core.async.t_cljs$core$async43985.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43987){
var self__ = this;
var _43987__$1 = this;
return self__.meta43986;
}));

(cljs.core.async.t_cljs$core$async43985.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43985.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async43985.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43985.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async43985.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async43985.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async43985.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta43986","meta43986",-282120805,null)], null);
}));

(cljs.core.async.t_cljs$core$async43985.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43985.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43985");

(cljs.core.async.t_cljs$core$async43985.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async43985");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43985.
 */
cljs.core.async.__GT_t_cljs$core$async43985 = (function cljs$core$async$mult_$___GT_t_cljs$core$async43985(ch__$1,cs__$1,meta43986){
return (new cljs.core.async.t_cljs$core$async43985(ch__$1,cs__$1,meta43986));
});

}

return (new cljs.core.async.t_cljs$core$async43985(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__42854__auto___46079 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_44150){
var state_val_44151 = (state_44150[(1)]);
if((state_val_44151 === (7))){
var inst_44146 = (state_44150[(2)]);
var state_44150__$1 = state_44150;
var statearr_44165_46084 = state_44150__$1;
(statearr_44165_46084[(2)] = inst_44146);

(statearr_44165_46084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (20))){
var inst_44039 = (state_44150[(7)]);
var inst_44051 = cljs.core.first(inst_44039);
var inst_44052 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44051,(0),null);
var inst_44053 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44051,(1),null);
var state_44150__$1 = (function (){var statearr_44166 = state_44150;
(statearr_44166[(8)] = inst_44052);

return statearr_44166;
})();
if(cljs.core.truth_(inst_44053)){
var statearr_44167_46085 = state_44150__$1;
(statearr_44167_46085[(1)] = (22));

} else {
var statearr_44168_46086 = state_44150__$1;
(statearr_44168_46086[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (27))){
var inst_44092 = (state_44150[(9)]);
var inst_44000 = (state_44150[(10)]);
var inst_44084 = (state_44150[(11)]);
var inst_44086 = (state_44150[(12)]);
var inst_44092__$1 = cljs.core._nth(inst_44084,inst_44086);
var inst_44093 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_44092__$1,inst_44000,done);
var state_44150__$1 = (function (){var statearr_44169 = state_44150;
(statearr_44169[(9)] = inst_44092__$1);

return statearr_44169;
})();
if(cljs.core.truth_(inst_44093)){
var statearr_44170_46087 = state_44150__$1;
(statearr_44170_46087[(1)] = (30));

} else {
var statearr_44171_46088 = state_44150__$1;
(statearr_44171_46088[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (1))){
var state_44150__$1 = state_44150;
var statearr_44172_46089 = state_44150__$1;
(statearr_44172_46089[(2)] = null);

(statearr_44172_46089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (24))){
var inst_44039 = (state_44150[(7)]);
var inst_44058 = (state_44150[(2)]);
var inst_44059 = cljs.core.next(inst_44039);
var inst_44009 = inst_44059;
var inst_44010 = null;
var inst_44011 = (0);
var inst_44012 = (0);
var state_44150__$1 = (function (){var statearr_44175 = state_44150;
(statearr_44175[(13)] = inst_44009);

(statearr_44175[(14)] = inst_44010);

(statearr_44175[(15)] = inst_44012);

(statearr_44175[(16)] = inst_44058);

(statearr_44175[(17)] = inst_44011);

return statearr_44175;
})();
var statearr_44176_46093 = state_44150__$1;
(statearr_44176_46093[(2)] = null);

(statearr_44176_46093[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (39))){
var state_44150__$1 = state_44150;
var statearr_44183_46094 = state_44150__$1;
(statearr_44183_46094[(2)] = null);

(statearr_44183_46094[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (4))){
var inst_44000 = (state_44150[(10)]);
var inst_44000__$1 = (state_44150[(2)]);
var inst_44001 = (inst_44000__$1 == null);
var state_44150__$1 = (function (){var statearr_44189 = state_44150;
(statearr_44189[(10)] = inst_44000__$1);

return statearr_44189;
})();
if(cljs.core.truth_(inst_44001)){
var statearr_44190_46095 = state_44150__$1;
(statearr_44190_46095[(1)] = (5));

} else {
var statearr_44192_46096 = state_44150__$1;
(statearr_44192_46096[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (15))){
var inst_44009 = (state_44150[(13)]);
var inst_44010 = (state_44150[(14)]);
var inst_44012 = (state_44150[(15)]);
var inst_44011 = (state_44150[(17)]);
var inst_44031 = (state_44150[(2)]);
var inst_44036 = (inst_44012 + (1));
var tmp44179 = inst_44009;
var tmp44180 = inst_44010;
var tmp44181 = inst_44011;
var inst_44009__$1 = tmp44179;
var inst_44010__$1 = tmp44180;
var inst_44011__$1 = tmp44181;
var inst_44012__$1 = inst_44036;
var state_44150__$1 = (function (){var statearr_44193 = state_44150;
(statearr_44193[(13)] = inst_44009__$1);

(statearr_44193[(14)] = inst_44010__$1);

(statearr_44193[(18)] = inst_44031);

(statearr_44193[(15)] = inst_44012__$1);

(statearr_44193[(17)] = inst_44011__$1);

return statearr_44193;
})();
var statearr_44194_46098 = state_44150__$1;
(statearr_44194_46098[(2)] = null);

(statearr_44194_46098[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (21))){
var inst_44062 = (state_44150[(2)]);
var state_44150__$1 = state_44150;
var statearr_44198_46103 = state_44150__$1;
(statearr_44198_46103[(2)] = inst_44062);

(statearr_44198_46103[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (31))){
var inst_44092 = (state_44150[(9)]);
var inst_44096 = done(null);
var inst_44097 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_44092);
var state_44150__$1 = (function (){var statearr_44199 = state_44150;
(statearr_44199[(19)] = inst_44096);

return statearr_44199;
})();
var statearr_44200_46106 = state_44150__$1;
(statearr_44200_46106[(2)] = inst_44097);

(statearr_44200_46106[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (32))){
var inst_44083 = (state_44150[(20)]);
var inst_44084 = (state_44150[(11)]);
var inst_44086 = (state_44150[(12)]);
var inst_44085 = (state_44150[(21)]);
var inst_44099 = (state_44150[(2)]);
var inst_44100 = (inst_44086 + (1));
var tmp44195 = inst_44083;
var tmp44196 = inst_44084;
var tmp44197 = inst_44085;
var inst_44083__$1 = tmp44195;
var inst_44084__$1 = tmp44196;
var inst_44085__$1 = tmp44197;
var inst_44086__$1 = inst_44100;
var state_44150__$1 = (function (){var statearr_44207 = state_44150;
(statearr_44207[(20)] = inst_44083__$1);

(statearr_44207[(11)] = inst_44084__$1);

(statearr_44207[(12)] = inst_44086__$1);

(statearr_44207[(21)] = inst_44085__$1);

(statearr_44207[(22)] = inst_44099);

return statearr_44207;
})();
var statearr_44208_46111 = state_44150__$1;
(statearr_44208_46111[(2)] = null);

(statearr_44208_46111[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (40))){
var inst_44114 = (state_44150[(23)]);
var inst_44121 = done(null);
var inst_44122 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_44114);
var state_44150__$1 = (function (){var statearr_44210 = state_44150;
(statearr_44210[(24)] = inst_44121);

return statearr_44210;
})();
var statearr_44212_46112 = state_44150__$1;
(statearr_44212_46112[(2)] = inst_44122);

(statearr_44212_46112[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (33))){
var inst_44103 = (state_44150[(25)]);
var inst_44105 = cljs.core.chunked_seq_QMARK_(inst_44103);
var state_44150__$1 = state_44150;
if(inst_44105){
var statearr_44215_46113 = state_44150__$1;
(statearr_44215_46113[(1)] = (36));

} else {
var statearr_44216_46114 = state_44150__$1;
(statearr_44216_46114[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (13))){
var inst_44024 = (state_44150[(26)]);
var inst_44028 = cljs.core.async.close_BANG_(inst_44024);
var state_44150__$1 = state_44150;
var statearr_44217_46119 = state_44150__$1;
(statearr_44217_46119[(2)] = inst_44028);

(statearr_44217_46119[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (22))){
var inst_44052 = (state_44150[(8)]);
var inst_44055 = cljs.core.async.close_BANG_(inst_44052);
var state_44150__$1 = state_44150;
var statearr_44221_46125 = state_44150__$1;
(statearr_44221_46125[(2)] = inst_44055);

(statearr_44221_46125[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (36))){
var inst_44103 = (state_44150[(25)]);
var inst_44108 = cljs.core.chunk_first(inst_44103);
var inst_44109 = cljs.core.chunk_rest(inst_44103);
var inst_44110 = cljs.core.count(inst_44108);
var inst_44083 = inst_44109;
var inst_44084 = inst_44108;
var inst_44085 = inst_44110;
var inst_44086 = (0);
var state_44150__$1 = (function (){var statearr_44222 = state_44150;
(statearr_44222[(20)] = inst_44083);

(statearr_44222[(11)] = inst_44084);

(statearr_44222[(12)] = inst_44086);

(statearr_44222[(21)] = inst_44085);

return statearr_44222;
})();
var statearr_44224_46126 = state_44150__$1;
(statearr_44224_46126[(2)] = null);

(statearr_44224_46126[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (41))){
var inst_44103 = (state_44150[(25)]);
var inst_44124 = (state_44150[(2)]);
var inst_44126 = cljs.core.next(inst_44103);
var inst_44083 = inst_44126;
var inst_44084 = null;
var inst_44085 = (0);
var inst_44086 = (0);
var state_44150__$1 = (function (){var statearr_44227 = state_44150;
(statearr_44227[(20)] = inst_44083);

(statearr_44227[(11)] = inst_44084);

(statearr_44227[(12)] = inst_44086);

(statearr_44227[(21)] = inst_44085);

(statearr_44227[(27)] = inst_44124);

return statearr_44227;
})();
var statearr_44229_46133 = state_44150__$1;
(statearr_44229_46133[(2)] = null);

(statearr_44229_46133[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (43))){
var state_44150__$1 = state_44150;
var statearr_44234_46134 = state_44150__$1;
(statearr_44234_46134[(2)] = null);

(statearr_44234_46134[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (29))){
var inst_44134 = (state_44150[(2)]);
var state_44150__$1 = state_44150;
var statearr_44237_46135 = state_44150__$1;
(statearr_44237_46135[(2)] = inst_44134);

(statearr_44237_46135[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (44))){
var inst_44143 = (state_44150[(2)]);
var state_44150__$1 = (function (){var statearr_44239 = state_44150;
(statearr_44239[(28)] = inst_44143);

return statearr_44239;
})();
var statearr_44241_46139 = state_44150__$1;
(statearr_44241_46139[(2)] = null);

(statearr_44241_46139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (6))){
var inst_44075 = (state_44150[(29)]);
var inst_44074 = cljs.core.deref(cs);
var inst_44075__$1 = cljs.core.keys(inst_44074);
var inst_44076 = cljs.core.count(inst_44075__$1);
var inst_44077 = cljs.core.reset_BANG_(dctr,inst_44076);
var inst_44082 = cljs.core.seq(inst_44075__$1);
var inst_44083 = inst_44082;
var inst_44084 = null;
var inst_44085 = (0);
var inst_44086 = (0);
var state_44150__$1 = (function (){var statearr_44248 = state_44150;
(statearr_44248[(20)] = inst_44083);

(statearr_44248[(29)] = inst_44075__$1);

(statearr_44248[(11)] = inst_44084);

(statearr_44248[(12)] = inst_44086);

(statearr_44248[(21)] = inst_44085);

(statearr_44248[(30)] = inst_44077);

return statearr_44248;
})();
var statearr_44250_46144 = state_44150__$1;
(statearr_44250_46144[(2)] = null);

(statearr_44250_46144[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (28))){
var inst_44103 = (state_44150[(25)]);
var inst_44083 = (state_44150[(20)]);
var inst_44103__$1 = cljs.core.seq(inst_44083);
var state_44150__$1 = (function (){var statearr_44251 = state_44150;
(statearr_44251[(25)] = inst_44103__$1);

return statearr_44251;
})();
if(inst_44103__$1){
var statearr_44252_46145 = state_44150__$1;
(statearr_44252_46145[(1)] = (33));

} else {
var statearr_44253_46146 = state_44150__$1;
(statearr_44253_46146[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (25))){
var inst_44086 = (state_44150[(12)]);
var inst_44085 = (state_44150[(21)]);
var inst_44088 = (inst_44086 < inst_44085);
var inst_44089 = inst_44088;
var state_44150__$1 = state_44150;
if(cljs.core.truth_(inst_44089)){
var statearr_44254_46148 = state_44150__$1;
(statearr_44254_46148[(1)] = (27));

} else {
var statearr_44256_46149 = state_44150__$1;
(statearr_44256_46149[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (34))){
var state_44150__$1 = state_44150;
var statearr_44258_46150 = state_44150__$1;
(statearr_44258_46150[(2)] = null);

(statearr_44258_46150[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (17))){
var state_44150__$1 = state_44150;
var statearr_44260_46152 = state_44150__$1;
(statearr_44260_46152[(2)] = null);

(statearr_44260_46152[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (3))){
var inst_44148 = (state_44150[(2)]);
var state_44150__$1 = state_44150;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44150__$1,inst_44148);
} else {
if((state_val_44151 === (12))){
var inst_44067 = (state_44150[(2)]);
var state_44150__$1 = state_44150;
var statearr_44263_46154 = state_44150__$1;
(statearr_44263_46154[(2)] = inst_44067);

(statearr_44263_46154[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (2))){
var state_44150__$1 = state_44150;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44150__$1,(4),ch);
} else {
if((state_val_44151 === (23))){
var state_44150__$1 = state_44150;
var statearr_44264_46159 = state_44150__$1;
(statearr_44264_46159[(2)] = null);

(statearr_44264_46159[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (35))){
var inst_44132 = (state_44150[(2)]);
var state_44150__$1 = state_44150;
var statearr_44265_46160 = state_44150__$1;
(statearr_44265_46160[(2)] = inst_44132);

(statearr_44265_46160[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (19))){
var inst_44039 = (state_44150[(7)]);
var inst_44043 = cljs.core.chunk_first(inst_44039);
var inst_44044 = cljs.core.chunk_rest(inst_44039);
var inst_44045 = cljs.core.count(inst_44043);
var inst_44009 = inst_44044;
var inst_44010 = inst_44043;
var inst_44011 = inst_44045;
var inst_44012 = (0);
var state_44150__$1 = (function (){var statearr_44266 = state_44150;
(statearr_44266[(13)] = inst_44009);

(statearr_44266[(14)] = inst_44010);

(statearr_44266[(15)] = inst_44012);

(statearr_44266[(17)] = inst_44011);

return statearr_44266;
})();
var statearr_44271_46168 = state_44150__$1;
(statearr_44271_46168[(2)] = null);

(statearr_44271_46168[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (11))){
var inst_44009 = (state_44150[(13)]);
var inst_44039 = (state_44150[(7)]);
var inst_44039__$1 = cljs.core.seq(inst_44009);
var state_44150__$1 = (function (){var statearr_44273 = state_44150;
(statearr_44273[(7)] = inst_44039__$1);

return statearr_44273;
})();
if(inst_44039__$1){
var statearr_44275_46170 = state_44150__$1;
(statearr_44275_46170[(1)] = (16));

} else {
var statearr_44277_46172 = state_44150__$1;
(statearr_44277_46172[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (9))){
var inst_44070 = (state_44150[(2)]);
var state_44150__$1 = state_44150;
var statearr_44280_46173 = state_44150__$1;
(statearr_44280_46173[(2)] = inst_44070);

(statearr_44280_46173[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (5))){
var inst_44007 = cljs.core.deref(cs);
var inst_44008 = cljs.core.seq(inst_44007);
var inst_44009 = inst_44008;
var inst_44010 = null;
var inst_44011 = (0);
var inst_44012 = (0);
var state_44150__$1 = (function (){var statearr_44284 = state_44150;
(statearr_44284[(13)] = inst_44009);

(statearr_44284[(14)] = inst_44010);

(statearr_44284[(15)] = inst_44012);

(statearr_44284[(17)] = inst_44011);

return statearr_44284;
})();
var statearr_44285_46178 = state_44150__$1;
(statearr_44285_46178[(2)] = null);

(statearr_44285_46178[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (14))){
var state_44150__$1 = state_44150;
var statearr_44286_46179 = state_44150__$1;
(statearr_44286_46179[(2)] = null);

(statearr_44286_46179[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (45))){
var inst_44140 = (state_44150[(2)]);
var state_44150__$1 = state_44150;
var statearr_44287_46180 = state_44150__$1;
(statearr_44287_46180[(2)] = inst_44140);

(statearr_44287_46180[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (26))){
var inst_44075 = (state_44150[(29)]);
var inst_44136 = (state_44150[(2)]);
var inst_44137 = cljs.core.seq(inst_44075);
var state_44150__$1 = (function (){var statearr_44288 = state_44150;
(statearr_44288[(31)] = inst_44136);

return statearr_44288;
})();
if(inst_44137){
var statearr_44289_46185 = state_44150__$1;
(statearr_44289_46185[(1)] = (42));

} else {
var statearr_44290_46186 = state_44150__$1;
(statearr_44290_46186[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (16))){
var inst_44039 = (state_44150[(7)]);
var inst_44041 = cljs.core.chunked_seq_QMARK_(inst_44039);
var state_44150__$1 = state_44150;
if(inst_44041){
var statearr_44292_46187 = state_44150__$1;
(statearr_44292_46187[(1)] = (19));

} else {
var statearr_44293_46188 = state_44150__$1;
(statearr_44293_46188[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (38))){
var inst_44129 = (state_44150[(2)]);
var state_44150__$1 = state_44150;
var statearr_44294_46189 = state_44150__$1;
(statearr_44294_46189[(2)] = inst_44129);

(statearr_44294_46189[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (30))){
var state_44150__$1 = state_44150;
var statearr_44295_46190 = state_44150__$1;
(statearr_44295_46190[(2)] = null);

(statearr_44295_46190[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (10))){
var inst_44010 = (state_44150[(14)]);
var inst_44012 = (state_44150[(15)]);
var inst_44023 = cljs.core._nth(inst_44010,inst_44012);
var inst_44024 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44023,(0),null);
var inst_44025 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44023,(1),null);
var state_44150__$1 = (function (){var statearr_44297 = state_44150;
(statearr_44297[(26)] = inst_44024);

return statearr_44297;
})();
if(cljs.core.truth_(inst_44025)){
var statearr_44299_46191 = state_44150__$1;
(statearr_44299_46191[(1)] = (13));

} else {
var statearr_44300_46192 = state_44150__$1;
(statearr_44300_46192[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (18))){
var inst_44065 = (state_44150[(2)]);
var state_44150__$1 = state_44150;
var statearr_44302_46197 = state_44150__$1;
(statearr_44302_46197[(2)] = inst_44065);

(statearr_44302_46197[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (42))){
var state_44150__$1 = state_44150;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44150__$1,(45),dchan);
} else {
if((state_val_44151 === (37))){
var inst_44103 = (state_44150[(25)]);
var inst_44000 = (state_44150[(10)]);
var inst_44114 = (state_44150[(23)]);
var inst_44114__$1 = cljs.core.first(inst_44103);
var inst_44118 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_44114__$1,inst_44000,done);
var state_44150__$1 = (function (){var statearr_44306 = state_44150;
(statearr_44306[(23)] = inst_44114__$1);

return statearr_44306;
})();
if(cljs.core.truth_(inst_44118)){
var statearr_44307_46199 = state_44150__$1;
(statearr_44307_46199[(1)] = (39));

} else {
var statearr_44308_46200 = state_44150__$1;
(statearr_44308_46200[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44151 === (8))){
var inst_44012 = (state_44150[(15)]);
var inst_44011 = (state_44150[(17)]);
var inst_44016 = (inst_44012 < inst_44011);
var inst_44017 = inst_44016;
var state_44150__$1 = state_44150;
if(cljs.core.truth_(inst_44017)){
var statearr_44309_46201 = state_44150__$1;
(statearr_44309_46201[(1)] = (10));

} else {
var statearr_44310_46202 = state_44150__$1;
(statearr_44310_46202[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__42649__auto__ = null;
var cljs$core$async$mult_$_state_machine__42649__auto____0 = (function (){
var statearr_44312 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44312[(0)] = cljs$core$async$mult_$_state_machine__42649__auto__);

(statearr_44312[(1)] = (1));

return statearr_44312;
});
var cljs$core$async$mult_$_state_machine__42649__auto____1 = (function (state_44150){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_44150);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e44319){if((e44319 instanceof Object)){
var ex__42652__auto__ = e44319;
var statearr_44321_46208 = state_44150;
(statearr_44321_46208[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44150);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44319;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46209 = state_44150;
state_44150 = G__46209;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__42649__auto__ = function(state_44150){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__42649__auto____1.call(this,state_44150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__42649__auto____0;
cljs$core$async$mult_$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__42649__auto____1;
return cljs$core$async$mult_$_state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_44329 = f__42855__auto__();
(statearr_44329[(6)] = c__42854__auto___46079);

return statearr_44329;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__44331 = arguments.length;
switch (G__44331) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_46211 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_46211(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_46212 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_46212(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_46213 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_46213(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_46219 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_46219(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_46221 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_46221(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___46222 = arguments.length;
var i__4737__auto___46223 = (0);
while(true){
if((i__4737__auto___46223 < len__4736__auto___46222)){
args__4742__auto__.push((arguments[i__4737__auto___46223]));

var G__46224 = (i__4737__auto___46223 + (1));
i__4737__auto___46223 = G__46224;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__44376){
var map__44377 = p__44376;
var map__44377__$1 = (((((!((map__44377 == null))))?(((((map__44377.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44377.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44377):map__44377);
var opts = map__44377__$1;
var statearr_44381_46229 = state;
(statearr_44381_46229[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts((function (val){
var statearr_44383_46231 = state;
(statearr_44383_46231[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_44384_46234 = state;
(statearr_44384_46234[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq44371){
var G__44372 = cljs.core.first(seq44371);
var seq44371__$1 = cljs.core.next(seq44371);
var G__44373 = cljs.core.first(seq44371__$1);
var seq44371__$2 = cljs.core.next(seq44371__$1);
var G__44374 = cljs.core.first(seq44371__$2);
var seq44371__$3 = cljs.core.next(seq44371__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44372,G__44373,G__44374,seq44371__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44406 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44406 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta44407){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta44407 = meta44407;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44406.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44408,meta44407__$1){
var self__ = this;
var _44408__$1 = this;
return (new cljs.core.async.t_cljs$core$async44406(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta44407__$1));
}));

(cljs.core.async.t_cljs$core$async44406.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44408){
var self__ = this;
var _44408__$1 = this;
return self__.meta44407;
}));

(cljs.core.async.t_cljs$core$async44406.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44406.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async44406.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44406.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async44406.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async44406.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async44406.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async44406.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async44406.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta44407","meta44407",1394751909,null)], null);
}));

(cljs.core.async.t_cljs$core$async44406.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44406.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44406");

(cljs.core.async.t_cljs$core$async44406.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44406");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44406.
 */
cljs.core.async.__GT_t_cljs$core$async44406 = (function cljs$core$async$mix_$___GT_t_cljs$core$async44406(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta44407){
return (new cljs.core.async.t_cljs$core$async44406(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta44407));
});

}

return (new cljs.core.async.t_cljs$core$async44406(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42854__auto___46253 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_44532){
var state_val_44533 = (state_44532[(1)]);
if((state_val_44533 === (7))){
var inst_44439 = (state_44532[(2)]);
var state_44532__$1 = state_44532;
var statearr_44541_46254 = state_44532__$1;
(statearr_44541_46254[(2)] = inst_44439);

(statearr_44541_46254[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (20))){
var inst_44456 = (state_44532[(7)]);
var state_44532__$1 = state_44532;
var statearr_44546_46255 = state_44532__$1;
(statearr_44546_46255[(2)] = inst_44456);

(statearr_44546_46255[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (27))){
var state_44532__$1 = state_44532;
var statearr_44548_46256 = state_44532__$1;
(statearr_44548_46256[(2)] = null);

(statearr_44548_46256[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (1))){
var inst_44426 = (state_44532[(8)]);
var inst_44426__$1 = calc_state();
var inst_44428 = (inst_44426__$1 == null);
var inst_44429 = cljs.core.not(inst_44428);
var state_44532__$1 = (function (){var statearr_44549 = state_44532;
(statearr_44549[(8)] = inst_44426__$1);

return statearr_44549;
})();
if(inst_44429){
var statearr_44550_46257 = state_44532__$1;
(statearr_44550_46257[(1)] = (2));

} else {
var statearr_44551_46258 = state_44532__$1;
(statearr_44551_46258[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (24))){
var inst_44489 = (state_44532[(9)]);
var inst_44503 = (state_44532[(10)]);
var inst_44480 = (state_44532[(11)]);
var inst_44503__$1 = (inst_44480.cljs$core$IFn$_invoke$arity$1 ? inst_44480.cljs$core$IFn$_invoke$arity$1(inst_44489) : inst_44480.call(null,inst_44489));
var state_44532__$1 = (function (){var statearr_44552 = state_44532;
(statearr_44552[(10)] = inst_44503__$1);

return statearr_44552;
})();
if(cljs.core.truth_(inst_44503__$1)){
var statearr_44553_46262 = state_44532__$1;
(statearr_44553_46262[(1)] = (29));

} else {
var statearr_44554_46263 = state_44532__$1;
(statearr_44554_46263[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (4))){
var inst_44442 = (state_44532[(2)]);
var state_44532__$1 = state_44532;
if(cljs.core.truth_(inst_44442)){
var statearr_44556_46264 = state_44532__$1;
(statearr_44556_46264[(1)] = (8));

} else {
var statearr_44557_46265 = state_44532__$1;
(statearr_44557_46265[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (15))){
var inst_44474 = (state_44532[(2)]);
var state_44532__$1 = state_44532;
if(cljs.core.truth_(inst_44474)){
var statearr_44562_46266 = state_44532__$1;
(statearr_44562_46266[(1)] = (19));

} else {
var statearr_44563_46267 = state_44532__$1;
(statearr_44563_46267[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (21))){
var inst_44479 = (state_44532[(12)]);
var inst_44479__$1 = (state_44532[(2)]);
var inst_44480 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44479__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_44481 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44479__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_44482 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44479__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_44532__$1 = (function (){var statearr_44565 = state_44532;
(statearr_44565[(13)] = inst_44481);

(statearr_44565[(12)] = inst_44479__$1);

(statearr_44565[(11)] = inst_44480);

return statearr_44565;
})();
return cljs.core.async.ioc_alts_BANG_(state_44532__$1,(22),inst_44482);
} else {
if((state_val_44533 === (31))){
var inst_44511 = (state_44532[(2)]);
var state_44532__$1 = state_44532;
if(cljs.core.truth_(inst_44511)){
var statearr_44571_46268 = state_44532__$1;
(statearr_44571_46268[(1)] = (32));

} else {
var statearr_44572_46269 = state_44532__$1;
(statearr_44572_46269[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (32))){
var inst_44488 = (state_44532[(14)]);
var state_44532__$1 = state_44532;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44532__$1,(35),out,inst_44488);
} else {
if((state_val_44533 === (33))){
var inst_44479 = (state_44532[(12)]);
var inst_44456 = inst_44479;
var state_44532__$1 = (function (){var statearr_44573 = state_44532;
(statearr_44573[(7)] = inst_44456);

return statearr_44573;
})();
var statearr_44574_46270 = state_44532__$1;
(statearr_44574_46270[(2)] = null);

(statearr_44574_46270[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (13))){
var inst_44456 = (state_44532[(7)]);
var inst_44463 = inst_44456.cljs$lang$protocol_mask$partition0$;
var inst_44464 = (inst_44463 & (64));
var inst_44465 = inst_44456.cljs$core$ISeq$;
var inst_44466 = (cljs.core.PROTOCOL_SENTINEL === inst_44465);
var inst_44467 = ((inst_44464) || (inst_44466));
var state_44532__$1 = state_44532;
if(cljs.core.truth_(inst_44467)){
var statearr_44575_46272 = state_44532__$1;
(statearr_44575_46272[(1)] = (16));

} else {
var statearr_44576_46273 = state_44532__$1;
(statearr_44576_46273[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (22))){
var inst_44489 = (state_44532[(9)]);
var inst_44488 = (state_44532[(14)]);
var inst_44487 = (state_44532[(2)]);
var inst_44488__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44487,(0),null);
var inst_44489__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44487,(1),null);
var inst_44490 = (inst_44488__$1 == null);
var inst_44491 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_44489__$1,change);
var inst_44492 = ((inst_44490) || (inst_44491));
var state_44532__$1 = (function (){var statearr_44581 = state_44532;
(statearr_44581[(9)] = inst_44489__$1);

(statearr_44581[(14)] = inst_44488__$1);

return statearr_44581;
})();
if(cljs.core.truth_(inst_44492)){
var statearr_44582_46274 = state_44532__$1;
(statearr_44582_46274[(1)] = (23));

} else {
var statearr_44583_46275 = state_44532__$1;
(statearr_44583_46275[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (36))){
var inst_44479 = (state_44532[(12)]);
var inst_44456 = inst_44479;
var state_44532__$1 = (function (){var statearr_44588 = state_44532;
(statearr_44588[(7)] = inst_44456);

return statearr_44588;
})();
var statearr_44589_46276 = state_44532__$1;
(statearr_44589_46276[(2)] = null);

(statearr_44589_46276[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (29))){
var inst_44503 = (state_44532[(10)]);
var state_44532__$1 = state_44532;
var statearr_44590_46277 = state_44532__$1;
(statearr_44590_46277[(2)] = inst_44503);

(statearr_44590_46277[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (6))){
var state_44532__$1 = state_44532;
var statearr_44591_46278 = state_44532__$1;
(statearr_44591_46278[(2)] = false);

(statearr_44591_46278[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (28))){
var inst_44499 = (state_44532[(2)]);
var inst_44500 = calc_state();
var inst_44456 = inst_44500;
var state_44532__$1 = (function (){var statearr_44592 = state_44532;
(statearr_44592[(7)] = inst_44456);

(statearr_44592[(15)] = inst_44499);

return statearr_44592;
})();
var statearr_44593_46279 = state_44532__$1;
(statearr_44593_46279[(2)] = null);

(statearr_44593_46279[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (25))){
var inst_44526 = (state_44532[(2)]);
var state_44532__$1 = state_44532;
var statearr_44598_46281 = state_44532__$1;
(statearr_44598_46281[(2)] = inst_44526);

(statearr_44598_46281[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (34))){
var inst_44524 = (state_44532[(2)]);
var state_44532__$1 = state_44532;
var statearr_44601_46282 = state_44532__$1;
(statearr_44601_46282[(2)] = inst_44524);

(statearr_44601_46282[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (17))){
var state_44532__$1 = state_44532;
var statearr_44605_46283 = state_44532__$1;
(statearr_44605_46283[(2)] = false);

(statearr_44605_46283[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (3))){
var state_44532__$1 = state_44532;
var statearr_44606_46284 = state_44532__$1;
(statearr_44606_46284[(2)] = false);

(statearr_44606_46284[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (12))){
var inst_44528 = (state_44532[(2)]);
var state_44532__$1 = state_44532;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44532__$1,inst_44528);
} else {
if((state_val_44533 === (2))){
var inst_44426 = (state_44532[(8)]);
var inst_44431 = inst_44426.cljs$lang$protocol_mask$partition0$;
var inst_44432 = (inst_44431 & (64));
var inst_44433 = inst_44426.cljs$core$ISeq$;
var inst_44434 = (cljs.core.PROTOCOL_SENTINEL === inst_44433);
var inst_44435 = ((inst_44432) || (inst_44434));
var state_44532__$1 = state_44532;
if(cljs.core.truth_(inst_44435)){
var statearr_44611_46285 = state_44532__$1;
(statearr_44611_46285[(1)] = (5));

} else {
var statearr_44612_46286 = state_44532__$1;
(statearr_44612_46286[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (23))){
var inst_44488 = (state_44532[(14)]);
var inst_44494 = (inst_44488 == null);
var state_44532__$1 = state_44532;
if(cljs.core.truth_(inst_44494)){
var statearr_44613_46291 = state_44532__$1;
(statearr_44613_46291[(1)] = (26));

} else {
var statearr_44614_46292 = state_44532__$1;
(statearr_44614_46292[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (35))){
var inst_44515 = (state_44532[(2)]);
var state_44532__$1 = state_44532;
if(cljs.core.truth_(inst_44515)){
var statearr_44615_46293 = state_44532__$1;
(statearr_44615_46293[(1)] = (36));

} else {
var statearr_44616_46294 = state_44532__$1;
(statearr_44616_46294[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (19))){
var inst_44456 = (state_44532[(7)]);
var inst_44476 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_44456);
var state_44532__$1 = state_44532;
var statearr_44618_46299 = state_44532__$1;
(statearr_44618_46299[(2)] = inst_44476);

(statearr_44618_46299[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (11))){
var inst_44456 = (state_44532[(7)]);
var inst_44460 = (inst_44456 == null);
var inst_44461 = cljs.core.not(inst_44460);
var state_44532__$1 = state_44532;
if(inst_44461){
var statearr_44620_46300 = state_44532__$1;
(statearr_44620_46300[(1)] = (13));

} else {
var statearr_44622_46302 = state_44532__$1;
(statearr_44622_46302[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (9))){
var inst_44426 = (state_44532[(8)]);
var state_44532__$1 = state_44532;
var statearr_44623_46304 = state_44532__$1;
(statearr_44623_46304[(2)] = inst_44426);

(statearr_44623_46304[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (5))){
var state_44532__$1 = state_44532;
var statearr_44627_46305 = state_44532__$1;
(statearr_44627_46305[(2)] = true);

(statearr_44627_46305[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (14))){
var state_44532__$1 = state_44532;
var statearr_44628_46306 = state_44532__$1;
(statearr_44628_46306[(2)] = false);

(statearr_44628_46306[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (26))){
var inst_44489 = (state_44532[(9)]);
var inst_44496 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_44489);
var state_44532__$1 = state_44532;
var statearr_44629_46307 = state_44532__$1;
(statearr_44629_46307[(2)] = inst_44496);

(statearr_44629_46307[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (16))){
var state_44532__$1 = state_44532;
var statearr_44633_46308 = state_44532__$1;
(statearr_44633_46308[(2)] = true);

(statearr_44633_46308[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (38))){
var inst_44520 = (state_44532[(2)]);
var state_44532__$1 = state_44532;
var statearr_44635_46309 = state_44532__$1;
(statearr_44635_46309[(2)] = inst_44520);

(statearr_44635_46309[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (30))){
var inst_44481 = (state_44532[(13)]);
var inst_44489 = (state_44532[(9)]);
var inst_44480 = (state_44532[(11)]);
var inst_44506 = cljs.core.empty_QMARK_(inst_44480);
var inst_44507 = (inst_44481.cljs$core$IFn$_invoke$arity$1 ? inst_44481.cljs$core$IFn$_invoke$arity$1(inst_44489) : inst_44481.call(null,inst_44489));
var inst_44508 = cljs.core.not(inst_44507);
var inst_44509 = ((inst_44506) && (inst_44508));
var state_44532__$1 = state_44532;
var statearr_44636_46310 = state_44532__$1;
(statearr_44636_46310[(2)] = inst_44509);

(statearr_44636_46310[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (10))){
var inst_44426 = (state_44532[(8)]);
var inst_44448 = (state_44532[(2)]);
var inst_44453 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44448,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_44454 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44448,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_44455 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44448,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_44456 = inst_44426;
var state_44532__$1 = (function (){var statearr_44639 = state_44532;
(statearr_44639[(16)] = inst_44453);

(statearr_44639[(7)] = inst_44456);

(statearr_44639[(17)] = inst_44455);

(statearr_44639[(18)] = inst_44454);

return statearr_44639;
})();
var statearr_44640_46311 = state_44532__$1;
(statearr_44640_46311[(2)] = null);

(statearr_44640_46311[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (18))){
var inst_44471 = (state_44532[(2)]);
var state_44532__$1 = state_44532;
var statearr_44641_46312 = state_44532__$1;
(statearr_44641_46312[(2)] = inst_44471);

(statearr_44641_46312[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (37))){
var state_44532__$1 = state_44532;
var statearr_44642_46313 = state_44532__$1;
(statearr_44642_46313[(2)] = null);

(statearr_44642_46313[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44533 === (8))){
var inst_44426 = (state_44532[(8)]);
var inst_44444 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_44426);
var state_44532__$1 = state_44532;
var statearr_44646_46314 = state_44532__$1;
(statearr_44646_46314[(2)] = inst_44444);

(statearr_44646_46314[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__42649__auto__ = null;
var cljs$core$async$mix_$_state_machine__42649__auto____0 = (function (){
var statearr_44648 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44648[(0)] = cljs$core$async$mix_$_state_machine__42649__auto__);

(statearr_44648[(1)] = (1));

return statearr_44648;
});
var cljs$core$async$mix_$_state_machine__42649__auto____1 = (function (state_44532){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_44532);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e44649){if((e44649 instanceof Object)){
var ex__42652__auto__ = e44649;
var statearr_44650_46315 = state_44532;
(statearr_44650_46315[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44532);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44649;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46316 = state_44532;
state_44532 = G__46316;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__42649__auto__ = function(state_44532){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__42649__auto____1.call(this,state_44532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__42649__auto____0;
cljs$core$async$mix_$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__42649__auto____1;
return cljs$core$async$mix_$_state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_44652 = f__42855__auto__();
(statearr_44652[(6)] = c__42854__auto___46253);

return statearr_44652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_46318 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_46318(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_46319 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_46319(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_46335 = (function() {
var G__46336 = null;
var G__46336__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__46336__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__46336 = function(p,v){
switch(arguments.length){
case 1:
return G__46336__1.call(this,p);
case 2:
return G__46336__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46336.cljs$core$IFn$_invoke$arity$1 = G__46336__1;
G__46336.cljs$core$IFn$_invoke$arity$2 = G__46336__2;
return G__46336;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__44685 = arguments.length;
switch (G__44685) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_46335(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_46335(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__44696 = arguments.length;
switch (G__44696) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__44691_SHARP_){
if(cljs.core.truth_((p1__44691_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__44691_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__44691_SHARP_.call(null,topic)))){
return p1__44691_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__44691_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44700 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44700 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta44701){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta44701 = meta44701;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44700.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44702,meta44701__$1){
var self__ = this;
var _44702__$1 = this;
return (new cljs.core.async.t_cljs$core$async44700(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta44701__$1));
}));

(cljs.core.async.t_cljs$core$async44700.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44702){
var self__ = this;
var _44702__$1 = this;
return self__.meta44701;
}));

(cljs.core.async.t_cljs$core$async44700.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44700.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async44700.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44700.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async44700.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async44700.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async44700.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async44700.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta44701","meta44701",-486339723,null)], null);
}));

(cljs.core.async.t_cljs$core$async44700.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44700.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44700");

(cljs.core.async.t_cljs$core$async44700.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44700");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44700.
 */
cljs.core.async.__GT_t_cljs$core$async44700 = (function cljs$core$async$__GT_t_cljs$core$async44700(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta44701){
return (new cljs.core.async.t_cljs$core$async44700(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta44701));
});

}

return (new cljs.core.async.t_cljs$core$async44700(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42854__auto___46373 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_44785){
var state_val_44786 = (state_44785[(1)]);
if((state_val_44786 === (7))){
var inst_44781 = (state_44785[(2)]);
var state_44785__$1 = state_44785;
var statearr_44787_46376 = state_44785__$1;
(statearr_44787_46376[(2)] = inst_44781);

(statearr_44787_46376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (20))){
var state_44785__$1 = state_44785;
var statearr_44788_46377 = state_44785__$1;
(statearr_44788_46377[(2)] = null);

(statearr_44788_46377[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (1))){
var state_44785__$1 = state_44785;
var statearr_44791_46379 = state_44785__$1;
(statearr_44791_46379[(2)] = null);

(statearr_44791_46379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (24))){
var inst_44764 = (state_44785[(7)]);
var inst_44773 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_44764);
var state_44785__$1 = state_44785;
var statearr_44793_46380 = state_44785__$1;
(statearr_44793_46380[(2)] = inst_44773);

(statearr_44793_46380[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (4))){
var inst_44706 = (state_44785[(8)]);
var inst_44706__$1 = (state_44785[(2)]);
var inst_44707 = (inst_44706__$1 == null);
var state_44785__$1 = (function (){var statearr_44797 = state_44785;
(statearr_44797[(8)] = inst_44706__$1);

return statearr_44797;
})();
if(cljs.core.truth_(inst_44707)){
var statearr_44798_46381 = state_44785__$1;
(statearr_44798_46381[(1)] = (5));

} else {
var statearr_44799_46382 = state_44785__$1;
(statearr_44799_46382[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (15))){
var inst_44752 = (state_44785[(2)]);
var state_44785__$1 = state_44785;
var statearr_44802_46383 = state_44785__$1;
(statearr_44802_46383[(2)] = inst_44752);

(statearr_44802_46383[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (21))){
var inst_44778 = (state_44785[(2)]);
var state_44785__$1 = (function (){var statearr_44804 = state_44785;
(statearr_44804[(9)] = inst_44778);

return statearr_44804;
})();
var statearr_44805_46388 = state_44785__$1;
(statearr_44805_46388[(2)] = null);

(statearr_44805_46388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (13))){
var inst_44730 = (state_44785[(10)]);
var inst_44736 = cljs.core.chunked_seq_QMARK_(inst_44730);
var state_44785__$1 = state_44785;
if(inst_44736){
var statearr_44812_46400 = state_44785__$1;
(statearr_44812_46400[(1)] = (16));

} else {
var statearr_44813_46401 = state_44785__$1;
(statearr_44813_46401[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (22))){
var inst_44770 = (state_44785[(2)]);
var state_44785__$1 = state_44785;
if(cljs.core.truth_(inst_44770)){
var statearr_44817_46403 = state_44785__$1;
(statearr_44817_46403[(1)] = (23));

} else {
var statearr_44819_46404 = state_44785__$1;
(statearr_44819_46404[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (6))){
var inst_44706 = (state_44785[(8)]);
var inst_44764 = (state_44785[(7)]);
var inst_44766 = (state_44785[(11)]);
var inst_44764__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_44706) : topic_fn.call(null,inst_44706));
var inst_44765 = cljs.core.deref(mults);
var inst_44766__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44765,inst_44764__$1);
var state_44785__$1 = (function (){var statearr_44825 = state_44785;
(statearr_44825[(7)] = inst_44764__$1);

(statearr_44825[(11)] = inst_44766__$1);

return statearr_44825;
})();
if(cljs.core.truth_(inst_44766__$1)){
var statearr_44826_46405 = state_44785__$1;
(statearr_44826_46405[(1)] = (19));

} else {
var statearr_44827_46406 = state_44785__$1;
(statearr_44827_46406[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (25))){
var inst_44775 = (state_44785[(2)]);
var state_44785__$1 = state_44785;
var statearr_44830_46408 = state_44785__$1;
(statearr_44830_46408[(2)] = inst_44775);

(statearr_44830_46408[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (17))){
var inst_44730 = (state_44785[(10)]);
var inst_44743 = cljs.core.first(inst_44730);
var inst_44744 = cljs.core.async.muxch_STAR_(inst_44743);
var inst_44745 = cljs.core.async.close_BANG_(inst_44744);
var inst_44746 = cljs.core.next(inst_44730);
var inst_44716 = inst_44746;
var inst_44717 = null;
var inst_44718 = (0);
var inst_44719 = (0);
var state_44785__$1 = (function (){var statearr_44831 = state_44785;
(statearr_44831[(12)] = inst_44719);

(statearr_44831[(13)] = inst_44717);

(statearr_44831[(14)] = inst_44718);

(statearr_44831[(15)] = inst_44716);

(statearr_44831[(16)] = inst_44745);

return statearr_44831;
})();
var statearr_44832_46413 = state_44785__$1;
(statearr_44832_46413[(2)] = null);

(statearr_44832_46413[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (3))){
var inst_44783 = (state_44785[(2)]);
var state_44785__$1 = state_44785;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44785__$1,inst_44783);
} else {
if((state_val_44786 === (12))){
var inst_44754 = (state_44785[(2)]);
var state_44785__$1 = state_44785;
var statearr_44836_46422 = state_44785__$1;
(statearr_44836_46422[(2)] = inst_44754);

(statearr_44836_46422[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (2))){
var state_44785__$1 = state_44785;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44785__$1,(4),ch);
} else {
if((state_val_44786 === (23))){
var state_44785__$1 = state_44785;
var statearr_44839_46424 = state_44785__$1;
(statearr_44839_46424[(2)] = null);

(statearr_44839_46424[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (19))){
var inst_44706 = (state_44785[(8)]);
var inst_44766 = (state_44785[(11)]);
var inst_44768 = cljs.core.async.muxch_STAR_(inst_44766);
var state_44785__$1 = state_44785;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44785__$1,(22),inst_44768,inst_44706);
} else {
if((state_val_44786 === (11))){
var inst_44730 = (state_44785[(10)]);
var inst_44716 = (state_44785[(15)]);
var inst_44730__$1 = cljs.core.seq(inst_44716);
var state_44785__$1 = (function (){var statearr_44841 = state_44785;
(statearr_44841[(10)] = inst_44730__$1);

return statearr_44841;
})();
if(inst_44730__$1){
var statearr_44842_46431 = state_44785__$1;
(statearr_44842_46431[(1)] = (13));

} else {
var statearr_44843_46434 = state_44785__$1;
(statearr_44843_46434[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (9))){
var inst_44757 = (state_44785[(2)]);
var state_44785__$1 = state_44785;
var statearr_44845_46436 = state_44785__$1;
(statearr_44845_46436[(2)] = inst_44757);

(statearr_44845_46436[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (5))){
var inst_44713 = cljs.core.deref(mults);
var inst_44714 = cljs.core.vals(inst_44713);
var inst_44715 = cljs.core.seq(inst_44714);
var inst_44716 = inst_44715;
var inst_44717 = null;
var inst_44718 = (0);
var inst_44719 = (0);
var state_44785__$1 = (function (){var statearr_44851 = state_44785;
(statearr_44851[(12)] = inst_44719);

(statearr_44851[(13)] = inst_44717);

(statearr_44851[(14)] = inst_44718);

(statearr_44851[(15)] = inst_44716);

return statearr_44851;
})();
var statearr_44852_46440 = state_44785__$1;
(statearr_44852_46440[(2)] = null);

(statearr_44852_46440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (14))){
var state_44785__$1 = state_44785;
var statearr_44857_46447 = state_44785__$1;
(statearr_44857_46447[(2)] = null);

(statearr_44857_46447[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (16))){
var inst_44730 = (state_44785[(10)]);
var inst_44738 = cljs.core.chunk_first(inst_44730);
var inst_44739 = cljs.core.chunk_rest(inst_44730);
var inst_44740 = cljs.core.count(inst_44738);
var inst_44716 = inst_44739;
var inst_44717 = inst_44738;
var inst_44718 = inst_44740;
var inst_44719 = (0);
var state_44785__$1 = (function (){var statearr_44858 = state_44785;
(statearr_44858[(12)] = inst_44719);

(statearr_44858[(13)] = inst_44717);

(statearr_44858[(14)] = inst_44718);

(statearr_44858[(15)] = inst_44716);

return statearr_44858;
})();
var statearr_44861_46461 = state_44785__$1;
(statearr_44861_46461[(2)] = null);

(statearr_44861_46461[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (10))){
var inst_44719 = (state_44785[(12)]);
var inst_44717 = (state_44785[(13)]);
var inst_44718 = (state_44785[(14)]);
var inst_44716 = (state_44785[(15)]);
var inst_44724 = cljs.core._nth(inst_44717,inst_44719);
var inst_44725 = cljs.core.async.muxch_STAR_(inst_44724);
var inst_44726 = cljs.core.async.close_BANG_(inst_44725);
var inst_44727 = (inst_44719 + (1));
var tmp44853 = inst_44717;
var tmp44854 = inst_44718;
var tmp44855 = inst_44716;
var inst_44716__$1 = tmp44855;
var inst_44717__$1 = tmp44853;
var inst_44718__$1 = tmp44854;
var inst_44719__$1 = inst_44727;
var state_44785__$1 = (function (){var statearr_44862 = state_44785;
(statearr_44862[(12)] = inst_44719__$1);

(statearr_44862[(13)] = inst_44717__$1);

(statearr_44862[(17)] = inst_44726);

(statearr_44862[(14)] = inst_44718__$1);

(statearr_44862[(15)] = inst_44716__$1);

return statearr_44862;
})();
var statearr_44863_46468 = state_44785__$1;
(statearr_44863_46468[(2)] = null);

(statearr_44863_46468[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (18))){
var inst_44749 = (state_44785[(2)]);
var state_44785__$1 = state_44785;
var statearr_44867_46471 = state_44785__$1;
(statearr_44867_46471[(2)] = inst_44749);

(statearr_44867_46471[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44786 === (8))){
var inst_44719 = (state_44785[(12)]);
var inst_44718 = (state_44785[(14)]);
var inst_44721 = (inst_44719 < inst_44718);
var inst_44722 = inst_44721;
var state_44785__$1 = state_44785;
if(cljs.core.truth_(inst_44722)){
var statearr_44873_46472 = state_44785__$1;
(statearr_44873_46472[(1)] = (10));

} else {
var statearr_44875_46473 = state_44785__$1;
(statearr_44875_46473[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42649__auto__ = null;
var cljs$core$async$state_machine__42649__auto____0 = (function (){
var statearr_44879 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44879[(0)] = cljs$core$async$state_machine__42649__auto__);

(statearr_44879[(1)] = (1));

return statearr_44879;
});
var cljs$core$async$state_machine__42649__auto____1 = (function (state_44785){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_44785);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e44881){if((e44881 instanceof Object)){
var ex__42652__auto__ = e44881;
var statearr_44883_46486 = state_44785;
(statearr_44883_46486[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44785);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44881;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46487 = state_44785;
state_44785 = G__46487;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$state_machine__42649__auto__ = function(state_44785){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42649__auto____1.call(this,state_44785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42649__auto____0;
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42649__auto____1;
return cljs$core$async$state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_44888 = f__42855__auto__();
(statearr_44888[(6)] = c__42854__auto___46373);

return statearr_44888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__44890 = arguments.length;
switch (G__44890) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__44898 = arguments.length;
switch (G__44898) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__44911 = arguments.length;
switch (G__44911) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__42854__auto___46507 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_44955){
var state_val_44957 = (state_44955[(1)]);
if((state_val_44957 === (7))){
var state_44955__$1 = state_44955;
var statearr_44962_46509 = state_44955__$1;
(statearr_44962_46509[(2)] = null);

(statearr_44962_46509[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (1))){
var state_44955__$1 = state_44955;
var statearr_44963_46511 = state_44955__$1;
(statearr_44963_46511[(2)] = null);

(statearr_44963_46511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (4))){
var inst_44918 = (state_44955[(7)]);
var inst_44920 = (inst_44918 < cnt);
var state_44955__$1 = state_44955;
if(cljs.core.truth_(inst_44920)){
var statearr_44964_46518 = state_44955__$1;
(statearr_44964_46518[(1)] = (6));

} else {
var statearr_44965_46519 = state_44955__$1;
(statearr_44965_46519[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (15))){
var inst_44950 = (state_44955[(2)]);
var state_44955__$1 = state_44955;
var statearr_44968_46521 = state_44955__$1;
(statearr_44968_46521[(2)] = inst_44950);

(statearr_44968_46521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (13))){
var inst_44943 = cljs.core.async.close_BANG_(out);
var state_44955__$1 = state_44955;
var statearr_44974_46523 = state_44955__$1;
(statearr_44974_46523[(2)] = inst_44943);

(statearr_44974_46523[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (6))){
var state_44955__$1 = state_44955;
var statearr_44975_46529 = state_44955__$1;
(statearr_44975_46529[(2)] = null);

(statearr_44975_46529[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (3))){
var inst_44952 = (state_44955[(2)]);
var state_44955__$1 = state_44955;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44955__$1,inst_44952);
} else {
if((state_val_44957 === (12))){
var inst_44940 = (state_44955[(8)]);
var inst_44940__$1 = (state_44955[(2)]);
var inst_44941 = cljs.core.some(cljs.core.nil_QMARK_,inst_44940__$1);
var state_44955__$1 = (function (){var statearr_44982 = state_44955;
(statearr_44982[(8)] = inst_44940__$1);

return statearr_44982;
})();
if(cljs.core.truth_(inst_44941)){
var statearr_44983_46536 = state_44955__$1;
(statearr_44983_46536[(1)] = (13));

} else {
var statearr_44984_46537 = state_44955__$1;
(statearr_44984_46537[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (2))){
var inst_44917 = cljs.core.reset_BANG_(dctr,cnt);
var inst_44918 = (0);
var state_44955__$1 = (function (){var statearr_44987 = state_44955;
(statearr_44987[(7)] = inst_44918);

(statearr_44987[(9)] = inst_44917);

return statearr_44987;
})();
var statearr_44989_46540 = state_44955__$1;
(statearr_44989_46540[(2)] = null);

(statearr_44989_46540[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (11))){
var inst_44918 = (state_44955[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_44955,(10),Object,null,(9));
var inst_44927 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_44918) : chs__$1.call(null,inst_44918));
var inst_44928 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_44918) : done.call(null,inst_44918));
var inst_44929 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_44927,inst_44928);
var state_44955__$1 = state_44955;
var statearr_44998_46550 = state_44955__$1;
(statearr_44998_46550[(2)] = inst_44929);


cljs.core.async.impl.ioc_helpers.process_exception(state_44955__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (9))){
var inst_44918 = (state_44955[(7)]);
var inst_44931 = (state_44955[(2)]);
var inst_44932 = (inst_44918 + (1));
var inst_44918__$1 = inst_44932;
var state_44955__$1 = (function (){var statearr_45002 = state_44955;
(statearr_45002[(10)] = inst_44931);

(statearr_45002[(7)] = inst_44918__$1);

return statearr_45002;
})();
var statearr_45003_46555 = state_44955__$1;
(statearr_45003_46555[(2)] = null);

(statearr_45003_46555[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (5))){
var inst_44938 = (state_44955[(2)]);
var state_44955__$1 = (function (){var statearr_45006 = state_44955;
(statearr_45006[(11)] = inst_44938);

return statearr_45006;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44955__$1,(12),dchan);
} else {
if((state_val_44957 === (14))){
var inst_44940 = (state_44955[(8)]);
var inst_44945 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_44940);
var state_44955__$1 = state_44955;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44955__$1,(16),out,inst_44945);
} else {
if((state_val_44957 === (16))){
var inst_44947 = (state_44955[(2)]);
var state_44955__$1 = (function (){var statearr_45007 = state_44955;
(statearr_45007[(12)] = inst_44947);

return statearr_45007;
})();
var statearr_45008_46559 = state_44955__$1;
(statearr_45008_46559[(2)] = null);

(statearr_45008_46559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (10))){
var inst_44922 = (state_44955[(2)]);
var inst_44923 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_44955__$1 = (function (){var statearr_45009 = state_44955;
(statearr_45009[(13)] = inst_44922);

return statearr_45009;
})();
var statearr_45010_46563 = state_44955__$1;
(statearr_45010_46563[(2)] = inst_44923);


cljs.core.async.impl.ioc_helpers.process_exception(state_44955__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (8))){
var inst_44936 = (state_44955[(2)]);
var state_44955__$1 = state_44955;
var statearr_45011_46566 = state_44955__$1;
(statearr_45011_46566[(2)] = inst_44936);

(statearr_45011_46566[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42649__auto__ = null;
var cljs$core$async$state_machine__42649__auto____0 = (function (){
var statearr_45014 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45014[(0)] = cljs$core$async$state_machine__42649__auto__);

(statearr_45014[(1)] = (1));

return statearr_45014;
});
var cljs$core$async$state_machine__42649__auto____1 = (function (state_44955){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_44955);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e45015){if((e45015 instanceof Object)){
var ex__42652__auto__ = e45015;
var statearr_45016_46571 = state_44955;
(statearr_45016_46571[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44955);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45015;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46573 = state_44955;
state_44955 = G__46573;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$state_machine__42649__auto__ = function(state_44955){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42649__auto____1.call(this,state_44955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42649__auto____0;
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42649__auto____1;
return cljs$core$async$state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_45017 = f__42855__auto__();
(statearr_45017[(6)] = c__42854__auto___46507);

return statearr_45017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__45026 = arguments.length;
switch (G__45026) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42854__auto___46582 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_45063){
var state_val_45064 = (state_45063[(1)]);
if((state_val_45064 === (7))){
var inst_45041 = (state_45063[(7)]);
var inst_45042 = (state_45063[(8)]);
var inst_45041__$1 = (state_45063[(2)]);
var inst_45042__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45041__$1,(0),null);
var inst_45043 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45041__$1,(1),null);
var inst_45045 = (inst_45042__$1 == null);
var state_45063__$1 = (function (){var statearr_45066 = state_45063;
(statearr_45066[(9)] = inst_45043);

(statearr_45066[(7)] = inst_45041__$1);

(statearr_45066[(8)] = inst_45042__$1);

return statearr_45066;
})();
if(cljs.core.truth_(inst_45045)){
var statearr_45067_46586 = state_45063__$1;
(statearr_45067_46586[(1)] = (8));

} else {
var statearr_45068_46587 = state_45063__$1;
(statearr_45068_46587[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45064 === (1))){
var inst_45030 = cljs.core.vec(chs);
var inst_45031 = inst_45030;
var state_45063__$1 = (function (){var statearr_45069 = state_45063;
(statearr_45069[(10)] = inst_45031);

return statearr_45069;
})();
var statearr_45070_46589 = state_45063__$1;
(statearr_45070_46589[(2)] = null);

(statearr_45070_46589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45064 === (4))){
var inst_45031 = (state_45063[(10)]);
var state_45063__$1 = state_45063;
return cljs.core.async.ioc_alts_BANG_(state_45063__$1,(7),inst_45031);
} else {
if((state_val_45064 === (6))){
var inst_45059 = (state_45063[(2)]);
var state_45063__$1 = state_45063;
var statearr_45071_46591 = state_45063__$1;
(statearr_45071_46591[(2)] = inst_45059);

(statearr_45071_46591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45064 === (3))){
var inst_45061 = (state_45063[(2)]);
var state_45063__$1 = state_45063;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45063__$1,inst_45061);
} else {
if((state_val_45064 === (2))){
var inst_45031 = (state_45063[(10)]);
var inst_45033 = cljs.core.count(inst_45031);
var inst_45034 = (inst_45033 > (0));
var state_45063__$1 = state_45063;
if(cljs.core.truth_(inst_45034)){
var statearr_45073_46593 = state_45063__$1;
(statearr_45073_46593[(1)] = (4));

} else {
var statearr_45074_46598 = state_45063__$1;
(statearr_45074_46598[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45064 === (11))){
var inst_45031 = (state_45063[(10)]);
var inst_45052 = (state_45063[(2)]);
var tmp45072 = inst_45031;
var inst_45031__$1 = tmp45072;
var state_45063__$1 = (function (){var statearr_45075 = state_45063;
(statearr_45075[(10)] = inst_45031__$1);

(statearr_45075[(11)] = inst_45052);

return statearr_45075;
})();
var statearr_45076_46601 = state_45063__$1;
(statearr_45076_46601[(2)] = null);

(statearr_45076_46601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45064 === (9))){
var inst_45042 = (state_45063[(8)]);
var state_45063__$1 = state_45063;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45063__$1,(11),out,inst_45042);
} else {
if((state_val_45064 === (5))){
var inst_45057 = cljs.core.async.close_BANG_(out);
var state_45063__$1 = state_45063;
var statearr_45077_46607 = state_45063__$1;
(statearr_45077_46607[(2)] = inst_45057);

(statearr_45077_46607[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45064 === (10))){
var inst_45055 = (state_45063[(2)]);
var state_45063__$1 = state_45063;
var statearr_45078_46609 = state_45063__$1;
(statearr_45078_46609[(2)] = inst_45055);

(statearr_45078_46609[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45064 === (8))){
var inst_45043 = (state_45063[(9)]);
var inst_45031 = (state_45063[(10)]);
var inst_45041 = (state_45063[(7)]);
var inst_45042 = (state_45063[(8)]);
var inst_45047 = (function (){var cs = inst_45031;
var vec__45036 = inst_45041;
var v = inst_45042;
var c = inst_45043;
return (function (p1__45021_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__45021_SHARP_);
});
})();
var inst_45048 = cljs.core.filterv(inst_45047,inst_45031);
var inst_45031__$1 = inst_45048;
var state_45063__$1 = (function (){var statearr_45080 = state_45063;
(statearr_45080[(10)] = inst_45031__$1);

return statearr_45080;
})();
var statearr_45081_46614 = state_45063__$1;
(statearr_45081_46614[(2)] = null);

(statearr_45081_46614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42649__auto__ = null;
var cljs$core$async$state_machine__42649__auto____0 = (function (){
var statearr_45082 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45082[(0)] = cljs$core$async$state_machine__42649__auto__);

(statearr_45082[(1)] = (1));

return statearr_45082;
});
var cljs$core$async$state_machine__42649__auto____1 = (function (state_45063){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_45063);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e45083){if((e45083 instanceof Object)){
var ex__42652__auto__ = e45083;
var statearr_45084_46622 = state_45063;
(statearr_45084_46622[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_45063);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45083;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46624 = state_45063;
state_45063 = G__46624;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$state_machine__42649__auto__ = function(state_45063){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42649__auto____1.call(this,state_45063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42649__auto____0;
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42649__auto____1;
return cljs$core$async$state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_45085 = f__42855__auto__();
(statearr_45085[(6)] = c__42854__auto___46582);

return statearr_45085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__45089 = arguments.length;
switch (G__45089) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42854__auto___46633 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_45117){
var state_val_45118 = (state_45117[(1)]);
if((state_val_45118 === (7))){
var inst_45099 = (state_45117[(7)]);
var inst_45099__$1 = (state_45117[(2)]);
var inst_45100 = (inst_45099__$1 == null);
var inst_45101 = cljs.core.not(inst_45100);
var state_45117__$1 = (function (){var statearr_45120 = state_45117;
(statearr_45120[(7)] = inst_45099__$1);

return statearr_45120;
})();
if(inst_45101){
var statearr_45123_46638 = state_45117__$1;
(statearr_45123_46638[(1)] = (8));

} else {
var statearr_45124_46643 = state_45117__$1;
(statearr_45124_46643[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45118 === (1))){
var inst_45093 = (0);
var state_45117__$1 = (function (){var statearr_45125 = state_45117;
(statearr_45125[(8)] = inst_45093);

return statearr_45125;
})();
var statearr_45126_46649 = state_45117__$1;
(statearr_45126_46649[(2)] = null);

(statearr_45126_46649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45118 === (4))){
var state_45117__$1 = state_45117;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45117__$1,(7),ch);
} else {
if((state_val_45118 === (6))){
var inst_45112 = (state_45117[(2)]);
var state_45117__$1 = state_45117;
var statearr_45127_46653 = state_45117__$1;
(statearr_45127_46653[(2)] = inst_45112);

(statearr_45127_46653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45118 === (3))){
var inst_45114 = (state_45117[(2)]);
var inst_45115 = cljs.core.async.close_BANG_(out);
var state_45117__$1 = (function (){var statearr_45128 = state_45117;
(statearr_45128[(9)] = inst_45114);

return statearr_45128;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45117__$1,inst_45115);
} else {
if((state_val_45118 === (2))){
var inst_45093 = (state_45117[(8)]);
var inst_45096 = (inst_45093 < n);
var state_45117__$1 = state_45117;
if(cljs.core.truth_(inst_45096)){
var statearr_45129_46664 = state_45117__$1;
(statearr_45129_46664[(1)] = (4));

} else {
var statearr_45130_46665 = state_45117__$1;
(statearr_45130_46665[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45118 === (11))){
var inst_45093 = (state_45117[(8)]);
var inst_45104 = (state_45117[(2)]);
var inst_45105 = (inst_45093 + (1));
var inst_45093__$1 = inst_45105;
var state_45117__$1 = (function (){var statearr_45131 = state_45117;
(statearr_45131[(8)] = inst_45093__$1);

(statearr_45131[(10)] = inst_45104);

return statearr_45131;
})();
var statearr_45132_46670 = state_45117__$1;
(statearr_45132_46670[(2)] = null);

(statearr_45132_46670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45118 === (9))){
var state_45117__$1 = state_45117;
var statearr_45133_46675 = state_45117__$1;
(statearr_45133_46675[(2)] = null);

(statearr_45133_46675[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45118 === (5))){
var state_45117__$1 = state_45117;
var statearr_45134_46676 = state_45117__$1;
(statearr_45134_46676[(2)] = null);

(statearr_45134_46676[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45118 === (10))){
var inst_45109 = (state_45117[(2)]);
var state_45117__$1 = state_45117;
var statearr_45135_46683 = state_45117__$1;
(statearr_45135_46683[(2)] = inst_45109);

(statearr_45135_46683[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45118 === (8))){
var inst_45099 = (state_45117[(7)]);
var state_45117__$1 = state_45117;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45117__$1,(11),out,inst_45099);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42649__auto__ = null;
var cljs$core$async$state_machine__42649__auto____0 = (function (){
var statearr_45136 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45136[(0)] = cljs$core$async$state_machine__42649__auto__);

(statearr_45136[(1)] = (1));

return statearr_45136;
});
var cljs$core$async$state_machine__42649__auto____1 = (function (state_45117){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_45117);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e45138){if((e45138 instanceof Object)){
var ex__42652__auto__ = e45138;
var statearr_45139_46701 = state_45117;
(statearr_45139_46701[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_45117);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45138;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46704 = state_45117;
state_45117 = G__46704;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$state_machine__42649__auto__ = function(state_45117){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42649__auto____1.call(this,state_45117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42649__auto____0;
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42649__auto____1;
return cljs$core$async$state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_45140 = f__42855__auto__();
(statearr_45140[(6)] = c__42854__auto___46633);

return statearr_45140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45143 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45143 = (function (f,ch,meta45144){
this.f = f;
this.ch = ch;
this.meta45144 = meta45144;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45143.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45145,meta45144__$1){
var self__ = this;
var _45145__$1 = this;
return (new cljs.core.async.t_cljs$core$async45143(self__.f,self__.ch,meta45144__$1));
}));

(cljs.core.async.t_cljs$core$async45143.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45145){
var self__ = this;
var _45145__$1 = this;
return self__.meta45144;
}));

(cljs.core.async.t_cljs$core$async45143.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45143.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45143.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45143.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45143.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45165 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45165 = (function (f,ch,meta45144,_,fn1,meta45166){
this.f = f;
this.ch = ch;
this.meta45144 = meta45144;
this._ = _;
this.fn1 = fn1;
this.meta45166 = meta45166;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45165.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45167,meta45166__$1){
var self__ = this;
var _45167__$1 = this;
return (new cljs.core.async.t_cljs$core$async45165(self__.f,self__.ch,self__.meta45144,self__._,self__.fn1,meta45166__$1));
}));

(cljs.core.async.t_cljs$core$async45165.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45167){
var self__ = this;
var _45167__$1 = this;
return self__.meta45166;
}));

(cljs.core.async.t_cljs$core$async45165.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45165.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async45165.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45165.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__45142_SHARP_){
var G__45168 = (((p1__45142_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__45142_SHARP_) : self__.f.call(null,p1__45142_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__45168) : f1.call(null,G__45168));
});
}));

(cljs.core.async.t_cljs$core$async45165.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45144","meta45144",1253896302,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async45143","cljs.core.async/t_cljs$core$async45143",540345901,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta45166","meta45166",-10183685,null)], null);
}));

(cljs.core.async.t_cljs$core$async45165.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45165.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45165");

(cljs.core.async.t_cljs$core$async45165.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45165");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45165.
 */
cljs.core.async.__GT_t_cljs$core$async45165 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45165(f__$1,ch__$1,meta45144__$1,___$2,fn1__$1,meta45166){
return (new cljs.core.async.t_cljs$core$async45165(f__$1,ch__$1,meta45144__$1,___$2,fn1__$1,meta45166));
});

}

return (new cljs.core.async.t_cljs$core$async45165(self__.f,self__.ch,self__.meta45144,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__45169 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__45169) : self__.f.call(null,G__45169));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async45143.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45143.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async45143.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45144","meta45144",1253896302,null)], null);
}));

(cljs.core.async.t_cljs$core$async45143.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45143.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45143");

(cljs.core.async.t_cljs$core$async45143.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45143");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45143.
 */
cljs.core.async.__GT_t_cljs$core$async45143 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45143(f__$1,ch__$1,meta45144){
return (new cljs.core.async.t_cljs$core$async45143(f__$1,ch__$1,meta45144));
});

}

return (new cljs.core.async.t_cljs$core$async45143(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45172 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45172 = (function (f,ch,meta45173){
this.f = f;
this.ch = ch;
this.meta45173 = meta45173;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45172.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45174,meta45173__$1){
var self__ = this;
var _45174__$1 = this;
return (new cljs.core.async.t_cljs$core$async45172(self__.f,self__.ch,meta45173__$1));
}));

(cljs.core.async.t_cljs$core$async45172.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45174){
var self__ = this;
var _45174__$1 = this;
return self__.meta45173;
}));

(cljs.core.async.t_cljs$core$async45172.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45172.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45172.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45172.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45172.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45172.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async45172.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45173","meta45173",195958985,null)], null);
}));

(cljs.core.async.t_cljs$core$async45172.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45172.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45172");

(cljs.core.async.t_cljs$core$async45172.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45172");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45172.
 */
cljs.core.async.__GT_t_cljs$core$async45172 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async45172(f__$1,ch__$1,meta45173){
return (new cljs.core.async.t_cljs$core$async45172(f__$1,ch__$1,meta45173));
});

}

return (new cljs.core.async.t_cljs$core$async45172(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45182 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45182 = (function (p,ch,meta45183){
this.p = p;
this.ch = ch;
this.meta45183 = meta45183;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45182.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45184,meta45183__$1){
var self__ = this;
var _45184__$1 = this;
return (new cljs.core.async.t_cljs$core$async45182(self__.p,self__.ch,meta45183__$1));
}));

(cljs.core.async.t_cljs$core$async45182.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45184){
var self__ = this;
var _45184__$1 = this;
return self__.meta45183;
}));

(cljs.core.async.t_cljs$core$async45182.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45182.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45182.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45182.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45182.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45182.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45182.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async45182.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45183","meta45183",-1662055727,null)], null);
}));

(cljs.core.async.t_cljs$core$async45182.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45182.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45182");

(cljs.core.async.t_cljs$core$async45182.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45182");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45182.
 */
cljs.core.async.__GT_t_cljs$core$async45182 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async45182(p__$1,ch__$1,meta45183){
return (new cljs.core.async.t_cljs$core$async45182(p__$1,ch__$1,meta45183));
});

}

return (new cljs.core.async.t_cljs$core$async45182(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__45187 = arguments.length;
switch (G__45187) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42854__auto___46808 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_45208){
var state_val_45209 = (state_45208[(1)]);
if((state_val_45209 === (7))){
var inst_45204 = (state_45208[(2)]);
var state_45208__$1 = state_45208;
var statearr_45212_46816 = state_45208__$1;
(statearr_45212_46816[(2)] = inst_45204);

(statearr_45212_46816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45209 === (1))){
var state_45208__$1 = state_45208;
var statearr_45213_46826 = state_45208__$1;
(statearr_45213_46826[(2)] = null);

(statearr_45213_46826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45209 === (4))){
var inst_45190 = (state_45208[(7)]);
var inst_45190__$1 = (state_45208[(2)]);
var inst_45191 = (inst_45190__$1 == null);
var state_45208__$1 = (function (){var statearr_45215 = state_45208;
(statearr_45215[(7)] = inst_45190__$1);

return statearr_45215;
})();
if(cljs.core.truth_(inst_45191)){
var statearr_45216_46836 = state_45208__$1;
(statearr_45216_46836[(1)] = (5));

} else {
var statearr_45217_46843 = state_45208__$1;
(statearr_45217_46843[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45209 === (6))){
var inst_45190 = (state_45208[(7)]);
var inst_45195 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_45190) : p.call(null,inst_45190));
var state_45208__$1 = state_45208;
if(cljs.core.truth_(inst_45195)){
var statearr_45218_46852 = state_45208__$1;
(statearr_45218_46852[(1)] = (8));

} else {
var statearr_45219_46857 = state_45208__$1;
(statearr_45219_46857[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45209 === (3))){
var inst_45206 = (state_45208[(2)]);
var state_45208__$1 = state_45208;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45208__$1,inst_45206);
} else {
if((state_val_45209 === (2))){
var state_45208__$1 = state_45208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45208__$1,(4),ch);
} else {
if((state_val_45209 === (11))){
var inst_45198 = (state_45208[(2)]);
var state_45208__$1 = state_45208;
var statearr_45220_46870 = state_45208__$1;
(statearr_45220_46870[(2)] = inst_45198);

(statearr_45220_46870[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45209 === (9))){
var state_45208__$1 = state_45208;
var statearr_45221_46879 = state_45208__$1;
(statearr_45221_46879[(2)] = null);

(statearr_45221_46879[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45209 === (5))){
var inst_45193 = cljs.core.async.close_BANG_(out);
var state_45208__$1 = state_45208;
var statearr_45222_46885 = state_45208__$1;
(statearr_45222_46885[(2)] = inst_45193);

(statearr_45222_46885[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45209 === (10))){
var inst_45201 = (state_45208[(2)]);
var state_45208__$1 = (function (){var statearr_45223 = state_45208;
(statearr_45223[(8)] = inst_45201);

return statearr_45223;
})();
var statearr_45224_46894 = state_45208__$1;
(statearr_45224_46894[(2)] = null);

(statearr_45224_46894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45209 === (8))){
var inst_45190 = (state_45208[(7)]);
var state_45208__$1 = state_45208;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45208__$1,(11),out,inst_45190);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42649__auto__ = null;
var cljs$core$async$state_machine__42649__auto____0 = (function (){
var statearr_45227 = [null,null,null,null,null,null,null,null,null];
(statearr_45227[(0)] = cljs$core$async$state_machine__42649__auto__);

(statearr_45227[(1)] = (1));

return statearr_45227;
});
var cljs$core$async$state_machine__42649__auto____1 = (function (state_45208){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_45208);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e45228){if((e45228 instanceof Object)){
var ex__42652__auto__ = e45228;
var statearr_45229_46897 = state_45208;
(statearr_45229_46897[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_45208);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45228;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46898 = state_45208;
state_45208 = G__46898;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$state_machine__42649__auto__ = function(state_45208){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42649__auto____1.call(this,state_45208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42649__auto____0;
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42649__auto____1;
return cljs$core$async$state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_45230 = f__42855__auto__();
(statearr_45230[(6)] = c__42854__auto___46808);

return statearr_45230;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__45232 = arguments.length;
switch (G__45232) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__42854__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_45294){
var state_val_45295 = (state_45294[(1)]);
if((state_val_45295 === (7))){
var inst_45290 = (state_45294[(2)]);
var state_45294__$1 = state_45294;
var statearr_45298_46915 = state_45294__$1;
(statearr_45298_46915[(2)] = inst_45290);

(statearr_45298_46915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (20))){
var inst_45260 = (state_45294[(7)]);
var inst_45271 = (state_45294[(2)]);
var inst_45272 = cljs.core.next(inst_45260);
var inst_45246 = inst_45272;
var inst_45247 = null;
var inst_45248 = (0);
var inst_45249 = (0);
var state_45294__$1 = (function (){var statearr_45301 = state_45294;
(statearr_45301[(8)] = inst_45247);

(statearr_45301[(9)] = inst_45271);

(statearr_45301[(10)] = inst_45246);

(statearr_45301[(11)] = inst_45249);

(statearr_45301[(12)] = inst_45248);

return statearr_45301;
})();
var statearr_45303_46917 = state_45294__$1;
(statearr_45303_46917[(2)] = null);

(statearr_45303_46917[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (1))){
var state_45294__$1 = state_45294;
var statearr_45305_46919 = state_45294__$1;
(statearr_45305_46919[(2)] = null);

(statearr_45305_46919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (4))){
var inst_45235 = (state_45294[(13)]);
var inst_45235__$1 = (state_45294[(2)]);
var inst_45236 = (inst_45235__$1 == null);
var state_45294__$1 = (function (){var statearr_45307 = state_45294;
(statearr_45307[(13)] = inst_45235__$1);

return statearr_45307;
})();
if(cljs.core.truth_(inst_45236)){
var statearr_45308_46921 = state_45294__$1;
(statearr_45308_46921[(1)] = (5));

} else {
var statearr_45311_46922 = state_45294__$1;
(statearr_45311_46922[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (15))){
var state_45294__$1 = state_45294;
var statearr_45316_46923 = state_45294__$1;
(statearr_45316_46923[(2)] = null);

(statearr_45316_46923[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (21))){
var state_45294__$1 = state_45294;
var statearr_45319_46925 = state_45294__$1;
(statearr_45319_46925[(2)] = null);

(statearr_45319_46925[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (13))){
var inst_45247 = (state_45294[(8)]);
var inst_45246 = (state_45294[(10)]);
var inst_45249 = (state_45294[(11)]);
var inst_45248 = (state_45294[(12)]);
var inst_45256 = (state_45294[(2)]);
var inst_45257 = (inst_45249 + (1));
var tmp45312 = inst_45247;
var tmp45313 = inst_45246;
var tmp45314 = inst_45248;
var inst_45246__$1 = tmp45313;
var inst_45247__$1 = tmp45312;
var inst_45248__$1 = tmp45314;
var inst_45249__$1 = inst_45257;
var state_45294__$1 = (function (){var statearr_45320 = state_45294;
(statearr_45320[(8)] = inst_45247__$1);

(statearr_45320[(10)] = inst_45246__$1);

(statearr_45320[(11)] = inst_45249__$1);

(statearr_45320[(14)] = inst_45256);

(statearr_45320[(12)] = inst_45248__$1);

return statearr_45320;
})();
var statearr_45321_46926 = state_45294__$1;
(statearr_45321_46926[(2)] = null);

(statearr_45321_46926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (22))){
var state_45294__$1 = state_45294;
var statearr_45322_46931 = state_45294__$1;
(statearr_45322_46931[(2)] = null);

(statearr_45322_46931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (6))){
var inst_45235 = (state_45294[(13)]);
var inst_45244 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_45235) : f.call(null,inst_45235));
var inst_45245 = cljs.core.seq(inst_45244);
var inst_45246 = inst_45245;
var inst_45247 = null;
var inst_45248 = (0);
var inst_45249 = (0);
var state_45294__$1 = (function (){var statearr_45325 = state_45294;
(statearr_45325[(8)] = inst_45247);

(statearr_45325[(10)] = inst_45246);

(statearr_45325[(11)] = inst_45249);

(statearr_45325[(12)] = inst_45248);

return statearr_45325;
})();
var statearr_45326_46944 = state_45294__$1;
(statearr_45326_46944[(2)] = null);

(statearr_45326_46944[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (17))){
var inst_45260 = (state_45294[(7)]);
var inst_45264 = cljs.core.chunk_first(inst_45260);
var inst_45265 = cljs.core.chunk_rest(inst_45260);
var inst_45266 = cljs.core.count(inst_45264);
var inst_45246 = inst_45265;
var inst_45247 = inst_45264;
var inst_45248 = inst_45266;
var inst_45249 = (0);
var state_45294__$1 = (function (){var statearr_45329 = state_45294;
(statearr_45329[(8)] = inst_45247);

(statearr_45329[(10)] = inst_45246);

(statearr_45329[(11)] = inst_45249);

(statearr_45329[(12)] = inst_45248);

return statearr_45329;
})();
var statearr_45332_46964 = state_45294__$1;
(statearr_45332_46964[(2)] = null);

(statearr_45332_46964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (3))){
var inst_45292 = (state_45294[(2)]);
var state_45294__$1 = state_45294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45294__$1,inst_45292);
} else {
if((state_val_45295 === (12))){
var inst_45280 = (state_45294[(2)]);
var state_45294__$1 = state_45294;
var statearr_45334_46974 = state_45294__$1;
(statearr_45334_46974[(2)] = inst_45280);

(statearr_45334_46974[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (2))){
var state_45294__$1 = state_45294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45294__$1,(4),in$);
} else {
if((state_val_45295 === (23))){
var inst_45288 = (state_45294[(2)]);
var state_45294__$1 = state_45294;
var statearr_45343_46979 = state_45294__$1;
(statearr_45343_46979[(2)] = inst_45288);

(statearr_45343_46979[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (19))){
var inst_45275 = (state_45294[(2)]);
var state_45294__$1 = state_45294;
var statearr_45345_46983 = state_45294__$1;
(statearr_45345_46983[(2)] = inst_45275);

(statearr_45345_46983[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (11))){
var inst_45246 = (state_45294[(10)]);
var inst_45260 = (state_45294[(7)]);
var inst_45260__$1 = cljs.core.seq(inst_45246);
var state_45294__$1 = (function (){var statearr_45347 = state_45294;
(statearr_45347[(7)] = inst_45260__$1);

return statearr_45347;
})();
if(inst_45260__$1){
var statearr_45348_46999 = state_45294__$1;
(statearr_45348_46999[(1)] = (14));

} else {
var statearr_45350_47007 = state_45294__$1;
(statearr_45350_47007[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (9))){
var inst_45282 = (state_45294[(2)]);
var inst_45283 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_45294__$1 = (function (){var statearr_45351 = state_45294;
(statearr_45351[(15)] = inst_45282);

return statearr_45351;
})();
if(cljs.core.truth_(inst_45283)){
var statearr_45356_47016 = state_45294__$1;
(statearr_45356_47016[(1)] = (21));

} else {
var statearr_45357_47017 = state_45294__$1;
(statearr_45357_47017[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (5))){
var inst_45238 = cljs.core.async.close_BANG_(out);
var state_45294__$1 = state_45294;
var statearr_45358_47018 = state_45294__$1;
(statearr_45358_47018[(2)] = inst_45238);

(statearr_45358_47018[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (14))){
var inst_45260 = (state_45294[(7)]);
var inst_45262 = cljs.core.chunked_seq_QMARK_(inst_45260);
var state_45294__$1 = state_45294;
if(inst_45262){
var statearr_45359_47019 = state_45294__$1;
(statearr_45359_47019[(1)] = (17));

} else {
var statearr_45360_47020 = state_45294__$1;
(statearr_45360_47020[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (16))){
var inst_45278 = (state_45294[(2)]);
var state_45294__$1 = state_45294;
var statearr_45361_47022 = state_45294__$1;
(statearr_45361_47022[(2)] = inst_45278);

(statearr_45361_47022[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45295 === (10))){
var inst_45247 = (state_45294[(8)]);
var inst_45249 = (state_45294[(11)]);
var inst_45254 = cljs.core._nth(inst_45247,inst_45249);
var state_45294__$1 = state_45294;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45294__$1,(13),out,inst_45254);
} else {
if((state_val_45295 === (18))){
var inst_45260 = (state_45294[(7)]);
var inst_45269 = cljs.core.first(inst_45260);
var state_45294__$1 = state_45294;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45294__$1,(20),out,inst_45269);
} else {
if((state_val_45295 === (8))){
var inst_45249 = (state_45294[(11)]);
var inst_45248 = (state_45294[(12)]);
var inst_45251 = (inst_45249 < inst_45248);
var inst_45252 = inst_45251;
var state_45294__$1 = state_45294;
if(cljs.core.truth_(inst_45252)){
var statearr_45362_47023 = state_45294__$1;
(statearr_45362_47023[(1)] = (10));

} else {
var statearr_45364_47024 = state_45294__$1;
(statearr_45364_47024[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__42649__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__42649__auto____0 = (function (){
var statearr_45365 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45365[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__42649__auto__);

(statearr_45365[(1)] = (1));

return statearr_45365;
});
var cljs$core$async$mapcat_STAR__$_state_machine__42649__auto____1 = (function (state_45294){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_45294);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e45366){if((e45366 instanceof Object)){
var ex__42652__auto__ = e45366;
var statearr_45367_47032 = state_45294;
(statearr_45367_47032[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_45294);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45366;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47033 = state_45294;
state_45294 = G__47033;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__42649__auto__ = function(state_45294){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__42649__auto____1.call(this,state_45294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__42649__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__42649__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_45368 = f__42855__auto__();
(statearr_45368[(6)] = c__42854__auto__);

return statearr_45368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));

return c__42854__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__45370 = arguments.length;
switch (G__45370) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__45374 = arguments.length;
switch (G__45374) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__45378 = arguments.length;
switch (G__45378) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42854__auto___47051 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_45405){
var state_val_45406 = (state_45405[(1)]);
if((state_val_45406 === (7))){
var inst_45399 = (state_45405[(2)]);
var state_45405__$1 = state_45405;
var statearr_45410_47052 = state_45405__$1;
(statearr_45410_47052[(2)] = inst_45399);

(statearr_45410_47052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45406 === (1))){
var inst_45381 = null;
var state_45405__$1 = (function (){var statearr_45411 = state_45405;
(statearr_45411[(7)] = inst_45381);

return statearr_45411;
})();
var statearr_45412_47053 = state_45405__$1;
(statearr_45412_47053[(2)] = null);

(statearr_45412_47053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45406 === (4))){
var inst_45384 = (state_45405[(8)]);
var inst_45384__$1 = (state_45405[(2)]);
var inst_45385 = (inst_45384__$1 == null);
var inst_45386 = cljs.core.not(inst_45385);
var state_45405__$1 = (function (){var statearr_45420 = state_45405;
(statearr_45420[(8)] = inst_45384__$1);

return statearr_45420;
})();
if(inst_45386){
var statearr_45421_47054 = state_45405__$1;
(statearr_45421_47054[(1)] = (5));

} else {
var statearr_45422_47055 = state_45405__$1;
(statearr_45422_47055[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45406 === (6))){
var state_45405__$1 = state_45405;
var statearr_45427_47056 = state_45405__$1;
(statearr_45427_47056[(2)] = null);

(statearr_45427_47056[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45406 === (3))){
var inst_45401 = (state_45405[(2)]);
var inst_45403 = cljs.core.async.close_BANG_(out);
var state_45405__$1 = (function (){var statearr_45436 = state_45405;
(statearr_45436[(9)] = inst_45401);

return statearr_45436;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45405__$1,inst_45403);
} else {
if((state_val_45406 === (2))){
var state_45405__$1 = state_45405;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45405__$1,(4),ch);
} else {
if((state_val_45406 === (11))){
var inst_45384 = (state_45405[(8)]);
var inst_45393 = (state_45405[(2)]);
var inst_45381 = inst_45384;
var state_45405__$1 = (function (){var statearr_45439 = state_45405;
(statearr_45439[(10)] = inst_45393);

(statearr_45439[(7)] = inst_45381);

return statearr_45439;
})();
var statearr_45444_47057 = state_45405__$1;
(statearr_45444_47057[(2)] = null);

(statearr_45444_47057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45406 === (9))){
var inst_45384 = (state_45405[(8)]);
var state_45405__$1 = state_45405;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45405__$1,(11),out,inst_45384);
} else {
if((state_val_45406 === (5))){
var inst_45384 = (state_45405[(8)]);
var inst_45381 = (state_45405[(7)]);
var inst_45388 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45384,inst_45381);
var state_45405__$1 = state_45405;
if(inst_45388){
var statearr_45447_47058 = state_45405__$1;
(statearr_45447_47058[(1)] = (8));

} else {
var statearr_45448_47059 = state_45405__$1;
(statearr_45448_47059[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45406 === (10))){
var inst_45396 = (state_45405[(2)]);
var state_45405__$1 = state_45405;
var statearr_45449_47066 = state_45405__$1;
(statearr_45449_47066[(2)] = inst_45396);

(statearr_45449_47066[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45406 === (8))){
var inst_45381 = (state_45405[(7)]);
var tmp45446 = inst_45381;
var inst_45381__$1 = tmp45446;
var state_45405__$1 = (function (){var statearr_45450 = state_45405;
(statearr_45450[(7)] = inst_45381__$1);

return statearr_45450;
})();
var statearr_45451_47067 = state_45405__$1;
(statearr_45451_47067[(2)] = null);

(statearr_45451_47067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42649__auto__ = null;
var cljs$core$async$state_machine__42649__auto____0 = (function (){
var statearr_45452 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45452[(0)] = cljs$core$async$state_machine__42649__auto__);

(statearr_45452[(1)] = (1));

return statearr_45452;
});
var cljs$core$async$state_machine__42649__auto____1 = (function (state_45405){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_45405);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e45453){if((e45453 instanceof Object)){
var ex__42652__auto__ = e45453;
var statearr_45454_47068 = state_45405;
(statearr_45454_47068[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_45405);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45453;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47071 = state_45405;
state_45405 = G__47071;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$state_machine__42649__auto__ = function(state_45405){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42649__auto____1.call(this,state_45405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42649__auto____0;
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42649__auto____1;
return cljs$core$async$state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_45455 = f__42855__auto__();
(statearr_45455[(6)] = c__42854__auto___47051);

return statearr_45455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__45457 = arguments.length;
switch (G__45457) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42854__auto___47077 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_45496){
var state_val_45497 = (state_45496[(1)]);
if((state_val_45497 === (7))){
var inst_45492 = (state_45496[(2)]);
var state_45496__$1 = state_45496;
var statearr_45498_47079 = state_45496__$1;
(statearr_45498_47079[(2)] = inst_45492);

(statearr_45498_47079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45497 === (1))){
var inst_45459 = (new Array(n));
var inst_45460 = inst_45459;
var inst_45461 = (0);
var state_45496__$1 = (function (){var statearr_45500 = state_45496;
(statearr_45500[(7)] = inst_45460);

(statearr_45500[(8)] = inst_45461);

return statearr_45500;
})();
var statearr_45502_47080 = state_45496__$1;
(statearr_45502_47080[(2)] = null);

(statearr_45502_47080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45497 === (4))){
var inst_45464 = (state_45496[(9)]);
var inst_45464__$1 = (state_45496[(2)]);
var inst_45465 = (inst_45464__$1 == null);
var inst_45466 = cljs.core.not(inst_45465);
var state_45496__$1 = (function (){var statearr_45504 = state_45496;
(statearr_45504[(9)] = inst_45464__$1);

return statearr_45504;
})();
if(inst_45466){
var statearr_45505_47086 = state_45496__$1;
(statearr_45505_47086[(1)] = (5));

} else {
var statearr_45507_47088 = state_45496__$1;
(statearr_45507_47088[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45497 === (15))){
var inst_45486 = (state_45496[(2)]);
var state_45496__$1 = state_45496;
var statearr_45508_47089 = state_45496__$1;
(statearr_45508_47089[(2)] = inst_45486);

(statearr_45508_47089[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45497 === (13))){
var state_45496__$1 = state_45496;
var statearr_45509_47090 = state_45496__$1;
(statearr_45509_47090[(2)] = null);

(statearr_45509_47090[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45497 === (6))){
var inst_45461 = (state_45496[(8)]);
var inst_45482 = (inst_45461 > (0));
var state_45496__$1 = state_45496;
if(cljs.core.truth_(inst_45482)){
var statearr_45511_47091 = state_45496__$1;
(statearr_45511_47091[(1)] = (12));

} else {
var statearr_45512_47092 = state_45496__$1;
(statearr_45512_47092[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45497 === (3))){
var inst_45494 = (state_45496[(2)]);
var state_45496__$1 = state_45496;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45496__$1,inst_45494);
} else {
if((state_val_45497 === (12))){
var inst_45460 = (state_45496[(7)]);
var inst_45484 = cljs.core.vec(inst_45460);
var state_45496__$1 = state_45496;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45496__$1,(15),out,inst_45484);
} else {
if((state_val_45497 === (2))){
var state_45496__$1 = state_45496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45496__$1,(4),ch);
} else {
if((state_val_45497 === (11))){
var inst_45476 = (state_45496[(2)]);
var inst_45477 = (new Array(n));
var inst_45460 = inst_45477;
var inst_45461 = (0);
var state_45496__$1 = (function (){var statearr_45516 = state_45496;
(statearr_45516[(7)] = inst_45460);

(statearr_45516[(10)] = inst_45476);

(statearr_45516[(8)] = inst_45461);

return statearr_45516;
})();
var statearr_45517_47096 = state_45496__$1;
(statearr_45517_47096[(2)] = null);

(statearr_45517_47096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45497 === (9))){
var inst_45460 = (state_45496[(7)]);
var inst_45474 = cljs.core.vec(inst_45460);
var state_45496__$1 = state_45496;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45496__$1,(11),out,inst_45474);
} else {
if((state_val_45497 === (5))){
var inst_45469 = (state_45496[(11)]);
var inst_45460 = (state_45496[(7)]);
var inst_45461 = (state_45496[(8)]);
var inst_45464 = (state_45496[(9)]);
var inst_45468 = (inst_45460[inst_45461] = inst_45464);
var inst_45469__$1 = (inst_45461 + (1));
var inst_45470 = (inst_45469__$1 < n);
var state_45496__$1 = (function (){var statearr_45518 = state_45496;
(statearr_45518[(11)] = inst_45469__$1);

(statearr_45518[(12)] = inst_45468);

return statearr_45518;
})();
if(cljs.core.truth_(inst_45470)){
var statearr_45519_47097 = state_45496__$1;
(statearr_45519_47097[(1)] = (8));

} else {
var statearr_45520_47099 = state_45496__$1;
(statearr_45520_47099[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45497 === (14))){
var inst_45489 = (state_45496[(2)]);
var inst_45490 = cljs.core.async.close_BANG_(out);
var state_45496__$1 = (function (){var statearr_45522 = state_45496;
(statearr_45522[(13)] = inst_45489);

return statearr_45522;
})();
var statearr_45523_47103 = state_45496__$1;
(statearr_45523_47103[(2)] = inst_45490);

(statearr_45523_47103[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45497 === (10))){
var inst_45480 = (state_45496[(2)]);
var state_45496__$1 = state_45496;
var statearr_45524_47104 = state_45496__$1;
(statearr_45524_47104[(2)] = inst_45480);

(statearr_45524_47104[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45497 === (8))){
var inst_45469 = (state_45496[(11)]);
var inst_45460 = (state_45496[(7)]);
var tmp45521 = inst_45460;
var inst_45460__$1 = tmp45521;
var inst_45461 = inst_45469;
var state_45496__$1 = (function (){var statearr_45525 = state_45496;
(statearr_45525[(7)] = inst_45460__$1);

(statearr_45525[(8)] = inst_45461);

return statearr_45525;
})();
var statearr_45526_47105 = state_45496__$1;
(statearr_45526_47105[(2)] = null);

(statearr_45526_47105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42649__auto__ = null;
var cljs$core$async$state_machine__42649__auto____0 = (function (){
var statearr_45527 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45527[(0)] = cljs$core$async$state_machine__42649__auto__);

(statearr_45527[(1)] = (1));

return statearr_45527;
});
var cljs$core$async$state_machine__42649__auto____1 = (function (state_45496){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_45496);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e45528){if((e45528 instanceof Object)){
var ex__42652__auto__ = e45528;
var statearr_45529_47106 = state_45496;
(statearr_45529_47106[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_45496);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45528;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47107 = state_45496;
state_45496 = G__47107;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$state_machine__42649__auto__ = function(state_45496){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42649__auto____1.call(this,state_45496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42649__auto____0;
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42649__auto____1;
return cljs$core$async$state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_45530 = f__42855__auto__();
(statearr_45530[(6)] = c__42854__auto___47077);

return statearr_45530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__45534 = arguments.length;
switch (G__45534) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42854__auto___47113 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42855__auto__ = (function (){var switch__42648__auto__ = (function (state_45589){
var state_val_45590 = (state_45589[(1)]);
if((state_val_45590 === (7))){
var inst_45581 = (state_45589[(2)]);
var state_45589__$1 = state_45589;
var statearr_45591_47117 = state_45589__$1;
(statearr_45591_47117[(2)] = inst_45581);

(statearr_45591_47117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45590 === (1))){
var inst_45540 = [];
var inst_45541 = inst_45540;
var inst_45542 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_45589__$1 = (function (){var statearr_45596 = state_45589;
(statearr_45596[(7)] = inst_45542);

(statearr_45596[(8)] = inst_45541);

return statearr_45596;
})();
var statearr_45597_47119 = state_45589__$1;
(statearr_45597_47119[(2)] = null);

(statearr_45597_47119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45590 === (4))){
var inst_45545 = (state_45589[(9)]);
var inst_45545__$1 = (state_45589[(2)]);
var inst_45546 = (inst_45545__$1 == null);
var inst_45547 = cljs.core.not(inst_45546);
var state_45589__$1 = (function (){var statearr_45602 = state_45589;
(statearr_45602[(9)] = inst_45545__$1);

return statearr_45602;
})();
if(inst_45547){
var statearr_45603_47120 = state_45589__$1;
(statearr_45603_47120[(1)] = (5));

} else {
var statearr_45604_47121 = state_45589__$1;
(statearr_45604_47121[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45590 === (15))){
var inst_45575 = (state_45589[(2)]);
var state_45589__$1 = state_45589;
var statearr_45605_47124 = state_45589__$1;
(statearr_45605_47124[(2)] = inst_45575);

(statearr_45605_47124[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45590 === (13))){
var state_45589__$1 = state_45589;
var statearr_45606_47125 = state_45589__$1;
(statearr_45606_47125[(2)] = null);

(statearr_45606_47125[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45590 === (6))){
var inst_45541 = (state_45589[(8)]);
var inst_45570 = inst_45541.length;
var inst_45571 = (inst_45570 > (0));
var state_45589__$1 = state_45589;
if(cljs.core.truth_(inst_45571)){
var statearr_45608_47126 = state_45589__$1;
(statearr_45608_47126[(1)] = (12));

} else {
var statearr_45609_47127 = state_45589__$1;
(statearr_45609_47127[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45590 === (3))){
var inst_45583 = (state_45589[(2)]);
var state_45589__$1 = state_45589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45589__$1,inst_45583);
} else {
if((state_val_45590 === (12))){
var inst_45541 = (state_45589[(8)]);
var inst_45573 = cljs.core.vec(inst_45541);
var state_45589__$1 = state_45589;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45589__$1,(15),out,inst_45573);
} else {
if((state_val_45590 === (2))){
var state_45589__$1 = state_45589;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45589__$1,(4),ch);
} else {
if((state_val_45590 === (11))){
var inst_45545 = (state_45589[(9)]);
var inst_45549 = (state_45589[(10)]);
var inst_45563 = (state_45589[(2)]);
var inst_45564 = [];
var inst_45565 = inst_45564.push(inst_45545);
var inst_45541 = inst_45564;
var inst_45542 = inst_45549;
var state_45589__$1 = (function (){var statearr_45613 = state_45589;
(statearr_45613[(7)] = inst_45542);

(statearr_45613[(11)] = inst_45563);

(statearr_45613[(12)] = inst_45565);

(statearr_45613[(8)] = inst_45541);

return statearr_45613;
})();
var statearr_45614_47139 = state_45589__$1;
(statearr_45614_47139[(2)] = null);

(statearr_45614_47139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45590 === (9))){
var inst_45541 = (state_45589[(8)]);
var inst_45561 = cljs.core.vec(inst_45541);
var state_45589__$1 = state_45589;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45589__$1,(11),out,inst_45561);
} else {
if((state_val_45590 === (5))){
var inst_45545 = (state_45589[(9)]);
var inst_45542 = (state_45589[(7)]);
var inst_45549 = (state_45589[(10)]);
var inst_45549__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_45545) : f.call(null,inst_45545));
var inst_45554 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45549__$1,inst_45542);
var inst_45555 = cljs.core.keyword_identical_QMARK_(inst_45542,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_45556 = ((inst_45554) || (inst_45555));
var state_45589__$1 = (function (){var statearr_45619 = state_45589;
(statearr_45619[(10)] = inst_45549__$1);

return statearr_45619;
})();
if(cljs.core.truth_(inst_45556)){
var statearr_45620_47154 = state_45589__$1;
(statearr_45620_47154[(1)] = (8));

} else {
var statearr_45621_47155 = state_45589__$1;
(statearr_45621_47155[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45590 === (14))){
var inst_45578 = (state_45589[(2)]);
var inst_45579 = cljs.core.async.close_BANG_(out);
var state_45589__$1 = (function (){var statearr_45623 = state_45589;
(statearr_45623[(13)] = inst_45578);

return statearr_45623;
})();
var statearr_45624_47163 = state_45589__$1;
(statearr_45624_47163[(2)] = inst_45579);

(statearr_45624_47163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45590 === (10))){
var inst_45568 = (state_45589[(2)]);
var state_45589__$1 = state_45589;
var statearr_45625_47164 = state_45589__$1;
(statearr_45625_47164[(2)] = inst_45568);

(statearr_45625_47164[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45590 === (8))){
var inst_45545 = (state_45589[(9)]);
var inst_45549 = (state_45589[(10)]);
var inst_45541 = (state_45589[(8)]);
var inst_45558 = inst_45541.push(inst_45545);
var tmp45622 = inst_45541;
var inst_45541__$1 = tmp45622;
var inst_45542 = inst_45549;
var state_45589__$1 = (function (){var statearr_45629 = state_45589;
(statearr_45629[(7)] = inst_45542);

(statearr_45629[(8)] = inst_45541__$1);

(statearr_45629[(14)] = inst_45558);

return statearr_45629;
})();
var statearr_45630_47173 = state_45589__$1;
(statearr_45630_47173[(2)] = null);

(statearr_45630_47173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42649__auto__ = null;
var cljs$core$async$state_machine__42649__auto____0 = (function (){
var statearr_45631 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45631[(0)] = cljs$core$async$state_machine__42649__auto__);

(statearr_45631[(1)] = (1));

return statearr_45631;
});
var cljs$core$async$state_machine__42649__auto____1 = (function (state_45589){
while(true){
var ret_value__42650__auto__ = (function (){try{while(true){
var result__42651__auto__ = switch__42648__auto__(state_45589);
if(cljs.core.keyword_identical_QMARK_(result__42651__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42651__auto__;
}
break;
}
}catch (e45634){if((e45634 instanceof Object)){
var ex__42652__auto__ = e45634;
var statearr_45635_47193 = state_45589;
(statearr_45635_47193[(5)] = ex__42652__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_45589);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45634;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47196 = state_45589;
state_45589 = G__47196;
continue;
} else {
return ret_value__42650__auto__;
}
break;
}
});
cljs$core$async$state_machine__42649__auto__ = function(state_45589){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42649__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42649__auto____1.call(this,state_45589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42649__auto____0;
cljs$core$async$state_machine__42649__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42649__auto____1;
return cljs$core$async$state_machine__42649__auto__;
})()
})();
var state__42856__auto__ = (function (){var statearr_45637 = f__42855__auto__();
(statearr_45637[(6)] = c__42854__auto___47113);

return statearr_45637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42856__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
