import "./cljs_env.js";
shadow$provide.module$node_modules$vega_scenegraph$build$vega_scenegraph=function(global$jscomp$0,require,module,exports$jscomp$0){(function(global,factory){"object"===typeof exports$jscomp$0&&"undefined"!==typeof module?factory(exports$jscomp$0,require("module$node_modules$vega_util$build$vega_util"),require("module$node_modules$d3_shape$dist$d3_shape"),require("module$node_modules$d3_path$dist$d3_path"),require("module$node_modules$vega_canvas$build$vega_canvas"),require("module$node_modules$vega_loader$build$vega_loader"),
require("module$node_modules$vega_scale$build$vega_scale")):"function"===typeof define&&define.amd?define("exports vega-util d3-shape d3-path vega-canvas vega-loader vega-scale".split(" "),factory):(global=global||self,factory(global.vega={},global.vega,global.d3,global.d3,global.vega,global.vega,global.vega))})(this,function(exports,vegaUtil,d3Shape,d3Path,vegaCanvas,vegaLoader,vegaScale){function gradientRef(g,defs,base){let id=g.id,type=g.gradient,prefix="radial"===type?"p_":"";id||(id=g.id="gradient_"+
gradient_id++,"radial"===type?(g.x1=get(g.x1,.5),g.y1=get(g.y1,.5),g.r1=get(g.r1,0),g.x2=get(g.x2,.5),g.y2=get(g.y2,.5),g.r2=get(g.r2,.5),prefix="p_"):(g.x1=get(g.x1,0),g.y1=get(g.y1,0),g.x2=get(g.x2,1),g.y2=get(g.y2,0)));defs[id]=g;return"url("+(base||"")+"#"+prefix+id+")"}function get(val,def){return null!=val?val:def}function curves(type,orientation,tension){type=vegaUtil.hasOwnProperty(lookup,type)&&lookup[type];var curve=null;type&&(curve=type.curve||type[orientation||"vertical"],type.tension&&
null!=tension&&(curve=curve[type.tension](tension)));return curve}function pathParse(pathstr){var result=[],param,n,m;pathstr=pathstr.slice().replace(regexp[0],"###$1").split(regexp[1]).slice(1);var i=0;for(n=pathstr.length;i<n;++i){var curr=pathstr[i];var chunks=curr.slice(1).trim().replace(regexp[2],"$1###$2").split(regexp[3]);var cmd=curr.charAt(0);curr=[cmd];var j=0;for(m=chunks.length;j<m;++j)(param=+chunks[j])===param&&curr.push(param);chunks=cmdlen[cmd.toLowerCase()];if(curr.length-1>chunks)for(j=
1,m=curr.length;j<m;j+=chunks)result.push([cmd].concat(curr.slice(j,j+chunks)));else result.push(curr)}return result}function segments(x,y,rx,ry,large,sweep,rotateX,ox,oy){var key=join.call(arguments);if(segmentCache[key])return segmentCache[key];var th=rotateX*DegToRad,sin_th=Math.sin(th);th=Math.cos(th);rx=Math.abs(rx);ry=Math.abs(ry);var px=th*(ox-x)*.5+sin_th*(oy-y)*.5,py=th*(oy-y)*.5-sin_th*(ox-x)*.5;px=px*px/(rx*rx)+py*py/(ry*ry);1<px&&(px=Math.sqrt(px),rx*=px,ry*=px);var a00=th/rx,a01=sin_th/
rx,a10=-sin_th/ry,a11=th/ry;px=a00*ox+a01*oy;py=a10*ox+a11*oy;a00=a00*x+a01*y;a01=a10*x+a11*y;a10=1/((a00-px)*(a00-px)+(a01-py)*(a01-py))-.25;0>a10&&(a10=0);a11=Math.sqrt(a10);sweep==large&&(a11=-a11);a10=.5*(px+a00)-a11*(a01-py);a11=.5*(py+a01)+a11*(a00-px);px=Math.atan2(py-a11,px-a10);py=Math.atan2(a01-a11,a00-a10)-px;0>py&&1===sweep?py+=Tau:0<py&&0===sweep&&(py-=Tau);a00=Math.ceil(Math.abs(py/(HalfPi+.001)));a01=[];for(var i=0;i<a00;++i)a01[i]=[a10,a11,px+i*py/a00,px+(i+1)*py/a00,rx,ry,sin_th,
th];return segmentCache[key]=a01}function pathRender(context,path,l,t,sX,sY){var previous=null,x=0,y=0,controlX=0,controlY=0;null==l&&(l=0);null==t&&(t=0);null==sX&&(sX=1);null==sY&&(sY=sX);context.beginPath&&context.beginPath();for(var i=0,len=path.length;i<len;++i){var current=path[i];if(1!==sX||1!==sY){var tempX=sX;var tempY=sY;var c=temp[0]=current[0];if("a"===c||"A"===c)temp[1]=tempX*current[1],temp[2]=tempY*current[2],temp[3]=current[3],temp[4]=current[4],temp[5]=current[5],temp[6]=tempX*current[6],
temp[7]=tempY*current[7];else if("h"===c||"H"===c)temp[1]=tempX*current[1];else if("v"===c||"V"===c)temp[1]=tempY*current[1];else{c=1;for(var n=current.length;c<n;++c)temp[c]=(1==c%2?tempX:tempY)*current[c]}current=temp}switch(current[0]){case "l":x+=current[1];y+=current[2];context.lineTo(x+l,y+t);break;case "L":x=current[1];y=current[2];context.lineTo(x+l,y+t);break;case "h":x+=current[1];context.lineTo(x+l,y+t);break;case "H":x=current[1];context.lineTo(x+l,y+t);break;case "v":y+=current[1];context.lineTo(x+
l,y+t);break;case "V":y=current[1];context.lineTo(x+l,y+t);break;case "m":x+=current[1];y+=current[2];context.moveTo(x+l,y+t);break;case "M":x=current[1];y=current[2];context.moveTo(x+l,y+t);break;case "c":tempX=x+current[5];tempY=y+current[6];controlX=x+current[3];controlY=y+current[4];context.bezierCurveTo(x+current[1]+l,y+current[2]+t,controlX+l,controlY+t,tempX+l,tempY+t);x=tempX;y=tempY;break;case "C":x=current[5];y=current[6];controlX=current[3];controlY=current[4];context.bezierCurveTo(current[1]+
l,current[2]+t,controlX+l,controlY+t,x+l,y+t);break;case "s":tempX=x+current[3];tempY=y+current[4];controlX=2*x-controlX;controlY=2*y-controlY;context.bezierCurveTo(controlX+l,controlY+t,x+current[1]+l,y+current[2]+t,tempX+l,tempY+t);controlX=x+current[1];controlY=y+current[2];x=tempX;y=tempY;break;case "S":tempX=current[3];tempY=current[4];controlX=2*x-controlX;controlY=2*y-controlY;context.bezierCurveTo(controlX+l,controlY+t,current[1]+l,current[2]+t,tempX+l,tempY+t);x=tempX;y=tempY;controlX=current[1];
controlY=current[2];break;case "q":tempX=x+current[3];tempY=y+current[4];controlX=x+current[1];controlY=y+current[2];context.quadraticCurveTo(controlX+l,controlY+t,tempX+l,tempY+t);x=tempX;y=tempY;break;case "Q":tempX=current[3];tempY=current[4];context.quadraticCurveTo(current[1]+l,current[2]+t,tempX+l,tempY+t);x=tempX;y=tempY;controlX=current[1];controlY=current[2];break;case "t":tempX=x+current[1];tempY=y+current[2];null===previous[0].match(/[QqTt]/)?(controlX=x,controlY=y):"t"===previous[0]?(controlX=
2*x-tempControlX,controlY=2*y-tempControlY):"q"===previous[0]&&(controlX=2*x-controlX,controlY=2*y-controlY);var tempControlX=controlX;var tempControlY=controlY;context.quadraticCurveTo(controlX+l,controlY+t,tempX+l,tempY+t);x=tempX;y=tempY;controlX=x+current[1];controlY=y+current[2];break;case "T":tempX=current[1];tempY=current[2];controlX=2*x-controlX;controlY=2*y-controlY;context.quadraticCurveTo(controlX+l,controlY+t,tempX+l,tempY+t);x=tempX;y=tempY;break;case "a":drawArc(context,x+l,y+t,[current[1],
current[2],current[3],current[4],current[5],current[6]+x+l,current[7]+y+t]);x+=current[6];y+=current[7];break;case "A":drawArc(context,x+l,y+t,[current[1],current[2],current[3],current[4],current[5],current[6]+l,current[7]+t]);x=current[6];y=current[7];break;case "z":case "Z":context.closePath()}previous=current}}function drawArc(context,x,y,coords){x=segments(coords[5],coords[6],coords[0],coords[1],coords[3],coords[4],coords[2],x,y);for(y=0;y<x.length;++y){var params=x[y];coords=join.call(params);
if(bezierCache[coords])coords=bezierCache[coords];else{var cx=params[0],cy=params[1],th0=params[2],th1=params[3],rx=params[4],ry=params[5],sin_th=params[6],cos_th=params[7];params=cos_th*rx;var a01=-sin_th*ry;rx*=sin_th;ry*=cos_th;var cos_th0=Math.cos(th0),sin_th0=Math.sin(th0);sin_th=Math.cos(th1);cos_th=Math.sin(th1);th0=.5*(th1-th0);th1=Math.sin(.5*th0);th1=8/3*th1*th1/Math.sin(th0);th0=cx+cos_th0-th1*sin_th0;cos_th0=cy+sin_th0+th1*cos_th0;cx+=sin_th;cy+=cos_th;cos_th=cx+th1*cos_th;sin_th=cy-th1*
sin_th;coords=bezierCache[coords]=[params*th0+a01*cos_th0,rx*th0+ry*cos_th0,params*cos_th+a01*sin_th,rx*cos_th+ry*sin_th,params*cx+a01*cy,rx*cx+ry*cy]}context.bezierCurveTo(coords[0],coords[1],coords[2],coords[3],coords[4],coords[5])}}function symbols(_){return vegaUtil.hasOwnProperty(builtins,_)?builtins[_]:customSymbol(_)}function customSymbol(path){if(!vegaUtil.hasOwnProperty(custom,path)){var parsed=pathParse(path);custom[path]={draw:function(context,size){pathRender(context,parsed,0,0,Math.sqrt(size)/
2)}}}return custom[path]}function rectangleX(d){return d.x}function rectangleY(d){return d.y}function rectangleWidth(d){return d.width}function rectangleHeight(d){return d.height}function number(_){return"function"===typeof _?_:()=>+_}function clamp(value,min,max){return Math.max(min,Math.min(value,max))}function vg_rect(){function rectangle(_,x0,y0){var buffer;x0=null!=x0?x0:+x.call(this,_);y0=null!=y0?y0:+y.call(this,_);var w=+width.call(this,_),h=+height.call(this,_),s=Math.min(w,h)/2,tl=clamp(+crTL.call(this,
_),0,s),tr=clamp(+crTR.call(this,_),0,s),bl=clamp(+crBL.call(this,_),0,s);_=clamp(+crBR.call(this,_),0,s);context||(context=buffer=d3Path.path());0>=tl&&0>=tr&&0>=bl&&0>=_?context.rect(x0,y0,w,h):(w=x0+w,h=y0+h,context.moveTo(x0+tl,y0),context.lineTo(w-tr,y0),context.bezierCurveTo(w-.448084975506*tr,y0,w,y0+.448084975506*tr,w,y0+tr),context.lineTo(w,h-_),context.bezierCurveTo(w,h-.448084975506*_,w-.448084975506*_,h,w-_,h),context.lineTo(x0+bl,h),context.bezierCurveTo(x0+.448084975506*bl,h,x0,h-.448084975506*
bl,x0,h-bl),context.lineTo(x0,y0+tl),context.bezierCurveTo(x0,y0+.448084975506*tl,x0+.448084975506*tl,y0,x0+tl,y0),context.closePath());if(buffer)return context=null,buffer+""||null}var x=rectangleX,y=rectangleY,width=rectangleWidth,height=rectangleHeight,crTL=number(0),crTR=crTL,crBL=crTL,crBR=crTL,context=null;rectangle.x=function(_){return arguments.length?(x=number(_),rectangle):x};rectangle.y=function(_){return arguments.length?(y=number(_),rectangle):y};rectangle.width=function(_){return arguments.length?
(width=number(_),rectangle):width};rectangle.height=function(_){return arguments.length?(height=number(_),rectangle):height};rectangle.cornerRadius=function(tl,tr,br,bl){return arguments.length?(crTL=number(tl),crTR=null!=tr?number(tr):crTL,crBR=null!=br?number(br):crTL,crBL=null!=bl?number(bl):crTR,rectangle):crTL};rectangle.context=function(_){return arguments.length?(context=null==_?null:_,rectangle):context};return rectangle}function vg_trail(){function trail(data){var i,n=data.length,d,defined0=
!1,buffer;null==context&&(context=buffer=d3Path.path());for(i=0;i<=n;++i)if(!(i<n&&defined(d=data[i],i,data))===defined0&&(defined0=!defined0)&&(ready=0),defined0){var x2=+x(d,i,data),y2=+y(d,i,data),r2=+size(d,i,data)/2;if(ready){var ux=y1-y2,uy=x2-x1;if(ux||uy){var ud=Math.sqrt(ux*ux+uy*uy),rx=(ux/=ud)*r1;ud=(uy/=ud)*r1;var t=Math.atan2(uy,ux);context.moveTo(x1-rx,y1-ud);context.lineTo(x2-ux*r2,y2-uy*r2);context.arc(x2,y2,r2,t-Math.PI,t);context.lineTo(x1+rx,y1+ud);context.arc(x1,y1,r1,t,t+Math.PI)}else context.arc(x2,
y2,r2,0,Tau);context.closePath()}else ready=1;x1=x2;y1=y2;r1=r2}if(buffer)return context=null,buffer+""||null}var x,y,size,defined,context=null,ready,x1,y1,r1;trail.x=function(_){return arguments.length?(x=_,trail):x};trail.y=function(_){return arguments.length?(y=_,trail):y};trail.size=function(_){return arguments.length?(size=_,trail):size};trail.defined=function(_){return arguments.length?(defined=_,trail):defined};trail.context=function(_){return arguments.length?(context=null==_?null:_,trail):
context};return trail}function value$jscomp$0(a,b){return null!=a?a:b}function hasCornerRadius(item){return item.cornerRadius||item.cornerRadiusTopLeft||item.cornerRadiusTopRight||item.cornerRadiusBottomRight||item.cornerRadiusBottomLeft}function rectangle$jscomp$0(context,item,x,y){return rectShape.context(context)(item,x,y)}function clip(renderer,item,size){var clip=item.clip;renderer=renderer._defs;item=item.clip_id||(item.clip_id="clip"+clip_id++);renderer=renderer.clipping[item]||(renderer.clipping[item]=
{id:item});vegaUtil.isFunction(clip)?renderer.path=clip(null):hasCornerRadius(size)?renderer.path=rectangle$jscomp$0(null,size,0,0):(renderer.width=size.width||0,renderer.height=size.height||0);return"url(#"+item+")"}function Bounds(b){this.clear();b&&this.union(b)}function Item(mark){this.mark=mark;this.bounds=this.bounds||new Bounds}function GroupItem(mark){Item.call(this,mark);this.items=this.items||[]}function ResourceLoader(customLoader){this._pending=0;this._loader=customLoader||vegaLoader.loader()}
function boundStroke(bounds,item,miter){if(item.stroke&&0!==item.opacity&&0!==item.strokeOpacity){const sw=null!=item.strokeWidth?+item.strokeWidth:1;bounds.expand(sw+(miter?item.strokeJoin&&"miter"!==item.strokeJoin?0:sw:0))}return bounds}function context$jscomp$0(_){bounds$jscomp$0=_;return context$jscomp$0}function noop(){}function addL(x,y){x=lx=x;y=ly=y;bounds$jscomp$0.add(x,y)}function addX(x){bounds$jscomp$0.add(x,bounds$jscomp$0.y1)}function addY(y){bounds$jscomp$0.add(bounds$jscomp$0.x1,
y)}function quadExtrema(x0,x1,x2,cb){x2=(x0-x1)/(x0+x2-2*x1);0<x2&&1>x2&&cb(x0+(x1-x0)*x2)}function cubicExtrema(x0,x1,x2,x3,cb){const a=x3-x0+3*x1-3*x2,b=x0+x2-2*x1;var c=x0-x1;let t0=0,t1=0;1E-14<Math.abs(a)?(c=b*b+c*a,0<=c&&(c=Math.sqrt(c),t0=(-b+c)/a,t1=(-b-c)/a)):t0=.5*c/b;0<t0&&1>t0&&cb(cubic(t0,x0,x1,x2,x3));0<t1&&1>t1&&cb(cubic(t1,x0,x1,x2,x3))}function cubic(t,x0,x1,x2,x3){const s=1-t,s2=s*s,t2=t*t;return s2*s*x0+3*s2*t*x1+3*s*t2*x2+t2*t*x3}function intersectPath(draw){return function(item,
brush){if(!context$1)return!0;draw(context$1,item);b$jscomp$0.clear().union(item.bounds).intersect(brush).round();const {x1,y1,x2,y2}=b$jscomp$0;for(item=y1;item<=y2;++item)for(brush=x1;brush<=x2;++brush)if(context$1.isPointInPath(brush,item))return!0;return!1}}function intersectPoint(item,box){return box.contains(item.x||0,item.y||0)}function intersectRect(item,box){const x=item.x||0,y=item.y||0;return box.intersects(b$jscomp$0.set(x,y,x+(item.width||0),y+(item.height||0)))}function intersectRule(item,
box){const x=item.x||0,y=item.y||0;return intersectBoxLine(box,x,y,null!=item.x2?item.x2:x,null!=item.y2?item.y2:y)}function intersectBoxLine(box,x,y,u,v){const {x1,y1,x2,y2}=box;box=u-x;v-=y;u=0;let t1=1,p,q,r,e;for(e=0;4>e;++e){0===e&&(p=-box,q=-(x1-x));1===e&&(p=box,q=x2-x);2===e&&(p=-v,q=-(y1-y));3===e&&(p=v,q=y2-y);if(1E-10>Math.abs(p)&&0>q)return!1;r=q/p;if(0>p){if(r>t1)return!1;r>u&&(u=r)}else if(0<p){if(r<u)return!1;r<t1&&(t1=r)}}return!0}function blend(context,item){context.globalCompositeOperation=
item.blend||"source-over"}function value$1(value,dflt){return null==value?dflt:value}function addStops(gradient,stops){const n=stops.length;for(let i=0;i<n;++i)gradient.addColorStop(stops[i].offset,stops[i].color);return gradient}function gradient(context,spec,bounds){const w=bounds.width(),h=bounds.height();if("radial"===spec.gradient)context=context.createRadialGradient(bounds.x1+value$1(spec.x1,.5)*w,bounds.y1+value$1(spec.y1,.5)*h,Math.max(w,h)*value$1(spec.r1,0),bounds.x1+value$1(spec.x2,.5)*
w,bounds.y1+value$1(spec.y2,.5)*h,Math.max(w,h)*value$1(spec.r2,.5));else{const x1=value$1(spec.x1,0),y1=value$1(spec.y1,0),x2=value$1(spec.x2,1),y2=value$1(spec.y2,0);if(x1===x2||y1===y2||w===h)context=context.createLinearGradient(bounds.x1+x1*w,bounds.y1+y1*h,bounds.x1+x2*w,bounds.y1+y2*h);else{bounds=vegaCanvas.canvas(Math.ceil(w),Math.ceil(h));const ictx=bounds.getContext("2d");ictx.scale(w,h);ictx.fillStyle=addStops(ictx.createLinearGradient(x1,y1,x2,y2),spec.stops);ictx.fillRect(0,0,w,h);return context.createPattern(bounds,
"no-repeat")}}return addStops(context,spec.stops)}function fill$jscomp$0(context,item,opacity){opacity*=null==item.fillOpacity?1:item.fillOpacity;return 0<opacity?(context.globalAlpha=opacity,item=(opacity=item.fill)&&opacity.gradient?gradient(context,opacity,item.bounds):opacity,context.fillStyle=item,!0):!1}function stroke$jscomp$0(context,item,opacity){var lw=null!=(lw=item.strokeWidth)?lw:1;if(0>=lw)return!1;opacity*=null==item.strokeOpacity?1:item.strokeOpacity;return 0<opacity?(context.globalAlpha=
opacity,opacity=(opacity=item.stroke)&&opacity.gradient?gradient(context,opacity,item.bounds):opacity,context.strokeStyle=opacity,context.lineWidth=lw,context.lineCap=item.strokeCap||"butt",context.lineJoin=item.strokeJoin||"miter",context.miterLimit=item.strokeMiterLimit||10,context.setLineDash&&(context.setLineDash(item.strokeDash||Empty),context.lineDashOffset=item.strokeDashOffset||0),!0):!1}function compare(a,b){return a.zindex-b.zindex||a.index-b.index}function zorder(scene){if(!scene.zdirty)return scene.zitems;
var items=scene.items,output=[],n;var i=0;for(n=items.length;i<n;++i){var item=items[i];item.index=i;item.zindex&&output.push(item)}scene.zdirty=!1;return scene.zitems=output.sort(compare)}function visit(scene,visitor){var items=scene.items,n;if(items&&items.length){var zitems=zorder(scene);if(zitems&&zitems.length){scene=0;for(n=items.length;scene<n;++scene)items[scene].zindex||visitor(items[scene]);items=zitems}scene=0;for(n=items.length;scene<n;++scene)visitor(items[scene])}}function pickVisit(scene,
visitor){var items=scene.items,hit,i;if(!items||!items.length)return null;var zitems=zorder(scene);zitems&&zitems.length&&(items=zitems);for(i=items.length;0<=--i;)if(hit=visitor(items[i]))return hit;if(items===zitems)for(items=scene.items,i=items.length;0<=--i;)if(!items[i].zindex&&(hit=visitor(items[i])))return hit;return null}function drawAll(path){return function(context,scene,bounds){visit(scene,function(item){bounds&&!bounds.intersects(item.bounds)||drawPath(path,context,item,item)})}}function drawOne(path){return function(context,
scene,bounds){!scene.items.length||bounds&&!bounds.intersects(scene.bounds)||drawPath(path,context,scene.items[0],scene.items)}}function drawPath(path,context,item,items){var opacity=null==item.opacity?1:item.opacity;0===opacity||path(context,items)||(blend(context,item),item.fill&&fill$jscomp$0(context,item,opacity)&&context.fill(),item.stroke&&stroke$jscomp$0(context,item,opacity)&&context.stroke())}function pick(test){test=test||vegaUtil.truthy;return function(context,scene,x,y,gx,gy){x*=context.pixelRatio;
y*=context.pixelRatio;return pickVisit(scene,function(item){var b=item.bounds;if((!b||b.contains(gx,gy))&&b&&test(context,item,x,y,gx,gy))return item})}}function hitPath(path,filled){return function(context,o,x,y){var item=Array.isArray(o)?o[0]:o,fill=null==filled?item.fill:filled,stroke=item.stroke&&context.isPointInStroke;if(stroke){var lw=item.strokeWidth;item=item.strokeCap;context.lineWidth=null!=lw?lw:1;context.lineCap=null!=item?item:"butt"}return path(context,o)?!1:fill&&context.isPointInPath(x,
y)||stroke&&context.isPointInStroke(x,y)}}function translate(x,y){return"translate("+x+","+y+")"}function transformItem(item){return translate(item.x||0,item.y||0)+(item.angle?" rotate("+(item.angle+")"):"")+(item.scaleX||item.scaleY?" scale("+((item.scaleX||1)+","+(item.scaleY||1)+")"):"")}function markItemPath(type,shape,isect){function draw(context,item){var x=item.x||0,y=item.y||0,a=item.angle||0;context.translate(x,y);a&&context.rotate(a*=DegToRad);context.beginPath();shape(context,item);a&&
context.rotate(-a);context.translate(-x,-y)}return{type,tag:"path",nested:!1,attr:function(emit,item){emit("transform",transformItem(item));emit("d",shape(null,item))},bound:function(bounds,item){var x=item.x||0,y=item.y||0;shape(context$jscomp$0(bounds),item);boundStroke(bounds,item).translate(x,y);item.angle&&bounds.rotate(item.angle*DegToRad,x,y);return bounds},draw:drawAll(draw),pick:pick(hitPath(draw)),isect:isect||intersectPath(draw)}}function markMultiItemPath(type,shape,tip){function draw(context,
items){context.beginPath();shape(context,items)}var hit=hitPath(draw);return{type,tag:"path",nested:!0,attr:function(emit,item){item=item.mark.items;item.length&&emit("d",shape(null,item))},bound:function(bounds,mark){mark=mark.items;if(0===mark.length)return bounds;shape(context$jscomp$0(bounds),mark);return boundStroke(bounds,mark[0])},draw:drawOne(draw),pick:function(context,scene,x,y,gx,gy){var items=scene.items;scene=scene.bounds;if(!items||!items.length||scene&&!scene.contains(gx,gy))return null;
x*=context.pixelRatio;y*=context.pixelRatio;return hit(context,items,x,y)?items[0]:null},isect:intersectPoint,tip}}function clipGroup(context,group){context.beginPath();hasCornerRadius(group)?rectangle$jscomp$0(context,group,0,0):context.rect(0,0,group.width||0,group.height||0);context.clip()}function offset$jscomp$0(item){const sw=value$1(item.strokeWidth,1);return null!=item.strokeOffset?item.strokeOffset:item.stroke&&.5<sw&&1.5>sw?.5-Math.abs(sw-1):0}function rectanglePath(context,group,x,y){const off=
offset$jscomp$0(group);context.beginPath();rectangle$jscomp$0(context,group,(x||0)+off,(y||0)+off)}function getImage(item,renderer){var image$jscomp$0=item.image;if(!image$jscomp$0||item.url&&item.url!==image$jscomp$0.url)image$jscomp$0={complete:!1,width:0,height:0},renderer.loadImage(item.url).then(image=>{item.image=image;item.image.url=item.url});return image$jscomp$0}function imageWidth(item,image){return null!=item.width?item.width:image&&image.width?!1!==item.aspect&&item.height?item.height*
image.width/image.height:image.width:0}function imageHeight(item,image){return null!=item.height?item.height:image&&image.height?!1!==item.aspect&&item.width?item.width*image.height/image.width:image.height:0}function imageXOffset(align,w){return"center"===align?w/2:"right"===align?w:0}function imageYOffset(baseline,h){return"middle"===baseline?h/2:"bottom"===baseline?h:0}function path$jscomp$0(context,item){var path=item.path;if(null==path)return!0;var x=item.x||0,y=item.y||0,sx=item.scaleX||1,sy=
item.scaleY||1,a=(item.angle||0)*DegToRad,cache=item.pathCache;cache&&cache.path===path||((item.pathCache=cache=pathParse(path)).path=path);a&&context.rotate&&context.translate?(context.translate(x,y),context.rotate(a),pathRender(context,cache,0,0,sx,sy),context.rotate(-a),context.translate(-x,-y)):pathRender(context,cache,x,y,sx,sy)}function draw$2(context,item){context.beginPath();rectangle$jscomp$0(context,item)}function path$2(context,item,opacity){if(item.stroke&&stroke$jscomp$0(context,item,
opacity)){opacity=item.x||0;var y1=item.y||0;var x2=null!=item.x2?item.x2:opacity;item=null!=item.y2?item.y2:y1;context.beginPath();context.moveTo(opacity,y1);context.lineTo(x2,item);return!0}return!1}function useCanvas(use){textMetrics.width=use&&context$1?measureWidth:estimateWidth}function estimateWidth(item,text){text=textValue(item,text);item=fontSize(item);return~~(.8*text.length*item)}function measureWidth(item,text){return 0>=fontSize(item)||!(text=textValue(item,text))?0:_measureWidth(text,
font(item))}function _measureWidth(text,currentFont){const key=`(${currentFont}) ${text}`;let width=widthCache.get(key);void 0===width&&(context$1.font=currentFont,width=context$1.measureText(text).width,widthCache.set(key,width));return width}function fontSize(item){return null!=item.fontSize?+item.fontSize||0:11}function lineHeight(item){return null!=item.lineHeight?item.lineHeight:fontSize(item)+2}function textLines(item){item=item.lineBreak&&item.text&&!vegaUtil.isArray(item.text)?item.text.split(item.lineBreak):
item.text;return vegaUtil.isArray(item)?1<item.length?item:item[0]:item}function textValue(item,line){line=null==line?"":(line+"").trim();if(0<item.limit&&line.length){var limit=+item.limit,width=widthGetter(item);if(!(width(line)<limit)){var ellipsis=item.ellipsis||"…",rtl="rtl"===item.dir;item=0;var hi=line.length;limit-=width(ellipsis);if(rtl){for(;item<hi;)rtl=item+hi>>>1,width(line.slice(rtl))>limit?item=rtl+1:hi=rtl;line=ellipsis+line.slice(item)}else{for(;item<hi;)rtl=1+(item+hi>>>1),width(line.slice(0,
rtl))<limit?item=rtl:hi=rtl-1;line=line.slice(0,item)+ellipsis}}}return line}function widthGetter(item){if(textMetrics.width===measureWidth){const currentFont=font(item);return text=>_measureWidth(text,currentFont)}{const currentFontHeight=fontSize(item);return text=>~~(.8*text.length*currentFontHeight)}}function fontFamily(item,quote){item=item.font;return(quote&&item?String(item).replace(/"/g,"'"):item)||"sans-serif"}function font(item,quote){return(item.fontStyle?item.fontStyle+" ":"")+(item.fontVariant?
item.fontVariant+" ":"")+(item.fontWeight?item.fontWeight+" ":"")+fontSize(item)+"px "+fontFamily(item,quote)}function offset$1(item){var baseline=item.baseline,h=fontSize(item);return Math.round("top"===baseline?.79*h:"middle"===baseline?.3*h:"bottom"===baseline?-.21*h:"line-top"===baseline?.29*h+.5*lineHeight(item):"line-bottom"===baseline?.29*h-.5*lineHeight(item):0)}function anchorPoint(item){var x=item.x||0,y=item.y||0,r=item.radius||0;r&&(item=(item.theta||0)-HalfPi,x+=r*Math.cos(item),y+=r*
Math.sin(item));tempBounds.x1=x;tempBounds.y1=y;return tempBounds}function bound$5(bounds,item,mode){var h=textMetrics.height(item),a=item.align,p=anchorPoint(item),x=p.x1;p=p.y1;var dx=item.dx||0,dy=(item.dy||0)+offset$1(item)-Math.round(.8*h),tl=textLines(item);vegaUtil.isArray(tl)?(h+=lineHeight(item)*(tl.length-1),tl=tl.reduce((w,t)=>Math.max(w,textMetrics.width(item,t)),0)):tl=textMetrics.width(item,tl);"center"===a?dx-=tl/2:"right"===a&&(dx-=tl);bounds.set(dx+=x,dy+=p,dx+tl,dy+h);if(item.angle&&
!mode)bounds.rotate(item.angle*DegToRad,x,p);else if(2===mode)return bounds.rotatedPoints(item.angle*DegToRad,x,p);return bounds}function boundItem(item,func,opt){var type=Marks[item.mark.marktype];func=func||type.bound;type.nested&&(item=item.mark);return func(item.bounds||(item.bounds=new Bounds),item,opt)}function boundMark(mark,bounds,opt){var type=Marks[mark.marktype],bound=type.bound,items=mark.items,hasItems=items&&items.length;if(type.nested)return hasItems?mark=items[0]:(DUMMY.mark=mark,
mark=DUMMY),opt=boundItem(mark,bound,opt),bounds=bounds&&bounds.union(opt)||opt;bounds=bounds||mark.bounds&&mark.bounds.clear()||new Bounds;if(hasItems)for(type=0,hasItems=items.length;type<hasItems;++type)bounds.union(boundItem(items[type],bound,opt));return mark.bounds=bounds}function sceneToJSON(scene,indent){return JSON.stringify(scene,keys,indent)}function sceneFromJSON(json){json="string"===typeof json?JSON.parse(json):json;return initialize(json)}function initialize(scene){var type=scene.marktype,
items=scene.items,n;if(items){var i=0;for(n=items.length;i<n;++i){var parent=type?"mark":"group";items[i][parent]=scene;items[i].zindex&&(items[i][parent].zdirty=!0);"group"===(type||parent)&&initialize(items[i])}}type&&boundMark(scene);return scene}function Scenegraph(scene){arguments.length?this.root=sceneFromJSON(scene):(this.root=createMark({marktype:"group",name:"root",role:"frame"}),this.root.items=[new GroupItem(this.root)])}function createMark(def,group){group={bounds:new Bounds,clip:!!def.clip,
group,interactive:!1===def.interactive?!1:!0,items:[],marktype:def.marktype,name:def.name||void 0,role:def.role||void 0,zindex:def.zindex||0};null!=def.aria&&(group.aria=def.aria);def.description&&(group.description=def.description);return group}function domCreate(doc,tag,ns){!doc&&"undefined"!==typeof document&&document.createElement&&(doc=document);return doc?ns?doc.createElementNS(ns,tag):doc.createElement(tag):null}function domFind(el,tag){tag=tag.toLowerCase();el=el.childNodes;for(var i=0,n=
el.length;i<n;++i)if(el[i].tagName.toLowerCase()===tag)return el[i]}function domChild(el,index,tag,ns){index=el.childNodes[index];if(!index||index.tagName.toLowerCase()!==tag.toLowerCase()){var b=index||null;index=domCreate(el.ownerDocument,tag,ns);el.insertBefore(index,b)}return index}function domClear(el,index){for(var nodes=el.childNodes,curr=nodes.length;curr>index;)el.removeChild(nodes[--curr]);return el}function cssClass(mark){return"mark-"+mark.marktype+(mark.role?" role-"+mark.role:"")+(mark.name?
" "+mark.name:"")}function point(event,el){var rect=el.getBoundingClientRect();return[event.clientX-rect.left-(el.clientLeft||0),event.clientY-rect.top-(el.clientTop||0)]}function Handler(customLoader,customTooltip){this._active=null;this._handlers={};this._loader=customLoader||vegaLoader.loader();this._tooltip=customTooltip||defaultTooltip}function defaultTooltip(handler,event,item,value){handler.element().setAttribute("title",value||"")}function Renderer(loader){this._bgcolor=this._el=null;this._loader=
new ResourceLoader(loader)}function CanvasHandler(loader,tooltip){Handler.call(this,loader,tooltip);this._touch=this._down=null;this._first=!0;this._events={}}function eventListenerCheck(handler,type){("touchstart"===type||"touchmove"===type||"touchend"===type?["touchstart","touchmove","touchend"]:[type]).forEach(_=>addEventListener(handler,_))}function addEventListener(handler,type){const canvas=handler.canvas();canvas&&!handler._events[type]&&(handler._events[type]=1,canvas.addEventListener(type,
handler[type]?evt=>handler[type](evt):evt=>handler.fire(type,evt)))}function move(moveEvent,overEvent,outEvent){return function(evt){const a=this._active,p=this.pickEvent(evt);p!==a&&(a&&a.exit||this.fire(outEvent,evt),this._active=p,this.fire(overEvent,evt));this.fire(moveEvent,evt)}}function inactive(type){return function(evt){this.fire(type,evt);this._active=null}}function CanvasRenderer(loader){Renderer.call(this,loader);this._options={};this._redraw=!1;this._dirty=new Bounds;this._tempb=new Bounds}
function SVGHandler(loader,tooltip){Handler.call(this,loader,tooltip);const h=this;h._hrefHandler=listener(h,(evt,item)=>{item&&item.href&&h.handleHref(evt,item,item.href)});h._tooltipHandler=listener(h,(evt,item)=>{h.handleTooltip(evt,item,"mouseout"!==evt.type)})}function ariaItemAttributes(emit,item){var hide=!1===item.aria;emit("aria-hidden",hide||void 0);if(hide||null==item.description)for(const prop in AriaEncode)emit(AriaEncode[prop],void 0);else hide=item.mark.marktype,emit("aria-label",item.description),
emit("role",item.ariaRole||("group"===hide?"graphics-object":"graphics-symbol")),emit("aria-roledescription",item.ariaRoleDescription||`${hide} mark`)}function ariaMarkAttributes(mark){return!1===mark.aria?{["aria-hidden"]:!0}:AriaIgnore[mark.role]?null:AriaGuides[mark.role]?ariaGuide(mark,AriaGuides[mark.role]):ariaMark(mark)}function ariaMark(mark){const type=mark.marktype,recurse="group"===type||"text"===type||mark.items.some(_=>null!=_.description&&!1!==_.aria);return bundle(recurse?"graphics-object":
"graphics-symbol",`${type} mark container`,mark.description)}function ariaGuide(mark,opt){try{const item=mark.items[0],caption=opt.caption||(()=>"");return bundle(opt.role||"graphics-symbol",opt.desc,item.description||caption(item))}catch(err){return null}}function extractTitle(item){try{return vegaUtil.array(vegaUtil.peek(item.items).items[0].text).join(" ")}catch(err){return null}}function channelCaption(props){props=props.map(p=>p+("fill"===p||"stroke"===p?" color":""));return 2>props.length?props[0]:
props.slice(0,-1).join(", ")+" and "+vegaUtil.peek(props)}function openTag(tag,attr,raw){tag="\x3c"+tag;var key;if(attr)for(key in attr){var val=attr[key];null!=val&&(tag+=" "+key+'\x3d"'+(val+"").replace(/&/g,"\x26amp;").replace(/"/g,"\x26quot;")+'"')}raw&&(tag+=" "+raw);return tag+"\x3e"}function closeTag(tag){return"\x3c/"+tag+"\x3e"}function SVGRenderer(loader){Renderer.call(this,loader);this._dirtyID=0;this._dirty=[];this._defs=this._root=this._svg=null}function dirtyParents(item,id){for(;item&&
item.dirty!==id;item=item.mark.group)if(item.dirty=id,item.mark&&item.mark.dirty!==id)item.mark.dirty=id;else break}function recurse$jscomp$0(renderer,el,group){el=el.lastChild.previousSibling;let prev,idx=0;visit(group,item=>{prev=renderer.draw(el,item,prev);++idx});domClear(el,1+idx)}function bind(item,el,sibling,tag,svg){let node=item._svg;if(!node){var doc=el.ownerDocument;node=domCreate(doc,tag,ns);item._svg=node;item.mark&&(node.__data__=item,node.__values__={fill:"default"},"g"===tag&&(tag=
domCreate(doc,"path",ns),node.appendChild(tag),tag.__data__=item,tag=domCreate(doc,"g",ns),node.appendChild(tag),tag.__data__=item,doc=domCreate(doc,"path",ns),node.appendChild(doc),doc.__data__=item,doc.__values__={fill:"default"}))}(node.ownerSVGElement!==svg||node.parentNode&&1<node.parentNode.childNodes.length&&node.previousSibling!=sibling)&&el.insertBefore(node,sibling?sibling.nextSibling:el.firstChild);return node}function setStyle(el,name,value){value!==values[name]&&(null==value?el.style.removeProperty(name):
el.style.setProperty(name,value+""),values[name]=value)}function emit(name,value,ns){if(value!==values[name]){if(ns){var el=element;null!=value?el.setAttributeNS(ns,name,value):el.removeAttributeNS(ns,name)}else setAttribute(element,name,value);values[name]=value}}function setAttribute(el,name,value){null!=value?el.setAttribute(name,value):el.removeAttribute(name)}function href(){let loc;return"undefined"===typeof window?"":(loc=window.location).hash?loc.href.slice(0,-loc.hash.length):loc.href}function SVGStringRenderer(loader){Renderer.call(this,
loader);this._text={head:"",bg:"",root:"",foot:"",defs:"",body:""};this._defs={gradient:{},clipping:{}}}function applyStyles(s,item,scene,tag,defs){if(null==item)return s;"bgrect"===tag&&!1===scene.interactive&&(s["pointer-events"]="none");if("bgfore"===tag&&(!1===scene.interactive&&(s["pointer-events"]="none"),s.display="none",null!==item.fill))return s;"image"===tag&&!1===item.smooth&&(s.style="image-rendering: optimizeSpeed; image-rendering: pixelated;");"text"===tag&&(s["font-family"]=fontFamily(item),
s["font-size"]=fontSize(item)+"px",item.fontStyle&&(s["font-style"]=item.fontStyle),item.fontVariant&&(s["font-variant"]=item.fontVariant),item.fontWeight&&(s["font-weight"]=item.fontWeight));for(const prop in styles)scene=item[prop],tag=styles[prop],("transparent"!==scene||"fill"!==tag&&"stroke"!==tag)&&null!=scene&&(scene&&scene.gradient&&(scene=gradientRef(scene,defs.gradient,"")),s[tag]=scene);return s}function escape_text(s){return s.replace(/&/g,"\x26amp;").replace(/</g,"\x26lt;").replace(/>/g,
"\x26gt;")}function intersectMark(mark,box,filter,hits){if(mark.bounds&&box.intersects(mark.bounds)&&("group"===mark.marktype||!1!==mark.interactive&&(!filter||filter(mark)))){const items=mark.items;var type=mark.marktype;mark=items.length;let i=0;if("group"===type)for(;i<mark;++i)intersectGroup(items[i],box,filter,hits);else for(filter=Marks[type].isect;i<mark;++i)type=items[i],intersectItem(type,box,filter)&&hits.push(type)}return hits}function intersectGroup(group,box,filter,hits){filter&&filter(group.mark)&&
intersectItem(group,box,Marks.group.isect)&&hits.push(group);const marks=group.items,n=marks&&marks.length;if(n){const x=group.x||0;group=group.y||0;box.translate(-x,-group);for(let i=0;i<n;++i)intersectMark(marks[i],box,filter,hits);box.translate(x,group)}return hits}function intersectItem(item,box,test){const bounds=item.bounds;return box.encloses(bounds)||box.intersects(bounds)&&test(item,box)}function sceneEqual(a,b,key){return a===b?!0:"path"===key?pathEqual(a,b):a instanceof Date&&b instanceof
Date?+a===+b:vegaUtil.isNumber(a)&&vegaUtil.isNumber(b)?1E-9>=Math.abs(a-b):a&&b&&(vegaUtil.isObject(a)||vegaUtil.isObject(b))?null==a||null==b?!1:objectEqual(a,b):a==b}function pathEqual(a,b){return sceneEqual(pathParse(a),pathParse(b))}function objectEqual(a,b){var ka=Object.keys(a),kb=Object.keys(b),i;if(ka.length!==kb.length)return!1;ka.sort();kb.sort();for(i=ka.length-1;0<=i;i--)if(ka[i]!=kb[i])return!1;for(i=ka.length-1;0<=i;i--)if(kb=ka[i],!sceneEqual(a[kb],b[kb],kb))return!1;return typeof a===
typeof b}var gradient_id=0,lookup={basis:{curve:d3Shape.curveBasis},"basis-closed":{curve:d3Shape.curveBasisClosed},"basis-open":{curve:d3Shape.curveBasisOpen},bundle:{curve:d3Shape.curveBundle,tension:"beta",value:.85},cardinal:{curve:d3Shape.curveCardinal,tension:"tension",value:0},"cardinal-open":{curve:d3Shape.curveCardinalOpen,tension:"tension",value:0},"cardinal-closed":{curve:d3Shape.curveCardinalClosed,tension:"tension",value:0},"catmull-rom":{curve:d3Shape.curveCatmullRom,tension:"alpha",
value:.5},"catmull-rom-closed":{curve:d3Shape.curveCatmullRomClosed,tension:"alpha",value:.5},"catmull-rom-open":{curve:d3Shape.curveCatmullRomOpen,tension:"alpha",value:.5},linear:{curve:d3Shape.curveLinear},"linear-closed":{curve:d3Shape.curveLinearClosed},monotone:{horizontal:d3Shape.curveMonotoneY,vertical:d3Shape.curveMonotoneX},natural:{curve:d3Shape.curveNatural},step:{curve:d3Shape.curveStep},"step-after":{curve:d3Shape.curveStepAfter},"step-before":{curve:d3Shape.curveStepBefore}},cmdlen=
{m:2,l:2,h:1,v:1,c:6,s:4,q:4,t:2,a:7},regexp=[/([MLHVCSQTAZmlhvcsqtaz])/g,/###/,/(\d)([-+])/g,/\s|,|###/];const DegToRad=Math.PI/180,HalfPi=Math.PI/2,Tau=2*Math.PI,HalfSqrt3=Math.sqrt(3)/2;var segmentCache={},bezierCache={},join=[].join,temp=["l",0,0,0,0,0,0,0],builtins={circle:{draw:function(context,size){size=Math.sqrt(size)/2;context.moveTo(size,0);context.arc(0,0,size,0,Tau)}},cross:{draw:function(context,size){size=Math.sqrt(size)/2;var s=size/2.5;context.moveTo(-size,-s);context.lineTo(-size,
s);context.lineTo(-s,s);context.lineTo(-s,size);context.lineTo(s,size);context.lineTo(s,s);context.lineTo(size,s);context.lineTo(size,-s);context.lineTo(s,-s);context.lineTo(s,-size);context.lineTo(-s,-size);context.lineTo(-s,-s);context.closePath()}},diamond:{draw:function(context,size){size=Math.sqrt(size)/2;context.moveTo(-size,0);context.lineTo(0,-size);context.lineTo(size,0);context.lineTo(0,size);context.closePath()}},square:{draw:function(context,size){size=Math.sqrt(size);var x=-size/2;context.rect(x,
x,size,size)}},arrow:{draw:function(context,size){size=Math.sqrt(size)/2;var s=size/7,t=size/2.5,v=size/8;context.moveTo(-s,size);context.lineTo(s,size);context.lineTo(s,-v);context.lineTo(t,-v);context.lineTo(0,-size);context.lineTo(-t,-v);context.lineTo(-s,-v);context.closePath()}},wedge:{draw:function(context,size){var r=Math.sqrt(size)/2;size=HalfSqrt3*r;var o=size-.5773502691896257*r;r/=4;context.moveTo(0,-size-o);context.lineTo(-r,size-o);context.lineTo(r,size-o);context.closePath()}},triangle:{draw:function(context,
size){size=Math.sqrt(size)/2;var h=HalfSqrt3*size,o=h-.5773502691896257*size;context.moveTo(0,-h-o);context.lineTo(-size,h-o);context.lineTo(size,h-o);context.closePath()}},"triangle-up":{draw:function(context,size){size=Math.sqrt(size)/2;var h=HalfSqrt3*size;context.moveTo(0,-h);context.lineTo(-size,h);context.lineTo(size,h);context.closePath()}},"triangle-down":{draw:function(context,size){size=Math.sqrt(size)/2;var h=HalfSqrt3*size;context.moveTo(0,h);context.lineTo(-size,-h);context.lineTo(size,
-h);context.closePath()}},"triangle-right":{draw:function(context,size){size=Math.sqrt(size)/2;var h=HalfSqrt3*size;context.moveTo(h,0);context.lineTo(-h,-size);context.lineTo(-h,size);context.closePath()}},"triangle-left":{draw:function(context,size){size=Math.sqrt(size)/2;var h=HalfSqrt3*size;context.moveTo(-h,0);context.lineTo(h,-size);context.lineTo(h,size);context.closePath()}},stroke:{draw:function(context,size){size=Math.sqrt(size)/2;context.moveTo(-size,0);context.lineTo(size,0)}}},custom=
{};const x$jscomp$0=item=>item.x||0,y$jscomp$0=item=>item.y||0,def$jscomp$0=item=>!1!==item.defined,arcShape=d3Shape.arc().startAngle(item=>item.startAngle||0).endAngle(item=>item.endAngle||0).padAngle(item=>item.padAngle||0).innerRadius(item=>item.innerRadius||0).outerRadius(item=>item.outerRadius||0).cornerRadius(item=>item.cornerRadius||0),areavShape=d3Shape.area().x(x$jscomp$0).y1(y$jscomp$0).y0(item=>(item.y||0)+(item.height||0)).defined(def$jscomp$0),areahShape=d3Shape.area().y(y$jscomp$0).x1(x$jscomp$0).x0(item=>
(item.x||0)+(item.width||0)).defined(def$jscomp$0),lineShape=d3Shape.line().x(x$jscomp$0).y(y$jscomp$0).defined(def$jscomp$0),rectShape=vg_rect().x(x$jscomp$0).y(y$jscomp$0).width(item=>item.width||0).height(item=>item.height||0).cornerRadius(item=>value$jscomp$0(item.cornerRadiusTopLeft,item.cornerRadius)||0,item=>value$jscomp$0(item.cornerRadiusTopRight,item.cornerRadius)||0,item=>value$jscomp$0(item.cornerRadiusBottomRight,item.cornerRadius)||0,item=>value$jscomp$0(item.cornerRadiusBottomLeft,
item.cornerRadius)||0),symbolShape=d3Shape.symbol().type(item=>symbols(item.shape||"circle")).size(item=>value$jscomp$0(item.size,64)),trailShape=vg_trail().x(x$jscomp$0).y(y$jscomp$0).defined(def$jscomp$0).size(item=>item.size||1);var clip_id=1,prototype=Bounds.prototype;prototype.clone=function(){return new Bounds(this)};prototype.clear=function(){this.x1=+Number.MAX_VALUE;this.y1=+Number.MAX_VALUE;this.x2=-Number.MAX_VALUE;this.y2=-Number.MAX_VALUE;return this};prototype.empty=function(){return this.x1===
+Number.MAX_VALUE&&this.y1===+Number.MAX_VALUE&&this.x2===-Number.MAX_VALUE&&this.y2===-Number.MAX_VALUE};prototype.equals=function(b){return this.x1===b.x1&&this.y1===b.y1&&this.x2===b.x2&&this.y2===b.y2};prototype.set=function(x1,y1,x2,y2){x2<x1?(this.x2=x1,this.x1=x2):(this.x1=x1,this.x2=x2);y2<y1?(this.y2=y1,this.y1=y2):(this.y1=y1,this.y2=y2);return this};prototype.add=function(x,y){x<this.x1&&(this.x1=x);y<this.y1&&(this.y1=y);x>this.x2&&(this.x2=x);y>this.y2&&(this.y2=y);return this};prototype.expand=
function(d){this.x1-=d;this.y1-=d;this.x2+=d;this.y2+=d;return this};prototype.round=function(){this.x1=Math.floor(this.x1);this.y1=Math.floor(this.y1);this.x2=Math.ceil(this.x2);this.y2=Math.ceil(this.y2);return this};prototype.scale=function(s){this.x1*=s;this.y1*=s;this.x2*=s;this.y2*=s;return this};prototype.translate=function(dx,dy){this.x1+=dx;this.x2+=dx;this.y1+=dy;this.y2+=dy;return this};prototype.rotate=function(angle,x,y){angle=this.rotatedPoints(angle,x,y);return this.clear().add(angle[0],
angle[1]).add(angle[2],angle[3]).add(angle[4],angle[5]).add(angle[6],angle[7])};prototype.rotatedPoints=function(angle,x,y){var {x1,y1,x2,y2}=this,cos=Math.cos(angle);angle=Math.sin(angle);var cx=x-x*cos+y*angle;x=y-x*angle-y*cos;return[cos*x1-angle*y1+cx,angle*x1+cos*y1+x,cos*x1-angle*y2+cx,angle*x1+cos*y2+x,cos*x2-angle*y1+cx,angle*x2+cos*y1+x,cos*x2-angle*y2+cx,angle*x2+cos*y2+x]};prototype.union=function(b){b.x1<this.x1&&(this.x1=b.x1);b.y1<this.y1&&(this.y1=b.y1);b.x2>this.x2&&(this.x2=b.x2);
b.y2>this.y2&&(this.y2=b.y2);return this};prototype.intersect=function(b){b.x1>this.x1&&(this.x1=b.x1);b.y1>this.y1&&(this.y1=b.y1);b.x2<this.x2&&(this.x2=b.x2);b.y2<this.y2&&(this.y2=b.y2);return this};prototype.encloses=function(b){return b&&this.x1<=b.x1&&this.x2>=b.x2&&this.y1<=b.y1&&this.y2>=b.y2};prototype.alignsWith=function(b){return b&&(this.x1==b.x1||this.x2==b.x2||this.y1==b.y1||this.y2==b.y2)};prototype.intersects=function(b){return b&&!(this.x2<b.x1||this.x1>b.x2||this.y2<b.y1||this.y1>
b.y2)};prototype.contains=function(x,y){return!(x<this.x1||x>this.x2||y<this.y1||y>this.y2)};prototype.width=function(){return this.x2-this.x1};prototype.height=function(){return this.y2-this.y1};vegaUtil.inherits(GroupItem,Item);var prototype$1=ResourceLoader.prototype;prototype$1.pending=function(){return this._pending};prototype$1.sanitizeURL=function(uri){var loader=this;loader._pending+=1;return loader._loader.sanitize(uri,{context:"href"}).then(function(opt){--loader._pending;return opt}).catch(function(){--loader._pending;
return null})};prototype$1.loadImage=function(uri){const loader=this,Image=vegaCanvas.image();loader._pending+=1;return loader._loader.sanitize(uri,{context:"image"}).then(function(opt){const url=opt.href;if(!url||!Image)throw{url};const img=new Image;opt=vegaUtil.hasOwnProperty(opt,"crossOrigin")?opt.crossOrigin:"anonymous";null!=opt&&(img.crossOrigin=opt);img.onload=()=>{--loader._pending};img.onerror=()=>{--loader._pending};img.src=url;return img}).catch(function(e){--loader._pending;return{complete:!1,
width:0,height:0,src:e&&e.url||""}})};prototype$1.ready=function(){var loader=this;return new Promise(function(accept){function poll(value){loader.pending()?setTimeout(function(){poll(!0)},10):accept(value)}poll(!1)})};var bounds$jscomp$0,lx,ly,circleThreshold=Tau-1E-8;context$jscomp$0.beginPath=noop;context$jscomp$0.closePath=noop;context$jscomp$0.moveTo=addL;context$jscomp$0.lineTo=addL;context$jscomp$0.rect=function(x,y,w,h){bounds$jscomp$0.add(x+w,y+h);addL(x,y)};context$jscomp$0.quadraticCurveTo=
function(x1,y1,x2,y2){quadExtrema(lx,x1,x2,addX);quadExtrema(ly,y1,y2,addY);addL(x2,y2)};context$jscomp$0.bezierCurveTo=function(x1,y1,x2,y2,x3,y3){cubicExtrema(lx,x1,x2,x3,addX);cubicExtrema(ly,y1,y2,y3,addY);addL(x3,y3)};context$jscomp$0.arc=function(cx,cy,r,sa,ea,ccw){lx=r*Math.cos(ea)+cx;ly=r*Math.sin(ea)+cy;if(Math.abs(ea-sa)>circleThreshold)bounds$jscomp$0.add(cx-r,cy-r),bounds$jscomp$0.add(cx+r,cy+r);else{const update=a=>{bounds$jscomp$0.add(r*Math.cos(a)+cx,r*Math.sin(a)+cy)};let s;update(sa);
update(ea);if(ea!==sa)if(sa%=Tau,0>sa&&(sa+=Tau),ea%=Tau,0>ea&&(ea+=Tau),ea<sa&&(ccw=!ccw,s=sa,sa=ea,ea=s),ccw)for(ea-=Tau,s=sa-sa%HalfPi,sa=0;4>sa&&s>ea;++sa,s-=HalfPi)update(s);else for(s=sa-sa%HalfPi+HalfPi,sa=0;4>sa&&s<ea;++sa,s+=HalfPi)update(s)}};var context$1=(context$1=vegaCanvas.canvas(1,1))?context$1.getContext("2d"):null;const b$jscomp$0=new Bounds;var Empty=[],arc$1=markItemPath("arc",function(context,item){return arcShape.context(context)(item)}),area$1=markMultiItemPath("area",function(context,
items){var item=items[0];return("horizontal"===item.orient?areahShape:areavShape).curve(curves(item.interpolate||"linear",item.orient,item.tension)).context(context)(items)},function(a,p){p="horizontal"===a[0].orient?p[1]:p[0];for(var z="horizontal"===a[0].orient?"y":"x",i=a.length,min=Infinity,hit,d;0<=--i;)!1!==a[i].defined&&(d=Math.abs(a[i][z]-p),d<min&&(min=d,hit=a[i]));return hit});const hitBackground=hitPath(rectanglePath),hitForeground=hitPath(rectanglePath,!1);var group$jscomp$0={type:"group",
tag:"g",nested:!1,attr:function(emit,item){emit("transform",translate(item.x||0,item.y||0))},bound:function(bounds,group){if(!group.clip&&group.items){const items=group.items,m=items.length;for(let j=0;j<m;++j)bounds.union(items[j].bounds)}(group.clip||group.width||group.height)&&!group.noBound&&bounds.add(0,0).add(group.width||0,group.height||0);boundStroke(bounds,group);return bounds.translate(group.x||0,group.y||0)},draw:function(context,scene,bounds){visit(scene,group=>{const gx=group.x||0,gy=
group.y||0,fore=group.strokeForeground,opacity=null==group.opacity?1:group.opacity;(group.stroke||group.fill)&&opacity&&(rectanglePath(context,group,gx,gy),blend(context,group),group.fill&&fill$jscomp$0(context,group,opacity)&&context.fill(),group.stroke&&!fore&&stroke$jscomp$0(context,group,opacity)&&context.stroke());context.save();context.translate(gx,gy);group.clip&&clipGroup(context,group);bounds&&bounds.translate(-gx,-gy);visit(group,item=>{this.draw(context,item,bounds)});bounds&&bounds.translate(gx,
gy);context.restore();fore&&group.stroke&&opacity&&(rectanglePath(context,group,gx,gy),blend(context,group),stroke$jscomp$0(context,group,opacity)&&context.stroke())})},pick:function(context,scene,x,y,gx,gy){if(scene.bounds&&!scene.bounds.contains(gx,gy)||!scene.items)return null;const cx=x*context.pixelRatio,cy=y*context.pixelRatio;return pickVisit(scene,group=>{let dx,dy;var hit=group.bounds;if(!hit||hit.contains(gx,gy)){dx=group.x||0;dy=group.y||0;hit=dx+(group.width||0);var fore=dy+(group.height||
0);var ix=group.clip;if(!ix||!(gx<dx||gx>hit||gy<dy||gy>fore)){context.save();context.translate(dx,dy);dx=gx-dx;dy=gy-dy;if(ix&&hasCornerRadius(group)&&!hitBackground(context,group,cx,cy))return context.restore(),null;fore=group.strokeForeground;if((ix=!1!==scene.interactive)&&fore&&group.stroke&&hitForeground(context,group,cx,cy))return context.restore(),group;hit=pickVisit(group,mark=>(!1!==mark.interactive||"group"===mark.marktype)&&mark.bounds&&mark.bounds.contains(dx,dy)?this.pick(mark,x,y,dx,
dy):null);!hit&&ix&&(group.fill||!fore&&group.stroke)&&hitBackground(context,group,cx,cy)&&(hit=group);context.restore();return hit||null}}})},isect:intersectRect,content:function(emit,item,renderer){item=item.clip?clip(renderer,item,item):null;emit("clip-path",item)},background:function(emit,item){emit("class","background");emit("aria-hidden",!0);{const off=offset$jscomp$0(item);emit("d",rectangle$jscomp$0(null,item,off,off))}},foreground:function(emit,item){emit("class","foreground");emit("aria-hidden",
!0);if(item.strokeForeground){{const off=offset$jscomp$0(item);emit("d",rectangle$jscomp$0(null,item,off,off))}}else emit("d","")}},metadata={version:"1.1",xmlns:"http://www.w3.org/2000/svg","xmlns:xlink":"http://www.w3.org/1999/xlink"},image$jscomp$1={type:"image",tag:"image",nested:!1,attr:function(emit,item,renderer){var img=getImage(item,renderer);renderer=imageWidth(item,img);const h=imageHeight(item,img),x=(item.x||0)-imageXOffset(item.align,renderer),y=(item.y||0)-imageYOffset(item.baseline,
h);img=!img.src&&img.toDataURL?img.toDataURL():img.src||"";emit("href",img,metadata["xmlns:xlink"],"xlink:href");emit("transform",translate(x,y));emit("width",renderer);emit("height",h);emit("preserveAspectRatio",!1===item.aspect?"none":"xMidYMid")},bound:function(bounds,item){var img=item.image;const w=imageWidth(item,img);img=imageHeight(item,img);const x=(item.x||0)-imageXOffset(item.align,w);item=(item.y||0)-imageYOffset(item.baseline,img);return bounds.set(x,item,x+w,item+img)},draw:function(context,
scene,bounds){visit(scene,item=>{if(!bounds||bounds.intersects(item.bounds)){var img=getImage(item,this),w=imageWidth(item,img),h=imageHeight(item,img),x=(item.x||0)-imageXOffset(item.align,w),y=(item.y||0)-imageYOffset(item.baseline,h),opacity;if(!1!==item.aspect){var ar0=img.width/img.height;var ar1=item.width/item.height;ar0===ar0&&ar1===ar1&&ar0!==ar1&&(ar1<ar0?(ar0=w/ar0,y+=(h-ar0)/2,h=ar0):(ar0*=h,x+=(w-ar0)/2,w=ar0))}if(img.complete||img.toDataURL)blend(context,item),context.globalAlpha=null!=
(opacity=item.opacity)?opacity:1,context.imageSmoothingEnabled=!1!==item.smooth,context.drawImage(img,x,y,w,h)}})},pick:pick(),isect:vegaUtil.truthy,get:getImage,xOffset:imageXOffset,yOffset:imageYOffset},line$1=markMultiItemPath("line",function(context,items){var item=items[0];return lineShape.curve(curves(item.interpolate||"linear",item.orient,item.tension)).context(context)(items)},function(a,p){for(var t=Math.pow(a[0].strokeWidth||1,2),i=a.length,dx,dy;0<=--i;)if(!1!==a[i].defined&&(dx=a[i].x-
p[0],dy=a[i].y-p[1],dx=dx*dx+dy*dy,dx<t))return a[i];return null}),path$1={type:"path",tag:"path",nested:!1,attr:function(emit,item){var sy=item.scaleY||1;1===(item.scaleX||1)&&1===sy||emit("vector-effect","non-scaling-stroke");emit("transform",transformItem(item));emit("d",item.path)},bound:function(bounds,item){path$jscomp$0(context$jscomp$0(bounds),item)?bounds.set(0,0,0,0):boundStroke(bounds,item,!0);item.angle&&bounds.rotate(item.angle*DegToRad,item.x||0,item.y||0);return bounds},draw:drawAll(path$jscomp$0),
pick:pick(hitPath(path$jscomp$0)),isect:intersectPath(path$jscomp$0)},rect$jscomp$0={type:"rect",tag:"path",nested:!1,attr:function(emit,item){emit("d",rectangle$jscomp$0(null,item))},bound:function(bounds,item){var x,y;return boundStroke(bounds.set(x=item.x||0,y=item.y||0,x+item.width||0,y+item.height||0),item)},draw:drawAll(draw$2),pick:pick(hitPath(draw$2)),isect:intersectRect},rule={type:"rule",tag:"line",nested:!1,attr:function(emit,item){emit("transform",translate(item.x||0,item.y||0));emit("x2",
null!=item.x2?item.x2-(item.x||0):0);emit("y2",null!=item.y2?item.y2-(item.y||0):0)},bound:function(bounds,item){var x1,y1;return boundStroke(bounds.set(x1=item.x||0,y1=item.y||0,null!=item.x2?item.x2:x1,null!=item.y2?item.y2:y1),item)},draw:function(context,scene,bounds){visit(scene,function(item){if(!bounds||bounds.intersects(item.bounds)){var opacity=null==item.opacity?1:item.opacity;opacity&&path$2(context,item,opacity)&&(blend(context,item),context.stroke())}})},pick:pick(function(context,item,
x,y){return context.isPointInStroke?path$2(context,item,1)&&context.isPointInStroke(x,y):!1}),isect:intersectRule},shape$1=markItemPath("shape",function(context,item){return(item.mark.shape||item.shape).context(context)(item)}),symbol$1=markItemPath("symbol",function(context,item){return symbolShape.context(context)(item)},intersectPoint);const widthCache=vegaUtil.lruCache();var textMetrics={height:fontSize,measureWidth,estimateWidth,width:estimateWidth,canvas:useCanvas};useCanvas(!0);var textAlign=
{left:"start",center:"middle",right:"end"},tempBounds=new Bounds,text$jscomp$0={type:"text",tag:"text",nested:!1,attr:function(emit,item){var dx=item.dx||0,dy=(item.dy||0)+offset$1(item),p=anchorPoint(item),x=p.x1;p=p.y1;var a=item.angle||0;emit("text-anchor",textAlign[item.align]||"start");if(a){if(item=translate(x,p)+" rotate("+(a+")"),dx||dy)item+=" "+translate(dx,dy)}else item=translate(x+dx,p+dy);emit("transform",item)},bound:bound$5,draw:function(context,scene,bounds){visit(scene,function(item){var opacity=
null==item.opacity?1:item.opacity,i;if(!(bounds&&!bounds.intersects(item.bounds)||0===opacity||0>=item.fontSize||null==item.text||0===item.text.length)){context.font=font(item);context.textAlign=item.align||"left";var p=anchorPoint(item);var x=p.x1;p=p.y1;item.angle&&(context.save(),context.translate(x,p),context.rotate(item.angle*DegToRad),x=p=0);x+=item.dx||0;p+=(item.dy||0)+offset$1(item);var tl=textLines(item);blend(context,item);if(vegaUtil.isArray(tl)){var lh=lineHeight(item);for(i=0;i<tl.length;++i){var str=
textValue(item,tl[i]);item.fill&&fill$jscomp$0(context,item,opacity)&&context.fillText(str,x,p);item.stroke&&stroke$jscomp$0(context,item,opacity)&&context.strokeText(str,x,p);p+=lh}}else str=textValue(item,tl),item.fill&&fill$jscomp$0(context,item,opacity)&&context.fillText(str,x,p),item.stroke&&stroke$jscomp$0(context,item,opacity)&&context.strokeText(str,x,p);item.angle&&context.restore()}})},pick:pick(function(context,item,x,y,gx,gy){if(0>=item.fontSize)return!1;if(!item.angle)return!0;x=anchorPoint(item);
context=x.x1;x=x.y1;y=bound$5(tempBounds,item,1);var a=-item.angle*DegToRad;item=Math.cos(a);a=Math.sin(a);return y.contains(item*gx-a*gy+(context-item*context+a*x),a*gx+item*gy+(x-a*context-item*x))}),isect:function(item,box){item=bound$5(tempBounds,item,2);return intersectBoxLine(box,item[0],item[1],item[2],item[3])||intersectBoxLine(box,item[0],item[1],item[4],item[5])||intersectBoxLine(box,item[4],item[5],item[6],item[7])||intersectBoxLine(box,item[2],item[3],item[6],item[7])}},trail$1=markMultiItemPath("trail",
function(context,items){return trailShape.context(context)(items)},function(a,p){for(var i=a.length,dx,dy;0<=--i;)if(!1!==a[i].defined&&(dx=a[i].x-p[0],dy=a[i].y-p[1],dy=dx*dx+dy*dy,dx=a[i].size||1,dy<dx*dx))return a[i];return null}),Marks={arc:arc$1,area:area$1,group:group$jscomp$0,image:image$jscomp$1,line:line$1,path:path$1,rect:rect$jscomp$0,rule,shape:shape$1,symbol:symbol$1,text:text$jscomp$0,trail:trail$1},DUMMY={mark:null},keys="marktype name role interactive clip items zindex x y width height align baseline fill fillOpacity opacity blend stroke strokeOpacity strokeWidth strokeCap strokeDash strokeDashOffset strokeForeground strokeOffset startAngle endAngle innerRadius outerRadius cornerRadius padAngle cornerRadiusTopLeft cornerRadiusTopRight cornerRadiusBottomLeft cornerRadiusBottomRight interpolate tension orient defined url aspect smooth path scaleX scaleY x2 y2 size shape text angle theta radius dir dx dy ellipsis limit lineBreak lineHeight font fontSize fontWeight fontStyle fontVariant description aria ariaRole ariaRoleDescription".split(" "),
prototype$2=Scenegraph.prototype;prototype$2.toJSON=function(indent){return sceneToJSON(this.root,indent||0)};prototype$2.mark=function(markdef,group,index){group=group||this.root.items[0];markdef=createMark(markdef,group);group.items[index]=markdef;markdef.zindex&&(markdef.group.zdirty=!0);return markdef};const prototype$3=Handler.prototype;prototype$3.initialize=function(el,origin,obj){this._el=el;this._obj=obj||null;return this.origin(origin)};prototype$3.element=function(){return this._el};prototype$3.canvas=
function(){return this._el&&this._el.firstChild};prototype$3.origin=function(origin){return arguments.length?(this._origin=origin||[0,0],this):this._origin.slice()};prototype$3.scene=function(scene){if(!arguments.length)return this._scene;this._scene=scene;return this};prototype$3.on=function(){};prototype$3.off=function(){};prototype$3._handlerIndex=function(h,type,handler){for(let i=h?h.length:0;0<=--i;)if(h[i].type===type&&(!handler||h[i].handler===handler))return i;return-1};prototype$3.handlers=
function(type){const h=this._handlers,a=[];if(type)a.push.apply(a,h[this.eventName(type)]);else for(const k in h)a.push.apply(a,h[k]);return a};prototype$3.eventName=function(name){const i=name.indexOf(".");return 0>i?name:name.slice(0,i)};prototype$3.handleHref=function(event,item,href){this._loader.sanitize(href,{context:"href"}).then(opt=>{const e=new MouseEvent(event.type,event),a=domCreate(null,"a");for(const name in opt)a.setAttribute(name,opt[name]);a.dispatchEvent(e)}).catch(function(){})};
prototype$3.handleTooltip=function(event,item,show){if(item&&null!=item.tooltip){var el=this.canvas(),origin=this._origin,mark=item&&item.mark,mdef;if(mark&&(mdef=Marks[mark.marktype]).tip){el=point(event,el);el[0]-=origin[0];for(el[1]-=origin[1];item=item.mark.group;)el[0]-=item.x||0,el[1]-=item.y||0;item=mdef.tip(mark.items,el)}this._tooltip.call(this._obj,this,event,item,show&&item&&item.tooltip||null)}};prototype$3.getItemBoundingClientRect=function(item){var el=this.canvas();if(el){var rect=
el.getBoundingClientRect(),origin=this._origin,bounds=item.bounds;el=bounds.width();var height=bounds.height(),x=bounds.x1+origin[0]+rect.left;for(rect=bounds.y1+origin[1]+rect.top;item.mark&&(item=item.mark.group);)x+=item.x||0,rect+=item.y||0;return{x,y:rect,width:el,height,left:x,top:rect,right:x+el,bottom:rect+height}}};var prototype$4=Renderer.prototype;prototype$4.initialize=function(el,width,height,origin,scaleFactor){this._el=el;return this.resize(width,height,origin,scaleFactor)};prototype$4.element=
function(){return this._el};prototype$4.canvas=function(){return this._el&&this._el.firstChild};prototype$4.background=function(bgcolor){if(0===arguments.length)return this._bgcolor;this._bgcolor=bgcolor;return this};prototype$4.resize=function(width,height,origin,scaleFactor){this._width=width;this._height=height;this._origin=origin||[0,0];this._scale=scaleFactor||1;return this};prototype$4.dirty=function(){};prototype$4.render=function(scene){var r=this;r._call=function(){r._render(scene)};r._call();
r._call=null;return r};prototype$4._render=function(){};prototype$4.renderAsync=function(scene){var r=this.render(scene);return this._ready?this._ready.then(function(){return r}):Promise.resolve(r)};prototype$4._load=function(method,uri){var r=this;method=r._loader[method](uri);if(!r._ready){var call=r._call;r._ready=r._loader.ready().then(function(redraw){redraw&&call();r._ready=null})}return method};prototype$4.sanitizeURL=function(uri){return this._load("sanitizeURL",uri)};prototype$4.loadImage=
function(uri){return this._load("loadImage",uri)};const prototype$5=vegaUtil.inherits(CanvasHandler,Handler);prototype$5.initialize=function(el,origin,obj){this._canvas=el&&domFind(el,"canvas");["click","mousedown","mousemove","mouseout","dragleave"].forEach(type=>eventListenerCheck(this,type));return Handler.prototype.initialize.call(this,el,origin,obj)};prototype$5.canvas=function(){return this._canvas};prototype$5.context=function(){return this._canvas.getContext("2d")};prototype$5.events="keydown keypress keyup dragenter dragleave dragover mousedown mouseup mousemove mouseout mouseover click dblclick wheel mousewheel touchstart touchmove touchend".split(" ");
prototype$5.DOMMouseScroll=function(evt){this.fire("mousewheel",evt)};prototype$5.mousemove=move("mousemove","mouseover","mouseout");prototype$5.dragover=move("dragover","dragenter","dragleave");prototype$5.mouseout=inactive("mouseout");prototype$5.dragleave=inactive("dragleave");prototype$5.mousedown=function(evt){this._down=this._active;this.fire("mousedown",evt)};prototype$5.click=function(evt){this._down===this._active&&(this.fire("click",evt),this._down=null)};prototype$5.touchstart=function(evt){this._touch=
this.pickEvent(evt.changedTouches[0]);this._first&&(this._active=this._touch,this._first=!1);this.fire("touchstart",evt,!0)};prototype$5.touchmove=function(evt){this.fire("touchmove",evt,!0)};prototype$5.touchend=function(evt){this.fire("touchend",evt,!0);this._touch=null};prototype$5.fire=function(type,evt,touch){touch=touch?this._touch:this._active;const h=this._handlers[type];evt.vegaType=type;"click"===type&&touch&&touch.href?this.handleHref(evt,touch,touch.href):("mousemove"===type||"mouseout"===
type)&&this.handleTooltip(evt,touch,"mouseout"!==type);if(h)for(let i=0,len=h.length;i<len;++i)h[i].handler.call(this._obj,evt,touch)};prototype$5.on=function(type,handler){const name=this.eventName(type),h=this._handlers;0>this._handlerIndex(h[name],type,handler)&&(eventListenerCheck(this,type),(h[name]||(h[name]=[])).push({type,handler}));return this};prototype$5.off=function(type,handler){var name=this.eventName(type);name=this._handlers[name];type=this._handlerIndex(name,type,handler);0<=type&&
name.splice(type,1);return this};prototype$5.pickEvent=function(evt){evt=point(evt,this._canvas);const o=this._origin;return this.pick(this._scene,evt[0],evt[1],evt[0]-o[0],evt[1]-o[1])};prototype$5.pick=function(scene,x,y,gx,gy){const g=this.context();return Marks[scene.marktype].pick.call(this,g,scene,x,y,gx,gy)};var pixelRatio="undefined"!==typeof window?window.devicePixelRatio||1:1;const prototype$6=vegaUtil.inherits(CanvasRenderer,Renderer),base$jscomp$0=Renderer.prototype;prototype$6.initialize=
function(el,width,height,origin,scaleFactor,options){this._options=options||{};this._canvas=this._options.externalContext?null:vegaCanvas.canvas(1,1,this._options.type);el&&this._canvas&&(domClear(el,0).appendChild(this._canvas),this._canvas.setAttribute("class","marks"));return base$jscomp$0.initialize.call(this,el,width,height,origin,scaleFactor)};prototype$6.resize=function(width,height,origin,scaleFactor$jscomp$0){base$jscomp$0.resize.call(this,width,height,origin,scaleFactor$jscomp$0);if(this._canvas){{width=
this._canvas;height=this._width;origin=this._height;scaleFactor$jscomp$0=this._origin;var scaleFactor=this._scale,opt=this._options.context;const inDOM="undefined"!==typeof HTMLElement&&width instanceof HTMLElement&&null!=width.parentNode,context=width.getContext("2d");scaleFactor=inDOM?pixelRatio:scaleFactor;width.width=height*scaleFactor;width.height=origin*scaleFactor;for(var key in opt)context[key]=opt[key];inDOM&&1!==scaleFactor&&(width.style.width=height+"px",width.style.height=origin+"px");
context.pixelRatio=scaleFactor;context.setTransform(scaleFactor,0,0,scaleFactor,scaleFactor*scaleFactor$jscomp$0[0],scaleFactor*scaleFactor$jscomp$0[1])}}else(key=this._options.externalContext)||vegaUtil.error("CanvasRenderer is missing a valid canvas or context"),key.scale(this._scale,this._scale),key.translate(this._origin[0],this._origin[1]);this._redraw=!0;return this};prototype$6.canvas=function(){return this._canvas};prototype$6.context=function(){return this._options.externalContext||(this._canvas?
this._canvas.getContext("2d"):null)};prototype$6.dirty=function(item){let b=this._tempb.clear().union(item.bounds);for(item=item.mark.group;item;)b.translate(item.x||0,item.y||0),item=item.mark.group;this._dirty.union(b)};prototype$6._render=function(scene){const g=this.context(),o=this._origin,w=this._width,h=this._height,db=this._dirty;var JSCompiler_inline_result=(new Bounds).set(0,0,w,h).translate(-o[0],-o[1]);g.save();this._redraw||db.empty()?JSCompiler_inline_result=(this._redraw=!1,JSCompiler_inline_result.expand(1)):
(JSCompiler_inline_result=JSCompiler_inline_result.intersect(db),JSCompiler_inline_result.expand(1).round(),g.pixelRatio%1&&JSCompiler_inline_result.scale(g.pixelRatio).round().scale(1/g.pixelRatio),JSCompiler_inline_result.translate(-(o[0]%1),-(o[1]%1)),g.beginPath(),g.rect(JSCompiler_inline_result.x1,JSCompiler_inline_result.y1,JSCompiler_inline_result.width(),JSCompiler_inline_result.height()),g.clip());this.clear(-o[0],-o[1],w,h);this.draw(g,scene,JSCompiler_inline_result);g.restore();db.clear();
return this};prototype$6.draw=function(ctx,scene,bounds){const mark=Marks[scene.marktype];if(scene.clip){var clip=scene.clip;ctx.save();vegaUtil.isFunction(clip)?(ctx.beginPath(),clip(ctx),ctx.clip()):clipGroup(ctx,scene.group)}mark.draw.call(this,ctx,scene,bounds);scene.clip&&ctx.restore()};prototype$6.clear=function(x,y,w,h){const opt=this._options,g=this.context();"pdf"===opt.type||opt.externalContext||g.clearRect(x,y,w,h);null!=this._bgcolor&&(g.fillStyle=this._bgcolor,g.fillRect(x,y,w,h))};const prototype$7=
vegaUtil.inherits(SVGHandler,Handler);prototype$7.initialize=function(el,origin,obj){let svg=this._svg;svg&&(svg.removeEventListener("click",this._hrefHandler),svg.removeEventListener("mousemove",this._tooltipHandler),svg.removeEventListener("mouseout",this._tooltipHandler));if(this._svg=svg=el&&domFind(el,"svg"))svg.addEventListener("click",this._hrefHandler),svg.addEventListener("mousemove",this._tooltipHandler),svg.addEventListener("mouseout",this._tooltipHandler);return Handler.prototype.initialize.call(this,
el,origin,obj)};prototype$7.canvas=function(){return this._svg};const listener=(context,handler)=>evt=>{let item=evt.target.__data__;item=Array.isArray(item)?item[0]:item;evt.vegaType=evt.type;handler.call(context._obj,evt,item)};prototype$7.on=function(type,handler){const name=this.eventName(type),h=this._handlers;0>this._handlerIndex(h[name],type,handler)&&(type={type,handler,listener:listener(this,handler)},(h[name]||(h[name]=[])).push(type),this._svg&&this._svg.addEventListener(name,type.listener));
return this};prototype$7.off=function(type,handler){const name=this.eventName(type),h=this._handlers[name];type=this._handlerIndex(h,type,handler);0<=type&&(this._svg&&this._svg.removeEventListener(name,h[type].listener),h.splice(type,1));return this};const bundle=(role,roledesc,label)=>({["role"]:role,["aria-roledescription"]:roledesc,["aria-label"]:label||void 0}),AriaIgnore=vegaUtil.toSet("axis-domain axis-grid axis-label axis-tick axis-title legend-band legend-entry legend-gradient legend-label legend-title legend-symbol title".split(" ")),
AriaGuides={axis:{desc:"axis",caption:function(item){var datum=item.datum;const orient=item.orient,title=datum.title?extractTitle(item):null;var ctx=item.context;datum=ctx.scales[datum.scale].value;ctx=ctx.dataflow.locale();const type=datum.type;return`${"left"===orient||"right"===orient?"Y":"X"}-axis`+(title?` titled '${title}'`:"")+` for a ${vegaScale.isDiscrete(type)?"discrete":type} scale`+` with ${vegaScale.domainCaption(ctx,datum,item)}`}},legend:{desc:"legend",caption:function(item){var datum=
item.datum;const title=datum.title?extractTitle(item):null,type=`${datum.type||""} legend`.trim();var scales=datum.scales;datum=Object.keys(scales);var ctx=item.context;scales=ctx.scales[scales[datum[0]]].value;ctx=ctx.dataflow.locale();return(type.length?type[0].toUpperCase()+type.slice(1):type)+(title?` titled '${title}'`:"")+` for ${channelCaption(datum)}`+` with ${vegaScale.domainCaption(ctx,scales,item)}`}},"title-text":{desc:"title",caption:item=>`Title text '${vegaUtil.array(item.text).join(" ")}'`},
"title-subtitle":{desc:"subtitle",caption:item=>`Subtitle text '${vegaUtil.array(item.text).join(" ")}'`}},AriaEncode={ariaRole:"role",ariaRoleDescription:"aria-roledescription",description:"aria-label"},styles={fill:"fill",fillOpacity:"fill-opacity",stroke:"stroke",strokeOpacity:"stroke-opacity",strokeWidth:"stroke-width",strokeCap:"stroke-linecap",strokeJoin:"stroke-linejoin",strokeDash:"stroke-dasharray",strokeDashOffset:"stroke-dashoffset",strokeMiterLimit:"stroke-miterlimit",opacity:"opacity",
blend:"mix-blend-mode"},rootAttributes={fill:"none","stroke-miterlimit":10},ns=metadata.xmlns;var prototype$8=vegaUtil.inherits(SVGRenderer,Renderer),base$1=Renderer.prototype;prototype$8.initialize=function(el,width,height,padding){this._defs={gradient:{},clipping:{}};if(el){this._svg=domChild(el,0,"svg",ns);this._svg.setAttribute("class","marks");domClear(el,1);this._root=domChild(this._svg,0,"g",ns);for(const attr in rootAttributes)this._root.setAttribute(attr,rootAttributes[attr]);domClear(this._svg,
1)}this.background(this._bgcolor);return base$1.initialize.call(this,el,width,height,padding)};prototype$8.background=function(bgcolor){arguments.length&&this._svg&&this._svg.style.setProperty("background-color",bgcolor);return base$1.background.apply(this,arguments)};prototype$8.resize=function(width,height,origin,scaleFactor){base$1.resize.call(this,width,height,origin,scaleFactor);this._svg&&(this._svg.setAttribute("width",this._width*this._scale),this._svg.setAttribute("height",this._height*this._scale),
this._svg.setAttribute("viewBox","0 0 "+this._width+" "+this._height),this._root.setAttribute("transform","translate("+this._origin+")"));this._dirty=[];return this};prototype$8.canvas=function(){return this._svg};prototype$8.svg=function(){if(!this._svg)return null;var attr={class:"marks",width:this._width*this._scale,height:this._height*this._scale,viewBox:"0 0 "+this._width+" "+this._height};for(key in metadata)attr[key]=metadata[key];var key=this._bgcolor?openTag("rect",{width:this._width,height:this._height,
fill:this._bgcolor})+closeTag("rect"):"";return openTag("svg",attr)+(this._defs.el?this._defs.el.outerHTML:"")+key+this._root.outerHTML+closeTag("svg")};prototype$8._render=function(scene){this._dirtyCheck()&&(this._dirtyAll&&this._resetDefs(),this.draw(this._root,scene),domClear(this._root,1));this.updateDefs();this._dirty=[];++this._dirtyID;return this};prototype$8.updateDefs=function(){const svg=this._svg,defs=this._defs;let el=defs.el;var index=0;for(var id$jscomp$0 in defs.gradient){el||(defs.el=
el=domChild(svg,0,"defs",ns));var n,el$jscomp$0=el,grad=defs.gradient[id$jscomp$0];if("radial"===grad.gradient){var stop=domChild(el$jscomp$0,index++,"pattern",ns);stop.setAttribute("id","p_"+grad.id);stop.setAttribute("viewBox","0,0,1,1");stop.setAttribute("width","100%");stop.setAttribute("height","100%");stop.setAttribute("preserveAspectRatio","xMidYMid slice");stop=domChild(stop,0,"rect",ns);stop.setAttribute("width","1");stop.setAttribute("height","1");stop.setAttribute("fill","url("+href()+
"#"+grad.id+")");el$jscomp$0=domChild(el$jscomp$0,index++,"radialGradient",ns);el$jscomp$0.setAttribute("id",grad.id);el$jscomp$0.setAttribute("fx",grad.x1);el$jscomp$0.setAttribute("fy",grad.y1);el$jscomp$0.setAttribute("fr",grad.r1);el$jscomp$0.setAttribute("cx",grad.x2);el$jscomp$0.setAttribute("cy",grad.y2);el$jscomp$0.setAttribute("r",grad.r2)}else el$jscomp$0=domChild(el$jscomp$0,index++,"linearGradient",ns),el$jscomp$0.setAttribute("id",grad.id),el$jscomp$0.setAttribute("x1",grad.x1),el$jscomp$0.setAttribute("x2",
grad.x2),el$jscomp$0.setAttribute("y1",grad.y1),el$jscomp$0.setAttribute("y2",grad.y2);var i=0;for(n=grad.stops.length;i<n;++i)stop=domChild(el$jscomp$0,i,"stop",ns),stop.setAttribute("offset",grad.stops[i].offset),stop.setAttribute("stop-color",grad.stops[i].color);domClear(el$jscomp$0,i)}for(const id in defs.clipping)el||(defs.el=el=domChild(svg,0,"defs",ns)),el$jscomp$0=el,grad=defs.clipping[id],el$jscomp$0=domChild(el$jscomp$0,index,"clipPath",ns),el$jscomp$0.setAttribute("id",grad.id),grad.path?
(id$jscomp$0=domChild(el$jscomp$0,0,"path",ns),id$jscomp$0.setAttribute("d",grad.path)):(id$jscomp$0=domChild(el$jscomp$0,0,"rect",ns),id$jscomp$0.setAttribute("x",0),id$jscomp$0.setAttribute("y",0),id$jscomp$0.setAttribute("width",grad.width),id$jscomp$0.setAttribute("height",grad.height)),domClear(el$jscomp$0,1),index+=1;el&&(0===index?(svg.removeChild(el),defs.el=null):domClear(el,index))};prototype$8._resetDefs=function(){var def=this._defs;def.gradient={};def.clipping={}};prototype$8.dirty=function(item){item.dirty!==
this._dirtyID&&(item.dirty=this._dirtyID,this._dirty.push(item))};prototype$8.isDirty=function(item){return this._dirtyAll||!item._svg||item.dirty===this._dirtyID};prototype$8._dirtyCheck=function(){this._dirtyAll=!0;var items=this._dirty;if(!items.length||!this._dirtyID)return!0;var id=++this._dirtyID,n;var i$jscomp$0=0;for(n=items.length;i$jscomp$0<n;++i$jscomp$0){var item=items[i$jscomp$0];var mark=item.mark;if(mark.marktype!==type){var type=mark.marktype;var mdef=Marks[type]}mark.zdirty&&mark.dirty!==
id&&(this._dirtyAll=!1,dirtyParents(item,id),mark.items.forEach(function(i){i.dirty=id}));mark.zdirty||(item.exit?(mdef.nested&&mark.items.length?(mark=mark.items[0],mark._svg&&this._update(mdef,mark._svg,mark)):item._svg&&(mark=item._svg.parentNode)&&mark.removeChild(item._svg),item._svg=null):(item=mdef.nested?mark.items[0]:item,item._update!==id&&(item._svg&&item._svg.ownerSVGElement?this._update(mdef,item._svg,item):(this._dirtyAll=!1,dirtyParents(item,id)),item._update=id)))}return!this._dirtyAll};
prototype$8.draw=function(el,scene,prev){if(!this.isDirty(scene))return scene._svg;var svg=this._svg,mdef=Marks[scene.marktype],events=!1===scene.interactive?"none":null,isGroup="g"===mdef.tag,sibling=null,i=0;var parent=bind(scene,el,prev,"g",svg);parent.setAttribute("class",cssClass(scene));el=ariaMarkAttributes(scene);for(const key in el)setAttribute(parent,key,el[key]);isGroup||setAttribute(parent,"pointer-events",events);setAttribute(parent,"clip-path",scene.clip?clip(this,scene,scene.group):
null);events=item=>{const dirty=this.isDirty(item),node=bind(item,parent,sibling,mdef.tag,svg);dirty&&(this._update(mdef,node,item),isGroup&&recurse$jscomp$0(this,node,item));sibling=node;++i};mdef.nested?scene.items.length&&events(scene.items[0]):visit(scene,events);domClear(parent,i);return parent};var element=null,values=null,mark_extras={group:function(mdef,el,item){const fg=element=el.childNodes[2];values=fg.__values__;mdef.foreground(emit,item,this);values=el.__values__;element=el.childNodes[1];
mdef.content(emit,item,this);el=element=el.childNodes[0];mdef.background(emit,item,this);mdef=!1===item.mark.interactive?"none":null;mdef!==values.events&&(setAttribute(fg,"pointer-events",mdef),setAttribute(el,"pointer-events",mdef),values.events=mdef);item.strokeForeground&&item.stroke?(mdef=item.fill,setAttribute(fg,"display",null),this.style(el,item),setAttribute(el,"stroke",null),mdef&&(item.fill=null),values=fg.__values__,this.style(fg,item),mdef&&(item.fill=mdef),element=null):setAttribute(fg,
"display","none")},image:function(mdef,el,item){!1===item.smooth?(setStyle(el,"image-rendering","optimizeSpeed"),setStyle(el,"image-rendering","pixelated")):setStyle(el,"image-rendering",null)},text:function(mdef,el,item){mdef=textLines(item);let value,doc,lh;vegaUtil.isArray(mdef)?(value=mdef.map(_=>textValue(item,_)),mdef=value.join("\n"),mdef!==values.text&&(domClear(el,0),doc=el.ownerDocument,lh=lineHeight(item),value.forEach((t,i)=>{const ts=domCreate(doc,"tspan",ns);ts.__data__=item;ts.textContent=
t;i&&(ts.setAttribute("x",0),ts.setAttribute("dy",lh));el.appendChild(ts)}),values.text=mdef)):(value=textValue(item,mdef),value!==values.text&&(el.textContent=value,values.text=value));setAttribute(el,"font-family",fontFamily(item));setAttribute(el,"font-size",fontSize(item)+"px");setAttribute(el,"font-style",item.fontStyle);setAttribute(el,"font-variant",item.fontVariant);setAttribute(el,"font-weight",item.fontWeight)}};prototype$8._update=function(mdef,el,item){element=el;values=el.__values__;
ariaItemAttributes(emit,item);mdef.attr(emit,item,this);const extra=mark_extras[mdef.type];extra&&extra.call(this,mdef,el,item);element&&this.style(element,item)};prototype$8.style=function(el,o){if(null!=o)for(const prop in styles){let value="font"===prop?fontFamily(o):o[prop];if(value===values[prop])continue;const name=styles[prop];null==value?el.removeAttribute(name):(value&&value.gradient&&(value=gradientRef(value,this._defs.gradient,href())),el.setAttribute(name,value+""));values[prop]=value}};
var prototype$9=vegaUtil.inherits(SVGStringRenderer,Renderer),base$2=Renderer.prototype;prototype$9.resize=function(width,height,origin,scaleFactor){base$2.resize.call(this,width,height,origin,scaleFactor);width=this._origin;height=this._text;origin={class:"marks",width:this._width*this._scale,height:this._height*this._scale,viewBox:"0 0 "+this._width+" "+this._height};for(var key in metadata)origin[key]=metadata[key];height.head=openTag("svg",origin);key=this._bgcolor;if("transparent"===key||"none"===
key)key=null;height.bg=key?openTag("rect",{width:this._width,height:this._height,fill:key})+closeTag("rect"):"";height.root=openTag("g",vegaUtil.extend({},rootAttributes,{transform:"translate("+width+")"}));height.foot=closeTag("g")+closeTag("svg");return this};prototype$9.background=function(){var rv=base$2.background.apply(this,arguments);arguments.length&&this._text.head&&this.resize(this._width,this._height,this._origin,this._scale);return rv};prototype$9.svg=function(){var t=this._text;return t.head+
t.defs+t.bg+t.root+t.body+t.foot};prototype$9._render=function(scene){this._text.body=this.mark(scene);this._text.defs=this.buildDefs();return this};prototype$9.buildDefs=function(){let defs="";var tag;for(const id in this._defs.gradient){var def=this._defs.gradient[id];const stops=def.stops;"radial"===def.gradient?(defs+=openTag(tag="pattern",{id:"p_"+id,viewBox:"0,0,1,1",width:"100%",height:"100%",preserveAspectRatio:"xMidYMid slice"}),defs+=openTag("rect",{width:"1",height:"1",fill:"url(#"+id+
")"})+closeTag("rect"),defs+=closeTag(tag),defs+=openTag(tag="radialGradient",{id,fx:def.x1,fy:def.y1,fr:def.r1,cx:def.x2,cy:def.y2,r:def.r2})):defs+=openTag(tag="linearGradient",{id,x1:def.x1,x2:def.x2,y1:def.y1,y2:def.y2});for(def=0;def<stops.length;++def)defs+=openTag("stop",{offset:stops[def].offset,"stop-color":stops[def].color})+closeTag("stop");defs+=closeTag(tag)}for(const id in this._defs.clipping)tag=this._defs.clipping[id],defs+=openTag("clipPath",{id}),defs=tag.path?defs+(openTag("path",
{d:tag.path})+closeTag("path")):defs+(openTag("rect",{x:0,y:0,width:tag.width,height:tag.height})+closeTag("rect")),defs+=closeTag("clipPath");return defs?openTag("defs")+defs+closeTag("defs"):""};prototype$9.attr=function(scene,item,attrs,tag){const object={},emit=(name,value,ns,prefixed)=>{object[prefixed||name]=value};Array.isArray(attrs)?attrs.forEach(fn=>fn(emit,item,this)):attrs(emit,item,this);tag&&applyStyles(object,item,scene,tag,this._defs);return object};prototype$9.href=function(item){var that=
this,href=item.href;if(href){if(item=that._hrefs&&that._hrefs[href])return item;that.sanitizeURL(href).then(attr=>{attr["xlink:href"]=attr.href;attr.href=null;(that._hrefs||(that._hrefs={}))[href]=attr})}return null};prototype$9.mark=function(scene){const mdef=Marks[scene.marktype],tag=mdef.tag,attrList=[ariaItemAttributes,mdef.attr];let str="";str+=openTag("g",vegaUtil.extend({"class":cssClass(scene),"clip-path":scene.clip?clip(this,scene,scene.group):null},ariaMarkAttributes(scene),{"pointer-events":"g"!==
tag&&!1===scene.interactive?"none":null}));const process=item=>{const href=this.href(item);href&&(str+=openTag("a",href));str+=openTag(tag,this.attr(scene,item,attrList,"g"!==tag?tag:null));if("text"===tag){var tl=textLines(item);if(vegaUtil.isArray(tl)){var attrs={x:0,dy:lineHeight(item)};for(var i=0;i<tl.length;++i)str+=openTag("tspan",i?attrs:null)+escape_text(textValue(item,tl[i]))+closeTag("tspan")}else str+=escape_text(textValue(item,tl))}else"g"===tag&&(tl=item.strokeForeground,attrs=item.fill,
i=item.stroke,tl&&i&&(item.stroke=null),str+=openTag("path",this.attr(scene,item,mdef.background,"bgrect"))+closeTag("path"),str+=openTag("g",this.attr(scene,item,mdef.content))+this.markGroup(item)+closeTag("g"),tl&&i?(attrs&&(item.fill=null),item.stroke=i,str+=openTag("path",this.attr(scene,item,mdef.foreground,"bgrect"))+closeTag("path"),attrs&&(item.fill=attrs)):str+=openTag("path",this.attr(scene,item,mdef.foreground,"bgfore"))+closeTag("path"));str+=closeTag(tag);href&&(str+=closeTag("a"))};
mdef.nested?scene.items&&scene.items.length&&process(scene.items[0]):visit(scene,process);return str+closeTag("g")};prototype$9.markGroup=function(scene){let str="";visit(scene,item=>{str+=this.mark(item)});return str};var modules={};modules.canvas=modules.png={renderer:CanvasRenderer,headless:CanvasRenderer,handler:CanvasHandler};modules.svg={renderer:SVGRenderer,headless:SVGStringRenderer,handler:SVGHandler};modules.none={};var clipBounds=new Bounds;exports.Bounds=Bounds;exports.CanvasHandler=CanvasHandler;
exports.CanvasRenderer=CanvasRenderer;exports.Gradient=function(p0,p1){var stops=[],gradient;return gradient={gradient:"linear",x1:p0?p0[0]:0,y1:p0?p0[1]:0,x2:p1?p1[0]:1,y2:p1?p1[1]:0,stops,stop:function(offset,color){stops.push({offset,color});return gradient}}};exports.GroupItem=GroupItem;exports.Handler=Handler;exports.Item=Item;exports.Marks=Marks;exports.RenderType={Canvas:"canvas",PNG:"png",SVG:"svg",None:"none"};exports.Renderer=Renderer;exports.ResourceLoader=ResourceLoader;exports.SVGHandler=
SVGHandler;exports.SVGRenderer=SVGRenderer;exports.SVGStringRenderer=SVGStringRenderer;exports.Scenegraph=Scenegraph;exports.boundClip=function(mark){var clip=mark.clip;if(vegaUtil.isFunction(clip))clip(context$jscomp$0(clipBounds.clear()));else if(clip)clipBounds.set(0,0,mark.group.width,mark.group.height);else return;mark.bounds.intersect(clipBounds)};exports.boundContext=context$jscomp$0;exports.boundItem=boundItem;exports.boundMark=boundMark;exports.boundStroke=boundStroke;exports.closeTag=closeTag;
exports.domChild=domChild;exports.domClear=domClear;exports.domCreate=domCreate;exports.domFind=domFind;exports.font=font;exports.fontFamily=fontFamily;exports.fontSize=fontSize;exports.intersect=function(scene,bounds,filter){const hits=[];bounds=(new Bounds).union(bounds);const type=scene.marktype;return type?intersectMark(scene,bounds,filter,hits):"group"===type?intersectGroup(scene,bounds,filter,hits):vegaUtil.error("Intersect scene must be mark node or group item.")};exports.intersectBoxLine=
intersectBoxLine;exports.intersectPath=intersectPath;exports.intersectPoint=intersectPoint;exports.intersectRule=intersectRule;exports.lineHeight=lineHeight;exports.multiLineOffset=function(item){const tl=textLines(item);return(vegaUtil.isArray(tl)?tl.length-1:0)*lineHeight(item)};exports.openTag=openTag;exports.pathCurves=curves;exports.pathEqual=pathEqual;exports.pathParse=pathParse;exports.pathRectangle=vg_rect;exports.pathRender=pathRender;exports.pathSymbols=symbols;exports.pathTrail=vg_trail;
exports.point=point;exports.renderModule=function(name,_){name=String(name||"").toLowerCase();return 1<arguments.length?(modules[name]=_,this):modules[name]};exports.resetSVGClipId=function(){clip_id=1};exports.resetSVGDefIds=function(){clip_id=1;gradient_id=0};exports.sceneEqual=sceneEqual;exports.sceneFromJSON=sceneFromJSON;exports.scenePickVisit=pickVisit;exports.sceneToJSON=sceneToJSON;exports.sceneVisit=visit;exports.sceneZOrder=zorder;exports.textMetrics=textMetrics;Object.defineProperty(exports,
"__esModule",{value:!0})})}
//# sourceMappingURL=module$node_modules$vega_scenegraph$build$vega_scenegraph.js.map
