goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e55914){var e = e55914;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56044 = arguments.length;
var i__4737__auto___56045 = (0);
while(true){
if((i__4737__auto___56045 < len__4736__auto___56044)){
args__4742__auto__.push((arguments[i__4737__auto___56045]));

var G__56046 = (i__4737__auto___56045 + (1));
i__4737__auto___56045 = G__56046;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__55921){
var vec__55922 = p__55921;
var map__55925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55922,(0),null);
var map__55925__$1 = (((((!((map__55925 == null))))?(((((map__55925.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55925.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55925):map__55925);
var opts = map__55925__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55925__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55925__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55925__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55925__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__55927 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4126__auto__ = read_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4126__auto__ = write_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__55927__$1 = (((((!((map__55927 == null))))?(((((map__55927.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55927.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55927):map__55927);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55927__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55927__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__55915_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__55915_SHARP_);
}));

(web_socket.onclose = (function (p1__55916_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__55916_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__41778__auto___56049 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_55999){
var state_val_56000 = (state_55999[(1)]);
if((state_val_56000 === (7))){
var inst_55995 = (state_55999[(2)]);
var state_55999__$1 = state_55999;
var statearr_56001_56050 = state_55999__$1;
(statearr_56001_56050[(2)] = inst_55995);

(statearr_56001_56050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (20))){
var state_55999__$1 = state_55999;
var statearr_56003_56051 = state_55999__$1;
(statearr_56003_56051[(2)] = null);

(statearr_56003_56051[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (1))){
var inst_55933 = false;
var state_55999__$1 = (function (){var statearr_56004 = state_55999;
(statearr_56004[(7)] = inst_55933);

return statearr_56004;
})();
var statearr_56005_56052 = state_55999__$1;
(statearr_56005_56052[(2)] = null);

(statearr_56005_56052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (4))){
var inst_55946 = (state_55999[(8)]);
var inst_55948 = (state_55999[(9)]);
var inst_55946__$1 = (state_55999[(2)]);
var inst_55947 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55946__$1,(0),null);
var inst_55948__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55946__$1,(1),null);
var inst_55949 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_55948__$1,open_ch);
var state_55999__$1 = (function (){var statearr_56006 = state_55999;
(statearr_56006[(10)] = inst_55947);

(statearr_56006[(8)] = inst_55946__$1);

(statearr_56006[(9)] = inst_55948__$1);

return statearr_56006;
})();
if(inst_55949){
var statearr_56007_56053 = state_55999__$1;
(statearr_56007_56053[(1)] = (5));

} else {
var statearr_56009_56054 = state_55999__$1;
(statearr_56009_56054[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (15))){
var inst_55980 = (state_55999[(2)]);
var state_55999__$1 = state_55999;
var statearr_56010_56055 = state_55999__$1;
(statearr_56010_56055[(2)] = inst_55980);

(statearr_56010_56055[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (21))){
var inst_55991 = (state_55999[(2)]);
var state_55999__$1 = state_55999;
var statearr_56011_56057 = state_55999__$1;
(statearr_56011_56057[(2)] = inst_55991);

(statearr_56011_56057[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (13))){
var state_55999__$1 = state_55999;
var statearr_56012_56058 = state_55999__$1;
(statearr_56012_56058[(2)] = null);

(statearr_56012_56058[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (6))){
var inst_55948 = (state_55999[(9)]);
var inst_55964 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_55948,close_ch);
var state_55999__$1 = state_55999;
if(inst_55964){
var statearr_56016_56060 = state_55999__$1;
(statearr_56016_56060[(1)] = (9));

} else {
var statearr_56017_56061 = state_55999__$1;
(statearr_56017_56061[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (17))){
var state_55999__$1 = state_55999;
var statearr_56018_56062 = state_55999__$1;
(statearr_56018_56062[(2)] = initial_ch);

(statearr_56018_56062[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (3))){
var inst_55997 = (state_55999[(2)]);
var state_55999__$1 = state_55999;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55999__$1,inst_55997);
} else {
if((state_val_56000 === (12))){
var inst_55933 = (state_55999[(7)]);
var state_55999__$1 = state_55999;
if(cljs.core.truth_(inst_55933)){
var statearr_56020_56063 = state_55999__$1;
(statearr_56020_56063[(1)] = (16));

} else {
var statearr_56021_56064 = state_55999__$1;
(statearr_56021_56064[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (2))){
var inst_55942 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55943 = [open_ch,close_ch];
var inst_55944 = (new cljs.core.PersistentVector(null,2,(5),inst_55942,inst_55943,null));
var state_55999__$1 = state_55999;
return cljs.core.async.ioc_alts_BANG_(state_55999__$1,(4),inst_55944);
} else {
if((state_val_56000 === (19))){
var inst_55947 = (state_55999[(10)]);
var state_55999__$1 = state_55999;
var statearr_56022_56066 = state_55999__$1;
(statearr_56022_56066[(2)] = inst_55947);

(statearr_56022_56066[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (11))){
var inst_55993 = (state_55999[(2)]);
var state_55999__$1 = state_55999;
var statearr_56023_56067 = state_55999__$1;
(statearr_56023_56067[(2)] = inst_55993);

(statearr_56023_56067[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (9))){
var inst_55970 = (state_55999[(11)]);
var inst_55946 = (state_55999[(8)]);
var inst_55969 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55946,(0),null);
var inst_55970__$1 = chord.client.close_event__GT_maybe_error(inst_55969);
var state_55999__$1 = (function (){var statearr_56025 = state_55999;
(statearr_56025[(11)] = inst_55970__$1);

return statearr_56025;
})();
if(cljs.core.truth_(inst_55970__$1)){
var statearr_56026_56068 = state_55999__$1;
(statearr_56026_56068[(1)] = (12));

} else {
var statearr_56027_56069 = state_55999__$1;
(statearr_56027_56069[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (5))){
var inst_55946 = (state_55999[(8)]);
var inst_55955 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55946,(0),null);
var inst_55956 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_55957 = [ws_chan];
var inst_55958 = cljs.core.PersistentHashMap.fromArrays(inst_55956,inst_55957);
var state_55999__$1 = (function (){var statearr_56028 = state_55999;
(statearr_56028[(12)] = inst_55955);

return statearr_56028;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_55999__$1,(8),initial_ch,inst_55958);
} else {
if((state_val_56000 === (14))){
var inst_55983 = (state_55999[(2)]);
var inst_55984 = cljs.core.async.close_BANG_(ws_chan);
var inst_55985 = cljs.core.async.close_BANG_(initial_ch);
var state_55999__$1 = (function (){var statearr_56029 = state_55999;
(statearr_56029[(13)] = inst_55983);

(statearr_56029[(14)] = inst_55984);

return statearr_56029;
})();
var statearr_56030_56073 = state_55999__$1;
(statearr_56030_56073[(2)] = inst_55985);

(statearr_56030_56073[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (16))){
var state_55999__$1 = state_55999;
var statearr_56031_56074 = state_55999__$1;
(statearr_56031_56074[(2)] = read_ch__$1);

(statearr_56031_56074[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (10))){
var inst_55948 = (state_55999[(9)]);
var inst_55987 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_55948,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_55999__$1 = state_55999;
if(inst_55987){
var statearr_56033_56077 = state_55999__$1;
(statearr_56033_56077[(1)] = (19));

} else {
var statearr_56034_56081 = state_55999__$1;
(statearr_56034_56081[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56000 === (18))){
var inst_55970 = (state_55999[(11)]);
var inst_55975 = (state_55999[(2)]);
var inst_55976 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_55977 = [inst_55970];
var inst_55978 = cljs.core.PersistentHashMap.fromArrays(inst_55976,inst_55977);
var state_55999__$1 = state_55999;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_55999__$1,(15),inst_55975,inst_55978);
} else {
if((state_val_56000 === (8))){
var inst_55960 = (state_55999[(2)]);
var inst_55961 = cljs.core.async.close_BANG_(initial_ch);
var inst_55933 = true;
var state_55999__$1 = (function (){var statearr_56035 = state_55999;
(statearr_56035[(15)] = inst_55960);

(statearr_56035[(7)] = inst_55933);

(statearr_56035[(16)] = inst_55961);

return statearr_56035;
})();
var statearr_56037_56082 = state_55999__$1;
(statearr_56037_56082[(2)] = null);

(statearr_56037_56082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__41689__auto__ = null;
var chord$client$state_machine__41689__auto____0 = (function (){
var statearr_56038 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56038[(0)] = chord$client$state_machine__41689__auto__);

(statearr_56038[(1)] = (1));

return statearr_56038;
});
var chord$client$state_machine__41689__auto____1 = (function (state_55999){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_55999);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e56039){if((e56039 instanceof Object)){
var ex__41692__auto__ = e56039;
var statearr_56040_56089 = state_55999;
(statearr_56040_56089[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_55999);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56039;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56090 = state_55999;
state_55999 = G__56090;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
chord$client$state_machine__41689__auto__ = function(state_55999){
switch(arguments.length){
case 0:
return chord$client$state_machine__41689__auto____0.call(this);
case 1:
return chord$client$state_machine__41689__auto____1.call(this,state_55999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__41689__auto____0;
chord$client$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__41689__auto____1;
return chord$client$state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_56041 = f__41779__auto__();
(statearr_56041[(6)] = c__41778__auto___56049);

return statearr_56041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq55918){
var G__55919 = cljs.core.first(seq55918);
var seq55918__$1 = cljs.core.next(seq55918);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55919,seq55918__$1);
}));


//# sourceMappingURL=chord.client.js.map
