goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_46641 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_46641(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_46644 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_46644(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__45709 = coll;
var G__45710 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__45709,G__45710) : shadow.dom.lazy_native_coll_seq.call(null,G__45709,G__45710));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__45731 = arguments.length;
switch (G__45731) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__45733 = arguments.length;
switch (G__45733) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__45741 = arguments.length;
switch (G__45741) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__45747 = arguments.length;
switch (G__45747) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__45758 = arguments.length;
switch (G__45758) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__45763 = arguments.length;
switch (G__45763) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e45774){if((e45774 instanceof Object)){
var e = e45774;
return console.log("didnt support attachEvent",el,e);
} else {
throw e45774;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__45788 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__45789 = null;
var count__45790 = (0);
var i__45791 = (0);
while(true){
if((i__45791 < count__45790)){
var el = chunk__45789.cljs$core$IIndexed$_nth$arity$2(null,i__45791);
var handler_46668__$1 = ((function (seq__45788,chunk__45789,count__45790,i__45791,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__45788,chunk__45789,count__45790,i__45791,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_46668__$1);


var G__46670 = seq__45788;
var G__46671 = chunk__45789;
var G__46672 = count__45790;
var G__46673 = (i__45791 + (1));
seq__45788 = G__46670;
chunk__45789 = G__46671;
count__45790 = G__46672;
i__45791 = G__46673;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__45788);
if(temp__5720__auto__){
var seq__45788__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__45788__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__45788__$1);
var G__46674 = cljs.core.chunk_rest(seq__45788__$1);
var G__46675 = c__4556__auto__;
var G__46676 = cljs.core.count(c__4556__auto__);
var G__46677 = (0);
seq__45788 = G__46674;
chunk__45789 = G__46675;
count__45790 = G__46676;
i__45791 = G__46677;
continue;
} else {
var el = cljs.core.first(seq__45788__$1);
var handler_46679__$1 = ((function (seq__45788,chunk__45789,count__45790,i__45791,el,seq__45788__$1,temp__5720__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__45788,chunk__45789,count__45790,i__45791,el,seq__45788__$1,temp__5720__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_46679__$1);


var G__46680 = cljs.core.next(seq__45788__$1);
var G__46681 = null;
var G__46682 = (0);
var G__46683 = (0);
seq__45788 = G__46680;
chunk__45789 = G__46681;
count__45790 = G__46682;
i__45791 = G__46683;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__45812 = arguments.length;
switch (G__45812) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__45822 = cljs.core.seq(events);
var chunk__45823 = null;
var count__45824 = (0);
var i__45825 = (0);
while(true){
if((i__45825 < count__45824)){
var vec__45835 = chunk__45823.cljs$core$IIndexed$_nth$arity$2(null,i__45825);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45835,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45835,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__46687 = seq__45822;
var G__46688 = chunk__45823;
var G__46689 = count__45824;
var G__46690 = (i__45825 + (1));
seq__45822 = G__46687;
chunk__45823 = G__46688;
count__45824 = G__46689;
i__45825 = G__46690;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__45822);
if(temp__5720__auto__){
var seq__45822__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__45822__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__45822__$1);
var G__46692 = cljs.core.chunk_rest(seq__45822__$1);
var G__46693 = c__4556__auto__;
var G__46694 = cljs.core.count(c__4556__auto__);
var G__46695 = (0);
seq__45822 = G__46692;
chunk__45823 = G__46693;
count__45824 = G__46694;
i__45825 = G__46695;
continue;
} else {
var vec__45840 = cljs.core.first(seq__45822__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45840,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45840,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__46698 = cljs.core.next(seq__45822__$1);
var G__46699 = null;
var G__46700 = (0);
var G__46701 = (0);
seq__45822 = G__46698;
chunk__45823 = G__46699;
count__45824 = G__46700;
i__45825 = G__46701;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__45844 = cljs.core.seq(styles);
var chunk__45845 = null;
var count__45846 = (0);
var i__45847 = (0);
while(true){
if((i__45847 < count__45846)){
var vec__45858 = chunk__45845.cljs$core$IIndexed$_nth$arity$2(null,i__45847);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45858,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45858,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__46704 = seq__45844;
var G__46705 = chunk__45845;
var G__46706 = count__45846;
var G__46707 = (i__45847 + (1));
seq__45844 = G__46704;
chunk__45845 = G__46705;
count__45846 = G__46706;
i__45847 = G__46707;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__45844);
if(temp__5720__auto__){
var seq__45844__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__45844__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__45844__$1);
var G__46708 = cljs.core.chunk_rest(seq__45844__$1);
var G__46709 = c__4556__auto__;
var G__46710 = cljs.core.count(c__4556__auto__);
var G__46711 = (0);
seq__45844 = G__46708;
chunk__45845 = G__46709;
count__45846 = G__46710;
i__45847 = G__46711;
continue;
} else {
var vec__45865 = cljs.core.first(seq__45844__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45865,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45865,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__46714 = cljs.core.next(seq__45844__$1);
var G__46715 = null;
var G__46716 = (0);
var G__46717 = (0);
seq__45844 = G__46714;
chunk__45845 = G__46715;
count__45846 = G__46716;
i__45847 = G__46717;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__45873_46718 = key;
var G__45873_46719__$1 = (((G__45873_46718 instanceof cljs.core.Keyword))?G__45873_46718.fqn:null);
switch (G__45873_46719__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_46723 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_46723,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_46723,"aria-");
}
})())){
el.setAttribute(ks_46723,value);
} else {
(el[ks_46723] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__45898){
var map__45899 = p__45898;
var map__45899__$1 = (((((!((map__45899 == null))))?(((((map__45899.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45899.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45899):map__45899);
var props = map__45899__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45899__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__45906 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45906,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45906,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45906,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__45913 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__45913,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__45913;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__45921 = arguments.length;
switch (G__45921) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__45931){
var vec__45933 = p__45931;
var seq__45934 = cljs.core.seq(vec__45933);
var first__45935 = cljs.core.first(seq__45934);
var seq__45934__$1 = cljs.core.next(seq__45934);
var nn = first__45935;
var first__45935__$1 = cljs.core.first(seq__45934__$1);
var seq__45934__$2 = cljs.core.next(seq__45934__$1);
var np = first__45935__$1;
var nc = seq__45934__$2;
var node = vec__45933;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__45938 = nn;
var G__45939 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__45938,G__45939) : create_fn.call(null,G__45938,G__45939));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__45940 = nn;
var G__45941 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__45940,G__45941) : create_fn.call(null,G__45940,G__45941));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__45945 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45945,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45945,(1),null);
var seq__45950_46735 = cljs.core.seq(node_children);
var chunk__45951_46736 = null;
var count__45952_46737 = (0);
var i__45953_46738 = (0);
while(true){
if((i__45953_46738 < count__45952_46737)){
var child_struct_46739 = chunk__45951_46736.cljs$core$IIndexed$_nth$arity$2(null,i__45953_46738);
var children_46740 = shadow.dom.dom_node(child_struct_46739);
if(cljs.core.seq_QMARK_(children_46740)){
var seq__45994_46741 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_46740));
var chunk__45996_46742 = null;
var count__45997_46743 = (0);
var i__45998_46744 = (0);
while(true){
if((i__45998_46744 < count__45997_46743)){
var child_46745 = chunk__45996_46742.cljs$core$IIndexed$_nth$arity$2(null,i__45998_46744);
if(cljs.core.truth_(child_46745)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_46745);


var G__46746 = seq__45994_46741;
var G__46747 = chunk__45996_46742;
var G__46748 = count__45997_46743;
var G__46749 = (i__45998_46744 + (1));
seq__45994_46741 = G__46746;
chunk__45996_46742 = G__46747;
count__45997_46743 = G__46748;
i__45998_46744 = G__46749;
continue;
} else {
var G__46750 = seq__45994_46741;
var G__46751 = chunk__45996_46742;
var G__46752 = count__45997_46743;
var G__46753 = (i__45998_46744 + (1));
seq__45994_46741 = G__46750;
chunk__45996_46742 = G__46751;
count__45997_46743 = G__46752;
i__45998_46744 = G__46753;
continue;
}
} else {
var temp__5720__auto___46754 = cljs.core.seq(seq__45994_46741);
if(temp__5720__auto___46754){
var seq__45994_46756__$1 = temp__5720__auto___46754;
if(cljs.core.chunked_seq_QMARK_(seq__45994_46756__$1)){
var c__4556__auto___46757 = cljs.core.chunk_first(seq__45994_46756__$1);
var G__46758 = cljs.core.chunk_rest(seq__45994_46756__$1);
var G__46759 = c__4556__auto___46757;
var G__46760 = cljs.core.count(c__4556__auto___46757);
var G__46761 = (0);
seq__45994_46741 = G__46758;
chunk__45996_46742 = G__46759;
count__45997_46743 = G__46760;
i__45998_46744 = G__46761;
continue;
} else {
var child_46762 = cljs.core.first(seq__45994_46756__$1);
if(cljs.core.truth_(child_46762)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_46762);


var G__46763 = cljs.core.next(seq__45994_46756__$1);
var G__46764 = null;
var G__46765 = (0);
var G__46766 = (0);
seq__45994_46741 = G__46763;
chunk__45996_46742 = G__46764;
count__45997_46743 = G__46765;
i__45998_46744 = G__46766;
continue;
} else {
var G__46767 = cljs.core.next(seq__45994_46756__$1);
var G__46768 = null;
var G__46769 = (0);
var G__46770 = (0);
seq__45994_46741 = G__46767;
chunk__45996_46742 = G__46768;
count__45997_46743 = G__46769;
i__45998_46744 = G__46770;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_46740);
}


var G__46771 = seq__45950_46735;
var G__46772 = chunk__45951_46736;
var G__46773 = count__45952_46737;
var G__46774 = (i__45953_46738 + (1));
seq__45950_46735 = G__46771;
chunk__45951_46736 = G__46772;
count__45952_46737 = G__46773;
i__45953_46738 = G__46774;
continue;
} else {
var temp__5720__auto___46779 = cljs.core.seq(seq__45950_46735);
if(temp__5720__auto___46779){
var seq__45950_46780__$1 = temp__5720__auto___46779;
if(cljs.core.chunked_seq_QMARK_(seq__45950_46780__$1)){
var c__4556__auto___46781 = cljs.core.chunk_first(seq__45950_46780__$1);
var G__46782 = cljs.core.chunk_rest(seq__45950_46780__$1);
var G__46783 = c__4556__auto___46781;
var G__46784 = cljs.core.count(c__4556__auto___46781);
var G__46785 = (0);
seq__45950_46735 = G__46782;
chunk__45951_46736 = G__46783;
count__45952_46737 = G__46784;
i__45953_46738 = G__46785;
continue;
} else {
var child_struct_46790 = cljs.core.first(seq__45950_46780__$1);
var children_46791 = shadow.dom.dom_node(child_struct_46790);
if(cljs.core.seq_QMARK_(children_46791)){
var seq__46012_46793 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_46791));
var chunk__46014_46794 = null;
var count__46015_46795 = (0);
var i__46016_46796 = (0);
while(true){
if((i__46016_46796 < count__46015_46795)){
var child_46801 = chunk__46014_46794.cljs$core$IIndexed$_nth$arity$2(null,i__46016_46796);
if(cljs.core.truth_(child_46801)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_46801);


var G__46803 = seq__46012_46793;
var G__46804 = chunk__46014_46794;
var G__46805 = count__46015_46795;
var G__46806 = (i__46016_46796 + (1));
seq__46012_46793 = G__46803;
chunk__46014_46794 = G__46804;
count__46015_46795 = G__46805;
i__46016_46796 = G__46806;
continue;
} else {
var G__46807 = seq__46012_46793;
var G__46808 = chunk__46014_46794;
var G__46809 = count__46015_46795;
var G__46810 = (i__46016_46796 + (1));
seq__46012_46793 = G__46807;
chunk__46014_46794 = G__46808;
count__46015_46795 = G__46809;
i__46016_46796 = G__46810;
continue;
}
} else {
var temp__5720__auto___46811__$1 = cljs.core.seq(seq__46012_46793);
if(temp__5720__auto___46811__$1){
var seq__46012_46812__$1 = temp__5720__auto___46811__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46012_46812__$1)){
var c__4556__auto___46813 = cljs.core.chunk_first(seq__46012_46812__$1);
var G__46814 = cljs.core.chunk_rest(seq__46012_46812__$1);
var G__46815 = c__4556__auto___46813;
var G__46816 = cljs.core.count(c__4556__auto___46813);
var G__46817 = (0);
seq__46012_46793 = G__46814;
chunk__46014_46794 = G__46815;
count__46015_46795 = G__46816;
i__46016_46796 = G__46817;
continue;
} else {
var child_46818 = cljs.core.first(seq__46012_46812__$1);
if(cljs.core.truth_(child_46818)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_46818);


var G__46819 = cljs.core.next(seq__46012_46812__$1);
var G__46820 = null;
var G__46821 = (0);
var G__46822 = (0);
seq__46012_46793 = G__46819;
chunk__46014_46794 = G__46820;
count__46015_46795 = G__46821;
i__46016_46796 = G__46822;
continue;
} else {
var G__46823 = cljs.core.next(seq__46012_46812__$1);
var G__46824 = null;
var G__46825 = (0);
var G__46826 = (0);
seq__46012_46793 = G__46823;
chunk__46014_46794 = G__46824;
count__46015_46795 = G__46825;
i__46016_46796 = G__46826;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_46791);
}


var G__46827 = cljs.core.next(seq__45950_46780__$1);
var G__46828 = null;
var G__46829 = (0);
var G__46830 = (0);
seq__45950_46735 = G__46827;
chunk__45951_46736 = G__46828;
count__45952_46737 = G__46829;
i__45953_46738 = G__46830;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__46043 = cljs.core.seq(node);
var chunk__46044 = null;
var count__46045 = (0);
var i__46046 = (0);
while(true){
if((i__46046 < count__46045)){
var n = chunk__46044.cljs$core$IIndexed$_nth$arity$2(null,i__46046);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__46834 = seq__46043;
var G__46835 = chunk__46044;
var G__46836 = count__46045;
var G__46837 = (i__46046 + (1));
seq__46043 = G__46834;
chunk__46044 = G__46835;
count__46045 = G__46836;
i__46046 = G__46837;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46043);
if(temp__5720__auto__){
var seq__46043__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46043__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46043__$1);
var G__46841 = cljs.core.chunk_rest(seq__46043__$1);
var G__46842 = c__4556__auto__;
var G__46843 = cljs.core.count(c__4556__auto__);
var G__46844 = (0);
seq__46043 = G__46841;
chunk__46044 = G__46842;
count__46045 = G__46843;
i__46046 = G__46844;
continue;
} else {
var n = cljs.core.first(seq__46043__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__46845 = cljs.core.next(seq__46043__$1);
var G__46846 = null;
var G__46847 = (0);
var G__46848 = (0);
seq__46043 = G__46845;
chunk__46044 = G__46846;
count__46045 = G__46847;
i__46046 = G__46848;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__46053 = arguments.length;
switch (G__46053) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__46058 = arguments.length;
switch (G__46058) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__46062 = arguments.length;
switch (G__46062) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___46858 = arguments.length;
var i__4737__auto___46859 = (0);
while(true){
if((i__4737__auto___46859 < len__4736__auto___46858)){
args__4742__auto__.push((arguments[i__4737__auto___46859]));

var G__46860 = (i__4737__auto___46859 + (1));
i__4737__auto___46859 = G__46860;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__46084_46861 = cljs.core.seq(nodes);
var chunk__46085_46862 = null;
var count__46086_46863 = (0);
var i__46087_46864 = (0);
while(true){
if((i__46087_46864 < count__46086_46863)){
var node_46865 = chunk__46085_46862.cljs$core$IIndexed$_nth$arity$2(null,i__46087_46864);
fragment.appendChild(shadow.dom._to_dom(node_46865));


var G__46866 = seq__46084_46861;
var G__46867 = chunk__46085_46862;
var G__46868 = count__46086_46863;
var G__46869 = (i__46087_46864 + (1));
seq__46084_46861 = G__46866;
chunk__46085_46862 = G__46867;
count__46086_46863 = G__46868;
i__46087_46864 = G__46869;
continue;
} else {
var temp__5720__auto___46872 = cljs.core.seq(seq__46084_46861);
if(temp__5720__auto___46872){
var seq__46084_46873__$1 = temp__5720__auto___46872;
if(cljs.core.chunked_seq_QMARK_(seq__46084_46873__$1)){
var c__4556__auto___46876 = cljs.core.chunk_first(seq__46084_46873__$1);
var G__46877 = cljs.core.chunk_rest(seq__46084_46873__$1);
var G__46878 = c__4556__auto___46876;
var G__46879 = cljs.core.count(c__4556__auto___46876);
var G__46880 = (0);
seq__46084_46861 = G__46877;
chunk__46085_46862 = G__46878;
count__46086_46863 = G__46879;
i__46087_46864 = G__46880;
continue;
} else {
var node_46883 = cljs.core.first(seq__46084_46873__$1);
fragment.appendChild(shadow.dom._to_dom(node_46883));


var G__46886 = cljs.core.next(seq__46084_46873__$1);
var G__46887 = null;
var G__46888 = (0);
var G__46889 = (0);
seq__46084_46861 = G__46886;
chunk__46085_46862 = G__46887;
count__46086_46863 = G__46888;
i__46087_46864 = G__46889;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq46074){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46074));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__46113_46893 = cljs.core.seq(scripts);
var chunk__46114_46894 = null;
var count__46115_46895 = (0);
var i__46116_46896 = (0);
while(true){
if((i__46116_46896 < count__46115_46895)){
var vec__46132_46897 = chunk__46114_46894.cljs$core$IIndexed$_nth$arity$2(null,i__46116_46896);
var script_tag_46898 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46132_46897,(0),null);
var script_body_46899 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46132_46897,(1),null);
eval(script_body_46899);


var G__46900 = seq__46113_46893;
var G__46901 = chunk__46114_46894;
var G__46902 = count__46115_46895;
var G__46903 = (i__46116_46896 + (1));
seq__46113_46893 = G__46900;
chunk__46114_46894 = G__46901;
count__46115_46895 = G__46902;
i__46116_46896 = G__46903;
continue;
} else {
var temp__5720__auto___46904 = cljs.core.seq(seq__46113_46893);
if(temp__5720__auto___46904){
var seq__46113_46905__$1 = temp__5720__auto___46904;
if(cljs.core.chunked_seq_QMARK_(seq__46113_46905__$1)){
var c__4556__auto___46906 = cljs.core.chunk_first(seq__46113_46905__$1);
var G__46907 = cljs.core.chunk_rest(seq__46113_46905__$1);
var G__46908 = c__4556__auto___46906;
var G__46909 = cljs.core.count(c__4556__auto___46906);
var G__46910 = (0);
seq__46113_46893 = G__46907;
chunk__46114_46894 = G__46908;
count__46115_46895 = G__46909;
i__46116_46896 = G__46910;
continue;
} else {
var vec__46144_46911 = cljs.core.first(seq__46113_46905__$1);
var script_tag_46912 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46144_46911,(0),null);
var script_body_46913 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46144_46911,(1),null);
eval(script_body_46913);


var G__46918 = cljs.core.next(seq__46113_46905__$1);
var G__46919 = null;
var G__46920 = (0);
var G__46921 = (0);
seq__46113_46893 = G__46918;
chunk__46114_46894 = G__46919;
count__46115_46895 = G__46920;
i__46116_46896 = G__46921;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__46152){
var vec__46153 = p__46152;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46153,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46153,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__46171 = arguments.length;
switch (G__46171) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__46195 = cljs.core.seq(style_keys);
var chunk__46196 = null;
var count__46197 = (0);
var i__46198 = (0);
while(true){
if((i__46198 < count__46197)){
var it = chunk__46196.cljs$core$IIndexed$_nth$arity$2(null,i__46198);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__46940 = seq__46195;
var G__46941 = chunk__46196;
var G__46942 = count__46197;
var G__46943 = (i__46198 + (1));
seq__46195 = G__46940;
chunk__46196 = G__46941;
count__46197 = G__46942;
i__46198 = G__46943;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46195);
if(temp__5720__auto__){
var seq__46195__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46195__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46195__$1);
var G__46945 = cljs.core.chunk_rest(seq__46195__$1);
var G__46946 = c__4556__auto__;
var G__46947 = cljs.core.count(c__4556__auto__);
var G__46948 = (0);
seq__46195 = G__46945;
chunk__46196 = G__46946;
count__46197 = G__46947;
i__46198 = G__46948;
continue;
} else {
var it = cljs.core.first(seq__46195__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__46952 = cljs.core.next(seq__46195__$1);
var G__46953 = null;
var G__46954 = (0);
var G__46955 = (0);
seq__46195 = G__46952;
chunk__46196 = G__46953;
count__46197 = G__46954;
i__46198 = G__46955;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k46223,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__46237 = k46223;
var G__46237__$1 = (((G__46237 instanceof cljs.core.Keyword))?G__46237.fqn:null);
switch (G__46237__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46223,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__46245){
var vec__46247 = p__46245;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46247,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46247,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46222){
var self__ = this;
var G__46222__$1 = this;
return (new cljs.core.RecordIter((0),G__46222__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46224,other46225){
var self__ = this;
var this46224__$1 = this;
return (((!((other46225 == null)))) && ((this46224__$1.constructor === other46225.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46224__$1.x,other46225.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46224__$1.y,other46225.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46224__$1.__extmap,other46225.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__46222){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__46268 = cljs.core.keyword_identical_QMARK_;
var expr__46269 = k__4388__auto__;
if(cljs.core.truth_((pred__46268.cljs$core$IFn$_invoke$arity$2 ? pred__46268.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__46269) : pred__46268.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__46269)))){
return (new shadow.dom.Coordinate(G__46222,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__46268.cljs$core$IFn$_invoke$arity$2 ? pred__46268.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__46269) : pred__46268.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__46269)))){
return (new shadow.dom.Coordinate(self__.x,G__46222,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__46222),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__46222){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__46222,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__46227){
var extmap__4419__auto__ = (function (){var G__46294 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46227,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__46227)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46294);
} else {
return G__46294;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__46227),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__46227),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k46308,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__46317 = k46308;
var G__46317__$1 = (((G__46317 instanceof cljs.core.Keyword))?G__46317.fqn:null);
switch (G__46317__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46308,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__46322){
var vec__46323 = p__46322;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46323,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46323,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46307){
var self__ = this;
var G__46307__$1 = this;
return (new cljs.core.RecordIter((0),G__46307__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46310,other46311){
var self__ = this;
var this46310__$1 = this;
return (((!((other46311 == null)))) && ((this46310__$1.constructor === other46311.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46310__$1.w,other46311.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46310__$1.h,other46311.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46310__$1.__extmap,other46311.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__46307){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__46359 = cljs.core.keyword_identical_QMARK_;
var expr__46360 = k__4388__auto__;
if(cljs.core.truth_((pred__46359.cljs$core$IFn$_invoke$arity$2 ? pred__46359.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__46360) : pred__46359.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__46360)))){
return (new shadow.dom.Size(G__46307,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__46359.cljs$core$IFn$_invoke$arity$2 ? pred__46359.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__46360) : pred__46359.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__46360)))){
return (new shadow.dom.Size(self__.w,G__46307,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__46307),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__46307){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__46307,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__46313){
var extmap__4419__auto__ = (function (){var G__46387 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46313,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__46313)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46387);
} else {
return G__46387;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__46313),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__46313),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__47007 = (i + (1));
var G__47008 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__47007;
ret = G__47008;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__46436){
var vec__46437 = p__46436;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46437,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46437,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__46447 = arguments.length;
switch (G__46447) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__47018 = ps;
var G__47019 = (i + (1));
el__$1 = G__47018;
i = G__47019;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__46487 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46487,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46487,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46487,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__46493_47034 = cljs.core.seq(props);
var chunk__46494_47035 = null;
var count__46495_47036 = (0);
var i__46496_47037 = (0);
while(true){
if((i__46496_47037 < count__46495_47036)){
var vec__46505_47043 = chunk__46494_47035.cljs$core$IIndexed$_nth$arity$2(null,i__46496_47037);
var k_47044 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46505_47043,(0),null);
var v_47045 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46505_47043,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace(k_47044);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_47044),v_47045);


var G__47047 = seq__46493_47034;
var G__47048 = chunk__46494_47035;
var G__47049 = count__46495_47036;
var G__47050 = (i__46496_47037 + (1));
seq__46493_47034 = G__47047;
chunk__46494_47035 = G__47048;
count__46495_47036 = G__47049;
i__46496_47037 = G__47050;
continue;
} else {
var temp__5720__auto___47052 = cljs.core.seq(seq__46493_47034);
if(temp__5720__auto___47052){
var seq__46493_47053__$1 = temp__5720__auto___47052;
if(cljs.core.chunked_seq_QMARK_(seq__46493_47053__$1)){
var c__4556__auto___47054 = cljs.core.chunk_first(seq__46493_47053__$1);
var G__47055 = cljs.core.chunk_rest(seq__46493_47053__$1);
var G__47056 = c__4556__auto___47054;
var G__47057 = cljs.core.count(c__4556__auto___47054);
var G__47058 = (0);
seq__46493_47034 = G__47055;
chunk__46494_47035 = G__47056;
count__46495_47036 = G__47057;
i__46496_47037 = G__47058;
continue;
} else {
var vec__46513_47060 = cljs.core.first(seq__46493_47053__$1);
var k_47061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46513_47060,(0),null);
var v_47062 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46513_47060,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace(k_47061);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_47061),v_47062);


var G__47070 = cljs.core.next(seq__46493_47053__$1);
var G__47071 = null;
var G__47072 = (0);
var G__47073 = (0);
seq__46493_47034 = G__47070;
chunk__46494_47035 = G__47071;
count__46495_47036 = G__47072;
i__46496_47037 = G__47073;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__46525 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46525,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46525,(1),null);
var seq__46528_47074 = cljs.core.seq(node_children);
var chunk__46530_47075 = null;
var count__46531_47076 = (0);
var i__46532_47077 = (0);
while(true){
if((i__46532_47077 < count__46531_47076)){
var child_struct_47079 = chunk__46530_47075.cljs$core$IIndexed$_nth$arity$2(null,i__46532_47077);
if((!((child_struct_47079 == null)))){
if(typeof child_struct_47079 === 'string'){
var text_47081 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47081),child_struct_47079].join(''));
} else {
var children_47082 = shadow.dom.svg_node(child_struct_47079);
if(cljs.core.seq_QMARK_(children_47082)){
var seq__46574_47083 = cljs.core.seq(children_47082);
var chunk__46576_47084 = null;
var count__46577_47085 = (0);
var i__46578_47086 = (0);
while(true){
if((i__46578_47086 < count__46577_47085)){
var child_47087 = chunk__46576_47084.cljs$core$IIndexed$_nth$arity$2(null,i__46578_47086);
if(cljs.core.truth_(child_47087)){
node.appendChild(child_47087);


var G__47088 = seq__46574_47083;
var G__47089 = chunk__46576_47084;
var G__47090 = count__46577_47085;
var G__47091 = (i__46578_47086 + (1));
seq__46574_47083 = G__47088;
chunk__46576_47084 = G__47089;
count__46577_47085 = G__47090;
i__46578_47086 = G__47091;
continue;
} else {
var G__47092 = seq__46574_47083;
var G__47093 = chunk__46576_47084;
var G__47094 = count__46577_47085;
var G__47095 = (i__46578_47086 + (1));
seq__46574_47083 = G__47092;
chunk__46576_47084 = G__47093;
count__46577_47085 = G__47094;
i__46578_47086 = G__47095;
continue;
}
} else {
var temp__5720__auto___47097 = cljs.core.seq(seq__46574_47083);
if(temp__5720__auto___47097){
var seq__46574_47098__$1 = temp__5720__auto___47097;
if(cljs.core.chunked_seq_QMARK_(seq__46574_47098__$1)){
var c__4556__auto___47099 = cljs.core.chunk_first(seq__46574_47098__$1);
var G__47100 = cljs.core.chunk_rest(seq__46574_47098__$1);
var G__47101 = c__4556__auto___47099;
var G__47102 = cljs.core.count(c__4556__auto___47099);
var G__47103 = (0);
seq__46574_47083 = G__47100;
chunk__46576_47084 = G__47101;
count__46577_47085 = G__47102;
i__46578_47086 = G__47103;
continue;
} else {
var child_47104 = cljs.core.first(seq__46574_47098__$1);
if(cljs.core.truth_(child_47104)){
node.appendChild(child_47104);


var G__47109 = cljs.core.next(seq__46574_47098__$1);
var G__47110 = null;
var G__47111 = (0);
var G__47112 = (0);
seq__46574_47083 = G__47109;
chunk__46576_47084 = G__47110;
count__46577_47085 = G__47111;
i__46578_47086 = G__47112;
continue;
} else {
var G__47113 = cljs.core.next(seq__46574_47098__$1);
var G__47114 = null;
var G__47115 = (0);
var G__47116 = (0);
seq__46574_47083 = G__47113;
chunk__46576_47084 = G__47114;
count__46577_47085 = G__47115;
i__46578_47086 = G__47116;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47082);
}
}


var G__47117 = seq__46528_47074;
var G__47118 = chunk__46530_47075;
var G__47119 = count__46531_47076;
var G__47120 = (i__46532_47077 + (1));
seq__46528_47074 = G__47117;
chunk__46530_47075 = G__47118;
count__46531_47076 = G__47119;
i__46532_47077 = G__47120;
continue;
} else {
var G__47122 = seq__46528_47074;
var G__47123 = chunk__46530_47075;
var G__47124 = count__46531_47076;
var G__47125 = (i__46532_47077 + (1));
seq__46528_47074 = G__47122;
chunk__46530_47075 = G__47123;
count__46531_47076 = G__47124;
i__46532_47077 = G__47125;
continue;
}
} else {
var temp__5720__auto___47126 = cljs.core.seq(seq__46528_47074);
if(temp__5720__auto___47126){
var seq__46528_47127__$1 = temp__5720__auto___47126;
if(cljs.core.chunked_seq_QMARK_(seq__46528_47127__$1)){
var c__4556__auto___47128 = cljs.core.chunk_first(seq__46528_47127__$1);
var G__47129 = cljs.core.chunk_rest(seq__46528_47127__$1);
var G__47130 = c__4556__auto___47128;
var G__47131 = cljs.core.count(c__4556__auto___47128);
var G__47132 = (0);
seq__46528_47074 = G__47129;
chunk__46530_47075 = G__47130;
count__46531_47076 = G__47131;
i__46532_47077 = G__47132;
continue;
} else {
var child_struct_47133 = cljs.core.first(seq__46528_47127__$1);
if((!((child_struct_47133 == null)))){
if(typeof child_struct_47133 === 'string'){
var text_47134 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47134),child_struct_47133].join(''));
} else {
var children_47138 = shadow.dom.svg_node(child_struct_47133);
if(cljs.core.seq_QMARK_(children_47138)){
var seq__46588_47139 = cljs.core.seq(children_47138);
var chunk__46590_47140 = null;
var count__46591_47141 = (0);
var i__46592_47142 = (0);
while(true){
if((i__46592_47142 < count__46591_47141)){
var child_47143 = chunk__46590_47140.cljs$core$IIndexed$_nth$arity$2(null,i__46592_47142);
if(cljs.core.truth_(child_47143)){
node.appendChild(child_47143);


var G__47146 = seq__46588_47139;
var G__47147 = chunk__46590_47140;
var G__47148 = count__46591_47141;
var G__47149 = (i__46592_47142 + (1));
seq__46588_47139 = G__47146;
chunk__46590_47140 = G__47147;
count__46591_47141 = G__47148;
i__46592_47142 = G__47149;
continue;
} else {
var G__47150 = seq__46588_47139;
var G__47151 = chunk__46590_47140;
var G__47152 = count__46591_47141;
var G__47153 = (i__46592_47142 + (1));
seq__46588_47139 = G__47150;
chunk__46590_47140 = G__47151;
count__46591_47141 = G__47152;
i__46592_47142 = G__47153;
continue;
}
} else {
var temp__5720__auto___47156__$1 = cljs.core.seq(seq__46588_47139);
if(temp__5720__auto___47156__$1){
var seq__46588_47160__$1 = temp__5720__auto___47156__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46588_47160__$1)){
var c__4556__auto___47161 = cljs.core.chunk_first(seq__46588_47160__$1);
var G__47162 = cljs.core.chunk_rest(seq__46588_47160__$1);
var G__47163 = c__4556__auto___47161;
var G__47164 = cljs.core.count(c__4556__auto___47161);
var G__47165 = (0);
seq__46588_47139 = G__47162;
chunk__46590_47140 = G__47163;
count__46591_47141 = G__47164;
i__46592_47142 = G__47165;
continue;
} else {
var child_47167 = cljs.core.first(seq__46588_47160__$1);
if(cljs.core.truth_(child_47167)){
node.appendChild(child_47167);


var G__47168 = cljs.core.next(seq__46588_47160__$1);
var G__47169 = null;
var G__47170 = (0);
var G__47171 = (0);
seq__46588_47139 = G__47168;
chunk__46590_47140 = G__47169;
count__46591_47141 = G__47170;
i__46592_47142 = G__47171;
continue;
} else {
var G__47175 = cljs.core.next(seq__46588_47160__$1);
var G__47176 = null;
var G__47177 = (0);
var G__47178 = (0);
seq__46588_47139 = G__47175;
chunk__46590_47140 = G__47176;
count__46591_47141 = G__47177;
i__46592_47142 = G__47178;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47138);
}
}


var G__47180 = cljs.core.next(seq__46528_47127__$1);
var G__47181 = null;
var G__47182 = (0);
var G__47183 = (0);
seq__46528_47074 = G__47180;
chunk__46530_47075 = G__47181;
count__46531_47076 = G__47182;
i__46532_47077 = G__47183;
continue;
} else {
var G__47184 = cljs.core.next(seq__46528_47127__$1);
var G__47185 = null;
var G__47186 = (0);
var G__47187 = (0);
seq__46528_47074 = G__47184;
chunk__46530_47075 = G__47185;
count__46531_47076 = G__47186;
i__46532_47077 = G__47187;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47189 = arguments.length;
var i__4737__auto___47190 = (0);
while(true){
if((i__4737__auto___47190 < len__4736__auto___47189)){
args__4742__auto__.push((arguments[i__4737__auto___47190]));

var G__47191 = (i__4737__auto___47190 + (1));
i__4737__auto___47190 = G__47191;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq46606){
var G__46607 = cljs.core.first(seq46606);
var seq46606__$1 = cljs.core.next(seq46606);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46607,seq46606__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__46611 = arguments.length;
switch (G__46611) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__42847__auto___47200 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42848__auto__ = (function (){var switch__42590__auto__ = (function (state_46624){
var state_val_46625 = (state_46624[(1)]);
if((state_val_46625 === (1))){
var state_46624__$1 = state_46624;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46624__$1,(2),once_or_cleanup);
} else {
if((state_val_46625 === (2))){
var inst_46621 = (state_46624[(2)]);
var inst_46622 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_46624__$1 = (function (){var statearr_46629 = state_46624;
(statearr_46629[(7)] = inst_46621);

return statearr_46629;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46624__$1,inst_46622);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__42591__auto__ = null;
var shadow$dom$state_machine__42591__auto____0 = (function (){
var statearr_46630 = [null,null,null,null,null,null,null,null];
(statearr_46630[(0)] = shadow$dom$state_machine__42591__auto__);

(statearr_46630[(1)] = (1));

return statearr_46630;
});
var shadow$dom$state_machine__42591__auto____1 = (function (state_46624){
while(true){
var ret_value__42592__auto__ = (function (){try{while(true){
var result__42593__auto__ = switch__42590__auto__(state_46624);
if(cljs.core.keyword_identical_QMARK_(result__42593__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42593__auto__;
}
break;
}
}catch (e46632){if((e46632 instanceof Object)){
var ex__42594__auto__ = e46632;
var statearr_46633_47216 = state_46624;
(statearr_46633_47216[(5)] = ex__42594__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_46624);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46632;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42592__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47217 = state_46624;
state_46624 = G__47217;
continue;
} else {
return ret_value__42592__auto__;
}
break;
}
});
shadow$dom$state_machine__42591__auto__ = function(state_46624){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__42591__auto____0.call(this);
case 1:
return shadow$dom$state_machine__42591__auto____1.call(this,state_46624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__42591__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__42591__auto____0;
shadow$dom$state_machine__42591__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__42591__auto____1;
return shadow$dom$state_machine__42591__auto__;
})()
})();
var state__42849__auto__ = (function (){var statearr_46635 = f__42848__auto__();
(statearr_46635[(6)] = c__42847__auto___47200);

return statearr_46635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42849__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
