goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e52883){var e = e52883;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4742__auto__ = [];
var len__4736__auto___53020 = arguments.length;
var i__4737__auto___53021 = (0);
while(true){
if((i__4737__auto___53021 < len__4736__auto___53020)){
args__4742__auto__.push((arguments[i__4737__auto___53021]));

var G__53022 = (i__4737__auto___53021 + (1));
i__4737__auto___53021 = G__53022;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__52889){
var vec__52890 = p__52889;
var map__52893 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52890,(0),null);
var map__52893__$1 = (((((!((map__52893 == null))))?(((((map__52893.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52893.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52893):map__52893);
var opts = map__52893__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52893__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52893__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52893__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52893__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__52895 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4126__auto__ = read_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4126__auto__ = write_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__52895__$1 = (((((!((map__52895 == null))))?(((((map__52895.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52895.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52895):map__52895);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52895__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52895__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__52884_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__52884_SHARP_);
}));

(web_socket.onclose = (function (p1__52885_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__52885_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__43595__auto___53029 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_52966){
var state_val_52967 = (state_52966[(1)]);
if((state_val_52967 === (7))){
var inst_52962 = (state_52966[(2)]);
var state_52966__$1 = state_52966;
var statearr_52972_53032 = state_52966__$1;
(statearr_52972_53032[(2)] = inst_52962);

(statearr_52972_53032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (20))){
var state_52966__$1 = state_52966;
var statearr_52973_53034 = state_52966__$1;
(statearr_52973_53034[(2)] = null);

(statearr_52973_53034[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (1))){
var inst_52897 = false;
var state_52966__$1 = (function (){var statearr_52974 = state_52966;
(statearr_52974[(7)] = inst_52897);

return statearr_52974;
})();
var statearr_52976_53041 = state_52966__$1;
(statearr_52976_53041[(2)] = null);

(statearr_52976_53041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (4))){
var inst_52916 = (state_52966[(8)]);
var inst_52908 = (state_52966[(9)]);
var inst_52914 = (state_52966[(10)]);
var inst_52914__$1 = (state_52966[(2)]);
var inst_52915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_52914__$1,(0),null);
var inst_52916__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_52914__$1,(1),null);
var inst_52917 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_52916__$1,inst_52908);
var state_52966__$1 = (function (){var statearr_52977 = state_52966;
(statearr_52977[(8)] = inst_52916__$1);

(statearr_52977[(10)] = inst_52914__$1);

(statearr_52977[(11)] = inst_52915);

return statearr_52977;
})();
if(inst_52917){
var statearr_52982_53042 = state_52966__$1;
(statearr_52982_53042[(1)] = (5));

} else {
var statearr_52983_53043 = state_52966__$1;
(statearr_52983_53043[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (15))){
var inst_52947 = (state_52966[(2)]);
var state_52966__$1 = state_52966;
var statearr_52984_53046 = state_52966__$1;
(statearr_52984_53046[(2)] = inst_52947);

(statearr_52984_53046[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (21))){
var inst_52958 = (state_52966[(2)]);
var state_52966__$1 = state_52966;
var statearr_52985_53048 = state_52966__$1;
(statearr_52985_53048[(2)] = inst_52958);

(statearr_52985_53048[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (13))){
var state_52966__$1 = state_52966;
var statearr_52986_53050 = state_52966__$1;
(statearr_52986_53050[(2)] = null);

(statearr_52986_53050[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (6))){
var inst_52916 = (state_52966[(8)]);
var inst_52909 = (state_52966[(12)]);
var inst_52931 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_52916,inst_52909);
var state_52966__$1 = state_52966;
if(inst_52931){
var statearr_52987_53054 = state_52966__$1;
(statearr_52987_53054[(1)] = (9));

} else {
var statearr_52988_53055 = state_52966__$1;
(statearr_52988_53055[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (17))){
var state_52966__$1 = state_52966;
var statearr_52989_53059 = state_52966__$1;
(statearr_52989_53059[(2)] = initial_ch);

(statearr_52989_53059[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (3))){
var inst_52964 = (state_52966[(2)]);
var state_52966__$1 = state_52966;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52966__$1,inst_52964);
} else {
if((state_val_52967 === (12))){
var inst_52897 = (state_52966[(7)]);
var state_52966__$1 = state_52966;
if(cljs.core.truth_(inst_52897)){
var statearr_52990_53060 = state_52966__$1;
(statearr_52990_53060[(1)] = (16));

} else {
var statearr_52991_53061 = state_52966__$1;
(statearr_52991_53061[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (2))){
var inst_52908 = (state_52966[(9)]);
var inst_52909 = (state_52966[(12)]);
var inst_52908__$1 = open_ch;
var inst_52909__$1 = close_ch;
var inst_52910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52911 = [inst_52908__$1,inst_52909__$1];
var inst_52912 = (new cljs.core.PersistentVector(null,2,(5),inst_52910,inst_52911,null));
var state_52966__$1 = (function (){var statearr_52992 = state_52966;
(statearr_52992[(9)] = inst_52908__$1);

(statearr_52992[(12)] = inst_52909__$1);

return statearr_52992;
})();
return cljs.core.async.ioc_alts_BANG_(state_52966__$1,(4),inst_52912);
} else {
if((state_val_52967 === (19))){
var inst_52915 = (state_52966[(11)]);
var state_52966__$1 = state_52966;
var statearr_52993_53064 = state_52966__$1;
(statearr_52993_53064[(2)] = inst_52915);

(statearr_52993_53064[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (11))){
var inst_52960 = (state_52966[(2)]);
var state_52966__$1 = state_52966;
var statearr_52994_53065 = state_52966__$1;
(statearr_52994_53065[(2)] = inst_52960);

(statearr_52994_53065[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (9))){
var inst_52914 = (state_52966[(10)]);
var inst_52937 = (state_52966[(13)]);
var inst_52936 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_52914,(0),null);
var inst_52937__$1 = chord.client.close_event__GT_maybe_error(inst_52936);
var state_52966__$1 = (function (){var statearr_52995 = state_52966;
(statearr_52995[(13)] = inst_52937__$1);

return statearr_52995;
})();
if(cljs.core.truth_(inst_52937__$1)){
var statearr_52996_53069 = state_52966__$1;
(statearr_52996_53069[(1)] = (12));

} else {
var statearr_52997_53070 = state_52966__$1;
(statearr_52997_53070[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (5))){
var inst_52914 = (state_52966[(10)]);
var inst_52922 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_52914,(0),null);
var inst_52923 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_52924 = [ws_chan];
var inst_52925 = cljs.core.PersistentHashMap.fromArrays(inst_52923,inst_52924);
var state_52966__$1 = (function (){var statearr_52998 = state_52966;
(statearr_52998[(14)] = inst_52922);

return statearr_52998;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52966__$1,(8),initial_ch,inst_52925);
} else {
if((state_val_52967 === (14))){
var inst_52950 = (state_52966[(2)]);
var inst_52951 = cljs.core.async.close_BANG_(ws_chan);
var inst_52952 = cljs.core.async.close_BANG_(initial_ch);
var state_52966__$1 = (function (){var statearr_52999 = state_52966;
(statearr_52999[(15)] = inst_52951);

(statearr_52999[(16)] = inst_52950);

return statearr_52999;
})();
var statearr_53000_53073 = state_52966__$1;
(statearr_53000_53073[(2)] = inst_52952);

(statearr_53000_53073[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (16))){
var state_52966__$1 = state_52966;
var statearr_53003_53076 = state_52966__$1;
(statearr_53003_53076[(2)] = read_ch__$1);

(statearr_53003_53076[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (10))){
var inst_52916 = (state_52966[(8)]);
var inst_52954 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_52916,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_52966__$1 = state_52966;
if(inst_52954){
var statearr_53004_53081 = state_52966__$1;
(statearr_53004_53081[(1)] = (19));

} else {
var statearr_53005_53082 = state_52966__$1;
(statearr_53005_53082[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52967 === (18))){
var inst_52937 = (state_52966[(13)]);
var inst_52942 = (state_52966[(2)]);
var inst_52943 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_52944 = [inst_52937];
var inst_52945 = cljs.core.PersistentHashMap.fromArrays(inst_52943,inst_52944);
var state_52966__$1 = state_52966;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52966__$1,(15),inst_52942,inst_52945);
} else {
if((state_val_52967 === (8))){
var inst_52927 = (state_52966[(2)]);
var inst_52928 = cljs.core.async.close_BANG_(initial_ch);
var inst_52897 = true;
var state_52966__$1 = (function (){var statearr_53006 = state_52966;
(statearr_53006[(7)] = inst_52897);

(statearr_53006[(17)] = inst_52927);

(statearr_53006[(18)] = inst_52928);

return statearr_53006;
})();
var statearr_53007_53086 = state_52966__$1;
(statearr_53007_53086[(2)] = null);

(statearr_53007_53086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__43403__auto__ = null;
var chord$client$state_machine__43403__auto____0 = (function (){
var statearr_53012 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53012[(0)] = chord$client$state_machine__43403__auto__);

(statearr_53012[(1)] = (1));

return statearr_53012;
});
var chord$client$state_machine__43403__auto____1 = (function (state_52966){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_52966);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e53013){var ex__43406__auto__ = e53013;
var statearr_53014_53093 = state_52966;
(statearr_53014_53093[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_52966[(4)]))){
var statearr_53015_53101 = state_52966;
(statearr_53015_53101[(1)] = cljs.core.first((state_52966[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53102 = state_52966;
state_52966 = G__53102;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
chord$client$state_machine__43403__auto__ = function(state_52966){
switch(arguments.length){
case 0:
return chord$client$state_machine__43403__auto____0.call(this);
case 1:
return chord$client$state_machine__43403__auto____1.call(this,state_52966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__43403__auto____0;
chord$client$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__43403__auto____1;
return chord$client$state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_53017 = f__43596__auto__();
(statearr_53017[(6)] = c__43595__auto___53029);

return statearr_53017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq52886){
var G__52887 = cljs.core.first(seq52886);
var seq52886__$1 = cljs.core.next(seq52886);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__52887,seq52886__$1);
}));


//# sourceMappingURL=chord.client.js.map
