goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__43689 = arguments.length;
switch (G__43689) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43691 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43691 = (function (f,blockable,meta43692){
this.f = f;
this.blockable = blockable;
this.meta43692 = meta43692;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43691.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43693,meta43692__$1){
var self__ = this;
var _43693__$1 = this;
return (new cljs.core.async.t_cljs$core$async43691(self__.f,self__.blockable,meta43692__$1));
}));

(cljs.core.async.t_cljs$core$async43691.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43693){
var self__ = this;
var _43693__$1 = this;
return self__.meta43692;
}));

(cljs.core.async.t_cljs$core$async43691.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43691.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43691.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async43691.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async43691.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta43692","meta43692",-1686853553,null)], null);
}));

(cljs.core.async.t_cljs$core$async43691.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43691.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43691");

(cljs.core.async.t_cljs$core$async43691.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async43691");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43691.
 */
cljs.core.async.__GT_t_cljs$core$async43691 = (function cljs$core$async$__GT_t_cljs$core$async43691(f__$1,blockable__$1,meta43692){
return (new cljs.core.async.t_cljs$core$async43691(f__$1,blockable__$1,meta43692));
});

}

return (new cljs.core.async.t_cljs$core$async43691(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__43712 = arguments.length;
switch (G__43712) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__43729 = arguments.length;
switch (G__43729) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__43752 = arguments.length;
switch (G__43752) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_46322 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_46322) : fn1.call(null,val_46322));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_46322) : fn1.call(null,val_46322));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__43765 = arguments.length;
switch (G__43765) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___46355 = n;
var x_46356 = (0);
while(true){
if((x_46356 < n__4613__auto___46355)){
(a[x_46356] = x_46356);

var G__46357 = (x_46356 + (1));
x_46356 = G__46357;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43797 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43797 = (function (flag,meta43798){
this.flag = flag;
this.meta43798 = meta43798;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43797.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43799,meta43798__$1){
var self__ = this;
var _43799__$1 = this;
return (new cljs.core.async.t_cljs$core$async43797(self__.flag,meta43798__$1));
}));

(cljs.core.async.t_cljs$core$async43797.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43799){
var self__ = this;
var _43799__$1 = this;
return self__.meta43798;
}));

(cljs.core.async.t_cljs$core$async43797.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43797.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async43797.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43797.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async43797.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta43798","meta43798",112803425,null)], null);
}));

(cljs.core.async.t_cljs$core$async43797.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43797.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43797");

(cljs.core.async.t_cljs$core$async43797.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async43797");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43797.
 */
cljs.core.async.__GT_t_cljs$core$async43797 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async43797(flag__$1,meta43798){
return (new cljs.core.async.t_cljs$core$async43797(flag__$1,meta43798));
});

}

return (new cljs.core.async.t_cljs$core$async43797(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43813 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43813 = (function (flag,cb,meta43814){
this.flag = flag;
this.cb = cb;
this.meta43814 = meta43814;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43813.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43815,meta43814__$1){
var self__ = this;
var _43815__$1 = this;
return (new cljs.core.async.t_cljs$core$async43813(self__.flag,self__.cb,meta43814__$1));
}));

(cljs.core.async.t_cljs$core$async43813.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43815){
var self__ = this;
var _43815__$1 = this;
return self__.meta43814;
}));

(cljs.core.async.t_cljs$core$async43813.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43813.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async43813.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43813.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async43813.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta43814","meta43814",-1804563026,null)], null);
}));

(cljs.core.async.t_cljs$core$async43813.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43813.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43813");

(cljs.core.async.t_cljs$core$async43813.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async43813");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43813.
 */
cljs.core.async.__GT_t_cljs$core$async43813 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async43813(flag__$1,cb__$1,meta43814){
return (new cljs.core.async.t_cljs$core$async43813(flag__$1,cb__$1,meta43814));
});

}

return (new cljs.core.async.t_cljs$core$async43813(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__43839_SHARP_){
var G__43863 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__43839_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__43863) : fret.call(null,G__43863));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__43842_SHARP_){
var G__43866 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__43842_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__43866) : fret.call(null,G__43866));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__46394 = (i + (1));
i = G__46394;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___46403 = arguments.length;
var i__4737__auto___46404 = (0);
while(true){
if((i__4737__auto___46404 < len__4736__auto___46403)){
args__4742__auto__.push((arguments[i__4737__auto___46404]));

var G__46405 = (i__4737__auto___46404 + (1));
i__4737__auto___46404 = G__46405;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__43902){
var map__43903 = p__43902;
var map__43903__$1 = (((((!((map__43903 == null))))?(((((map__43903.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43903.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43903):map__43903);
var opts = map__43903__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq43884){
var G__43885 = cljs.core.first(seq43884);
var seq43884__$1 = cljs.core.next(seq43884);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43885,seq43884__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__43922 = arguments.length;
switch (G__43922) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__43595__auto___46432 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_43981){
var state_val_43982 = (state_43981[(1)]);
if((state_val_43982 === (7))){
var inst_43969 = (state_43981[(2)]);
var state_43981__$1 = state_43981;
var statearr_43994_46437 = state_43981__$1;
(statearr_43994_46437[(2)] = inst_43969);

(statearr_43994_46437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43982 === (1))){
var state_43981__$1 = state_43981;
var statearr_43995_46441 = state_43981__$1;
(statearr_43995_46441[(2)] = null);

(statearr_43995_46441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43982 === (4))){
var inst_43949 = (state_43981[(7)]);
var inst_43949__$1 = (state_43981[(2)]);
var inst_43950 = (inst_43949__$1 == null);
var state_43981__$1 = (function (){var statearr_43998 = state_43981;
(statearr_43998[(7)] = inst_43949__$1);

return statearr_43998;
})();
if(cljs.core.truth_(inst_43950)){
var statearr_43999_46442 = state_43981__$1;
(statearr_43999_46442[(1)] = (5));

} else {
var statearr_44000_46443 = state_43981__$1;
(statearr_44000_46443[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43982 === (13))){
var state_43981__$1 = state_43981;
var statearr_44005_46444 = state_43981__$1;
(statearr_44005_46444[(2)] = null);

(statearr_44005_46444[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43982 === (6))){
var inst_43949 = (state_43981[(7)]);
var state_43981__$1 = state_43981;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43981__$1,(11),to,inst_43949);
} else {
if((state_val_43982 === (3))){
var inst_43971 = (state_43981[(2)]);
var state_43981__$1 = state_43981;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43981__$1,inst_43971);
} else {
if((state_val_43982 === (12))){
var state_43981__$1 = state_43981;
var statearr_44007_46452 = state_43981__$1;
(statearr_44007_46452[(2)] = null);

(statearr_44007_46452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43982 === (2))){
var state_43981__$1 = state_43981;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43981__$1,(4),from);
} else {
if((state_val_43982 === (11))){
var inst_43959 = (state_43981[(2)]);
var state_43981__$1 = state_43981;
if(cljs.core.truth_(inst_43959)){
var statearr_44012_46456 = state_43981__$1;
(statearr_44012_46456[(1)] = (12));

} else {
var statearr_44014_46459 = state_43981__$1;
(statearr_44014_46459[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43982 === (9))){
var state_43981__$1 = state_43981;
var statearr_44019_46461 = state_43981__$1;
(statearr_44019_46461[(2)] = null);

(statearr_44019_46461[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43982 === (5))){
var state_43981__$1 = state_43981;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44021_46464 = state_43981__$1;
(statearr_44021_46464[(1)] = (8));

} else {
var statearr_44022_46465 = state_43981__$1;
(statearr_44022_46465[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43982 === (14))){
var inst_43967 = (state_43981[(2)]);
var state_43981__$1 = state_43981;
var statearr_44023_46466 = state_43981__$1;
(statearr_44023_46466[(2)] = inst_43967);

(statearr_44023_46466[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43982 === (10))){
var inst_43956 = (state_43981[(2)]);
var state_43981__$1 = state_43981;
var statearr_44024_46473 = state_43981__$1;
(statearr_44024_46473[(2)] = inst_43956);

(statearr_44024_46473[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43982 === (8))){
var inst_43953 = cljs.core.async.close_BANG_(to);
var state_43981__$1 = state_43981;
var statearr_44028_46476 = state_43981__$1;
(statearr_44028_46476[(2)] = inst_43953);

(statearr_44028_46476[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43403__auto__ = null;
var cljs$core$async$state_machine__43403__auto____0 = (function (){
var statearr_44035 = [null,null,null,null,null,null,null,null];
(statearr_44035[(0)] = cljs$core$async$state_machine__43403__auto__);

(statearr_44035[(1)] = (1));

return statearr_44035;
});
var cljs$core$async$state_machine__43403__auto____1 = (function (state_43981){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_43981);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e44036){var ex__43406__auto__ = e44036;
var statearr_44037_46483 = state_43981;
(statearr_44037_46483[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_43981[(4)]))){
var statearr_44038_46484 = state_43981;
(statearr_44038_46484[(1)] = cljs.core.first((state_43981[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46490 = state_43981;
state_43981 = G__46490;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$state_machine__43403__auto__ = function(state_43981){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43403__auto____1.call(this,state_43981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43403__auto____0;
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43403__auto____1;
return cljs$core$async$state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_44040 = f__43596__auto__();
(statearr_44040[(6)] = c__43595__auto___46432);

return statearr_44040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__44057){
var vec__44058 = p__44057;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44058,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44058,(1),null);
var job = vec__44058;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__43595__auto___46497 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_44069){
var state_val_44070 = (state_44069[(1)]);
if((state_val_44070 === (1))){
var state_44069__$1 = state_44069;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44069__$1,(2),res,v);
} else {
if((state_val_44070 === (2))){
var inst_44066 = (state_44069[(2)]);
var inst_44067 = cljs.core.async.close_BANG_(res);
var state_44069__$1 = (function (){var statearr_44071 = state_44069;
(statearr_44071[(7)] = inst_44066);

return statearr_44071;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44069__$1,inst_44067);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0 = (function (){
var statearr_44072 = [null,null,null,null,null,null,null,null];
(statearr_44072[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__);

(statearr_44072[(1)] = (1));

return statearr_44072;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1 = (function (state_44069){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_44069);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e44074){var ex__43406__auto__ = e44074;
var statearr_44075_46524 = state_44069;
(statearr_44075_46524[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_44069[(4)]))){
var statearr_44078_46525 = state_44069;
(statearr_44078_46525[(1)] = cljs.core.first((state_44069[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46528 = state_44069;
state_44069 = G__46528;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__ = function(state_44069){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1.call(this,state_44069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_44081 = f__43596__auto__();
(statearr_44081[(6)] = c__43595__auto___46497);

return statearr_44081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__44087){
var vec__44088 = p__44087;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44088,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44088,(1),null);
var job = vec__44088;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___46540 = n;
var __46541 = (0);
while(true){
if((__46541 < n__4613__auto___46540)){
var G__44091_46542 = type;
var G__44091_46543__$1 = (((G__44091_46542 instanceof cljs.core.Keyword))?G__44091_46542.fqn:null);
switch (G__44091_46543__$1) {
case "compute":
var c__43595__auto___46545 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__46541,c__43595__auto___46545,G__44091_46542,G__44091_46543__$1,n__4613__auto___46540,jobs,results,process,async){
return (function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = ((function (__46541,c__43595__auto___46545,G__44091_46542,G__44091_46543__$1,n__4613__auto___46540,jobs,results,process,async){
return (function (state_44104){
var state_val_44105 = (state_44104[(1)]);
if((state_val_44105 === (1))){
var state_44104__$1 = state_44104;
var statearr_44106_46546 = state_44104__$1;
(statearr_44106_46546[(2)] = null);

(statearr_44106_46546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44105 === (2))){
var state_44104__$1 = state_44104;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44104__$1,(4),jobs);
} else {
if((state_val_44105 === (3))){
var inst_44102 = (state_44104[(2)]);
var state_44104__$1 = state_44104;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44104__$1,inst_44102);
} else {
if((state_val_44105 === (4))){
var inst_44094 = (state_44104[(2)]);
var inst_44095 = process(inst_44094);
var state_44104__$1 = state_44104;
if(cljs.core.truth_(inst_44095)){
var statearr_44111_46557 = state_44104__$1;
(statearr_44111_46557[(1)] = (5));

} else {
var statearr_44112_46562 = state_44104__$1;
(statearr_44112_46562[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44105 === (5))){
var state_44104__$1 = state_44104;
var statearr_44115_46565 = state_44104__$1;
(statearr_44115_46565[(2)] = null);

(statearr_44115_46565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44105 === (6))){
var state_44104__$1 = state_44104;
var statearr_44117_46569 = state_44104__$1;
(statearr_44117_46569[(2)] = null);

(statearr_44117_46569[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44105 === (7))){
var inst_44100 = (state_44104[(2)]);
var state_44104__$1 = state_44104;
var statearr_44119_46576 = state_44104__$1;
(statearr_44119_46576[(2)] = inst_44100);

(statearr_44119_46576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46541,c__43595__auto___46545,G__44091_46542,G__44091_46543__$1,n__4613__auto___46540,jobs,results,process,async))
;
return ((function (__46541,switch__43402__auto__,c__43595__auto___46545,G__44091_46542,G__44091_46543__$1,n__4613__auto___46540,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0 = (function (){
var statearr_44122 = [null,null,null,null,null,null,null];
(statearr_44122[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__);

(statearr_44122[(1)] = (1));

return statearr_44122;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1 = (function (state_44104){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_44104);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e44125){var ex__43406__auto__ = e44125;
var statearr_44127_46580 = state_44104;
(statearr_44127_46580[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_44104[(4)]))){
var statearr_44129_46581 = state_44104;
(statearr_44129_46581[(1)] = cljs.core.first((state_44104[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46587 = state_44104;
state_44104 = G__46587;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__ = function(state_44104){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1.call(this,state_44104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__;
})()
;})(__46541,switch__43402__auto__,c__43595__auto___46545,G__44091_46542,G__44091_46543__$1,n__4613__auto___46540,jobs,results,process,async))
})();
var state__43597__auto__ = (function (){var statearr_44137 = f__43596__auto__();
(statearr_44137[(6)] = c__43595__auto___46545);

return statearr_44137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
});})(__46541,c__43595__auto___46545,G__44091_46542,G__44091_46543__$1,n__4613__auto___46540,jobs,results,process,async))
);


break;
case "async":
var c__43595__auto___46592 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__46541,c__43595__auto___46592,G__44091_46542,G__44091_46543__$1,n__4613__auto___46540,jobs,results,process,async){
return (function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = ((function (__46541,c__43595__auto___46592,G__44091_46542,G__44091_46543__$1,n__4613__auto___46540,jobs,results,process,async){
return (function (state_44153){
var state_val_44154 = (state_44153[(1)]);
if((state_val_44154 === (1))){
var state_44153__$1 = state_44153;
var statearr_44158_46598 = state_44153__$1;
(statearr_44158_46598[(2)] = null);

(statearr_44158_46598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44154 === (2))){
var state_44153__$1 = state_44153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44153__$1,(4),jobs);
} else {
if((state_val_44154 === (3))){
var inst_44151 = (state_44153[(2)]);
var state_44153__$1 = state_44153;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44153__$1,inst_44151);
} else {
if((state_val_44154 === (4))){
var inst_44143 = (state_44153[(2)]);
var inst_44144 = async(inst_44143);
var state_44153__$1 = state_44153;
if(cljs.core.truth_(inst_44144)){
var statearr_44162_46602 = state_44153__$1;
(statearr_44162_46602[(1)] = (5));

} else {
var statearr_44164_46603 = state_44153__$1;
(statearr_44164_46603[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44154 === (5))){
var state_44153__$1 = state_44153;
var statearr_44168_46604 = state_44153__$1;
(statearr_44168_46604[(2)] = null);

(statearr_44168_46604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44154 === (6))){
var state_44153__$1 = state_44153;
var statearr_44172_46608 = state_44153__$1;
(statearr_44172_46608[(2)] = null);

(statearr_44172_46608[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44154 === (7))){
var inst_44149 = (state_44153[(2)]);
var state_44153__$1 = state_44153;
var statearr_44178_46609 = state_44153__$1;
(statearr_44178_46609[(2)] = inst_44149);

(statearr_44178_46609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46541,c__43595__auto___46592,G__44091_46542,G__44091_46543__$1,n__4613__auto___46540,jobs,results,process,async))
;
return ((function (__46541,switch__43402__auto__,c__43595__auto___46592,G__44091_46542,G__44091_46543__$1,n__4613__auto___46540,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0 = (function (){
var statearr_44185 = [null,null,null,null,null,null,null];
(statearr_44185[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__);

(statearr_44185[(1)] = (1));

return statearr_44185;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1 = (function (state_44153){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_44153);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e44187){var ex__43406__auto__ = e44187;
var statearr_44189_46611 = state_44153;
(statearr_44189_46611[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_44153[(4)]))){
var statearr_44191_46612 = state_44153;
(statearr_44191_46612[(1)] = cljs.core.first((state_44153[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46613 = state_44153;
state_44153 = G__46613;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__ = function(state_44153){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1.call(this,state_44153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__;
})()
;})(__46541,switch__43402__auto__,c__43595__auto___46592,G__44091_46542,G__44091_46543__$1,n__4613__auto___46540,jobs,results,process,async))
})();
var state__43597__auto__ = (function (){var statearr_44194 = f__43596__auto__();
(statearr_44194[(6)] = c__43595__auto___46592);

return statearr_44194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
});})(__46541,c__43595__auto___46592,G__44091_46542,G__44091_46543__$1,n__4613__auto___46540,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44091_46543__$1)].join('')));

}

var G__46614 = (__46541 + (1));
__46541 = G__46614;
continue;
} else {
}
break;
}

var c__43595__auto___46615 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_44226){
var state_val_44227 = (state_44226[(1)]);
if((state_val_44227 === (7))){
var inst_44221 = (state_44226[(2)]);
var state_44226__$1 = state_44226;
var statearr_44243_46616 = state_44226__$1;
(statearr_44243_46616[(2)] = inst_44221);

(statearr_44243_46616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44227 === (1))){
var state_44226__$1 = state_44226;
var statearr_44249_46617 = state_44226__$1;
(statearr_44249_46617[(2)] = null);

(statearr_44249_46617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44227 === (4))){
var inst_44202 = (state_44226[(7)]);
var inst_44202__$1 = (state_44226[(2)]);
var inst_44203 = (inst_44202__$1 == null);
var state_44226__$1 = (function (){var statearr_44253 = state_44226;
(statearr_44253[(7)] = inst_44202__$1);

return statearr_44253;
})();
if(cljs.core.truth_(inst_44203)){
var statearr_44255_46618 = state_44226__$1;
(statearr_44255_46618[(1)] = (5));

} else {
var statearr_44259_46619 = state_44226__$1;
(statearr_44259_46619[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44227 === (6))){
var inst_44207 = (state_44226[(8)]);
var inst_44202 = (state_44226[(7)]);
var inst_44207__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_44210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44212 = [inst_44202,inst_44207__$1];
var inst_44213 = (new cljs.core.PersistentVector(null,2,(5),inst_44210,inst_44212,null));
var state_44226__$1 = (function (){var statearr_44263 = state_44226;
(statearr_44263[(8)] = inst_44207__$1);

return statearr_44263;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44226__$1,(8),jobs,inst_44213);
} else {
if((state_val_44227 === (3))){
var inst_44223 = (state_44226[(2)]);
var state_44226__$1 = state_44226;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44226__$1,inst_44223);
} else {
if((state_val_44227 === (2))){
var state_44226__$1 = state_44226;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44226__$1,(4),from);
} else {
if((state_val_44227 === (9))){
var inst_44218 = (state_44226[(2)]);
var state_44226__$1 = (function (){var statearr_44268 = state_44226;
(statearr_44268[(9)] = inst_44218);

return statearr_44268;
})();
var statearr_44270_46621 = state_44226__$1;
(statearr_44270_46621[(2)] = null);

(statearr_44270_46621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44227 === (5))){
var inst_44205 = cljs.core.async.close_BANG_(jobs);
var state_44226__$1 = state_44226;
var statearr_44274_46622 = state_44226__$1;
(statearr_44274_46622[(2)] = inst_44205);

(statearr_44274_46622[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44227 === (8))){
var inst_44207 = (state_44226[(8)]);
var inst_44216 = (state_44226[(2)]);
var state_44226__$1 = (function (){var statearr_44277 = state_44226;
(statearr_44277[(10)] = inst_44216);

return statearr_44277;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44226__$1,(9),results,inst_44207);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0 = (function (){
var statearr_44280 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44280[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__);

(statearr_44280[(1)] = (1));

return statearr_44280;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1 = (function (state_44226){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_44226);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e44285){var ex__43406__auto__ = e44285;
var statearr_44286_46623 = state_44226;
(statearr_44286_46623[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_44226[(4)]))){
var statearr_44288_46624 = state_44226;
(statearr_44288_46624[(1)] = cljs.core.first((state_44226[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46628 = state_44226;
state_44226 = G__46628;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__ = function(state_44226){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1.call(this,state_44226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_44290 = f__43596__auto__();
(statearr_44290[(6)] = c__43595__auto___46615);

return statearr_44290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


var c__43595__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_44330){
var state_val_44333 = (state_44330[(1)]);
if((state_val_44333 === (7))){
var inst_44326 = (state_44330[(2)]);
var state_44330__$1 = state_44330;
var statearr_44346_46635 = state_44330__$1;
(statearr_44346_46635[(2)] = inst_44326);

(statearr_44346_46635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (20))){
var state_44330__$1 = state_44330;
var statearr_44349_46636 = state_44330__$1;
(statearr_44349_46636[(2)] = null);

(statearr_44349_46636[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (1))){
var state_44330__$1 = state_44330;
var statearr_44351_46637 = state_44330__$1;
(statearr_44351_46637[(2)] = null);

(statearr_44351_46637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (4))){
var inst_44295 = (state_44330[(7)]);
var inst_44295__$1 = (state_44330[(2)]);
var inst_44296 = (inst_44295__$1 == null);
var state_44330__$1 = (function (){var statearr_44352 = state_44330;
(statearr_44352[(7)] = inst_44295__$1);

return statearr_44352;
})();
if(cljs.core.truth_(inst_44296)){
var statearr_44353_46640 = state_44330__$1;
(statearr_44353_46640[(1)] = (5));

} else {
var statearr_44354_46641 = state_44330__$1;
(statearr_44354_46641[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (15))){
var inst_44308 = (state_44330[(8)]);
var state_44330__$1 = state_44330;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44330__$1,(18),to,inst_44308);
} else {
if((state_val_44333 === (21))){
var inst_44321 = (state_44330[(2)]);
var state_44330__$1 = state_44330;
var statearr_44355_46650 = state_44330__$1;
(statearr_44355_46650[(2)] = inst_44321);

(statearr_44355_46650[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (13))){
var inst_44323 = (state_44330[(2)]);
var state_44330__$1 = (function (){var statearr_44357 = state_44330;
(statearr_44357[(9)] = inst_44323);

return statearr_44357;
})();
var statearr_44358_46655 = state_44330__$1;
(statearr_44358_46655[(2)] = null);

(statearr_44358_46655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (6))){
var inst_44295 = (state_44330[(7)]);
var state_44330__$1 = state_44330;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44330__$1,(11),inst_44295);
} else {
if((state_val_44333 === (17))){
var inst_44316 = (state_44330[(2)]);
var state_44330__$1 = state_44330;
if(cljs.core.truth_(inst_44316)){
var statearr_44362_46656 = state_44330__$1;
(statearr_44362_46656[(1)] = (19));

} else {
var statearr_44364_46657 = state_44330__$1;
(statearr_44364_46657[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (3))){
var inst_44328 = (state_44330[(2)]);
var state_44330__$1 = state_44330;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44330__$1,inst_44328);
} else {
if((state_val_44333 === (12))){
var inst_44305 = (state_44330[(10)]);
var state_44330__$1 = state_44330;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44330__$1,(14),inst_44305);
} else {
if((state_val_44333 === (2))){
var state_44330__$1 = state_44330;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44330__$1,(4),results);
} else {
if((state_val_44333 === (19))){
var state_44330__$1 = state_44330;
var statearr_44371_46662 = state_44330__$1;
(statearr_44371_46662[(2)] = null);

(statearr_44371_46662[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (11))){
var inst_44305 = (state_44330[(2)]);
var state_44330__$1 = (function (){var statearr_44378 = state_44330;
(statearr_44378[(10)] = inst_44305);

return statearr_44378;
})();
var statearr_44380_46663 = state_44330__$1;
(statearr_44380_46663[(2)] = null);

(statearr_44380_46663[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (9))){
var state_44330__$1 = state_44330;
var statearr_44387_46666 = state_44330__$1;
(statearr_44387_46666[(2)] = null);

(statearr_44387_46666[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (5))){
var state_44330__$1 = state_44330;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44395_46669 = state_44330__$1;
(statearr_44395_46669[(1)] = (8));

} else {
var statearr_44397_46670 = state_44330__$1;
(statearr_44397_46670[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (14))){
var inst_44308 = (state_44330[(8)]);
var inst_44308__$1 = (state_44330[(2)]);
var inst_44309 = (inst_44308__$1 == null);
var inst_44310 = cljs.core.not(inst_44309);
var state_44330__$1 = (function (){var statearr_44405 = state_44330;
(statearr_44405[(8)] = inst_44308__$1);

return statearr_44405;
})();
if(inst_44310){
var statearr_44407_46678 = state_44330__$1;
(statearr_44407_46678[(1)] = (15));

} else {
var statearr_44408_46679 = state_44330__$1;
(statearr_44408_46679[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (16))){
var state_44330__$1 = state_44330;
var statearr_44414_46686 = state_44330__$1;
(statearr_44414_46686[(2)] = false);

(statearr_44414_46686[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (10))){
var inst_44302 = (state_44330[(2)]);
var state_44330__$1 = state_44330;
var statearr_44422_46687 = state_44330__$1;
(statearr_44422_46687[(2)] = inst_44302);

(statearr_44422_46687[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (18))){
var inst_44313 = (state_44330[(2)]);
var state_44330__$1 = state_44330;
var statearr_44427_46688 = state_44330__$1;
(statearr_44427_46688[(2)] = inst_44313);

(statearr_44427_46688[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44333 === (8))){
var inst_44299 = cljs.core.async.close_BANG_(to);
var state_44330__$1 = state_44330;
var statearr_44436_46689 = state_44330__$1;
(statearr_44436_46689[(2)] = inst_44299);

(statearr_44436_46689[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0 = (function (){
var statearr_44439 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44439[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__);

(statearr_44439[(1)] = (1));

return statearr_44439;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1 = (function (state_44330){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_44330);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e44443){var ex__43406__auto__ = e44443;
var statearr_44444_46690 = state_44330;
(statearr_44444_46690[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_44330[(4)]))){
var statearr_44445_46691 = state_44330;
(statearr_44445_46691[(1)] = cljs.core.first((state_44330[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46692 = state_44330;
state_44330 = G__46692;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__ = function(state_44330){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1.call(this,state_44330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43403__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_44447 = f__43596__auto__();
(statearr_44447[(6)] = c__43595__auto__);

return statearr_44447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));

return c__43595__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__44452 = arguments.length;
switch (G__44452) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__44470 = arguments.length;
switch (G__44470) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__44480 = arguments.length;
switch (G__44480) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__43595__auto___46722 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_44514){
var state_val_44515 = (state_44514[(1)]);
if((state_val_44515 === (7))){
var inst_44509 = (state_44514[(2)]);
var state_44514__$1 = state_44514;
var statearr_44516_46723 = state_44514__$1;
(statearr_44516_46723[(2)] = inst_44509);

(statearr_44516_46723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (1))){
var state_44514__$1 = state_44514;
var statearr_44517_46724 = state_44514__$1;
(statearr_44517_46724[(2)] = null);

(statearr_44517_46724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (4))){
var inst_44487 = (state_44514[(7)]);
var inst_44487__$1 = (state_44514[(2)]);
var inst_44488 = (inst_44487__$1 == null);
var state_44514__$1 = (function (){var statearr_44520 = state_44514;
(statearr_44520[(7)] = inst_44487__$1);

return statearr_44520;
})();
if(cljs.core.truth_(inst_44488)){
var statearr_44522_46731 = state_44514__$1;
(statearr_44522_46731[(1)] = (5));

} else {
var statearr_44524_46732 = state_44514__$1;
(statearr_44524_46732[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (13))){
var state_44514__$1 = state_44514;
var statearr_44528_46733 = state_44514__$1;
(statearr_44528_46733[(2)] = null);

(statearr_44528_46733[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (6))){
var inst_44487 = (state_44514[(7)]);
var inst_44495 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_44487) : p.call(null,inst_44487));
var state_44514__$1 = state_44514;
if(cljs.core.truth_(inst_44495)){
var statearr_44532_46734 = state_44514__$1;
(statearr_44532_46734[(1)] = (9));

} else {
var statearr_44541_46735 = state_44514__$1;
(statearr_44541_46735[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (3))){
var inst_44511 = (state_44514[(2)]);
var state_44514__$1 = state_44514;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44514__$1,inst_44511);
} else {
if((state_val_44515 === (12))){
var state_44514__$1 = state_44514;
var statearr_44544_46736 = state_44514__$1;
(statearr_44544_46736[(2)] = null);

(statearr_44544_46736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (2))){
var state_44514__$1 = state_44514;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44514__$1,(4),ch);
} else {
if((state_val_44515 === (11))){
var inst_44487 = (state_44514[(7)]);
var inst_44499 = (state_44514[(2)]);
var state_44514__$1 = state_44514;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44514__$1,(8),inst_44499,inst_44487);
} else {
if((state_val_44515 === (9))){
var state_44514__$1 = state_44514;
var statearr_44545_46737 = state_44514__$1;
(statearr_44545_46737[(2)] = tc);

(statearr_44545_46737[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (5))){
var inst_44491 = cljs.core.async.close_BANG_(tc);
var inst_44492 = cljs.core.async.close_BANG_(fc);
var state_44514__$1 = (function (){var statearr_44547 = state_44514;
(statearr_44547[(8)] = inst_44491);

return statearr_44547;
})();
var statearr_44548_46738 = state_44514__$1;
(statearr_44548_46738[(2)] = inst_44492);

(statearr_44548_46738[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (14))){
var inst_44507 = (state_44514[(2)]);
var state_44514__$1 = state_44514;
var statearr_44549_46757 = state_44514__$1;
(statearr_44549_46757[(2)] = inst_44507);

(statearr_44549_46757[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (10))){
var state_44514__$1 = state_44514;
var statearr_44552_46758 = state_44514__$1;
(statearr_44552_46758[(2)] = fc);

(statearr_44552_46758[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (8))){
var inst_44501 = (state_44514[(2)]);
var state_44514__$1 = state_44514;
if(cljs.core.truth_(inst_44501)){
var statearr_44553_46760 = state_44514__$1;
(statearr_44553_46760[(1)] = (12));

} else {
var statearr_44554_46762 = state_44514__$1;
(statearr_44554_46762[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43403__auto__ = null;
var cljs$core$async$state_machine__43403__auto____0 = (function (){
var statearr_44557 = [null,null,null,null,null,null,null,null,null];
(statearr_44557[(0)] = cljs$core$async$state_machine__43403__auto__);

(statearr_44557[(1)] = (1));

return statearr_44557;
});
var cljs$core$async$state_machine__43403__auto____1 = (function (state_44514){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_44514);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e44559){var ex__43406__auto__ = e44559;
var statearr_44560_46766 = state_44514;
(statearr_44560_46766[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_44514[(4)]))){
var statearr_44561_46767 = state_44514;
(statearr_44561_46767[(1)] = cljs.core.first((state_44514[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46770 = state_44514;
state_44514 = G__46770;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$state_machine__43403__auto__ = function(state_44514){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43403__auto____1.call(this,state_44514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43403__auto____0;
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43403__auto____1;
return cljs$core$async$state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_44562 = f__43596__auto__();
(statearr_44562[(6)] = c__43595__auto___46722);

return statearr_44562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__43595__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_44591){
var state_val_44592 = (state_44591[(1)]);
if((state_val_44592 === (7))){
var inst_44587 = (state_44591[(2)]);
var state_44591__$1 = state_44591;
var statearr_44597_46774 = state_44591__$1;
(statearr_44597_46774[(2)] = inst_44587);

(statearr_44597_46774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44592 === (1))){
var inst_44568 = init;
var inst_44571 = inst_44568;
var state_44591__$1 = (function (){var statearr_44600 = state_44591;
(statearr_44600[(7)] = inst_44571);

return statearr_44600;
})();
var statearr_44602_46776 = state_44591__$1;
(statearr_44602_46776[(2)] = null);

(statearr_44602_46776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44592 === (4))){
var inst_44574 = (state_44591[(8)]);
var inst_44574__$1 = (state_44591[(2)]);
var inst_44575 = (inst_44574__$1 == null);
var state_44591__$1 = (function (){var statearr_44603 = state_44591;
(statearr_44603[(8)] = inst_44574__$1);

return statearr_44603;
})();
if(cljs.core.truth_(inst_44575)){
var statearr_44604_46779 = state_44591__$1;
(statearr_44604_46779[(1)] = (5));

} else {
var statearr_44605_46780 = state_44591__$1;
(statearr_44605_46780[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44592 === (6))){
var inst_44574 = (state_44591[(8)]);
var inst_44571 = (state_44591[(7)]);
var inst_44578 = (state_44591[(9)]);
var inst_44578__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_44571,inst_44574) : f.call(null,inst_44571,inst_44574));
var inst_44579 = cljs.core.reduced_QMARK_(inst_44578__$1);
var state_44591__$1 = (function (){var statearr_44610 = state_44591;
(statearr_44610[(9)] = inst_44578__$1);

return statearr_44610;
})();
if(inst_44579){
var statearr_44613_46781 = state_44591__$1;
(statearr_44613_46781[(1)] = (8));

} else {
var statearr_44614_46782 = state_44591__$1;
(statearr_44614_46782[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44592 === (3))){
var inst_44589 = (state_44591[(2)]);
var state_44591__$1 = state_44591;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44591__$1,inst_44589);
} else {
if((state_val_44592 === (2))){
var state_44591__$1 = state_44591;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44591__$1,(4),ch);
} else {
if((state_val_44592 === (9))){
var inst_44578 = (state_44591[(9)]);
var inst_44571 = inst_44578;
var state_44591__$1 = (function (){var statearr_44622 = state_44591;
(statearr_44622[(7)] = inst_44571);

return statearr_44622;
})();
var statearr_44623_46785 = state_44591__$1;
(statearr_44623_46785[(2)] = null);

(statearr_44623_46785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44592 === (5))){
var inst_44571 = (state_44591[(7)]);
var state_44591__$1 = state_44591;
var statearr_44626_46786 = state_44591__$1;
(statearr_44626_46786[(2)] = inst_44571);

(statearr_44626_46786[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44592 === (10))){
var inst_44585 = (state_44591[(2)]);
var state_44591__$1 = state_44591;
var statearr_44627_46788 = state_44591__$1;
(statearr_44627_46788[(2)] = inst_44585);

(statearr_44627_46788[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44592 === (8))){
var inst_44578 = (state_44591[(9)]);
var inst_44581 = cljs.core.deref(inst_44578);
var state_44591__$1 = state_44591;
var statearr_44628_46789 = state_44591__$1;
(statearr_44628_46789[(2)] = inst_44581);

(statearr_44628_46789[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__43403__auto__ = null;
var cljs$core$async$reduce_$_state_machine__43403__auto____0 = (function (){
var statearr_44633 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44633[(0)] = cljs$core$async$reduce_$_state_machine__43403__auto__);

(statearr_44633[(1)] = (1));

return statearr_44633;
});
var cljs$core$async$reduce_$_state_machine__43403__auto____1 = (function (state_44591){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_44591);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e44634){var ex__43406__auto__ = e44634;
var statearr_44635_46794 = state_44591;
(statearr_44635_46794[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_44591[(4)]))){
var statearr_44636_46797 = state_44591;
(statearr_44636_46797[(1)] = cljs.core.first((state_44591[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46802 = state_44591;
state_44591 = G__46802;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__43403__auto__ = function(state_44591){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__43403__auto____1.call(this,state_44591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__43403__auto____0;
cljs$core$async$reduce_$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__43403__auto____1;
return cljs$core$async$reduce_$_state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_44639 = f__43596__auto__();
(statearr_44639[(6)] = c__43595__auto__);

return statearr_44639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));

return c__43595__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__43595__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_44650){
var state_val_44651 = (state_44650[(1)]);
if((state_val_44651 === (1))){
var inst_44645 = cljs.core.async.reduce(f__$1,init,ch);
var state_44650__$1 = state_44650;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44650__$1,(2),inst_44645);
} else {
if((state_val_44651 === (2))){
var inst_44647 = (state_44650[(2)]);
var inst_44648 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_44647) : f__$1.call(null,inst_44647));
var state_44650__$1 = state_44650;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44650__$1,inst_44648);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__43403__auto__ = null;
var cljs$core$async$transduce_$_state_machine__43403__auto____0 = (function (){
var statearr_44661 = [null,null,null,null,null,null,null];
(statearr_44661[(0)] = cljs$core$async$transduce_$_state_machine__43403__auto__);

(statearr_44661[(1)] = (1));

return statearr_44661;
});
var cljs$core$async$transduce_$_state_machine__43403__auto____1 = (function (state_44650){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_44650);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e44664){var ex__43406__auto__ = e44664;
var statearr_44665_46808 = state_44650;
(statearr_44665_46808[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_44650[(4)]))){
var statearr_44666_46809 = state_44650;
(statearr_44666_46809[(1)] = cljs.core.first((state_44650[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46811 = state_44650;
state_44650 = G__46811;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__43403__auto__ = function(state_44650){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__43403__auto____1.call(this,state_44650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__43403__auto____0;
cljs$core$async$transduce_$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__43403__auto____1;
return cljs$core$async$transduce_$_state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_44668 = f__43596__auto__();
(statearr_44668[(6)] = c__43595__auto__);

return statearr_44668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));

return c__43595__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__44670 = arguments.length;
switch (G__44670) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__43595__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_44698){
var state_val_44699 = (state_44698[(1)]);
if((state_val_44699 === (7))){
var inst_44680 = (state_44698[(2)]);
var state_44698__$1 = state_44698;
var statearr_44703_46824 = state_44698__$1;
(statearr_44703_46824[(2)] = inst_44680);

(statearr_44703_46824[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44699 === (1))){
var inst_44674 = cljs.core.seq(coll);
var inst_44675 = inst_44674;
var state_44698__$1 = (function (){var statearr_44706 = state_44698;
(statearr_44706[(7)] = inst_44675);

return statearr_44706;
})();
var statearr_44709_46828 = state_44698__$1;
(statearr_44709_46828[(2)] = null);

(statearr_44709_46828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44699 === (4))){
var inst_44675 = (state_44698[(7)]);
var inst_44678 = cljs.core.first(inst_44675);
var state_44698__$1 = state_44698;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44698__$1,(7),ch,inst_44678);
} else {
if((state_val_44699 === (13))){
var inst_44692 = (state_44698[(2)]);
var state_44698__$1 = state_44698;
var statearr_44711_46832 = state_44698__$1;
(statearr_44711_46832[(2)] = inst_44692);

(statearr_44711_46832[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44699 === (6))){
var inst_44683 = (state_44698[(2)]);
var state_44698__$1 = state_44698;
if(cljs.core.truth_(inst_44683)){
var statearr_44712_46837 = state_44698__$1;
(statearr_44712_46837[(1)] = (8));

} else {
var statearr_44713_46838 = state_44698__$1;
(statearr_44713_46838[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44699 === (3))){
var inst_44696 = (state_44698[(2)]);
var state_44698__$1 = state_44698;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44698__$1,inst_44696);
} else {
if((state_val_44699 === (12))){
var state_44698__$1 = state_44698;
var statearr_44717_46839 = state_44698__$1;
(statearr_44717_46839[(2)] = null);

(statearr_44717_46839[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44699 === (2))){
var inst_44675 = (state_44698[(7)]);
var state_44698__$1 = state_44698;
if(cljs.core.truth_(inst_44675)){
var statearr_44718_46840 = state_44698__$1;
(statearr_44718_46840[(1)] = (4));

} else {
var statearr_44719_46841 = state_44698__$1;
(statearr_44719_46841[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44699 === (11))){
var inst_44689 = cljs.core.async.close_BANG_(ch);
var state_44698__$1 = state_44698;
var statearr_44724_46842 = state_44698__$1;
(statearr_44724_46842[(2)] = inst_44689);

(statearr_44724_46842[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44699 === (9))){
var state_44698__$1 = state_44698;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44725_46843 = state_44698__$1;
(statearr_44725_46843[(1)] = (11));

} else {
var statearr_44727_46844 = state_44698__$1;
(statearr_44727_46844[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44699 === (5))){
var inst_44675 = (state_44698[(7)]);
var state_44698__$1 = state_44698;
var statearr_44728_46846 = state_44698__$1;
(statearr_44728_46846[(2)] = inst_44675);

(statearr_44728_46846[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44699 === (10))){
var inst_44694 = (state_44698[(2)]);
var state_44698__$1 = state_44698;
var statearr_44729_46848 = state_44698__$1;
(statearr_44729_46848[(2)] = inst_44694);

(statearr_44729_46848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44699 === (8))){
var inst_44675 = (state_44698[(7)]);
var inst_44685 = cljs.core.next(inst_44675);
var inst_44675__$1 = inst_44685;
var state_44698__$1 = (function (){var statearr_44730 = state_44698;
(statearr_44730[(7)] = inst_44675__$1);

return statearr_44730;
})();
var statearr_44733_46849 = state_44698__$1;
(statearr_44733_46849[(2)] = null);

(statearr_44733_46849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43403__auto__ = null;
var cljs$core$async$state_machine__43403__auto____0 = (function (){
var statearr_44738 = [null,null,null,null,null,null,null,null];
(statearr_44738[(0)] = cljs$core$async$state_machine__43403__auto__);

(statearr_44738[(1)] = (1));

return statearr_44738;
});
var cljs$core$async$state_machine__43403__auto____1 = (function (state_44698){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_44698);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e44740){var ex__43406__auto__ = e44740;
var statearr_44741_46850 = state_44698;
(statearr_44741_46850[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_44698[(4)]))){
var statearr_44746_46852 = state_44698;
(statearr_44746_46852[(1)] = cljs.core.first((state_44698[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46853 = state_44698;
state_44698 = G__46853;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$state_machine__43403__auto__ = function(state_44698){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43403__auto____1.call(this,state_44698);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43403__auto____0;
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43403__auto____1;
return cljs$core$async$state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_44756 = f__43596__auto__();
(statearr_44756[(6)] = c__43595__auto__);

return statearr_44756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));

return c__43595__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__44762 = arguments.length;
switch (G__44762) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_46856 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_46856(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_46861 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_46861(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_46866 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_46866(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_46868 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_46868(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44780 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44780 = (function (ch,cs,meta44781){
this.ch = ch;
this.cs = cs;
this.meta44781 = meta44781;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44780.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44782,meta44781__$1){
var self__ = this;
var _44782__$1 = this;
return (new cljs.core.async.t_cljs$core$async44780(self__.ch,self__.cs,meta44781__$1));
}));

(cljs.core.async.t_cljs$core$async44780.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44782){
var self__ = this;
var _44782__$1 = this;
return self__.meta44781;
}));

(cljs.core.async.t_cljs$core$async44780.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44780.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async44780.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44780.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async44780.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async44780.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async44780.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta44781","meta44781",340256663,null)], null);
}));

(cljs.core.async.t_cljs$core$async44780.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44780.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44780");

(cljs.core.async.t_cljs$core$async44780.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44780");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44780.
 */
cljs.core.async.__GT_t_cljs$core$async44780 = (function cljs$core$async$mult_$___GT_t_cljs$core$async44780(ch__$1,cs__$1,meta44781){
return (new cljs.core.async.t_cljs$core$async44780(ch__$1,cs__$1,meta44781));
});

}

return (new cljs.core.async.t_cljs$core$async44780(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__43595__auto___46880 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_44929){
var state_val_44930 = (state_44929[(1)]);
if((state_val_44930 === (7))){
var inst_44923 = (state_44929[(2)]);
var state_44929__$1 = state_44929;
var statearr_44931_46881 = state_44929__$1;
(statearr_44931_46881[(2)] = inst_44923);

(statearr_44931_46881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (20))){
var inst_44823 = (state_44929[(7)]);
var inst_44835 = cljs.core.first(inst_44823);
var inst_44836 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44835,(0),null);
var inst_44837 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44835,(1),null);
var state_44929__$1 = (function (){var statearr_44932 = state_44929;
(statearr_44932[(8)] = inst_44836);

return statearr_44932;
})();
if(cljs.core.truth_(inst_44837)){
var statearr_44933_46882 = state_44929__$1;
(statearr_44933_46882[(1)] = (22));

} else {
var statearr_44934_46883 = state_44929__$1;
(statearr_44934_46883[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (27))){
var inst_44791 = (state_44929[(9)]);
var inst_44872 = (state_44929[(10)]);
var inst_44865 = (state_44929[(11)]);
var inst_44867 = (state_44929[(12)]);
var inst_44872__$1 = cljs.core._nth(inst_44865,inst_44867);
var inst_44874 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_44872__$1,inst_44791,done);
var state_44929__$1 = (function (){var statearr_44936 = state_44929;
(statearr_44936[(10)] = inst_44872__$1);

return statearr_44936;
})();
if(cljs.core.truth_(inst_44874)){
var statearr_44937_46886 = state_44929__$1;
(statearr_44937_46886[(1)] = (30));

} else {
var statearr_44939_46887 = state_44929__$1;
(statearr_44939_46887[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (1))){
var state_44929__$1 = state_44929;
var statearr_44940_46888 = state_44929__$1;
(statearr_44940_46888[(2)] = null);

(statearr_44940_46888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (24))){
var inst_44823 = (state_44929[(7)]);
var inst_44842 = (state_44929[(2)]);
var inst_44843 = cljs.core.next(inst_44823);
var inst_44800 = inst_44843;
var inst_44801 = null;
var inst_44802 = (0);
var inst_44803 = (0);
var state_44929__$1 = (function (){var statearr_44944 = state_44929;
(statearr_44944[(13)] = inst_44842);

(statearr_44944[(14)] = inst_44800);

(statearr_44944[(15)] = inst_44802);

(statearr_44944[(16)] = inst_44801);

(statearr_44944[(17)] = inst_44803);

return statearr_44944;
})();
var statearr_44945_46892 = state_44929__$1;
(statearr_44945_46892[(2)] = null);

(statearr_44945_46892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (39))){
var state_44929__$1 = state_44929;
var statearr_44950_46893 = state_44929__$1;
(statearr_44950_46893[(2)] = null);

(statearr_44950_46893[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (4))){
var inst_44791 = (state_44929[(9)]);
var inst_44791__$1 = (state_44929[(2)]);
var inst_44792 = (inst_44791__$1 == null);
var state_44929__$1 = (function (){var statearr_44951 = state_44929;
(statearr_44951[(9)] = inst_44791__$1);

return statearr_44951;
})();
if(cljs.core.truth_(inst_44792)){
var statearr_44952_46894 = state_44929__$1;
(statearr_44952_46894[(1)] = (5));

} else {
var statearr_44953_46895 = state_44929__$1;
(statearr_44953_46895[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (15))){
var inst_44800 = (state_44929[(14)]);
var inst_44802 = (state_44929[(15)]);
var inst_44801 = (state_44929[(16)]);
var inst_44803 = (state_44929[(17)]);
var inst_44819 = (state_44929[(2)]);
var inst_44820 = (inst_44803 + (1));
var tmp44947 = inst_44800;
var tmp44948 = inst_44802;
var tmp44949 = inst_44801;
var inst_44800__$1 = tmp44947;
var inst_44801__$1 = tmp44949;
var inst_44802__$1 = tmp44948;
var inst_44803__$1 = inst_44820;
var state_44929__$1 = (function (){var statearr_44955 = state_44929;
(statearr_44955[(14)] = inst_44800__$1);

(statearr_44955[(15)] = inst_44802__$1);

(statearr_44955[(18)] = inst_44819);

(statearr_44955[(16)] = inst_44801__$1);

(statearr_44955[(17)] = inst_44803__$1);

return statearr_44955;
})();
var statearr_44956_46896 = state_44929__$1;
(statearr_44956_46896[(2)] = null);

(statearr_44956_46896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (21))){
var inst_44846 = (state_44929[(2)]);
var state_44929__$1 = state_44929;
var statearr_44961_46902 = state_44929__$1;
(statearr_44961_46902[(2)] = inst_44846);

(statearr_44961_46902[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (31))){
var inst_44872 = (state_44929[(10)]);
var inst_44877 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_44872);
var state_44929__$1 = state_44929;
var statearr_44962_46907 = state_44929__$1;
(statearr_44962_46907[(2)] = inst_44877);

(statearr_44962_46907[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (32))){
var inst_44866 = (state_44929[(19)]);
var inst_44865 = (state_44929[(11)]);
var inst_44864 = (state_44929[(20)]);
var inst_44867 = (state_44929[(12)]);
var inst_44879 = (state_44929[(2)]);
var inst_44880 = (inst_44867 + (1));
var tmp44957 = inst_44866;
var tmp44958 = inst_44865;
var tmp44959 = inst_44864;
var inst_44864__$1 = tmp44959;
var inst_44865__$1 = tmp44958;
var inst_44866__$1 = tmp44957;
var inst_44867__$1 = inst_44880;
var state_44929__$1 = (function (){var statearr_44963 = state_44929;
(statearr_44963[(21)] = inst_44879);

(statearr_44963[(19)] = inst_44866__$1);

(statearr_44963[(11)] = inst_44865__$1);

(statearr_44963[(20)] = inst_44864__$1);

(statearr_44963[(12)] = inst_44867__$1);

return statearr_44963;
})();
var statearr_44968_46912 = state_44929__$1;
(statearr_44968_46912[(2)] = null);

(statearr_44968_46912[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (40))){
var inst_44896 = (state_44929[(22)]);
var inst_44900 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_44896);
var state_44929__$1 = state_44929;
var statearr_44973_46913 = state_44929__$1;
(statearr_44973_46913[(2)] = inst_44900);

(statearr_44973_46913[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (33))){
var inst_44883 = (state_44929[(23)]);
var inst_44885 = cljs.core.chunked_seq_QMARK_(inst_44883);
var state_44929__$1 = state_44929;
if(inst_44885){
var statearr_44981_46914 = state_44929__$1;
(statearr_44981_46914[(1)] = (36));

} else {
var statearr_44983_46919 = state_44929__$1;
(statearr_44983_46919[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (13))){
var inst_44813 = (state_44929[(24)]);
var inst_44816 = cljs.core.async.close_BANG_(inst_44813);
var state_44929__$1 = state_44929;
var statearr_44984_46921 = state_44929__$1;
(statearr_44984_46921[(2)] = inst_44816);

(statearr_44984_46921[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (22))){
var inst_44836 = (state_44929[(8)]);
var inst_44839 = cljs.core.async.close_BANG_(inst_44836);
var state_44929__$1 = state_44929;
var statearr_44985_46922 = state_44929__$1;
(statearr_44985_46922[(2)] = inst_44839);

(statearr_44985_46922[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (36))){
var inst_44883 = (state_44929[(23)]);
var inst_44889 = cljs.core.chunk_first(inst_44883);
var inst_44890 = cljs.core.chunk_rest(inst_44883);
var inst_44891 = cljs.core.count(inst_44889);
var inst_44864 = inst_44890;
var inst_44865 = inst_44889;
var inst_44866 = inst_44891;
var inst_44867 = (0);
var state_44929__$1 = (function (){var statearr_44988 = state_44929;
(statearr_44988[(19)] = inst_44866);

(statearr_44988[(11)] = inst_44865);

(statearr_44988[(20)] = inst_44864);

(statearr_44988[(12)] = inst_44867);

return statearr_44988;
})();
var statearr_44989_46924 = state_44929__$1;
(statearr_44989_46924[(2)] = null);

(statearr_44989_46924[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (41))){
var inst_44883 = (state_44929[(23)]);
var inst_44902 = (state_44929[(2)]);
var inst_44903 = cljs.core.next(inst_44883);
var inst_44864 = inst_44903;
var inst_44865 = null;
var inst_44866 = (0);
var inst_44867 = (0);
var state_44929__$1 = (function (){var statearr_44990 = state_44929;
(statearr_44990[(25)] = inst_44902);

(statearr_44990[(19)] = inst_44866);

(statearr_44990[(11)] = inst_44865);

(statearr_44990[(20)] = inst_44864);

(statearr_44990[(12)] = inst_44867);

return statearr_44990;
})();
var statearr_44991_46929 = state_44929__$1;
(statearr_44991_46929[(2)] = null);

(statearr_44991_46929[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (43))){
var state_44929__$1 = state_44929;
var statearr_44994_46930 = state_44929__$1;
(statearr_44994_46930[(2)] = null);

(statearr_44994_46930[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (29))){
var inst_44911 = (state_44929[(2)]);
var state_44929__$1 = state_44929;
var statearr_44996_46932 = state_44929__$1;
(statearr_44996_46932[(2)] = inst_44911);

(statearr_44996_46932[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (44))){
var inst_44920 = (state_44929[(2)]);
var state_44929__$1 = (function (){var statearr_44998 = state_44929;
(statearr_44998[(26)] = inst_44920);

return statearr_44998;
})();
var statearr_44999_46933 = state_44929__$1;
(statearr_44999_46933[(2)] = null);

(statearr_44999_46933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (6))){
var inst_44856 = (state_44929[(27)]);
var inst_44855 = cljs.core.deref(cs);
var inst_44856__$1 = cljs.core.keys(inst_44855);
var inst_44857 = cljs.core.count(inst_44856__$1);
var inst_44858 = cljs.core.reset_BANG_(dctr,inst_44857);
var inst_44863 = cljs.core.seq(inst_44856__$1);
var inst_44864 = inst_44863;
var inst_44865 = null;
var inst_44866 = (0);
var inst_44867 = (0);
var state_44929__$1 = (function (){var statearr_45001 = state_44929;
(statearr_45001[(27)] = inst_44856__$1);

(statearr_45001[(19)] = inst_44866);

(statearr_45001[(11)] = inst_44865);

(statearr_45001[(20)] = inst_44864);

(statearr_45001[(28)] = inst_44858);

(statearr_45001[(12)] = inst_44867);

return statearr_45001;
})();
var statearr_45002_46934 = state_44929__$1;
(statearr_45002_46934[(2)] = null);

(statearr_45002_46934[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (28))){
var inst_44864 = (state_44929[(20)]);
var inst_44883 = (state_44929[(23)]);
var inst_44883__$1 = cljs.core.seq(inst_44864);
var state_44929__$1 = (function (){var statearr_45003 = state_44929;
(statearr_45003[(23)] = inst_44883__$1);

return statearr_45003;
})();
if(inst_44883__$1){
var statearr_45004_46937 = state_44929__$1;
(statearr_45004_46937[(1)] = (33));

} else {
var statearr_45005_46938 = state_44929__$1;
(statearr_45005_46938[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (25))){
var inst_44866 = (state_44929[(19)]);
var inst_44867 = (state_44929[(12)]);
var inst_44869 = (inst_44867 < inst_44866);
var inst_44870 = inst_44869;
var state_44929__$1 = state_44929;
if(cljs.core.truth_(inst_44870)){
var statearr_45006_46941 = state_44929__$1;
(statearr_45006_46941[(1)] = (27));

} else {
var statearr_45007_46942 = state_44929__$1;
(statearr_45007_46942[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (34))){
var state_44929__$1 = state_44929;
var statearr_45009_46945 = state_44929__$1;
(statearr_45009_46945[(2)] = null);

(statearr_45009_46945[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (17))){
var state_44929__$1 = state_44929;
var statearr_45010_46946 = state_44929__$1;
(statearr_45010_46946[(2)] = null);

(statearr_45010_46946[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (3))){
var inst_44925 = (state_44929[(2)]);
var state_44929__$1 = state_44929;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44929__$1,inst_44925);
} else {
if((state_val_44930 === (12))){
var inst_44851 = (state_44929[(2)]);
var state_44929__$1 = state_44929;
var statearr_45011_46953 = state_44929__$1;
(statearr_45011_46953[(2)] = inst_44851);

(statearr_45011_46953[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (2))){
var state_44929__$1 = state_44929;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44929__$1,(4),ch);
} else {
if((state_val_44930 === (23))){
var state_44929__$1 = state_44929;
var statearr_45018_46955 = state_44929__$1;
(statearr_45018_46955[(2)] = null);

(statearr_45018_46955[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (35))){
var inst_44909 = (state_44929[(2)]);
var state_44929__$1 = state_44929;
var statearr_45019_46956 = state_44929__$1;
(statearr_45019_46956[(2)] = inst_44909);

(statearr_45019_46956[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (19))){
var inst_44823 = (state_44929[(7)]);
var inst_44827 = cljs.core.chunk_first(inst_44823);
var inst_44828 = cljs.core.chunk_rest(inst_44823);
var inst_44829 = cljs.core.count(inst_44827);
var inst_44800 = inst_44828;
var inst_44801 = inst_44827;
var inst_44802 = inst_44829;
var inst_44803 = (0);
var state_44929__$1 = (function (){var statearr_45021 = state_44929;
(statearr_45021[(14)] = inst_44800);

(statearr_45021[(15)] = inst_44802);

(statearr_45021[(16)] = inst_44801);

(statearr_45021[(17)] = inst_44803);

return statearr_45021;
})();
var statearr_45024_46957 = state_44929__$1;
(statearr_45024_46957[(2)] = null);

(statearr_45024_46957[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (11))){
var inst_44823 = (state_44929[(7)]);
var inst_44800 = (state_44929[(14)]);
var inst_44823__$1 = cljs.core.seq(inst_44800);
var state_44929__$1 = (function (){var statearr_45026 = state_44929;
(statearr_45026[(7)] = inst_44823__$1);

return statearr_45026;
})();
if(inst_44823__$1){
var statearr_45027_46959 = state_44929__$1;
(statearr_45027_46959[(1)] = (16));

} else {
var statearr_45028_46961 = state_44929__$1;
(statearr_45028_46961[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (9))){
var inst_44853 = (state_44929[(2)]);
var state_44929__$1 = state_44929;
var statearr_45029_46962 = state_44929__$1;
(statearr_45029_46962[(2)] = inst_44853);

(statearr_45029_46962[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (5))){
var inst_44798 = cljs.core.deref(cs);
var inst_44799 = cljs.core.seq(inst_44798);
var inst_44800 = inst_44799;
var inst_44801 = null;
var inst_44802 = (0);
var inst_44803 = (0);
var state_44929__$1 = (function (){var statearr_45030 = state_44929;
(statearr_45030[(14)] = inst_44800);

(statearr_45030[(15)] = inst_44802);

(statearr_45030[(16)] = inst_44801);

(statearr_45030[(17)] = inst_44803);

return statearr_45030;
})();
var statearr_45031_46963 = state_44929__$1;
(statearr_45031_46963[(2)] = null);

(statearr_45031_46963[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (14))){
var state_44929__$1 = state_44929;
var statearr_45032_46964 = state_44929__$1;
(statearr_45032_46964[(2)] = null);

(statearr_45032_46964[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (45))){
var inst_44917 = (state_44929[(2)]);
var state_44929__$1 = state_44929;
var statearr_45033_46965 = state_44929__$1;
(statearr_45033_46965[(2)] = inst_44917);

(statearr_45033_46965[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (26))){
var inst_44856 = (state_44929[(27)]);
var inst_44913 = (state_44929[(2)]);
var inst_44914 = cljs.core.seq(inst_44856);
var state_44929__$1 = (function (){var statearr_45034 = state_44929;
(statearr_45034[(29)] = inst_44913);

return statearr_45034;
})();
if(inst_44914){
var statearr_45036_46966 = state_44929__$1;
(statearr_45036_46966[(1)] = (42));

} else {
var statearr_45037_46967 = state_44929__$1;
(statearr_45037_46967[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (16))){
var inst_44823 = (state_44929[(7)]);
var inst_44825 = cljs.core.chunked_seq_QMARK_(inst_44823);
var state_44929__$1 = state_44929;
if(inst_44825){
var statearr_45038_46968 = state_44929__$1;
(statearr_45038_46968[(1)] = (19));

} else {
var statearr_45039_46973 = state_44929__$1;
(statearr_45039_46973[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (38))){
var inst_44906 = (state_44929[(2)]);
var state_44929__$1 = state_44929;
var statearr_45041_46978 = state_44929__$1;
(statearr_45041_46978[(2)] = inst_44906);

(statearr_45041_46978[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (30))){
var state_44929__$1 = state_44929;
var statearr_45042_46979 = state_44929__$1;
(statearr_45042_46979[(2)] = null);

(statearr_45042_46979[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (10))){
var inst_44801 = (state_44929[(16)]);
var inst_44803 = (state_44929[(17)]);
var inst_44812 = cljs.core._nth(inst_44801,inst_44803);
var inst_44813 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44812,(0),null);
var inst_44814 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44812,(1),null);
var state_44929__$1 = (function (){var statearr_45043 = state_44929;
(statearr_45043[(24)] = inst_44813);

return statearr_45043;
})();
if(cljs.core.truth_(inst_44814)){
var statearr_45044_46985 = state_44929__$1;
(statearr_45044_46985[(1)] = (13));

} else {
var statearr_45045_46989 = state_44929__$1;
(statearr_45045_46989[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (18))){
var inst_44849 = (state_44929[(2)]);
var state_44929__$1 = state_44929;
var statearr_45047_46990 = state_44929__$1;
(statearr_45047_46990[(2)] = inst_44849);

(statearr_45047_46990[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (42))){
var state_44929__$1 = state_44929;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44929__$1,(45),dchan);
} else {
if((state_val_44930 === (37))){
var inst_44791 = (state_44929[(9)]);
var inst_44896 = (state_44929[(22)]);
var inst_44883 = (state_44929[(23)]);
var inst_44896__$1 = cljs.core.first(inst_44883);
var inst_44897 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_44896__$1,inst_44791,done);
var state_44929__$1 = (function (){var statearr_45048 = state_44929;
(statearr_45048[(22)] = inst_44896__$1);

return statearr_45048;
})();
if(cljs.core.truth_(inst_44897)){
var statearr_45052_46995 = state_44929__$1;
(statearr_45052_46995[(1)] = (39));

} else {
var statearr_45053_46997 = state_44929__$1;
(statearr_45053_46997[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44930 === (8))){
var inst_44802 = (state_44929[(15)]);
var inst_44803 = (state_44929[(17)]);
var inst_44806 = (inst_44803 < inst_44802);
var inst_44807 = inst_44806;
var state_44929__$1 = state_44929;
if(cljs.core.truth_(inst_44807)){
var statearr_45054_46999 = state_44929__$1;
(statearr_45054_46999[(1)] = (10));

} else {
var statearr_45055_47000 = state_44929__$1;
(statearr_45055_47000[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__43403__auto__ = null;
var cljs$core$async$mult_$_state_machine__43403__auto____0 = (function (){
var statearr_45057 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45057[(0)] = cljs$core$async$mult_$_state_machine__43403__auto__);

(statearr_45057[(1)] = (1));

return statearr_45057;
});
var cljs$core$async$mult_$_state_machine__43403__auto____1 = (function (state_44929){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_44929);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e45058){var ex__43406__auto__ = e45058;
var statearr_45059_47002 = state_44929;
(statearr_45059_47002[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_44929[(4)]))){
var statearr_45063_47003 = state_44929;
(statearr_45063_47003[(1)] = cljs.core.first((state_44929[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47004 = state_44929;
state_44929 = G__47004;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__43403__auto__ = function(state_44929){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__43403__auto____1.call(this,state_44929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__43403__auto____0;
cljs$core$async$mult_$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__43403__auto____1;
return cljs$core$async$mult_$_state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_45064 = f__43596__auto__();
(statearr_45064[(6)] = c__43595__auto___46880);

return statearr_45064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__45066 = arguments.length;
switch (G__45066) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_47008 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_47008(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_47011 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_47011(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_47016 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_47016(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_47020 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_47020(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_47031 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_47031(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47036 = arguments.length;
var i__4737__auto___47037 = (0);
while(true){
if((i__4737__auto___47037 < len__4736__auto___47036)){
args__4742__auto__.push((arguments[i__4737__auto___47037]));

var G__47041 = (i__4737__auto___47037 + (1));
i__4737__auto___47037 = G__47041;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__45083){
var map__45084 = p__45083;
var map__45084__$1 = (((((!((map__45084 == null))))?(((((map__45084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45084.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45084):map__45084);
var opts = map__45084__$1;
var statearr_45088_47046 = state;
(statearr_45088_47046[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts((function (val){
var statearr_45090_47048 = state;
(statearr_45090_47048[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_45095_47049 = state;
(statearr_45095_47049[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq45077){
var G__45078 = cljs.core.first(seq45077);
var seq45077__$1 = cljs.core.next(seq45077);
var G__45079 = cljs.core.first(seq45077__$1);
var seq45077__$2 = cljs.core.next(seq45077__$1);
var G__45080 = cljs.core.first(seq45077__$2);
var seq45077__$3 = cljs.core.next(seq45077__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45078,G__45079,G__45080,seq45077__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45113 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45113 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta45114){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta45114 = meta45114;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45113.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45115,meta45114__$1){
var self__ = this;
var _45115__$1 = this;
return (new cljs.core.async.t_cljs$core$async45113(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta45114__$1));
}));

(cljs.core.async.t_cljs$core$async45113.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45115){
var self__ = this;
var _45115__$1 = this;
return self__.meta45114;
}));

(cljs.core.async.t_cljs$core$async45113.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45113.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async45113.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45113.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45113.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45113.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45113.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45113.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45113.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta45114","meta45114",-978487790,null)], null);
}));

(cljs.core.async.t_cljs$core$async45113.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45113.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45113");

(cljs.core.async.t_cljs$core$async45113.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45113");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45113.
 */
cljs.core.async.__GT_t_cljs$core$async45113 = (function cljs$core$async$mix_$___GT_t_cljs$core$async45113(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45114){
return (new cljs.core.async.t_cljs$core$async45113(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45114));
});

}

return (new cljs.core.async.t_cljs$core$async45113(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43595__auto___47090 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_45224){
var state_val_45226 = (state_45224[(1)]);
if((state_val_45226 === (7))){
var inst_45135 = (state_45224[(2)]);
var state_45224__$1 = state_45224;
var statearr_45228_47091 = state_45224__$1;
(statearr_45228_47091[(2)] = inst_45135);

(statearr_45228_47091[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (20))){
var inst_45147 = (state_45224[(7)]);
var state_45224__$1 = state_45224;
var statearr_45229_47092 = state_45224__$1;
(statearr_45229_47092[(2)] = inst_45147);

(statearr_45229_47092[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (27))){
var state_45224__$1 = state_45224;
var statearr_45230_47099 = state_45224__$1;
(statearr_45230_47099[(2)] = null);

(statearr_45230_47099[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (1))){
var inst_45122 = (state_45224[(8)]);
var inst_45122__$1 = calc_state();
var inst_45124 = (inst_45122__$1 == null);
var inst_45125 = cljs.core.not(inst_45124);
var state_45224__$1 = (function (){var statearr_45233 = state_45224;
(statearr_45233[(8)] = inst_45122__$1);

return statearr_45233;
})();
if(inst_45125){
var statearr_45234_47101 = state_45224__$1;
(statearr_45234_47101[(1)] = (2));

} else {
var statearr_45235_47103 = state_45224__$1;
(statearr_45235_47103[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (24))){
var inst_45183 = (state_45224[(9)]);
var inst_45171 = (state_45224[(10)]);
var inst_45197 = (state_45224[(11)]);
var inst_45197__$1 = (inst_45171.cljs$core$IFn$_invoke$arity$1 ? inst_45171.cljs$core$IFn$_invoke$arity$1(inst_45183) : inst_45171.call(null,inst_45183));
var state_45224__$1 = (function (){var statearr_45240 = state_45224;
(statearr_45240[(11)] = inst_45197__$1);

return statearr_45240;
})();
if(cljs.core.truth_(inst_45197__$1)){
var statearr_45245_47104 = state_45224__$1;
(statearr_45245_47104[(1)] = (29));

} else {
var statearr_45247_47105 = state_45224__$1;
(statearr_45247_47105[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (4))){
var inst_45138 = (state_45224[(2)]);
var state_45224__$1 = state_45224;
if(cljs.core.truth_(inst_45138)){
var statearr_45248_47106 = state_45224__$1;
(statearr_45248_47106[(1)] = (8));

} else {
var statearr_45249_47107 = state_45224__$1;
(statearr_45249_47107[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (15))){
var inst_45165 = (state_45224[(2)]);
var state_45224__$1 = state_45224;
if(cljs.core.truth_(inst_45165)){
var statearr_45254_47108 = state_45224__$1;
(statearr_45254_47108[(1)] = (19));

} else {
var statearr_45256_47109 = state_45224__$1;
(statearr_45256_47109[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (21))){
var inst_45170 = (state_45224[(12)]);
var inst_45170__$1 = (state_45224[(2)]);
var inst_45171 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45170__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45172 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45170__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45173 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45170__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_45224__$1 = (function (){var statearr_45264 = state_45224;
(statearr_45264[(13)] = inst_45172);

(statearr_45264[(12)] = inst_45170__$1);

(statearr_45264[(10)] = inst_45171);

return statearr_45264;
})();
return cljs.core.async.ioc_alts_BANG_(state_45224__$1,(22),inst_45173);
} else {
if((state_val_45226 === (31))){
var inst_45205 = (state_45224[(2)]);
var state_45224__$1 = state_45224;
if(cljs.core.truth_(inst_45205)){
var statearr_45265_47118 = state_45224__$1;
(statearr_45265_47118[(1)] = (32));

} else {
var statearr_45266_47119 = state_45224__$1;
(statearr_45266_47119[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (32))){
var inst_45182 = (state_45224[(14)]);
var state_45224__$1 = state_45224;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45224__$1,(35),out,inst_45182);
} else {
if((state_val_45226 === (33))){
var inst_45170 = (state_45224[(12)]);
var inst_45147 = inst_45170;
var state_45224__$1 = (function (){var statearr_45271 = state_45224;
(statearr_45271[(7)] = inst_45147);

return statearr_45271;
})();
var statearr_45272_47120 = state_45224__$1;
(statearr_45272_47120[(2)] = null);

(statearr_45272_47120[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (13))){
var inst_45147 = (state_45224[(7)]);
var inst_45154 = inst_45147.cljs$lang$protocol_mask$partition0$;
var inst_45155 = (inst_45154 & (64));
var inst_45156 = inst_45147.cljs$core$ISeq$;
var inst_45157 = (cljs.core.PROTOCOL_SENTINEL === inst_45156);
var inst_45158 = ((inst_45155) || (inst_45157));
var state_45224__$1 = state_45224;
if(cljs.core.truth_(inst_45158)){
var statearr_45273_47122 = state_45224__$1;
(statearr_45273_47122[(1)] = (16));

} else {
var statearr_45274_47123 = state_45224__$1;
(statearr_45274_47123[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (22))){
var inst_45182 = (state_45224[(14)]);
var inst_45183 = (state_45224[(9)]);
var inst_45181 = (state_45224[(2)]);
var inst_45182__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45181,(0),null);
var inst_45183__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45181,(1),null);
var inst_45184 = (inst_45182__$1 == null);
var inst_45185 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45183__$1,change);
var inst_45186 = ((inst_45184) || (inst_45185));
var state_45224__$1 = (function (){var statearr_45275 = state_45224;
(statearr_45275[(14)] = inst_45182__$1);

(statearr_45275[(9)] = inst_45183__$1);

return statearr_45275;
})();
if(cljs.core.truth_(inst_45186)){
var statearr_45276_47124 = state_45224__$1;
(statearr_45276_47124[(1)] = (23));

} else {
var statearr_45277_47125 = state_45224__$1;
(statearr_45277_47125[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (36))){
var inst_45170 = (state_45224[(12)]);
var inst_45147 = inst_45170;
var state_45224__$1 = (function (){var statearr_45278 = state_45224;
(statearr_45278[(7)] = inst_45147);

return statearr_45278;
})();
var statearr_45279_47126 = state_45224__$1;
(statearr_45279_47126[(2)] = null);

(statearr_45279_47126[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (29))){
var inst_45197 = (state_45224[(11)]);
var state_45224__$1 = state_45224;
var statearr_45280_47129 = state_45224__$1;
(statearr_45280_47129[(2)] = inst_45197);

(statearr_45280_47129[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (6))){
var state_45224__$1 = state_45224;
var statearr_45281_47131 = state_45224__$1;
(statearr_45281_47131[(2)] = false);

(statearr_45281_47131[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (28))){
var inst_45193 = (state_45224[(2)]);
var inst_45194 = calc_state();
var inst_45147 = inst_45194;
var state_45224__$1 = (function (){var statearr_45282 = state_45224;
(statearr_45282[(15)] = inst_45193);

(statearr_45282[(7)] = inst_45147);

return statearr_45282;
})();
var statearr_45283_47132 = state_45224__$1;
(statearr_45283_47132[(2)] = null);

(statearr_45283_47132[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (25))){
var inst_45219 = (state_45224[(2)]);
var state_45224__$1 = state_45224;
var statearr_45284_47133 = state_45224__$1;
(statearr_45284_47133[(2)] = inst_45219);

(statearr_45284_47133[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (34))){
var inst_45217 = (state_45224[(2)]);
var state_45224__$1 = state_45224;
var statearr_45285_47134 = state_45224__$1;
(statearr_45285_47134[(2)] = inst_45217);

(statearr_45285_47134[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (17))){
var state_45224__$1 = state_45224;
var statearr_45288_47135 = state_45224__$1;
(statearr_45288_47135[(2)] = false);

(statearr_45288_47135[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (3))){
var state_45224__$1 = state_45224;
var statearr_45291_47138 = state_45224__$1;
(statearr_45291_47138[(2)] = false);

(statearr_45291_47138[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (12))){
var inst_45221 = (state_45224[(2)]);
var state_45224__$1 = state_45224;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45224__$1,inst_45221);
} else {
if((state_val_45226 === (2))){
var inst_45122 = (state_45224[(8)]);
var inst_45127 = inst_45122.cljs$lang$protocol_mask$partition0$;
var inst_45128 = (inst_45127 & (64));
var inst_45129 = inst_45122.cljs$core$ISeq$;
var inst_45130 = (cljs.core.PROTOCOL_SENTINEL === inst_45129);
var inst_45131 = ((inst_45128) || (inst_45130));
var state_45224__$1 = state_45224;
if(cljs.core.truth_(inst_45131)){
var statearr_45292_47139 = state_45224__$1;
(statearr_45292_47139[(1)] = (5));

} else {
var statearr_45293_47140 = state_45224__$1;
(statearr_45293_47140[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (23))){
var inst_45182 = (state_45224[(14)]);
var inst_45188 = (inst_45182 == null);
var state_45224__$1 = state_45224;
if(cljs.core.truth_(inst_45188)){
var statearr_45294_47141 = state_45224__$1;
(statearr_45294_47141[(1)] = (26));

} else {
var statearr_45295_47142 = state_45224__$1;
(statearr_45295_47142[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (35))){
var inst_45208 = (state_45224[(2)]);
var state_45224__$1 = state_45224;
if(cljs.core.truth_(inst_45208)){
var statearr_45296_47143 = state_45224__$1;
(statearr_45296_47143[(1)] = (36));

} else {
var statearr_45297_47150 = state_45224__$1;
(statearr_45297_47150[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (19))){
var inst_45147 = (state_45224[(7)]);
var inst_45167 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_45147);
var state_45224__$1 = state_45224;
var statearr_45300_47151 = state_45224__$1;
(statearr_45300_47151[(2)] = inst_45167);

(statearr_45300_47151[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (11))){
var inst_45147 = (state_45224[(7)]);
var inst_45151 = (inst_45147 == null);
var inst_45152 = cljs.core.not(inst_45151);
var state_45224__$1 = state_45224;
if(inst_45152){
var statearr_45302_47153 = state_45224__$1;
(statearr_45302_47153[(1)] = (13));

} else {
var statearr_45304_47155 = state_45224__$1;
(statearr_45304_47155[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (9))){
var inst_45122 = (state_45224[(8)]);
var state_45224__$1 = state_45224;
var statearr_45306_47157 = state_45224__$1;
(statearr_45306_47157[(2)] = inst_45122);

(statearr_45306_47157[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (5))){
var state_45224__$1 = state_45224;
var statearr_45307_47160 = state_45224__$1;
(statearr_45307_47160[(2)] = true);

(statearr_45307_47160[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (14))){
var state_45224__$1 = state_45224;
var statearr_45309_47163 = state_45224__$1;
(statearr_45309_47163[(2)] = false);

(statearr_45309_47163[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (26))){
var inst_45183 = (state_45224[(9)]);
var inst_45190 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_45183);
var state_45224__$1 = state_45224;
var statearr_45310_47164 = state_45224__$1;
(statearr_45310_47164[(2)] = inst_45190);

(statearr_45310_47164[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (16))){
var state_45224__$1 = state_45224;
var statearr_45311_47166 = state_45224__$1;
(statearr_45311_47166[(2)] = true);

(statearr_45311_47166[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (38))){
var inst_45213 = (state_45224[(2)]);
var state_45224__$1 = state_45224;
var statearr_45312_47167 = state_45224__$1;
(statearr_45312_47167[(2)] = inst_45213);

(statearr_45312_47167[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (30))){
var inst_45172 = (state_45224[(13)]);
var inst_45183 = (state_45224[(9)]);
var inst_45171 = (state_45224[(10)]);
var inst_45200 = cljs.core.empty_QMARK_(inst_45171);
var inst_45201 = (inst_45172.cljs$core$IFn$_invoke$arity$1 ? inst_45172.cljs$core$IFn$_invoke$arity$1(inst_45183) : inst_45172.call(null,inst_45183));
var inst_45202 = cljs.core.not(inst_45201);
var inst_45203 = ((inst_45200) && (inst_45202));
var state_45224__$1 = state_45224;
var statearr_45317_47168 = state_45224__$1;
(statearr_45317_47168[(2)] = inst_45203);

(statearr_45317_47168[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (10))){
var inst_45122 = (state_45224[(8)]);
var inst_45143 = (state_45224[(2)]);
var inst_45144 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45143,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45145 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45143,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45146 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45143,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_45147 = inst_45122;
var state_45224__$1 = (function (){var statearr_45318 = state_45224;
(statearr_45318[(16)] = inst_45146);

(statearr_45318[(17)] = inst_45144);

(statearr_45318[(7)] = inst_45147);

(statearr_45318[(18)] = inst_45145);

return statearr_45318;
})();
var statearr_45319_47169 = state_45224__$1;
(statearr_45319_47169[(2)] = null);

(statearr_45319_47169[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (18))){
var inst_45162 = (state_45224[(2)]);
var state_45224__$1 = state_45224;
var statearr_45322_47170 = state_45224__$1;
(statearr_45322_47170[(2)] = inst_45162);

(statearr_45322_47170[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (37))){
var state_45224__$1 = state_45224;
var statearr_45323_47172 = state_45224__$1;
(statearr_45323_47172[(2)] = null);

(statearr_45323_47172[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45226 === (8))){
var inst_45122 = (state_45224[(8)]);
var inst_45140 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_45122);
var state_45224__$1 = state_45224;
var statearr_45324_47175 = state_45224__$1;
(statearr_45324_47175[(2)] = inst_45140);

(statearr_45324_47175[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__43403__auto__ = null;
var cljs$core$async$mix_$_state_machine__43403__auto____0 = (function (){
var statearr_45328 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45328[(0)] = cljs$core$async$mix_$_state_machine__43403__auto__);

(statearr_45328[(1)] = (1));

return statearr_45328;
});
var cljs$core$async$mix_$_state_machine__43403__auto____1 = (function (state_45224){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_45224);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e45329){var ex__43406__auto__ = e45329;
var statearr_45330_47177 = state_45224;
(statearr_45330_47177[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_45224[(4)]))){
var statearr_45331_47178 = state_45224;
(statearr_45331_47178[(1)] = cljs.core.first((state_45224[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47179 = state_45224;
state_45224 = G__47179;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__43403__auto__ = function(state_45224){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__43403__auto____1.call(this,state_45224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__43403__auto____0;
cljs$core$async$mix_$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__43403__auto____1;
return cljs$core$async$mix_$_state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_45332 = f__43596__auto__();
(statearr_45332[(6)] = c__43595__auto___47090);

return statearr_45332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_47181 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_47181(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_47183 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_47183(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_47188 = (function() {
var G__47189 = null;
var G__47189__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__47189__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__47189 = function(p,v){
switch(arguments.length){
case 1:
return G__47189__1.call(this,p);
case 2:
return G__47189__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47189.cljs$core$IFn$_invoke$arity$1 = G__47189__1;
G__47189.cljs$core$IFn$_invoke$arity$2 = G__47189__2;
return G__47189;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__45349 = arguments.length;
switch (G__45349) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_47188(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_47188(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__45357 = arguments.length;
switch (G__45357) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__45351_SHARP_){
if(cljs.core.truth_((p1__45351_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__45351_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__45351_SHARP_.call(null,topic)))){
return p1__45351_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__45351_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45361 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45361 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta45362){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta45362 = meta45362;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45361.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45363,meta45362__$1){
var self__ = this;
var _45363__$1 = this;
return (new cljs.core.async.t_cljs$core$async45361(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta45362__$1));
}));

(cljs.core.async.t_cljs$core$async45361.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45363){
var self__ = this;
var _45363__$1 = this;
return self__.meta45362;
}));

(cljs.core.async.t_cljs$core$async45361.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45361.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async45361.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45361.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async45361.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async45361.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async45361.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async45361.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta45362","meta45362",-1183272245,null)], null);
}));

(cljs.core.async.t_cljs$core$async45361.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45361.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45361");

(cljs.core.async.t_cljs$core$async45361.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45361");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45361.
 */
cljs.core.async.__GT_t_cljs$core$async45361 = (function cljs$core$async$__GT_t_cljs$core$async45361(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta45362){
return (new cljs.core.async.t_cljs$core$async45361(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta45362));
});

}

return (new cljs.core.async.t_cljs$core$async45361(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43595__auto___47225 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_45437){
var state_val_45438 = (state_45437[(1)]);
if((state_val_45438 === (7))){
var inst_45433 = (state_45437[(2)]);
var state_45437__$1 = state_45437;
var statearr_45439_47226 = state_45437__$1;
(statearr_45439_47226[(2)] = inst_45433);

(statearr_45439_47226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (20))){
var state_45437__$1 = state_45437;
var statearr_45440_47232 = state_45437__$1;
(statearr_45440_47232[(2)] = null);

(statearr_45440_47232[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (1))){
var state_45437__$1 = state_45437;
var statearr_45446_47237 = state_45437__$1;
(statearr_45446_47237[(2)] = null);

(statearr_45446_47237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (24))){
var inst_45415 = (state_45437[(7)]);
var inst_45425 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_45415);
var state_45437__$1 = state_45437;
var statearr_45447_47245 = state_45437__$1;
(statearr_45447_47245[(2)] = inst_45425);

(statearr_45447_47245[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (4))){
var inst_45367 = (state_45437[(8)]);
var inst_45367__$1 = (state_45437[(2)]);
var inst_45368 = (inst_45367__$1 == null);
var state_45437__$1 = (function (){var statearr_45449 = state_45437;
(statearr_45449[(8)] = inst_45367__$1);

return statearr_45449;
})();
if(cljs.core.truth_(inst_45368)){
var statearr_45450_47252 = state_45437__$1;
(statearr_45450_47252[(1)] = (5));

} else {
var statearr_45451_47253 = state_45437__$1;
(statearr_45451_47253[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (15))){
var inst_45409 = (state_45437[(2)]);
var state_45437__$1 = state_45437;
var statearr_45452_47254 = state_45437__$1;
(statearr_45452_47254[(2)] = inst_45409);

(statearr_45452_47254[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (21))){
var inst_45430 = (state_45437[(2)]);
var state_45437__$1 = (function (){var statearr_45453 = state_45437;
(statearr_45453[(9)] = inst_45430);

return statearr_45453;
})();
var statearr_45454_47257 = state_45437__$1;
(statearr_45454_47257[(2)] = null);

(statearr_45454_47257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (13))){
var inst_45391 = (state_45437[(10)]);
var inst_45393 = cljs.core.chunked_seq_QMARK_(inst_45391);
var state_45437__$1 = state_45437;
if(inst_45393){
var statearr_45455_47259 = state_45437__$1;
(statearr_45455_47259[(1)] = (16));

} else {
var statearr_45456_47261 = state_45437__$1;
(statearr_45456_47261[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (22))){
var inst_45422 = (state_45437[(2)]);
var state_45437__$1 = state_45437;
if(cljs.core.truth_(inst_45422)){
var statearr_45457_47262 = state_45437__$1;
(statearr_45457_47262[(1)] = (23));

} else {
var statearr_45458_47265 = state_45437__$1;
(statearr_45458_47265[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (6))){
var inst_45367 = (state_45437[(8)]);
var inst_45415 = (state_45437[(7)]);
var inst_45418 = (state_45437[(11)]);
var inst_45415__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_45367) : topic_fn.call(null,inst_45367));
var inst_45417 = cljs.core.deref(mults);
var inst_45418__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45417,inst_45415__$1);
var state_45437__$1 = (function (){var statearr_45459 = state_45437;
(statearr_45459[(7)] = inst_45415__$1);

(statearr_45459[(11)] = inst_45418__$1);

return statearr_45459;
})();
if(cljs.core.truth_(inst_45418__$1)){
var statearr_45460_47267 = state_45437__$1;
(statearr_45460_47267[(1)] = (19));

} else {
var statearr_45461_47269 = state_45437__$1;
(statearr_45461_47269[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (25))){
var inst_45427 = (state_45437[(2)]);
var state_45437__$1 = state_45437;
var statearr_45462_47271 = state_45437__$1;
(statearr_45462_47271[(2)] = inst_45427);

(statearr_45462_47271[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (17))){
var inst_45391 = (state_45437[(10)]);
var inst_45400 = cljs.core.first(inst_45391);
var inst_45401 = cljs.core.async.muxch_STAR_(inst_45400);
var inst_45402 = cljs.core.async.close_BANG_(inst_45401);
var inst_45403 = cljs.core.next(inst_45391);
var inst_45377 = inst_45403;
var inst_45378 = null;
var inst_45379 = (0);
var inst_45380 = (0);
var state_45437__$1 = (function (){var statearr_45466 = state_45437;
(statearr_45466[(12)] = inst_45378);

(statearr_45466[(13)] = inst_45380);

(statearr_45466[(14)] = inst_45402);

(statearr_45466[(15)] = inst_45377);

(statearr_45466[(16)] = inst_45379);

return statearr_45466;
})();
var statearr_45467_47275 = state_45437__$1;
(statearr_45467_47275[(2)] = null);

(statearr_45467_47275[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (3))){
var inst_45435 = (state_45437[(2)]);
var state_45437__$1 = state_45437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45437__$1,inst_45435);
} else {
if((state_val_45438 === (12))){
var inst_45411 = (state_45437[(2)]);
var state_45437__$1 = state_45437;
var statearr_45468_47279 = state_45437__$1;
(statearr_45468_47279[(2)] = inst_45411);

(statearr_45468_47279[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (2))){
var state_45437__$1 = state_45437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45437__$1,(4),ch);
} else {
if((state_val_45438 === (23))){
var state_45437__$1 = state_45437;
var statearr_45469_47282 = state_45437__$1;
(statearr_45469_47282[(2)] = null);

(statearr_45469_47282[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (19))){
var inst_45367 = (state_45437[(8)]);
var inst_45418 = (state_45437[(11)]);
var inst_45420 = cljs.core.async.muxch_STAR_(inst_45418);
var state_45437__$1 = state_45437;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45437__$1,(22),inst_45420,inst_45367);
} else {
if((state_val_45438 === (11))){
var inst_45391 = (state_45437[(10)]);
var inst_45377 = (state_45437[(15)]);
var inst_45391__$1 = cljs.core.seq(inst_45377);
var state_45437__$1 = (function (){var statearr_45470 = state_45437;
(statearr_45470[(10)] = inst_45391__$1);

return statearr_45470;
})();
if(inst_45391__$1){
var statearr_45471_47284 = state_45437__$1;
(statearr_45471_47284[(1)] = (13));

} else {
var statearr_45472_47285 = state_45437__$1;
(statearr_45472_47285[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (9))){
var inst_45413 = (state_45437[(2)]);
var state_45437__$1 = state_45437;
var statearr_45473_47286 = state_45437__$1;
(statearr_45473_47286[(2)] = inst_45413);

(statearr_45473_47286[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (5))){
var inst_45374 = cljs.core.deref(mults);
var inst_45375 = cljs.core.vals(inst_45374);
var inst_45376 = cljs.core.seq(inst_45375);
var inst_45377 = inst_45376;
var inst_45378 = null;
var inst_45379 = (0);
var inst_45380 = (0);
var state_45437__$1 = (function (){var statearr_45474 = state_45437;
(statearr_45474[(12)] = inst_45378);

(statearr_45474[(13)] = inst_45380);

(statearr_45474[(15)] = inst_45377);

(statearr_45474[(16)] = inst_45379);

return statearr_45474;
})();
var statearr_45475_47298 = state_45437__$1;
(statearr_45475_47298[(2)] = null);

(statearr_45475_47298[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (14))){
var state_45437__$1 = state_45437;
var statearr_45479_47300 = state_45437__$1;
(statearr_45479_47300[(2)] = null);

(statearr_45479_47300[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (16))){
var inst_45391 = (state_45437[(10)]);
var inst_45395 = cljs.core.chunk_first(inst_45391);
var inst_45396 = cljs.core.chunk_rest(inst_45391);
var inst_45397 = cljs.core.count(inst_45395);
var inst_45377 = inst_45396;
var inst_45378 = inst_45395;
var inst_45379 = inst_45397;
var inst_45380 = (0);
var state_45437__$1 = (function (){var statearr_45480 = state_45437;
(statearr_45480[(12)] = inst_45378);

(statearr_45480[(13)] = inst_45380);

(statearr_45480[(15)] = inst_45377);

(statearr_45480[(16)] = inst_45379);

return statearr_45480;
})();
var statearr_45481_47318 = state_45437__$1;
(statearr_45481_47318[(2)] = null);

(statearr_45481_47318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (10))){
var inst_45378 = (state_45437[(12)]);
var inst_45380 = (state_45437[(13)]);
var inst_45377 = (state_45437[(15)]);
var inst_45379 = (state_45437[(16)]);
var inst_45385 = cljs.core._nth(inst_45378,inst_45380);
var inst_45386 = cljs.core.async.muxch_STAR_(inst_45385);
var inst_45387 = cljs.core.async.close_BANG_(inst_45386);
var inst_45388 = (inst_45380 + (1));
var tmp45476 = inst_45378;
var tmp45477 = inst_45377;
var tmp45478 = inst_45379;
var inst_45377__$1 = tmp45477;
var inst_45378__$1 = tmp45476;
var inst_45379__$1 = tmp45478;
var inst_45380__$1 = inst_45388;
var state_45437__$1 = (function (){var statearr_45482 = state_45437;
(statearr_45482[(12)] = inst_45378__$1);

(statearr_45482[(13)] = inst_45380__$1);

(statearr_45482[(17)] = inst_45387);

(statearr_45482[(15)] = inst_45377__$1);

(statearr_45482[(16)] = inst_45379__$1);

return statearr_45482;
})();
var statearr_45483_47339 = state_45437__$1;
(statearr_45483_47339[(2)] = null);

(statearr_45483_47339[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (18))){
var inst_45406 = (state_45437[(2)]);
var state_45437__$1 = state_45437;
var statearr_45484_47345 = state_45437__$1;
(statearr_45484_47345[(2)] = inst_45406);

(statearr_45484_47345[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45438 === (8))){
var inst_45380 = (state_45437[(13)]);
var inst_45379 = (state_45437[(16)]);
var inst_45382 = (inst_45380 < inst_45379);
var inst_45383 = inst_45382;
var state_45437__$1 = state_45437;
if(cljs.core.truth_(inst_45383)){
var statearr_45485_47363 = state_45437__$1;
(statearr_45485_47363[(1)] = (10));

} else {
var statearr_45486_47366 = state_45437__$1;
(statearr_45486_47366[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43403__auto__ = null;
var cljs$core$async$state_machine__43403__auto____0 = (function (){
var statearr_45487 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45487[(0)] = cljs$core$async$state_machine__43403__auto__);

(statearr_45487[(1)] = (1));

return statearr_45487;
});
var cljs$core$async$state_machine__43403__auto____1 = (function (state_45437){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_45437);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e45488){var ex__43406__auto__ = e45488;
var statearr_45489_47389 = state_45437;
(statearr_45489_47389[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_45437[(4)]))){
var statearr_45490_47391 = state_45437;
(statearr_45490_47391[(1)] = cljs.core.first((state_45437[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47392 = state_45437;
state_45437 = G__47392;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$state_machine__43403__auto__ = function(state_45437){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43403__auto____1.call(this,state_45437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43403__auto____0;
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43403__auto____1;
return cljs$core$async$state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_45491 = f__43596__auto__();
(statearr_45491[(6)] = c__43595__auto___47225);

return statearr_45491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__45494 = arguments.length;
switch (G__45494) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__45496 = arguments.length;
switch (G__45496) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__45500 = arguments.length;
switch (G__45500) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__43595__auto___47421 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_45550){
var state_val_45551 = (state_45550[(1)]);
if((state_val_45551 === (7))){
var state_45550__$1 = state_45550;
var statearr_45553_47422 = state_45550__$1;
(statearr_45553_47422[(2)] = null);

(statearr_45553_47422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45551 === (1))){
var state_45550__$1 = state_45550;
var statearr_45554_47423 = state_45550__$1;
(statearr_45554_47423[(2)] = null);

(statearr_45554_47423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45551 === (4))){
var inst_45510 = (state_45550[(7)]);
var inst_45509 = (state_45550[(8)]);
var inst_45512 = (inst_45510 < inst_45509);
var state_45550__$1 = state_45550;
if(cljs.core.truth_(inst_45512)){
var statearr_45555_47424 = state_45550__$1;
(statearr_45555_47424[(1)] = (6));

} else {
var statearr_45556_47426 = state_45550__$1;
(statearr_45556_47426[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45551 === (15))){
var inst_45535 = (state_45550[(9)]);
var inst_45540 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_45535);
var state_45550__$1 = state_45550;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45550__$1,(17),out,inst_45540);
} else {
if((state_val_45551 === (13))){
var inst_45535 = (state_45550[(9)]);
var inst_45535__$1 = (state_45550[(2)]);
var inst_45536 = cljs.core.some(cljs.core.nil_QMARK_,inst_45535__$1);
var state_45550__$1 = (function (){var statearr_45557 = state_45550;
(statearr_45557[(9)] = inst_45535__$1);

return statearr_45557;
})();
if(cljs.core.truth_(inst_45536)){
var statearr_45558_47427 = state_45550__$1;
(statearr_45558_47427[(1)] = (14));

} else {
var statearr_45559_47428 = state_45550__$1;
(statearr_45559_47428[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45551 === (6))){
var state_45550__$1 = state_45550;
var statearr_45560_47429 = state_45550__$1;
(statearr_45560_47429[(2)] = null);

(statearr_45560_47429[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45551 === (17))){
var inst_45542 = (state_45550[(2)]);
var state_45550__$1 = (function (){var statearr_45566 = state_45550;
(statearr_45566[(10)] = inst_45542);

return statearr_45566;
})();
var statearr_45567_47436 = state_45550__$1;
(statearr_45567_47436[(2)] = null);

(statearr_45567_47436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45551 === (3))){
var inst_45547 = (state_45550[(2)]);
var state_45550__$1 = state_45550;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45550__$1,inst_45547);
} else {
if((state_val_45551 === (12))){
var _ = (function (){var statearr_45572 = state_45550;
(statearr_45572[(4)] = cljs.core.rest((state_45550[(4)])));

return statearr_45572;
})();
var state_45550__$1 = state_45550;
var ex45565 = (state_45550__$1[(2)]);
var statearr_45573_47449 = state_45550__$1;
(statearr_45573_47449[(5)] = ex45565);


if((ex45565 instanceof Object)){
var statearr_45574_47455 = state_45550__$1;
(statearr_45574_47455[(1)] = (11));

(statearr_45574_47455[(5)] = null);

} else {
throw ex45565;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45551 === (2))){
var inst_45508 = cljs.core.reset_BANG_(dctr,cnt);
var inst_45509 = cnt;
var inst_45510 = (0);
var state_45550__$1 = (function (){var statearr_45575 = state_45550;
(statearr_45575[(7)] = inst_45510);

(statearr_45575[(11)] = inst_45508);

(statearr_45575[(8)] = inst_45509);

return statearr_45575;
})();
var statearr_45576_47470 = state_45550__$1;
(statearr_45576_47470[(2)] = null);

(statearr_45576_47470[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45551 === (11))){
var inst_45514 = (state_45550[(2)]);
var inst_45515 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_45550__$1 = (function (){var statearr_45577 = state_45550;
(statearr_45577[(12)] = inst_45514);

return statearr_45577;
})();
var statearr_45578_47478 = state_45550__$1;
(statearr_45578_47478[(2)] = inst_45515);

(statearr_45578_47478[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45551 === (9))){
var inst_45510 = (state_45550[(7)]);
var _ = (function (){var statearr_45582 = state_45550;
(statearr_45582[(4)] = cljs.core.cons((12),(state_45550[(4)])));

return statearr_45582;
})();
var inst_45521 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_45510) : chs__$1.call(null,inst_45510));
var inst_45522 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_45510) : done.call(null,inst_45510));
var inst_45523 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_45521,inst_45522);
var ___$1 = (function (){var statearr_45586 = state_45550;
(statearr_45586[(4)] = cljs.core.rest((state_45550[(4)])));

return statearr_45586;
})();
var state_45550__$1 = state_45550;
var statearr_45587_47490 = state_45550__$1;
(statearr_45587_47490[(2)] = inst_45523);

(statearr_45587_47490[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45551 === (5))){
var inst_45533 = (state_45550[(2)]);
var state_45550__$1 = (function (){var statearr_45590 = state_45550;
(statearr_45590[(13)] = inst_45533);

return statearr_45590;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45550__$1,(13),dchan);
} else {
if((state_val_45551 === (14))){
var inst_45538 = cljs.core.async.close_BANG_(out);
var state_45550__$1 = state_45550;
var statearr_45591_47513 = state_45550__$1;
(statearr_45591_47513[(2)] = inst_45538);

(statearr_45591_47513[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45551 === (16))){
var inst_45545 = (state_45550[(2)]);
var state_45550__$1 = state_45550;
var statearr_45598_47522 = state_45550__$1;
(statearr_45598_47522[(2)] = inst_45545);

(statearr_45598_47522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45551 === (10))){
var inst_45510 = (state_45550[(7)]);
var inst_45526 = (state_45550[(2)]);
var inst_45527 = (inst_45510 + (1));
var inst_45510__$1 = inst_45527;
var state_45550__$1 = (function (){var statearr_45599 = state_45550;
(statearr_45599[(7)] = inst_45510__$1);

(statearr_45599[(14)] = inst_45526);

return statearr_45599;
})();
var statearr_45600_47523 = state_45550__$1;
(statearr_45600_47523[(2)] = null);

(statearr_45600_47523[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45551 === (8))){
var inst_45531 = (state_45550[(2)]);
var state_45550__$1 = state_45550;
var statearr_45601_47525 = state_45550__$1;
(statearr_45601_47525[(2)] = inst_45531);

(statearr_45601_47525[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43403__auto__ = null;
var cljs$core$async$state_machine__43403__auto____0 = (function (){
var statearr_45603 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45603[(0)] = cljs$core$async$state_machine__43403__auto__);

(statearr_45603[(1)] = (1));

return statearr_45603;
});
var cljs$core$async$state_machine__43403__auto____1 = (function (state_45550){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_45550);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e45607){var ex__43406__auto__ = e45607;
var statearr_45609_47529 = state_45550;
(statearr_45609_47529[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_45550[(4)]))){
var statearr_45613_47530 = state_45550;
(statearr_45613_47530[(1)] = cljs.core.first((state_45550[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47531 = state_45550;
state_45550 = G__47531;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$state_machine__43403__auto__ = function(state_45550){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43403__auto____1.call(this,state_45550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43403__auto____0;
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43403__auto____1;
return cljs$core$async$state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_45614 = f__43596__auto__();
(statearr_45614[(6)] = c__43595__auto___47421);

return statearr_45614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__45619 = arguments.length;
switch (G__45619) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43595__auto___47540 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_45653){
var state_val_45654 = (state_45653[(1)]);
if((state_val_45654 === (7))){
var inst_45632 = (state_45653[(7)]);
var inst_45633 = (state_45653[(8)]);
var inst_45632__$1 = (state_45653[(2)]);
var inst_45633__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45632__$1,(0),null);
var inst_45634 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45632__$1,(1),null);
var inst_45635 = (inst_45633__$1 == null);
var state_45653__$1 = (function (){var statearr_45655 = state_45653;
(statearr_45655[(7)] = inst_45632__$1);

(statearr_45655[(8)] = inst_45633__$1);

(statearr_45655[(9)] = inst_45634);

return statearr_45655;
})();
if(cljs.core.truth_(inst_45635)){
var statearr_45656_47550 = state_45653__$1;
(statearr_45656_47550[(1)] = (8));

} else {
var statearr_45657_47551 = state_45653__$1;
(statearr_45657_47551[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45654 === (1))){
var inst_45620 = cljs.core.vec(chs);
var inst_45623 = inst_45620;
var state_45653__$1 = (function (){var statearr_45658 = state_45653;
(statearr_45658[(10)] = inst_45623);

return statearr_45658;
})();
var statearr_45659_47556 = state_45653__$1;
(statearr_45659_47556[(2)] = null);

(statearr_45659_47556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45654 === (4))){
var inst_45623 = (state_45653[(10)]);
var state_45653__$1 = state_45653;
return cljs.core.async.ioc_alts_BANG_(state_45653__$1,(7),inst_45623);
} else {
if((state_val_45654 === (6))){
var inst_45649 = (state_45653[(2)]);
var state_45653__$1 = state_45653;
var statearr_45660_47557 = state_45653__$1;
(statearr_45660_47557[(2)] = inst_45649);

(statearr_45660_47557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45654 === (3))){
var inst_45651 = (state_45653[(2)]);
var state_45653__$1 = state_45653;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45653__$1,inst_45651);
} else {
if((state_val_45654 === (2))){
var inst_45623 = (state_45653[(10)]);
var inst_45625 = cljs.core.count(inst_45623);
var inst_45626 = (inst_45625 > (0));
var state_45653__$1 = state_45653;
if(cljs.core.truth_(inst_45626)){
var statearr_45662_47573 = state_45653__$1;
(statearr_45662_47573[(1)] = (4));

} else {
var statearr_45664_47574 = state_45653__$1;
(statearr_45664_47574[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45654 === (11))){
var inst_45623 = (state_45653[(10)]);
var inst_45642 = (state_45653[(2)]);
var tmp45661 = inst_45623;
var inst_45623__$1 = tmp45661;
var state_45653__$1 = (function (){var statearr_45665 = state_45653;
(statearr_45665[(11)] = inst_45642);

(statearr_45665[(10)] = inst_45623__$1);

return statearr_45665;
})();
var statearr_45666_47579 = state_45653__$1;
(statearr_45666_47579[(2)] = null);

(statearr_45666_47579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45654 === (9))){
var inst_45633 = (state_45653[(8)]);
var state_45653__$1 = state_45653;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45653__$1,(11),out,inst_45633);
} else {
if((state_val_45654 === (5))){
var inst_45647 = cljs.core.async.close_BANG_(out);
var state_45653__$1 = state_45653;
var statearr_45667_47587 = state_45653__$1;
(statearr_45667_47587[(2)] = inst_45647);

(statearr_45667_47587[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45654 === (10))){
var inst_45645 = (state_45653[(2)]);
var state_45653__$1 = state_45653;
var statearr_45669_47591 = state_45653__$1;
(statearr_45669_47591[(2)] = inst_45645);

(statearr_45669_47591[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45654 === (8))){
var inst_45623 = (state_45653[(10)]);
var inst_45632 = (state_45653[(7)]);
var inst_45633 = (state_45653[(8)]);
var inst_45634 = (state_45653[(9)]);
var inst_45637 = (function (){var cs = inst_45623;
var vec__45628 = inst_45632;
var v = inst_45633;
var c = inst_45634;
return (function (p1__45617_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__45617_SHARP_);
});
})();
var inst_45638 = cljs.core.filterv(inst_45637,inst_45623);
var inst_45623__$1 = inst_45638;
var state_45653__$1 = (function (){var statearr_45670 = state_45653;
(statearr_45670[(10)] = inst_45623__$1);

return statearr_45670;
})();
var statearr_45671_47592 = state_45653__$1;
(statearr_45671_47592[(2)] = null);

(statearr_45671_47592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43403__auto__ = null;
var cljs$core$async$state_machine__43403__auto____0 = (function (){
var statearr_45672 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45672[(0)] = cljs$core$async$state_machine__43403__auto__);

(statearr_45672[(1)] = (1));

return statearr_45672;
});
var cljs$core$async$state_machine__43403__auto____1 = (function (state_45653){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_45653);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e45673){var ex__43406__auto__ = e45673;
var statearr_45674_47600 = state_45653;
(statearr_45674_47600[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_45653[(4)]))){
var statearr_45675_47601 = state_45653;
(statearr_45675_47601[(1)] = cljs.core.first((state_45653[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47605 = state_45653;
state_45653 = G__47605;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$state_machine__43403__auto__ = function(state_45653){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43403__auto____1.call(this,state_45653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43403__auto____0;
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43403__auto____1;
return cljs$core$async$state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_45676 = f__43596__auto__();
(statearr_45676[(6)] = c__43595__auto___47540);

return statearr_45676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__45678 = arguments.length;
switch (G__45678) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43595__auto___47613 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_45706){
var state_val_45707 = (state_45706[(1)]);
if((state_val_45707 === (7))){
var inst_45687 = (state_45706[(7)]);
var inst_45687__$1 = (state_45706[(2)]);
var inst_45688 = (inst_45687__$1 == null);
var inst_45689 = cljs.core.not(inst_45688);
var state_45706__$1 = (function (){var statearr_45714 = state_45706;
(statearr_45714[(7)] = inst_45687__$1);

return statearr_45714;
})();
if(inst_45689){
var statearr_45715_47621 = state_45706__$1;
(statearr_45715_47621[(1)] = (8));

} else {
var statearr_45716_47622 = state_45706__$1;
(statearr_45716_47622[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45707 === (1))){
var inst_45682 = (0);
var state_45706__$1 = (function (){var statearr_45719 = state_45706;
(statearr_45719[(8)] = inst_45682);

return statearr_45719;
})();
var statearr_45720_47626 = state_45706__$1;
(statearr_45720_47626[(2)] = null);

(statearr_45720_47626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45707 === (4))){
var state_45706__$1 = state_45706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45706__$1,(7),ch);
} else {
if((state_val_45707 === (6))){
var inst_45700 = (state_45706[(2)]);
var state_45706__$1 = state_45706;
var statearr_45721_47628 = state_45706__$1;
(statearr_45721_47628[(2)] = inst_45700);

(statearr_45721_47628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45707 === (3))){
var inst_45702 = (state_45706[(2)]);
var inst_45703 = cljs.core.async.close_BANG_(out);
var state_45706__$1 = (function (){var statearr_45727 = state_45706;
(statearr_45727[(9)] = inst_45702);

return statearr_45727;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45706__$1,inst_45703);
} else {
if((state_val_45707 === (2))){
var inst_45682 = (state_45706[(8)]);
var inst_45684 = (inst_45682 < n);
var state_45706__$1 = state_45706;
if(cljs.core.truth_(inst_45684)){
var statearr_45733_47633 = state_45706__$1;
(statearr_45733_47633[(1)] = (4));

} else {
var statearr_45754_47634 = state_45706__$1;
(statearr_45754_47634[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45707 === (11))){
var inst_45682 = (state_45706[(8)]);
var inst_45692 = (state_45706[(2)]);
var inst_45693 = (inst_45682 + (1));
var inst_45682__$1 = inst_45693;
var state_45706__$1 = (function (){var statearr_45755 = state_45706;
(statearr_45755[(8)] = inst_45682__$1);

(statearr_45755[(10)] = inst_45692);

return statearr_45755;
})();
var statearr_45757_47641 = state_45706__$1;
(statearr_45757_47641[(2)] = null);

(statearr_45757_47641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45707 === (9))){
var state_45706__$1 = state_45706;
var statearr_45758_47645 = state_45706__$1;
(statearr_45758_47645[(2)] = null);

(statearr_45758_47645[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45707 === (5))){
var state_45706__$1 = state_45706;
var statearr_45759_47646 = state_45706__$1;
(statearr_45759_47646[(2)] = null);

(statearr_45759_47646[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45707 === (10))){
var inst_45697 = (state_45706[(2)]);
var state_45706__$1 = state_45706;
var statearr_45760_47647 = state_45706__$1;
(statearr_45760_47647[(2)] = inst_45697);

(statearr_45760_47647[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45707 === (8))){
var inst_45687 = (state_45706[(7)]);
var state_45706__$1 = state_45706;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45706__$1,(11),out,inst_45687);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43403__auto__ = null;
var cljs$core$async$state_machine__43403__auto____0 = (function (){
var statearr_45761 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45761[(0)] = cljs$core$async$state_machine__43403__auto__);

(statearr_45761[(1)] = (1));

return statearr_45761;
});
var cljs$core$async$state_machine__43403__auto____1 = (function (state_45706){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_45706);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e45762){var ex__43406__auto__ = e45762;
var statearr_45763_47648 = state_45706;
(statearr_45763_47648[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_45706[(4)]))){
var statearr_45764_47652 = state_45706;
(statearr_45764_47652[(1)] = cljs.core.first((state_45706[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47653 = state_45706;
state_45706 = G__47653;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$state_machine__43403__auto__ = function(state_45706){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43403__auto____1.call(this,state_45706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43403__auto____0;
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43403__auto____1;
return cljs$core$async$state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_45770 = f__43596__auto__();
(statearr_45770[(6)] = c__43595__auto___47613);

return statearr_45770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45772 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45772 = (function (f,ch,meta45773){
this.f = f;
this.ch = ch;
this.meta45773 = meta45773;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45772.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45774,meta45773__$1){
var self__ = this;
var _45774__$1 = this;
return (new cljs.core.async.t_cljs$core$async45772(self__.f,self__.ch,meta45773__$1));
}));

(cljs.core.async.t_cljs$core$async45772.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45774){
var self__ = this;
var _45774__$1 = this;
return self__.meta45773;
}));

(cljs.core.async.t_cljs$core$async45772.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45772.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45772.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45772.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45772.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45776 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45776 = (function (f,ch,meta45773,_,fn1,meta45777){
this.f = f;
this.ch = ch;
this.meta45773 = meta45773;
this._ = _;
this.fn1 = fn1;
this.meta45777 = meta45777;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45776.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45778,meta45777__$1){
var self__ = this;
var _45778__$1 = this;
return (new cljs.core.async.t_cljs$core$async45776(self__.f,self__.ch,self__.meta45773,self__._,self__.fn1,meta45777__$1));
}));

(cljs.core.async.t_cljs$core$async45776.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45778){
var self__ = this;
var _45778__$1 = this;
return self__.meta45777;
}));

(cljs.core.async.t_cljs$core$async45776.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45776.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async45776.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45776.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__45771_SHARP_){
var G__45780 = (((p1__45771_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__45771_SHARP_) : self__.f.call(null,p1__45771_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__45780) : f1.call(null,G__45780));
});
}));

(cljs.core.async.t_cljs$core$async45776.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45773","meta45773",-1105451075,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async45772","cljs.core.async/t_cljs$core$async45772",-1839162996,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta45777","meta45777",-1274438928,null)], null);
}));

(cljs.core.async.t_cljs$core$async45776.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45776.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45776");

(cljs.core.async.t_cljs$core$async45776.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45776");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45776.
 */
cljs.core.async.__GT_t_cljs$core$async45776 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45776(f__$1,ch__$1,meta45773__$1,___$2,fn1__$1,meta45777){
return (new cljs.core.async.t_cljs$core$async45776(f__$1,ch__$1,meta45773__$1,___$2,fn1__$1,meta45777));
});

}

return (new cljs.core.async.t_cljs$core$async45776(self__.f,self__.ch,self__.meta45773,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__45783 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__45783) : self__.f.call(null,G__45783));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async45772.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45772.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async45772.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45773","meta45773",-1105451075,null)], null);
}));

(cljs.core.async.t_cljs$core$async45772.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45772.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45772");

(cljs.core.async.t_cljs$core$async45772.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45772");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45772.
 */
cljs.core.async.__GT_t_cljs$core$async45772 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45772(f__$1,ch__$1,meta45773){
return (new cljs.core.async.t_cljs$core$async45772(f__$1,ch__$1,meta45773));
});

}

return (new cljs.core.async.t_cljs$core$async45772(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45784 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45784 = (function (f,ch,meta45785){
this.f = f;
this.ch = ch;
this.meta45785 = meta45785;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45784.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45786,meta45785__$1){
var self__ = this;
var _45786__$1 = this;
return (new cljs.core.async.t_cljs$core$async45784(self__.f,self__.ch,meta45785__$1));
}));

(cljs.core.async.t_cljs$core$async45784.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45786){
var self__ = this;
var _45786__$1 = this;
return self__.meta45785;
}));

(cljs.core.async.t_cljs$core$async45784.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45784.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45784.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45784.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45784.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45784.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async45784.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45785","meta45785",-1096883926,null)], null);
}));

(cljs.core.async.t_cljs$core$async45784.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45784.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45784");

(cljs.core.async.t_cljs$core$async45784.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45784");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45784.
 */
cljs.core.async.__GT_t_cljs$core$async45784 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async45784(f__$1,ch__$1,meta45785){
return (new cljs.core.async.t_cljs$core$async45784(f__$1,ch__$1,meta45785));
});

}

return (new cljs.core.async.t_cljs$core$async45784(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45792 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45792 = (function (p,ch,meta45793){
this.p = p;
this.ch = ch;
this.meta45793 = meta45793;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45792.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45794,meta45793__$1){
var self__ = this;
var _45794__$1 = this;
return (new cljs.core.async.t_cljs$core$async45792(self__.p,self__.ch,meta45793__$1));
}));

(cljs.core.async.t_cljs$core$async45792.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45794){
var self__ = this;
var _45794__$1 = this;
return self__.meta45793;
}));

(cljs.core.async.t_cljs$core$async45792.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45792.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45792.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45792.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45792.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45792.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45792.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async45792.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45793","meta45793",-625473561,null)], null);
}));

(cljs.core.async.t_cljs$core$async45792.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45792.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45792");

(cljs.core.async.t_cljs$core$async45792.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45792");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45792.
 */
cljs.core.async.__GT_t_cljs$core$async45792 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async45792(p__$1,ch__$1,meta45793){
return (new cljs.core.async.t_cljs$core$async45792(p__$1,ch__$1,meta45793));
});

}

return (new cljs.core.async.t_cljs$core$async45792(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__45819 = arguments.length;
switch (G__45819) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43595__auto___47745 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_45848){
var state_val_45849 = (state_45848[(1)]);
if((state_val_45849 === (7))){
var inst_45844 = (state_45848[(2)]);
var state_45848__$1 = state_45848;
var statearr_45854_47756 = state_45848__$1;
(statearr_45854_47756[(2)] = inst_45844);

(statearr_45854_47756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45849 === (1))){
var state_45848__$1 = state_45848;
var statearr_45855_47758 = state_45848__$1;
(statearr_45855_47758[(2)] = null);

(statearr_45855_47758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45849 === (4))){
var inst_45824 = (state_45848[(7)]);
var inst_45824__$1 = (state_45848[(2)]);
var inst_45825 = (inst_45824__$1 == null);
var state_45848__$1 = (function (){var statearr_45856 = state_45848;
(statearr_45856[(7)] = inst_45824__$1);

return statearr_45856;
})();
if(cljs.core.truth_(inst_45825)){
var statearr_45857_47765 = state_45848__$1;
(statearr_45857_47765[(1)] = (5));

} else {
var statearr_45858_47770 = state_45848__$1;
(statearr_45858_47770[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45849 === (6))){
var inst_45824 = (state_45848[(7)]);
var inst_45829 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_45824) : p.call(null,inst_45824));
var state_45848__$1 = state_45848;
if(cljs.core.truth_(inst_45829)){
var statearr_45859_47777 = state_45848__$1;
(statearr_45859_47777[(1)] = (8));

} else {
var statearr_45860_47783 = state_45848__$1;
(statearr_45860_47783[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45849 === (3))){
var inst_45846 = (state_45848[(2)]);
var state_45848__$1 = state_45848;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45848__$1,inst_45846);
} else {
if((state_val_45849 === (2))){
var state_45848__$1 = state_45848;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45848__$1,(4),ch);
} else {
if((state_val_45849 === (11))){
var inst_45838 = (state_45848[(2)]);
var state_45848__$1 = state_45848;
var statearr_45863_47793 = state_45848__$1;
(statearr_45863_47793[(2)] = inst_45838);

(statearr_45863_47793[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45849 === (9))){
var state_45848__$1 = state_45848;
var statearr_45864_47794 = state_45848__$1;
(statearr_45864_47794[(2)] = null);

(statearr_45864_47794[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45849 === (5))){
var inst_45827 = cljs.core.async.close_BANG_(out);
var state_45848__$1 = state_45848;
var statearr_45866_47803 = state_45848__$1;
(statearr_45866_47803[(2)] = inst_45827);

(statearr_45866_47803[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45849 === (10))){
var inst_45841 = (state_45848[(2)]);
var state_45848__$1 = (function (){var statearr_45867 = state_45848;
(statearr_45867[(8)] = inst_45841);

return statearr_45867;
})();
var statearr_45868_47805 = state_45848__$1;
(statearr_45868_47805[(2)] = null);

(statearr_45868_47805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45849 === (8))){
var inst_45824 = (state_45848[(7)]);
var state_45848__$1 = state_45848;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45848__$1,(11),out,inst_45824);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43403__auto__ = null;
var cljs$core$async$state_machine__43403__auto____0 = (function (){
var statearr_45869 = [null,null,null,null,null,null,null,null,null];
(statearr_45869[(0)] = cljs$core$async$state_machine__43403__auto__);

(statearr_45869[(1)] = (1));

return statearr_45869;
});
var cljs$core$async$state_machine__43403__auto____1 = (function (state_45848){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_45848);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e45870){var ex__43406__auto__ = e45870;
var statearr_45871_47809 = state_45848;
(statearr_45871_47809[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_45848[(4)]))){
var statearr_45872_47815 = state_45848;
(statearr_45872_47815[(1)] = cljs.core.first((state_45848[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47816 = state_45848;
state_45848 = G__47816;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$state_machine__43403__auto__ = function(state_45848){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43403__auto____1.call(this,state_45848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43403__auto____0;
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43403__auto____1;
return cljs$core$async$state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_45877 = f__43596__auto__();
(statearr_45877[(6)] = c__43595__auto___47745);

return statearr_45877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__45885 = arguments.length;
switch (G__45885) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__43595__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_45956){
var state_val_45957 = (state_45956[(1)]);
if((state_val_45957 === (7))){
var inst_45952 = (state_45956[(2)]);
var state_45956__$1 = state_45956;
var statearr_45958_47828 = state_45956__$1;
(statearr_45958_47828[(2)] = inst_45952);

(statearr_45958_47828[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (20))){
var inst_45920 = (state_45956[(7)]);
var inst_45933 = (state_45956[(2)]);
var inst_45934 = cljs.core.next(inst_45920);
var inst_45906 = inst_45934;
var inst_45907 = null;
var inst_45908 = (0);
var inst_45909 = (0);
var state_45956__$1 = (function (){var statearr_45960 = state_45956;
(statearr_45960[(8)] = inst_45908);

(statearr_45960[(9)] = inst_45907);

(statearr_45960[(10)] = inst_45906);

(statearr_45960[(11)] = inst_45933);

(statearr_45960[(12)] = inst_45909);

return statearr_45960;
})();
var statearr_45961_47830 = state_45956__$1;
(statearr_45961_47830[(2)] = null);

(statearr_45961_47830[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (1))){
var state_45956__$1 = state_45956;
var statearr_45963_47831 = state_45956__$1;
(statearr_45963_47831[(2)] = null);

(statearr_45963_47831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (4))){
var inst_45895 = (state_45956[(13)]);
var inst_45895__$1 = (state_45956[(2)]);
var inst_45896 = (inst_45895__$1 == null);
var state_45956__$1 = (function (){var statearr_45964 = state_45956;
(statearr_45964[(13)] = inst_45895__$1);

return statearr_45964;
})();
if(cljs.core.truth_(inst_45896)){
var statearr_45965_47834 = state_45956__$1;
(statearr_45965_47834[(1)] = (5));

} else {
var statearr_45966_47835 = state_45956__$1;
(statearr_45966_47835[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (15))){
var state_45956__$1 = state_45956;
var statearr_45974_47837 = state_45956__$1;
(statearr_45974_47837[(2)] = null);

(statearr_45974_47837[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (21))){
var state_45956__$1 = state_45956;
var statearr_45975_47840 = state_45956__$1;
(statearr_45975_47840[(2)] = null);

(statearr_45975_47840[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (13))){
var inst_45908 = (state_45956[(8)]);
var inst_45907 = (state_45956[(9)]);
var inst_45906 = (state_45956[(10)]);
var inst_45909 = (state_45956[(12)]);
var inst_45916 = (state_45956[(2)]);
var inst_45917 = (inst_45909 + (1));
var tmp45967 = inst_45908;
var tmp45968 = inst_45907;
var tmp45969 = inst_45906;
var inst_45906__$1 = tmp45969;
var inst_45907__$1 = tmp45968;
var inst_45908__$1 = tmp45967;
var inst_45909__$1 = inst_45917;
var state_45956__$1 = (function (){var statearr_45983 = state_45956;
(statearr_45983[(8)] = inst_45908__$1);

(statearr_45983[(9)] = inst_45907__$1);

(statearr_45983[(10)] = inst_45906__$1);

(statearr_45983[(14)] = inst_45916);

(statearr_45983[(12)] = inst_45909__$1);

return statearr_45983;
})();
var statearr_45984_47845 = state_45956__$1;
(statearr_45984_47845[(2)] = null);

(statearr_45984_47845[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (22))){
var state_45956__$1 = state_45956;
var statearr_45985_47846 = state_45956__$1;
(statearr_45985_47846[(2)] = null);

(statearr_45985_47846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (6))){
var inst_45895 = (state_45956[(13)]);
var inst_45904 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_45895) : f.call(null,inst_45895));
var inst_45905 = cljs.core.seq(inst_45904);
var inst_45906 = inst_45905;
var inst_45907 = null;
var inst_45908 = (0);
var inst_45909 = (0);
var state_45956__$1 = (function (){var statearr_45991 = state_45956;
(statearr_45991[(8)] = inst_45908);

(statearr_45991[(9)] = inst_45907);

(statearr_45991[(10)] = inst_45906);

(statearr_45991[(12)] = inst_45909);

return statearr_45991;
})();
var statearr_45992_47847 = state_45956__$1;
(statearr_45992_47847[(2)] = null);

(statearr_45992_47847[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (17))){
var inst_45920 = (state_45956[(7)]);
var inst_45926 = cljs.core.chunk_first(inst_45920);
var inst_45927 = cljs.core.chunk_rest(inst_45920);
var inst_45928 = cljs.core.count(inst_45926);
var inst_45906 = inst_45927;
var inst_45907 = inst_45926;
var inst_45908 = inst_45928;
var inst_45909 = (0);
var state_45956__$1 = (function (){var statearr_45993 = state_45956;
(statearr_45993[(8)] = inst_45908);

(statearr_45993[(9)] = inst_45907);

(statearr_45993[(10)] = inst_45906);

(statearr_45993[(12)] = inst_45909);

return statearr_45993;
})();
var statearr_45994_47849 = state_45956__$1;
(statearr_45994_47849[(2)] = null);

(statearr_45994_47849[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (3))){
var inst_45954 = (state_45956[(2)]);
var state_45956__$1 = state_45956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45956__$1,inst_45954);
} else {
if((state_val_45957 === (12))){
var inst_45942 = (state_45956[(2)]);
var state_45956__$1 = state_45956;
var statearr_45996_47851 = state_45956__$1;
(statearr_45996_47851[(2)] = inst_45942);

(statearr_45996_47851[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (2))){
var state_45956__$1 = state_45956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45956__$1,(4),in$);
} else {
if((state_val_45957 === (23))){
var inst_45950 = (state_45956[(2)]);
var state_45956__$1 = state_45956;
var statearr_45997_47853 = state_45956__$1;
(statearr_45997_47853[(2)] = inst_45950);

(statearr_45997_47853[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (19))){
var inst_45937 = (state_45956[(2)]);
var state_45956__$1 = state_45956;
var statearr_45998_47854 = state_45956__$1;
(statearr_45998_47854[(2)] = inst_45937);

(statearr_45998_47854[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (11))){
var inst_45920 = (state_45956[(7)]);
var inst_45906 = (state_45956[(10)]);
var inst_45920__$1 = cljs.core.seq(inst_45906);
var state_45956__$1 = (function (){var statearr_45999 = state_45956;
(statearr_45999[(7)] = inst_45920__$1);

return statearr_45999;
})();
if(inst_45920__$1){
var statearr_46000_47855 = state_45956__$1;
(statearr_46000_47855[(1)] = (14));

} else {
var statearr_46001_47856 = state_45956__$1;
(statearr_46001_47856[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (9))){
var inst_45944 = (state_45956[(2)]);
var inst_45945 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_45956__$1 = (function (){var statearr_46004 = state_45956;
(statearr_46004[(15)] = inst_45944);

return statearr_46004;
})();
if(cljs.core.truth_(inst_45945)){
var statearr_46005_47858 = state_45956__$1;
(statearr_46005_47858[(1)] = (21));

} else {
var statearr_46006_47859 = state_45956__$1;
(statearr_46006_47859[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (5))){
var inst_45898 = cljs.core.async.close_BANG_(out);
var state_45956__$1 = state_45956;
var statearr_46007_47864 = state_45956__$1;
(statearr_46007_47864[(2)] = inst_45898);

(statearr_46007_47864[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (14))){
var inst_45920 = (state_45956[(7)]);
var inst_45924 = cljs.core.chunked_seq_QMARK_(inst_45920);
var state_45956__$1 = state_45956;
if(inst_45924){
var statearr_46008_47866 = state_45956__$1;
(statearr_46008_47866[(1)] = (17));

} else {
var statearr_46009_47867 = state_45956__$1;
(statearr_46009_47867[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (16))){
var inst_45940 = (state_45956[(2)]);
var state_45956__$1 = state_45956;
var statearr_46010_47868 = state_45956__$1;
(statearr_46010_47868[(2)] = inst_45940);

(statearr_46010_47868[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (10))){
var inst_45907 = (state_45956[(9)]);
var inst_45909 = (state_45956[(12)]);
var inst_45914 = cljs.core._nth(inst_45907,inst_45909);
var state_45956__$1 = state_45956;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45956__$1,(13),out,inst_45914);
} else {
if((state_val_45957 === (18))){
var inst_45920 = (state_45956[(7)]);
var inst_45931 = cljs.core.first(inst_45920);
var state_45956__$1 = state_45956;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45956__$1,(20),out,inst_45931);
} else {
if((state_val_45957 === (8))){
var inst_45908 = (state_45956[(8)]);
var inst_45909 = (state_45956[(12)]);
var inst_45911 = (inst_45909 < inst_45908);
var inst_45912 = inst_45911;
var state_45956__$1 = state_45956;
if(cljs.core.truth_(inst_45912)){
var statearr_46011_47870 = state_45956__$1;
(statearr_46011_47870[(1)] = (10));

} else {
var statearr_46012_47871 = state_45956__$1;
(statearr_46012_47871[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__43403__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__43403__auto____0 = (function (){
var statearr_46013 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46013[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__43403__auto__);

(statearr_46013[(1)] = (1));

return statearr_46013;
});
var cljs$core$async$mapcat_STAR__$_state_machine__43403__auto____1 = (function (state_45956){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_45956);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e46014){var ex__43406__auto__ = e46014;
var statearr_46015_47873 = state_45956;
(statearr_46015_47873[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_45956[(4)]))){
var statearr_46016_47874 = state_45956;
(statearr_46016_47874[(1)] = cljs.core.first((state_45956[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47876 = state_45956;
state_45956 = G__47876;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__43403__auto__ = function(state_45956){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__43403__auto____1.call(this,state_45956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__43403__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__43403__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_46017 = f__43596__auto__();
(statearr_46017[(6)] = c__43595__auto__);

return statearr_46017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));

return c__43595__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__46019 = arguments.length;
switch (G__46019) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__46025 = arguments.length;
switch (G__46025) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__46039 = arguments.length;
switch (G__46039) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43595__auto___47898 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_46065){
var state_val_46066 = (state_46065[(1)]);
if((state_val_46066 === (7))){
var inst_46058 = (state_46065[(2)]);
var state_46065__$1 = state_46065;
var statearr_46071_47899 = state_46065__$1;
(statearr_46071_47899[(2)] = inst_46058);

(statearr_46071_47899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46066 === (1))){
var inst_46040 = null;
var state_46065__$1 = (function (){var statearr_46072 = state_46065;
(statearr_46072[(7)] = inst_46040);

return statearr_46072;
})();
var statearr_46073_47903 = state_46065__$1;
(statearr_46073_47903[(2)] = null);

(statearr_46073_47903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46066 === (4))){
var inst_46043 = (state_46065[(8)]);
var inst_46043__$1 = (state_46065[(2)]);
var inst_46044 = (inst_46043__$1 == null);
var inst_46045 = cljs.core.not(inst_46044);
var state_46065__$1 = (function (){var statearr_46074 = state_46065;
(statearr_46074[(8)] = inst_46043__$1);

return statearr_46074;
})();
if(inst_46045){
var statearr_46075_47907 = state_46065__$1;
(statearr_46075_47907[(1)] = (5));

} else {
var statearr_46076_47908 = state_46065__$1;
(statearr_46076_47908[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46066 === (6))){
var state_46065__$1 = state_46065;
var statearr_46077_47909 = state_46065__$1;
(statearr_46077_47909[(2)] = null);

(statearr_46077_47909[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46066 === (3))){
var inst_46060 = (state_46065[(2)]);
var inst_46061 = cljs.core.async.close_BANG_(out);
var state_46065__$1 = (function (){var statearr_46078 = state_46065;
(statearr_46078[(9)] = inst_46060);

return statearr_46078;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46065__$1,inst_46061);
} else {
if((state_val_46066 === (2))){
var state_46065__$1 = state_46065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46065__$1,(4),ch);
} else {
if((state_val_46066 === (11))){
var inst_46043 = (state_46065[(8)]);
var inst_46052 = (state_46065[(2)]);
var inst_46040 = inst_46043;
var state_46065__$1 = (function (){var statearr_46079 = state_46065;
(statearr_46079[(10)] = inst_46052);

(statearr_46079[(7)] = inst_46040);

return statearr_46079;
})();
var statearr_46080_47914 = state_46065__$1;
(statearr_46080_47914[(2)] = null);

(statearr_46080_47914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46066 === (9))){
var inst_46043 = (state_46065[(8)]);
var state_46065__$1 = state_46065;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46065__$1,(11),out,inst_46043);
} else {
if((state_val_46066 === (5))){
var inst_46040 = (state_46065[(7)]);
var inst_46043 = (state_46065[(8)]);
var inst_46047 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46043,inst_46040);
var state_46065__$1 = state_46065;
if(inst_46047){
var statearr_46082_47916 = state_46065__$1;
(statearr_46082_47916[(1)] = (8));

} else {
var statearr_46083_47917 = state_46065__$1;
(statearr_46083_47917[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46066 === (10))){
var inst_46055 = (state_46065[(2)]);
var state_46065__$1 = state_46065;
var statearr_46084_47921 = state_46065__$1;
(statearr_46084_47921[(2)] = inst_46055);

(statearr_46084_47921[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46066 === (8))){
var inst_46040 = (state_46065[(7)]);
var tmp46081 = inst_46040;
var inst_46040__$1 = tmp46081;
var state_46065__$1 = (function (){var statearr_46085 = state_46065;
(statearr_46085[(7)] = inst_46040__$1);

return statearr_46085;
})();
var statearr_46086_47922 = state_46065__$1;
(statearr_46086_47922[(2)] = null);

(statearr_46086_47922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43403__auto__ = null;
var cljs$core$async$state_machine__43403__auto____0 = (function (){
var statearr_46087 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46087[(0)] = cljs$core$async$state_machine__43403__auto__);

(statearr_46087[(1)] = (1));

return statearr_46087;
});
var cljs$core$async$state_machine__43403__auto____1 = (function (state_46065){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_46065);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e46088){var ex__43406__auto__ = e46088;
var statearr_46089_47930 = state_46065;
(statearr_46089_47930[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_46065[(4)]))){
var statearr_46096_47933 = state_46065;
(statearr_46096_47933[(1)] = cljs.core.first((state_46065[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47934 = state_46065;
state_46065 = G__47934;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$state_machine__43403__auto__ = function(state_46065){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43403__auto____1.call(this,state_46065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43403__auto____0;
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43403__auto____1;
return cljs$core$async$state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_46097 = f__43596__auto__();
(statearr_46097[(6)] = c__43595__auto___47898);

return statearr_46097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__46099 = arguments.length;
switch (G__46099) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43595__auto___47942 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_46141){
var state_val_46142 = (state_46141[(1)]);
if((state_val_46142 === (7))){
var inst_46137 = (state_46141[(2)]);
var state_46141__$1 = state_46141;
var statearr_46143_47946 = state_46141__$1;
(statearr_46143_47946[(2)] = inst_46137);

(statearr_46143_47946[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46142 === (1))){
var inst_46100 = (new Array(n));
var inst_46101 = inst_46100;
var inst_46102 = (0);
var state_46141__$1 = (function (){var statearr_46144 = state_46141;
(statearr_46144[(7)] = inst_46102);

(statearr_46144[(8)] = inst_46101);

return statearr_46144;
})();
var statearr_46145_47956 = state_46141__$1;
(statearr_46145_47956[(2)] = null);

(statearr_46145_47956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46142 === (4))){
var inst_46107 = (state_46141[(9)]);
var inst_46107__$1 = (state_46141[(2)]);
var inst_46108 = (inst_46107__$1 == null);
var inst_46109 = cljs.core.not(inst_46108);
var state_46141__$1 = (function (){var statearr_46146 = state_46141;
(statearr_46146[(9)] = inst_46107__$1);

return statearr_46146;
})();
if(inst_46109){
var statearr_46147_47964 = state_46141__$1;
(statearr_46147_47964[(1)] = (5));

} else {
var statearr_46148_47965 = state_46141__$1;
(statearr_46148_47965[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46142 === (15))){
var inst_46131 = (state_46141[(2)]);
var state_46141__$1 = state_46141;
var statearr_46149_47966 = state_46141__$1;
(statearr_46149_47966[(2)] = inst_46131);

(statearr_46149_47966[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46142 === (13))){
var state_46141__$1 = state_46141;
var statearr_46150_47971 = state_46141__$1;
(statearr_46150_47971[(2)] = null);

(statearr_46150_47971[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46142 === (6))){
var inst_46102 = (state_46141[(7)]);
var inst_46127 = (inst_46102 > (0));
var state_46141__$1 = state_46141;
if(cljs.core.truth_(inst_46127)){
var statearr_46151_47974 = state_46141__$1;
(statearr_46151_47974[(1)] = (12));

} else {
var statearr_46152_47979 = state_46141__$1;
(statearr_46152_47979[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46142 === (3))){
var inst_46139 = (state_46141[(2)]);
var state_46141__$1 = state_46141;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46141__$1,inst_46139);
} else {
if((state_val_46142 === (12))){
var inst_46101 = (state_46141[(8)]);
var inst_46129 = cljs.core.vec(inst_46101);
var state_46141__$1 = state_46141;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46141__$1,(15),out,inst_46129);
} else {
if((state_val_46142 === (2))){
var state_46141__$1 = state_46141;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46141__$1,(4),ch);
} else {
if((state_val_46142 === (11))){
var inst_46121 = (state_46141[(2)]);
var inst_46122 = (new Array(n));
var inst_46101 = inst_46122;
var inst_46102 = (0);
var state_46141__$1 = (function (){var statearr_46154 = state_46141;
(statearr_46154[(10)] = inst_46121);

(statearr_46154[(7)] = inst_46102);

(statearr_46154[(8)] = inst_46101);

return statearr_46154;
})();
var statearr_46155_48001 = state_46141__$1;
(statearr_46155_48001[(2)] = null);

(statearr_46155_48001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46142 === (9))){
var inst_46101 = (state_46141[(8)]);
var inst_46119 = cljs.core.vec(inst_46101);
var state_46141__$1 = state_46141;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46141__$1,(11),out,inst_46119);
} else {
if((state_val_46142 === (5))){
var inst_46107 = (state_46141[(9)]);
var inst_46102 = (state_46141[(7)]);
var inst_46114 = (state_46141[(11)]);
var inst_46101 = (state_46141[(8)]);
var inst_46113 = (inst_46101[inst_46102] = inst_46107);
var inst_46114__$1 = (inst_46102 + (1));
var inst_46115 = (inst_46114__$1 < n);
var state_46141__$1 = (function (){var statearr_46156 = state_46141;
(statearr_46156[(12)] = inst_46113);

(statearr_46156[(11)] = inst_46114__$1);

return statearr_46156;
})();
if(cljs.core.truth_(inst_46115)){
var statearr_46157_48003 = state_46141__$1;
(statearr_46157_48003[(1)] = (8));

} else {
var statearr_46158_48004 = state_46141__$1;
(statearr_46158_48004[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46142 === (14))){
var inst_46134 = (state_46141[(2)]);
var inst_46135 = cljs.core.async.close_BANG_(out);
var state_46141__$1 = (function (){var statearr_46160 = state_46141;
(statearr_46160[(13)] = inst_46134);

return statearr_46160;
})();
var statearr_46161_48005 = state_46141__$1;
(statearr_46161_48005[(2)] = inst_46135);

(statearr_46161_48005[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46142 === (10))){
var inst_46125 = (state_46141[(2)]);
var state_46141__$1 = state_46141;
var statearr_46162_48009 = state_46141__$1;
(statearr_46162_48009[(2)] = inst_46125);

(statearr_46162_48009[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46142 === (8))){
var inst_46114 = (state_46141[(11)]);
var inst_46101 = (state_46141[(8)]);
var tmp46159 = inst_46101;
var inst_46101__$1 = tmp46159;
var inst_46102 = inst_46114;
var state_46141__$1 = (function (){var statearr_46163 = state_46141;
(statearr_46163[(7)] = inst_46102);

(statearr_46163[(8)] = inst_46101__$1);

return statearr_46163;
})();
var statearr_46165_48011 = state_46141__$1;
(statearr_46165_48011[(2)] = null);

(statearr_46165_48011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43403__auto__ = null;
var cljs$core$async$state_machine__43403__auto____0 = (function (){
var statearr_46166 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46166[(0)] = cljs$core$async$state_machine__43403__auto__);

(statearr_46166[(1)] = (1));

return statearr_46166;
});
var cljs$core$async$state_machine__43403__auto____1 = (function (state_46141){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_46141);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e46167){var ex__43406__auto__ = e46167;
var statearr_46168_48012 = state_46141;
(statearr_46168_48012[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_46141[(4)]))){
var statearr_46169_48013 = state_46141;
(statearr_46169_48013[(1)] = cljs.core.first((state_46141[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48014 = state_46141;
state_46141 = G__48014;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$state_machine__43403__auto__ = function(state_46141){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43403__auto____1.call(this,state_46141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43403__auto____0;
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43403__auto____1;
return cljs$core$async$state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_46170 = f__43596__auto__();
(statearr_46170[(6)] = c__43595__auto___47942);

return statearr_46170;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__46172 = arguments.length;
switch (G__46172) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43595__auto___48018 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_46215){
var state_val_46216 = (state_46215[(1)]);
if((state_val_46216 === (7))){
var inst_46211 = (state_46215[(2)]);
var state_46215__$1 = state_46215;
var statearr_46218_48020 = state_46215__$1;
(statearr_46218_48020[(2)] = inst_46211);

(statearr_46218_48020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46216 === (1))){
var inst_46174 = [];
var inst_46175 = inst_46174;
var inst_46176 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_46215__$1 = (function (){var statearr_46220 = state_46215;
(statearr_46220[(7)] = inst_46176);

(statearr_46220[(8)] = inst_46175);

return statearr_46220;
})();
var statearr_46221_48022 = state_46215__$1;
(statearr_46221_48022[(2)] = null);

(statearr_46221_48022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46216 === (4))){
var inst_46179 = (state_46215[(9)]);
var inst_46179__$1 = (state_46215[(2)]);
var inst_46180 = (inst_46179__$1 == null);
var inst_46181 = cljs.core.not(inst_46180);
var state_46215__$1 = (function (){var statearr_46222 = state_46215;
(statearr_46222[(9)] = inst_46179__$1);

return statearr_46222;
})();
if(inst_46181){
var statearr_46223_48029 = state_46215__$1;
(statearr_46223_48029[(1)] = (5));

} else {
var statearr_46224_48030 = state_46215__$1;
(statearr_46224_48030[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46216 === (15))){
var inst_46205 = (state_46215[(2)]);
var state_46215__$1 = state_46215;
var statearr_46225_48032 = state_46215__$1;
(statearr_46225_48032[(2)] = inst_46205);

(statearr_46225_48032[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46216 === (13))){
var state_46215__$1 = state_46215;
var statearr_46226_48035 = state_46215__$1;
(statearr_46226_48035[(2)] = null);

(statearr_46226_48035[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46216 === (6))){
var inst_46175 = (state_46215[(8)]);
var inst_46200 = inst_46175.length;
var inst_46201 = (inst_46200 > (0));
var state_46215__$1 = state_46215;
if(cljs.core.truth_(inst_46201)){
var statearr_46227_48037 = state_46215__$1;
(statearr_46227_48037[(1)] = (12));

} else {
var statearr_46228_48038 = state_46215__$1;
(statearr_46228_48038[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46216 === (3))){
var inst_46213 = (state_46215[(2)]);
var state_46215__$1 = state_46215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46215__$1,inst_46213);
} else {
if((state_val_46216 === (12))){
var inst_46175 = (state_46215[(8)]);
var inst_46203 = cljs.core.vec(inst_46175);
var state_46215__$1 = state_46215;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46215__$1,(15),out,inst_46203);
} else {
if((state_val_46216 === (2))){
var state_46215__$1 = state_46215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46215__$1,(4),ch);
} else {
if((state_val_46216 === (11))){
var inst_46183 = (state_46215[(10)]);
var inst_46179 = (state_46215[(9)]);
var inst_46193 = (state_46215[(2)]);
var inst_46194 = [];
var inst_46195 = inst_46194.push(inst_46179);
var inst_46175 = inst_46194;
var inst_46176 = inst_46183;
var state_46215__$1 = (function (){var statearr_46229 = state_46215;
(statearr_46229[(11)] = inst_46195);

(statearr_46229[(12)] = inst_46193);

(statearr_46229[(7)] = inst_46176);

(statearr_46229[(8)] = inst_46175);

return statearr_46229;
})();
var statearr_46230_48040 = state_46215__$1;
(statearr_46230_48040[(2)] = null);

(statearr_46230_48040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46216 === (9))){
var inst_46175 = (state_46215[(8)]);
var inst_46191 = cljs.core.vec(inst_46175);
var state_46215__$1 = state_46215;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46215__$1,(11),out,inst_46191);
} else {
if((state_val_46216 === (5))){
var inst_46183 = (state_46215[(10)]);
var inst_46179 = (state_46215[(9)]);
var inst_46176 = (state_46215[(7)]);
var inst_46183__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_46179) : f.call(null,inst_46179));
var inst_46184 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46183__$1,inst_46176);
var inst_46185 = cljs.core.keyword_identical_QMARK_(inst_46176,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_46186 = ((inst_46184) || (inst_46185));
var state_46215__$1 = (function (){var statearr_46234 = state_46215;
(statearr_46234[(10)] = inst_46183__$1);

return statearr_46234;
})();
if(cljs.core.truth_(inst_46186)){
var statearr_46237_48044 = state_46215__$1;
(statearr_46237_48044[(1)] = (8));

} else {
var statearr_46238_48045 = state_46215__$1;
(statearr_46238_48045[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46216 === (14))){
var inst_46208 = (state_46215[(2)]);
var inst_46209 = cljs.core.async.close_BANG_(out);
var state_46215__$1 = (function (){var statearr_46240 = state_46215;
(statearr_46240[(13)] = inst_46208);

return statearr_46240;
})();
var statearr_46242_48046 = state_46215__$1;
(statearr_46242_48046[(2)] = inst_46209);

(statearr_46242_48046[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46216 === (10))){
var inst_46198 = (state_46215[(2)]);
var state_46215__$1 = state_46215;
var statearr_46244_48047 = state_46215__$1;
(statearr_46244_48047[(2)] = inst_46198);

(statearr_46244_48047[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46216 === (8))){
var inst_46183 = (state_46215[(10)]);
var inst_46179 = (state_46215[(9)]);
var inst_46175 = (state_46215[(8)]);
var inst_46188 = inst_46175.push(inst_46179);
var tmp46239 = inst_46175;
var inst_46175__$1 = tmp46239;
var inst_46176 = inst_46183;
var state_46215__$1 = (function (){var statearr_46245 = state_46215;
(statearr_46245[(7)] = inst_46176);

(statearr_46245[(14)] = inst_46188);

(statearr_46245[(8)] = inst_46175__$1);

return statearr_46245;
})();
var statearr_46246_48052 = state_46215__$1;
(statearr_46246_48052[(2)] = null);

(statearr_46246_48052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43403__auto__ = null;
var cljs$core$async$state_machine__43403__auto____0 = (function (){
var statearr_46247 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46247[(0)] = cljs$core$async$state_machine__43403__auto__);

(statearr_46247[(1)] = (1));

return statearr_46247;
});
var cljs$core$async$state_machine__43403__auto____1 = (function (state_46215){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_46215);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e46248){var ex__43406__auto__ = e46248;
var statearr_46249_48058 = state_46215;
(statearr_46249_48058[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_46215[(4)]))){
var statearr_46250_48062 = state_46215;
(statearr_46250_48062[(1)] = cljs.core.first((state_46215[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48068 = state_46215;
state_46215 = G__48068;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs$core$async$state_machine__43403__auto__ = function(state_46215){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43403__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43403__auto____1.call(this,state_46215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43403__auto____0;
cljs$core$async$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43403__auto____1;
return cljs$core$async$state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_46257 = f__43596__auto__();
(statearr_46257[(6)] = c__43595__auto___48018);

return statearr_46257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
