goog.provide('cljs_http.core');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5720__auto__ = (function (){var fexpr__53294 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__53294.cljs$core$IFn$_invoke$arity$1 ? fexpr__53294.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__53294.call(null,channel));
})();
if(cljs.core.truth_(temp__5720__auto__)){
var req = temp__5720__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return new cljs.core.Keyword(null,"jsonp","jsonp",226119588).cljs$core$IFn$_invoke$arity$1(req).cancel(new cljs.core.Keyword(null,"request","request",1772954723).cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__53300){
var vec__53302 = p__53300;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53302,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53302,(1),null);
return xhr.headers.set(k,v);
}),formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__53305 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"array-buffer","array-buffer",519008380),G__53305)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"blob","blob",1636965233),G__53305)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"document","document",-1329188687),G__53305)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),G__53305)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"default","default",-1987822328),G__53305)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__53305)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__53305)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__53307){
var map__53308 = p__53307;
var map__53308__$1 = (((((!((map__53308 == null))))?(((((map__53308.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53308.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53308):map__53308);
var request = map__53308__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53308__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53308__$1,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094));
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53308__$1,new cljs.core.Keyword(null,"response-type","response-type",-1493770458));
var timeout = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"timeout","timeout",-318625318).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__53311 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__53311,default_headers);

cljs_http.core.apply_response_type_BANG_(G__53311,response_type);

G__53311.setTimeoutInterval(timeout);

G__53311.setWithCredentials(send_credentials);

return G__53311;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[new cljs.core.Keyword(null,"no-error","no-error",1984610064),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"access-denied","access-denied",959449406),new cljs.core.Keyword(null,"custom-error","custom-error",-1565161123),new cljs.core.Keyword(null,"http-error","http-error",-1040049553),new cljs.core.Keyword(null,"ff-silent-error","ff-silent-error",189390514),new cljs.core.Keyword(null,"file-not-found","file-not-found",-65398940),new cljs.core.Keyword(null,"offline","offline",-107631935),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"timeout","timeout",-318625318)]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__53317){
var map__53318 = p__53317;
var map__53318__$1 = (((((!((map__53318 == null))))?(((((map__53318.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53318.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53318):map__53318);
var request = map__53318__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53318__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53318__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53318__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53318__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53318__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53318__$1,new cljs.core.Keyword(null,"progress","progress",244323547));
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__4126__auto__ = request_method;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"get","get",1683182755);
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,(function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"status","status",-1997798413),target.getStatus(),new cljs.core.Keyword(null,"success","success",1890645906),target.isSuccess(),new cljs.core.Keyword(null,"body","body",-2049205669),target.getResponse(),new cljs.core.Keyword(null,"headers","headers",-835030129),cljs_http.util.parse_headers(target.getAllResponseHeaders()),new cljs.core.Keyword(null,"trace-redirects","trace-redirects",-1149427907),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),new cljs.core.Keyword(null,"error-code","error-code",180497232),(function (){var G__53332 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__53332) : cljs_http.core.error_kw.call(null,G__53332));
})(),new cljs.core.Keyword(null,"error-text","error-text",2021893718),target.getLastError()], null);
if((!(cljs_http.core.aborted_QMARK_(xhr)))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));

if(cljs.core.truth_(progress)){
var listener_53377 = (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"direction","direction",-633359395),direction,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"total","total",1916810418),evt.total], null):null)], 0)));
});
var G__53334_53378 = xhr;
G__53334_53378.setProgressEventsEnabled(true);

G__53334_53378.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_53377,new cljs.core.Keyword(null,"upload","upload",-255769218)));

G__53334_53378.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_53377,new cljs.core.Keyword(null,"download","download",-300081668)));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__43595__auto___53379 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_53345){
var state_val_53346 = (state_53345[(1)]);
if((state_val_53346 === (1))){
var state_53345__$1 = state_53345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53345__$1,(2),cancel);
} else {
if((state_val_53346 === (2))){
var inst_53336 = (state_53345[(2)]);
var inst_53337 = xhr.isComplete();
var inst_53338 = cljs.core.not(inst_53337);
var state_53345__$1 = (function (){var statearr_53347 = state_53345;
(statearr_53347[(7)] = inst_53336);

return statearr_53347;
})();
if(inst_53338){
var statearr_53348_53380 = state_53345__$1;
(statearr_53348_53380[(1)] = (3));

} else {
var statearr_53349_53381 = state_53345__$1;
(statearr_53349_53381[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (3))){
var inst_53340 = xhr.abort();
var state_53345__$1 = state_53345;
var statearr_53350_53382 = state_53345__$1;
(statearr_53350_53382[(2)] = inst_53340);

(statearr_53350_53382[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (4))){
var state_53345__$1 = state_53345;
var statearr_53351_53383 = state_53345__$1;
(statearr_53351_53383[(2)] = null);

(statearr_53351_53383[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (5))){
var inst_53343 = (state_53345[(2)]);
var state_53345__$1 = state_53345;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53345__$1,inst_53343);
} else {
return null;
}
}
}
}
}
});
return (function() {
var cljs_http$core$xhr_$_state_machine__43403__auto__ = null;
var cljs_http$core$xhr_$_state_machine__43403__auto____0 = (function (){
var statearr_53352 = [null,null,null,null,null,null,null,null];
(statearr_53352[(0)] = cljs_http$core$xhr_$_state_machine__43403__auto__);

(statearr_53352[(1)] = (1));

return statearr_53352;
});
var cljs_http$core$xhr_$_state_machine__43403__auto____1 = (function (state_53345){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_53345);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e53354){var ex__43406__auto__ = e53354;
var statearr_53355_53384 = state_53345;
(statearr_53355_53384[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_53345[(4)]))){
var statearr_53356_53385 = state_53345;
(statearr_53356_53385[(1)] = cljs.core.first((state_53345[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53386 = state_53345;
state_53345 = G__53386;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__43403__auto__ = function(state_53345){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__43403__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__43403__auto____1.call(this,state_53345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__43403__auto____0;
cljs_http$core$xhr_$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__43403__auto____1;
return cljs_http$core$xhr_$_state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_53357 = f__43596__auto__();
(statearr_53357[(6)] = c__43595__auto___53379);

return statearr_53357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__53358){
var map__53359 = p__53358;
var map__53359__$1 = (((((!((map__53359 == null))))?(((((map__53359.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53359.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53359):map__53359);
var request = map__53359__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53359__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318));
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53359__$1,new cljs.core.Keyword(null,"callback-name","callback-name",336964714));
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53359__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__53359__$1,new cljs.core.Keyword(null,"keywordize-keys?","keywordize-keys?",-254545987),true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_53387 = jsonp.send(null,(function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"success","success",1890645906),true,new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}),(function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"jsonp","jsonp",226119588),jsonp,new cljs.core.Keyword(null,"request","request",1772954723),req_53387], null));

if(cljs.core.truth_(cancel)){
var c__43595__auto___53388 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_53365){
var state_val_53366 = (state_53365[(1)]);
if((state_val_53366 === (1))){
var state_53365__$1 = state_53365;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53365__$1,(2),cancel);
} else {
if((state_val_53366 === (2))){
var inst_53362 = (state_53365[(2)]);
var inst_53363 = jsonp.cancel(req_53387);
var state_53365__$1 = (function (){var statearr_53367 = state_53365;
(statearr_53367[(7)] = inst_53362);

return statearr_53367;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_53365__$1,inst_53363);
} else {
return null;
}
}
});
return (function() {
var cljs_http$core$jsonp_$_state_machine__43403__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__43403__auto____0 = (function (){
var statearr_53368 = [null,null,null,null,null,null,null,null];
(statearr_53368[(0)] = cljs_http$core$jsonp_$_state_machine__43403__auto__);

(statearr_53368[(1)] = (1));

return statearr_53368;
});
var cljs_http$core$jsonp_$_state_machine__43403__auto____1 = (function (state_53365){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_53365);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e53369){var ex__43406__auto__ = e53369;
var statearr_53370_53391 = state_53365;
(statearr_53370_53391[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_53365[(4)]))){
var statearr_53371_53392 = state_53365;
(statearr_53371_53392[(1)] = cljs.core.first((state_53365[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53393 = state_53365;
state_53365 = G__53393;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__43403__auto__ = function(state_53365){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__43403__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__43403__auto____1.call(this,state_53365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__43403__auto____0;
cljs_http$core$jsonp_$_state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__43403__auto____1;
return cljs_http$core$jsonp_$_state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_53372 = f__43596__auto__();
(statearr_53372[(6)] = c__43595__auto___53388);

return statearr_53372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__53373){
var map__53374 = p__53373;
var map__53374__$1 = (((((!((map__53374 == null))))?(((((map__53374.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53374.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53374):map__53374);
var request = map__53374__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53374__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,new cljs.core.Keyword(null,"jsonp","jsonp",226119588))){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});

//# sourceMappingURL=cljs_http.core.js.map
