goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__43902 = arguments.length;
switch (G__43902) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43912 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43912 = (function (f,blockable,meta43913){
this.f = f;
this.blockable = blockable;
this.meta43913 = meta43913;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43912.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43914,meta43913__$1){
var self__ = this;
var _43914__$1 = this;
return (new cljs.core.async.t_cljs$core$async43912(self__.f,self__.blockable,meta43913__$1));
}));

(cljs.core.async.t_cljs$core$async43912.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43914){
var self__ = this;
var _43914__$1 = this;
return self__.meta43913;
}));

(cljs.core.async.t_cljs$core$async43912.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43912.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43912.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async43912.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async43912.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta43913","meta43913",1764165610,null)], null);
}));

(cljs.core.async.t_cljs$core$async43912.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43912.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43912");

(cljs.core.async.t_cljs$core$async43912.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async43912");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43912.
 */
cljs.core.async.__GT_t_cljs$core$async43912 = (function cljs$core$async$__GT_t_cljs$core$async43912(f__$1,blockable__$1,meta43913){
return (new cljs.core.async.t_cljs$core$async43912(f__$1,blockable__$1,meta43913));
});

}

return (new cljs.core.async.t_cljs$core$async43912(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__43981 = arguments.length;
switch (G__43981) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__43997 = arguments.length;
switch (G__43997) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__44009 = arguments.length;
switch (G__44009) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_46340 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_46340) : fn1.call(null,val_46340));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_46340) : fn1.call(null,val_46340));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__44026 = arguments.length;
switch (G__44026) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___46354 = n;
var x_46355 = (0);
while(true){
if((x_46355 < n__4613__auto___46354)){
(a[x_46355] = x_46355);

var G__46357 = (x_46355 + (1));
x_46355 = G__46357;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44055 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44055 = (function (flag,meta44056){
this.flag = flag;
this.meta44056 = meta44056;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44055.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44057,meta44056__$1){
var self__ = this;
var _44057__$1 = this;
return (new cljs.core.async.t_cljs$core$async44055(self__.flag,meta44056__$1));
}));

(cljs.core.async.t_cljs$core$async44055.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44057){
var self__ = this;
var _44057__$1 = this;
return self__.meta44056;
}));

(cljs.core.async.t_cljs$core$async44055.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44055.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44055.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44055.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async44055.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta44056","meta44056",-1439359587,null)], null);
}));

(cljs.core.async.t_cljs$core$async44055.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44055.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44055");

(cljs.core.async.t_cljs$core$async44055.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44055");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44055.
 */
cljs.core.async.__GT_t_cljs$core$async44055 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async44055(flag__$1,meta44056){
return (new cljs.core.async.t_cljs$core$async44055(flag__$1,meta44056));
});

}

return (new cljs.core.async.t_cljs$core$async44055(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44082 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44082 = (function (flag,cb,meta44083){
this.flag = flag;
this.cb = cb;
this.meta44083 = meta44083;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44082.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44084,meta44083__$1){
var self__ = this;
var _44084__$1 = this;
return (new cljs.core.async.t_cljs$core$async44082(self__.flag,self__.cb,meta44083__$1));
}));

(cljs.core.async.t_cljs$core$async44082.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44084){
var self__ = this;
var _44084__$1 = this;
return self__.meta44083;
}));

(cljs.core.async.t_cljs$core$async44082.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44082.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44082.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44082.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async44082.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta44083","meta44083",1069433061,null)], null);
}));

(cljs.core.async.t_cljs$core$async44082.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44082.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44082");

(cljs.core.async.t_cljs$core$async44082.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44082");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44082.
 */
cljs.core.async.__GT_t_cljs$core$async44082 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async44082(flag__$1,cb__$1,meta44083){
return (new cljs.core.async.t_cljs$core$async44082(flag__$1,cb__$1,meta44083));
});

}

return (new cljs.core.async.t_cljs$core$async44082(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44110_SHARP_){
var G__44118 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44110_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44118) : fret.call(null,G__44118));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44111_SHARP_){
var G__44123 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44111_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44123) : fret.call(null,G__44123));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__46391 = (i + (1));
i = G__46391;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___46395 = arguments.length;
var i__4737__auto___46396 = (0);
while(true){
if((i__4737__auto___46396 < len__4736__auto___46395)){
args__4742__auto__.push((arguments[i__4737__auto___46396]));

var G__46397 = (i__4737__auto___46396 + (1));
i__4737__auto___46396 = G__46397;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__44139){
var map__44140 = p__44139;
var map__44140__$1 = (((((!((map__44140 == null))))?(((((map__44140.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44140.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44140):map__44140);
var opts = map__44140__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq44132){
var G__44133 = cljs.core.first(seq44132);
var seq44132__$1 = cljs.core.next(seq44132);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44133,seq44132__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__44155 = arguments.length;
switch (G__44155) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__43781__auto___46408 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_44211){
var state_val_44212 = (state_44211[(1)]);
if((state_val_44212 === (7))){
var inst_44204 = (state_44211[(2)]);
var state_44211__$1 = state_44211;
var statearr_44222_46412 = state_44211__$1;
(statearr_44222_46412[(2)] = inst_44204);

(statearr_44222_46412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44212 === (1))){
var state_44211__$1 = state_44211;
var statearr_44228_46414 = state_44211__$1;
(statearr_44228_46414[(2)] = null);

(statearr_44228_46414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44212 === (4))){
var inst_44174 = (state_44211[(7)]);
var inst_44174__$1 = (state_44211[(2)]);
var inst_44179 = (inst_44174__$1 == null);
var state_44211__$1 = (function (){var statearr_44235 = state_44211;
(statearr_44235[(7)] = inst_44174__$1);

return statearr_44235;
})();
if(cljs.core.truth_(inst_44179)){
var statearr_44236_46418 = state_44211__$1;
(statearr_44236_46418[(1)] = (5));

} else {
var statearr_44237_46419 = state_44211__$1;
(statearr_44237_46419[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44212 === (13))){
var state_44211__$1 = state_44211;
var statearr_44242_46420 = state_44211__$1;
(statearr_44242_46420[(2)] = null);

(statearr_44242_46420[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44212 === (6))){
var inst_44174 = (state_44211[(7)]);
var state_44211__$1 = state_44211;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44211__$1,(11),to,inst_44174);
} else {
if((state_val_44212 === (3))){
var inst_44206 = (state_44211[(2)]);
var state_44211__$1 = state_44211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44211__$1,inst_44206);
} else {
if((state_val_44212 === (12))){
var state_44211__$1 = state_44211;
var statearr_44262_46421 = state_44211__$1;
(statearr_44262_46421[(2)] = null);

(statearr_44262_46421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44212 === (2))){
var state_44211__$1 = state_44211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44211__$1,(4),from);
} else {
if((state_val_44212 === (11))){
var inst_44192 = (state_44211[(2)]);
var state_44211__$1 = state_44211;
if(cljs.core.truth_(inst_44192)){
var statearr_44270_46424 = state_44211__$1;
(statearr_44270_46424[(1)] = (12));

} else {
var statearr_44272_46425 = state_44211__$1;
(statearr_44272_46425[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44212 === (9))){
var state_44211__$1 = state_44211;
var statearr_44281_46431 = state_44211__$1;
(statearr_44281_46431[(2)] = null);

(statearr_44281_46431[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44212 === (5))){
var state_44211__$1 = state_44211;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44294_46432 = state_44211__$1;
(statearr_44294_46432[(1)] = (8));

} else {
var statearr_44296_46433 = state_44211__$1;
(statearr_44296_46433[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44212 === (14))){
var inst_44202 = (state_44211[(2)]);
var state_44211__$1 = state_44211;
var statearr_44308_46440 = state_44211__$1;
(statearr_44308_46440[(2)] = inst_44202);

(statearr_44308_46440[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44212 === (10))){
var inst_44189 = (state_44211[(2)]);
var state_44211__$1 = state_44211;
var statearr_44313_46443 = state_44211__$1;
(statearr_44313_46443[(2)] = inst_44189);

(statearr_44313_46443[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44212 === (8))){
var inst_44185 = cljs.core.async.close_BANG_(to);
var state_44211__$1 = state_44211;
var statearr_44323_46444 = state_44211__$1;
(statearr_44323_46444[(2)] = inst_44185);

(statearr_44323_46444[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43550__auto__ = null;
var cljs$core$async$state_machine__43550__auto____0 = (function (){
var statearr_44331 = [null,null,null,null,null,null,null,null];
(statearr_44331[(0)] = cljs$core$async$state_machine__43550__auto__);

(statearr_44331[(1)] = (1));

return statearr_44331;
});
var cljs$core$async$state_machine__43550__auto____1 = (function (state_44211){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_44211);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e44336){var ex__43553__auto__ = e44336;
var statearr_44337_46453 = state_44211;
(statearr_44337_46453[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_44211[(4)]))){
var statearr_44339_46455 = state_44211;
(statearr_44339_46455[(1)] = cljs.core.first((state_44211[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46458 = state_44211;
state_44211 = G__46458;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$state_machine__43550__auto__ = function(state_44211){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43550__auto____1.call(this,state_44211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43550__auto____0;
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43550__auto____1;
return cljs$core$async$state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_44346 = f__43782__auto__();
(statearr_44346[(6)] = c__43781__auto___46408);

return statearr_44346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__44360){
var vec__44361 = p__44360;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44361,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44361,(1),null);
var job = vec__44361;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__43781__auto___46463 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_44377){
var state_val_44378 = (state_44377[(1)]);
if((state_val_44378 === (1))){
var state_44377__$1 = state_44377;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44377__$1,(2),res,v);
} else {
if((state_val_44378 === (2))){
var inst_44374 = (state_44377[(2)]);
var inst_44375 = cljs.core.async.close_BANG_(res);
var state_44377__$1 = (function (){var statearr_44383 = state_44377;
(statearr_44383[(7)] = inst_44374);

return statearr_44383;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44377__$1,inst_44375);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0 = (function (){
var statearr_44384 = [null,null,null,null,null,null,null,null];
(statearr_44384[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__);

(statearr_44384[(1)] = (1));

return statearr_44384;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1 = (function (state_44377){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_44377);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e44388){var ex__43553__auto__ = e44388;
var statearr_44389_46477 = state_44377;
(statearr_44389_46477[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_44377[(4)]))){
var statearr_44391_46478 = state_44377;
(statearr_44391_46478[(1)] = cljs.core.first((state_44377[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46483 = state_44377;
state_44377 = G__46483;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__ = function(state_44377){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1.call(this,state_44377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_44393 = f__43782__auto__();
(statearr_44393[(6)] = c__43781__auto___46463);

return statearr_44393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__44397){
var vec__44400 = p__44397;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44400,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44400,(1),null);
var job = vec__44400;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___46495 = n;
var __46496 = (0);
while(true){
if((__46496 < n__4613__auto___46495)){
var G__44403_46498 = type;
var G__44403_46499__$1 = (((G__44403_46498 instanceof cljs.core.Keyword))?G__44403_46498.fqn:null);
switch (G__44403_46499__$1) {
case "compute":
var c__43781__auto___46501 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__46496,c__43781__auto___46501,G__44403_46498,G__44403_46499__$1,n__4613__auto___46495,jobs,results,process,async){
return (function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = ((function (__46496,c__43781__auto___46501,G__44403_46498,G__44403_46499__$1,n__4613__auto___46495,jobs,results,process,async){
return (function (state_44416){
var state_val_44417 = (state_44416[(1)]);
if((state_val_44417 === (1))){
var state_44416__$1 = state_44416;
var statearr_44419_46506 = state_44416__$1;
(statearr_44419_46506[(2)] = null);

(statearr_44419_46506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44417 === (2))){
var state_44416__$1 = state_44416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44416__$1,(4),jobs);
} else {
if((state_val_44417 === (3))){
var inst_44414 = (state_44416[(2)]);
var state_44416__$1 = state_44416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44416__$1,inst_44414);
} else {
if((state_val_44417 === (4))){
var inst_44406 = (state_44416[(2)]);
var inst_44407 = process(inst_44406);
var state_44416__$1 = state_44416;
if(cljs.core.truth_(inst_44407)){
var statearr_44422_46510 = state_44416__$1;
(statearr_44422_46510[(1)] = (5));

} else {
var statearr_44423_46511 = state_44416__$1;
(statearr_44423_46511[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44417 === (5))){
var state_44416__$1 = state_44416;
var statearr_44426_46519 = state_44416__$1;
(statearr_44426_46519[(2)] = null);

(statearr_44426_46519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44417 === (6))){
var state_44416__$1 = state_44416;
var statearr_44427_46520 = state_44416__$1;
(statearr_44427_46520[(2)] = null);

(statearr_44427_46520[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44417 === (7))){
var inst_44412 = (state_44416[(2)]);
var state_44416__$1 = state_44416;
var statearr_44432_46525 = state_44416__$1;
(statearr_44432_46525[(2)] = inst_44412);

(statearr_44432_46525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46496,c__43781__auto___46501,G__44403_46498,G__44403_46499__$1,n__4613__auto___46495,jobs,results,process,async))
;
return ((function (__46496,switch__43549__auto__,c__43781__auto___46501,G__44403_46498,G__44403_46499__$1,n__4613__auto___46495,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0 = (function (){
var statearr_44433 = [null,null,null,null,null,null,null];
(statearr_44433[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__);

(statearr_44433[(1)] = (1));

return statearr_44433;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1 = (function (state_44416){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_44416);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e44434){var ex__43553__auto__ = e44434;
var statearr_44435_46532 = state_44416;
(statearr_44435_46532[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_44416[(4)]))){
var statearr_44437_46534 = state_44416;
(statearr_44437_46534[(1)] = cljs.core.first((state_44416[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46536 = state_44416;
state_44416 = G__46536;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__ = function(state_44416){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1.call(this,state_44416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__;
})()
;})(__46496,switch__43549__auto__,c__43781__auto___46501,G__44403_46498,G__44403_46499__$1,n__4613__auto___46495,jobs,results,process,async))
})();
var state__43783__auto__ = (function (){var statearr_44440 = f__43782__auto__();
(statearr_44440[(6)] = c__43781__auto___46501);

return statearr_44440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
});})(__46496,c__43781__auto___46501,G__44403_46498,G__44403_46499__$1,n__4613__auto___46495,jobs,results,process,async))
);


break;
case "async":
var c__43781__auto___46539 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__46496,c__43781__auto___46539,G__44403_46498,G__44403_46499__$1,n__4613__auto___46495,jobs,results,process,async){
return (function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = ((function (__46496,c__43781__auto___46539,G__44403_46498,G__44403_46499__$1,n__4613__auto___46495,jobs,results,process,async){
return (function (state_44456){
var state_val_44457 = (state_44456[(1)]);
if((state_val_44457 === (1))){
var state_44456__$1 = state_44456;
var statearr_44460_46542 = state_44456__$1;
(statearr_44460_46542[(2)] = null);

(statearr_44460_46542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44457 === (2))){
var state_44456__$1 = state_44456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44456__$1,(4),jobs);
} else {
if((state_val_44457 === (3))){
var inst_44453 = (state_44456[(2)]);
var state_44456__$1 = state_44456;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44456__$1,inst_44453);
} else {
if((state_val_44457 === (4))){
var inst_44443 = (state_44456[(2)]);
var inst_44444 = async(inst_44443);
var state_44456__$1 = state_44456;
if(cljs.core.truth_(inst_44444)){
var statearr_44462_46547 = state_44456__$1;
(statearr_44462_46547[(1)] = (5));

} else {
var statearr_44463_46552 = state_44456__$1;
(statearr_44463_46552[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44457 === (5))){
var state_44456__$1 = state_44456;
var statearr_44466_46559 = state_44456__$1;
(statearr_44466_46559[(2)] = null);

(statearr_44466_46559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44457 === (6))){
var state_44456__$1 = state_44456;
var statearr_44470_46564 = state_44456__$1;
(statearr_44470_46564[(2)] = null);

(statearr_44470_46564[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44457 === (7))){
var inst_44451 = (state_44456[(2)]);
var state_44456__$1 = state_44456;
var statearr_44471_46569 = state_44456__$1;
(statearr_44471_46569[(2)] = inst_44451);

(statearr_44471_46569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46496,c__43781__auto___46539,G__44403_46498,G__44403_46499__$1,n__4613__auto___46495,jobs,results,process,async))
;
return ((function (__46496,switch__43549__auto__,c__43781__auto___46539,G__44403_46498,G__44403_46499__$1,n__4613__auto___46495,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0 = (function (){
var statearr_44476 = [null,null,null,null,null,null,null];
(statearr_44476[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__);

(statearr_44476[(1)] = (1));

return statearr_44476;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1 = (function (state_44456){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_44456);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e44477){var ex__43553__auto__ = e44477;
var statearr_44480_46572 = state_44456;
(statearr_44480_46572[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_44456[(4)]))){
var statearr_44482_46575 = state_44456;
(statearr_44482_46575[(1)] = cljs.core.first((state_44456[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46576 = state_44456;
state_44456 = G__46576;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__ = function(state_44456){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1.call(this,state_44456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__;
})()
;})(__46496,switch__43549__auto__,c__43781__auto___46539,G__44403_46498,G__44403_46499__$1,n__4613__auto___46495,jobs,results,process,async))
})();
var state__43783__auto__ = (function (){var statearr_44484 = f__43782__auto__();
(statearr_44484[(6)] = c__43781__auto___46539);

return statearr_44484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
});})(__46496,c__43781__auto___46539,G__44403_46498,G__44403_46499__$1,n__4613__auto___46495,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44403_46499__$1)].join('')));

}

var G__46581 = (__46496 + (1));
__46496 = G__46581;
continue;
} else {
}
break;
}

var c__43781__auto___46582 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_44514){
var state_val_44515 = (state_44514[(1)]);
if((state_val_44515 === (7))){
var inst_44509 = (state_44514[(2)]);
var state_44514__$1 = state_44514;
var statearr_44517_46583 = state_44514__$1;
(statearr_44517_46583[(2)] = inst_44509);

(statearr_44517_46583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (1))){
var state_44514__$1 = state_44514;
var statearr_44518_46585 = state_44514__$1;
(statearr_44518_46585[(2)] = null);

(statearr_44518_46585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (4))){
var inst_44491 = (state_44514[(7)]);
var inst_44491__$1 = (state_44514[(2)]);
var inst_44494 = (inst_44491__$1 == null);
var state_44514__$1 = (function (){var statearr_44519 = state_44514;
(statearr_44519[(7)] = inst_44491__$1);

return statearr_44519;
})();
if(cljs.core.truth_(inst_44494)){
var statearr_44520_46588 = state_44514__$1;
(statearr_44520_46588[(1)] = (5));

} else {
var statearr_44521_46590 = state_44514__$1;
(statearr_44521_46590[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (6))){
var inst_44491 = (state_44514[(7)]);
var inst_44498 = (state_44514[(8)]);
var inst_44498__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_44499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44500 = [inst_44491,inst_44498__$1];
var inst_44501 = (new cljs.core.PersistentVector(null,2,(5),inst_44499,inst_44500,null));
var state_44514__$1 = (function (){var statearr_44524 = state_44514;
(statearr_44524[(8)] = inst_44498__$1);

return statearr_44524;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44514__$1,(8),jobs,inst_44501);
} else {
if((state_val_44515 === (3))){
var inst_44512 = (state_44514[(2)]);
var state_44514__$1 = state_44514;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44514__$1,inst_44512);
} else {
if((state_val_44515 === (2))){
var state_44514__$1 = state_44514;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44514__$1,(4),from);
} else {
if((state_val_44515 === (9))){
var inst_44506 = (state_44514[(2)]);
var state_44514__$1 = (function (){var statearr_44528 = state_44514;
(statearr_44528[(9)] = inst_44506);

return statearr_44528;
})();
var statearr_44529_46605 = state_44514__$1;
(statearr_44529_46605[(2)] = null);

(statearr_44529_46605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (5))){
var inst_44496 = cljs.core.async.close_BANG_(jobs);
var state_44514__$1 = state_44514;
var statearr_44530_46607 = state_44514__$1;
(statearr_44530_46607[(2)] = inst_44496);

(statearr_44530_46607[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44515 === (8))){
var inst_44498 = (state_44514[(8)]);
var inst_44503 = (state_44514[(2)]);
var state_44514__$1 = (function (){var statearr_44532 = state_44514;
(statearr_44532[(10)] = inst_44503);

return statearr_44532;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44514__$1,(9),results,inst_44498);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0 = (function (){
var statearr_44534 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44534[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__);

(statearr_44534[(1)] = (1));

return statearr_44534;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1 = (function (state_44514){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_44514);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e44535){var ex__43553__auto__ = e44535;
var statearr_44536_46628 = state_44514;
(statearr_44536_46628[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_44514[(4)]))){
var statearr_44537_46629 = state_44514;
(statearr_44537_46629[(1)] = cljs.core.first((state_44514[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46634 = state_44514;
state_44514 = G__46634;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__ = function(state_44514){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1.call(this,state_44514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_44540 = f__43782__auto__();
(statearr_44540[(6)] = c__43781__auto___46582);

return statearr_44540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


var c__43781__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_44583){
var state_val_44584 = (state_44583[(1)]);
if((state_val_44584 === (7))){
var inst_44578 = (state_44583[(2)]);
var state_44583__$1 = state_44583;
var statearr_44586_46645 = state_44583__$1;
(statearr_44586_46645[(2)] = inst_44578);

(statearr_44586_46645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (20))){
var state_44583__$1 = state_44583;
var statearr_44589_46652 = state_44583__$1;
(statearr_44589_46652[(2)] = null);

(statearr_44589_46652[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (1))){
var state_44583__$1 = state_44583;
var statearr_44590_46660 = state_44583__$1;
(statearr_44590_46660[(2)] = null);

(statearr_44590_46660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (4))){
var inst_44544 = (state_44583[(7)]);
var inst_44544__$1 = (state_44583[(2)]);
var inst_44545 = (inst_44544__$1 == null);
var state_44583__$1 = (function (){var statearr_44593 = state_44583;
(statearr_44593[(7)] = inst_44544__$1);

return statearr_44593;
})();
if(cljs.core.truth_(inst_44545)){
var statearr_44594_46668 = state_44583__$1;
(statearr_44594_46668[(1)] = (5));

} else {
var statearr_44595_46671 = state_44583__$1;
(statearr_44595_46671[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (15))){
var inst_44557 = (state_44583[(8)]);
var state_44583__$1 = state_44583;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44583__$1,(18),to,inst_44557);
} else {
if((state_val_44584 === (21))){
var inst_44573 = (state_44583[(2)]);
var state_44583__$1 = state_44583;
var statearr_44598_46676 = state_44583__$1;
(statearr_44598_46676[(2)] = inst_44573);

(statearr_44598_46676[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (13))){
var inst_44575 = (state_44583[(2)]);
var state_44583__$1 = (function (){var statearr_44599 = state_44583;
(statearr_44599[(9)] = inst_44575);

return statearr_44599;
})();
var statearr_44602_46689 = state_44583__$1;
(statearr_44602_46689[(2)] = null);

(statearr_44602_46689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (6))){
var inst_44544 = (state_44583[(7)]);
var state_44583__$1 = state_44583;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44583__$1,(11),inst_44544);
} else {
if((state_val_44584 === (17))){
var inst_44568 = (state_44583[(2)]);
var state_44583__$1 = state_44583;
if(cljs.core.truth_(inst_44568)){
var statearr_44603_46705 = state_44583__$1;
(statearr_44603_46705[(1)] = (19));

} else {
var statearr_44604_46708 = state_44583__$1;
(statearr_44604_46708[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (3))){
var inst_44580 = (state_44583[(2)]);
var state_44583__$1 = state_44583;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44583__$1,inst_44580);
} else {
if((state_val_44584 === (12))){
var inst_44554 = (state_44583[(10)]);
var state_44583__$1 = state_44583;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44583__$1,(14),inst_44554);
} else {
if((state_val_44584 === (2))){
var state_44583__$1 = state_44583;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44583__$1,(4),results);
} else {
if((state_val_44584 === (19))){
var state_44583__$1 = state_44583;
var statearr_44605_46712 = state_44583__$1;
(statearr_44605_46712[(2)] = null);

(statearr_44605_46712[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (11))){
var inst_44554 = (state_44583[(2)]);
var state_44583__$1 = (function (){var statearr_44611 = state_44583;
(statearr_44611[(10)] = inst_44554);

return statearr_44611;
})();
var statearr_44612_46715 = state_44583__$1;
(statearr_44612_46715[(2)] = null);

(statearr_44612_46715[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (9))){
var state_44583__$1 = state_44583;
var statearr_44618_46716 = state_44583__$1;
(statearr_44618_46716[(2)] = null);

(statearr_44618_46716[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (5))){
var state_44583__$1 = state_44583;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44624_46717 = state_44583__$1;
(statearr_44624_46717[(1)] = (8));

} else {
var statearr_44625_46718 = state_44583__$1;
(statearr_44625_46718[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (14))){
var inst_44557 = (state_44583[(8)]);
var inst_44557__$1 = (state_44583[(2)]);
var inst_44560 = (inst_44557__$1 == null);
var inst_44561 = cljs.core.not(inst_44560);
var state_44583__$1 = (function (){var statearr_44626 = state_44583;
(statearr_44626[(8)] = inst_44557__$1);

return statearr_44626;
})();
if(inst_44561){
var statearr_44627_46719 = state_44583__$1;
(statearr_44627_46719[(1)] = (15));

} else {
var statearr_44628_46720 = state_44583__$1;
(statearr_44628_46720[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (16))){
var state_44583__$1 = state_44583;
var statearr_44629_46727 = state_44583__$1;
(statearr_44629_46727[(2)] = false);

(statearr_44629_46727[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (10))){
var inst_44551 = (state_44583[(2)]);
var state_44583__$1 = state_44583;
var statearr_44631_46728 = state_44583__$1;
(statearr_44631_46728[(2)] = inst_44551);

(statearr_44631_46728[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (18))){
var inst_44565 = (state_44583[(2)]);
var state_44583__$1 = state_44583;
var statearr_44634_46729 = state_44583__$1;
(statearr_44634_46729[(2)] = inst_44565);

(statearr_44634_46729[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44584 === (8))){
var inst_44548 = cljs.core.async.close_BANG_(to);
var state_44583__$1 = state_44583;
var statearr_44636_46730 = state_44583__$1;
(statearr_44636_46730[(2)] = inst_44548);

(statearr_44636_46730[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0 = (function (){
var statearr_44639 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44639[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__);

(statearr_44639[(1)] = (1));

return statearr_44639;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1 = (function (state_44583){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_44583);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e44640){var ex__43553__auto__ = e44640;
var statearr_44641_46734 = state_44583;
(statearr_44641_46734[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_44583[(4)]))){
var statearr_44642_46735 = state_44583;
(statearr_44642_46735[(1)] = cljs.core.first((state_44583[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46736 = state_44583;
state_44583 = G__46736;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__ = function(state_44583){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1.call(this,state_44583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43550__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_44643 = f__43782__auto__();
(statearr_44643[(6)] = c__43781__auto__);

return statearr_44643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));

return c__43781__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__44646 = arguments.length;
switch (G__44646) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__44649 = arguments.length;
switch (G__44649) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__44661 = arguments.length;
switch (G__44661) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__43781__auto___46771 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_44691){
var state_val_44692 = (state_44691[(1)]);
if((state_val_44692 === (7))){
var inst_44687 = (state_44691[(2)]);
var state_44691__$1 = state_44691;
var statearr_44693_46772 = state_44691__$1;
(statearr_44693_46772[(2)] = inst_44687);

(statearr_44693_46772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44692 === (1))){
var state_44691__$1 = state_44691;
var statearr_44695_46775 = state_44691__$1;
(statearr_44695_46775[(2)] = null);

(statearr_44695_46775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44692 === (4))){
var inst_44668 = (state_44691[(7)]);
var inst_44668__$1 = (state_44691[(2)]);
var inst_44669 = (inst_44668__$1 == null);
var state_44691__$1 = (function (){var statearr_44698 = state_44691;
(statearr_44698[(7)] = inst_44668__$1);

return statearr_44698;
})();
if(cljs.core.truth_(inst_44669)){
var statearr_44699_46776 = state_44691__$1;
(statearr_44699_46776[(1)] = (5));

} else {
var statearr_44700_46777 = state_44691__$1;
(statearr_44700_46777[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44692 === (13))){
var state_44691__$1 = state_44691;
var statearr_44701_46778 = state_44691__$1;
(statearr_44701_46778[(2)] = null);

(statearr_44701_46778[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44692 === (6))){
var inst_44668 = (state_44691[(7)]);
var inst_44674 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_44668) : p.call(null,inst_44668));
var state_44691__$1 = state_44691;
if(cljs.core.truth_(inst_44674)){
var statearr_44702_46779 = state_44691__$1;
(statearr_44702_46779[(1)] = (9));

} else {
var statearr_44703_46780 = state_44691__$1;
(statearr_44703_46780[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44692 === (3))){
var inst_44689 = (state_44691[(2)]);
var state_44691__$1 = state_44691;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44691__$1,inst_44689);
} else {
if((state_val_44692 === (12))){
var state_44691__$1 = state_44691;
var statearr_44708_46781 = state_44691__$1;
(statearr_44708_46781[(2)] = null);

(statearr_44708_46781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44692 === (2))){
var state_44691__$1 = state_44691;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44691__$1,(4),ch);
} else {
if((state_val_44692 === (11))){
var inst_44668 = (state_44691[(7)]);
var inst_44678 = (state_44691[(2)]);
var state_44691__$1 = state_44691;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44691__$1,(8),inst_44678,inst_44668);
} else {
if((state_val_44692 === (9))){
var state_44691__$1 = state_44691;
var statearr_44709_46794 = state_44691__$1;
(statearr_44709_46794[(2)] = tc);

(statearr_44709_46794[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44692 === (5))){
var inst_44671 = cljs.core.async.close_BANG_(tc);
var inst_44672 = cljs.core.async.close_BANG_(fc);
var state_44691__$1 = (function (){var statearr_44712 = state_44691;
(statearr_44712[(8)] = inst_44671);

return statearr_44712;
})();
var statearr_44713_46795 = state_44691__$1;
(statearr_44713_46795[(2)] = inst_44672);

(statearr_44713_46795[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44692 === (14))){
var inst_44685 = (state_44691[(2)]);
var state_44691__$1 = state_44691;
var statearr_44714_46796 = state_44691__$1;
(statearr_44714_46796[(2)] = inst_44685);

(statearr_44714_46796[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44692 === (10))){
var state_44691__$1 = state_44691;
var statearr_44715_46797 = state_44691__$1;
(statearr_44715_46797[(2)] = fc);

(statearr_44715_46797[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44692 === (8))){
var inst_44680 = (state_44691[(2)]);
var state_44691__$1 = state_44691;
if(cljs.core.truth_(inst_44680)){
var statearr_44716_46799 = state_44691__$1;
(statearr_44716_46799[(1)] = (12));

} else {
var statearr_44717_46804 = state_44691__$1;
(statearr_44717_46804[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43550__auto__ = null;
var cljs$core$async$state_machine__43550__auto____0 = (function (){
var statearr_44720 = [null,null,null,null,null,null,null,null,null];
(statearr_44720[(0)] = cljs$core$async$state_machine__43550__auto__);

(statearr_44720[(1)] = (1));

return statearr_44720;
});
var cljs$core$async$state_machine__43550__auto____1 = (function (state_44691){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_44691);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e44722){var ex__43553__auto__ = e44722;
var statearr_44723_46806 = state_44691;
(statearr_44723_46806[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_44691[(4)]))){
var statearr_44724_46807 = state_44691;
(statearr_44724_46807[(1)] = cljs.core.first((state_44691[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46808 = state_44691;
state_44691 = G__46808;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$state_machine__43550__auto__ = function(state_44691){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43550__auto____1.call(this,state_44691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43550__auto____0;
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43550__auto____1;
return cljs$core$async$state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_44725 = f__43782__auto__();
(statearr_44725[(6)] = c__43781__auto___46771);

return statearr_44725;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__43781__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_44748){
var state_val_44749 = (state_44748[(1)]);
if((state_val_44749 === (7))){
var inst_44744 = (state_44748[(2)]);
var state_44748__$1 = state_44748;
var statearr_44751_46813 = state_44748__$1;
(statearr_44751_46813[(2)] = inst_44744);

(statearr_44751_46813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44749 === (1))){
var inst_44727 = init;
var inst_44728 = inst_44727;
var state_44748__$1 = (function (){var statearr_44752 = state_44748;
(statearr_44752[(7)] = inst_44728);

return statearr_44752;
})();
var statearr_44753_46818 = state_44748__$1;
(statearr_44753_46818[(2)] = null);

(statearr_44753_46818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44749 === (4))){
var inst_44731 = (state_44748[(8)]);
var inst_44731__$1 = (state_44748[(2)]);
var inst_44732 = (inst_44731__$1 == null);
var state_44748__$1 = (function (){var statearr_44754 = state_44748;
(statearr_44754[(8)] = inst_44731__$1);

return statearr_44754;
})();
if(cljs.core.truth_(inst_44732)){
var statearr_44755_46823 = state_44748__$1;
(statearr_44755_46823[(1)] = (5));

} else {
var statearr_44756_46824 = state_44748__$1;
(statearr_44756_46824[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44749 === (6))){
var inst_44728 = (state_44748[(7)]);
var inst_44735 = (state_44748[(9)]);
var inst_44731 = (state_44748[(8)]);
var inst_44735__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_44728,inst_44731) : f.call(null,inst_44728,inst_44731));
var inst_44736 = cljs.core.reduced_QMARK_(inst_44735__$1);
var state_44748__$1 = (function (){var statearr_44757 = state_44748;
(statearr_44757[(9)] = inst_44735__$1);

return statearr_44757;
})();
if(inst_44736){
var statearr_44758_46826 = state_44748__$1;
(statearr_44758_46826[(1)] = (8));

} else {
var statearr_44759_46829 = state_44748__$1;
(statearr_44759_46829[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44749 === (3))){
var inst_44746 = (state_44748[(2)]);
var state_44748__$1 = state_44748;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44748__$1,inst_44746);
} else {
if((state_val_44749 === (2))){
var state_44748__$1 = state_44748;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44748__$1,(4),ch);
} else {
if((state_val_44749 === (9))){
var inst_44735 = (state_44748[(9)]);
var inst_44728 = inst_44735;
var state_44748__$1 = (function (){var statearr_44763 = state_44748;
(statearr_44763[(7)] = inst_44728);

return statearr_44763;
})();
var statearr_44764_46830 = state_44748__$1;
(statearr_44764_46830[(2)] = null);

(statearr_44764_46830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44749 === (5))){
var inst_44728 = (state_44748[(7)]);
var state_44748__$1 = state_44748;
var statearr_44766_46831 = state_44748__$1;
(statearr_44766_46831[(2)] = inst_44728);

(statearr_44766_46831[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44749 === (10))){
var inst_44742 = (state_44748[(2)]);
var state_44748__$1 = state_44748;
var statearr_44767_46832 = state_44748__$1;
(statearr_44767_46832[(2)] = inst_44742);

(statearr_44767_46832[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44749 === (8))){
var inst_44735 = (state_44748[(9)]);
var inst_44738 = cljs.core.deref(inst_44735);
var state_44748__$1 = state_44748;
var statearr_44768_46833 = state_44748__$1;
(statearr_44768_46833[(2)] = inst_44738);

(statearr_44768_46833[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__43550__auto__ = null;
var cljs$core$async$reduce_$_state_machine__43550__auto____0 = (function (){
var statearr_44769 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44769[(0)] = cljs$core$async$reduce_$_state_machine__43550__auto__);

(statearr_44769[(1)] = (1));

return statearr_44769;
});
var cljs$core$async$reduce_$_state_machine__43550__auto____1 = (function (state_44748){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_44748);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e44770){var ex__43553__auto__ = e44770;
var statearr_44771_46842 = state_44748;
(statearr_44771_46842[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_44748[(4)]))){
var statearr_44773_46847 = state_44748;
(statearr_44773_46847[(1)] = cljs.core.first((state_44748[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46850 = state_44748;
state_44748 = G__46850;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__43550__auto__ = function(state_44748){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__43550__auto____1.call(this,state_44748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__43550__auto____0;
cljs$core$async$reduce_$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__43550__auto____1;
return cljs$core$async$reduce_$_state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_44774 = f__43782__auto__();
(statearr_44774[(6)] = c__43781__auto__);

return statearr_44774;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));

return c__43781__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__43781__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_44781){
var state_val_44782 = (state_44781[(1)]);
if((state_val_44782 === (1))){
var inst_44776 = cljs.core.async.reduce(f__$1,init,ch);
var state_44781__$1 = state_44781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44781__$1,(2),inst_44776);
} else {
if((state_val_44782 === (2))){
var inst_44778 = (state_44781[(2)]);
var inst_44779 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_44778) : f__$1.call(null,inst_44778));
var state_44781__$1 = state_44781;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44781__$1,inst_44779);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__43550__auto__ = null;
var cljs$core$async$transduce_$_state_machine__43550__auto____0 = (function (){
var statearr_44786 = [null,null,null,null,null,null,null];
(statearr_44786[(0)] = cljs$core$async$transduce_$_state_machine__43550__auto__);

(statearr_44786[(1)] = (1));

return statearr_44786;
});
var cljs$core$async$transduce_$_state_machine__43550__auto____1 = (function (state_44781){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_44781);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e44787){var ex__43553__auto__ = e44787;
var statearr_44788_46852 = state_44781;
(statearr_44788_46852[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_44781[(4)]))){
var statearr_44790_46853 = state_44781;
(statearr_44790_46853[(1)] = cljs.core.first((state_44781[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46854 = state_44781;
state_44781 = G__46854;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__43550__auto__ = function(state_44781){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__43550__auto____1.call(this,state_44781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__43550__auto____0;
cljs$core$async$transduce_$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__43550__auto____1;
return cljs$core$async$transduce_$_state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_44791 = f__43782__auto__();
(statearr_44791[(6)] = c__43781__auto__);

return statearr_44791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));

return c__43781__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__44798 = arguments.length;
switch (G__44798) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__43781__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_44825){
var state_val_44826 = (state_44825[(1)]);
if((state_val_44826 === (7))){
var inst_44807 = (state_44825[(2)]);
var state_44825__$1 = state_44825;
var statearr_44829_46859 = state_44825__$1;
(statearr_44829_46859[(2)] = inst_44807);

(statearr_44829_46859[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (1))){
var inst_44801 = cljs.core.seq(coll);
var inst_44802 = inst_44801;
var state_44825__$1 = (function (){var statearr_44830 = state_44825;
(statearr_44830[(7)] = inst_44802);

return statearr_44830;
})();
var statearr_44831_46866 = state_44825__$1;
(statearr_44831_46866[(2)] = null);

(statearr_44831_46866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (4))){
var inst_44802 = (state_44825[(7)]);
var inst_44805 = cljs.core.first(inst_44802);
var state_44825__$1 = state_44825;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44825__$1,(7),ch,inst_44805);
} else {
if((state_val_44826 === (13))){
var inst_44819 = (state_44825[(2)]);
var state_44825__$1 = state_44825;
var statearr_44832_46874 = state_44825__$1;
(statearr_44832_46874[(2)] = inst_44819);

(statearr_44832_46874[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (6))){
var inst_44810 = (state_44825[(2)]);
var state_44825__$1 = state_44825;
if(cljs.core.truth_(inst_44810)){
var statearr_44833_46875 = state_44825__$1;
(statearr_44833_46875[(1)] = (8));

} else {
var statearr_44834_46877 = state_44825__$1;
(statearr_44834_46877[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (3))){
var inst_44823 = (state_44825[(2)]);
var state_44825__$1 = state_44825;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44825__$1,inst_44823);
} else {
if((state_val_44826 === (12))){
var state_44825__$1 = state_44825;
var statearr_44835_46880 = state_44825__$1;
(statearr_44835_46880[(2)] = null);

(statearr_44835_46880[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (2))){
var inst_44802 = (state_44825[(7)]);
var state_44825__$1 = state_44825;
if(cljs.core.truth_(inst_44802)){
var statearr_44836_46882 = state_44825__$1;
(statearr_44836_46882[(1)] = (4));

} else {
var statearr_44837_46883 = state_44825__$1;
(statearr_44837_46883[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (11))){
var inst_44816 = cljs.core.async.close_BANG_(ch);
var state_44825__$1 = state_44825;
var statearr_44838_46884 = state_44825__$1;
(statearr_44838_46884[(2)] = inst_44816);

(statearr_44838_46884[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (9))){
var state_44825__$1 = state_44825;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44839_46885 = state_44825__$1;
(statearr_44839_46885[(1)] = (11));

} else {
var statearr_44840_46886 = state_44825__$1;
(statearr_44840_46886[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (5))){
var inst_44802 = (state_44825[(7)]);
var state_44825__$1 = state_44825;
var statearr_44842_46887 = state_44825__$1;
(statearr_44842_46887[(2)] = inst_44802);

(statearr_44842_46887[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (10))){
var inst_44821 = (state_44825[(2)]);
var state_44825__$1 = state_44825;
var statearr_44843_46894 = state_44825__$1;
(statearr_44843_46894[(2)] = inst_44821);

(statearr_44843_46894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (8))){
var inst_44802 = (state_44825[(7)]);
var inst_44812 = cljs.core.next(inst_44802);
var inst_44802__$1 = inst_44812;
var state_44825__$1 = (function (){var statearr_44844 = state_44825;
(statearr_44844[(7)] = inst_44802__$1);

return statearr_44844;
})();
var statearr_44847_46898 = state_44825__$1;
(statearr_44847_46898[(2)] = null);

(statearr_44847_46898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43550__auto__ = null;
var cljs$core$async$state_machine__43550__auto____0 = (function (){
var statearr_44849 = [null,null,null,null,null,null,null,null];
(statearr_44849[(0)] = cljs$core$async$state_machine__43550__auto__);

(statearr_44849[(1)] = (1));

return statearr_44849;
});
var cljs$core$async$state_machine__43550__auto____1 = (function (state_44825){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_44825);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e44850){var ex__43553__auto__ = e44850;
var statearr_44851_46906 = state_44825;
(statearr_44851_46906[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_44825[(4)]))){
var statearr_44852_46910 = state_44825;
(statearr_44852_46910[(1)] = cljs.core.first((state_44825[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46911 = state_44825;
state_44825 = G__46911;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$state_machine__43550__auto__ = function(state_44825){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43550__auto____1.call(this,state_44825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43550__auto____0;
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43550__auto____1;
return cljs$core$async$state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_44855 = f__43782__auto__();
(statearr_44855[(6)] = c__43781__auto__);

return statearr_44855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));

return c__43781__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__44857 = arguments.length;
switch (G__44857) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_46927 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_46927(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_46929 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_46929(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_46935 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_46935(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_46936 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_46936(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44882 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44882 = (function (ch,cs,meta44883){
this.ch = ch;
this.cs = cs;
this.meta44883 = meta44883;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44882.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44884,meta44883__$1){
var self__ = this;
var _44884__$1 = this;
return (new cljs.core.async.t_cljs$core$async44882(self__.ch,self__.cs,meta44883__$1));
}));

(cljs.core.async.t_cljs$core$async44882.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44884){
var self__ = this;
var _44884__$1 = this;
return self__.meta44883;
}));

(cljs.core.async.t_cljs$core$async44882.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44882.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async44882.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44882.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async44882.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async44882.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async44882.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta44883","meta44883",1149695686,null)], null);
}));

(cljs.core.async.t_cljs$core$async44882.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44882.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44882");

(cljs.core.async.t_cljs$core$async44882.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44882");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44882.
 */
cljs.core.async.__GT_t_cljs$core$async44882 = (function cljs$core$async$mult_$___GT_t_cljs$core$async44882(ch__$1,cs__$1,meta44883){
return (new cljs.core.async.t_cljs$core$async44882(ch__$1,cs__$1,meta44883));
});

}

return (new cljs.core.async.t_cljs$core$async44882(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__43781__auto___46946 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_45026){
var state_val_45027 = (state_45026[(1)]);
if((state_val_45027 === (7))){
var inst_45021 = (state_45026[(2)]);
var state_45026__$1 = state_45026;
var statearr_45028_46947 = state_45026__$1;
(statearr_45028_46947[(2)] = inst_45021);

(statearr_45028_46947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (20))){
var inst_44924 = (state_45026[(7)]);
var inst_44937 = cljs.core.first(inst_44924);
var inst_44938 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44937,(0),null);
var inst_44939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44937,(1),null);
var state_45026__$1 = (function (){var statearr_45031 = state_45026;
(statearr_45031[(8)] = inst_44938);

return statearr_45031;
})();
if(cljs.core.truth_(inst_44939)){
var statearr_45034_46952 = state_45026__$1;
(statearr_45034_46952[(1)] = (22));

} else {
var statearr_45035_46955 = state_45026__$1;
(statearr_45035_46955[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (27))){
var inst_44968 = (state_45026[(9)]);
var inst_44891 = (state_45026[(10)]);
var inst_44970 = (state_45026[(11)]);
var inst_44975 = (state_45026[(12)]);
var inst_44975__$1 = cljs.core._nth(inst_44968,inst_44970);
var inst_44976 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_44975__$1,inst_44891,done);
var state_45026__$1 = (function (){var statearr_45038 = state_45026;
(statearr_45038[(12)] = inst_44975__$1);

return statearr_45038;
})();
if(cljs.core.truth_(inst_44976)){
var statearr_45039_46956 = state_45026__$1;
(statearr_45039_46956[(1)] = (30));

} else {
var statearr_45040_46957 = state_45026__$1;
(statearr_45040_46957[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (1))){
var state_45026__$1 = state_45026;
var statearr_45041_46958 = state_45026__$1;
(statearr_45041_46958[(2)] = null);

(statearr_45041_46958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (24))){
var inst_44924 = (state_45026[(7)]);
var inst_44944 = (state_45026[(2)]);
var inst_44945 = cljs.core.next(inst_44924);
var inst_44901 = inst_44945;
var inst_44902 = null;
var inst_44903 = (0);
var inst_44904 = (0);
var state_45026__$1 = (function (){var statearr_45047 = state_45026;
(statearr_45047[(13)] = inst_44902);

(statearr_45047[(14)] = inst_44904);

(statearr_45047[(15)] = inst_44901);

(statearr_45047[(16)] = inst_44903);

(statearr_45047[(17)] = inst_44944);

return statearr_45047;
})();
var statearr_45048_46961 = state_45026__$1;
(statearr_45048_46961[(2)] = null);

(statearr_45048_46961[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (39))){
var state_45026__$1 = state_45026;
var statearr_45058_46965 = state_45026__$1;
(statearr_45058_46965[(2)] = null);

(statearr_45058_46965[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (4))){
var inst_44891 = (state_45026[(10)]);
var inst_44891__$1 = (state_45026[(2)]);
var inst_44892 = (inst_44891__$1 == null);
var state_45026__$1 = (function (){var statearr_45065 = state_45026;
(statearr_45065[(10)] = inst_44891__$1);

return statearr_45065;
})();
if(cljs.core.truth_(inst_44892)){
var statearr_45066_46966 = state_45026__$1;
(statearr_45066_46966[(1)] = (5));

} else {
var statearr_45067_46967 = state_45026__$1;
(statearr_45067_46967[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (15))){
var inst_44902 = (state_45026[(13)]);
var inst_44904 = (state_45026[(14)]);
var inst_44901 = (state_45026[(15)]);
var inst_44903 = (state_45026[(16)]);
var inst_44919 = (state_45026[(2)]);
var inst_44920 = (inst_44904 + (1));
var tmp45053 = inst_44902;
var tmp45054 = inst_44901;
var tmp45055 = inst_44903;
var inst_44901__$1 = tmp45054;
var inst_44902__$1 = tmp45053;
var inst_44903__$1 = tmp45055;
var inst_44904__$1 = inst_44920;
var state_45026__$1 = (function (){var statearr_45072 = state_45026;
(statearr_45072[(13)] = inst_44902__$1);

(statearr_45072[(14)] = inst_44904__$1);

(statearr_45072[(15)] = inst_44901__$1);

(statearr_45072[(16)] = inst_44903__$1);

(statearr_45072[(18)] = inst_44919);

return statearr_45072;
})();
var statearr_45073_46968 = state_45026__$1;
(statearr_45073_46968[(2)] = null);

(statearr_45073_46968[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (21))){
var inst_44948 = (state_45026[(2)]);
var state_45026__$1 = state_45026;
var statearr_45077_46969 = state_45026__$1;
(statearr_45077_46969[(2)] = inst_44948);

(statearr_45077_46969[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (31))){
var inst_44975 = (state_45026[(12)]);
var inst_44979 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_44975);
var state_45026__$1 = state_45026;
var statearr_45078_46970 = state_45026__$1;
(statearr_45078_46970[(2)] = inst_44979);

(statearr_45078_46970[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (32))){
var inst_44968 = (state_45026[(9)]);
var inst_44969 = (state_45026[(19)]);
var inst_44970 = (state_45026[(11)]);
var inst_44967 = (state_45026[(20)]);
var inst_44981 = (state_45026[(2)]);
var inst_44982 = (inst_44970 + (1));
var tmp45074 = inst_44968;
var tmp45075 = inst_44969;
var tmp45076 = inst_44967;
var inst_44967__$1 = tmp45076;
var inst_44968__$1 = tmp45074;
var inst_44969__$1 = tmp45075;
var inst_44970__$1 = inst_44982;
var state_45026__$1 = (function (){var statearr_45079 = state_45026;
(statearr_45079[(9)] = inst_44968__$1);

(statearr_45079[(19)] = inst_44969__$1);

(statearr_45079[(11)] = inst_44970__$1);

(statearr_45079[(20)] = inst_44967__$1);

(statearr_45079[(21)] = inst_44981);

return statearr_45079;
})();
var statearr_45080_46972 = state_45026__$1;
(statearr_45080_46972[(2)] = null);

(statearr_45080_46972[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (40))){
var inst_44994 = (state_45026[(22)]);
var inst_44998 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_44994);
var state_45026__$1 = state_45026;
var statearr_45081_46974 = state_45026__$1;
(statearr_45081_46974[(2)] = inst_44998);

(statearr_45081_46974[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (33))){
var inst_44985 = (state_45026[(23)]);
var inst_44987 = cljs.core.chunked_seq_QMARK_(inst_44985);
var state_45026__$1 = state_45026;
if(inst_44987){
var statearr_45082_46978 = state_45026__$1;
(statearr_45082_46978[(1)] = (36));

} else {
var statearr_45083_46979 = state_45026__$1;
(statearr_45083_46979[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (13))){
var inst_44913 = (state_45026[(24)]);
var inst_44916 = cljs.core.async.close_BANG_(inst_44913);
var state_45026__$1 = state_45026;
var statearr_45084_46980 = state_45026__$1;
(statearr_45084_46980[(2)] = inst_44916);

(statearr_45084_46980[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (22))){
var inst_44938 = (state_45026[(8)]);
var inst_44941 = cljs.core.async.close_BANG_(inst_44938);
var state_45026__$1 = state_45026;
var statearr_45087_46981 = state_45026__$1;
(statearr_45087_46981[(2)] = inst_44941);

(statearr_45087_46981[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (36))){
var inst_44985 = (state_45026[(23)]);
var inst_44989 = cljs.core.chunk_first(inst_44985);
var inst_44990 = cljs.core.chunk_rest(inst_44985);
var inst_44991 = cljs.core.count(inst_44989);
var inst_44967 = inst_44990;
var inst_44968 = inst_44989;
var inst_44969 = inst_44991;
var inst_44970 = (0);
var state_45026__$1 = (function (){var statearr_45090 = state_45026;
(statearr_45090[(9)] = inst_44968);

(statearr_45090[(19)] = inst_44969);

(statearr_45090[(11)] = inst_44970);

(statearr_45090[(20)] = inst_44967);

return statearr_45090;
})();
var statearr_45091_46982 = state_45026__$1;
(statearr_45091_46982[(2)] = null);

(statearr_45091_46982[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (41))){
var inst_44985 = (state_45026[(23)]);
var inst_45000 = (state_45026[(2)]);
var inst_45001 = cljs.core.next(inst_44985);
var inst_44967 = inst_45001;
var inst_44968 = null;
var inst_44969 = (0);
var inst_44970 = (0);
var state_45026__$1 = (function (){var statearr_45092 = state_45026;
(statearr_45092[(9)] = inst_44968);

(statearr_45092[(25)] = inst_45000);

(statearr_45092[(19)] = inst_44969);

(statearr_45092[(11)] = inst_44970);

(statearr_45092[(20)] = inst_44967);

return statearr_45092;
})();
var statearr_45093_46983 = state_45026__$1;
(statearr_45093_46983[(2)] = null);

(statearr_45093_46983[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (43))){
var state_45026__$1 = state_45026;
var statearr_45094_46985 = state_45026__$1;
(statearr_45094_46985[(2)] = null);

(statearr_45094_46985[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (29))){
var inst_45009 = (state_45026[(2)]);
var state_45026__$1 = state_45026;
var statearr_45097_46986 = state_45026__$1;
(statearr_45097_46986[(2)] = inst_45009);

(statearr_45097_46986[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (44))){
var inst_45018 = (state_45026[(2)]);
var state_45026__$1 = (function (){var statearr_45099 = state_45026;
(statearr_45099[(26)] = inst_45018);

return statearr_45099;
})();
var statearr_45100_46987 = state_45026__$1;
(statearr_45100_46987[(2)] = null);

(statearr_45100_46987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (6))){
var inst_44958 = (state_45026[(27)]);
var inst_44957 = cljs.core.deref(cs);
var inst_44958__$1 = cljs.core.keys(inst_44957);
var inst_44959 = cljs.core.count(inst_44958__$1);
var inst_44960 = cljs.core.reset_BANG_(dctr,inst_44959);
var inst_44966 = cljs.core.seq(inst_44958__$1);
var inst_44967 = inst_44966;
var inst_44968 = null;
var inst_44969 = (0);
var inst_44970 = (0);
var state_45026__$1 = (function (){var statearr_45101 = state_45026;
(statearr_45101[(9)] = inst_44968);

(statearr_45101[(19)] = inst_44969);

(statearr_45101[(11)] = inst_44970);

(statearr_45101[(28)] = inst_44960);

(statearr_45101[(20)] = inst_44967);

(statearr_45101[(27)] = inst_44958__$1);

return statearr_45101;
})();
var statearr_45103_46990 = state_45026__$1;
(statearr_45103_46990[(2)] = null);

(statearr_45103_46990[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (28))){
var inst_44985 = (state_45026[(23)]);
var inst_44967 = (state_45026[(20)]);
var inst_44985__$1 = cljs.core.seq(inst_44967);
var state_45026__$1 = (function (){var statearr_45106 = state_45026;
(statearr_45106[(23)] = inst_44985__$1);

return statearr_45106;
})();
if(inst_44985__$1){
var statearr_45107_46995 = state_45026__$1;
(statearr_45107_46995[(1)] = (33));

} else {
var statearr_45108_46997 = state_45026__$1;
(statearr_45108_46997[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (25))){
var inst_44969 = (state_45026[(19)]);
var inst_44970 = (state_45026[(11)]);
var inst_44972 = (inst_44970 < inst_44969);
var inst_44973 = inst_44972;
var state_45026__$1 = state_45026;
if(cljs.core.truth_(inst_44973)){
var statearr_45109_46998 = state_45026__$1;
(statearr_45109_46998[(1)] = (27));

} else {
var statearr_45110_46999 = state_45026__$1;
(statearr_45110_46999[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (34))){
var state_45026__$1 = state_45026;
var statearr_45111_47000 = state_45026__$1;
(statearr_45111_47000[(2)] = null);

(statearr_45111_47000[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (17))){
var state_45026__$1 = state_45026;
var statearr_45112_47002 = state_45026__$1;
(statearr_45112_47002[(2)] = null);

(statearr_45112_47002[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (3))){
var inst_45023 = (state_45026[(2)]);
var state_45026__$1 = state_45026;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45026__$1,inst_45023);
} else {
if((state_val_45027 === (12))){
var inst_44953 = (state_45026[(2)]);
var state_45026__$1 = state_45026;
var statearr_45114_47003 = state_45026__$1;
(statearr_45114_47003[(2)] = inst_44953);

(statearr_45114_47003[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (2))){
var state_45026__$1 = state_45026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45026__$1,(4),ch);
} else {
if((state_val_45027 === (23))){
var state_45026__$1 = state_45026;
var statearr_45118_47008 = state_45026__$1;
(statearr_45118_47008[(2)] = null);

(statearr_45118_47008[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (35))){
var inst_45007 = (state_45026[(2)]);
var state_45026__$1 = state_45026;
var statearr_45119_47010 = state_45026__$1;
(statearr_45119_47010[(2)] = inst_45007);

(statearr_45119_47010[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (19))){
var inst_44924 = (state_45026[(7)]);
var inst_44929 = cljs.core.chunk_first(inst_44924);
var inst_44930 = cljs.core.chunk_rest(inst_44924);
var inst_44931 = cljs.core.count(inst_44929);
var inst_44901 = inst_44930;
var inst_44902 = inst_44929;
var inst_44903 = inst_44931;
var inst_44904 = (0);
var state_45026__$1 = (function (){var statearr_45120 = state_45026;
(statearr_45120[(13)] = inst_44902);

(statearr_45120[(14)] = inst_44904);

(statearr_45120[(15)] = inst_44901);

(statearr_45120[(16)] = inst_44903);

return statearr_45120;
})();
var statearr_45121_47011 = state_45026__$1;
(statearr_45121_47011[(2)] = null);

(statearr_45121_47011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (11))){
var inst_44901 = (state_45026[(15)]);
var inst_44924 = (state_45026[(7)]);
var inst_44924__$1 = cljs.core.seq(inst_44901);
var state_45026__$1 = (function (){var statearr_45124 = state_45026;
(statearr_45124[(7)] = inst_44924__$1);

return statearr_45124;
})();
if(inst_44924__$1){
var statearr_45125_47012 = state_45026__$1;
(statearr_45125_47012[(1)] = (16));

} else {
var statearr_45126_47013 = state_45026__$1;
(statearr_45126_47013[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (9))){
var inst_44955 = (state_45026[(2)]);
var state_45026__$1 = state_45026;
var statearr_45127_47014 = state_45026__$1;
(statearr_45127_47014[(2)] = inst_44955);

(statearr_45127_47014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (5))){
var inst_44899 = cljs.core.deref(cs);
var inst_44900 = cljs.core.seq(inst_44899);
var inst_44901 = inst_44900;
var inst_44902 = null;
var inst_44903 = (0);
var inst_44904 = (0);
var state_45026__$1 = (function (){var statearr_45130 = state_45026;
(statearr_45130[(13)] = inst_44902);

(statearr_45130[(14)] = inst_44904);

(statearr_45130[(15)] = inst_44901);

(statearr_45130[(16)] = inst_44903);

return statearr_45130;
})();
var statearr_45132_47017 = state_45026__$1;
(statearr_45132_47017[(2)] = null);

(statearr_45132_47017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (14))){
var state_45026__$1 = state_45026;
var statearr_45133_47018 = state_45026__$1;
(statearr_45133_47018[(2)] = null);

(statearr_45133_47018[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (45))){
var inst_45015 = (state_45026[(2)]);
var state_45026__$1 = state_45026;
var statearr_45134_47019 = state_45026__$1;
(statearr_45134_47019[(2)] = inst_45015);

(statearr_45134_47019[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (26))){
var inst_44958 = (state_45026[(27)]);
var inst_45011 = (state_45026[(2)]);
var inst_45012 = cljs.core.seq(inst_44958);
var state_45026__$1 = (function (){var statearr_45135 = state_45026;
(statearr_45135[(29)] = inst_45011);

return statearr_45135;
})();
if(inst_45012){
var statearr_45136_47020 = state_45026__$1;
(statearr_45136_47020[(1)] = (42));

} else {
var statearr_45137_47021 = state_45026__$1;
(statearr_45137_47021[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (16))){
var inst_44924 = (state_45026[(7)]);
var inst_44927 = cljs.core.chunked_seq_QMARK_(inst_44924);
var state_45026__$1 = state_45026;
if(inst_44927){
var statearr_45139_47025 = state_45026__$1;
(statearr_45139_47025[(1)] = (19));

} else {
var statearr_45140_47026 = state_45026__$1;
(statearr_45140_47026[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (38))){
var inst_45004 = (state_45026[(2)]);
var state_45026__$1 = state_45026;
var statearr_45141_47028 = state_45026__$1;
(statearr_45141_47028[(2)] = inst_45004);

(statearr_45141_47028[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (30))){
var state_45026__$1 = state_45026;
var statearr_45143_47029 = state_45026__$1;
(statearr_45143_47029[(2)] = null);

(statearr_45143_47029[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (10))){
var inst_44902 = (state_45026[(13)]);
var inst_44904 = (state_45026[(14)]);
var inst_44912 = cljs.core._nth(inst_44902,inst_44904);
var inst_44913 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44912,(0),null);
var inst_44914 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44912,(1),null);
var state_45026__$1 = (function (){var statearr_45145 = state_45026;
(statearr_45145[(24)] = inst_44913);

return statearr_45145;
})();
if(cljs.core.truth_(inst_44914)){
var statearr_45147_47031 = state_45026__$1;
(statearr_45147_47031[(1)] = (13));

} else {
var statearr_45149_47032 = state_45026__$1;
(statearr_45149_47032[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (18))){
var inst_44951 = (state_45026[(2)]);
var state_45026__$1 = state_45026;
var statearr_45150_47033 = state_45026__$1;
(statearr_45150_47033[(2)] = inst_44951);

(statearr_45150_47033[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (42))){
var state_45026__$1 = state_45026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45026__$1,(45),dchan);
} else {
if((state_val_45027 === (37))){
var inst_44985 = (state_45026[(23)]);
var inst_44891 = (state_45026[(10)]);
var inst_44994 = (state_45026[(22)]);
var inst_44994__$1 = cljs.core.first(inst_44985);
var inst_44995 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_44994__$1,inst_44891,done);
var state_45026__$1 = (function (){var statearr_45151 = state_45026;
(statearr_45151[(22)] = inst_44994__$1);

return statearr_45151;
})();
if(cljs.core.truth_(inst_44995)){
var statearr_45152_47034 = state_45026__$1;
(statearr_45152_47034[(1)] = (39));

} else {
var statearr_45153_47036 = state_45026__$1;
(statearr_45153_47036[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (8))){
var inst_44904 = (state_45026[(14)]);
var inst_44903 = (state_45026[(16)]);
var inst_44906 = (inst_44904 < inst_44903);
var inst_44907 = inst_44906;
var state_45026__$1 = state_45026;
if(cljs.core.truth_(inst_44907)){
var statearr_45154_47037 = state_45026__$1;
(statearr_45154_47037[(1)] = (10));

} else {
var statearr_45155_47038 = state_45026__$1;
(statearr_45155_47038[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__43550__auto__ = null;
var cljs$core$async$mult_$_state_machine__43550__auto____0 = (function (){
var statearr_45156 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45156[(0)] = cljs$core$async$mult_$_state_machine__43550__auto__);

(statearr_45156[(1)] = (1));

return statearr_45156;
});
var cljs$core$async$mult_$_state_machine__43550__auto____1 = (function (state_45026){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_45026);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e45157){var ex__43553__auto__ = e45157;
var statearr_45158_47040 = state_45026;
(statearr_45158_47040[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_45026[(4)]))){
var statearr_45159_47041 = state_45026;
(statearr_45159_47041[(1)] = cljs.core.first((state_45026[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47042 = state_45026;
state_45026 = G__47042;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__43550__auto__ = function(state_45026){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__43550__auto____1.call(this,state_45026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__43550__auto____0;
cljs$core$async$mult_$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__43550__auto____1;
return cljs$core$async$mult_$_state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_45164 = f__43782__auto__();
(statearr_45164[(6)] = c__43781__auto___46946);

return statearr_45164;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__45168 = arguments.length;
switch (G__45168) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_47046 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_47046(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_47054 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_47054(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_47060 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_47060(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_47067 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_47067(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_47069 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_47069(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47071 = arguments.length;
var i__4737__auto___47073 = (0);
while(true){
if((i__4737__auto___47073 < len__4736__auto___47071)){
args__4742__auto__.push((arguments[i__4737__auto___47073]));

var G__47075 = (i__4737__auto___47073 + (1));
i__4737__auto___47073 = G__47075;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__45186){
var map__45187 = p__45186;
var map__45187__$1 = (((((!((map__45187 == null))))?(((((map__45187.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45187.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45187):map__45187);
var opts = map__45187__$1;
var statearr_45189_47079 = state;
(statearr_45189_47079[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts((function (val){
var statearr_45190_47080 = state;
(statearr_45190_47080[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_45191_47081 = state;
(statearr_45191_47081[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq45182){
var G__45183 = cljs.core.first(seq45182);
var seq45182__$1 = cljs.core.next(seq45182);
var G__45184 = cljs.core.first(seq45182__$1);
var seq45182__$2 = cljs.core.next(seq45182__$1);
var G__45185 = cljs.core.first(seq45182__$2);
var seq45182__$3 = cljs.core.next(seq45182__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45183,G__45184,G__45185,seq45182__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45198 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45198 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta45199){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta45199 = meta45199;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45200,meta45199__$1){
var self__ = this;
var _45200__$1 = this;
return (new cljs.core.async.t_cljs$core$async45198(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta45199__$1));
}));

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45200){
var self__ = this;
var _45200__$1 = this;
return self__.meta45199;
}));

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45198.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta45199","meta45199",1541849713,null)], null);
}));

(cljs.core.async.t_cljs$core$async45198.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45198.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45198");

(cljs.core.async.t_cljs$core$async45198.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45198");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45198.
 */
cljs.core.async.__GT_t_cljs$core$async45198 = (function cljs$core$async$mix_$___GT_t_cljs$core$async45198(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45199){
return (new cljs.core.async.t_cljs$core$async45198(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45199));
});

}

return (new cljs.core.async.t_cljs$core$async45198(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43781__auto___47114 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_45306){
var state_val_45307 = (state_45306[(1)]);
if((state_val_45307 === (7))){
var inst_45219 = (state_45306[(2)]);
var state_45306__$1 = state_45306;
var statearr_45308_47118 = state_45306__$1;
(statearr_45308_47118[(2)] = inst_45219);

(statearr_45308_47118[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (20))){
var inst_45231 = (state_45306[(7)]);
var state_45306__$1 = state_45306;
var statearr_45309_47119 = state_45306__$1;
(statearr_45309_47119[(2)] = inst_45231);

(statearr_45309_47119[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (27))){
var state_45306__$1 = state_45306;
var statearr_45310_47120 = state_45306__$1;
(statearr_45310_47120[(2)] = null);

(statearr_45310_47120[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (1))){
var inst_45206 = (state_45306[(8)]);
var inst_45206__$1 = calc_state();
var inst_45208 = (inst_45206__$1 == null);
var inst_45209 = cljs.core.not(inst_45208);
var state_45306__$1 = (function (){var statearr_45311 = state_45306;
(statearr_45311[(8)] = inst_45206__$1);

return statearr_45311;
})();
if(inst_45209){
var statearr_45312_47122 = state_45306__$1;
(statearr_45312_47122[(1)] = (2));

} else {
var statearr_45313_47123 = state_45306__$1;
(statearr_45313_47123[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (24))){
var inst_45266 = (state_45306[(9)]);
var inst_45280 = (state_45306[(10)]);
var inst_45257 = (state_45306[(11)]);
var inst_45280__$1 = (inst_45257.cljs$core$IFn$_invoke$arity$1 ? inst_45257.cljs$core$IFn$_invoke$arity$1(inst_45266) : inst_45257.call(null,inst_45266));
var state_45306__$1 = (function (){var statearr_45314 = state_45306;
(statearr_45314[(10)] = inst_45280__$1);

return statearr_45314;
})();
if(cljs.core.truth_(inst_45280__$1)){
var statearr_45315_47133 = state_45306__$1;
(statearr_45315_47133[(1)] = (29));

} else {
var statearr_45316_47134 = state_45306__$1;
(statearr_45316_47134[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (4))){
var inst_45222 = (state_45306[(2)]);
var state_45306__$1 = state_45306;
if(cljs.core.truth_(inst_45222)){
var statearr_45317_47135 = state_45306__$1;
(statearr_45317_47135[(1)] = (8));

} else {
var statearr_45318_47136 = state_45306__$1;
(statearr_45318_47136[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (15))){
var inst_45251 = (state_45306[(2)]);
var state_45306__$1 = state_45306;
if(cljs.core.truth_(inst_45251)){
var statearr_45319_47143 = state_45306__$1;
(statearr_45319_47143[(1)] = (19));

} else {
var statearr_45320_47144 = state_45306__$1;
(statearr_45320_47144[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (21))){
var inst_45256 = (state_45306[(12)]);
var inst_45256__$1 = (state_45306[(2)]);
var inst_45257 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45256__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45258 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45256__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45259 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45256__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_45306__$1 = (function (){var statearr_45321 = state_45306;
(statearr_45321[(11)] = inst_45257);

(statearr_45321[(13)] = inst_45258);

(statearr_45321[(12)] = inst_45256__$1);

return statearr_45321;
})();
return cljs.core.async.ioc_alts_BANG_(state_45306__$1,(22),inst_45259);
} else {
if((state_val_45307 === (31))){
var inst_45288 = (state_45306[(2)]);
var state_45306__$1 = state_45306;
if(cljs.core.truth_(inst_45288)){
var statearr_45322_47150 = state_45306__$1;
(statearr_45322_47150[(1)] = (32));

} else {
var statearr_45323_47151 = state_45306__$1;
(statearr_45323_47151[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (32))){
var inst_45265 = (state_45306[(14)]);
var state_45306__$1 = state_45306;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45306__$1,(35),out,inst_45265);
} else {
if((state_val_45307 === (33))){
var inst_45256 = (state_45306[(12)]);
var inst_45231 = inst_45256;
var state_45306__$1 = (function (){var statearr_45324 = state_45306;
(statearr_45324[(7)] = inst_45231);

return statearr_45324;
})();
var statearr_45325_47157 = state_45306__$1;
(statearr_45325_47157[(2)] = null);

(statearr_45325_47157[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (13))){
var inst_45231 = (state_45306[(7)]);
var inst_45240 = inst_45231.cljs$lang$protocol_mask$partition0$;
var inst_45241 = (inst_45240 & (64));
var inst_45242 = inst_45231.cljs$core$ISeq$;
var inst_45243 = (cljs.core.PROTOCOL_SENTINEL === inst_45242);
var inst_45244 = ((inst_45241) || (inst_45243));
var state_45306__$1 = state_45306;
if(cljs.core.truth_(inst_45244)){
var statearr_45326_47158 = state_45306__$1;
(statearr_45326_47158[(1)] = (16));

} else {
var statearr_45327_47160 = state_45306__$1;
(statearr_45327_47160[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (22))){
var inst_45266 = (state_45306[(9)]);
var inst_45265 = (state_45306[(14)]);
var inst_45264 = (state_45306[(2)]);
var inst_45265__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45264,(0),null);
var inst_45266__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45264,(1),null);
var inst_45267 = (inst_45265__$1 == null);
var inst_45268 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45266__$1,change);
var inst_45269 = ((inst_45267) || (inst_45268));
var state_45306__$1 = (function (){var statearr_45329 = state_45306;
(statearr_45329[(9)] = inst_45266__$1);

(statearr_45329[(14)] = inst_45265__$1);

return statearr_45329;
})();
if(cljs.core.truth_(inst_45269)){
var statearr_45330_47169 = state_45306__$1;
(statearr_45330_47169[(1)] = (23));

} else {
var statearr_45331_47174 = state_45306__$1;
(statearr_45331_47174[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (36))){
var inst_45256 = (state_45306[(12)]);
var inst_45231 = inst_45256;
var state_45306__$1 = (function (){var statearr_45332 = state_45306;
(statearr_45332[(7)] = inst_45231);

return statearr_45332;
})();
var statearr_45333_47179 = state_45306__$1;
(statearr_45333_47179[(2)] = null);

(statearr_45333_47179[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (29))){
var inst_45280 = (state_45306[(10)]);
var state_45306__$1 = state_45306;
var statearr_45334_47184 = state_45306__$1;
(statearr_45334_47184[(2)] = inst_45280);

(statearr_45334_47184[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (6))){
var state_45306__$1 = state_45306;
var statearr_45335_47185 = state_45306__$1;
(statearr_45335_47185[(2)] = false);

(statearr_45335_47185[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (28))){
var inst_45276 = (state_45306[(2)]);
var inst_45277 = calc_state();
var inst_45231 = inst_45277;
var state_45306__$1 = (function (){var statearr_45336 = state_45306;
(statearr_45336[(7)] = inst_45231);

(statearr_45336[(15)] = inst_45276);

return statearr_45336;
})();
var statearr_45337_47186 = state_45306__$1;
(statearr_45337_47186[(2)] = null);

(statearr_45337_47186[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (25))){
var inst_45302 = (state_45306[(2)]);
var state_45306__$1 = state_45306;
var statearr_45338_47190 = state_45306__$1;
(statearr_45338_47190[(2)] = inst_45302);

(statearr_45338_47190[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (34))){
var inst_45300 = (state_45306[(2)]);
var state_45306__$1 = state_45306;
var statearr_45339_47197 = state_45306__$1;
(statearr_45339_47197[(2)] = inst_45300);

(statearr_45339_47197[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (17))){
var state_45306__$1 = state_45306;
var statearr_45340_47198 = state_45306__$1;
(statearr_45340_47198[(2)] = false);

(statearr_45340_47198[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (3))){
var state_45306__$1 = state_45306;
var statearr_45341_47199 = state_45306__$1;
(statearr_45341_47199[(2)] = false);

(statearr_45341_47199[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (12))){
var inst_45304 = (state_45306[(2)]);
var state_45306__$1 = state_45306;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45306__$1,inst_45304);
} else {
if((state_val_45307 === (2))){
var inst_45206 = (state_45306[(8)]);
var inst_45211 = inst_45206.cljs$lang$protocol_mask$partition0$;
var inst_45212 = (inst_45211 & (64));
var inst_45213 = inst_45206.cljs$core$ISeq$;
var inst_45214 = (cljs.core.PROTOCOL_SENTINEL === inst_45213);
var inst_45215 = ((inst_45212) || (inst_45214));
var state_45306__$1 = state_45306;
if(cljs.core.truth_(inst_45215)){
var statearr_45343_47200 = state_45306__$1;
(statearr_45343_47200[(1)] = (5));

} else {
var statearr_45344_47201 = state_45306__$1;
(statearr_45344_47201[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (23))){
var inst_45265 = (state_45306[(14)]);
var inst_45271 = (inst_45265 == null);
var state_45306__$1 = state_45306;
if(cljs.core.truth_(inst_45271)){
var statearr_45346_47203 = state_45306__$1;
(statearr_45346_47203[(1)] = (26));

} else {
var statearr_45347_47204 = state_45306__$1;
(statearr_45347_47204[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (35))){
var inst_45291 = (state_45306[(2)]);
var state_45306__$1 = state_45306;
if(cljs.core.truth_(inst_45291)){
var statearr_45348_47205 = state_45306__$1;
(statearr_45348_47205[(1)] = (36));

} else {
var statearr_45349_47206 = state_45306__$1;
(statearr_45349_47206[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (19))){
var inst_45231 = (state_45306[(7)]);
var inst_45253 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_45231);
var state_45306__$1 = state_45306;
var statearr_45350_47207 = state_45306__$1;
(statearr_45350_47207[(2)] = inst_45253);

(statearr_45350_47207[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (11))){
var inst_45231 = (state_45306[(7)]);
var inst_45237 = (inst_45231 == null);
var inst_45238 = cljs.core.not(inst_45237);
var state_45306__$1 = state_45306;
if(inst_45238){
var statearr_45351_47214 = state_45306__$1;
(statearr_45351_47214[(1)] = (13));

} else {
var statearr_45352_47215 = state_45306__$1;
(statearr_45352_47215[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (9))){
var inst_45206 = (state_45306[(8)]);
var state_45306__$1 = state_45306;
var statearr_45353_47216 = state_45306__$1;
(statearr_45353_47216[(2)] = inst_45206);

(statearr_45353_47216[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (5))){
var state_45306__$1 = state_45306;
var statearr_45360_47217 = state_45306__$1;
(statearr_45360_47217[(2)] = true);

(statearr_45360_47217[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (14))){
var state_45306__$1 = state_45306;
var statearr_45361_47222 = state_45306__$1;
(statearr_45361_47222[(2)] = false);

(statearr_45361_47222[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (26))){
var inst_45266 = (state_45306[(9)]);
var inst_45273 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_45266);
var state_45306__$1 = state_45306;
var statearr_45362_47231 = state_45306__$1;
(statearr_45362_47231[(2)] = inst_45273);

(statearr_45362_47231[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (16))){
var state_45306__$1 = state_45306;
var statearr_45363_47232 = state_45306__$1;
(statearr_45363_47232[(2)] = true);

(statearr_45363_47232[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (38))){
var inst_45296 = (state_45306[(2)]);
var state_45306__$1 = state_45306;
var statearr_45364_47237 = state_45306__$1;
(statearr_45364_47237[(2)] = inst_45296);

(statearr_45364_47237[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (30))){
var inst_45266 = (state_45306[(9)]);
var inst_45257 = (state_45306[(11)]);
var inst_45258 = (state_45306[(13)]);
var inst_45283 = cljs.core.empty_QMARK_(inst_45257);
var inst_45284 = (inst_45258.cljs$core$IFn$_invoke$arity$1 ? inst_45258.cljs$core$IFn$_invoke$arity$1(inst_45266) : inst_45258.call(null,inst_45266));
var inst_45285 = cljs.core.not(inst_45284);
var inst_45286 = ((inst_45283) && (inst_45285));
var state_45306__$1 = state_45306;
var statearr_45365_47239 = state_45306__$1;
(statearr_45365_47239[(2)] = inst_45286);

(statearr_45365_47239[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (10))){
var inst_45206 = (state_45306[(8)]);
var inst_45227 = (state_45306[(2)]);
var inst_45228 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45227,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45229 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45227,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45230 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45227,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_45231 = inst_45206;
var state_45306__$1 = (function (){var statearr_45366 = state_45306;
(statearr_45366[(16)] = inst_45230);

(statearr_45366[(17)] = inst_45228);

(statearr_45366[(18)] = inst_45229);

(statearr_45366[(7)] = inst_45231);

return statearr_45366;
})();
var statearr_45368_47246 = state_45306__$1;
(statearr_45368_47246[(2)] = null);

(statearr_45368_47246[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (18))){
var inst_45248 = (state_45306[(2)]);
var state_45306__$1 = state_45306;
var statearr_45369_47247 = state_45306__$1;
(statearr_45369_47247[(2)] = inst_45248);

(statearr_45369_47247[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (37))){
var state_45306__$1 = state_45306;
var statearr_45371_47253 = state_45306__$1;
(statearr_45371_47253[(2)] = null);

(statearr_45371_47253[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45307 === (8))){
var inst_45206 = (state_45306[(8)]);
var inst_45224 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_45206);
var state_45306__$1 = state_45306;
var statearr_45372_47254 = state_45306__$1;
(statearr_45372_47254[(2)] = inst_45224);

(statearr_45372_47254[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__43550__auto__ = null;
var cljs$core$async$mix_$_state_machine__43550__auto____0 = (function (){
var statearr_45373 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45373[(0)] = cljs$core$async$mix_$_state_machine__43550__auto__);

(statearr_45373[(1)] = (1));

return statearr_45373;
});
var cljs$core$async$mix_$_state_machine__43550__auto____1 = (function (state_45306){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_45306);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e45374){var ex__43553__auto__ = e45374;
var statearr_45375_47261 = state_45306;
(statearr_45375_47261[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_45306[(4)]))){
var statearr_45376_47264 = state_45306;
(statearr_45376_47264[(1)] = cljs.core.first((state_45306[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47265 = state_45306;
state_45306 = G__47265;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__43550__auto__ = function(state_45306){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__43550__auto____1.call(this,state_45306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__43550__auto____0;
cljs$core$async$mix_$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__43550__auto____1;
return cljs$core$async$mix_$_state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_45377 = f__43782__auto__();
(statearr_45377[(6)] = c__43781__auto___47114);

return statearr_45377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_47274 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_47274(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_47275 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_47275(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_47294 = (function() {
var G__47295 = null;
var G__47295__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__47295__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__47295 = function(p,v){
switch(arguments.length){
case 1:
return G__47295__1.call(this,p);
case 2:
return G__47295__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47295.cljs$core$IFn$_invoke$arity$1 = G__47295__1;
G__47295.cljs$core$IFn$_invoke$arity$2 = G__47295__2;
return G__47295;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__45395 = arguments.length;
switch (G__45395) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_47294(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_47294(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__45406 = arguments.length;
switch (G__45406) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__45399_SHARP_){
if(cljs.core.truth_((p1__45399_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__45399_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__45399_SHARP_.call(null,topic)))){
return p1__45399_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__45399_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45407 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45407 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta45408){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta45408 = meta45408;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45407.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45409,meta45408__$1){
var self__ = this;
var _45409__$1 = this;
return (new cljs.core.async.t_cljs$core$async45407(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta45408__$1));
}));

(cljs.core.async.t_cljs$core$async45407.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45409){
var self__ = this;
var _45409__$1 = this;
return self__.meta45408;
}));

(cljs.core.async.t_cljs$core$async45407.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45407.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async45407.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45407.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async45407.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async45407.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async45407.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async45407.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta45408","meta45408",-1555599490,null)], null);
}));

(cljs.core.async.t_cljs$core$async45407.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45407.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45407");

(cljs.core.async.t_cljs$core$async45407.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45407");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45407.
 */
cljs.core.async.__GT_t_cljs$core$async45407 = (function cljs$core$async$__GT_t_cljs$core$async45407(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta45408){
return (new cljs.core.async.t_cljs$core$async45407(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta45408));
});

}

return (new cljs.core.async.t_cljs$core$async45407(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43781__auto___47305 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_45492){
var state_val_45493 = (state_45492[(1)]);
if((state_val_45493 === (7))){
var inst_45488 = (state_45492[(2)]);
var state_45492__$1 = state_45492;
var statearr_45494_47310 = state_45492__$1;
(statearr_45494_47310[(2)] = inst_45488);

(statearr_45494_47310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (20))){
var state_45492__$1 = state_45492;
var statearr_45495_47311 = state_45492__$1;
(statearr_45495_47311[(2)] = null);

(statearr_45495_47311[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (1))){
var state_45492__$1 = state_45492;
var statearr_45496_47312 = state_45492__$1;
(statearr_45496_47312[(2)] = null);

(statearr_45496_47312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (24))){
var inst_45471 = (state_45492[(7)]);
var inst_45480 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_45471);
var state_45492__$1 = state_45492;
var statearr_45497_47313 = state_45492__$1;
(statearr_45497_47313[(2)] = inst_45480);

(statearr_45497_47313[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (4))){
var inst_45421 = (state_45492[(8)]);
var inst_45421__$1 = (state_45492[(2)]);
var inst_45422 = (inst_45421__$1 == null);
var state_45492__$1 = (function (){var statearr_45499 = state_45492;
(statearr_45499[(8)] = inst_45421__$1);

return statearr_45499;
})();
if(cljs.core.truth_(inst_45422)){
var statearr_45500_47315 = state_45492__$1;
(statearr_45500_47315[(1)] = (5));

} else {
var statearr_45501_47316 = state_45492__$1;
(statearr_45501_47316[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (15))){
var inst_45463 = (state_45492[(2)]);
var state_45492__$1 = state_45492;
var statearr_45503_47317 = state_45492__$1;
(statearr_45503_47317[(2)] = inst_45463);

(statearr_45503_47317[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (21))){
var inst_45485 = (state_45492[(2)]);
var state_45492__$1 = (function (){var statearr_45505 = state_45492;
(statearr_45505[(9)] = inst_45485);

return statearr_45505;
})();
var statearr_45506_47319 = state_45492__$1;
(statearr_45506_47319[(2)] = null);

(statearr_45506_47319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (13))){
var inst_45445 = (state_45492[(10)]);
var inst_45447 = cljs.core.chunked_seq_QMARK_(inst_45445);
var state_45492__$1 = state_45492;
if(inst_45447){
var statearr_45508_47320 = state_45492__$1;
(statearr_45508_47320[(1)] = (16));

} else {
var statearr_45509_47321 = state_45492__$1;
(statearr_45509_47321[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (22))){
var inst_45477 = (state_45492[(2)]);
var state_45492__$1 = state_45492;
if(cljs.core.truth_(inst_45477)){
var statearr_45511_47322 = state_45492__$1;
(statearr_45511_47322[(1)] = (23));

} else {
var statearr_45512_47324 = state_45492__$1;
(statearr_45512_47324[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (6))){
var inst_45473 = (state_45492[(11)]);
var inst_45421 = (state_45492[(8)]);
var inst_45471 = (state_45492[(7)]);
var inst_45471__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_45421) : topic_fn.call(null,inst_45421));
var inst_45472 = cljs.core.deref(mults);
var inst_45473__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45472,inst_45471__$1);
var state_45492__$1 = (function (){var statearr_45513 = state_45492;
(statearr_45513[(11)] = inst_45473__$1);

(statearr_45513[(7)] = inst_45471__$1);

return statearr_45513;
})();
if(cljs.core.truth_(inst_45473__$1)){
var statearr_45514_47325 = state_45492__$1;
(statearr_45514_47325[(1)] = (19));

} else {
var statearr_45515_47326 = state_45492__$1;
(statearr_45515_47326[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (25))){
var inst_45482 = (state_45492[(2)]);
var state_45492__$1 = state_45492;
var statearr_45516_47328 = state_45492__$1;
(statearr_45516_47328[(2)] = inst_45482);

(statearr_45516_47328[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (17))){
var inst_45445 = (state_45492[(10)]);
var inst_45454 = cljs.core.first(inst_45445);
var inst_45455 = cljs.core.async.muxch_STAR_(inst_45454);
var inst_45456 = cljs.core.async.close_BANG_(inst_45455);
var inst_45457 = cljs.core.next(inst_45445);
var inst_45431 = inst_45457;
var inst_45432 = null;
var inst_45433 = (0);
var inst_45434 = (0);
var state_45492__$1 = (function (){var statearr_45519 = state_45492;
(statearr_45519[(12)] = inst_45432);

(statearr_45519[(13)] = inst_45433);

(statearr_45519[(14)] = inst_45434);

(statearr_45519[(15)] = inst_45431);

(statearr_45519[(16)] = inst_45456);

return statearr_45519;
})();
var statearr_45520_47329 = state_45492__$1;
(statearr_45520_47329[(2)] = null);

(statearr_45520_47329[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (3))){
var inst_45490 = (state_45492[(2)]);
var state_45492__$1 = state_45492;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45492__$1,inst_45490);
} else {
if((state_val_45493 === (12))){
var inst_45466 = (state_45492[(2)]);
var state_45492__$1 = state_45492;
var statearr_45523_47330 = state_45492__$1;
(statearr_45523_47330[(2)] = inst_45466);

(statearr_45523_47330[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (2))){
var state_45492__$1 = state_45492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45492__$1,(4),ch);
} else {
if((state_val_45493 === (23))){
var state_45492__$1 = state_45492;
var statearr_45526_47331 = state_45492__$1;
(statearr_45526_47331[(2)] = null);

(statearr_45526_47331[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (19))){
var inst_45473 = (state_45492[(11)]);
var inst_45421 = (state_45492[(8)]);
var inst_45475 = cljs.core.async.muxch_STAR_(inst_45473);
var state_45492__$1 = state_45492;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45492__$1,(22),inst_45475,inst_45421);
} else {
if((state_val_45493 === (11))){
var inst_45445 = (state_45492[(10)]);
var inst_45431 = (state_45492[(15)]);
var inst_45445__$1 = cljs.core.seq(inst_45431);
var state_45492__$1 = (function (){var statearr_45527 = state_45492;
(statearr_45527[(10)] = inst_45445__$1);

return statearr_45527;
})();
if(inst_45445__$1){
var statearr_45528_47333 = state_45492__$1;
(statearr_45528_47333[(1)] = (13));

} else {
var statearr_45529_47334 = state_45492__$1;
(statearr_45529_47334[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (9))){
var inst_45469 = (state_45492[(2)]);
var state_45492__$1 = state_45492;
var statearr_45530_47335 = state_45492__$1;
(statearr_45530_47335[(2)] = inst_45469);

(statearr_45530_47335[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (5))){
var inst_45428 = cljs.core.deref(mults);
var inst_45429 = cljs.core.vals(inst_45428);
var inst_45430 = cljs.core.seq(inst_45429);
var inst_45431 = inst_45430;
var inst_45432 = null;
var inst_45433 = (0);
var inst_45434 = (0);
var state_45492__$1 = (function (){var statearr_45531 = state_45492;
(statearr_45531[(12)] = inst_45432);

(statearr_45531[(13)] = inst_45433);

(statearr_45531[(14)] = inst_45434);

(statearr_45531[(15)] = inst_45431);

return statearr_45531;
})();
var statearr_45532_47340 = state_45492__$1;
(statearr_45532_47340[(2)] = null);

(statearr_45532_47340[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (14))){
var state_45492__$1 = state_45492;
var statearr_45536_47342 = state_45492__$1;
(statearr_45536_47342[(2)] = null);

(statearr_45536_47342[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (16))){
var inst_45445 = (state_45492[(10)]);
var inst_45449 = cljs.core.chunk_first(inst_45445);
var inst_45450 = cljs.core.chunk_rest(inst_45445);
var inst_45451 = cljs.core.count(inst_45449);
var inst_45431 = inst_45450;
var inst_45432 = inst_45449;
var inst_45433 = inst_45451;
var inst_45434 = (0);
var state_45492__$1 = (function (){var statearr_45537 = state_45492;
(statearr_45537[(12)] = inst_45432);

(statearr_45537[(13)] = inst_45433);

(statearr_45537[(14)] = inst_45434);

(statearr_45537[(15)] = inst_45431);

return statearr_45537;
})();
var statearr_45538_47343 = state_45492__$1;
(statearr_45538_47343[(2)] = null);

(statearr_45538_47343[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (10))){
var inst_45432 = (state_45492[(12)]);
var inst_45433 = (state_45492[(13)]);
var inst_45434 = (state_45492[(14)]);
var inst_45431 = (state_45492[(15)]);
var inst_45439 = cljs.core._nth(inst_45432,inst_45434);
var inst_45440 = cljs.core.async.muxch_STAR_(inst_45439);
var inst_45441 = cljs.core.async.close_BANG_(inst_45440);
var inst_45442 = (inst_45434 + (1));
var tmp45533 = inst_45432;
var tmp45534 = inst_45433;
var tmp45535 = inst_45431;
var inst_45431__$1 = tmp45535;
var inst_45432__$1 = tmp45533;
var inst_45433__$1 = tmp45534;
var inst_45434__$1 = inst_45442;
var state_45492__$1 = (function (){var statearr_45539 = state_45492;
(statearr_45539[(12)] = inst_45432__$1);

(statearr_45539[(13)] = inst_45433__$1);

(statearr_45539[(14)] = inst_45434__$1);

(statearr_45539[(17)] = inst_45441);

(statearr_45539[(15)] = inst_45431__$1);

return statearr_45539;
})();
var statearr_45540_47344 = state_45492__$1;
(statearr_45540_47344[(2)] = null);

(statearr_45540_47344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (18))){
var inst_45460 = (state_45492[(2)]);
var state_45492__$1 = state_45492;
var statearr_45541_47345 = state_45492__$1;
(statearr_45541_47345[(2)] = inst_45460);

(statearr_45541_47345[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45493 === (8))){
var inst_45433 = (state_45492[(13)]);
var inst_45434 = (state_45492[(14)]);
var inst_45436 = (inst_45434 < inst_45433);
var inst_45437 = inst_45436;
var state_45492__$1 = state_45492;
if(cljs.core.truth_(inst_45437)){
var statearr_45543_47346 = state_45492__$1;
(statearr_45543_47346[(1)] = (10));

} else {
var statearr_45544_47347 = state_45492__$1;
(statearr_45544_47347[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43550__auto__ = null;
var cljs$core$async$state_machine__43550__auto____0 = (function (){
var statearr_45545 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45545[(0)] = cljs$core$async$state_machine__43550__auto__);

(statearr_45545[(1)] = (1));

return statearr_45545;
});
var cljs$core$async$state_machine__43550__auto____1 = (function (state_45492){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_45492);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e45546){var ex__43553__auto__ = e45546;
var statearr_45547_47350 = state_45492;
(statearr_45547_47350[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_45492[(4)]))){
var statearr_45548_47353 = state_45492;
(statearr_45548_47353[(1)] = cljs.core.first((state_45492[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47354 = state_45492;
state_45492 = G__47354;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$state_machine__43550__auto__ = function(state_45492){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43550__auto____1.call(this,state_45492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43550__auto____0;
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43550__auto____1;
return cljs$core$async$state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_45549 = f__43782__auto__();
(statearr_45549[(6)] = c__43781__auto___47305);

return statearr_45549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__45551 = arguments.length;
switch (G__45551) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__45555 = arguments.length;
switch (G__45555) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__45557 = arguments.length;
switch (G__45557) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__43781__auto___47377 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_45609){
var state_val_45610 = (state_45609[(1)]);
if((state_val_45610 === (7))){
var state_45609__$1 = state_45609;
var statearr_45635_47378 = state_45609__$1;
(statearr_45635_47378[(2)] = null);

(statearr_45635_47378[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45610 === (1))){
var state_45609__$1 = state_45609;
var statearr_45636_47379 = state_45609__$1;
(statearr_45636_47379[(2)] = null);

(statearr_45636_47379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45610 === (4))){
var inst_45566 = (state_45609[(7)]);
var inst_45565 = (state_45609[(8)]);
var inst_45568 = (inst_45566 < inst_45565);
var state_45609__$1 = state_45609;
if(cljs.core.truth_(inst_45568)){
var statearr_45641_47380 = state_45609__$1;
(statearr_45641_47380[(1)] = (6));

} else {
var statearr_45642_47381 = state_45609__$1;
(statearr_45642_47381[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45610 === (15))){
var inst_45591 = (state_45609[(9)]);
var inst_45600 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_45591);
var state_45609__$1 = state_45609;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45609__$1,(17),out,inst_45600);
} else {
if((state_val_45610 === (13))){
var inst_45591 = (state_45609[(9)]);
var inst_45591__$1 = (state_45609[(2)]);
var inst_45592 = cljs.core.some(cljs.core.nil_QMARK_,inst_45591__$1);
var state_45609__$1 = (function (){var statearr_45647 = state_45609;
(statearr_45647[(9)] = inst_45591__$1);

return statearr_45647;
})();
if(cljs.core.truth_(inst_45592)){
var statearr_45648_47386 = state_45609__$1;
(statearr_45648_47386[(1)] = (14));

} else {
var statearr_45653_47387 = state_45609__$1;
(statearr_45653_47387[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45610 === (6))){
var state_45609__$1 = state_45609;
var statearr_45654_47388 = state_45609__$1;
(statearr_45654_47388[(2)] = null);

(statearr_45654_47388[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45610 === (17))){
var inst_45602 = (state_45609[(2)]);
var state_45609__$1 = (function (){var statearr_45663 = state_45609;
(statearr_45663[(10)] = inst_45602);

return statearr_45663;
})();
var statearr_45664_47393 = state_45609__$1;
(statearr_45664_47393[(2)] = null);

(statearr_45664_47393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45610 === (3))){
var inst_45607 = (state_45609[(2)]);
var state_45609__$1 = state_45609;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45609__$1,inst_45607);
} else {
if((state_val_45610 === (12))){
var _ = (function (){var statearr_45665 = state_45609;
(statearr_45665[(4)] = cljs.core.rest((state_45609[(4)])));

return statearr_45665;
})();
var state_45609__$1 = state_45609;
var ex45662 = (state_45609__$1[(2)]);
var statearr_45667_47398 = state_45609__$1;
(statearr_45667_47398[(5)] = ex45662);


if((ex45662 instanceof Object)){
var statearr_45668_47399 = state_45609__$1;
(statearr_45668_47399[(1)] = (11));

(statearr_45668_47399[(5)] = null);

} else {
throw ex45662;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45610 === (2))){
var inst_45564 = cljs.core.reset_BANG_(dctr,cnt);
var inst_45565 = cnt;
var inst_45566 = (0);
var state_45609__$1 = (function (){var statearr_45670 = state_45609;
(statearr_45670[(7)] = inst_45566);

(statearr_45670[(8)] = inst_45565);

(statearr_45670[(11)] = inst_45564);

return statearr_45670;
})();
var statearr_45671_47400 = state_45609__$1;
(statearr_45671_47400[(2)] = null);

(statearr_45671_47400[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45610 === (11))){
var inst_45570 = (state_45609[(2)]);
var inst_45571 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_45609__$1 = (function (){var statearr_45672 = state_45609;
(statearr_45672[(12)] = inst_45570);

return statearr_45672;
})();
var statearr_45673_47405 = state_45609__$1;
(statearr_45673_47405[(2)] = inst_45571);

(statearr_45673_47405[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45610 === (9))){
var inst_45566 = (state_45609[(7)]);
var _ = (function (){var statearr_45674 = state_45609;
(statearr_45674[(4)] = cljs.core.cons((12),(state_45609[(4)])));

return statearr_45674;
})();
var inst_45577 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_45566) : chs__$1.call(null,inst_45566));
var inst_45578 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_45566) : done.call(null,inst_45566));
var inst_45579 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_45577,inst_45578);
var ___$1 = (function (){var statearr_45675 = state_45609;
(statearr_45675[(4)] = cljs.core.rest((state_45609[(4)])));

return statearr_45675;
})();
var state_45609__$1 = state_45609;
var statearr_45678_47411 = state_45609__$1;
(statearr_45678_47411[(2)] = inst_45579);

(statearr_45678_47411[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45610 === (5))){
var inst_45589 = (state_45609[(2)]);
var state_45609__$1 = (function (){var statearr_45681 = state_45609;
(statearr_45681[(13)] = inst_45589);

return statearr_45681;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45609__$1,(13),dchan);
} else {
if((state_val_45610 === (14))){
var inst_45598 = cljs.core.async.close_BANG_(out);
var state_45609__$1 = state_45609;
var statearr_45682_47413 = state_45609__$1;
(statearr_45682_47413[(2)] = inst_45598);

(statearr_45682_47413[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45610 === (16))){
var inst_45605 = (state_45609[(2)]);
var state_45609__$1 = state_45609;
var statearr_45683_47418 = state_45609__$1;
(statearr_45683_47418[(2)] = inst_45605);

(statearr_45683_47418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45610 === (10))){
var inst_45566 = (state_45609[(7)]);
var inst_45582 = (state_45609[(2)]);
var inst_45583 = (inst_45566 + (1));
var inst_45566__$1 = inst_45583;
var state_45609__$1 = (function (){var statearr_45684 = state_45609;
(statearr_45684[(14)] = inst_45582);

(statearr_45684[(7)] = inst_45566__$1);

return statearr_45684;
})();
var statearr_45685_47423 = state_45609__$1;
(statearr_45685_47423[(2)] = null);

(statearr_45685_47423[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45610 === (8))){
var inst_45587 = (state_45609[(2)]);
var state_45609__$1 = state_45609;
var statearr_45686_47424 = state_45609__$1;
(statearr_45686_47424[(2)] = inst_45587);

(statearr_45686_47424[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43550__auto__ = null;
var cljs$core$async$state_machine__43550__auto____0 = (function (){
var statearr_45687 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45687[(0)] = cljs$core$async$state_machine__43550__auto__);

(statearr_45687[(1)] = (1));

return statearr_45687;
});
var cljs$core$async$state_machine__43550__auto____1 = (function (state_45609){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_45609);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e45688){var ex__43553__auto__ = e45688;
var statearr_45689_47425 = state_45609;
(statearr_45689_47425[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_45609[(4)]))){
var statearr_45690_47426 = state_45609;
(statearr_45690_47426[(1)] = cljs.core.first((state_45609[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47427 = state_45609;
state_45609 = G__47427;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$state_machine__43550__auto__ = function(state_45609){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43550__auto____1.call(this,state_45609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43550__auto____0;
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43550__auto____1;
return cljs$core$async$state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_45693 = f__43782__auto__();
(statearr_45693[(6)] = c__43781__auto___47377);

return statearr_45693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__45697 = arguments.length;
switch (G__45697) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43781__auto___47431 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_45734){
var state_val_45735 = (state_45734[(1)]);
if((state_val_45735 === (7))){
var inst_45710 = (state_45734[(7)]);
var inst_45708 = (state_45734[(8)]);
var inst_45708__$1 = (state_45734[(2)]);
var inst_45710__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45708__$1,(0),null);
var inst_45711 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45708__$1,(1),null);
var inst_45715 = (inst_45710__$1 == null);
var state_45734__$1 = (function (){var statearr_45745 = state_45734;
(statearr_45745[(7)] = inst_45710__$1);

(statearr_45745[(9)] = inst_45711);

(statearr_45745[(8)] = inst_45708__$1);

return statearr_45745;
})();
if(cljs.core.truth_(inst_45715)){
var statearr_45746_47433 = state_45734__$1;
(statearr_45746_47433[(1)] = (8));

} else {
var statearr_45748_47434 = state_45734__$1;
(statearr_45748_47434[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45735 === (1))){
var inst_45698 = cljs.core.vec(chs);
var inst_45699 = inst_45698;
var state_45734__$1 = (function (){var statearr_45752 = state_45734;
(statearr_45752[(10)] = inst_45699);

return statearr_45752;
})();
var statearr_45754_47435 = state_45734__$1;
(statearr_45754_47435[(2)] = null);

(statearr_45754_47435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45735 === (4))){
var inst_45699 = (state_45734[(10)]);
var state_45734__$1 = state_45734;
return cljs.core.async.ioc_alts_BANG_(state_45734__$1,(7),inst_45699);
} else {
if((state_val_45735 === (6))){
var inst_45729 = (state_45734[(2)]);
var state_45734__$1 = state_45734;
var statearr_45756_47440 = state_45734__$1;
(statearr_45756_47440[(2)] = inst_45729);

(statearr_45756_47440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45735 === (3))){
var inst_45731 = (state_45734[(2)]);
var state_45734__$1 = state_45734;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45734__$1,inst_45731);
} else {
if((state_val_45735 === (2))){
var inst_45699 = (state_45734[(10)]);
var inst_45701 = cljs.core.count(inst_45699);
var inst_45702 = (inst_45701 > (0));
var state_45734__$1 = state_45734;
if(cljs.core.truth_(inst_45702)){
var statearr_45760_47442 = state_45734__$1;
(statearr_45760_47442[(1)] = (4));

} else {
var statearr_45761_47443 = state_45734__$1;
(statearr_45761_47443[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45735 === (11))){
var inst_45699 = (state_45734[(10)]);
var inst_45722 = (state_45734[(2)]);
var tmp45759 = inst_45699;
var inst_45699__$1 = tmp45759;
var state_45734__$1 = (function (){var statearr_45762 = state_45734;
(statearr_45762[(10)] = inst_45699__$1);

(statearr_45762[(11)] = inst_45722);

return statearr_45762;
})();
var statearr_45763_47444 = state_45734__$1;
(statearr_45763_47444[(2)] = null);

(statearr_45763_47444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45735 === (9))){
var inst_45710 = (state_45734[(7)]);
var state_45734__$1 = state_45734;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45734__$1,(11),out,inst_45710);
} else {
if((state_val_45735 === (5))){
var inst_45727 = cljs.core.async.close_BANG_(out);
var state_45734__$1 = state_45734;
var statearr_45769_47445 = state_45734__$1;
(statearr_45769_47445[(2)] = inst_45727);

(statearr_45769_47445[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45735 === (10))){
var inst_45725 = (state_45734[(2)]);
var state_45734__$1 = state_45734;
var statearr_45770_47446 = state_45734__$1;
(statearr_45770_47446[(2)] = inst_45725);

(statearr_45770_47446[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45735 === (8))){
var inst_45710 = (state_45734[(7)]);
var inst_45711 = (state_45734[(9)]);
var inst_45708 = (state_45734[(8)]);
var inst_45699 = (state_45734[(10)]);
var inst_45717 = (function (){var cs = inst_45699;
var vec__45704 = inst_45708;
var v = inst_45710;
var c = inst_45711;
return (function (p1__45695_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__45695_SHARP_);
});
})();
var inst_45718 = cljs.core.filterv(inst_45717,inst_45699);
var inst_45699__$1 = inst_45718;
var state_45734__$1 = (function (){var statearr_45773 = state_45734;
(statearr_45773[(10)] = inst_45699__$1);

return statearr_45773;
})();
var statearr_45774_47448 = state_45734__$1;
(statearr_45774_47448[(2)] = null);

(statearr_45774_47448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43550__auto__ = null;
var cljs$core$async$state_machine__43550__auto____0 = (function (){
var statearr_45775 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45775[(0)] = cljs$core$async$state_machine__43550__auto__);

(statearr_45775[(1)] = (1));

return statearr_45775;
});
var cljs$core$async$state_machine__43550__auto____1 = (function (state_45734){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_45734);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e45779){var ex__43553__auto__ = e45779;
var statearr_45780_47450 = state_45734;
(statearr_45780_47450[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_45734[(4)]))){
var statearr_45782_47452 = state_45734;
(statearr_45782_47452[(1)] = cljs.core.first((state_45734[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47455 = state_45734;
state_45734 = G__47455;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$state_machine__43550__auto__ = function(state_45734){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43550__auto____1.call(this,state_45734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43550__auto____0;
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43550__auto____1;
return cljs$core$async$state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_45784 = f__43782__auto__();
(statearr_45784[(6)] = c__43781__auto___47431);

return statearr_45784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__45786 = arguments.length;
switch (G__45786) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43781__auto___47464 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_45820){
var state_val_45821 = (state_45820[(1)]);
if((state_val_45821 === (7))){
var inst_45802 = (state_45820[(7)]);
var inst_45802__$1 = (state_45820[(2)]);
var inst_45803 = (inst_45802__$1 == null);
var inst_45804 = cljs.core.not(inst_45803);
var state_45820__$1 = (function (){var statearr_45823 = state_45820;
(statearr_45823[(7)] = inst_45802__$1);

return statearr_45823;
})();
if(inst_45804){
var statearr_45824_47465 = state_45820__$1;
(statearr_45824_47465[(1)] = (8));

} else {
var statearr_45825_47466 = state_45820__$1;
(statearr_45825_47466[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45821 === (1))){
var inst_45797 = (0);
var state_45820__$1 = (function (){var statearr_45826 = state_45820;
(statearr_45826[(8)] = inst_45797);

return statearr_45826;
})();
var statearr_45827_47470 = state_45820__$1;
(statearr_45827_47470[(2)] = null);

(statearr_45827_47470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45821 === (4))){
var state_45820__$1 = state_45820;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45820__$1,(7),ch);
} else {
if((state_val_45821 === (6))){
var inst_45815 = (state_45820[(2)]);
var state_45820__$1 = state_45820;
var statearr_45828_47477 = state_45820__$1;
(statearr_45828_47477[(2)] = inst_45815);

(statearr_45828_47477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45821 === (3))){
var inst_45817 = (state_45820[(2)]);
var inst_45818 = cljs.core.async.close_BANG_(out);
var state_45820__$1 = (function (){var statearr_45829 = state_45820;
(statearr_45829[(9)] = inst_45817);

return statearr_45829;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45820__$1,inst_45818);
} else {
if((state_val_45821 === (2))){
var inst_45797 = (state_45820[(8)]);
var inst_45799 = (inst_45797 < n);
var state_45820__$1 = state_45820;
if(cljs.core.truth_(inst_45799)){
var statearr_45830_47480 = state_45820__$1;
(statearr_45830_47480[(1)] = (4));

} else {
var statearr_45832_47481 = state_45820__$1;
(statearr_45832_47481[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45821 === (11))){
var inst_45797 = (state_45820[(8)]);
var inst_45807 = (state_45820[(2)]);
var inst_45808 = (inst_45797 + (1));
var inst_45797__$1 = inst_45808;
var state_45820__$1 = (function (){var statearr_45833 = state_45820;
(statearr_45833[(10)] = inst_45807);

(statearr_45833[(8)] = inst_45797__$1);

return statearr_45833;
})();
var statearr_45834_47485 = state_45820__$1;
(statearr_45834_47485[(2)] = null);

(statearr_45834_47485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45821 === (9))){
var state_45820__$1 = state_45820;
var statearr_45835_47490 = state_45820__$1;
(statearr_45835_47490[(2)] = null);

(statearr_45835_47490[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45821 === (5))){
var state_45820__$1 = state_45820;
var statearr_45836_47494 = state_45820__$1;
(statearr_45836_47494[(2)] = null);

(statearr_45836_47494[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45821 === (10))){
var inst_45812 = (state_45820[(2)]);
var state_45820__$1 = state_45820;
var statearr_45837_47500 = state_45820__$1;
(statearr_45837_47500[(2)] = inst_45812);

(statearr_45837_47500[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45821 === (8))){
var inst_45802 = (state_45820[(7)]);
var state_45820__$1 = state_45820;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45820__$1,(11),out,inst_45802);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43550__auto__ = null;
var cljs$core$async$state_machine__43550__auto____0 = (function (){
var statearr_45838 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45838[(0)] = cljs$core$async$state_machine__43550__auto__);

(statearr_45838[(1)] = (1));

return statearr_45838;
});
var cljs$core$async$state_machine__43550__auto____1 = (function (state_45820){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_45820);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e45839){var ex__43553__auto__ = e45839;
var statearr_45842_47511 = state_45820;
(statearr_45842_47511[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_45820[(4)]))){
var statearr_45843_47513 = state_45820;
(statearr_45843_47513[(1)] = cljs.core.first((state_45820[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47516 = state_45820;
state_45820 = G__47516;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$state_machine__43550__auto__ = function(state_45820){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43550__auto____1.call(this,state_45820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43550__auto____0;
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43550__auto____1;
return cljs$core$async$state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_45844 = f__43782__auto__();
(statearr_45844[(6)] = c__43781__auto___47464);

return statearr_45844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45846 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45846 = (function (f,ch,meta45847){
this.f = f;
this.ch = ch;
this.meta45847 = meta45847;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45848,meta45847__$1){
var self__ = this;
var _45848__$1 = this;
return (new cljs.core.async.t_cljs$core$async45846(self__.f,self__.ch,meta45847__$1));
}));

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45848){
var self__ = this;
var _45848__$1 = this;
return self__.meta45847;
}));

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45858 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45858 = (function (f,ch,meta45847,_,fn1,meta45859){
this.f = f;
this.ch = ch;
this.meta45847 = meta45847;
this._ = _;
this.fn1 = fn1;
this.meta45859 = meta45859;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45858.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45860,meta45859__$1){
var self__ = this;
var _45860__$1 = this;
return (new cljs.core.async.t_cljs$core$async45858(self__.f,self__.ch,self__.meta45847,self__._,self__.fn1,meta45859__$1));
}));

(cljs.core.async.t_cljs$core$async45858.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45860){
var self__ = this;
var _45860__$1 = this;
return self__.meta45859;
}));

(cljs.core.async.t_cljs$core$async45858.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45858.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async45858.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45858.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__45845_SHARP_){
var G__45865 = (((p1__45845_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__45845_SHARP_) : self__.f.call(null,p1__45845_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__45865) : f1.call(null,G__45865));
});
}));

(cljs.core.async.t_cljs$core$async45858.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45847","meta45847",1508364703,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async45846","cljs.core.async/t_cljs$core$async45846",732718130,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta45859","meta45859",-734017720,null)], null);
}));

(cljs.core.async.t_cljs$core$async45858.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45858.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45858");

(cljs.core.async.t_cljs$core$async45858.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45858");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45858.
 */
cljs.core.async.__GT_t_cljs$core$async45858 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45858(f__$1,ch__$1,meta45847__$1,___$2,fn1__$1,meta45859){
return (new cljs.core.async.t_cljs$core$async45858(f__$1,ch__$1,meta45847__$1,___$2,fn1__$1,meta45859));
});

}

return (new cljs.core.async.t_cljs$core$async45858(self__.f,self__.ch,self__.meta45847,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__45866 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__45866) : self__.f.call(null,G__45866));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async45846.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45847","meta45847",1508364703,null)], null);
}));

(cljs.core.async.t_cljs$core$async45846.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45846.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45846");

(cljs.core.async.t_cljs$core$async45846.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45846");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45846.
 */
cljs.core.async.__GT_t_cljs$core$async45846 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45846(f__$1,ch__$1,meta45847){
return (new cljs.core.async.t_cljs$core$async45846(f__$1,ch__$1,meta45847));
});

}

return (new cljs.core.async.t_cljs$core$async45846(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45867 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45867 = (function (f,ch,meta45868){
this.f = f;
this.ch = ch;
this.meta45868 = meta45868;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45867.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45869,meta45868__$1){
var self__ = this;
var _45869__$1 = this;
return (new cljs.core.async.t_cljs$core$async45867(self__.f,self__.ch,meta45868__$1));
}));

(cljs.core.async.t_cljs$core$async45867.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45869){
var self__ = this;
var _45869__$1 = this;
return self__.meta45868;
}));

(cljs.core.async.t_cljs$core$async45867.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45867.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45867.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45867.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45867.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45867.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async45867.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45868","meta45868",780263372,null)], null);
}));

(cljs.core.async.t_cljs$core$async45867.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45867.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45867");

(cljs.core.async.t_cljs$core$async45867.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45867");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45867.
 */
cljs.core.async.__GT_t_cljs$core$async45867 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async45867(f__$1,ch__$1,meta45868){
return (new cljs.core.async.t_cljs$core$async45867(f__$1,ch__$1,meta45868));
});

}

return (new cljs.core.async.t_cljs$core$async45867(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45876 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45876 = (function (p,ch,meta45877){
this.p = p;
this.ch = ch;
this.meta45877 = meta45877;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45876.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45878,meta45877__$1){
var self__ = this;
var _45878__$1 = this;
return (new cljs.core.async.t_cljs$core$async45876(self__.p,self__.ch,meta45877__$1));
}));

(cljs.core.async.t_cljs$core$async45876.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45878){
var self__ = this;
var _45878__$1 = this;
return self__.meta45877;
}));

(cljs.core.async.t_cljs$core$async45876.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45876.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45876.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45876.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45876.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45876.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45876.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async45876.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45877","meta45877",2092321043,null)], null);
}));

(cljs.core.async.t_cljs$core$async45876.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45876.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45876");

(cljs.core.async.t_cljs$core$async45876.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45876");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45876.
 */
cljs.core.async.__GT_t_cljs$core$async45876 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async45876(p__$1,ch__$1,meta45877){
return (new cljs.core.async.t_cljs$core$async45876(p__$1,ch__$1,meta45877));
});

}

return (new cljs.core.async.t_cljs$core$async45876(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__45886 = arguments.length;
switch (G__45886) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43781__auto___47633 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_45912){
var state_val_45913 = (state_45912[(1)]);
if((state_val_45913 === (7))){
var inst_45906 = (state_45912[(2)]);
var state_45912__$1 = state_45912;
var statearr_45922_47641 = state_45912__$1;
(statearr_45922_47641[(2)] = inst_45906);

(statearr_45922_47641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (1))){
var state_45912__$1 = state_45912;
var statearr_45925_47649 = state_45912__$1;
(statearr_45925_47649[(2)] = null);

(statearr_45925_47649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (4))){
var inst_45889 = (state_45912[(7)]);
var inst_45889__$1 = (state_45912[(2)]);
var inst_45890 = (inst_45889__$1 == null);
var state_45912__$1 = (function (){var statearr_45926 = state_45912;
(statearr_45926[(7)] = inst_45889__$1);

return statearr_45926;
})();
if(cljs.core.truth_(inst_45890)){
var statearr_45927_47657 = state_45912__$1;
(statearr_45927_47657[(1)] = (5));

} else {
var statearr_45928_47658 = state_45912__$1;
(statearr_45928_47658[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (6))){
var inst_45889 = (state_45912[(7)]);
var inst_45894 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_45889) : p.call(null,inst_45889));
var state_45912__$1 = state_45912;
if(cljs.core.truth_(inst_45894)){
var statearr_45930_47661 = state_45912__$1;
(statearr_45930_47661[(1)] = (8));

} else {
var statearr_45931_47662 = state_45912__$1;
(statearr_45931_47662[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (3))){
var inst_45908 = (state_45912[(2)]);
var state_45912__$1 = state_45912;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45912__$1,inst_45908);
} else {
if((state_val_45913 === (2))){
var state_45912__$1 = state_45912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45912__$1,(4),ch);
} else {
if((state_val_45913 === (11))){
var inst_45900 = (state_45912[(2)]);
var state_45912__$1 = state_45912;
var statearr_45932_47666 = state_45912__$1;
(statearr_45932_47666[(2)] = inst_45900);

(statearr_45932_47666[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (9))){
var state_45912__$1 = state_45912;
var statearr_45937_47667 = state_45912__$1;
(statearr_45937_47667[(2)] = null);

(statearr_45937_47667[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (5))){
var inst_45892 = cljs.core.async.close_BANG_(out);
var state_45912__$1 = state_45912;
var statearr_45938_47669 = state_45912__$1;
(statearr_45938_47669[(2)] = inst_45892);

(statearr_45938_47669[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (10))){
var inst_45903 = (state_45912[(2)]);
var state_45912__$1 = (function (){var statearr_45939 = state_45912;
(statearr_45939[(8)] = inst_45903);

return statearr_45939;
})();
var statearr_45940_47673 = state_45912__$1;
(statearr_45940_47673[(2)] = null);

(statearr_45940_47673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (8))){
var inst_45889 = (state_45912[(7)]);
var state_45912__$1 = state_45912;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45912__$1,(11),out,inst_45889);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43550__auto__ = null;
var cljs$core$async$state_machine__43550__auto____0 = (function (){
var statearr_45941 = [null,null,null,null,null,null,null,null,null];
(statearr_45941[(0)] = cljs$core$async$state_machine__43550__auto__);

(statearr_45941[(1)] = (1));

return statearr_45941;
});
var cljs$core$async$state_machine__43550__auto____1 = (function (state_45912){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_45912);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e45942){var ex__43553__auto__ = e45942;
var statearr_45943_47677 = state_45912;
(statearr_45943_47677[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_45912[(4)]))){
var statearr_45944_47678 = state_45912;
(statearr_45944_47678[(1)] = cljs.core.first((state_45912[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47683 = state_45912;
state_45912 = G__47683;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$state_machine__43550__auto__ = function(state_45912){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43550__auto____1.call(this,state_45912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43550__auto____0;
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43550__auto____1;
return cljs$core$async$state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_45945 = f__43782__auto__();
(statearr_45945[(6)] = c__43781__auto___47633);

return statearr_45945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__45947 = arguments.length;
switch (G__45947) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__43781__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_46010){
var state_val_46011 = (state_46010[(1)]);
if((state_val_46011 === (7))){
var inst_46006 = (state_46010[(2)]);
var state_46010__$1 = state_46010;
var statearr_46012_47706 = state_46010__$1;
(statearr_46012_47706[(2)] = inst_46006);

(statearr_46012_47706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (20))){
var inst_45976 = (state_46010[(7)]);
var inst_45987 = (state_46010[(2)]);
var inst_45988 = cljs.core.next(inst_45976);
var inst_45962 = inst_45988;
var inst_45963 = null;
var inst_45964 = (0);
var inst_45965 = (0);
var state_46010__$1 = (function (){var statearr_46013 = state_46010;
(statearr_46013[(8)] = inst_45964);

(statearr_46013[(9)] = inst_45963);

(statearr_46013[(10)] = inst_45962);

(statearr_46013[(11)] = inst_45987);

(statearr_46013[(12)] = inst_45965);

return statearr_46013;
})();
var statearr_46014_47718 = state_46010__$1;
(statearr_46014_47718[(2)] = null);

(statearr_46014_47718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (1))){
var state_46010__$1 = state_46010;
var statearr_46015_47722 = state_46010__$1;
(statearr_46015_47722[(2)] = null);

(statearr_46015_47722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (4))){
var inst_45951 = (state_46010[(13)]);
var inst_45951__$1 = (state_46010[(2)]);
var inst_45952 = (inst_45951__$1 == null);
var state_46010__$1 = (function (){var statearr_46016 = state_46010;
(statearr_46016[(13)] = inst_45951__$1);

return statearr_46016;
})();
if(cljs.core.truth_(inst_45952)){
var statearr_46017_47728 = state_46010__$1;
(statearr_46017_47728[(1)] = (5));

} else {
var statearr_46018_47730 = state_46010__$1;
(statearr_46018_47730[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (15))){
var state_46010__$1 = state_46010;
var statearr_46022_47733 = state_46010__$1;
(statearr_46022_47733[(2)] = null);

(statearr_46022_47733[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (21))){
var state_46010__$1 = state_46010;
var statearr_46023_47739 = state_46010__$1;
(statearr_46023_47739[(2)] = null);

(statearr_46023_47739[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (13))){
var inst_45964 = (state_46010[(8)]);
var inst_45963 = (state_46010[(9)]);
var inst_45962 = (state_46010[(10)]);
var inst_45965 = (state_46010[(12)]);
var inst_45972 = (state_46010[(2)]);
var inst_45973 = (inst_45965 + (1));
var tmp46019 = inst_45964;
var tmp46020 = inst_45963;
var tmp46021 = inst_45962;
var inst_45962__$1 = tmp46021;
var inst_45963__$1 = tmp46020;
var inst_45964__$1 = tmp46019;
var inst_45965__$1 = inst_45973;
var state_46010__$1 = (function (){var statearr_46024 = state_46010;
(statearr_46024[(8)] = inst_45964__$1);

(statearr_46024[(9)] = inst_45963__$1);

(statearr_46024[(10)] = inst_45962__$1);

(statearr_46024[(14)] = inst_45972);

(statearr_46024[(12)] = inst_45965__$1);

return statearr_46024;
})();
var statearr_46025_47751 = state_46010__$1;
(statearr_46025_47751[(2)] = null);

(statearr_46025_47751[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (22))){
var state_46010__$1 = state_46010;
var statearr_46026_47752 = state_46010__$1;
(statearr_46026_47752[(2)] = null);

(statearr_46026_47752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (6))){
var inst_45951 = (state_46010[(13)]);
var inst_45960 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_45951) : f.call(null,inst_45951));
var inst_45961 = cljs.core.seq(inst_45960);
var inst_45962 = inst_45961;
var inst_45963 = null;
var inst_45964 = (0);
var inst_45965 = (0);
var state_46010__$1 = (function (){var statearr_46027 = state_46010;
(statearr_46027[(8)] = inst_45964);

(statearr_46027[(9)] = inst_45963);

(statearr_46027[(10)] = inst_45962);

(statearr_46027[(12)] = inst_45965);

return statearr_46027;
})();
var statearr_46028_47753 = state_46010__$1;
(statearr_46028_47753[(2)] = null);

(statearr_46028_47753[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (17))){
var inst_45976 = (state_46010[(7)]);
var inst_45980 = cljs.core.chunk_first(inst_45976);
var inst_45981 = cljs.core.chunk_rest(inst_45976);
var inst_45982 = cljs.core.count(inst_45980);
var inst_45962 = inst_45981;
var inst_45963 = inst_45980;
var inst_45964 = inst_45982;
var inst_45965 = (0);
var state_46010__$1 = (function (){var statearr_46030 = state_46010;
(statearr_46030[(8)] = inst_45964);

(statearr_46030[(9)] = inst_45963);

(statearr_46030[(10)] = inst_45962);

(statearr_46030[(12)] = inst_45965);

return statearr_46030;
})();
var statearr_46031_47758 = state_46010__$1;
(statearr_46031_47758[(2)] = null);

(statearr_46031_47758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (3))){
var inst_46008 = (state_46010[(2)]);
var state_46010__$1 = state_46010;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46010__$1,inst_46008);
} else {
if((state_val_46011 === (12))){
var inst_45996 = (state_46010[(2)]);
var state_46010__$1 = state_46010;
var statearr_46032_47760 = state_46010__$1;
(statearr_46032_47760[(2)] = inst_45996);

(statearr_46032_47760[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (2))){
var state_46010__$1 = state_46010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46010__$1,(4),in$);
} else {
if((state_val_46011 === (23))){
var inst_46004 = (state_46010[(2)]);
var state_46010__$1 = state_46010;
var statearr_46033_47761 = state_46010__$1;
(statearr_46033_47761[(2)] = inst_46004);

(statearr_46033_47761[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (19))){
var inst_45991 = (state_46010[(2)]);
var state_46010__$1 = state_46010;
var statearr_46034_47762 = state_46010__$1;
(statearr_46034_47762[(2)] = inst_45991);

(statearr_46034_47762[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (11))){
var inst_45962 = (state_46010[(10)]);
var inst_45976 = (state_46010[(7)]);
var inst_45976__$1 = cljs.core.seq(inst_45962);
var state_46010__$1 = (function (){var statearr_46035 = state_46010;
(statearr_46035[(7)] = inst_45976__$1);

return statearr_46035;
})();
if(inst_45976__$1){
var statearr_46036_47763 = state_46010__$1;
(statearr_46036_47763[(1)] = (14));

} else {
var statearr_46038_47766 = state_46010__$1;
(statearr_46038_47766[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (9))){
var inst_45998 = (state_46010[(2)]);
var inst_45999 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_46010__$1 = (function (){var statearr_46039 = state_46010;
(statearr_46039[(15)] = inst_45998);

return statearr_46039;
})();
if(cljs.core.truth_(inst_45999)){
var statearr_46040_47767 = state_46010__$1;
(statearr_46040_47767[(1)] = (21));

} else {
var statearr_46042_47769 = state_46010__$1;
(statearr_46042_47769[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (5))){
var inst_45954 = cljs.core.async.close_BANG_(out);
var state_46010__$1 = state_46010;
var statearr_46043_47774 = state_46010__$1;
(statearr_46043_47774[(2)] = inst_45954);

(statearr_46043_47774[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (14))){
var inst_45976 = (state_46010[(7)]);
var inst_45978 = cljs.core.chunked_seq_QMARK_(inst_45976);
var state_46010__$1 = state_46010;
if(inst_45978){
var statearr_46044_47780 = state_46010__$1;
(statearr_46044_47780[(1)] = (17));

} else {
var statearr_46045_47782 = state_46010__$1;
(statearr_46045_47782[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (16))){
var inst_45994 = (state_46010[(2)]);
var state_46010__$1 = state_46010;
var statearr_46046_47788 = state_46010__$1;
(statearr_46046_47788[(2)] = inst_45994);

(statearr_46046_47788[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46011 === (10))){
var inst_45963 = (state_46010[(9)]);
var inst_45965 = (state_46010[(12)]);
var inst_45970 = cljs.core._nth(inst_45963,inst_45965);
var state_46010__$1 = state_46010;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46010__$1,(13),out,inst_45970);
} else {
if((state_val_46011 === (18))){
var inst_45976 = (state_46010[(7)]);
var inst_45985 = cljs.core.first(inst_45976);
var state_46010__$1 = state_46010;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46010__$1,(20),out,inst_45985);
} else {
if((state_val_46011 === (8))){
var inst_45964 = (state_46010[(8)]);
var inst_45965 = (state_46010[(12)]);
var inst_45967 = (inst_45965 < inst_45964);
var inst_45968 = inst_45967;
var state_46010__$1 = state_46010;
if(cljs.core.truth_(inst_45968)){
var statearr_46047_47811 = state_46010__$1;
(statearr_46047_47811[(1)] = (10));

} else {
var statearr_46048_47812 = state_46010__$1;
(statearr_46048_47812[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__43550__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__43550__auto____0 = (function (){
var statearr_46049 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46049[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__43550__auto__);

(statearr_46049[(1)] = (1));

return statearr_46049;
});
var cljs$core$async$mapcat_STAR__$_state_machine__43550__auto____1 = (function (state_46010){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_46010);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e46050){var ex__43553__auto__ = e46050;
var statearr_46051_47818 = state_46010;
(statearr_46051_47818[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_46010[(4)]))){
var statearr_46052_47819 = state_46010;
(statearr_46052_47819[(1)] = cljs.core.first((state_46010[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47821 = state_46010;
state_46010 = G__47821;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__43550__auto__ = function(state_46010){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__43550__auto____1.call(this,state_46010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__43550__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__43550__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_46053 = f__43782__auto__();
(statearr_46053[(6)] = c__43781__auto__);

return statearr_46053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));

return c__43781__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__46055 = arguments.length;
switch (G__46055) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__46058 = arguments.length;
switch (G__46058) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__46064 = arguments.length;
switch (G__46064) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43781__auto___47826 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_46089){
var state_val_46090 = (state_46089[(1)]);
if((state_val_46090 === (7))){
var inst_46084 = (state_46089[(2)]);
var state_46089__$1 = state_46089;
var statearr_46091_47829 = state_46089__$1;
(statearr_46091_47829[(2)] = inst_46084);

(statearr_46091_47829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46090 === (1))){
var inst_46066 = null;
var state_46089__$1 = (function (){var statearr_46092 = state_46089;
(statearr_46092[(7)] = inst_46066);

return statearr_46092;
})();
var statearr_46093_47832 = state_46089__$1;
(statearr_46093_47832[(2)] = null);

(statearr_46093_47832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46090 === (4))){
var inst_46069 = (state_46089[(8)]);
var inst_46069__$1 = (state_46089[(2)]);
var inst_46070 = (inst_46069__$1 == null);
var inst_46071 = cljs.core.not(inst_46070);
var state_46089__$1 = (function (){var statearr_46094 = state_46089;
(statearr_46094[(8)] = inst_46069__$1);

return statearr_46094;
})();
if(inst_46071){
var statearr_46095_47833 = state_46089__$1;
(statearr_46095_47833[(1)] = (5));

} else {
var statearr_46096_47834 = state_46089__$1;
(statearr_46096_47834[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46090 === (6))){
var state_46089__$1 = state_46089;
var statearr_46097_47835 = state_46089__$1;
(statearr_46097_47835[(2)] = null);

(statearr_46097_47835[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46090 === (3))){
var inst_46086 = (state_46089[(2)]);
var inst_46087 = cljs.core.async.close_BANG_(out);
var state_46089__$1 = (function (){var statearr_46098 = state_46089;
(statearr_46098[(9)] = inst_46086);

return statearr_46098;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46089__$1,inst_46087);
} else {
if((state_val_46090 === (2))){
var state_46089__$1 = state_46089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46089__$1,(4),ch);
} else {
if((state_val_46090 === (11))){
var inst_46069 = (state_46089[(8)]);
var inst_46078 = (state_46089[(2)]);
var inst_46066 = inst_46069;
var state_46089__$1 = (function (){var statearr_46099 = state_46089;
(statearr_46099[(7)] = inst_46066);

(statearr_46099[(10)] = inst_46078);

return statearr_46099;
})();
var statearr_46100_47838 = state_46089__$1;
(statearr_46100_47838[(2)] = null);

(statearr_46100_47838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46090 === (9))){
var inst_46069 = (state_46089[(8)]);
var state_46089__$1 = state_46089;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46089__$1,(11),out,inst_46069);
} else {
if((state_val_46090 === (5))){
var inst_46066 = (state_46089[(7)]);
var inst_46069 = (state_46089[(8)]);
var inst_46073 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46069,inst_46066);
var state_46089__$1 = state_46089;
if(inst_46073){
var statearr_46103_47841 = state_46089__$1;
(statearr_46103_47841[(1)] = (8));

} else {
var statearr_46104_47842 = state_46089__$1;
(statearr_46104_47842[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46090 === (10))){
var inst_46081 = (state_46089[(2)]);
var state_46089__$1 = state_46089;
var statearr_46105_47843 = state_46089__$1;
(statearr_46105_47843[(2)] = inst_46081);

(statearr_46105_47843[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46090 === (8))){
var inst_46066 = (state_46089[(7)]);
var tmp46102 = inst_46066;
var inst_46066__$1 = tmp46102;
var state_46089__$1 = (function (){var statearr_46108 = state_46089;
(statearr_46108[(7)] = inst_46066__$1);

return statearr_46108;
})();
var statearr_46109_47844 = state_46089__$1;
(statearr_46109_47844[(2)] = null);

(statearr_46109_47844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43550__auto__ = null;
var cljs$core$async$state_machine__43550__auto____0 = (function (){
var statearr_46110 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46110[(0)] = cljs$core$async$state_machine__43550__auto__);

(statearr_46110[(1)] = (1));

return statearr_46110;
});
var cljs$core$async$state_machine__43550__auto____1 = (function (state_46089){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_46089);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e46111){var ex__43553__auto__ = e46111;
var statearr_46112_47845 = state_46089;
(statearr_46112_47845[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_46089[(4)]))){
var statearr_46113_47846 = state_46089;
(statearr_46113_47846[(1)] = cljs.core.first((state_46089[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47850 = state_46089;
state_46089 = G__47850;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$state_machine__43550__auto__ = function(state_46089){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43550__auto____1.call(this,state_46089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43550__auto____0;
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43550__auto____1;
return cljs$core$async$state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_46114 = f__43782__auto__();
(statearr_46114[(6)] = c__43781__auto___47826);

return statearr_46114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__46116 = arguments.length;
switch (G__46116) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43781__auto___47853 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_46158){
var state_val_46159 = (state_46158[(1)]);
if((state_val_46159 === (7))){
var inst_46154 = (state_46158[(2)]);
var state_46158__$1 = state_46158;
var statearr_46168_47854 = state_46158__$1;
(statearr_46168_47854[(2)] = inst_46154);

(statearr_46168_47854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46159 === (1))){
var inst_46117 = (new Array(n));
var inst_46118 = inst_46117;
var inst_46119 = (0);
var state_46158__$1 = (function (){var statearr_46169 = state_46158;
(statearr_46169[(7)] = inst_46119);

(statearr_46169[(8)] = inst_46118);

return statearr_46169;
})();
var statearr_46170_47865 = state_46158__$1;
(statearr_46170_47865[(2)] = null);

(statearr_46170_47865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46159 === (4))){
var inst_46122 = (state_46158[(9)]);
var inst_46122__$1 = (state_46158[(2)]);
var inst_46123 = (inst_46122__$1 == null);
var inst_46124 = cljs.core.not(inst_46123);
var state_46158__$1 = (function (){var statearr_46171 = state_46158;
(statearr_46171[(9)] = inst_46122__$1);

return statearr_46171;
})();
if(inst_46124){
var statearr_46172_47875 = state_46158__$1;
(statearr_46172_47875[(1)] = (5));

} else {
var statearr_46173_47880 = state_46158__$1;
(statearr_46173_47880[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46159 === (15))){
var inst_46148 = (state_46158[(2)]);
var state_46158__$1 = state_46158;
var statearr_46174_47882 = state_46158__$1;
(statearr_46174_47882[(2)] = inst_46148);

(statearr_46174_47882[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46159 === (13))){
var state_46158__$1 = state_46158;
var statearr_46175_47883 = state_46158__$1;
(statearr_46175_47883[(2)] = null);

(statearr_46175_47883[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46159 === (6))){
var inst_46119 = (state_46158[(7)]);
var inst_46144 = (inst_46119 > (0));
var state_46158__$1 = state_46158;
if(cljs.core.truth_(inst_46144)){
var statearr_46176_47888 = state_46158__$1;
(statearr_46176_47888[(1)] = (12));

} else {
var statearr_46177_47889 = state_46158__$1;
(statearr_46177_47889[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46159 === (3))){
var inst_46156 = (state_46158[(2)]);
var state_46158__$1 = state_46158;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46158__$1,inst_46156);
} else {
if((state_val_46159 === (12))){
var inst_46118 = (state_46158[(8)]);
var inst_46146 = cljs.core.vec(inst_46118);
var state_46158__$1 = state_46158;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46158__$1,(15),out,inst_46146);
} else {
if((state_val_46159 === (2))){
var state_46158__$1 = state_46158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46158__$1,(4),ch);
} else {
if((state_val_46159 === (11))){
var inst_46138 = (state_46158[(2)]);
var inst_46139 = (new Array(n));
var inst_46118 = inst_46139;
var inst_46119 = (0);
var state_46158__$1 = (function (){var statearr_46178 = state_46158;
(statearr_46178[(7)] = inst_46119);

(statearr_46178[(8)] = inst_46118);

(statearr_46178[(10)] = inst_46138);

return statearr_46178;
})();
var statearr_46179_47903 = state_46158__$1;
(statearr_46179_47903[(2)] = null);

(statearr_46179_47903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46159 === (9))){
var inst_46118 = (state_46158[(8)]);
var inst_46136 = cljs.core.vec(inst_46118);
var state_46158__$1 = state_46158;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46158__$1,(11),out,inst_46136);
} else {
if((state_val_46159 === (5))){
var inst_46119 = (state_46158[(7)]);
var inst_46127 = (state_46158[(11)]);
var inst_46118 = (state_46158[(8)]);
var inst_46122 = (state_46158[(9)]);
var inst_46126 = (inst_46118[inst_46119] = inst_46122);
var inst_46127__$1 = (inst_46119 + (1));
var inst_46128 = (inst_46127__$1 < n);
var state_46158__$1 = (function (){var statearr_46180 = state_46158;
(statearr_46180[(12)] = inst_46126);

(statearr_46180[(11)] = inst_46127__$1);

return statearr_46180;
})();
if(cljs.core.truth_(inst_46128)){
var statearr_46181_47917 = state_46158__$1;
(statearr_46181_47917[(1)] = (8));

} else {
var statearr_46182_47918 = state_46158__$1;
(statearr_46182_47918[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46159 === (14))){
var inst_46151 = (state_46158[(2)]);
var inst_46152 = cljs.core.async.close_BANG_(out);
var state_46158__$1 = (function (){var statearr_46184 = state_46158;
(statearr_46184[(13)] = inst_46151);

return statearr_46184;
})();
var statearr_46185_47919 = state_46158__$1;
(statearr_46185_47919[(2)] = inst_46152);

(statearr_46185_47919[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46159 === (10))){
var inst_46142 = (state_46158[(2)]);
var state_46158__$1 = state_46158;
var statearr_46186_47924 = state_46158__$1;
(statearr_46186_47924[(2)] = inst_46142);

(statearr_46186_47924[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46159 === (8))){
var inst_46127 = (state_46158[(11)]);
var inst_46118 = (state_46158[(8)]);
var tmp46183 = inst_46118;
var inst_46118__$1 = tmp46183;
var inst_46119 = inst_46127;
var state_46158__$1 = (function (){var statearr_46187 = state_46158;
(statearr_46187[(7)] = inst_46119);

(statearr_46187[(8)] = inst_46118__$1);

return statearr_46187;
})();
var statearr_46188_47931 = state_46158__$1;
(statearr_46188_47931[(2)] = null);

(statearr_46188_47931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43550__auto__ = null;
var cljs$core$async$state_machine__43550__auto____0 = (function (){
var statearr_46190 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46190[(0)] = cljs$core$async$state_machine__43550__auto__);

(statearr_46190[(1)] = (1));

return statearr_46190;
});
var cljs$core$async$state_machine__43550__auto____1 = (function (state_46158){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_46158);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e46192){var ex__43553__auto__ = e46192;
var statearr_46195_47940 = state_46158;
(statearr_46195_47940[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_46158[(4)]))){
var statearr_46196_47945 = state_46158;
(statearr_46196_47945[(1)] = cljs.core.first((state_46158[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47946 = state_46158;
state_46158 = G__47946;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$state_machine__43550__auto__ = function(state_46158){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43550__auto____1.call(this,state_46158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43550__auto____0;
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43550__auto____1;
return cljs$core$async$state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_46198 = f__43782__auto__();
(statearr_46198[(6)] = c__43781__auto___47853);

return statearr_46198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__46200 = arguments.length;
switch (G__46200) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43781__auto___47948 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_46246){
var state_val_46247 = (state_46246[(1)]);
if((state_val_46247 === (7))){
var inst_46242 = (state_46246[(2)]);
var state_46246__$1 = state_46246;
var statearr_46250_47949 = state_46246__$1;
(statearr_46250_47949[(2)] = inst_46242);

(statearr_46250_47949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46247 === (1))){
var inst_46201 = [];
var inst_46202 = inst_46201;
var inst_46203 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_46246__$1 = (function (){var statearr_46251 = state_46246;
(statearr_46251[(7)] = inst_46203);

(statearr_46251[(8)] = inst_46202);

return statearr_46251;
})();
var statearr_46256_47950 = state_46246__$1;
(statearr_46256_47950[(2)] = null);

(statearr_46256_47950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46247 === (4))){
var inst_46208 = (state_46246[(9)]);
var inst_46208__$1 = (state_46246[(2)]);
var inst_46209 = (inst_46208__$1 == null);
var inst_46210 = cljs.core.not(inst_46209);
var state_46246__$1 = (function (){var statearr_46257 = state_46246;
(statearr_46257[(9)] = inst_46208__$1);

return statearr_46257;
})();
if(inst_46210){
var statearr_46260_47951 = state_46246__$1;
(statearr_46260_47951[(1)] = (5));

} else {
var statearr_46261_47952 = state_46246__$1;
(statearr_46261_47952[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46247 === (15))){
var inst_46236 = (state_46246[(2)]);
var state_46246__$1 = state_46246;
var statearr_46264_47955 = state_46246__$1;
(statearr_46264_47955[(2)] = inst_46236);

(statearr_46264_47955[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46247 === (13))){
var state_46246__$1 = state_46246;
var statearr_46267_47956 = state_46246__$1;
(statearr_46267_47956[(2)] = null);

(statearr_46267_47956[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46247 === (6))){
var inst_46202 = (state_46246[(8)]);
var inst_46231 = inst_46202.length;
var inst_46232 = (inst_46231 > (0));
var state_46246__$1 = state_46246;
if(cljs.core.truth_(inst_46232)){
var statearr_46268_47957 = state_46246__$1;
(statearr_46268_47957[(1)] = (12));

} else {
var statearr_46269_47958 = state_46246__$1;
(statearr_46269_47958[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46247 === (3))){
var inst_46244 = (state_46246[(2)]);
var state_46246__$1 = state_46246;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46246__$1,inst_46244);
} else {
if((state_val_46247 === (12))){
var inst_46202 = (state_46246[(8)]);
var inst_46234 = cljs.core.vec(inst_46202);
var state_46246__$1 = state_46246;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46246__$1,(15),out,inst_46234);
} else {
if((state_val_46247 === (2))){
var state_46246__$1 = state_46246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46246__$1,(4),ch);
} else {
if((state_val_46247 === (11))){
var inst_46208 = (state_46246[(9)]);
var inst_46212 = (state_46246[(10)]);
var inst_46222 = (state_46246[(2)]);
var inst_46223 = [];
var inst_46226 = inst_46223.push(inst_46208);
var inst_46202 = inst_46223;
var inst_46203 = inst_46212;
var state_46246__$1 = (function (){var statearr_46276 = state_46246;
(statearr_46276[(7)] = inst_46203);

(statearr_46276[(11)] = inst_46222);

(statearr_46276[(12)] = inst_46226);

(statearr_46276[(8)] = inst_46202);

return statearr_46276;
})();
var statearr_46279_47962 = state_46246__$1;
(statearr_46279_47962[(2)] = null);

(statearr_46279_47962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46247 === (9))){
var inst_46202 = (state_46246[(8)]);
var inst_46220 = cljs.core.vec(inst_46202);
var state_46246__$1 = state_46246;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46246__$1,(11),out,inst_46220);
} else {
if((state_val_46247 === (5))){
var inst_46203 = (state_46246[(7)]);
var inst_46208 = (state_46246[(9)]);
var inst_46212 = (state_46246[(10)]);
var inst_46212__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_46208) : f.call(null,inst_46208));
var inst_46213 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46212__$1,inst_46203);
var inst_46214 = cljs.core.keyword_identical_QMARK_(inst_46203,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_46215 = ((inst_46213) || (inst_46214));
var state_46246__$1 = (function (){var statearr_46282 = state_46246;
(statearr_46282[(10)] = inst_46212__$1);

return statearr_46282;
})();
if(cljs.core.truth_(inst_46215)){
var statearr_46284_47963 = state_46246__$1;
(statearr_46284_47963[(1)] = (8));

} else {
var statearr_46285_47964 = state_46246__$1;
(statearr_46285_47964[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46247 === (14))){
var inst_46239 = (state_46246[(2)]);
var inst_46240 = cljs.core.async.close_BANG_(out);
var state_46246__$1 = (function (){var statearr_46287 = state_46246;
(statearr_46287[(13)] = inst_46239);

return statearr_46287;
})();
var statearr_46288_47967 = state_46246__$1;
(statearr_46288_47967[(2)] = inst_46240);

(statearr_46288_47967[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46247 === (10))){
var inst_46229 = (state_46246[(2)]);
var state_46246__$1 = state_46246;
var statearr_46289_47968 = state_46246__$1;
(statearr_46289_47968[(2)] = inst_46229);

(statearr_46289_47968[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46247 === (8))){
var inst_46208 = (state_46246[(9)]);
var inst_46212 = (state_46246[(10)]);
var inst_46202 = (state_46246[(8)]);
var inst_46217 = inst_46202.push(inst_46208);
var tmp46286 = inst_46202;
var inst_46202__$1 = tmp46286;
var inst_46203 = inst_46212;
var state_46246__$1 = (function (){var statearr_46290 = state_46246;
(statearr_46290[(7)] = inst_46203);

(statearr_46290[(14)] = inst_46217);

(statearr_46290[(8)] = inst_46202__$1);

return statearr_46290;
})();
var statearr_46292_47969 = state_46246__$1;
(statearr_46292_47969[(2)] = null);

(statearr_46292_47969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43550__auto__ = null;
var cljs$core$async$state_machine__43550__auto____0 = (function (){
var statearr_46297 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46297[(0)] = cljs$core$async$state_machine__43550__auto__);

(statearr_46297[(1)] = (1));

return statearr_46297;
});
var cljs$core$async$state_machine__43550__auto____1 = (function (state_46246){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_46246);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e46298){var ex__43553__auto__ = e46298;
var statearr_46299_47975 = state_46246;
(statearr_46299_47975[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_46246[(4)]))){
var statearr_46302_47976 = state_46246;
(statearr_46302_47976[(1)] = cljs.core.first((state_46246[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47977 = state_46246;
state_46246 = G__47977;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs$core$async$state_machine__43550__auto__ = function(state_46246){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43550__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43550__auto____1.call(this,state_46246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43550__auto____0;
cljs$core$async$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43550__auto____1;
return cljs$core$async$state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_46307 = f__43782__auto__();
(statearr_46307[(6)] = c__43781__auto___47948);

return statearr_46307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
