goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_47303 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_47303(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_47304 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_47304(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__46363 = coll;
var G__46364 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__46363,G__46364) : shadow.dom.lazy_native_coll_seq.call(null,G__46363,G__46364));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__46385 = arguments.length;
switch (G__46385) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__46389 = arguments.length;
switch (G__46389) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__46393 = arguments.length;
switch (G__46393) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__46401 = arguments.length;
switch (G__46401) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__46407 = arguments.length;
switch (G__46407) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__46417 = arguments.length;
switch (G__46417) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e46422){if((e46422 instanceof Object)){
var e = e46422;
return console.log("didnt support attachEvent",el,e);
} else {
throw e46422;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__46436 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__46437 = null;
var count__46438 = (0);
var i__46439 = (0);
while(true){
if((i__46439 < count__46438)){
var el = chunk__46437.cljs$core$IIndexed$_nth$arity$2(null,i__46439);
var handler_47351__$1 = ((function (seq__46436,chunk__46437,count__46438,i__46439,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__46436,chunk__46437,count__46438,i__46439,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_47351__$1);


var G__47355 = seq__46436;
var G__47356 = chunk__46437;
var G__47357 = count__46438;
var G__47358 = (i__46439 + (1));
seq__46436 = G__47355;
chunk__46437 = G__47356;
count__46438 = G__47357;
i__46439 = G__47358;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46436);
if(temp__5720__auto__){
var seq__46436__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46436__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46436__$1);
var G__47360 = cljs.core.chunk_rest(seq__46436__$1);
var G__47361 = c__4556__auto__;
var G__47362 = cljs.core.count(c__4556__auto__);
var G__47363 = (0);
seq__46436 = G__47360;
chunk__46437 = G__47361;
count__46438 = G__47362;
i__46439 = G__47363;
continue;
} else {
var el = cljs.core.first(seq__46436__$1);
var handler_47364__$1 = ((function (seq__46436,chunk__46437,count__46438,i__46439,el,seq__46436__$1,temp__5720__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__46436,chunk__46437,count__46438,i__46439,el,seq__46436__$1,temp__5720__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_47364__$1);


var G__47370 = cljs.core.next(seq__46436__$1);
var G__47371 = null;
var G__47372 = (0);
var G__47373 = (0);
seq__46436 = G__47370;
chunk__46437 = G__47371;
count__46438 = G__47372;
i__46439 = G__47373;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__46451 = arguments.length;
switch (G__46451) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__46466 = cljs.core.seq(events);
var chunk__46467 = null;
var count__46468 = (0);
var i__46469 = (0);
while(true){
if((i__46469 < count__46468)){
var vec__46485 = chunk__46467.cljs$core$IIndexed$_nth$arity$2(null,i__46469);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46485,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46485,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__47382 = seq__46466;
var G__47383 = chunk__46467;
var G__47384 = count__46468;
var G__47385 = (i__46469 + (1));
seq__46466 = G__47382;
chunk__46467 = G__47383;
count__46468 = G__47384;
i__46469 = G__47385;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46466);
if(temp__5720__auto__){
var seq__46466__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46466__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46466__$1);
var G__47389 = cljs.core.chunk_rest(seq__46466__$1);
var G__47390 = c__4556__auto__;
var G__47391 = cljs.core.count(c__4556__auto__);
var G__47392 = (0);
seq__46466 = G__47389;
chunk__46467 = G__47390;
count__46468 = G__47391;
i__46469 = G__47392;
continue;
} else {
var vec__46491 = cljs.core.first(seq__46466__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46491,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46491,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__47394 = cljs.core.next(seq__46466__$1);
var G__47395 = null;
var G__47396 = (0);
var G__47397 = (0);
seq__46466 = G__47394;
chunk__46467 = G__47395;
count__46468 = G__47396;
i__46469 = G__47397;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__46502 = cljs.core.seq(styles);
var chunk__46503 = null;
var count__46504 = (0);
var i__46505 = (0);
while(true){
if((i__46505 < count__46504)){
var vec__46521 = chunk__46503.cljs$core$IIndexed$_nth$arity$2(null,i__46505);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46521,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46521,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__47401 = seq__46502;
var G__47402 = chunk__46503;
var G__47403 = count__46504;
var G__47404 = (i__46505 + (1));
seq__46502 = G__47401;
chunk__46503 = G__47402;
count__46504 = G__47403;
i__46505 = G__47404;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46502);
if(temp__5720__auto__){
var seq__46502__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46502__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46502__$1);
var G__47407 = cljs.core.chunk_rest(seq__46502__$1);
var G__47408 = c__4556__auto__;
var G__47409 = cljs.core.count(c__4556__auto__);
var G__47410 = (0);
seq__46502 = G__47407;
chunk__46503 = G__47408;
count__46504 = G__47409;
i__46505 = G__47410;
continue;
} else {
var vec__46528 = cljs.core.first(seq__46502__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46528,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46528,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__47414 = cljs.core.next(seq__46502__$1);
var G__47415 = null;
var G__47416 = (0);
var G__47417 = (0);
seq__46502 = G__47414;
chunk__46503 = G__47415;
count__46504 = G__47416;
i__46505 = G__47417;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__46541_47419 = key;
var G__46541_47420__$1 = (((G__46541_47419 instanceof cljs.core.Keyword))?G__46541_47419.fqn:null);
switch (G__46541_47420__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_47429 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_47429,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_47429,"aria-");
}
})())){
el.setAttribute(ks_47429,value);
} else {
(el[ks_47429] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__46592){
var map__46593 = p__46592;
var map__46593__$1 = (((((!((map__46593 == null))))?(((((map__46593.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46593.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46593):map__46593);
var props = map__46593__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46593__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__46599 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46599,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46599,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46599,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__46604 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__46604,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__46604;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__46619 = arguments.length;
switch (G__46619) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__46649){
var vec__46653 = p__46649;
var seq__46654 = cljs.core.seq(vec__46653);
var first__46655 = cljs.core.first(seq__46654);
var seq__46654__$1 = cljs.core.next(seq__46654);
var nn = first__46655;
var first__46655__$1 = cljs.core.first(seq__46654__$1);
var seq__46654__$2 = cljs.core.next(seq__46654__$1);
var np = first__46655__$1;
var nc = seq__46654__$2;
var node = vec__46653;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__46664 = nn;
var G__46665 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__46664,G__46665) : create_fn.call(null,G__46664,G__46665));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__46669 = nn;
var G__46670 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__46669,G__46670) : create_fn.call(null,G__46669,G__46670));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__46678 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46678,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46678,(1),null);
var seq__46685_47486 = cljs.core.seq(node_children);
var chunk__46686_47487 = null;
var count__46687_47488 = (0);
var i__46688_47489 = (0);
while(true){
if((i__46688_47489 < count__46687_47488)){
var child_struct_47491 = chunk__46686_47487.cljs$core$IIndexed$_nth$arity$2(null,i__46688_47489);
var children_47492 = shadow.dom.dom_node(child_struct_47491);
if(cljs.core.seq_QMARK_(children_47492)){
var seq__46737_47495 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_47492));
var chunk__46739_47496 = null;
var count__46740_47497 = (0);
var i__46741_47498 = (0);
while(true){
if((i__46741_47498 < count__46740_47497)){
var child_47501 = chunk__46739_47496.cljs$core$IIndexed$_nth$arity$2(null,i__46741_47498);
if(cljs.core.truth_(child_47501)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47501);


var G__47502 = seq__46737_47495;
var G__47503 = chunk__46739_47496;
var G__47504 = count__46740_47497;
var G__47505 = (i__46741_47498 + (1));
seq__46737_47495 = G__47502;
chunk__46739_47496 = G__47503;
count__46740_47497 = G__47504;
i__46741_47498 = G__47505;
continue;
} else {
var G__47506 = seq__46737_47495;
var G__47507 = chunk__46739_47496;
var G__47508 = count__46740_47497;
var G__47509 = (i__46741_47498 + (1));
seq__46737_47495 = G__47506;
chunk__46739_47496 = G__47507;
count__46740_47497 = G__47508;
i__46741_47498 = G__47509;
continue;
}
} else {
var temp__5720__auto___47512 = cljs.core.seq(seq__46737_47495);
if(temp__5720__auto___47512){
var seq__46737_47515__$1 = temp__5720__auto___47512;
if(cljs.core.chunked_seq_QMARK_(seq__46737_47515__$1)){
var c__4556__auto___47517 = cljs.core.chunk_first(seq__46737_47515__$1);
var G__47518 = cljs.core.chunk_rest(seq__46737_47515__$1);
var G__47519 = c__4556__auto___47517;
var G__47520 = cljs.core.count(c__4556__auto___47517);
var G__47521 = (0);
seq__46737_47495 = G__47518;
chunk__46739_47496 = G__47519;
count__46740_47497 = G__47520;
i__46741_47498 = G__47521;
continue;
} else {
var child_47522 = cljs.core.first(seq__46737_47515__$1);
if(cljs.core.truth_(child_47522)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47522);


var G__47523 = cljs.core.next(seq__46737_47515__$1);
var G__47524 = null;
var G__47525 = (0);
var G__47526 = (0);
seq__46737_47495 = G__47523;
chunk__46739_47496 = G__47524;
count__46740_47497 = G__47525;
i__46741_47498 = G__47526;
continue;
} else {
var G__47527 = cljs.core.next(seq__46737_47515__$1);
var G__47528 = null;
var G__47529 = (0);
var G__47530 = (0);
seq__46737_47495 = G__47527;
chunk__46739_47496 = G__47528;
count__46740_47497 = G__47529;
i__46741_47498 = G__47530;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_47492);
}


var G__47532 = seq__46685_47486;
var G__47533 = chunk__46686_47487;
var G__47534 = count__46687_47488;
var G__47535 = (i__46688_47489 + (1));
seq__46685_47486 = G__47532;
chunk__46686_47487 = G__47533;
count__46687_47488 = G__47534;
i__46688_47489 = G__47535;
continue;
} else {
var temp__5720__auto___47538 = cljs.core.seq(seq__46685_47486);
if(temp__5720__auto___47538){
var seq__46685_47539__$1 = temp__5720__auto___47538;
if(cljs.core.chunked_seq_QMARK_(seq__46685_47539__$1)){
var c__4556__auto___47540 = cljs.core.chunk_first(seq__46685_47539__$1);
var G__47541 = cljs.core.chunk_rest(seq__46685_47539__$1);
var G__47542 = c__4556__auto___47540;
var G__47543 = cljs.core.count(c__4556__auto___47540);
var G__47544 = (0);
seq__46685_47486 = G__47541;
chunk__46686_47487 = G__47542;
count__46687_47488 = G__47543;
i__46688_47489 = G__47544;
continue;
} else {
var child_struct_47545 = cljs.core.first(seq__46685_47539__$1);
var children_47546 = shadow.dom.dom_node(child_struct_47545);
if(cljs.core.seq_QMARK_(children_47546)){
var seq__46761_47547 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_47546));
var chunk__46763_47548 = null;
var count__46764_47549 = (0);
var i__46765_47550 = (0);
while(true){
if((i__46765_47550 < count__46764_47549)){
var child_47551 = chunk__46763_47548.cljs$core$IIndexed$_nth$arity$2(null,i__46765_47550);
if(cljs.core.truth_(child_47551)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47551);


var G__47552 = seq__46761_47547;
var G__47553 = chunk__46763_47548;
var G__47554 = count__46764_47549;
var G__47555 = (i__46765_47550 + (1));
seq__46761_47547 = G__47552;
chunk__46763_47548 = G__47553;
count__46764_47549 = G__47554;
i__46765_47550 = G__47555;
continue;
} else {
var G__47559 = seq__46761_47547;
var G__47560 = chunk__46763_47548;
var G__47561 = count__46764_47549;
var G__47562 = (i__46765_47550 + (1));
seq__46761_47547 = G__47559;
chunk__46763_47548 = G__47560;
count__46764_47549 = G__47561;
i__46765_47550 = G__47562;
continue;
}
} else {
var temp__5720__auto___47565__$1 = cljs.core.seq(seq__46761_47547);
if(temp__5720__auto___47565__$1){
var seq__46761_47566__$1 = temp__5720__auto___47565__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46761_47566__$1)){
var c__4556__auto___47568 = cljs.core.chunk_first(seq__46761_47566__$1);
var G__47569 = cljs.core.chunk_rest(seq__46761_47566__$1);
var G__47570 = c__4556__auto___47568;
var G__47571 = cljs.core.count(c__4556__auto___47568);
var G__47572 = (0);
seq__46761_47547 = G__47569;
chunk__46763_47548 = G__47570;
count__46764_47549 = G__47571;
i__46765_47550 = G__47572;
continue;
} else {
var child_47574 = cljs.core.first(seq__46761_47566__$1);
if(cljs.core.truth_(child_47574)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47574);


var G__47575 = cljs.core.next(seq__46761_47566__$1);
var G__47576 = null;
var G__47577 = (0);
var G__47578 = (0);
seq__46761_47547 = G__47575;
chunk__46763_47548 = G__47576;
count__46764_47549 = G__47577;
i__46765_47550 = G__47578;
continue;
} else {
var G__47579 = cljs.core.next(seq__46761_47566__$1);
var G__47580 = null;
var G__47581 = (0);
var G__47582 = (0);
seq__46761_47547 = G__47579;
chunk__46763_47548 = G__47580;
count__46764_47549 = G__47581;
i__46765_47550 = G__47582;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_47546);
}


var G__47583 = cljs.core.next(seq__46685_47539__$1);
var G__47584 = null;
var G__47585 = (0);
var G__47586 = (0);
seq__46685_47486 = G__47583;
chunk__46686_47487 = G__47584;
count__46687_47488 = G__47585;
i__46688_47489 = G__47586;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__46800 = cljs.core.seq(node);
var chunk__46801 = null;
var count__46802 = (0);
var i__46803 = (0);
while(true){
if((i__46803 < count__46802)){
var n = chunk__46801.cljs$core$IIndexed$_nth$arity$2(null,i__46803);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__47607 = seq__46800;
var G__47608 = chunk__46801;
var G__47609 = count__46802;
var G__47610 = (i__46803 + (1));
seq__46800 = G__47607;
chunk__46801 = G__47608;
count__46802 = G__47609;
i__46803 = G__47610;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46800);
if(temp__5720__auto__){
var seq__46800__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46800__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46800__$1);
var G__47619 = cljs.core.chunk_rest(seq__46800__$1);
var G__47620 = c__4556__auto__;
var G__47621 = cljs.core.count(c__4556__auto__);
var G__47622 = (0);
seq__46800 = G__47619;
chunk__46801 = G__47620;
count__46802 = G__47621;
i__46803 = G__47622;
continue;
} else {
var n = cljs.core.first(seq__46800__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__47628 = cljs.core.next(seq__46800__$1);
var G__47629 = null;
var G__47630 = (0);
var G__47631 = (0);
seq__46800 = G__47628;
chunk__46801 = G__47629;
count__46802 = G__47630;
i__46803 = G__47631;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__46819 = arguments.length;
switch (G__46819) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__46827 = arguments.length;
switch (G__46827) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__46849 = arguments.length;
switch (G__46849) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47674 = arguments.length;
var i__4737__auto___47675 = (0);
while(true){
if((i__4737__auto___47675 < len__4736__auto___47674)){
args__4742__auto__.push((arguments[i__4737__auto___47675]));

var G__47676 = (i__4737__auto___47675 + (1));
i__4737__auto___47675 = G__47676;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__46867_47679 = cljs.core.seq(nodes);
var chunk__46868_47680 = null;
var count__46869_47681 = (0);
var i__46870_47682 = (0);
while(true){
if((i__46870_47682 < count__46869_47681)){
var node_47684 = chunk__46868_47680.cljs$core$IIndexed$_nth$arity$2(null,i__46870_47682);
fragment.appendChild(shadow.dom._to_dom(node_47684));


var G__47685 = seq__46867_47679;
var G__47686 = chunk__46868_47680;
var G__47687 = count__46869_47681;
var G__47688 = (i__46870_47682 + (1));
seq__46867_47679 = G__47685;
chunk__46868_47680 = G__47686;
count__46869_47681 = G__47687;
i__46870_47682 = G__47688;
continue;
} else {
var temp__5720__auto___47690 = cljs.core.seq(seq__46867_47679);
if(temp__5720__auto___47690){
var seq__46867_47691__$1 = temp__5720__auto___47690;
if(cljs.core.chunked_seq_QMARK_(seq__46867_47691__$1)){
var c__4556__auto___47692 = cljs.core.chunk_first(seq__46867_47691__$1);
var G__47693 = cljs.core.chunk_rest(seq__46867_47691__$1);
var G__47694 = c__4556__auto___47692;
var G__47695 = cljs.core.count(c__4556__auto___47692);
var G__47696 = (0);
seq__46867_47679 = G__47693;
chunk__46868_47680 = G__47694;
count__46869_47681 = G__47695;
i__46870_47682 = G__47696;
continue;
} else {
var node_47697 = cljs.core.first(seq__46867_47691__$1);
fragment.appendChild(shadow.dom._to_dom(node_47697));


var G__47699 = cljs.core.next(seq__46867_47691__$1);
var G__47700 = null;
var G__47701 = (0);
var G__47702 = (0);
seq__46867_47679 = G__47699;
chunk__46868_47680 = G__47700;
count__46869_47681 = G__47701;
i__46870_47682 = G__47702;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq46858){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46858));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__46890_47713 = cljs.core.seq(scripts);
var chunk__46891_47714 = null;
var count__46892_47715 = (0);
var i__46893_47716 = (0);
while(true){
if((i__46893_47716 < count__46892_47715)){
var vec__46907_47719 = chunk__46891_47714.cljs$core$IIndexed$_nth$arity$2(null,i__46893_47716);
var script_tag_47720 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46907_47719,(0),null);
var script_body_47721 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46907_47719,(1),null);
eval(script_body_47721);


var G__47724 = seq__46890_47713;
var G__47725 = chunk__46891_47714;
var G__47726 = count__46892_47715;
var G__47727 = (i__46893_47716 + (1));
seq__46890_47713 = G__47724;
chunk__46891_47714 = G__47725;
count__46892_47715 = G__47726;
i__46893_47716 = G__47727;
continue;
} else {
var temp__5720__auto___47729 = cljs.core.seq(seq__46890_47713);
if(temp__5720__auto___47729){
var seq__46890_47731__$1 = temp__5720__auto___47729;
if(cljs.core.chunked_seq_QMARK_(seq__46890_47731__$1)){
var c__4556__auto___47732 = cljs.core.chunk_first(seq__46890_47731__$1);
var G__47735 = cljs.core.chunk_rest(seq__46890_47731__$1);
var G__47736 = c__4556__auto___47732;
var G__47737 = cljs.core.count(c__4556__auto___47732);
var G__47738 = (0);
seq__46890_47713 = G__47735;
chunk__46891_47714 = G__47736;
count__46892_47715 = G__47737;
i__46893_47716 = G__47738;
continue;
} else {
var vec__46915_47744 = cljs.core.first(seq__46890_47731__$1);
var script_tag_47745 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46915_47744,(0),null);
var script_body_47746 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46915_47744,(1),null);
eval(script_body_47746);


var G__47747 = cljs.core.next(seq__46890_47731__$1);
var G__47748 = null;
var G__47749 = (0);
var G__47750 = (0);
seq__46890_47713 = G__47747;
chunk__46891_47714 = G__47748;
count__46892_47715 = G__47749;
i__46893_47716 = G__47750;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__46922){
var vec__46924 = p__46922;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46924,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46924,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__46934 = arguments.length;
switch (G__46934) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__46941 = cljs.core.seq(style_keys);
var chunk__46942 = null;
var count__46943 = (0);
var i__46944 = (0);
while(true){
if((i__46944 < count__46943)){
var it = chunk__46942.cljs$core$IIndexed$_nth$arity$2(null,i__46944);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__47776 = seq__46941;
var G__47777 = chunk__46942;
var G__47778 = count__46943;
var G__47779 = (i__46944 + (1));
seq__46941 = G__47776;
chunk__46942 = G__47777;
count__46943 = G__47778;
i__46944 = G__47779;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46941);
if(temp__5720__auto__){
var seq__46941__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46941__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46941__$1);
var G__47790 = cljs.core.chunk_rest(seq__46941__$1);
var G__47791 = c__4556__auto__;
var G__47792 = cljs.core.count(c__4556__auto__);
var G__47793 = (0);
seq__46941 = G__47790;
chunk__46942 = G__47791;
count__46943 = G__47792;
i__46944 = G__47793;
continue;
} else {
var it = cljs.core.first(seq__46941__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__47805 = cljs.core.next(seq__46941__$1);
var G__47806 = null;
var G__47807 = (0);
var G__47808 = (0);
seq__46941 = G__47805;
chunk__46942 = G__47806;
count__46943 = G__47807;
i__46944 = G__47808;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k46949,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__46959 = k46949;
var G__46959__$1 = (((G__46959 instanceof cljs.core.Keyword))?G__46959.fqn:null);
switch (G__46959__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46949,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__46960){
var vec__46962 = p__46960;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46962,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46962,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46948){
var self__ = this;
var G__46948__$1 = this;
return (new cljs.core.RecordIter((0),G__46948__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46950,other46951){
var self__ = this;
var this46950__$1 = this;
return (((!((other46951 == null)))) && ((this46950__$1.constructor === other46951.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46950__$1.x,other46951.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46950__$1.y,other46951.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46950__$1.__extmap,other46951.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__46948){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__46975 = cljs.core.keyword_identical_QMARK_;
var expr__46976 = k__4388__auto__;
if(cljs.core.truth_((pred__46975.cljs$core$IFn$_invoke$arity$2 ? pred__46975.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__46976) : pred__46975.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__46976)))){
return (new shadow.dom.Coordinate(G__46948,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__46975.cljs$core$IFn$_invoke$arity$2 ? pred__46975.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__46976) : pred__46975.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__46976)))){
return (new shadow.dom.Coordinate(self__.x,G__46948,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__46948),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__46948){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__46948,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__46954){
var extmap__4419__auto__ = (function (){var G__46984 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46954,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__46954)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46984);
} else {
return G__46984;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__46954),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__46954),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k46992,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__47001 = k46992;
var G__47001__$1 = (((G__47001 instanceof cljs.core.Keyword))?G__47001.fqn:null);
switch (G__47001__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46992,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__47004){
var vec__47005 = p__47004;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47005,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47005,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46991){
var self__ = this;
var G__46991__$1 = this;
return (new cljs.core.RecordIter((0),G__46991__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46993,other46994){
var self__ = this;
var this46993__$1 = this;
return (((!((other46994 == null)))) && ((this46993__$1.constructor === other46994.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46993__$1.w,other46994.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46993__$1.h,other46994.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46993__$1.__extmap,other46994.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__46991){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__47022 = cljs.core.keyword_identical_QMARK_;
var expr__47023 = k__4388__auto__;
if(cljs.core.truth_((pred__47022.cljs$core$IFn$_invoke$arity$2 ? pred__47022.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__47023) : pred__47022.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__47023)))){
return (new shadow.dom.Size(G__46991,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__47022.cljs$core$IFn$_invoke$arity$2 ? pred__47022.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__47023) : pred__47022.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__47023)))){
return (new shadow.dom.Size(self__.w,G__46991,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__46991),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__46991){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__46991,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__46996){
var extmap__4419__auto__ = (function (){var G__47035 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46996,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__46996)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__47035);
} else {
return G__47035;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__46996),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__46996),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__47965 = (i + (1));
var G__47966 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__47965;
ret = G__47966;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__47055){
var vec__47056 = p__47055;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47056,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47056,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__47063 = arguments.length;
switch (G__47063) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__47989 = ps;
var G__47990 = (i + (1));
el__$1 = G__47989;
i = G__47990;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__47088 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47088,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47088,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47088,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__47094_47999 = cljs.core.seq(props);
var chunk__47095_48000 = null;
var count__47096_48001 = (0);
var i__47097_48002 = (0);
while(true){
if((i__47097_48002 < count__47096_48001)){
var vec__47110_48003 = chunk__47095_48000.cljs$core$IIndexed$_nth$arity$2(null,i__47097_48002);
var k_48004 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47110_48003,(0),null);
var v_48005 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47110_48003,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace(k_48004);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_48004),v_48005);


var G__48006 = seq__47094_47999;
var G__48007 = chunk__47095_48000;
var G__48008 = count__47096_48001;
var G__48009 = (i__47097_48002 + (1));
seq__47094_47999 = G__48006;
chunk__47095_48000 = G__48007;
count__47096_48001 = G__48008;
i__47097_48002 = G__48009;
continue;
} else {
var temp__5720__auto___48013 = cljs.core.seq(seq__47094_47999);
if(temp__5720__auto___48013){
var seq__47094_48014__$1 = temp__5720__auto___48013;
if(cljs.core.chunked_seq_QMARK_(seq__47094_48014__$1)){
var c__4556__auto___48015 = cljs.core.chunk_first(seq__47094_48014__$1);
var G__48016 = cljs.core.chunk_rest(seq__47094_48014__$1);
var G__48017 = c__4556__auto___48015;
var G__48018 = cljs.core.count(c__4556__auto___48015);
var G__48019 = (0);
seq__47094_47999 = G__48016;
chunk__47095_48000 = G__48017;
count__47096_48001 = G__48018;
i__47097_48002 = G__48019;
continue;
} else {
var vec__47115_48020 = cljs.core.first(seq__47094_48014__$1);
var k_48021 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47115_48020,(0),null);
var v_48022 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47115_48020,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace(k_48021);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_48021),v_48022);


var G__48023 = cljs.core.next(seq__47094_48014__$1);
var G__48024 = null;
var G__48025 = (0);
var G__48026 = (0);
seq__47094_47999 = G__48023;
chunk__47095_48000 = G__48024;
count__47096_48001 = G__48025;
i__47097_48002 = G__48026;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__47124 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47124,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47124,(1),null);
var seq__47127_48027 = cljs.core.seq(node_children);
var chunk__47129_48028 = null;
var count__47130_48029 = (0);
var i__47131_48030 = (0);
while(true){
if((i__47131_48030 < count__47130_48029)){
var child_struct_48031 = chunk__47129_48028.cljs$core$IIndexed$_nth$arity$2(null,i__47131_48030);
if((!((child_struct_48031 == null)))){
if(typeof child_struct_48031 === 'string'){
var text_48032 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_48032),child_struct_48031].join(''));
} else {
var children_48036 = shadow.dom.svg_node(child_struct_48031);
if(cljs.core.seq_QMARK_(children_48036)){
var seq__47191_48037 = cljs.core.seq(children_48036);
var chunk__47193_48038 = null;
var count__47194_48039 = (0);
var i__47195_48040 = (0);
while(true){
if((i__47195_48040 < count__47194_48039)){
var child_48041 = chunk__47193_48038.cljs$core$IIndexed$_nth$arity$2(null,i__47195_48040);
if(cljs.core.truth_(child_48041)){
node.appendChild(child_48041);


var G__48042 = seq__47191_48037;
var G__48043 = chunk__47193_48038;
var G__48044 = count__47194_48039;
var G__48045 = (i__47195_48040 + (1));
seq__47191_48037 = G__48042;
chunk__47193_48038 = G__48043;
count__47194_48039 = G__48044;
i__47195_48040 = G__48045;
continue;
} else {
var G__48046 = seq__47191_48037;
var G__48047 = chunk__47193_48038;
var G__48048 = count__47194_48039;
var G__48049 = (i__47195_48040 + (1));
seq__47191_48037 = G__48046;
chunk__47193_48038 = G__48047;
count__47194_48039 = G__48048;
i__47195_48040 = G__48049;
continue;
}
} else {
var temp__5720__auto___48050 = cljs.core.seq(seq__47191_48037);
if(temp__5720__auto___48050){
var seq__47191_48051__$1 = temp__5720__auto___48050;
if(cljs.core.chunked_seq_QMARK_(seq__47191_48051__$1)){
var c__4556__auto___48052 = cljs.core.chunk_first(seq__47191_48051__$1);
var G__48053 = cljs.core.chunk_rest(seq__47191_48051__$1);
var G__48054 = c__4556__auto___48052;
var G__48055 = cljs.core.count(c__4556__auto___48052);
var G__48056 = (0);
seq__47191_48037 = G__48053;
chunk__47193_48038 = G__48054;
count__47194_48039 = G__48055;
i__47195_48040 = G__48056;
continue;
} else {
var child_48057 = cljs.core.first(seq__47191_48051__$1);
if(cljs.core.truth_(child_48057)){
node.appendChild(child_48057);


var G__48058 = cljs.core.next(seq__47191_48051__$1);
var G__48059 = null;
var G__48060 = (0);
var G__48061 = (0);
seq__47191_48037 = G__48058;
chunk__47193_48038 = G__48059;
count__47194_48039 = G__48060;
i__47195_48040 = G__48061;
continue;
} else {
var G__48062 = cljs.core.next(seq__47191_48051__$1);
var G__48063 = null;
var G__48064 = (0);
var G__48065 = (0);
seq__47191_48037 = G__48062;
chunk__47193_48038 = G__48063;
count__47194_48039 = G__48064;
i__47195_48040 = G__48065;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_48036);
}
}


var G__48066 = seq__47127_48027;
var G__48067 = chunk__47129_48028;
var G__48068 = count__47130_48029;
var G__48069 = (i__47131_48030 + (1));
seq__47127_48027 = G__48066;
chunk__47129_48028 = G__48067;
count__47130_48029 = G__48068;
i__47131_48030 = G__48069;
continue;
} else {
var G__48070 = seq__47127_48027;
var G__48071 = chunk__47129_48028;
var G__48072 = count__47130_48029;
var G__48073 = (i__47131_48030 + (1));
seq__47127_48027 = G__48070;
chunk__47129_48028 = G__48071;
count__47130_48029 = G__48072;
i__47131_48030 = G__48073;
continue;
}
} else {
var temp__5720__auto___48074 = cljs.core.seq(seq__47127_48027);
if(temp__5720__auto___48074){
var seq__47127_48075__$1 = temp__5720__auto___48074;
if(cljs.core.chunked_seq_QMARK_(seq__47127_48075__$1)){
var c__4556__auto___48076 = cljs.core.chunk_first(seq__47127_48075__$1);
var G__48077 = cljs.core.chunk_rest(seq__47127_48075__$1);
var G__48078 = c__4556__auto___48076;
var G__48079 = cljs.core.count(c__4556__auto___48076);
var G__48080 = (0);
seq__47127_48027 = G__48077;
chunk__47129_48028 = G__48078;
count__47130_48029 = G__48079;
i__47131_48030 = G__48080;
continue;
} else {
var child_struct_48082 = cljs.core.first(seq__47127_48075__$1);
if((!((child_struct_48082 == null)))){
if(typeof child_struct_48082 === 'string'){
var text_48086 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_48086),child_struct_48082].join(''));
} else {
var children_48087 = shadow.dom.svg_node(child_struct_48082);
if(cljs.core.seq_QMARK_(children_48087)){
var seq__47208_48088 = cljs.core.seq(children_48087);
var chunk__47210_48089 = null;
var count__47211_48090 = (0);
var i__47212_48091 = (0);
while(true){
if((i__47212_48091 < count__47211_48090)){
var child_48092 = chunk__47210_48089.cljs$core$IIndexed$_nth$arity$2(null,i__47212_48091);
if(cljs.core.truth_(child_48092)){
node.appendChild(child_48092);


var G__48093 = seq__47208_48088;
var G__48094 = chunk__47210_48089;
var G__48095 = count__47211_48090;
var G__48096 = (i__47212_48091 + (1));
seq__47208_48088 = G__48093;
chunk__47210_48089 = G__48094;
count__47211_48090 = G__48095;
i__47212_48091 = G__48096;
continue;
} else {
var G__48097 = seq__47208_48088;
var G__48098 = chunk__47210_48089;
var G__48099 = count__47211_48090;
var G__48100 = (i__47212_48091 + (1));
seq__47208_48088 = G__48097;
chunk__47210_48089 = G__48098;
count__47211_48090 = G__48099;
i__47212_48091 = G__48100;
continue;
}
} else {
var temp__5720__auto___48101__$1 = cljs.core.seq(seq__47208_48088);
if(temp__5720__auto___48101__$1){
var seq__47208_48102__$1 = temp__5720__auto___48101__$1;
if(cljs.core.chunked_seq_QMARK_(seq__47208_48102__$1)){
var c__4556__auto___48103 = cljs.core.chunk_first(seq__47208_48102__$1);
var G__48104 = cljs.core.chunk_rest(seq__47208_48102__$1);
var G__48105 = c__4556__auto___48103;
var G__48106 = cljs.core.count(c__4556__auto___48103);
var G__48107 = (0);
seq__47208_48088 = G__48104;
chunk__47210_48089 = G__48105;
count__47211_48090 = G__48106;
i__47212_48091 = G__48107;
continue;
} else {
var child_48108 = cljs.core.first(seq__47208_48102__$1);
if(cljs.core.truth_(child_48108)){
node.appendChild(child_48108);


var G__48109 = cljs.core.next(seq__47208_48102__$1);
var G__48110 = null;
var G__48111 = (0);
var G__48112 = (0);
seq__47208_48088 = G__48109;
chunk__47210_48089 = G__48110;
count__47211_48090 = G__48111;
i__47212_48091 = G__48112;
continue;
} else {
var G__48113 = cljs.core.next(seq__47208_48102__$1);
var G__48114 = null;
var G__48115 = (0);
var G__48116 = (0);
seq__47208_48088 = G__48113;
chunk__47210_48089 = G__48114;
count__47211_48090 = G__48115;
i__47212_48091 = G__48116;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_48087);
}
}


var G__48117 = cljs.core.next(seq__47127_48075__$1);
var G__48118 = null;
var G__48119 = (0);
var G__48120 = (0);
seq__47127_48027 = G__48117;
chunk__47129_48028 = G__48118;
count__47130_48029 = G__48119;
i__47131_48030 = G__48120;
continue;
} else {
var G__48121 = cljs.core.next(seq__47127_48075__$1);
var G__48122 = null;
var G__48123 = (0);
var G__48124 = (0);
seq__47127_48027 = G__48121;
chunk__47129_48028 = G__48122;
count__47130_48029 = G__48123;
i__47131_48030 = G__48124;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48125 = arguments.length;
var i__4737__auto___48126 = (0);
while(true){
if((i__4737__auto___48126 < len__4736__auto___48125)){
args__4742__auto__.push((arguments[i__4737__auto___48126]));

var G__48127 = (i__4737__auto___48126 + (1));
i__4737__auto___48126 = G__48127;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq47250){
var G__47251 = cljs.core.first(seq47250);
var seq47250__$1 = cljs.core.next(seq47250);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47251,seq47250__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__47270 = arguments.length;
switch (G__47270) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__43781__auto___48131 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_47280){
var state_val_47281 = (state_47280[(1)]);
if((state_val_47281 === (1))){
var state_47280__$1 = state_47280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47280__$1,(2),once_or_cleanup);
} else {
if((state_val_47281 === (2))){
var inst_47277 = (state_47280[(2)]);
var inst_47278 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_47280__$1 = (function (){var statearr_47293 = state_47280;
(statearr_47293[(7)] = inst_47277);

return statearr_47293;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47280__$1,inst_47278);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__43550__auto__ = null;
var shadow$dom$state_machine__43550__auto____0 = (function (){
var statearr_47296 = [null,null,null,null,null,null,null,null];
(statearr_47296[(0)] = shadow$dom$state_machine__43550__auto__);

(statearr_47296[(1)] = (1));

return statearr_47296;
});
var shadow$dom$state_machine__43550__auto____1 = (function (state_47280){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_47280);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e47297){var ex__43553__auto__ = e47297;
var statearr_47298_48133 = state_47280;
(statearr_47298_48133[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_47280[(4)]))){
var statearr_47299_48134 = state_47280;
(statearr_47299_48134[(1)] = cljs.core.first((state_47280[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48135 = state_47280;
state_47280 = G__48135;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
shadow$dom$state_machine__43550__auto__ = function(state_47280){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__43550__auto____0.call(this);
case 1:
return shadow$dom$state_machine__43550__auto____1.call(this,state_47280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__43550__auto____0;
shadow$dom$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__43550__auto____1;
return shadow$dom$state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_47300 = f__43782__auto__();
(statearr_47300[(6)] = c__43781__auto___48131);

return statearr_47300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
