(ns gorilla-notes.dummy
  (:require [gorilla-notes.core :as gorilla-notes
             :refer [start-server! browse-http-url
                     reset-notes! add-note! assoc-note!
                     render-current-state!]]))

(defonce stop-server
  (let [s (start-server!)]
    (browse-http-url)
    s))

(let [*counter (atom 1)
      new-note (fn [i]
                 (swap! *counter inc)
                 [:div [:p i ": " @*counter]])
      n        10]
  (reset-notes!)
  (dotimes [i n]
    (add-note! (new-note i)))
  (dotimes [t 100]
    (Thread/sleep 1)
    (let [i (rand-int n)]
      (assoc-note! i (new-note i)))))

(comment
  (render-current-state! "resources/public/dummy.html"))
