goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e47726){var e = e47726;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4777__auto__ = [];
var len__4771__auto___47869 = arguments.length;
var i__4772__auto___47871 = (0);
while(true){
if((i__4772__auto___47871 < len__4771__auto___47869)){
args__4777__auto__.push((arguments[i__4772__auto___47871]));

var G__47875 = (i__4772__auto___47871 + (1));
i__4772__auto___47871 = G__47875;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__47731){
var vec__47732 = p__47731;
var map__47735 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47732,(0),null);
var map__47735__$1 = cljs.core.__destructure_map(map__47735);
var opts = map__47735__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47735__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47735__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47735__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47735__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__47736 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4160__auto__ = read_ch;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4160__auto__ = write_ch;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__47736__$1 = cljs.core.__destructure_map(map__47736);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47736__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47736__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__47727_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__47727_SHARP_);
}));

(web_socket.onclose = (function (p1__47728_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__47728_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__41850__auto___47889 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41851__auto__ = (function (){var switch__41777__auto__ = (function (state_47806){
var state_val_47807 = (state_47806[(1)]);
if((state_val_47807 === (7))){
var inst_47802 = (state_47806[(2)]);
var state_47806__$1 = state_47806;
var statearr_47809_47890 = state_47806__$1;
(statearr_47809_47890[(2)] = inst_47802);

(statearr_47809_47890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (20))){
var state_47806__$1 = state_47806;
var statearr_47810_47894 = state_47806__$1;
(statearr_47810_47894[(2)] = null);

(statearr_47810_47894[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (1))){
var inst_47737 = false;
var state_47806__$1 = (function (){var statearr_47811 = state_47806;
(statearr_47811[(7)] = inst_47737);

return statearr_47811;
})();
var statearr_47812_47895 = state_47806__$1;
(statearr_47812_47895[(2)] = null);

(statearr_47812_47895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (4))){
var inst_47746 = (state_47806[(8)]);
var inst_47755 = (state_47806[(9)]);
var inst_47753 = (state_47806[(10)]);
var inst_47753__$1 = (state_47806[(2)]);
var inst_47754 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47753__$1,(0),null);
var inst_47755__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47753__$1,(1),null);
var inst_47757 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47755__$1,inst_47746);
var state_47806__$1 = (function (){var statearr_47814 = state_47806;
(statearr_47814[(11)] = inst_47754);

(statearr_47814[(9)] = inst_47755__$1);

(statearr_47814[(10)] = inst_47753__$1);

return statearr_47814;
})();
if(inst_47757){
var statearr_47815_47896 = state_47806__$1;
(statearr_47815_47896[(1)] = (5));

} else {
var statearr_47817_47897 = state_47806__$1;
(statearr_47817_47897[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (15))){
var inst_47787 = (state_47806[(2)]);
var state_47806__$1 = state_47806;
var statearr_47818_47898 = state_47806__$1;
(statearr_47818_47898[(2)] = inst_47787);

(statearr_47818_47898[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (21))){
var inst_47798 = (state_47806[(2)]);
var state_47806__$1 = state_47806;
var statearr_47819_47903 = state_47806__$1;
(statearr_47819_47903[(2)] = inst_47798);

(statearr_47819_47903[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (13))){
var state_47806__$1 = state_47806;
var statearr_47820_47904 = state_47806__$1;
(statearr_47820_47904[(2)] = null);

(statearr_47820_47904[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (6))){
var inst_47747 = (state_47806[(12)]);
var inst_47755 = (state_47806[(9)]);
var inst_47771 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47755,inst_47747);
var state_47806__$1 = state_47806;
if(inst_47771){
var statearr_47822_47908 = state_47806__$1;
(statearr_47822_47908[(1)] = (9));

} else {
var statearr_47823_47909 = state_47806__$1;
(statearr_47823_47909[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (17))){
var state_47806__$1 = state_47806;
var statearr_47824_47910 = state_47806__$1;
(statearr_47824_47910[(2)] = initial_ch);

(statearr_47824_47910[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (3))){
var inst_47804 = (state_47806[(2)]);
var state_47806__$1 = state_47806;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47806__$1,inst_47804);
} else {
if((state_val_47807 === (12))){
var inst_47737 = (state_47806[(7)]);
var state_47806__$1 = state_47806;
if(cljs.core.truth_(inst_47737)){
var statearr_47825_47911 = state_47806__$1;
(statearr_47825_47911[(1)] = (16));

} else {
var statearr_47826_47913 = state_47806__$1;
(statearr_47826_47913[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (2))){
var inst_47747 = (state_47806[(12)]);
var inst_47746 = (state_47806[(8)]);
var inst_47746__$1 = open_ch;
var inst_47747__$1 = close_ch;
var inst_47749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47750 = [inst_47746__$1,inst_47747__$1];
var inst_47751 = (new cljs.core.PersistentVector(null,2,(5),inst_47749,inst_47750,null));
var state_47806__$1 = (function (){var statearr_47827 = state_47806;
(statearr_47827[(12)] = inst_47747__$1);

(statearr_47827[(8)] = inst_47746__$1);

return statearr_47827;
})();
return cljs.core.async.ioc_alts_BANG_(state_47806__$1,(4),inst_47751);
} else {
if((state_val_47807 === (19))){
var inst_47754 = (state_47806[(11)]);
var state_47806__$1 = state_47806;
var statearr_47828_47916 = state_47806__$1;
(statearr_47828_47916[(2)] = inst_47754);

(statearr_47828_47916[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (11))){
var inst_47800 = (state_47806[(2)]);
var state_47806__$1 = state_47806;
var statearr_47830_47917 = state_47806__$1;
(statearr_47830_47917[(2)] = inst_47800);

(statearr_47830_47917[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (9))){
var inst_47777 = (state_47806[(13)]);
var inst_47753 = (state_47806[(10)]);
var inst_47776 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47753,(0),null);
var inst_47777__$1 = chord.client.close_event__GT_maybe_error(inst_47776);
var state_47806__$1 = (function (){var statearr_47832 = state_47806;
(statearr_47832[(13)] = inst_47777__$1);

return statearr_47832;
})();
if(cljs.core.truth_(inst_47777__$1)){
var statearr_47833_47918 = state_47806__$1;
(statearr_47833_47918[(1)] = (12));

} else {
var statearr_47834_47919 = state_47806__$1;
(statearr_47834_47919[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (5))){
var inst_47753 = (state_47806[(10)]);
var inst_47762 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47753,(0),null);
var inst_47763 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_47764 = [ws_chan];
var inst_47765 = cljs.core.PersistentHashMap.fromArrays(inst_47763,inst_47764);
var state_47806__$1 = (function (){var statearr_47836 = state_47806;
(statearr_47836[(14)] = inst_47762);

return statearr_47836;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47806__$1,(8),initial_ch,inst_47765);
} else {
if((state_val_47807 === (14))){
var inst_47790 = (state_47806[(2)]);
var inst_47791 = cljs.core.async.close_BANG_(ws_chan);
var inst_47792 = cljs.core.async.close_BANG_(initial_ch);
var state_47806__$1 = (function (){var statearr_47839 = state_47806;
(statearr_47839[(15)] = inst_47791);

(statearr_47839[(16)] = inst_47790);

return statearr_47839;
})();
var statearr_47841_48058 = state_47806__$1;
(statearr_47841_48058[(2)] = inst_47792);

(statearr_47841_48058[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (16))){
var state_47806__$1 = state_47806;
var statearr_47843_48059 = state_47806__$1;
(statearr_47843_48059[(2)] = read_ch__$1);

(statearr_47843_48059[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (10))){
var inst_47755 = (state_47806[(9)]);
var inst_47794 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47755,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_47806__$1 = state_47806;
if(inst_47794){
var statearr_47848_48061 = state_47806__$1;
(statearr_47848_48061[(1)] = (19));

} else {
var statearr_47849_48062 = state_47806__$1;
(statearr_47849_48062[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47807 === (18))){
var inst_47777 = (state_47806[(13)]);
var inst_47782 = (state_47806[(2)]);
var inst_47783 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_47784 = [inst_47777];
var inst_47785 = cljs.core.PersistentHashMap.fromArrays(inst_47783,inst_47784);
var state_47806__$1 = state_47806;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47806__$1,(15),inst_47782,inst_47785);
} else {
if((state_val_47807 === (8))){
var inst_47767 = (state_47806[(2)]);
var inst_47768 = cljs.core.async.close_BANG_(initial_ch);
var inst_47737 = true;
var state_47806__$1 = (function (){var statearr_47851 = state_47806;
(statearr_47851[(17)] = inst_47767);

(statearr_47851[(18)] = inst_47768);

(statearr_47851[(7)] = inst_47737);

return statearr_47851;
})();
var statearr_47852_48067 = state_47806__$1;
(statearr_47852_48067[(2)] = null);

(statearr_47852_48067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__41778__auto__ = null;
var chord$client$state_machine__41778__auto____0 = (function (){
var statearr_47853 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47853[(0)] = chord$client$state_machine__41778__auto__);

(statearr_47853[(1)] = (1));

return statearr_47853;
});
var chord$client$state_machine__41778__auto____1 = (function (state_47806){
while(true){
var ret_value__41779__auto__ = (function (){try{while(true){
var result__41780__auto__ = switch__41777__auto__(state_47806);
if(cljs.core.keyword_identical_QMARK_(result__41780__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41780__auto__;
}
break;
}
}catch (e47856){var ex__41781__auto__ = e47856;
var statearr_47857_48068 = state_47806;
(statearr_47857_48068[(2)] = ex__41781__auto__);


if(cljs.core.seq((state_47806[(4)]))){
var statearr_47858_48069 = state_47806;
(statearr_47858_48069[(1)] = cljs.core.first((state_47806[(4)])));

} else {
throw ex__41781__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41779__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48070 = state_47806;
state_47806 = G__48070;
continue;
} else {
return ret_value__41779__auto__;
}
break;
}
});
chord$client$state_machine__41778__auto__ = function(state_47806){
switch(arguments.length){
case 0:
return chord$client$state_machine__41778__auto____0.call(this);
case 1:
return chord$client$state_machine__41778__auto____1.call(this,state_47806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__41778__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__41778__auto____0;
chord$client$state_machine__41778__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__41778__auto____1;
return chord$client$state_machine__41778__auto__;
})()
})();
var state__41852__auto__ = (function (){var statearr_47859 = f__41851__auto__();
(statearr_47859[(6)] = c__41850__auto___47889);

return statearr_47859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41852__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq47729){
var G__47730 = cljs.core.first(seq47729);
var seq47729__$1 = cljs.core.next(seq47729);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47730,seq47729__$1);
}));


//# sourceMappingURL=chord.client.js.map
