goog.provide('re_frame.trace');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});
/**
 * @define {boolean}
 */
re_frame.trace.trace_enabled_QMARK_ = goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__46498){
var map__46499 = p__46498;
var map__46499__$1 = cljs.core.__destructure_map(map__46499);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46499__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46499__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46499__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46499__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id(),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__4160__auto__ = child_of;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__46500_46530 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__46501_46531 = null;
var count__46502_46532 = (0);
var i__46503_46533 = (0);
while(true){
if((i__46503_46533 < count__46502_46532)){
var vec__46514_46538 = chunk__46501_46531.cljs$core$IIndexed$_nth$arity$2(null,i__46503_46533);
var k_46539 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46514_46538,(0),null);
var cb_46540 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46514_46538,(1),null);
try{var G__46518_46544 = cljs.core.deref(re_frame.trace.traces);
(cb_46540.cljs$core$IFn$_invoke$arity$1 ? cb_46540.cljs$core$IFn$_invoke$arity$1(G__46518_46544) : cb_46540.call(null,G__46518_46544));
}catch (e46517){var e_46545 = e46517;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_46539,"while storing",cljs.core.deref(re_frame.trace.traces),e_46545], 0));
}

var G__46546 = seq__46500_46530;
var G__46547 = chunk__46501_46531;
var G__46548 = count__46502_46532;
var G__46549 = (i__46503_46533 + (1));
seq__46500_46530 = G__46546;
chunk__46501_46531 = G__46547;
count__46502_46532 = G__46548;
i__46503_46533 = G__46549;
continue;
} else {
var temp__5754__auto___46550 = cljs.core.seq(seq__46500_46530);
if(temp__5754__auto___46550){
var seq__46500_46551__$1 = temp__5754__auto___46550;
if(cljs.core.chunked_seq_QMARK_(seq__46500_46551__$1)){
var c__4591__auto___46552 = cljs.core.chunk_first(seq__46500_46551__$1);
var G__46553 = cljs.core.chunk_rest(seq__46500_46551__$1);
var G__46554 = c__4591__auto___46552;
var G__46555 = cljs.core.count(c__4591__auto___46552);
var G__46556 = (0);
seq__46500_46530 = G__46553;
chunk__46501_46531 = G__46554;
count__46502_46532 = G__46555;
i__46503_46533 = G__46556;
continue;
} else {
var vec__46519_46558 = cljs.core.first(seq__46500_46551__$1);
var k_46561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46519_46558,(0),null);
var cb_46562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46519_46558,(1),null);
try{var G__46523_46563 = cljs.core.deref(re_frame.trace.traces);
(cb_46562.cljs$core$IFn$_invoke$arity$1 ? cb_46562.cljs$core$IFn$_invoke$arity$1(G__46523_46563) : cb_46562.call(null,G__46523_46563));
}catch (e46522){var e_46565 = e46522;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_46561,"while storing",cljs.core.deref(re_frame.trace.traces),e_46565], 0));
}

var G__46567 = cljs.core.next(seq__46500_46551__$1);
var G__46568 = null;
var G__46569 = (0);
var G__46570 = (0);
seq__46500_46530 = G__46567;
chunk__46501_46531 = G__46568;
count__46502_46532 = G__46569;
i__46503_46533 = G__46570;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=re_frame.trace.js.map
