goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e42561){var e = e42561;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4777__auto__ = [];
var len__4771__auto___42720 = arguments.length;
var i__4772__auto___42721 = (0);
while(true){
if((i__4772__auto___42721 < len__4771__auto___42720)){
args__4777__auto__.push((arguments[i__4772__auto___42721]));

var G__42722 = (i__4772__auto___42721 + (1));
i__4772__auto___42721 = G__42722;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__42569){
var vec__42570 = p__42569;
var map__42573 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42570,(0),null);
var map__42573__$1 = cljs.core.__destructure_map(map__42573);
var opts = map__42573__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42573__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42573__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42573__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42573__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__42574 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4160__auto__ = read_ch;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4160__auto__ = write_ch;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__42574__$1 = cljs.core.__destructure_map(map__42574);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42574__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42574__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__42564_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__42564_SHARP_);
}));

(web_socket.onclose = (function (p1__42565_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__42565_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__41040__auto___42723 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41041__auto__ = (function (){var switch__40970__auto__ = (function (state_42658){
var state_val_42659 = (state_42658[(1)]);
if((state_val_42659 === (7))){
var inst_42654 = (state_42658[(2)]);
var state_42658__$1 = state_42658;
var statearr_42660_42724 = state_42658__$1;
(statearr_42660_42724[(2)] = inst_42654);

(statearr_42660_42724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (20))){
var state_42658__$1 = state_42658;
var statearr_42663_42725 = state_42658__$1;
(statearr_42663_42725[(2)] = null);

(statearr_42663_42725[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (1))){
var inst_42577 = false;
var state_42658__$1 = (function (){var statearr_42665 = state_42658;
(statearr_42665[(7)] = inst_42577);

return statearr_42665;
})();
var statearr_42667_42726 = state_42658__$1;
(statearr_42667_42726[(2)] = null);

(statearr_42667_42726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (4))){
var inst_42593 = (state_42658[(8)]);
var inst_42587 = (state_42658[(9)]);
var inst_42595 = (state_42658[(10)]);
var inst_42593__$1 = (state_42658[(2)]);
var inst_42594 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42593__$1,(0),null);
var inst_42595__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42593__$1,(1),null);
var inst_42596 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42595__$1,inst_42587);
var state_42658__$1 = (function (){var statearr_42669 = state_42658;
(statearr_42669[(8)] = inst_42593__$1);

(statearr_42669[(11)] = inst_42594);

(statearr_42669[(10)] = inst_42595__$1);

return statearr_42669;
})();
if(inst_42596){
var statearr_42671_42727 = state_42658__$1;
(statearr_42671_42727[(1)] = (5));

} else {
var statearr_42672_42728 = state_42658__$1;
(statearr_42672_42728[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (15))){
var inst_42639 = (state_42658[(2)]);
var state_42658__$1 = state_42658;
var statearr_42675_42729 = state_42658__$1;
(statearr_42675_42729[(2)] = inst_42639);

(statearr_42675_42729[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (21))){
var inst_42650 = (state_42658[(2)]);
var state_42658__$1 = state_42658;
var statearr_42677_42730 = state_42658__$1;
(statearr_42677_42730[(2)] = inst_42650);

(statearr_42677_42730[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (13))){
var state_42658__$1 = state_42658;
var statearr_42679_42732 = state_42658__$1;
(statearr_42679_42732[(2)] = null);

(statearr_42679_42732[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (6))){
var inst_42595 = (state_42658[(10)]);
var inst_42588 = (state_42658[(12)]);
var inst_42611 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42595,inst_42588);
var state_42658__$1 = state_42658;
if(inst_42611){
var statearr_42680_42736 = state_42658__$1;
(statearr_42680_42736[(1)] = (9));

} else {
var statearr_42681_42737 = state_42658__$1;
(statearr_42681_42737[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (17))){
var state_42658__$1 = state_42658;
var statearr_42682_42741 = state_42658__$1;
(statearr_42682_42741[(2)] = initial_ch);

(statearr_42682_42741[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (3))){
var inst_42656 = (state_42658[(2)]);
var state_42658__$1 = state_42658;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42658__$1,inst_42656);
} else {
if((state_val_42659 === (12))){
var inst_42577 = (state_42658[(7)]);
var state_42658__$1 = state_42658;
if(cljs.core.truth_(inst_42577)){
var statearr_42685_42746 = state_42658__$1;
(statearr_42685_42746[(1)] = (16));

} else {
var statearr_42686_42747 = state_42658__$1;
(statearr_42686_42747[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (2))){
var inst_42587 = (state_42658[(9)]);
var inst_42588 = (state_42658[(12)]);
var inst_42587__$1 = open_ch;
var inst_42588__$1 = close_ch;
var inst_42589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42590 = [inst_42587__$1,inst_42588__$1];
var inst_42591 = (new cljs.core.PersistentVector(null,2,(5),inst_42589,inst_42590,null));
var state_42658__$1 = (function (){var statearr_42687 = state_42658;
(statearr_42687[(9)] = inst_42587__$1);

(statearr_42687[(12)] = inst_42588__$1);

return statearr_42687;
})();
return cljs.core.async.ioc_alts_BANG_(state_42658__$1,(4),inst_42591);
} else {
if((state_val_42659 === (19))){
var inst_42594 = (state_42658[(11)]);
var state_42658__$1 = state_42658;
var statearr_42688_42756 = state_42658__$1;
(statearr_42688_42756[(2)] = inst_42594);

(statearr_42688_42756[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (11))){
var inst_42652 = (state_42658[(2)]);
var state_42658__$1 = state_42658;
var statearr_42689_42758 = state_42658__$1;
(statearr_42689_42758[(2)] = inst_42652);

(statearr_42689_42758[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (9))){
var inst_42593 = (state_42658[(8)]);
var inst_42624 = (state_42658[(13)]);
var inst_42621 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42593,(0),null);
var inst_42624__$1 = chord.client.close_event__GT_maybe_error(inst_42621);
var state_42658__$1 = (function (){var statearr_42696 = state_42658;
(statearr_42696[(13)] = inst_42624__$1);

return statearr_42696;
})();
if(cljs.core.truth_(inst_42624__$1)){
var statearr_42697_42765 = state_42658__$1;
(statearr_42697_42765[(1)] = (12));

} else {
var statearr_42698_42766 = state_42658__$1;
(statearr_42698_42766[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (5))){
var inst_42593 = (state_42658[(8)]);
var inst_42601 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42593,(0),null);
var inst_42603 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_42604 = [ws_chan];
var inst_42605 = cljs.core.PersistentHashMap.fromArrays(inst_42603,inst_42604);
var state_42658__$1 = (function (){var statearr_42699 = state_42658;
(statearr_42699[(14)] = inst_42601);

return statearr_42699;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42658__$1,(8),initial_ch,inst_42605);
} else {
if((state_val_42659 === (14))){
var inst_42642 = (state_42658[(2)]);
var inst_42643 = cljs.core.async.close_BANG_(ws_chan);
var inst_42644 = cljs.core.async.close_BANG_(initial_ch);
var state_42658__$1 = (function (){var statearr_42701 = state_42658;
(statearr_42701[(15)] = inst_42643);

(statearr_42701[(16)] = inst_42642);

return statearr_42701;
})();
var statearr_42703_42773 = state_42658__$1;
(statearr_42703_42773[(2)] = inst_42644);

(statearr_42703_42773[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (16))){
var state_42658__$1 = state_42658;
var statearr_42706_42776 = state_42658__$1;
(statearr_42706_42776[(2)] = read_ch__$1);

(statearr_42706_42776[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (10))){
var inst_42595 = (state_42658[(10)]);
var inst_42646 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42595,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_42658__$1 = state_42658;
if(inst_42646){
var statearr_42709_42778 = state_42658__$1;
(statearr_42709_42778[(1)] = (19));

} else {
var statearr_42710_42779 = state_42658__$1;
(statearr_42710_42779[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42659 === (18))){
var inst_42624 = (state_42658[(13)]);
var inst_42634 = (state_42658[(2)]);
var inst_42635 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_42636 = [inst_42624];
var inst_42637 = cljs.core.PersistentHashMap.fromArrays(inst_42635,inst_42636);
var state_42658__$1 = state_42658;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42658__$1,(15),inst_42634,inst_42637);
} else {
if((state_val_42659 === (8))){
var inst_42607 = (state_42658[(2)]);
var inst_42608 = cljs.core.async.close_BANG_(initial_ch);
var inst_42577 = true;
var state_42658__$1 = (function (){var statearr_42713 = state_42658;
(statearr_42713[(7)] = inst_42577);

(statearr_42713[(17)] = inst_42607);

(statearr_42713[(18)] = inst_42608);

return statearr_42713;
})();
var statearr_42714_42780 = state_42658__$1;
(statearr_42714_42780[(2)] = null);

(statearr_42714_42780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__40971__auto__ = null;
var chord$client$state_machine__40971__auto____0 = (function (){
var statearr_42715 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42715[(0)] = chord$client$state_machine__40971__auto__);

(statearr_42715[(1)] = (1));

return statearr_42715;
});
var chord$client$state_machine__40971__auto____1 = (function (state_42658){
while(true){
var ret_value__40972__auto__ = (function (){try{while(true){
var result__40973__auto__ = switch__40970__auto__(state_42658);
if(cljs.core.keyword_identical_QMARK_(result__40973__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__40973__auto__;
}
break;
}
}catch (e42716){var ex__40974__auto__ = e42716;
var statearr_42717_42781 = state_42658;
(statearr_42717_42781[(2)] = ex__40974__auto__);


if(cljs.core.seq((state_42658[(4)]))){
var statearr_42718_42783 = state_42658;
(statearr_42718_42783[(1)] = cljs.core.first((state_42658[(4)])));

} else {
throw ex__40974__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__40972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42786 = state_42658;
state_42658 = G__42786;
continue;
} else {
return ret_value__40972__auto__;
}
break;
}
});
chord$client$state_machine__40971__auto__ = function(state_42658){
switch(arguments.length){
case 0:
return chord$client$state_machine__40971__auto____0.call(this);
case 1:
return chord$client$state_machine__40971__auto____1.call(this,state_42658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__40971__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__40971__auto____0;
chord$client$state_machine__40971__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__40971__auto____1;
return chord$client$state_machine__40971__auto__;
})()
})();
var state__41042__auto__ = (function (){var statearr_42719 = f__41041__auto__();
(statearr_42719[(6)] = c__41040__auto___42723);

return statearr_42719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41042__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq42567){
var G__42568 = cljs.core.first(seq42567);
var seq42567__$1 = cljs.core.next(seq42567);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42568,seq42567__$1);
}));


//# sourceMappingURL=chord.client.js.map
