goog.provide('pinkgorilla.ui.viz.leaflet');
var module$node_modules$react_leaflet$lib$index=shadow.js.require("module$node_modules$react_leaflet$lib$index", {});
var module$node_modules$leaflet$dist$leaflet_src=shadow.js.require("module$node_modules$leaflet$dist$leaflet_src", {});
pinkgorilla.ui.viz.leaflet.res_href = (function pinkgorilla$ui$viz$leaflet$res_href(href){
return ["/r/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(href)].join('');
});
pinkgorilla.ui.viz.leaflet.config = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tile-layer-url","tile-layer-url",-1729025633),"https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png",new cljs.core.Keyword(null,"attribution","attribution",1937239286),"&copy; <a href=&quot;http://osm.org/copyright&quot;>OpenStreetMap</a> contributors"], null);
pinkgorilla.ui.viz.leaflet.marker = (function pinkgorilla$ui$viz$leaflet$marker(){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"icon","icon",1679606541),(new module$node_modules$leaflet$dist$leaflet_src.Icon(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"iconUrl","iconUrl",-1868537869),pinkgorilla.ui.viz.leaflet.res_href("leaflet/dist/images/marker-icon.png"),new cljs.core.Keyword(null,"iconRetinaUrl","iconRetinaUrl",932366134),pinkgorilla.ui.viz.leaflet.res_href("leaflet/dist/images/marker-icon-2x.png"),new cljs.core.Keyword(null,"iconAnchor","iconAnchor",970343173),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(5),(55)], null),new cljs.core.Keyword(null,"popupAnchor","popupAnchor",931949236),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(10),(-44)], null),new cljs.core.Keyword(null,"iconSize","iconSize",253109071),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(25),(55)], null),new cljs.core.Keyword(null,"shadowUrl","shadowUrl",1986496437),pinkgorilla.ui.viz.leaflet.res_href("leaflet/dist/images/marker-shadow.png"),new cljs.core.Keyword(null,"shadowSize","shadowSize",-1015046863),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(68),(95)], null),new cljs.core.Keyword(null,"shadowAnchor","shadowAnchor",643451688),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(20),(92)], null)], null))))], null);
});
pinkgorilla.ui.viz.leaflet.log = (function pinkgorilla$ui$viz$leaflet$log(s){
return console.log(s);
});
pinkgorilla.ui.viz.leaflet.feature = (function pinkgorilla$ui$viz$leaflet$feature(data_with_type){
var type = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(data_with_type);
var data = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(data_with_type,new cljs.core.Keyword(null,"type","type",1174270348));
var G__41939 = type;
var G__41939__$1 = (((G__41939 instanceof cljs.core.Keyword))?G__41939.fqn:null);
switch (G__41939__$1) {
case "rectangle":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Rectangle,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "circle":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Circle,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "line":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Polyline,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "polygon":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Polygon,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "marker":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Marker,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.ui.viz.leaflet.marker(),data], 0)),(((!((new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data) == null))))?cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Popup,new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null)):null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "circlemarker":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.CircleMarker,data,(((!((new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data) == null))))?cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Popup,new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null)):null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "geojson":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.GeoJSON,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
default:
pinkgorilla.ui.viz.leaflet.log(["No feature found for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''));

return null;

}
});
pinkgorilla.ui.viz.leaflet.view_QMARK_ = (function pinkgorilla$ui$viz$leaflet$view_QMARK_(feature){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(feature));
});
pinkgorilla.ui.viz.leaflet.assoc_if_exists = (function pinkgorilla$ui$viz$leaflet$assoc_if_exists(m,key,val){
if((val == null)){
return m;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,key,val);
}
});
pinkgorilla.ui.viz.leaflet.view_map_props = (function pinkgorilla$ui$viz$leaflet$view_map_props(view){
var map__41972 = view;
var map__41972__$1 = cljs.core.__destructure_map(map__41972);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41972__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41972__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var zoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41972__$1,new cljs.core.Keyword(null,"zoom","zoom",-1827487038));
var center = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41972__$1,new cljs.core.Keyword(null,"center","center",-748944368));
var useFlyTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41972__$1,new cljs.core.Keyword(null,"useFlyTo","useFlyTo",1726688032));
var style = (cljs.core.truth_((function (){var or__4160__auto__ = width;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return height;
}
})())?pinkgorilla.ui.viz.leaflet.assoc_if_exists(pinkgorilla.ui.viz.leaflet.assoc_if_exists(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"width","width",-384071477),width),new cljs.core.Keyword(null,"height","height",1025178622),height):null);
return pinkgorilla.ui.viz.leaflet.assoc_if_exists(pinkgorilla.ui.viz.leaflet.assoc_if_exists(pinkgorilla.ui.viz.leaflet.assoc_if_exists(pinkgorilla.ui.viz.leaflet.assoc_if_exists(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"style","style",-496642736),style),new cljs.core.Keyword(null,"zoom","zoom",-1827487038),zoom),new cljs.core.Keyword(null,"center","center",-748944368),center),new cljs.core.Keyword(null,"useFlyTo","useFlyTo",1726688032),useFlyTo);
});
/**
 * displays a map with leaflet.
 * example:
 *   [:p/leaflet
 * [{:type :view :center [51.49, -0.08] :zoom 12 :height 600 :width 700}
 *  {:type :rectangle :bounds rectangle}
 *  {:type :circle :center center :fillColor :blue :radius 200}
 *  {:type :polygon :positions polygon :color :purple}
 *  {:type :polygon :positions multiPolygon :color :purple}
 *  {:type :line :positions polyline :color :lime}
 *  {:type :line :positions multi-polyline :color :lime}
 *  {:type :marker :position [51.505, -0.09]}
 *  {:type :marker :position [51.51, -0.12] :popup "wow"}
 *  {:type :circlemarker :center [51.52, -0.06] :fillColor :blue :radius 200 :popup "square the circle"}
 *  {:type :geojson :data geojson}]]
 */
pinkgorilla.ui.viz.leaflet.leaflet_map = (function pinkgorilla$ui$viz$leaflet$leaflet_map(var_args){
var G__41978 = arguments.length;
switch (G__41978) {
case 2:
return pinkgorilla.ui.viz.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return pinkgorilla.ui.viz.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(pinkgorilla.ui.viz.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$2 = (function (options,features_incl_view){
var map__41979 = pinkgorilla.ui.viz.leaflet.config;
var map__41979__$1 = cljs.core.__destructure_map(map__41979);
var css = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41979__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var tile_layer_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41979__$1,new cljs.core.Keyword(null,"tile-layer-url","tile-layer-url",-1729025633));
var attribution = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41979__$1,new cljs.core.Keyword(null,"attribution","attribution",1937239286));
var map__41980 = options;
var map__41980__$1 = cljs.core.__destructure_map(map__41980);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41980__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41980__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var zoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41980__$1,new cljs.core.Keyword(null,"zoom","zoom",-1827487038));
var center = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41980__$1,new cljs.core.Keyword(null,"center","center",-748944368));
var view = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.viz.leaflet.view_QMARK_,features_incl_view));
var features = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.viz.leaflet.view_QMARK_,features_incl_view);
var view_map = pinkgorilla.ui.viz.leaflet.view_map_props(view);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.z-10","div.z-10",-323390226),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.MapContainer,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"zoom","zoom",-1827487038),zoom,new cljs.core.Keyword(null,"center","center",-748944368),center,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),width,new cljs.core.Keyword(null,"height","height",1025178622),height], null),new cljs.core.Keyword(null,"keyboard","keyboard",-617357087),true,new cljs.core.Keyword(null,"class","class",-2030961996),"z-10"], null),view_map], 0)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.TileLayer,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),tile_layer_url,new cljs.core.Keyword(null,"attribution","attribution",1937239286),attribution], null)], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386)], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.viz.leaflet.feature,features))], null)], null);
}));

(pinkgorilla.ui.viz.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$1 = (function (features){
return pinkgorilla.ui.viz.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.dsl.leaflet.default_options,features);
}));

(pinkgorilla.ui.viz.leaflet.leaflet_map.cljs$lang$maxFixedArity = 2);

pinkgorilla.ui.viz.leaflet.leaflet_map_default = (function pinkgorilla$ui$viz$leaflet$leaflet_map_default(data){
var map__41984 = data;
var map__41984__$1 = cljs.core.__destructure_map(map__41984);
var features = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41984__$1,new cljs.core.Keyword(null,"features","features",-1146962336));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.viz.leaflet.leaflet_map,pinkgorilla.dsl.leaflet.default_options,features], null);
});
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkie.pinkie.component_registry,cljs.core.assoc,new cljs.core.Keyword("p","leaflet","p/leaflet",1547983832),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fun","fun",-1265158045),pinkgorilla.ui.viz.leaflet.leaflet_map_default,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core.meta(new cljs.core.Var(function(){return pinkgorilla.ui.viz.leaflet.leaflet_map_default;},new cljs.core.Symbol("pinkgorilla.ui.viz.leaflet","leaflet-map-default","pinkgorilla.ui.viz.leaflet/leaflet-map-default",1427564742,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"pinkgorilla.ui.viz.leaflet","pinkgorilla.ui.viz.leaflet",-1265138347,null),new cljs.core.Symbol(null,"leaflet-map-default","leaflet-map-default",-81064216,null),"pinkgorilla/ui/viz/leaflet.cljs",26,1,148,148,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"data","data",1407862150,null)], null)),null,(cljs.core.truth_(pinkgorilla.ui.viz.leaflet.leaflet_map_default)?pinkgorilla.ui.viz.leaflet.leaflet_map_default.cljs$lang$test:null)]))),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword("p","leaflet","p/leaflet",1547983832)], null));

//# sourceMappingURL=pinkgorilla.ui.viz.leaflet.js.map
