goog.provide('re_frame.fx');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed, other than that
 *   `:db` is guaranteed to be executed first.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__46794 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__46795 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__46795);

try{try{var effects = new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context);
var effects_without_db = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(effects,new cljs.core.Keyword(null,"db","db",993250759));
var temp__5754__auto___46895 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(effects);
if(cljs.core.truth_(temp__5754__auto___46895)){
var new_db_46896 = temp__5754__auto___46895;
var fexpr__46798_46901 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,new cljs.core.Keyword(null,"db","db",993250759),false);
(fexpr__46798_46901.cljs$core$IFn$_invoke$arity$1 ? fexpr__46798_46901.cljs$core$IFn$_invoke$arity$1(new_db_46896) : fexpr__46798_46901.call(null,new_db_46896));
} else {
}

var seq__46799 = cljs.core.seq(effects_without_db);
var chunk__46800 = null;
var count__46801 = (0);
var i__46802 = (0);
while(true){
if((i__46802 < count__46801)){
var vec__46812 = chunk__46800.cljs$core$IIndexed$_nth$arity$2(null,i__46802);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46812,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46812,(1),null);
var temp__5752__auto___46906 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___46906)){
var effect_fn_46907 = temp__5752__auto___46906;
(effect_fn_46907.cljs$core$IFn$_invoke$arity$1 ? effect_fn_46907.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_46907.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__46908 = seq__46799;
var G__46909 = chunk__46800;
var G__46910 = count__46801;
var G__46911 = (i__46802 + (1));
seq__46799 = G__46908;
chunk__46800 = G__46909;
count__46801 = G__46910;
i__46802 = G__46911;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__46799);
if(temp__5754__auto__){
var seq__46799__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46799__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46799__$1);
var G__46912 = cljs.core.chunk_rest(seq__46799__$1);
var G__46913 = c__4591__auto__;
var G__46914 = cljs.core.count(c__4591__auto__);
var G__46915 = (0);
seq__46799 = G__46912;
chunk__46800 = G__46913;
count__46801 = G__46914;
i__46802 = G__46915;
continue;
} else {
var vec__46816 = cljs.core.first(seq__46799__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46816,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46816,(1),null);
var temp__5752__auto___46916 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___46916)){
var effect_fn_46917 = temp__5752__auto___46916;
(effect_fn_46917.cljs$core$IFn$_invoke$arity$1 ? effect_fn_46917.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_46917.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__46918 = cljs.core.next(seq__46799__$1);
var G__46919 = null;
var G__46920 = (0);
var G__46921 = (0);
seq__46799 = G__46918;
chunk__46800 = G__46919;
count__46801 = G__46920;
i__46802 = G__46921;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__46478__auto___46922 = re_frame.interop.now();
var duration__46479__auto___46923 = (end__46478__auto___46922 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__46479__auto___46923,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__46478__auto___46922);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__46794);
}} else {
var effects = new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context);
var effects_without_db = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(effects,new cljs.core.Keyword(null,"db","db",993250759));
var temp__5754__auto___46924 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(effects);
if(cljs.core.truth_(temp__5754__auto___46924)){
var new_db_46925 = temp__5754__auto___46924;
var fexpr__46820_46926 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,new cljs.core.Keyword(null,"db","db",993250759),false);
(fexpr__46820_46926.cljs$core$IFn$_invoke$arity$1 ? fexpr__46820_46926.cljs$core$IFn$_invoke$arity$1(new_db_46925) : fexpr__46820_46926.call(null,new_db_46925));
} else {
}

var seq__46821 = cljs.core.seq(effects_without_db);
var chunk__46822 = null;
var count__46823 = (0);
var i__46824 = (0);
while(true){
if((i__46824 < count__46823)){
var vec__46833 = chunk__46822.cljs$core$IIndexed$_nth$arity$2(null,i__46824);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46833,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46833,(1),null);
var temp__5752__auto___46927 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___46927)){
var effect_fn_46928 = temp__5752__auto___46927;
(effect_fn_46928.cljs$core$IFn$_invoke$arity$1 ? effect_fn_46928.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_46928.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__46929 = seq__46821;
var G__46930 = chunk__46822;
var G__46931 = count__46823;
var G__46932 = (i__46824 + (1));
seq__46821 = G__46929;
chunk__46822 = G__46930;
count__46823 = G__46931;
i__46824 = G__46932;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__46821);
if(temp__5754__auto__){
var seq__46821__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46821__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46821__$1);
var G__46935 = cljs.core.chunk_rest(seq__46821__$1);
var G__46936 = c__4591__auto__;
var G__46937 = cljs.core.count(c__4591__auto__);
var G__46938 = (0);
seq__46821 = G__46935;
chunk__46822 = G__46936;
count__46823 = G__46937;
i__46824 = G__46938;
continue;
} else {
var vec__46837 = cljs.core.first(seq__46821__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46837,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46837,(1),null);
var temp__5752__auto___46939 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___46939)){
var effect_fn_46940 = temp__5752__auto___46939;
(effect_fn_46940.cljs$core$IFn$_invoke$arity$1 ? effect_fn_46940.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_46940.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__46941 = cljs.core.next(seq__46821__$1);
var G__46942 = null;
var G__46943 = (0);
var G__46944 = (0);
seq__46821 = G__46941;
chunk__46822 = G__46942;
count__46823 = G__46943;
i__46824 = G__46944;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.dispatch_later = (function re_frame$fx$dispatch_later(p__46841){
var map__46842 = p__46841;
var map__46842__$1 = cljs.core.__destructure_map(map__46842);
var effect = map__46842__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46842__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46842__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
return re_frame.interop.set_timeout_BANG_((function (){
return re_frame.router.dispatch(dispatch);
}),ms);
}
});
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
if(cljs.core.map_QMARK_(value)){
return re_frame.fx.dispatch_later(value);
} else {
var seq__46843 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__46844 = null;
var count__46845 = (0);
var i__46846 = (0);
while(true){
if((i__46846 < count__46845)){
var effect = chunk__46844.cljs$core$IIndexed$_nth$arity$2(null,i__46846);
re_frame.fx.dispatch_later(effect);


var G__46950 = seq__46843;
var G__46951 = chunk__46844;
var G__46952 = count__46845;
var G__46953 = (i__46846 + (1));
seq__46843 = G__46950;
chunk__46844 = G__46951;
count__46845 = G__46952;
i__46846 = G__46953;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__46843);
if(temp__5754__auto__){
var seq__46843__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46843__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46843__$1);
var G__46954 = cljs.core.chunk_rest(seq__46843__$1);
var G__46955 = c__4591__auto__;
var G__46956 = cljs.core.count(c__4591__auto__);
var G__46957 = (0);
seq__46843 = G__46954;
chunk__46844 = G__46955;
count__46845 = G__46956;
i__46846 = G__46957;
continue;
} else {
var effect = cljs.core.first(seq__46843__$1);
re_frame.fx.dispatch_later(effect);


var G__46958 = cljs.core.next(seq__46843__$1);
var G__46959 = null;
var G__46960 = (0);
var G__46961 = (0);
seq__46843 = G__46958;
chunk__46844 = G__46959;
count__46845 = G__46960;
i__46846 = G__46961;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"fx","fx",-1237829572),(function (seq_of_effects){
if((!(cljs.core.sequential_QMARK_(seq_of_effects)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect expects a seq, but was given ",cljs.core.type(seq_of_effects)], 0));
} else {
var seq__46847 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,seq_of_effects));
var chunk__46848 = null;
var count__46849 = (0);
var i__46850 = (0);
while(true){
if((i__46850 < count__46849)){
var vec__46858 = chunk__46848.cljs$core$IIndexed$_nth$arity$2(null,i__46850);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46858,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46858,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"db","db",993250759),effect_key)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect should not contain a :db effect"], 0));
} else {
}

var temp__5752__auto___46964 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___46964)){
var effect_fn_46965 = temp__5752__auto___46964;
(effect_fn_46965.cljs$core$IFn$_invoke$arity$1 ? effect_fn_46965.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_46965.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: in \":fx\" effect found ",effect_key," which has no associated handler. Ignoring."], 0));
}


var G__46966 = seq__46847;
var G__46967 = chunk__46848;
var G__46968 = count__46849;
var G__46969 = (i__46850 + (1));
seq__46847 = G__46966;
chunk__46848 = G__46967;
count__46849 = G__46968;
i__46850 = G__46969;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__46847);
if(temp__5754__auto__){
var seq__46847__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46847__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46847__$1);
var G__46971 = cljs.core.chunk_rest(seq__46847__$1);
var G__46972 = c__4591__auto__;
var G__46973 = cljs.core.count(c__4591__auto__);
var G__46974 = (0);
seq__46847 = G__46971;
chunk__46848 = G__46972;
count__46849 = G__46973;
i__46850 = G__46974;
continue;
} else {
var vec__46867 = cljs.core.first(seq__46847__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46867,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46867,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"db","db",993250759),effect_key)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect should not contain a :db effect"], 0));
} else {
}

var temp__5752__auto___46977 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___46977)){
var effect_fn_46979 = temp__5752__auto___46977;
(effect_fn_46979.cljs$core$IFn$_invoke$arity$1 ? effect_fn_46979.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_46979.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: in \":fx\" effect found ",effect_key," which has no associated handler. Ignoring."], 0));
}


var G__46981 = cljs.core.next(seq__46847__$1);
var G__46982 = null;
var G__46983 = (0);
var G__46984 = (0);
seq__46847 = G__46981;
chunk__46848 = G__46982;
count__46849 = G__46983;
i__46850 = G__46984;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__46872 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__46873 = null;
var count__46874 = (0);
var i__46875 = (0);
while(true){
if((i__46875 < count__46874)){
var event = chunk__46873.cljs$core$IIndexed$_nth$arity$2(null,i__46875);
re_frame.router.dispatch(event);


var G__46988 = seq__46872;
var G__46989 = chunk__46873;
var G__46990 = count__46874;
var G__46991 = (i__46875 + (1));
seq__46872 = G__46988;
chunk__46873 = G__46989;
count__46874 = G__46990;
i__46875 = G__46991;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__46872);
if(temp__5754__auto__){
var seq__46872__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46872__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46872__$1);
var G__46992 = cljs.core.chunk_rest(seq__46872__$1);
var G__46993 = c__4591__auto__;
var G__46994 = cljs.core.count(c__4591__auto__);
var G__46995 = (0);
seq__46872 = G__46992;
chunk__46873 = G__46993;
count__46874 = G__46994;
i__46875 = G__46995;
continue;
} else {
var event = cljs.core.first(seq__46872__$1);
re_frame.router.dispatch(event);


var G__47000 = cljs.core.next(seq__46872__$1);
var G__47001 = null;
var G__47002 = (0);
var G__47003 = (0);
seq__46872 = G__47000;
chunk__46873 = G__47001;
count__46874 = G__47002;
i__46875 = G__47003;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__46877 = cljs.core.seq(value);
var chunk__46878 = null;
var count__46879 = (0);
var i__46880 = (0);
while(true){
if((i__46880 < count__46879)){
var event = chunk__46878.cljs$core$IIndexed$_nth$arity$2(null,i__46880);
clear_event(event);


var G__47004 = seq__46877;
var G__47005 = chunk__46878;
var G__47006 = count__46879;
var G__47007 = (i__46880 + (1));
seq__46877 = G__47004;
chunk__46878 = G__47005;
count__46879 = G__47006;
i__46880 = G__47007;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__46877);
if(temp__5754__auto__){
var seq__46877__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46877__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46877__$1);
var G__47008 = cljs.core.chunk_rest(seq__46877__$1);
var G__47009 = c__4591__auto__;
var G__47010 = cljs.core.count(c__4591__auto__);
var G__47011 = (0);
seq__46877 = G__47008;
chunk__46878 = G__47009;
count__46879 = G__47010;
i__46880 = G__47011;
continue;
} else {
var event = cljs.core.first(seq__46877__$1);
clear_event(event);


var G__47015 = cljs.core.next(seq__46877__$1);
var G__47016 = null;
var G__47017 = (0);
var G__47018 = (0);
seq__46877 = G__47015;
chunk__46878 = G__47016;
count__46879 = G__47017;
i__46880 = G__47018;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
