goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__46463 = arguments.length;
switch (G__46463) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46467 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46467 = (function (f,blockable,meta46468){
this.f = f;
this.blockable = blockable;
this.meta46468 = meta46468;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46467.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46469,meta46468__$1){
var self__ = this;
var _46469__$1 = this;
return (new cljs.core.async.t_cljs$core$async46467(self__.f,self__.blockable,meta46468__$1));
}));

(cljs.core.async.t_cljs$core$async46467.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46469){
var self__ = this;
var _46469__$1 = this;
return self__.meta46468;
}));

(cljs.core.async.t_cljs$core$async46467.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46467.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async46467.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async46467.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async46467.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta46468","meta46468",-750954904,null)], null);
}));

(cljs.core.async.t_cljs$core$async46467.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46467.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46467");

(cljs.core.async.t_cljs$core$async46467.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async46467");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46467.
 */
cljs.core.async.__GT_t_cljs$core$async46467 = (function cljs$core$async$__GT_t_cljs$core$async46467(f__$1,blockable__$1,meta46468){
return (new cljs.core.async.t_cljs$core$async46467(f__$1,blockable__$1,meta46468));
});

}

return (new cljs.core.async.t_cljs$core$async46467(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__46482 = arguments.length;
switch (G__46482) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__46486 = arguments.length;
switch (G__46486) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__46493 = arguments.length;
switch (G__46493) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_48713 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_48713) : fn1.call(null,val_48713));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_48713) : fn1.call(null,val_48713));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__46501 = arguments.length;
switch (G__46501) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5752__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5752__auto__)){
var ret = temp__5752__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5752__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5752__auto__)){
var retb = temp__5752__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4648__auto___48715 = n;
var x_48716 = (0);
while(true){
if((x_48716 < n__4648__auto___48715)){
(a[x_48716] = x_48716);

var G__48717 = (x_48716 + (1));
x_48716 = G__48717;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46510 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46510 = (function (flag,meta46511){
this.flag = flag;
this.meta46511 = meta46511;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46510.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46512,meta46511__$1){
var self__ = this;
var _46512__$1 = this;
return (new cljs.core.async.t_cljs$core$async46510(self__.flag,meta46511__$1));
}));

(cljs.core.async.t_cljs$core$async46510.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46512){
var self__ = this;
var _46512__$1 = this;
return self__.meta46511;
}));

(cljs.core.async.t_cljs$core$async46510.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46510.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async46510.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async46510.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async46510.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta46511","meta46511",546350797,null)], null);
}));

(cljs.core.async.t_cljs$core$async46510.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46510.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46510");

(cljs.core.async.t_cljs$core$async46510.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async46510");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46510.
 */
cljs.core.async.__GT_t_cljs$core$async46510 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async46510(flag__$1,meta46511){
return (new cljs.core.async.t_cljs$core$async46510(flag__$1,meta46511));
});

}

return (new cljs.core.async.t_cljs$core$async46510(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46529 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46529 = (function (flag,cb,meta46530){
this.flag = flag;
this.cb = cb;
this.meta46530 = meta46530;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46529.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46531,meta46530__$1){
var self__ = this;
var _46531__$1 = this;
return (new cljs.core.async.t_cljs$core$async46529(self__.flag,self__.cb,meta46530__$1));
}));

(cljs.core.async.t_cljs$core$async46529.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46531){
var self__ = this;
var _46531__$1 = this;
return self__.meta46530;
}));

(cljs.core.async.t_cljs$core$async46529.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46529.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async46529.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async46529.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async46529.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta46530","meta46530",71369875,null)], null);
}));

(cljs.core.async.t_cljs$core$async46529.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46529.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46529");

(cljs.core.async.t_cljs$core$async46529.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async46529");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46529.
 */
cljs.core.async.__GT_t_cljs$core$async46529 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async46529(flag__$1,cb__$1,meta46530){
return (new cljs.core.async.t_cljs$core$async46529(flag__$1,cb__$1,meta46530));
});

}

return (new cljs.core.async.t_cljs$core$async46529(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__46540_SHARP_){
var G__46547 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__46540_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__46547) : fret.call(null,G__46547));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__46541_SHARP_){
var G__46548 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__46541_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__46548) : fret.call(null,G__46548));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4160__auto__ = wport;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return port;
}
})()], null));
} else {
var G__48721 = (i + (1));
i = G__48721;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4160__auto__ = ret;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5754__auto__ = (function (){var and__4149__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4149__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4149__auto__;
}
})();
if(cljs.core.truth_(temp__5754__auto__)){
var got = temp__5754__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___48732 = arguments.length;
var i__4772__auto___48733 = (0);
while(true){
if((i__4772__auto___48733 < len__4771__auto___48732)){
args__4777__auto__.push((arguments[i__4772__auto___48733]));

var G__48734 = (i__4772__auto___48733 + (1));
i__4772__auto___48733 = G__48734;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__46558){
var map__46559 = p__46558;
var map__46559__$1 = cljs.core.__destructure_map(map__46559);
var opts = map__46559__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq46556){
var G__46557 = cljs.core.first(seq46556);
var seq46556__$1 = cljs.core.next(seq46556);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46557,seq46556__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__46562 = arguments.length;
switch (G__46562) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__46308__auto___48743 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_46588){
var state_val_46589 = (state_46588[(1)]);
if((state_val_46589 === (7))){
var inst_46584 = (state_46588[(2)]);
var state_46588__$1 = state_46588;
var statearr_46599_48744 = state_46588__$1;
(statearr_46599_48744[(2)] = inst_46584);

(statearr_46599_48744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46589 === (1))){
var state_46588__$1 = state_46588;
var statearr_46600_48745 = state_46588__$1;
(statearr_46600_48745[(2)] = null);

(statearr_46600_48745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46589 === (4))){
var inst_46567 = (state_46588[(7)]);
var inst_46567__$1 = (state_46588[(2)]);
var inst_46568 = (inst_46567__$1 == null);
var state_46588__$1 = (function (){var statearr_46604 = state_46588;
(statearr_46604[(7)] = inst_46567__$1);

return statearr_46604;
})();
if(cljs.core.truth_(inst_46568)){
var statearr_46605_48746 = state_46588__$1;
(statearr_46605_48746[(1)] = (5));

} else {
var statearr_46606_48748 = state_46588__$1;
(statearr_46606_48748[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46589 === (13))){
var state_46588__$1 = state_46588;
var statearr_46610_48750 = state_46588__$1;
(statearr_46610_48750[(2)] = null);

(statearr_46610_48750[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46589 === (6))){
var inst_46567 = (state_46588[(7)]);
var state_46588__$1 = state_46588;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46588__$1,(11),to,inst_46567);
} else {
if((state_val_46589 === (3))){
var inst_46586 = (state_46588[(2)]);
var state_46588__$1 = state_46588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46588__$1,inst_46586);
} else {
if((state_val_46589 === (12))){
var state_46588__$1 = state_46588;
var statearr_46614_48751 = state_46588__$1;
(statearr_46614_48751[(2)] = null);

(statearr_46614_48751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46589 === (2))){
var state_46588__$1 = state_46588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46588__$1,(4),from);
} else {
if((state_val_46589 === (11))){
var inst_46577 = (state_46588[(2)]);
var state_46588__$1 = state_46588;
if(cljs.core.truth_(inst_46577)){
var statearr_46615_48752 = state_46588__$1;
(statearr_46615_48752[(1)] = (12));

} else {
var statearr_46616_48753 = state_46588__$1;
(statearr_46616_48753[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46589 === (9))){
var state_46588__$1 = state_46588;
var statearr_46617_48754 = state_46588__$1;
(statearr_46617_48754[(2)] = null);

(statearr_46617_48754[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46589 === (5))){
var state_46588__$1 = state_46588;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46618_48755 = state_46588__$1;
(statearr_46618_48755[(1)] = (8));

} else {
var statearr_46620_48756 = state_46588__$1;
(statearr_46620_48756[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46589 === (14))){
var inst_46582 = (state_46588[(2)]);
var state_46588__$1 = state_46588;
var statearr_46622_48757 = state_46588__$1;
(statearr_46622_48757[(2)] = inst_46582);

(statearr_46622_48757[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46589 === (10))){
var inst_46574 = (state_46588[(2)]);
var state_46588__$1 = state_46588;
var statearr_46623_48758 = state_46588__$1;
(statearr_46623_48758[(2)] = inst_46574);

(statearr_46623_48758[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46589 === (8))){
var inst_46571 = cljs.core.async.close_BANG_(to);
var state_46588__$1 = state_46588;
var statearr_46624_48761 = state_46588__$1;
(statearr_46624_48761[(2)] = inst_46571);

(statearr_46624_48761[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46108__auto__ = null;
var cljs$core$async$state_machine__46108__auto____0 = (function (){
var statearr_46625 = [null,null,null,null,null,null,null,null];
(statearr_46625[(0)] = cljs$core$async$state_machine__46108__auto__);

(statearr_46625[(1)] = (1));

return statearr_46625;
});
var cljs$core$async$state_machine__46108__auto____1 = (function (state_46588){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_46588);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e46629){var ex__46111__auto__ = e46629;
var statearr_46630_48762 = state_46588;
(statearr_46630_48762[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_46588[(4)]))){
var statearr_46631_48763 = state_46588;
(statearr_46631_48763[(1)] = cljs.core.first((state_46588[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48764 = state_46588;
state_46588 = G__48764;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$state_machine__46108__auto__ = function(state_46588){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46108__auto____1.call(this,state_46588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46108__auto____0;
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46108__auto____1;
return cljs$core$async$state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_46632 = f__46309__auto__();
(statearr_46632[(6)] = c__46308__auto___48743);

return statearr_46632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__46633){
var vec__46634 = p__46633;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46634,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46634,(1),null);
var job = vec__46634;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__46308__auto___48768 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_46641){
var state_val_46642 = (state_46641[(1)]);
if((state_val_46642 === (1))){
var state_46641__$1 = state_46641;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46641__$1,(2),res,v);
} else {
if((state_val_46642 === (2))){
var inst_46638 = (state_46641[(2)]);
var inst_46639 = cljs.core.async.close_BANG_(res);
var state_46641__$1 = (function (){var statearr_46643 = state_46641;
(statearr_46643[(7)] = inst_46638);

return statearr_46643;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46641__$1,inst_46639);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0 = (function (){
var statearr_46644 = [null,null,null,null,null,null,null,null];
(statearr_46644[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__);

(statearr_46644[(1)] = (1));

return statearr_46644;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1 = (function (state_46641){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_46641);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e46646){var ex__46111__auto__ = e46646;
var statearr_46647_48770 = state_46641;
(statearr_46647_48770[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_46641[(4)]))){
var statearr_46648_48771 = state_46641;
(statearr_46648_48771[(1)] = cljs.core.first((state_46641[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48772 = state_46641;
state_46641 = G__48772;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__ = function(state_46641){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1.call(this,state_46641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_46649 = f__46309__auto__();
(statearr_46649[(6)] = c__46308__auto___48768);

return statearr_46649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__46650){
var vec__46651 = p__46650;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46651,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46651,(1),null);
var job = vec__46651;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4648__auto___48777 = n;
var __48778 = (0);
while(true){
if((__48778 < n__4648__auto___48777)){
var G__46655_48780 = type;
var G__46655_48781__$1 = (((G__46655_48780 instanceof cljs.core.Keyword))?G__46655_48780.fqn:null);
switch (G__46655_48781__$1) {
case "compute":
var c__46308__auto___48783 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__48778,c__46308__auto___48783,G__46655_48780,G__46655_48781__$1,n__4648__auto___48777,jobs,results,process,async){
return (function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = ((function (__48778,c__46308__auto___48783,G__46655_48780,G__46655_48781__$1,n__4648__auto___48777,jobs,results,process,async){
return (function (state_46668){
var state_val_46669 = (state_46668[(1)]);
if((state_val_46669 === (1))){
var state_46668__$1 = state_46668;
var statearr_46670_48788 = state_46668__$1;
(statearr_46670_48788[(2)] = null);

(statearr_46670_48788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46669 === (2))){
var state_46668__$1 = state_46668;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46668__$1,(4),jobs);
} else {
if((state_val_46669 === (3))){
var inst_46666 = (state_46668[(2)]);
var state_46668__$1 = state_46668;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46668__$1,inst_46666);
} else {
if((state_val_46669 === (4))){
var inst_46658 = (state_46668[(2)]);
var inst_46659 = process(inst_46658);
var state_46668__$1 = state_46668;
if(cljs.core.truth_(inst_46659)){
var statearr_46671_48790 = state_46668__$1;
(statearr_46671_48790[(1)] = (5));

} else {
var statearr_46672_48792 = state_46668__$1;
(statearr_46672_48792[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46669 === (5))){
var state_46668__$1 = state_46668;
var statearr_46673_48793 = state_46668__$1;
(statearr_46673_48793[(2)] = null);

(statearr_46673_48793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46669 === (6))){
var state_46668__$1 = state_46668;
var statearr_46675_48794 = state_46668__$1;
(statearr_46675_48794[(2)] = null);

(statearr_46675_48794[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46669 === (7))){
var inst_46664 = (state_46668[(2)]);
var state_46668__$1 = state_46668;
var statearr_46676_48795 = state_46668__$1;
(statearr_46676_48795[(2)] = inst_46664);

(statearr_46676_48795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48778,c__46308__auto___48783,G__46655_48780,G__46655_48781__$1,n__4648__auto___48777,jobs,results,process,async))
;
return ((function (__48778,switch__46107__auto__,c__46308__auto___48783,G__46655_48780,G__46655_48781__$1,n__4648__auto___48777,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0 = (function (){
var statearr_46677 = [null,null,null,null,null,null,null];
(statearr_46677[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__);

(statearr_46677[(1)] = (1));

return statearr_46677;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1 = (function (state_46668){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_46668);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e46678){var ex__46111__auto__ = e46678;
var statearr_46679_48796 = state_46668;
(statearr_46679_48796[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_46668[(4)]))){
var statearr_46680_48797 = state_46668;
(statearr_46680_48797[(1)] = cljs.core.first((state_46668[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48798 = state_46668;
state_46668 = G__48798;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__ = function(state_46668){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1.call(this,state_46668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__;
})()
;})(__48778,switch__46107__auto__,c__46308__auto___48783,G__46655_48780,G__46655_48781__$1,n__4648__auto___48777,jobs,results,process,async))
})();
var state__46310__auto__ = (function (){var statearr_46681 = f__46309__auto__();
(statearr_46681[(6)] = c__46308__auto___48783);

return statearr_46681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
});})(__48778,c__46308__auto___48783,G__46655_48780,G__46655_48781__$1,n__4648__auto___48777,jobs,results,process,async))
);


break;
case "async":
var c__46308__auto___48799 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__48778,c__46308__auto___48799,G__46655_48780,G__46655_48781__$1,n__4648__auto___48777,jobs,results,process,async){
return (function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = ((function (__48778,c__46308__auto___48799,G__46655_48780,G__46655_48781__$1,n__4648__auto___48777,jobs,results,process,async){
return (function (state_46695){
var state_val_46696 = (state_46695[(1)]);
if((state_val_46696 === (1))){
var state_46695__$1 = state_46695;
var statearr_46697_48801 = state_46695__$1;
(statearr_46697_48801[(2)] = null);

(statearr_46697_48801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46696 === (2))){
var state_46695__$1 = state_46695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46695__$1,(4),jobs);
} else {
if((state_val_46696 === (3))){
var inst_46693 = (state_46695[(2)]);
var state_46695__$1 = state_46695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46695__$1,inst_46693);
} else {
if((state_val_46696 === (4))){
var inst_46685 = (state_46695[(2)]);
var inst_46686 = async(inst_46685);
var state_46695__$1 = state_46695;
if(cljs.core.truth_(inst_46686)){
var statearr_46698_48803 = state_46695__$1;
(statearr_46698_48803[(1)] = (5));

} else {
var statearr_46699_48804 = state_46695__$1;
(statearr_46699_48804[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46696 === (5))){
var state_46695__$1 = state_46695;
var statearr_46700_48805 = state_46695__$1;
(statearr_46700_48805[(2)] = null);

(statearr_46700_48805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46696 === (6))){
var state_46695__$1 = state_46695;
var statearr_46701_48806 = state_46695__$1;
(statearr_46701_48806[(2)] = null);

(statearr_46701_48806[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46696 === (7))){
var inst_46691 = (state_46695[(2)]);
var state_46695__$1 = state_46695;
var statearr_46702_48807 = state_46695__$1;
(statearr_46702_48807[(2)] = inst_46691);

(statearr_46702_48807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48778,c__46308__auto___48799,G__46655_48780,G__46655_48781__$1,n__4648__auto___48777,jobs,results,process,async))
;
return ((function (__48778,switch__46107__auto__,c__46308__auto___48799,G__46655_48780,G__46655_48781__$1,n__4648__auto___48777,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0 = (function (){
var statearr_46703 = [null,null,null,null,null,null,null];
(statearr_46703[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__);

(statearr_46703[(1)] = (1));

return statearr_46703;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1 = (function (state_46695){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_46695);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e46704){var ex__46111__auto__ = e46704;
var statearr_46705_48812 = state_46695;
(statearr_46705_48812[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_46695[(4)]))){
var statearr_46706_48816 = state_46695;
(statearr_46706_48816[(1)] = cljs.core.first((state_46695[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48817 = state_46695;
state_46695 = G__48817;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__ = function(state_46695){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1.call(this,state_46695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__;
})()
;})(__48778,switch__46107__auto__,c__46308__auto___48799,G__46655_48780,G__46655_48781__$1,n__4648__auto___48777,jobs,results,process,async))
})();
var state__46310__auto__ = (function (){var statearr_46707 = f__46309__auto__();
(statearr_46707[(6)] = c__46308__auto___48799);

return statearr_46707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
});})(__48778,c__46308__auto___48799,G__46655_48780,G__46655_48781__$1,n__4648__auto___48777,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__46655_48781__$1)].join('')));

}

var G__48821 = (__48778 + (1));
__48778 = G__48821;
continue;
} else {
}
break;
}

var c__46308__auto___48822 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_46734){
var state_val_46735 = (state_46734[(1)]);
if((state_val_46735 === (7))){
var inst_46729 = (state_46734[(2)]);
var state_46734__$1 = state_46734;
var statearr_46754_48826 = state_46734__$1;
(statearr_46754_48826[(2)] = inst_46729);

(statearr_46754_48826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46735 === (1))){
var state_46734__$1 = state_46734;
var statearr_46755_48827 = state_46734__$1;
(statearr_46755_48827[(2)] = null);

(statearr_46755_48827[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46735 === (4))){
var inst_46710 = (state_46734[(7)]);
var inst_46710__$1 = (state_46734[(2)]);
var inst_46711 = (inst_46710__$1 == null);
var state_46734__$1 = (function (){var statearr_46756 = state_46734;
(statearr_46756[(7)] = inst_46710__$1);

return statearr_46756;
})();
if(cljs.core.truth_(inst_46711)){
var statearr_46757_48831 = state_46734__$1;
(statearr_46757_48831[(1)] = (5));

} else {
var statearr_46758_48832 = state_46734__$1;
(statearr_46758_48832[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46735 === (6))){
var inst_46715 = (state_46734[(8)]);
var inst_46710 = (state_46734[(7)]);
var inst_46715__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_46720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46721 = [inst_46710,inst_46715__$1];
var inst_46722 = (new cljs.core.PersistentVector(null,2,(5),inst_46720,inst_46721,null));
var state_46734__$1 = (function (){var statearr_46759 = state_46734;
(statearr_46759[(8)] = inst_46715__$1);

return statearr_46759;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46734__$1,(8),jobs,inst_46722);
} else {
if((state_val_46735 === (3))){
var inst_46731 = (state_46734[(2)]);
var state_46734__$1 = state_46734;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46734__$1,inst_46731);
} else {
if((state_val_46735 === (2))){
var state_46734__$1 = state_46734;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46734__$1,(4),from);
} else {
if((state_val_46735 === (9))){
var inst_46726 = (state_46734[(2)]);
var state_46734__$1 = (function (){var statearr_46760 = state_46734;
(statearr_46760[(9)] = inst_46726);

return statearr_46760;
})();
var statearr_46762_48846 = state_46734__$1;
(statearr_46762_48846[(2)] = null);

(statearr_46762_48846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46735 === (5))){
var inst_46713 = cljs.core.async.close_BANG_(jobs);
var state_46734__$1 = state_46734;
var statearr_46763_48847 = state_46734__$1;
(statearr_46763_48847[(2)] = inst_46713);

(statearr_46763_48847[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46735 === (8))){
var inst_46715 = (state_46734[(8)]);
var inst_46724 = (state_46734[(2)]);
var state_46734__$1 = (function (){var statearr_46764 = state_46734;
(statearr_46764[(10)] = inst_46724);

return statearr_46764;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46734__$1,(9),results,inst_46715);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0 = (function (){
var statearr_46765 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46765[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__);

(statearr_46765[(1)] = (1));

return statearr_46765;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1 = (function (state_46734){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_46734);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e46768){var ex__46111__auto__ = e46768;
var statearr_46769_48854 = state_46734;
(statearr_46769_48854[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_46734[(4)]))){
var statearr_46770_48855 = state_46734;
(statearr_46770_48855[(1)] = cljs.core.first((state_46734[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48856 = state_46734;
state_46734 = G__48856;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__ = function(state_46734){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1.call(this,state_46734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_46772 = f__46309__auto__();
(statearr_46772[(6)] = c__46308__auto___48822);

return statearr_46772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


var c__46308__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_46810){
var state_val_46811 = (state_46810[(1)]);
if((state_val_46811 === (7))){
var inst_46806 = (state_46810[(2)]);
var state_46810__$1 = state_46810;
var statearr_46812_48868 = state_46810__$1;
(statearr_46812_48868[(2)] = inst_46806);

(statearr_46812_48868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (20))){
var state_46810__$1 = state_46810;
var statearr_46818_48869 = state_46810__$1;
(statearr_46818_48869[(2)] = null);

(statearr_46818_48869[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (1))){
var state_46810__$1 = state_46810;
var statearr_46825_48870 = state_46810__$1;
(statearr_46825_48870[(2)] = null);

(statearr_46825_48870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (4))){
var inst_46775 = (state_46810[(7)]);
var inst_46775__$1 = (state_46810[(2)]);
var inst_46776 = (inst_46775__$1 == null);
var state_46810__$1 = (function (){var statearr_46831 = state_46810;
(statearr_46831[(7)] = inst_46775__$1);

return statearr_46831;
})();
if(cljs.core.truth_(inst_46776)){
var statearr_46833_48874 = state_46810__$1;
(statearr_46833_48874[(1)] = (5));

} else {
var statearr_46838_48875 = state_46810__$1;
(statearr_46838_48875[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (15))){
var inst_46788 = (state_46810[(8)]);
var state_46810__$1 = state_46810;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46810__$1,(18),to,inst_46788);
} else {
if((state_val_46811 === (21))){
var inst_46801 = (state_46810[(2)]);
var state_46810__$1 = state_46810;
var statearr_46839_48876 = state_46810__$1;
(statearr_46839_48876[(2)] = inst_46801);

(statearr_46839_48876[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (13))){
var inst_46803 = (state_46810[(2)]);
var state_46810__$1 = (function (){var statearr_46840 = state_46810;
(statearr_46840[(9)] = inst_46803);

return statearr_46840;
})();
var statearr_46841_48877 = state_46810__$1;
(statearr_46841_48877[(2)] = null);

(statearr_46841_48877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (6))){
var inst_46775 = (state_46810[(7)]);
var state_46810__$1 = state_46810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46810__$1,(11),inst_46775);
} else {
if((state_val_46811 === (17))){
var inst_46796 = (state_46810[(2)]);
var state_46810__$1 = state_46810;
if(cljs.core.truth_(inst_46796)){
var statearr_46842_48885 = state_46810__$1;
(statearr_46842_48885[(1)] = (19));

} else {
var statearr_46843_48886 = state_46810__$1;
(statearr_46843_48886[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (3))){
var inst_46808 = (state_46810[(2)]);
var state_46810__$1 = state_46810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46810__$1,inst_46808);
} else {
if((state_val_46811 === (12))){
var inst_46785 = (state_46810[(10)]);
var state_46810__$1 = state_46810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46810__$1,(14),inst_46785);
} else {
if((state_val_46811 === (2))){
var state_46810__$1 = state_46810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46810__$1,(4),results);
} else {
if((state_val_46811 === (19))){
var state_46810__$1 = state_46810;
var statearr_46854_48890 = state_46810__$1;
(statearr_46854_48890[(2)] = null);

(statearr_46854_48890[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (11))){
var inst_46785 = (state_46810[(2)]);
var state_46810__$1 = (function (){var statearr_46861 = state_46810;
(statearr_46861[(10)] = inst_46785);

return statearr_46861;
})();
var statearr_46862_48891 = state_46810__$1;
(statearr_46862_48891[(2)] = null);

(statearr_46862_48891[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (9))){
var state_46810__$1 = state_46810;
var statearr_46868_48892 = state_46810__$1;
(statearr_46868_48892[(2)] = null);

(statearr_46868_48892[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (5))){
var state_46810__$1 = state_46810;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46869_48896 = state_46810__$1;
(statearr_46869_48896[(1)] = (8));

} else {
var statearr_46870_48897 = state_46810__$1;
(statearr_46870_48897[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (14))){
var inst_46788 = (state_46810[(8)]);
var inst_46788__$1 = (state_46810[(2)]);
var inst_46789 = (inst_46788__$1 == null);
var inst_46790 = cljs.core.not(inst_46789);
var state_46810__$1 = (function (){var statearr_46876 = state_46810;
(statearr_46876[(8)] = inst_46788__$1);

return statearr_46876;
})();
if(inst_46790){
var statearr_46882_48905 = state_46810__$1;
(statearr_46882_48905[(1)] = (15));

} else {
var statearr_46885_48909 = state_46810__$1;
(statearr_46885_48909[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (16))){
var state_46810__$1 = state_46810;
var statearr_46895_48910 = state_46810__$1;
(statearr_46895_48910[(2)] = false);

(statearr_46895_48910[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (10))){
var inst_46782 = (state_46810[(2)]);
var state_46810__$1 = state_46810;
var statearr_46896_48915 = state_46810__$1;
(statearr_46896_48915[(2)] = inst_46782);

(statearr_46896_48915[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (18))){
var inst_46793 = (state_46810[(2)]);
var state_46810__$1 = state_46810;
var statearr_46899_48918 = state_46810__$1;
(statearr_46899_48918[(2)] = inst_46793);

(statearr_46899_48918[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46811 === (8))){
var inst_46779 = cljs.core.async.close_BANG_(to);
var state_46810__$1 = state_46810;
var statearr_46900_48922 = state_46810__$1;
(statearr_46900_48922[(2)] = inst_46779);

(statearr_46900_48922[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0 = (function (){
var statearr_46902 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46902[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__);

(statearr_46902[(1)] = (1));

return statearr_46902;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1 = (function (state_46810){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_46810);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e46903){var ex__46111__auto__ = e46903;
var statearr_46904_48926 = state_46810;
(statearr_46904_48926[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_46810[(4)]))){
var statearr_46905_48928 = state_46810;
(statearr_46905_48928[(1)] = cljs.core.first((state_46810[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48930 = state_46810;
state_46810 = G__48930;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__ = function(state_46810){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1.call(this,state_46810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46108__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_46907 = f__46309__auto__();
(statearr_46907[(6)] = c__46308__auto__);

return statearr_46907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));

return c__46308__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__46911 = arguments.length;
switch (G__46911) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__46915 = arguments.length;
switch (G__46915) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__46934 = arguments.length;
switch (G__46934) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__46308__auto___48949 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_46969){
var state_val_46970 = (state_46969[(1)]);
if((state_val_46970 === (7))){
var inst_46965 = (state_46969[(2)]);
var state_46969__$1 = state_46969;
var statearr_46971_48956 = state_46969__$1;
(statearr_46971_48956[(2)] = inst_46965);

(statearr_46971_48956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (1))){
var state_46969__$1 = state_46969;
var statearr_46972_48957 = state_46969__$1;
(statearr_46972_48957[(2)] = null);

(statearr_46972_48957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (4))){
var inst_46945 = (state_46969[(7)]);
var inst_46945__$1 = (state_46969[(2)]);
var inst_46946 = (inst_46945__$1 == null);
var state_46969__$1 = (function (){var statearr_46973 = state_46969;
(statearr_46973[(7)] = inst_46945__$1);

return statearr_46973;
})();
if(cljs.core.truth_(inst_46946)){
var statearr_46975_48958 = state_46969__$1;
(statearr_46975_48958[(1)] = (5));

} else {
var statearr_46976_48959 = state_46969__$1;
(statearr_46976_48959[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (13))){
var state_46969__$1 = state_46969;
var statearr_46977_48960 = state_46969__$1;
(statearr_46977_48960[(2)] = null);

(statearr_46977_48960[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (6))){
var inst_46945 = (state_46969[(7)]);
var inst_46951 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_46945) : p.call(null,inst_46945));
var state_46969__$1 = state_46969;
if(cljs.core.truth_(inst_46951)){
var statearr_46978_48961 = state_46969__$1;
(statearr_46978_48961[(1)] = (9));

} else {
var statearr_46979_48962 = state_46969__$1;
(statearr_46979_48962[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (3))){
var inst_46967 = (state_46969[(2)]);
var state_46969__$1 = state_46969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46969__$1,inst_46967);
} else {
if((state_val_46970 === (12))){
var state_46969__$1 = state_46969;
var statearr_46982_48969 = state_46969__$1;
(statearr_46982_48969[(2)] = null);

(statearr_46982_48969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (2))){
var state_46969__$1 = state_46969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46969__$1,(4),ch);
} else {
if((state_val_46970 === (11))){
var inst_46945 = (state_46969[(7)]);
var inst_46955 = (state_46969[(2)]);
var state_46969__$1 = state_46969;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46969__$1,(8),inst_46955,inst_46945);
} else {
if((state_val_46970 === (9))){
var state_46969__$1 = state_46969;
var statearr_46986_48970 = state_46969__$1;
(statearr_46986_48970[(2)] = tc);

(statearr_46986_48970[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (5))){
var inst_46948 = cljs.core.async.close_BANG_(tc);
var inst_46949 = cljs.core.async.close_BANG_(fc);
var state_46969__$1 = (function (){var statearr_46987 = state_46969;
(statearr_46987[(8)] = inst_46948);

return statearr_46987;
})();
var statearr_46988_48971 = state_46969__$1;
(statearr_46988_48971[(2)] = inst_46949);

(statearr_46988_48971[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (14))){
var inst_46963 = (state_46969[(2)]);
var state_46969__$1 = state_46969;
var statearr_46989_48978 = state_46969__$1;
(statearr_46989_48978[(2)] = inst_46963);

(statearr_46989_48978[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (10))){
var state_46969__$1 = state_46969;
var statearr_46990_48979 = state_46969__$1;
(statearr_46990_48979[(2)] = fc);

(statearr_46990_48979[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (8))){
var inst_46957 = (state_46969[(2)]);
var state_46969__$1 = state_46969;
if(cljs.core.truth_(inst_46957)){
var statearr_46991_48980 = state_46969__$1;
(statearr_46991_48980[(1)] = (12));

} else {
var statearr_46992_48981 = state_46969__$1;
(statearr_46992_48981[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46108__auto__ = null;
var cljs$core$async$state_machine__46108__auto____0 = (function (){
var statearr_46995 = [null,null,null,null,null,null,null,null,null];
(statearr_46995[(0)] = cljs$core$async$state_machine__46108__auto__);

(statearr_46995[(1)] = (1));

return statearr_46995;
});
var cljs$core$async$state_machine__46108__auto____1 = (function (state_46969){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_46969);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e46996){var ex__46111__auto__ = e46996;
var statearr_46997_48984 = state_46969;
(statearr_46997_48984[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_46969[(4)]))){
var statearr_46998_48991 = state_46969;
(statearr_46998_48991[(1)] = cljs.core.first((state_46969[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48992 = state_46969;
state_46969 = G__48992;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$state_machine__46108__auto__ = function(state_46969){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46108__auto____1.call(this,state_46969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46108__auto____0;
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46108__auto____1;
return cljs$core$async$state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_46999 = f__46309__auto__();
(statearr_46999[(6)] = c__46308__auto___48949);

return statearr_46999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__46308__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_47023){
var state_val_47024 = (state_47023[(1)]);
if((state_val_47024 === (7))){
var inst_47019 = (state_47023[(2)]);
var state_47023__$1 = state_47023;
var statearr_47025_49004 = state_47023__$1;
(statearr_47025_49004[(2)] = inst_47019);

(statearr_47025_49004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47024 === (1))){
var inst_47002 = init;
var inst_47003 = inst_47002;
var state_47023__$1 = (function (){var statearr_47026 = state_47023;
(statearr_47026[(7)] = inst_47003);

return statearr_47026;
})();
var statearr_47027_49005 = state_47023__$1;
(statearr_47027_49005[(2)] = null);

(statearr_47027_49005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47024 === (4))){
var inst_47006 = (state_47023[(8)]);
var inst_47006__$1 = (state_47023[(2)]);
var inst_47007 = (inst_47006__$1 == null);
var state_47023__$1 = (function (){var statearr_47032 = state_47023;
(statearr_47032[(8)] = inst_47006__$1);

return statearr_47032;
})();
if(cljs.core.truth_(inst_47007)){
var statearr_47033_49007 = state_47023__$1;
(statearr_47033_49007[(1)] = (5));

} else {
var statearr_47034_49008 = state_47023__$1;
(statearr_47034_49008[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47024 === (6))){
var inst_47003 = (state_47023[(7)]);
var inst_47006 = (state_47023[(8)]);
var inst_47010 = (state_47023[(9)]);
var inst_47010__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_47003,inst_47006) : f.call(null,inst_47003,inst_47006));
var inst_47011 = cljs.core.reduced_QMARK_(inst_47010__$1);
var state_47023__$1 = (function (){var statearr_47035 = state_47023;
(statearr_47035[(9)] = inst_47010__$1);

return statearr_47035;
})();
if(inst_47011){
var statearr_47036_49010 = state_47023__$1;
(statearr_47036_49010[(1)] = (8));

} else {
var statearr_47037_49011 = state_47023__$1;
(statearr_47037_49011[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47024 === (3))){
var inst_47021 = (state_47023[(2)]);
var state_47023__$1 = state_47023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47023__$1,inst_47021);
} else {
if((state_val_47024 === (2))){
var state_47023__$1 = state_47023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47023__$1,(4),ch);
} else {
if((state_val_47024 === (9))){
var inst_47010 = (state_47023[(9)]);
var inst_47003 = inst_47010;
var state_47023__$1 = (function (){var statearr_47045 = state_47023;
(statearr_47045[(7)] = inst_47003);

return statearr_47045;
})();
var statearr_47046_49017 = state_47023__$1;
(statearr_47046_49017[(2)] = null);

(statearr_47046_49017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47024 === (5))){
var inst_47003 = (state_47023[(7)]);
var state_47023__$1 = state_47023;
var statearr_47047_49018 = state_47023__$1;
(statearr_47047_49018[(2)] = inst_47003);

(statearr_47047_49018[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47024 === (10))){
var inst_47017 = (state_47023[(2)]);
var state_47023__$1 = state_47023;
var statearr_47048_49019 = state_47023__$1;
(statearr_47048_49019[(2)] = inst_47017);

(statearr_47048_49019[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47024 === (8))){
var inst_47010 = (state_47023[(9)]);
var inst_47013 = cljs.core.deref(inst_47010);
var state_47023__$1 = state_47023;
var statearr_47049_49020 = state_47023__$1;
(statearr_47049_49020[(2)] = inst_47013);

(statearr_47049_49020[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__46108__auto__ = null;
var cljs$core$async$reduce_$_state_machine__46108__auto____0 = (function (){
var statearr_47053 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47053[(0)] = cljs$core$async$reduce_$_state_machine__46108__auto__);

(statearr_47053[(1)] = (1));

return statearr_47053;
});
var cljs$core$async$reduce_$_state_machine__46108__auto____1 = (function (state_47023){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_47023);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e47054){var ex__46111__auto__ = e47054;
var statearr_47055_49023 = state_47023;
(statearr_47055_49023[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_47023[(4)]))){
var statearr_47058_49024 = state_47023;
(statearr_47058_49024[(1)] = cljs.core.first((state_47023[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49026 = state_47023;
state_47023 = G__49026;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__46108__auto__ = function(state_47023){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__46108__auto____1.call(this,state_47023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__46108__auto____0;
cljs$core$async$reduce_$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__46108__auto____1;
return cljs$core$async$reduce_$_state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_47059 = f__46309__auto__();
(statearr_47059[(6)] = c__46308__auto__);

return statearr_47059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));

return c__46308__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__46308__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_47065){
var state_val_47066 = (state_47065[(1)]);
if((state_val_47066 === (1))){
var inst_47060 = cljs.core.async.reduce(f__$1,init,ch);
var state_47065__$1 = state_47065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47065__$1,(2),inst_47060);
} else {
if((state_val_47066 === (2))){
var inst_47062 = (state_47065[(2)]);
var inst_47063 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_47062) : f__$1.call(null,inst_47062));
var state_47065__$1 = state_47065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47065__$1,inst_47063);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__46108__auto__ = null;
var cljs$core$async$transduce_$_state_machine__46108__auto____0 = (function (){
var statearr_47069 = [null,null,null,null,null,null,null];
(statearr_47069[(0)] = cljs$core$async$transduce_$_state_machine__46108__auto__);

(statearr_47069[(1)] = (1));

return statearr_47069;
});
var cljs$core$async$transduce_$_state_machine__46108__auto____1 = (function (state_47065){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_47065);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e47070){var ex__46111__auto__ = e47070;
var statearr_47071_49031 = state_47065;
(statearr_47071_49031[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_47065[(4)]))){
var statearr_47072_49033 = state_47065;
(statearr_47072_49033[(1)] = cljs.core.first((state_47065[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49034 = state_47065;
state_47065 = G__49034;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__46108__auto__ = function(state_47065){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__46108__auto____1.call(this,state_47065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__46108__auto____0;
cljs$core$async$transduce_$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__46108__auto____1;
return cljs$core$async$transduce_$_state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_47073 = f__46309__auto__();
(statearr_47073[(6)] = c__46308__auto__);

return statearr_47073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));

return c__46308__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__47079 = arguments.length;
switch (G__47079) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__46308__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_47118){
var state_val_47119 = (state_47118[(1)]);
if((state_val_47119 === (7))){
var inst_47098 = (state_47118[(2)]);
var state_47118__$1 = state_47118;
var statearr_47120_49037 = state_47118__$1;
(statearr_47120_49037[(2)] = inst_47098);

(statearr_47120_49037[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47119 === (1))){
var inst_47084 = cljs.core.seq(coll);
var inst_47085 = inst_47084;
var state_47118__$1 = (function (){var statearr_47122 = state_47118;
(statearr_47122[(7)] = inst_47085);

return statearr_47122;
})();
var statearr_47123_49038 = state_47118__$1;
(statearr_47123_49038[(2)] = null);

(statearr_47123_49038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47119 === (4))){
var inst_47085 = (state_47118[(7)]);
var inst_47096 = cljs.core.first(inst_47085);
var state_47118__$1 = state_47118;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47118__$1,(7),ch,inst_47096);
} else {
if((state_val_47119 === (13))){
var inst_47111 = (state_47118[(2)]);
var state_47118__$1 = state_47118;
var statearr_47127_49049 = state_47118__$1;
(statearr_47127_49049[(2)] = inst_47111);

(statearr_47127_49049[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47119 === (6))){
var inst_47101 = (state_47118[(2)]);
var state_47118__$1 = state_47118;
if(cljs.core.truth_(inst_47101)){
var statearr_47128_49054 = state_47118__$1;
(statearr_47128_49054[(1)] = (8));

} else {
var statearr_47130_49055 = state_47118__$1;
(statearr_47130_49055[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47119 === (3))){
var inst_47115 = (state_47118[(2)]);
var state_47118__$1 = state_47118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47118__$1,inst_47115);
} else {
if((state_val_47119 === (12))){
var state_47118__$1 = state_47118;
var statearr_47132_49057 = state_47118__$1;
(statearr_47132_49057[(2)] = null);

(statearr_47132_49057[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47119 === (2))){
var inst_47085 = (state_47118[(7)]);
var state_47118__$1 = state_47118;
if(cljs.core.truth_(inst_47085)){
var statearr_47133_49058 = state_47118__$1;
(statearr_47133_49058[(1)] = (4));

} else {
var statearr_47135_49059 = state_47118__$1;
(statearr_47135_49059[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47119 === (11))){
var inst_47108 = cljs.core.async.close_BANG_(ch);
var state_47118__$1 = state_47118;
var statearr_47136_49060 = state_47118__$1;
(statearr_47136_49060[(2)] = inst_47108);

(statearr_47136_49060[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47119 === (9))){
var state_47118__$1 = state_47118;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47139_49065 = state_47118__$1;
(statearr_47139_49065[(1)] = (11));

} else {
var statearr_47144_49066 = state_47118__$1;
(statearr_47144_49066[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47119 === (5))){
var inst_47085 = (state_47118[(7)]);
var state_47118__$1 = state_47118;
var statearr_47145_49070 = state_47118__$1;
(statearr_47145_49070[(2)] = inst_47085);

(statearr_47145_49070[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47119 === (10))){
var inst_47113 = (state_47118[(2)]);
var state_47118__$1 = state_47118;
var statearr_47152_49071 = state_47118__$1;
(statearr_47152_49071[(2)] = inst_47113);

(statearr_47152_49071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47119 === (8))){
var inst_47085 = (state_47118[(7)]);
var inst_47103 = cljs.core.next(inst_47085);
var inst_47085__$1 = inst_47103;
var state_47118__$1 = (function (){var statearr_47158 = state_47118;
(statearr_47158[(7)] = inst_47085__$1);

return statearr_47158;
})();
var statearr_47159_49078 = state_47118__$1;
(statearr_47159_49078[(2)] = null);

(statearr_47159_49078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46108__auto__ = null;
var cljs$core$async$state_machine__46108__auto____0 = (function (){
var statearr_47160 = [null,null,null,null,null,null,null,null];
(statearr_47160[(0)] = cljs$core$async$state_machine__46108__auto__);

(statearr_47160[(1)] = (1));

return statearr_47160;
});
var cljs$core$async$state_machine__46108__auto____1 = (function (state_47118){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_47118);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e47162){var ex__46111__auto__ = e47162;
var statearr_47163_49086 = state_47118;
(statearr_47163_49086[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_47118[(4)]))){
var statearr_47164_49087 = state_47118;
(statearr_47164_49087[(1)] = cljs.core.first((state_47118[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49088 = state_47118;
state_47118 = G__49088;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$state_machine__46108__auto__ = function(state_47118){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46108__auto____1.call(this,state_47118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46108__auto____0;
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46108__auto____1;
return cljs$core$async$state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_47168 = f__46309__auto__();
(statearr_47168[(6)] = c__46308__auto__);

return statearr_47168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));

return c__46308__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__47179 = arguments.length;
switch (G__47179) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_49108 = (function (_){
var x__4463__auto__ = (((_ == null))?null:_);
var m__4464__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4464__auto__.call(null,_));
} else {
var m__4461__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4461__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_49108(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_49111 = (function (m,ch,close_QMARK_){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4464__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4461__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4461__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_49111(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_49118 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_49118(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_49119 = (function (m){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4464__auto__.call(null,m));
} else {
var m__4461__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4461__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_49119(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47220 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47220 = (function (ch,cs,meta47221){
this.ch = ch;
this.cs = cs;
this.meta47221 = meta47221;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47220.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47222,meta47221__$1){
var self__ = this;
var _47222__$1 = this;
return (new cljs.core.async.t_cljs$core$async47220(self__.ch,self__.cs,meta47221__$1));
}));

(cljs.core.async.t_cljs$core$async47220.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47222){
var self__ = this;
var _47222__$1 = this;
return self__.meta47221;
}));

(cljs.core.async.t_cljs$core$async47220.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47220.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async47220.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47220.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async47220.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async47220.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async47220.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta47221","meta47221",496584256,null)], null);
}));

(cljs.core.async.t_cljs$core$async47220.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47220.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47220");

(cljs.core.async.t_cljs$core$async47220.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async47220");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47220.
 */
cljs.core.async.__GT_t_cljs$core$async47220 = (function cljs$core$async$mult_$___GT_t_cljs$core$async47220(ch__$1,cs__$1,meta47221){
return (new cljs.core.async.t_cljs$core$async47220(ch__$1,cs__$1,meta47221));
});

}

return (new cljs.core.async.t_cljs$core$async47220(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__46308__auto___49158 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_47359){
var state_val_47360 = (state_47359[(1)]);
if((state_val_47360 === (7))){
var inst_47355 = (state_47359[(2)]);
var state_47359__$1 = state_47359;
var statearr_47361_49159 = state_47359__$1;
(statearr_47361_49159[(2)] = inst_47355);

(statearr_47361_49159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (20))){
var inst_47259 = (state_47359[(7)]);
var inst_47271 = cljs.core.first(inst_47259);
var inst_47272 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47271,(0),null);
var inst_47273 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47271,(1),null);
var state_47359__$1 = (function (){var statearr_47363 = state_47359;
(statearr_47363[(8)] = inst_47272);

return statearr_47363;
})();
if(cljs.core.truth_(inst_47273)){
var statearr_47364_49164 = state_47359__$1;
(statearr_47364_49164[(1)] = (22));

} else {
var statearr_47365_49165 = state_47359__$1;
(statearr_47365_49165[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (27))){
var inst_47303 = (state_47359[(9)]);
var inst_47301 = (state_47359[(10)]);
var inst_47308 = (state_47359[(11)]);
var inst_47227 = (state_47359[(12)]);
var inst_47308__$1 = cljs.core._nth(inst_47301,inst_47303);
var inst_47309 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_47308__$1,inst_47227,done);
var state_47359__$1 = (function (){var statearr_47366 = state_47359;
(statearr_47366[(11)] = inst_47308__$1);

return statearr_47366;
})();
if(cljs.core.truth_(inst_47309)){
var statearr_47367_49168 = state_47359__$1;
(statearr_47367_49168[(1)] = (30));

} else {
var statearr_47368_49169 = state_47359__$1;
(statearr_47368_49169[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (1))){
var state_47359__$1 = state_47359;
var statearr_47369_49175 = state_47359__$1;
(statearr_47369_49175[(2)] = null);

(statearr_47369_49175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (24))){
var inst_47259 = (state_47359[(7)]);
var inst_47278 = (state_47359[(2)]);
var inst_47279 = cljs.core.next(inst_47259);
var inst_47236 = inst_47279;
var inst_47237 = null;
var inst_47238 = (0);
var inst_47239 = (0);
var state_47359__$1 = (function (){var statearr_47371 = state_47359;
(statearr_47371[(13)] = inst_47239);

(statearr_47371[(14)] = inst_47238);

(statearr_47371[(15)] = inst_47237);

(statearr_47371[(16)] = inst_47236);

(statearr_47371[(17)] = inst_47278);

return statearr_47371;
})();
var statearr_47372_49177 = state_47359__$1;
(statearr_47372_49177[(2)] = null);

(statearr_47372_49177[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (39))){
var state_47359__$1 = state_47359;
var statearr_47376_49179 = state_47359__$1;
(statearr_47376_49179[(2)] = null);

(statearr_47376_49179[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (4))){
var inst_47227 = (state_47359[(12)]);
var inst_47227__$1 = (state_47359[(2)]);
var inst_47228 = (inst_47227__$1 == null);
var state_47359__$1 = (function (){var statearr_47377 = state_47359;
(statearr_47377[(12)] = inst_47227__$1);

return statearr_47377;
})();
if(cljs.core.truth_(inst_47228)){
var statearr_47379_49183 = state_47359__$1;
(statearr_47379_49183[(1)] = (5));

} else {
var statearr_47380_49185 = state_47359__$1;
(statearr_47380_49185[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (15))){
var inst_47239 = (state_47359[(13)]);
var inst_47238 = (state_47359[(14)]);
var inst_47237 = (state_47359[(15)]);
var inst_47236 = (state_47359[(16)]);
var inst_47255 = (state_47359[(2)]);
var inst_47256 = (inst_47239 + (1));
var tmp47373 = inst_47238;
var tmp47374 = inst_47237;
var tmp47375 = inst_47236;
var inst_47236__$1 = tmp47375;
var inst_47237__$1 = tmp47374;
var inst_47238__$1 = tmp47373;
var inst_47239__$1 = inst_47256;
var state_47359__$1 = (function (){var statearr_47381 = state_47359;
(statearr_47381[(13)] = inst_47239__$1);

(statearr_47381[(14)] = inst_47238__$1);

(statearr_47381[(15)] = inst_47237__$1);

(statearr_47381[(16)] = inst_47236__$1);

(statearr_47381[(18)] = inst_47255);

return statearr_47381;
})();
var statearr_47382_49191 = state_47359__$1;
(statearr_47382_49191[(2)] = null);

(statearr_47382_49191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (21))){
var inst_47282 = (state_47359[(2)]);
var state_47359__$1 = state_47359;
var statearr_47386_49193 = state_47359__$1;
(statearr_47386_49193[(2)] = inst_47282);

(statearr_47386_49193[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (31))){
var inst_47308 = (state_47359[(11)]);
var inst_47312 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_47308);
var state_47359__$1 = state_47359;
var statearr_47388_49196 = state_47359__$1;
(statearr_47388_49196[(2)] = inst_47312);

(statearr_47388_49196[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (32))){
var inst_47302 = (state_47359[(19)]);
var inst_47303 = (state_47359[(9)]);
var inst_47301 = (state_47359[(10)]);
var inst_47300 = (state_47359[(20)]);
var inst_47314 = (state_47359[(2)]);
var inst_47315 = (inst_47303 + (1));
var tmp47383 = inst_47302;
var tmp47384 = inst_47301;
var tmp47385 = inst_47300;
var inst_47300__$1 = tmp47385;
var inst_47301__$1 = tmp47384;
var inst_47302__$1 = tmp47383;
var inst_47303__$1 = inst_47315;
var state_47359__$1 = (function (){var statearr_47389 = state_47359;
(statearr_47389[(19)] = inst_47302__$1);

(statearr_47389[(9)] = inst_47303__$1);

(statearr_47389[(10)] = inst_47301__$1);

(statearr_47389[(20)] = inst_47300__$1);

(statearr_47389[(21)] = inst_47314);

return statearr_47389;
})();
var statearr_47390_49207 = state_47359__$1;
(statearr_47390_49207[(2)] = null);

(statearr_47390_49207[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (40))){
var inst_47328 = (state_47359[(22)]);
var inst_47332 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_47328);
var state_47359__$1 = state_47359;
var statearr_47391_49209 = state_47359__$1;
(statearr_47391_49209[(2)] = inst_47332);

(statearr_47391_49209[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (33))){
var inst_47319 = (state_47359[(23)]);
var inst_47321 = cljs.core.chunked_seq_QMARK_(inst_47319);
var state_47359__$1 = state_47359;
if(inst_47321){
var statearr_47393_49210 = state_47359__$1;
(statearr_47393_49210[(1)] = (36));

} else {
var statearr_47394_49211 = state_47359__$1;
(statearr_47394_49211[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (13))){
var inst_47249 = (state_47359[(24)]);
var inst_47252 = cljs.core.async.close_BANG_(inst_47249);
var state_47359__$1 = state_47359;
var statearr_47395_49212 = state_47359__$1;
(statearr_47395_49212[(2)] = inst_47252);

(statearr_47395_49212[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (22))){
var inst_47272 = (state_47359[(8)]);
var inst_47275 = cljs.core.async.close_BANG_(inst_47272);
var state_47359__$1 = state_47359;
var statearr_47396_49215 = state_47359__$1;
(statearr_47396_49215[(2)] = inst_47275);

(statearr_47396_49215[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (36))){
var inst_47319 = (state_47359[(23)]);
var inst_47323 = cljs.core.chunk_first(inst_47319);
var inst_47324 = cljs.core.chunk_rest(inst_47319);
var inst_47325 = cljs.core.count(inst_47323);
var inst_47300 = inst_47324;
var inst_47301 = inst_47323;
var inst_47302 = inst_47325;
var inst_47303 = (0);
var state_47359__$1 = (function (){var statearr_47398 = state_47359;
(statearr_47398[(19)] = inst_47302);

(statearr_47398[(9)] = inst_47303);

(statearr_47398[(10)] = inst_47301);

(statearr_47398[(20)] = inst_47300);

return statearr_47398;
})();
var statearr_47399_49221 = state_47359__$1;
(statearr_47399_49221[(2)] = null);

(statearr_47399_49221[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (41))){
var inst_47319 = (state_47359[(23)]);
var inst_47334 = (state_47359[(2)]);
var inst_47335 = cljs.core.next(inst_47319);
var inst_47300 = inst_47335;
var inst_47301 = null;
var inst_47302 = (0);
var inst_47303 = (0);
var state_47359__$1 = (function (){var statearr_47400 = state_47359;
(statearr_47400[(19)] = inst_47302);

(statearr_47400[(9)] = inst_47303);

(statearr_47400[(10)] = inst_47301);

(statearr_47400[(20)] = inst_47300);

(statearr_47400[(25)] = inst_47334);

return statearr_47400;
})();
var statearr_47401_49223 = state_47359__$1;
(statearr_47401_49223[(2)] = null);

(statearr_47401_49223[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (43))){
var state_47359__$1 = state_47359;
var statearr_47402_49226 = state_47359__$1;
(statearr_47402_49226[(2)] = null);

(statearr_47402_49226[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (29))){
var inst_47343 = (state_47359[(2)]);
var state_47359__$1 = state_47359;
var statearr_47404_49227 = state_47359__$1;
(statearr_47404_49227[(2)] = inst_47343);

(statearr_47404_49227[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (44))){
var inst_47352 = (state_47359[(2)]);
var state_47359__$1 = (function (){var statearr_47405 = state_47359;
(statearr_47405[(26)] = inst_47352);

return statearr_47405;
})();
var statearr_47406_49228 = state_47359__$1;
(statearr_47406_49228[(2)] = null);

(statearr_47406_49228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (6))){
var inst_47292 = (state_47359[(27)]);
var inst_47291 = cljs.core.deref(cs);
var inst_47292__$1 = cljs.core.keys(inst_47291);
var inst_47293 = cljs.core.count(inst_47292__$1);
var inst_47294 = cljs.core.reset_BANG_(dctr,inst_47293);
var inst_47299 = cljs.core.seq(inst_47292__$1);
var inst_47300 = inst_47299;
var inst_47301 = null;
var inst_47302 = (0);
var inst_47303 = (0);
var state_47359__$1 = (function (){var statearr_47407 = state_47359;
(statearr_47407[(19)] = inst_47302);

(statearr_47407[(28)] = inst_47294);

(statearr_47407[(9)] = inst_47303);

(statearr_47407[(10)] = inst_47301);

(statearr_47407[(27)] = inst_47292__$1);

(statearr_47407[(20)] = inst_47300);

return statearr_47407;
})();
var statearr_47408_49229 = state_47359__$1;
(statearr_47408_49229[(2)] = null);

(statearr_47408_49229[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (28))){
var inst_47319 = (state_47359[(23)]);
var inst_47300 = (state_47359[(20)]);
var inst_47319__$1 = cljs.core.seq(inst_47300);
var state_47359__$1 = (function (){var statearr_47410 = state_47359;
(statearr_47410[(23)] = inst_47319__$1);

return statearr_47410;
})();
if(inst_47319__$1){
var statearr_47411_49230 = state_47359__$1;
(statearr_47411_49230[(1)] = (33));

} else {
var statearr_47412_49231 = state_47359__$1;
(statearr_47412_49231[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (25))){
var inst_47302 = (state_47359[(19)]);
var inst_47303 = (state_47359[(9)]);
var inst_47305 = (inst_47303 < inst_47302);
var inst_47306 = inst_47305;
var state_47359__$1 = state_47359;
if(cljs.core.truth_(inst_47306)){
var statearr_47413_49232 = state_47359__$1;
(statearr_47413_49232[(1)] = (27));

} else {
var statearr_47414_49234 = state_47359__$1;
(statearr_47414_49234[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (34))){
var state_47359__$1 = state_47359;
var statearr_47415_49238 = state_47359__$1;
(statearr_47415_49238[(2)] = null);

(statearr_47415_49238[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (17))){
var state_47359__$1 = state_47359;
var statearr_47416_49243 = state_47359__$1;
(statearr_47416_49243[(2)] = null);

(statearr_47416_49243[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (3))){
var inst_47357 = (state_47359[(2)]);
var state_47359__$1 = state_47359;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47359__$1,inst_47357);
} else {
if((state_val_47360 === (12))){
var inst_47287 = (state_47359[(2)]);
var state_47359__$1 = state_47359;
var statearr_47418_49245 = state_47359__$1;
(statearr_47418_49245[(2)] = inst_47287);

(statearr_47418_49245[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (2))){
var state_47359__$1 = state_47359;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47359__$1,(4),ch);
} else {
if((state_val_47360 === (23))){
var state_47359__$1 = state_47359;
var statearr_47419_49250 = state_47359__$1;
(statearr_47419_49250[(2)] = null);

(statearr_47419_49250[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (35))){
var inst_47341 = (state_47359[(2)]);
var state_47359__$1 = state_47359;
var statearr_47420_49251 = state_47359__$1;
(statearr_47420_49251[(2)] = inst_47341);

(statearr_47420_49251[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (19))){
var inst_47259 = (state_47359[(7)]);
var inst_47263 = cljs.core.chunk_first(inst_47259);
var inst_47264 = cljs.core.chunk_rest(inst_47259);
var inst_47265 = cljs.core.count(inst_47263);
var inst_47236 = inst_47264;
var inst_47237 = inst_47263;
var inst_47238 = inst_47265;
var inst_47239 = (0);
var state_47359__$1 = (function (){var statearr_47422 = state_47359;
(statearr_47422[(13)] = inst_47239);

(statearr_47422[(14)] = inst_47238);

(statearr_47422[(15)] = inst_47237);

(statearr_47422[(16)] = inst_47236);

return statearr_47422;
})();
var statearr_47423_49254 = state_47359__$1;
(statearr_47423_49254[(2)] = null);

(statearr_47423_49254[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (11))){
var inst_47236 = (state_47359[(16)]);
var inst_47259 = (state_47359[(7)]);
var inst_47259__$1 = cljs.core.seq(inst_47236);
var state_47359__$1 = (function (){var statearr_47424 = state_47359;
(statearr_47424[(7)] = inst_47259__$1);

return statearr_47424;
})();
if(inst_47259__$1){
var statearr_47425_49261 = state_47359__$1;
(statearr_47425_49261[(1)] = (16));

} else {
var statearr_47426_49262 = state_47359__$1;
(statearr_47426_49262[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (9))){
var inst_47289 = (state_47359[(2)]);
var state_47359__$1 = state_47359;
var statearr_47427_49263 = state_47359__$1;
(statearr_47427_49263[(2)] = inst_47289);

(statearr_47427_49263[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (5))){
var inst_47234 = cljs.core.deref(cs);
var inst_47235 = cljs.core.seq(inst_47234);
var inst_47236 = inst_47235;
var inst_47237 = null;
var inst_47238 = (0);
var inst_47239 = (0);
var state_47359__$1 = (function (){var statearr_47429 = state_47359;
(statearr_47429[(13)] = inst_47239);

(statearr_47429[(14)] = inst_47238);

(statearr_47429[(15)] = inst_47237);

(statearr_47429[(16)] = inst_47236);

return statearr_47429;
})();
var statearr_47430_49267 = state_47359__$1;
(statearr_47430_49267[(2)] = null);

(statearr_47430_49267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (14))){
var state_47359__$1 = state_47359;
var statearr_47431_49268 = state_47359__$1;
(statearr_47431_49268[(2)] = null);

(statearr_47431_49268[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (45))){
var inst_47349 = (state_47359[(2)]);
var state_47359__$1 = state_47359;
var statearr_47432_49269 = state_47359__$1;
(statearr_47432_49269[(2)] = inst_47349);

(statearr_47432_49269[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (26))){
var inst_47292 = (state_47359[(27)]);
var inst_47345 = (state_47359[(2)]);
var inst_47346 = cljs.core.seq(inst_47292);
var state_47359__$1 = (function (){var statearr_47433 = state_47359;
(statearr_47433[(29)] = inst_47345);

return statearr_47433;
})();
if(inst_47346){
var statearr_47434_49270 = state_47359__$1;
(statearr_47434_49270[(1)] = (42));

} else {
var statearr_47435_49271 = state_47359__$1;
(statearr_47435_49271[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (16))){
var inst_47259 = (state_47359[(7)]);
var inst_47261 = cljs.core.chunked_seq_QMARK_(inst_47259);
var state_47359__$1 = state_47359;
if(inst_47261){
var statearr_47437_49276 = state_47359__$1;
(statearr_47437_49276[(1)] = (19));

} else {
var statearr_47438_49277 = state_47359__$1;
(statearr_47438_49277[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (38))){
var inst_47338 = (state_47359[(2)]);
var state_47359__$1 = state_47359;
var statearr_47439_49278 = state_47359__$1;
(statearr_47439_49278[(2)] = inst_47338);

(statearr_47439_49278[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (30))){
var state_47359__$1 = state_47359;
var statearr_47440_49279 = state_47359__$1;
(statearr_47440_49279[(2)] = null);

(statearr_47440_49279[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (10))){
var inst_47239 = (state_47359[(13)]);
var inst_47237 = (state_47359[(15)]);
var inst_47247 = cljs.core._nth(inst_47237,inst_47239);
var inst_47249 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47247,(0),null);
var inst_47250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47247,(1),null);
var state_47359__$1 = (function (){var statearr_47442 = state_47359;
(statearr_47442[(24)] = inst_47249);

return statearr_47442;
})();
if(cljs.core.truth_(inst_47250)){
var statearr_47443_49280 = state_47359__$1;
(statearr_47443_49280[(1)] = (13));

} else {
var statearr_47444_49281 = state_47359__$1;
(statearr_47444_49281[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (18))){
var inst_47285 = (state_47359[(2)]);
var state_47359__$1 = state_47359;
var statearr_47445_49282 = state_47359__$1;
(statearr_47445_49282[(2)] = inst_47285);

(statearr_47445_49282[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (42))){
var state_47359__$1 = state_47359;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47359__$1,(45),dchan);
} else {
if((state_val_47360 === (37))){
var inst_47319 = (state_47359[(23)]);
var inst_47328 = (state_47359[(22)]);
var inst_47227 = (state_47359[(12)]);
var inst_47328__$1 = cljs.core.first(inst_47319);
var inst_47329 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_47328__$1,inst_47227,done);
var state_47359__$1 = (function (){var statearr_47446 = state_47359;
(statearr_47446[(22)] = inst_47328__$1);

return statearr_47446;
})();
if(cljs.core.truth_(inst_47329)){
var statearr_47448_49289 = state_47359__$1;
(statearr_47448_49289[(1)] = (39));

} else {
var statearr_47449_49290 = state_47359__$1;
(statearr_47449_49290[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47360 === (8))){
var inst_47239 = (state_47359[(13)]);
var inst_47238 = (state_47359[(14)]);
var inst_47241 = (inst_47239 < inst_47238);
var inst_47242 = inst_47241;
var state_47359__$1 = state_47359;
if(cljs.core.truth_(inst_47242)){
var statearr_47450_49291 = state_47359__$1;
(statearr_47450_49291[(1)] = (10));

} else {
var statearr_47451_49292 = state_47359__$1;
(statearr_47451_49292[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__46108__auto__ = null;
var cljs$core$async$mult_$_state_machine__46108__auto____0 = (function (){
var statearr_47453 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47453[(0)] = cljs$core$async$mult_$_state_machine__46108__auto__);

(statearr_47453[(1)] = (1));

return statearr_47453;
});
var cljs$core$async$mult_$_state_machine__46108__auto____1 = (function (state_47359){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_47359);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e47454){var ex__46111__auto__ = e47454;
var statearr_47455_49302 = state_47359;
(statearr_47455_49302[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_47359[(4)]))){
var statearr_47456_49303 = state_47359;
(statearr_47456_49303[(1)] = cljs.core.first((state_47359[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49308 = state_47359;
state_47359 = G__49308;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__46108__auto__ = function(state_47359){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__46108__auto____1.call(this,state_47359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__46108__auto____0;
cljs$core$async$mult_$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__46108__auto____1;
return cljs$core$async$mult_$_state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_47457 = f__46309__auto__();
(statearr_47457[(6)] = c__46308__auto___49158);

return statearr_47457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__47460 = arguments.length;
switch (G__47460) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_49321 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_49321(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_49325 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_49325(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_49332 = (function (m){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4464__auto__.call(null,m));
} else {
var m__4461__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4461__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_49332(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_49347 = (function (m,state_map){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4464__auto__.call(null,m,state_map));
} else {
var m__4461__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4461__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_49347(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_49354 = (function (m,mode){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4464__auto__.call(null,m,mode));
} else {
var m__4461__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4461__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_49354(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___49356 = arguments.length;
var i__4772__auto___49357 = (0);
while(true){
if((i__4772__auto___49357 < len__4771__auto___49356)){
args__4777__auto__.push((arguments[i__4772__auto___49357]));

var G__49358 = (i__4772__auto___49357 + (1));
i__4772__auto___49357 = G__49358;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((3) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4778__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__47472){
var map__47473 = p__47472;
var map__47473__$1 = cljs.core.__destructure_map(map__47473);
var opts = map__47473__$1;
var statearr_47474_49359 = state;
(statearr_47474_49359[(1)] = cont_block);


var temp__5754__auto__ = cljs.core.async.do_alts((function (val){
var statearr_47475_49361 = state;
(statearr_47475_49361[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5754__auto__)){
var cb = temp__5754__auto__;
var statearr_47476_49362 = state;
(statearr_47476_49362[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq47467){
var G__47468 = cljs.core.first(seq47467);
var seq47467__$1 = cljs.core.next(seq47467);
var G__47469 = cljs.core.first(seq47467__$1);
var seq47467__$2 = cljs.core.next(seq47467__$1);
var G__47470 = cljs.core.first(seq47467__$2);
var seq47467__$3 = cljs.core.next(seq47467__$2);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47468,G__47469,G__47470,seq47467__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47480 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47480 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta47481){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta47481 = meta47481;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47482,meta47481__$1){
var self__ = this;
var _47482__$1 = this;
return (new cljs.core.async.t_cljs$core$async47480(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta47481__$1));
}));

(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47482){
var self__ = this;
var _47482__$1 = this;
return self__.meta47481;
}));

(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47480.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta47481","meta47481",1124401078,null)], null);
}));

(cljs.core.async.t_cljs$core$async47480.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47480.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47480");

(cljs.core.async.t_cljs$core$async47480.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async47480");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47480.
 */
cljs.core.async.__GT_t_cljs$core$async47480 = (function cljs$core$async$mix_$___GT_t_cljs$core$async47480(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta47481){
return (new cljs.core.async.t_cljs$core$async47480(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta47481));
});

}

return (new cljs.core.async.t_cljs$core$async47480(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__46308__auto___49391 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_47548){
var state_val_47549 = (state_47548[(1)]);
if((state_val_47549 === (7))){
var inst_47544 = (state_47548[(2)]);
var state_47548__$1 = state_47548;
var statearr_47551_49392 = state_47548__$1;
(statearr_47551_49392[(2)] = inst_47544);

(statearr_47551_49392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (20))){
var inst_47538 = (state_47548[(2)]);
var state_47548__$1 = state_47548;
var statearr_47552_49400 = state_47548__$1;
(statearr_47552_49400[(2)] = inst_47538);

(statearr_47552_49400[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (1))){
var inst_47489 = calc_state();
var inst_47490 = cljs.core.__destructure_map(inst_47489);
var inst_47491 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47490,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_47492 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47490,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_47493 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47490,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_47494 = inst_47489;
var state_47548__$1 = (function (){var statearr_47555 = state_47548;
(statearr_47555[(7)] = inst_47492);

(statearr_47555[(8)] = inst_47493);

(statearr_47555[(9)] = inst_47491);

(statearr_47555[(10)] = inst_47494);

return statearr_47555;
})();
var statearr_47556_49404 = state_47548__$1;
(statearr_47556_49404[(2)] = null);

(statearr_47556_49404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (4))){
var inst_47508 = (state_47548[(11)]);
var inst_47507 = (state_47548[(12)]);
var inst_47505 = (state_47548[(2)]);
var inst_47507__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47505,(0),null);
var inst_47508__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47505,(1),null);
var inst_47509 = (inst_47507__$1 == null);
var inst_47510 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47508__$1,change);
var inst_47511 = ((inst_47509) || (inst_47510));
var state_47548__$1 = (function (){var statearr_47557 = state_47548;
(statearr_47557[(11)] = inst_47508__$1);

(statearr_47557[(12)] = inst_47507__$1);

return statearr_47557;
})();
if(cljs.core.truth_(inst_47511)){
var statearr_47558_49405 = state_47548__$1;
(statearr_47558_49405[(1)] = (5));

} else {
var statearr_47559_49406 = state_47548__$1;
(statearr_47559_49406[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (15))){
var inst_47497 = (state_47548[(13)]);
var inst_47494 = inst_47497;
var state_47548__$1 = (function (){var statearr_47561 = state_47548;
(statearr_47561[(10)] = inst_47494);

return statearr_47561;
})();
var statearr_47563_49407 = state_47548__$1;
(statearr_47563_49407[(2)] = null);

(statearr_47563_49407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (13))){
var inst_47530 = (state_47548[(2)]);
var state_47548__$1 = state_47548;
if(cljs.core.truth_(inst_47530)){
var statearr_47564_49408 = state_47548__$1;
(statearr_47564_49408[(1)] = (14));

} else {
var statearr_47565_49409 = state_47548__$1;
(statearr_47565_49409[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (6))){
var inst_47498 = (state_47548[(14)]);
var inst_47508 = (state_47548[(11)]);
var inst_47522 = (state_47548[(15)]);
var inst_47522__$1 = (inst_47498.cljs$core$IFn$_invoke$arity$1 ? inst_47498.cljs$core$IFn$_invoke$arity$1(inst_47508) : inst_47498.call(null,inst_47508));
var state_47548__$1 = (function (){var statearr_47566 = state_47548;
(statearr_47566[(15)] = inst_47522__$1);

return statearr_47566;
})();
if(cljs.core.truth_(inst_47522__$1)){
var statearr_47567_49410 = state_47548__$1;
(statearr_47567_49410[(1)] = (11));

} else {
var statearr_47568_49411 = state_47548__$1;
(statearr_47568_49411[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (17))){
var inst_47533 = (state_47548[(2)]);
var state_47548__$1 = state_47548;
if(cljs.core.truth_(inst_47533)){
var statearr_47569_49415 = state_47548__$1;
(statearr_47569_49415[(1)] = (18));

} else {
var statearr_47570_49416 = state_47548__$1;
(statearr_47570_49416[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (3))){
var inst_47546 = (state_47548[(2)]);
var state_47548__$1 = state_47548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47548__$1,inst_47546);
} else {
if((state_val_47549 === (12))){
var inst_47498 = (state_47548[(14)]);
var inst_47508 = (state_47548[(11)]);
var inst_47499 = (state_47548[(16)]);
var inst_47525 = cljs.core.empty_QMARK_(inst_47498);
var inst_47526 = (inst_47499.cljs$core$IFn$_invoke$arity$1 ? inst_47499.cljs$core$IFn$_invoke$arity$1(inst_47508) : inst_47499.call(null,inst_47508));
var inst_47527 = cljs.core.not(inst_47526);
var inst_47528 = ((inst_47525) && (inst_47527));
var state_47548__$1 = state_47548;
var statearr_47571_49419 = state_47548__$1;
(statearr_47571_49419[(2)] = inst_47528);

(statearr_47571_49419[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (2))){
var inst_47497 = (state_47548[(13)]);
var inst_47494 = (state_47548[(10)]);
var inst_47497__$1 = cljs.core.__destructure_map(inst_47494);
var inst_47498 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47497__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_47499 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47497__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_47500 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47497__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_47548__$1 = (function (){var statearr_47572 = state_47548;
(statearr_47572[(14)] = inst_47498);

(statearr_47572[(13)] = inst_47497__$1);

(statearr_47572[(16)] = inst_47499);

return statearr_47572;
})();
return cljs.core.async.ioc_alts_BANG_(state_47548__$1,(4),inst_47500);
} else {
if((state_val_47549 === (19))){
var state_47548__$1 = state_47548;
var statearr_47573_49420 = state_47548__$1;
(statearr_47573_49420[(2)] = null);

(statearr_47573_49420[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (11))){
var inst_47522 = (state_47548[(15)]);
var state_47548__$1 = state_47548;
var statearr_47574_49421 = state_47548__$1;
(statearr_47574_49421[(2)] = inst_47522);

(statearr_47574_49421[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (9))){
var state_47548__$1 = state_47548;
var statearr_47577_49422 = state_47548__$1;
(statearr_47577_49422[(2)] = null);

(statearr_47577_49422[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (5))){
var inst_47507 = (state_47548[(12)]);
var inst_47513 = (inst_47507 == null);
var state_47548__$1 = state_47548;
if(cljs.core.truth_(inst_47513)){
var statearr_47578_49425 = state_47548__$1;
(statearr_47578_49425[(1)] = (8));

} else {
var statearr_47579_49426 = state_47548__$1;
(statearr_47579_49426[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (14))){
var inst_47507 = (state_47548[(12)]);
var state_47548__$1 = state_47548;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47548__$1,(17),out,inst_47507);
} else {
if((state_val_47549 === (16))){
var inst_47542 = (state_47548[(2)]);
var state_47548__$1 = state_47548;
var statearr_47580_49427 = state_47548__$1;
(statearr_47580_49427[(2)] = inst_47542);

(statearr_47580_49427[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (10))){
var inst_47518 = (state_47548[(2)]);
var inst_47519 = calc_state();
var inst_47494 = inst_47519;
var state_47548__$1 = (function (){var statearr_47581 = state_47548;
(statearr_47581[(17)] = inst_47518);

(statearr_47581[(10)] = inst_47494);

return statearr_47581;
})();
var statearr_47582_49428 = state_47548__$1;
(statearr_47582_49428[(2)] = null);

(statearr_47582_49428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (18))){
var inst_47497 = (state_47548[(13)]);
var inst_47494 = inst_47497;
var state_47548__$1 = (function (){var statearr_47583 = state_47548;
(statearr_47583[(10)] = inst_47494);

return statearr_47583;
})();
var statearr_47584_49429 = state_47548__$1;
(statearr_47584_49429[(2)] = null);

(statearr_47584_49429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47549 === (8))){
var inst_47508 = (state_47548[(11)]);
var inst_47515 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_47508);
var state_47548__$1 = state_47548;
var statearr_47585_49430 = state_47548__$1;
(statearr_47585_49430[(2)] = inst_47515);

(statearr_47585_49430[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__46108__auto__ = null;
var cljs$core$async$mix_$_state_machine__46108__auto____0 = (function (){
var statearr_47589 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47589[(0)] = cljs$core$async$mix_$_state_machine__46108__auto__);

(statearr_47589[(1)] = (1));

return statearr_47589;
});
var cljs$core$async$mix_$_state_machine__46108__auto____1 = (function (state_47548){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_47548);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e47590){var ex__46111__auto__ = e47590;
var statearr_47592_49437 = state_47548;
(statearr_47592_49437[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_47548[(4)]))){
var statearr_47595_49438 = state_47548;
(statearr_47595_49438[(1)] = cljs.core.first((state_47548[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49440 = state_47548;
state_47548 = G__49440;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__46108__auto__ = function(state_47548){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__46108__auto____1.call(this,state_47548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__46108__auto____0;
cljs$core$async$mix_$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__46108__auto____1;
return cljs$core$async$mix_$_state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_47599 = f__46309__auto__();
(statearr_47599[(6)] = c__46308__auto___49391);

return statearr_47599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_49445 = (function (p,v,ch,close_QMARK_){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4464__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4461__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4461__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_49445(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_49447 = (function (p,v,ch){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4464__auto__.call(null,p,v,ch));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4461__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_49447(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_49448 = (function() {
var G__49449 = null;
var G__49449__1 = (function (p){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4464__auto__.call(null,p));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4461__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__49449__2 = (function (p,v){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4464__auto__.call(null,p,v));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4461__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__49449 = function(p,v){
switch(arguments.length){
case 1:
return G__49449__1.call(this,p);
case 2:
return G__49449__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__49449.cljs$core$IFn$_invoke$arity$1 = G__49449__1;
G__49449.cljs$core$IFn$_invoke$arity$2 = G__49449__2;
return G__49449;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__47629 = arguments.length;
switch (G__47629) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_49448(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_49448(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__47644 = arguments.length;
switch (G__47644) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__47638_SHARP_){
if(cljs.core.truth_((p1__47638_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47638_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__47638_SHARP_.call(null,topic)))){
return p1__47638_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__47638_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47653 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47653 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta47654){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta47654 = meta47654;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47653.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47655,meta47654__$1){
var self__ = this;
var _47655__$1 = this;
return (new cljs.core.async.t_cljs$core$async47653(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta47654__$1));
}));

(cljs.core.async.t_cljs$core$async47653.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47655){
var self__ = this;
var _47655__$1 = this;
return self__.meta47654;
}));

(cljs.core.async.t_cljs$core$async47653.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47653.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async47653.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47653.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async47653.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5754__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5754__auto__)){
var m = temp__5754__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async47653.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async47653.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async47653.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta47654","meta47654",-1003283646,null)], null);
}));

(cljs.core.async.t_cljs$core$async47653.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47653.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47653");

(cljs.core.async.t_cljs$core$async47653.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async47653");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47653.
 */
cljs.core.async.__GT_t_cljs$core$async47653 = (function cljs$core$async$__GT_t_cljs$core$async47653(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta47654){
return (new cljs.core.async.t_cljs$core$async47653(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta47654));
});

}

return (new cljs.core.async.t_cljs$core$async47653(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__46308__auto___49463 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_47752){
var state_val_47753 = (state_47752[(1)]);
if((state_val_47753 === (7))){
var inst_47748 = (state_47752[(2)]);
var state_47752__$1 = state_47752;
var statearr_47758_49465 = state_47752__$1;
(statearr_47758_49465[(2)] = inst_47748);

(statearr_47758_49465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (20))){
var state_47752__$1 = state_47752;
var statearr_47759_49466 = state_47752__$1;
(statearr_47759_49466[(2)] = null);

(statearr_47759_49466[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (1))){
var state_47752__$1 = state_47752;
var statearr_47760_49467 = state_47752__$1;
(statearr_47760_49467[(2)] = null);

(statearr_47760_49467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (24))){
var inst_47731 = (state_47752[(7)]);
var inst_47740 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_47731);
var state_47752__$1 = state_47752;
var statearr_47762_49469 = state_47752__$1;
(statearr_47762_49469[(2)] = inst_47740);

(statearr_47762_49469[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (4))){
var inst_47679 = (state_47752[(8)]);
var inst_47679__$1 = (state_47752[(2)]);
var inst_47680 = (inst_47679__$1 == null);
var state_47752__$1 = (function (){var statearr_47766 = state_47752;
(statearr_47766[(8)] = inst_47679__$1);

return statearr_47766;
})();
if(cljs.core.truth_(inst_47680)){
var statearr_47767_49471 = state_47752__$1;
(statearr_47767_49471[(1)] = (5));

} else {
var statearr_47768_49472 = state_47752__$1;
(statearr_47768_49472[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (15))){
var inst_47724 = (state_47752[(2)]);
var state_47752__$1 = state_47752;
var statearr_47769_49477 = state_47752__$1;
(statearr_47769_49477[(2)] = inst_47724);

(statearr_47769_49477[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (21))){
var inst_47745 = (state_47752[(2)]);
var state_47752__$1 = (function (){var statearr_47771 = state_47752;
(statearr_47771[(9)] = inst_47745);

return statearr_47771;
})();
var statearr_47772_49478 = state_47752__$1;
(statearr_47772_49478[(2)] = null);

(statearr_47772_49478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (13))){
var inst_47704 = (state_47752[(10)]);
var inst_47706 = cljs.core.chunked_seq_QMARK_(inst_47704);
var state_47752__$1 = state_47752;
if(inst_47706){
var statearr_47775_49483 = state_47752__$1;
(statearr_47775_49483[(1)] = (16));

} else {
var statearr_47777_49484 = state_47752__$1;
(statearr_47777_49484[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (22))){
var inst_47737 = (state_47752[(2)]);
var state_47752__$1 = state_47752;
if(cljs.core.truth_(inst_47737)){
var statearr_47778_49486 = state_47752__$1;
(statearr_47778_49486[(1)] = (23));

} else {
var statearr_47779_49487 = state_47752__$1;
(statearr_47779_49487[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (6))){
var inst_47679 = (state_47752[(8)]);
var inst_47731 = (state_47752[(7)]);
var inst_47733 = (state_47752[(11)]);
var inst_47731__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_47679) : topic_fn.call(null,inst_47679));
var inst_47732 = cljs.core.deref(mults);
var inst_47733__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47732,inst_47731__$1);
var state_47752__$1 = (function (){var statearr_47781 = state_47752;
(statearr_47781[(7)] = inst_47731__$1);

(statearr_47781[(11)] = inst_47733__$1);

return statearr_47781;
})();
if(cljs.core.truth_(inst_47733__$1)){
var statearr_47784_49488 = state_47752__$1;
(statearr_47784_49488[(1)] = (19));

} else {
var statearr_47785_49489 = state_47752__$1;
(statearr_47785_49489[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (25))){
var inst_47742 = (state_47752[(2)]);
var state_47752__$1 = state_47752;
var statearr_47788_49490 = state_47752__$1;
(statearr_47788_49490[(2)] = inst_47742);

(statearr_47788_49490[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (17))){
var inst_47704 = (state_47752[(10)]);
var inst_47715 = cljs.core.first(inst_47704);
var inst_47716 = cljs.core.async.muxch_STAR_(inst_47715);
var inst_47717 = cljs.core.async.close_BANG_(inst_47716);
var inst_47718 = cljs.core.next(inst_47704);
var inst_47689 = inst_47718;
var inst_47690 = null;
var inst_47691 = (0);
var inst_47692 = (0);
var state_47752__$1 = (function (){var statearr_47791 = state_47752;
(statearr_47791[(12)] = inst_47689);

(statearr_47791[(13)] = inst_47692);

(statearr_47791[(14)] = inst_47691);

(statearr_47791[(15)] = inst_47690);

(statearr_47791[(16)] = inst_47717);

return statearr_47791;
})();
var statearr_47792_49492 = state_47752__$1;
(statearr_47792_49492[(2)] = null);

(statearr_47792_49492[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (3))){
var inst_47750 = (state_47752[(2)]);
var state_47752__$1 = state_47752;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47752__$1,inst_47750);
} else {
if((state_val_47753 === (12))){
var inst_47727 = (state_47752[(2)]);
var state_47752__$1 = state_47752;
var statearr_47795_49495 = state_47752__$1;
(statearr_47795_49495[(2)] = inst_47727);

(statearr_47795_49495[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (2))){
var state_47752__$1 = state_47752;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47752__$1,(4),ch);
} else {
if((state_val_47753 === (23))){
var state_47752__$1 = state_47752;
var statearr_47797_49496 = state_47752__$1;
(statearr_47797_49496[(2)] = null);

(statearr_47797_49496[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (19))){
var inst_47679 = (state_47752[(8)]);
var inst_47733 = (state_47752[(11)]);
var inst_47735 = cljs.core.async.muxch_STAR_(inst_47733);
var state_47752__$1 = state_47752;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47752__$1,(22),inst_47735,inst_47679);
} else {
if((state_val_47753 === (11))){
var inst_47689 = (state_47752[(12)]);
var inst_47704 = (state_47752[(10)]);
var inst_47704__$1 = cljs.core.seq(inst_47689);
var state_47752__$1 = (function (){var statearr_47799 = state_47752;
(statearr_47799[(10)] = inst_47704__$1);

return statearr_47799;
})();
if(inst_47704__$1){
var statearr_47800_49497 = state_47752__$1;
(statearr_47800_49497[(1)] = (13));

} else {
var statearr_47801_49498 = state_47752__$1;
(statearr_47801_49498[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (9))){
var inst_47729 = (state_47752[(2)]);
var state_47752__$1 = state_47752;
var statearr_47803_49499 = state_47752__$1;
(statearr_47803_49499[(2)] = inst_47729);

(statearr_47803_49499[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (5))){
var inst_47686 = cljs.core.deref(mults);
var inst_47687 = cljs.core.vals(inst_47686);
var inst_47688 = cljs.core.seq(inst_47687);
var inst_47689 = inst_47688;
var inst_47690 = null;
var inst_47691 = (0);
var inst_47692 = (0);
var state_47752__$1 = (function (){var statearr_47806 = state_47752;
(statearr_47806[(12)] = inst_47689);

(statearr_47806[(13)] = inst_47692);

(statearr_47806[(14)] = inst_47691);

(statearr_47806[(15)] = inst_47690);

return statearr_47806;
})();
var statearr_47807_49505 = state_47752__$1;
(statearr_47807_49505[(2)] = null);

(statearr_47807_49505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (14))){
var state_47752__$1 = state_47752;
var statearr_47811_49511 = state_47752__$1;
(statearr_47811_49511[(2)] = null);

(statearr_47811_49511[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (16))){
var inst_47704 = (state_47752[(10)]);
var inst_47708 = cljs.core.chunk_first(inst_47704);
var inst_47710 = cljs.core.chunk_rest(inst_47704);
var inst_47711 = cljs.core.count(inst_47708);
var inst_47689 = inst_47710;
var inst_47690 = inst_47708;
var inst_47691 = inst_47711;
var inst_47692 = (0);
var state_47752__$1 = (function (){var statearr_47813 = state_47752;
(statearr_47813[(12)] = inst_47689);

(statearr_47813[(13)] = inst_47692);

(statearr_47813[(14)] = inst_47691);

(statearr_47813[(15)] = inst_47690);

return statearr_47813;
})();
var statearr_47814_49523 = state_47752__$1;
(statearr_47814_49523[(2)] = null);

(statearr_47814_49523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (10))){
var inst_47689 = (state_47752[(12)]);
var inst_47692 = (state_47752[(13)]);
var inst_47691 = (state_47752[(14)]);
var inst_47690 = (state_47752[(15)]);
var inst_47698 = cljs.core._nth(inst_47690,inst_47692);
var inst_47699 = cljs.core.async.muxch_STAR_(inst_47698);
var inst_47700 = cljs.core.async.close_BANG_(inst_47699);
var inst_47701 = (inst_47692 + (1));
var tmp47808 = inst_47689;
var tmp47809 = inst_47691;
var tmp47810 = inst_47690;
var inst_47689__$1 = tmp47808;
var inst_47690__$1 = tmp47810;
var inst_47691__$1 = tmp47809;
var inst_47692__$1 = inst_47701;
var state_47752__$1 = (function (){var statearr_47818 = state_47752;
(statearr_47818[(12)] = inst_47689__$1);

(statearr_47818[(17)] = inst_47700);

(statearr_47818[(13)] = inst_47692__$1);

(statearr_47818[(14)] = inst_47691__$1);

(statearr_47818[(15)] = inst_47690__$1);

return statearr_47818;
})();
var statearr_47819_49539 = state_47752__$1;
(statearr_47819_49539[(2)] = null);

(statearr_47819_49539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (18))){
var inst_47721 = (state_47752[(2)]);
var state_47752__$1 = state_47752;
var statearr_47820_49540 = state_47752__$1;
(statearr_47820_49540[(2)] = inst_47721);

(statearr_47820_49540[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47753 === (8))){
var inst_47692 = (state_47752[(13)]);
var inst_47691 = (state_47752[(14)]);
var inst_47695 = (inst_47692 < inst_47691);
var inst_47696 = inst_47695;
var state_47752__$1 = state_47752;
if(cljs.core.truth_(inst_47696)){
var statearr_47822_49549 = state_47752__$1;
(statearr_47822_49549[(1)] = (10));

} else {
var statearr_47823_49550 = state_47752__$1;
(statearr_47823_49550[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46108__auto__ = null;
var cljs$core$async$state_machine__46108__auto____0 = (function (){
var statearr_47824 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47824[(0)] = cljs$core$async$state_machine__46108__auto__);

(statearr_47824[(1)] = (1));

return statearr_47824;
});
var cljs$core$async$state_machine__46108__auto____1 = (function (state_47752){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_47752);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e47827){var ex__46111__auto__ = e47827;
var statearr_47828_49559 = state_47752;
(statearr_47828_49559[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_47752[(4)]))){
var statearr_47830_49560 = state_47752;
(statearr_47830_49560[(1)] = cljs.core.first((state_47752[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49563 = state_47752;
state_47752 = G__49563;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$state_machine__46108__auto__ = function(state_47752){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46108__auto____1.call(this,state_47752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46108__auto____0;
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46108__auto____1;
return cljs$core$async$state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_47831 = f__46309__auto__();
(statearr_47831[(6)] = c__46308__auto___49463);

return statearr_47831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__47835 = arguments.length;
switch (G__47835) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__47851 = arguments.length;
switch (G__47851) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__47865 = arguments.length;
switch (G__47865) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__46308__auto___49578 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_47928){
var state_val_47929 = (state_47928[(1)]);
if((state_val_47929 === (7))){
var state_47928__$1 = state_47928;
var statearr_47935_49582 = state_47928__$1;
(statearr_47935_49582[(2)] = null);

(statearr_47935_49582[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47929 === (1))){
var state_47928__$1 = state_47928;
var statearr_47941_49588 = state_47928__$1;
(statearr_47941_49588[(2)] = null);

(statearr_47941_49588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47929 === (4))){
var inst_47885 = (state_47928[(7)]);
var inst_47884 = (state_47928[(8)]);
var inst_47887 = (inst_47885 < inst_47884);
var state_47928__$1 = state_47928;
if(cljs.core.truth_(inst_47887)){
var statearr_47944_49602 = state_47928__$1;
(statearr_47944_49602[(1)] = (6));

} else {
var statearr_47945_49606 = state_47928__$1;
(statearr_47945_49606[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47929 === (15))){
var inst_47914 = (state_47928[(9)]);
var inst_47919 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_47914);
var state_47928__$1 = state_47928;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47928__$1,(17),out,inst_47919);
} else {
if((state_val_47929 === (13))){
var inst_47914 = (state_47928[(9)]);
var inst_47914__$1 = (state_47928[(2)]);
var inst_47915 = cljs.core.some(cljs.core.nil_QMARK_,inst_47914__$1);
var state_47928__$1 = (function (){var statearr_47951 = state_47928;
(statearr_47951[(9)] = inst_47914__$1);

return statearr_47951;
})();
if(cljs.core.truth_(inst_47915)){
var statearr_47952_49632 = state_47928__$1;
(statearr_47952_49632[(1)] = (14));

} else {
var statearr_47953_49635 = state_47928__$1;
(statearr_47953_49635[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47929 === (6))){
var state_47928__$1 = state_47928;
var statearr_47957_49641 = state_47928__$1;
(statearr_47957_49641[(2)] = null);

(statearr_47957_49641[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47929 === (17))){
var inst_47921 = (state_47928[(2)]);
var state_47928__$1 = (function (){var statearr_47968 = state_47928;
(statearr_47968[(10)] = inst_47921);

return statearr_47968;
})();
var statearr_47969_49657 = state_47928__$1;
(statearr_47969_49657[(2)] = null);

(statearr_47969_49657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47929 === (3))){
var inst_47926 = (state_47928[(2)]);
var state_47928__$1 = state_47928;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47928__$1,inst_47926);
} else {
if((state_val_47929 === (12))){
var _ = (function (){var statearr_47971 = state_47928;
(statearr_47971[(4)] = cljs.core.rest((state_47928[(4)])));

return statearr_47971;
})();
var state_47928__$1 = state_47928;
var ex47966 = (state_47928__$1[(2)]);
var statearr_47974_49674 = state_47928__$1;
(statearr_47974_49674[(5)] = ex47966);


if((ex47966 instanceof Object)){
var statearr_47976_49676 = state_47928__$1;
(statearr_47976_49676[(1)] = (11));

(statearr_47976_49676[(5)] = null);

} else {
throw ex47966;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47929 === (2))){
var inst_47882 = cljs.core.reset_BANG_(dctr,cnt);
var inst_47884 = cnt;
var inst_47885 = (0);
var state_47928__$1 = (function (){var statearr_47986 = state_47928;
(statearr_47986[(7)] = inst_47885);

(statearr_47986[(8)] = inst_47884);

(statearr_47986[(11)] = inst_47882);

return statearr_47986;
})();
var statearr_47987_49678 = state_47928__$1;
(statearr_47987_49678[(2)] = null);

(statearr_47987_49678[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47929 === (11))){
var inst_47892 = (state_47928[(2)]);
var inst_47893 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_47928__$1 = (function (){var statearr_47994 = state_47928;
(statearr_47994[(12)] = inst_47892);

return statearr_47994;
})();
var statearr_47995_49679 = state_47928__$1;
(statearr_47995_49679[(2)] = inst_47893);

(statearr_47995_49679[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47929 === (9))){
var inst_47885 = (state_47928[(7)]);
var _ = (function (){var statearr_47997 = state_47928;
(statearr_47997[(4)] = cljs.core.cons((12),(state_47928[(4)])));

return statearr_47997;
})();
var inst_47899 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_47885) : chs__$1.call(null,inst_47885));
var inst_47901 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_47885) : done.call(null,inst_47885));
var inst_47902 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_47899,inst_47901);
var ___$1 = (function (){var statearr_48001 = state_47928;
(statearr_48001[(4)] = cljs.core.rest((state_47928[(4)])));

return statearr_48001;
})();
var state_47928__$1 = state_47928;
var statearr_48003_49692 = state_47928__$1;
(statearr_48003_49692[(2)] = inst_47902);

(statearr_48003_49692[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47929 === (5))){
var inst_47912 = (state_47928[(2)]);
var state_47928__$1 = (function (){var statearr_48005 = state_47928;
(statearr_48005[(13)] = inst_47912);

return statearr_48005;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47928__$1,(13),dchan);
} else {
if((state_val_47929 === (14))){
var inst_47917 = cljs.core.async.close_BANG_(out);
var state_47928__$1 = state_47928;
var statearr_48006_49694 = state_47928__$1;
(statearr_48006_49694[(2)] = inst_47917);

(statearr_48006_49694[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47929 === (16))){
var inst_47924 = (state_47928[(2)]);
var state_47928__$1 = state_47928;
var statearr_48012_49695 = state_47928__$1;
(statearr_48012_49695[(2)] = inst_47924);

(statearr_48012_49695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47929 === (10))){
var inst_47885 = (state_47928[(7)]);
var inst_47905 = (state_47928[(2)]);
var inst_47906 = (inst_47885 + (1));
var inst_47885__$1 = inst_47906;
var state_47928__$1 = (function (){var statearr_48015 = state_47928;
(statearr_48015[(14)] = inst_47905);

(statearr_48015[(7)] = inst_47885__$1);

return statearr_48015;
})();
var statearr_48016_49697 = state_47928__$1;
(statearr_48016_49697[(2)] = null);

(statearr_48016_49697[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47929 === (8))){
var inst_47910 = (state_47928[(2)]);
var state_47928__$1 = state_47928;
var statearr_48017_49698 = state_47928__$1;
(statearr_48017_49698[(2)] = inst_47910);

(statearr_48017_49698[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46108__auto__ = null;
var cljs$core$async$state_machine__46108__auto____0 = (function (){
var statearr_48020 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48020[(0)] = cljs$core$async$state_machine__46108__auto__);

(statearr_48020[(1)] = (1));

return statearr_48020;
});
var cljs$core$async$state_machine__46108__auto____1 = (function (state_47928){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_47928);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e48021){var ex__46111__auto__ = e48021;
var statearr_48022_49703 = state_47928;
(statearr_48022_49703[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_47928[(4)]))){
var statearr_48025_49704 = state_47928;
(statearr_48025_49704[(1)] = cljs.core.first((state_47928[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49709 = state_47928;
state_47928 = G__49709;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$state_machine__46108__auto__ = function(state_47928){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46108__auto____1.call(this,state_47928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46108__auto____0;
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46108__auto____1;
return cljs$core$async$state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_48031 = f__46309__auto__();
(statearr_48031[(6)] = c__46308__auto___49578);

return statearr_48031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__48039 = arguments.length;
switch (G__48039) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46308__auto___49722 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_48083){
var state_val_48084 = (state_48083[(1)]);
if((state_val_48084 === (7))){
var inst_48061 = (state_48083[(7)]);
var inst_48062 = (state_48083[(8)]);
var inst_48061__$1 = (state_48083[(2)]);
var inst_48062__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48061__$1,(0),null);
var inst_48063 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48061__$1,(1),null);
var inst_48064 = (inst_48062__$1 == null);
var state_48083__$1 = (function (){var statearr_48092 = state_48083;
(statearr_48092[(9)] = inst_48063);

(statearr_48092[(7)] = inst_48061__$1);

(statearr_48092[(8)] = inst_48062__$1);

return statearr_48092;
})();
if(cljs.core.truth_(inst_48064)){
var statearr_48093_49728 = state_48083__$1;
(statearr_48093_49728[(1)] = (8));

} else {
var statearr_48094_49733 = state_48083__$1;
(statearr_48094_49733[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48084 === (1))){
var inst_48050 = cljs.core.vec(chs);
var inst_48051 = inst_48050;
var state_48083__$1 = (function (){var statearr_48096 = state_48083;
(statearr_48096[(10)] = inst_48051);

return statearr_48096;
})();
var statearr_48097_49735 = state_48083__$1;
(statearr_48097_49735[(2)] = null);

(statearr_48097_49735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48084 === (4))){
var inst_48051 = (state_48083[(10)]);
var state_48083__$1 = state_48083;
return cljs.core.async.ioc_alts_BANG_(state_48083__$1,(7),inst_48051);
} else {
if((state_val_48084 === (6))){
var inst_48078 = (state_48083[(2)]);
var state_48083__$1 = state_48083;
var statearr_48100_49743 = state_48083__$1;
(statearr_48100_49743[(2)] = inst_48078);

(statearr_48100_49743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48084 === (3))){
var inst_48080 = (state_48083[(2)]);
var state_48083__$1 = state_48083;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48083__$1,inst_48080);
} else {
if((state_val_48084 === (2))){
var inst_48051 = (state_48083[(10)]);
var inst_48054 = cljs.core.count(inst_48051);
var inst_48055 = (inst_48054 > (0));
var state_48083__$1 = state_48083;
if(cljs.core.truth_(inst_48055)){
var statearr_48107_49748 = state_48083__$1;
(statearr_48107_49748[(1)] = (4));

} else {
var statearr_48108_49749 = state_48083__$1;
(statearr_48108_49749[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48084 === (11))){
var inst_48051 = (state_48083[(10)]);
var inst_48071 = (state_48083[(2)]);
var tmp48106 = inst_48051;
var inst_48051__$1 = tmp48106;
var state_48083__$1 = (function (){var statearr_48111 = state_48083;
(statearr_48111[(11)] = inst_48071);

(statearr_48111[(10)] = inst_48051__$1);

return statearr_48111;
})();
var statearr_48112_49754 = state_48083__$1;
(statearr_48112_49754[(2)] = null);

(statearr_48112_49754[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48084 === (9))){
var inst_48062 = (state_48083[(8)]);
var state_48083__$1 = state_48083;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48083__$1,(11),out,inst_48062);
} else {
if((state_val_48084 === (5))){
var inst_48076 = cljs.core.async.close_BANG_(out);
var state_48083__$1 = state_48083;
var statearr_48116_49762 = state_48083__$1;
(statearr_48116_49762[(2)] = inst_48076);

(statearr_48116_49762[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48084 === (10))){
var inst_48074 = (state_48083[(2)]);
var state_48083__$1 = state_48083;
var statearr_48117_49770 = state_48083__$1;
(statearr_48117_49770[(2)] = inst_48074);

(statearr_48117_49770[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48084 === (8))){
var inst_48051 = (state_48083[(10)]);
var inst_48063 = (state_48083[(9)]);
var inst_48061 = (state_48083[(7)]);
var inst_48062 = (state_48083[(8)]);
var inst_48066 = (function (){var cs = inst_48051;
var vec__48057 = inst_48061;
var v = inst_48062;
var c = inst_48063;
return (function (p1__48036_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__48036_SHARP_);
});
})();
var inst_48067 = cljs.core.filterv(inst_48066,inst_48051);
var inst_48051__$1 = inst_48067;
var state_48083__$1 = (function (){var statearr_48119 = state_48083;
(statearr_48119[(10)] = inst_48051__$1);

return statearr_48119;
})();
var statearr_48121_49784 = state_48083__$1;
(statearr_48121_49784[(2)] = null);

(statearr_48121_49784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46108__auto__ = null;
var cljs$core$async$state_machine__46108__auto____0 = (function (){
var statearr_48124 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48124[(0)] = cljs$core$async$state_machine__46108__auto__);

(statearr_48124[(1)] = (1));

return statearr_48124;
});
var cljs$core$async$state_machine__46108__auto____1 = (function (state_48083){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_48083);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e48127){var ex__46111__auto__ = e48127;
var statearr_48129_49793 = state_48083;
(statearr_48129_49793[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_48083[(4)]))){
var statearr_48130_49794 = state_48083;
(statearr_48130_49794[(1)] = cljs.core.first((state_48083[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49795 = state_48083;
state_48083 = G__49795;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$state_machine__46108__auto__ = function(state_48083){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46108__auto____1.call(this,state_48083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46108__auto____0;
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46108__auto____1;
return cljs$core$async$state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_48134 = f__46309__auto__();
(statearr_48134[(6)] = c__46308__auto___49722);

return statearr_48134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__48140 = arguments.length;
switch (G__48140) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46308__auto___49798 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_48167){
var state_val_48168 = (state_48167[(1)]);
if((state_val_48168 === (7))){
var inst_48149 = (state_48167[(7)]);
var inst_48149__$1 = (state_48167[(2)]);
var inst_48150 = (inst_48149__$1 == null);
var inst_48151 = cljs.core.not(inst_48150);
var state_48167__$1 = (function (){var statearr_48169 = state_48167;
(statearr_48169[(7)] = inst_48149__$1);

return statearr_48169;
})();
if(inst_48151){
var statearr_48170_49800 = state_48167__$1;
(statearr_48170_49800[(1)] = (8));

} else {
var statearr_48171_49801 = state_48167__$1;
(statearr_48171_49801[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48168 === (1))){
var inst_48144 = (0);
var state_48167__$1 = (function (){var statearr_48172 = state_48167;
(statearr_48172[(8)] = inst_48144);

return statearr_48172;
})();
var statearr_48173_49809 = state_48167__$1;
(statearr_48173_49809[(2)] = null);

(statearr_48173_49809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48168 === (4))){
var state_48167__$1 = state_48167;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48167__$1,(7),ch);
} else {
if((state_val_48168 === (6))){
var inst_48162 = (state_48167[(2)]);
var state_48167__$1 = state_48167;
var statearr_48174_49811 = state_48167__$1;
(statearr_48174_49811[(2)] = inst_48162);

(statearr_48174_49811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48168 === (3))){
var inst_48164 = (state_48167[(2)]);
var inst_48165 = cljs.core.async.close_BANG_(out);
var state_48167__$1 = (function (){var statearr_48175 = state_48167;
(statearr_48175[(9)] = inst_48164);

return statearr_48175;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48167__$1,inst_48165);
} else {
if((state_val_48168 === (2))){
var inst_48144 = (state_48167[(8)]);
var inst_48146 = (inst_48144 < n);
var state_48167__$1 = state_48167;
if(cljs.core.truth_(inst_48146)){
var statearr_48176_49821 = state_48167__$1;
(statearr_48176_49821[(1)] = (4));

} else {
var statearr_48177_49822 = state_48167__$1;
(statearr_48177_49822[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48168 === (11))){
var inst_48144 = (state_48167[(8)]);
var inst_48154 = (state_48167[(2)]);
var inst_48155 = (inst_48144 + (1));
var inst_48144__$1 = inst_48155;
var state_48167__$1 = (function (){var statearr_48178 = state_48167;
(statearr_48178[(8)] = inst_48144__$1);

(statearr_48178[(10)] = inst_48154);

return statearr_48178;
})();
var statearr_48179_49831 = state_48167__$1;
(statearr_48179_49831[(2)] = null);

(statearr_48179_49831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48168 === (9))){
var state_48167__$1 = state_48167;
var statearr_48180_49837 = state_48167__$1;
(statearr_48180_49837[(2)] = null);

(statearr_48180_49837[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48168 === (5))){
var state_48167__$1 = state_48167;
var statearr_48181_49839 = state_48167__$1;
(statearr_48181_49839[(2)] = null);

(statearr_48181_49839[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48168 === (10))){
var inst_48159 = (state_48167[(2)]);
var state_48167__$1 = state_48167;
var statearr_48182_49840 = state_48167__$1;
(statearr_48182_49840[(2)] = inst_48159);

(statearr_48182_49840[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48168 === (8))){
var inst_48149 = (state_48167[(7)]);
var state_48167__$1 = state_48167;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48167__$1,(11),out,inst_48149);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46108__auto__ = null;
var cljs$core$async$state_machine__46108__auto____0 = (function (){
var statearr_48183 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48183[(0)] = cljs$core$async$state_machine__46108__auto__);

(statearr_48183[(1)] = (1));

return statearr_48183;
});
var cljs$core$async$state_machine__46108__auto____1 = (function (state_48167){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_48167);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e48184){var ex__46111__auto__ = e48184;
var statearr_48185_49846 = state_48167;
(statearr_48185_49846[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_48167[(4)]))){
var statearr_48186_49851 = state_48167;
(statearr_48186_49851[(1)] = cljs.core.first((state_48167[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49852 = state_48167;
state_48167 = G__49852;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$state_machine__46108__auto__ = function(state_48167){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46108__auto____1.call(this,state_48167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46108__auto____0;
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46108__auto____1;
return cljs$core$async$state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_48187 = f__46309__auto__();
(statearr_48187[(6)] = c__46308__auto___49798);

return statearr_48187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48189 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48189 = (function (f,ch,meta48190){
this.f = f;
this.ch = ch;
this.meta48190 = meta48190;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48189.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48191,meta48190__$1){
var self__ = this;
var _48191__$1 = this;
return (new cljs.core.async.t_cljs$core$async48189(self__.f,self__.ch,meta48190__$1));
}));

(cljs.core.async.t_cljs$core$async48189.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48191){
var self__ = this;
var _48191__$1 = this;
return self__.meta48190;
}));

(cljs.core.async.t_cljs$core$async48189.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48189.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48189.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48189.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48189.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48194 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48194 = (function (f,ch,meta48190,_,fn1,meta48195){
this.f = f;
this.ch = ch;
this.meta48190 = meta48190;
this._ = _;
this.fn1 = fn1;
this.meta48195 = meta48195;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48194.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48196,meta48195__$1){
var self__ = this;
var _48196__$1 = this;
return (new cljs.core.async.t_cljs$core$async48194(self__.f,self__.ch,self__.meta48190,self__._,self__.fn1,meta48195__$1));
}));

(cljs.core.async.t_cljs$core$async48194.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48196){
var self__ = this;
var _48196__$1 = this;
return self__.meta48195;
}));

(cljs.core.async.t_cljs$core$async48194.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48194.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async48194.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async48194.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__48188_SHARP_){
var G__48197 = (((p1__48188_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__48188_SHARP_) : self__.f.call(null,p1__48188_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__48197) : f1.call(null,G__48197));
});
}));

(cljs.core.async.t_cljs$core$async48194.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48190","meta48190",-442095145,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async48189","cljs.core.async/t_cljs$core$async48189",625890340,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta48195","meta48195",-1390581493,null)], null);
}));

(cljs.core.async.t_cljs$core$async48194.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48194.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48194");

(cljs.core.async.t_cljs$core$async48194.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async48194");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48194.
 */
cljs.core.async.__GT_t_cljs$core$async48194 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48194(f__$1,ch__$1,meta48190__$1,___$2,fn1__$1,meta48195){
return (new cljs.core.async.t_cljs$core$async48194(f__$1,ch__$1,meta48190__$1,___$2,fn1__$1,meta48195));
});

}

return (new cljs.core.async.t_cljs$core$async48194(self__.f,self__.ch,self__.meta48190,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4149__auto__ = ret;
if(cljs.core.truth_(and__4149__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4149__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__48200 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__48200) : self__.f.call(null,G__48200));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async48189.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48189.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async48189.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48190","meta48190",-442095145,null)], null);
}));

(cljs.core.async.t_cljs$core$async48189.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48189.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48189");

(cljs.core.async.t_cljs$core$async48189.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async48189");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48189.
 */
cljs.core.async.__GT_t_cljs$core$async48189 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48189(f__$1,ch__$1,meta48190){
return (new cljs.core.async.t_cljs$core$async48189(f__$1,ch__$1,meta48190));
});

}

return (new cljs.core.async.t_cljs$core$async48189(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48203 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48203 = (function (f,ch,meta48204){
this.f = f;
this.ch = ch;
this.meta48204 = meta48204;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48203.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48205,meta48204__$1){
var self__ = this;
var _48205__$1 = this;
return (new cljs.core.async.t_cljs$core$async48203(self__.f,self__.ch,meta48204__$1));
}));

(cljs.core.async.t_cljs$core$async48203.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48205){
var self__ = this;
var _48205__$1 = this;
return self__.meta48204;
}));

(cljs.core.async.t_cljs$core$async48203.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48203.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48203.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48203.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async48203.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48203.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async48203.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48204","meta48204",1150882815,null)], null);
}));

(cljs.core.async.t_cljs$core$async48203.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48203.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48203");

(cljs.core.async.t_cljs$core$async48203.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async48203");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48203.
 */
cljs.core.async.__GT_t_cljs$core$async48203 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async48203(f__$1,ch__$1,meta48204){
return (new cljs.core.async.t_cljs$core$async48203(f__$1,ch__$1,meta48204));
});

}

return (new cljs.core.async.t_cljs$core$async48203(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48208 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48208 = (function (p,ch,meta48209){
this.p = p;
this.ch = ch;
this.meta48209 = meta48209;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48208.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48210,meta48209__$1){
var self__ = this;
var _48210__$1 = this;
return (new cljs.core.async.t_cljs$core$async48208(self__.p,self__.ch,meta48209__$1));
}));

(cljs.core.async.t_cljs$core$async48208.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48210){
var self__ = this;
var _48210__$1 = this;
return self__.meta48209;
}));

(cljs.core.async.t_cljs$core$async48208.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48208.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48208.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48208.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48208.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async48208.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48208.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async48208.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48209","meta48209",-1425050220,null)], null);
}));

(cljs.core.async.t_cljs$core$async48208.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48208.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48208");

(cljs.core.async.t_cljs$core$async48208.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async48208");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48208.
 */
cljs.core.async.__GT_t_cljs$core$async48208 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async48208(p__$1,ch__$1,meta48209){
return (new cljs.core.async.t_cljs$core$async48208(p__$1,ch__$1,meta48209));
});

}

return (new cljs.core.async.t_cljs$core$async48208(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__48221 = arguments.length;
switch (G__48221) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46308__auto___49925 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_48245){
var state_val_48246 = (state_48245[(1)]);
if((state_val_48246 === (7))){
var inst_48241 = (state_48245[(2)]);
var state_48245__$1 = state_48245;
var statearr_48247_49933 = state_48245__$1;
(statearr_48247_49933[(2)] = inst_48241);

(statearr_48247_49933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48246 === (1))){
var state_48245__$1 = state_48245;
var statearr_48248_49934 = state_48245__$1;
(statearr_48248_49934[(2)] = null);

(statearr_48248_49934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48246 === (4))){
var inst_48227 = (state_48245[(7)]);
var inst_48227__$1 = (state_48245[(2)]);
var inst_48228 = (inst_48227__$1 == null);
var state_48245__$1 = (function (){var statearr_48249 = state_48245;
(statearr_48249[(7)] = inst_48227__$1);

return statearr_48249;
})();
if(cljs.core.truth_(inst_48228)){
var statearr_48250_49941 = state_48245__$1;
(statearr_48250_49941[(1)] = (5));

} else {
var statearr_48258_49942 = state_48245__$1;
(statearr_48258_49942[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48246 === (6))){
var inst_48227 = (state_48245[(7)]);
var inst_48232 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_48227) : p.call(null,inst_48227));
var state_48245__$1 = state_48245;
if(cljs.core.truth_(inst_48232)){
var statearr_48265_49950 = state_48245__$1;
(statearr_48265_49950[(1)] = (8));

} else {
var statearr_48266_49952 = state_48245__$1;
(statearr_48266_49952[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48246 === (3))){
var inst_48243 = (state_48245[(2)]);
var state_48245__$1 = state_48245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48245__$1,inst_48243);
} else {
if((state_val_48246 === (2))){
var state_48245__$1 = state_48245;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48245__$1,(4),ch);
} else {
if((state_val_48246 === (11))){
var inst_48235 = (state_48245[(2)]);
var state_48245__$1 = state_48245;
var statearr_48273_49964 = state_48245__$1;
(statearr_48273_49964[(2)] = inst_48235);

(statearr_48273_49964[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48246 === (9))){
var state_48245__$1 = state_48245;
var statearr_48274_49965 = state_48245__$1;
(statearr_48274_49965[(2)] = null);

(statearr_48274_49965[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48246 === (5))){
var inst_48230 = cljs.core.async.close_BANG_(out);
var state_48245__$1 = state_48245;
var statearr_48275_49970 = state_48245__$1;
(statearr_48275_49970[(2)] = inst_48230);

(statearr_48275_49970[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48246 === (10))){
var inst_48238 = (state_48245[(2)]);
var state_48245__$1 = (function (){var statearr_48280 = state_48245;
(statearr_48280[(8)] = inst_48238);

return statearr_48280;
})();
var statearr_48284_49984 = state_48245__$1;
(statearr_48284_49984[(2)] = null);

(statearr_48284_49984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48246 === (8))){
var inst_48227 = (state_48245[(7)]);
var state_48245__$1 = state_48245;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48245__$1,(11),out,inst_48227);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46108__auto__ = null;
var cljs$core$async$state_machine__46108__auto____0 = (function (){
var statearr_48288 = [null,null,null,null,null,null,null,null,null];
(statearr_48288[(0)] = cljs$core$async$state_machine__46108__auto__);

(statearr_48288[(1)] = (1));

return statearr_48288;
});
var cljs$core$async$state_machine__46108__auto____1 = (function (state_48245){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_48245);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e48289){var ex__46111__auto__ = e48289;
var statearr_48290_49999 = state_48245;
(statearr_48290_49999[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_48245[(4)]))){
var statearr_48294_50000 = state_48245;
(statearr_48294_50000[(1)] = cljs.core.first((state_48245[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50008 = state_48245;
state_48245 = G__50008;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$state_machine__46108__auto__ = function(state_48245){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46108__auto____1.call(this,state_48245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46108__auto____0;
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46108__auto____1;
return cljs$core$async$state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_48295 = f__46309__auto__();
(statearr_48295[(6)] = c__46308__auto___49925);

return statearr_48295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__48297 = arguments.length;
switch (G__48297) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__46308__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_48371){
var state_val_48372 = (state_48371[(1)]);
if((state_val_48372 === (7))){
var inst_48366 = (state_48371[(2)]);
var state_48371__$1 = state_48371;
var statearr_48373_50064 = state_48371__$1;
(statearr_48373_50064[(2)] = inst_48366);

(statearr_48373_50064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (20))){
var inst_48333 = (state_48371[(7)]);
var inst_48347 = (state_48371[(2)]);
var inst_48348 = cljs.core.next(inst_48333);
var inst_48316 = inst_48348;
var inst_48317 = null;
var inst_48318 = (0);
var inst_48319 = (0);
var state_48371__$1 = (function (){var statearr_48374 = state_48371;
(statearr_48374[(8)] = inst_48347);

(statearr_48374[(9)] = inst_48316);

(statearr_48374[(10)] = inst_48318);

(statearr_48374[(11)] = inst_48319);

(statearr_48374[(12)] = inst_48317);

return statearr_48374;
})();
var statearr_48375_50092 = state_48371__$1;
(statearr_48375_50092[(2)] = null);

(statearr_48375_50092[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (1))){
var state_48371__$1 = state_48371;
var statearr_48376_50098 = state_48371__$1;
(statearr_48376_50098[(2)] = null);

(statearr_48376_50098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (4))){
var inst_48304 = (state_48371[(13)]);
var inst_48304__$1 = (state_48371[(2)]);
var inst_48305 = (inst_48304__$1 == null);
var state_48371__$1 = (function (){var statearr_48378 = state_48371;
(statearr_48378[(13)] = inst_48304__$1);

return statearr_48378;
})();
if(cljs.core.truth_(inst_48305)){
var statearr_48380_50122 = state_48371__$1;
(statearr_48380_50122[(1)] = (5));

} else {
var statearr_48381_50127 = state_48371__$1;
(statearr_48381_50127[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (15))){
var state_48371__$1 = state_48371;
var statearr_48385_50132 = state_48371__$1;
(statearr_48385_50132[(2)] = null);

(statearr_48385_50132[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (21))){
var state_48371__$1 = state_48371;
var statearr_48386_50142 = state_48371__$1;
(statearr_48386_50142[(2)] = null);

(statearr_48386_50142[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (13))){
var inst_48316 = (state_48371[(9)]);
var inst_48318 = (state_48371[(10)]);
var inst_48319 = (state_48371[(11)]);
var inst_48317 = (state_48371[(12)]);
var inst_48329 = (state_48371[(2)]);
var inst_48330 = (inst_48319 + (1));
var tmp48382 = inst_48316;
var tmp48383 = inst_48318;
var tmp48384 = inst_48317;
var inst_48316__$1 = tmp48382;
var inst_48317__$1 = tmp48384;
var inst_48318__$1 = tmp48383;
var inst_48319__$1 = inst_48330;
var state_48371__$1 = (function (){var statearr_48392 = state_48371;
(statearr_48392[(9)] = inst_48316__$1);

(statearr_48392[(10)] = inst_48318__$1);

(statearr_48392[(11)] = inst_48319__$1);

(statearr_48392[(12)] = inst_48317__$1);

(statearr_48392[(14)] = inst_48329);

return statearr_48392;
})();
var statearr_48393_50169 = state_48371__$1;
(statearr_48393_50169[(2)] = null);

(statearr_48393_50169[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (22))){
var state_48371__$1 = state_48371;
var statearr_48394_50177 = state_48371__$1;
(statearr_48394_50177[(2)] = null);

(statearr_48394_50177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (6))){
var inst_48304 = (state_48371[(13)]);
var inst_48314 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_48304) : f.call(null,inst_48304));
var inst_48315 = cljs.core.seq(inst_48314);
var inst_48316 = inst_48315;
var inst_48317 = null;
var inst_48318 = (0);
var inst_48319 = (0);
var state_48371__$1 = (function (){var statearr_48395 = state_48371;
(statearr_48395[(9)] = inst_48316);

(statearr_48395[(10)] = inst_48318);

(statearr_48395[(11)] = inst_48319);

(statearr_48395[(12)] = inst_48317);

return statearr_48395;
})();
var statearr_48396_50206 = state_48371__$1;
(statearr_48396_50206[(2)] = null);

(statearr_48396_50206[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (17))){
var inst_48333 = (state_48371[(7)]);
var inst_48339 = cljs.core.chunk_first(inst_48333);
var inst_48340 = cljs.core.chunk_rest(inst_48333);
var inst_48341 = cljs.core.count(inst_48339);
var inst_48316 = inst_48340;
var inst_48317 = inst_48339;
var inst_48318 = inst_48341;
var inst_48319 = (0);
var state_48371__$1 = (function (){var statearr_48397 = state_48371;
(statearr_48397[(9)] = inst_48316);

(statearr_48397[(10)] = inst_48318);

(statearr_48397[(11)] = inst_48319);

(statearr_48397[(12)] = inst_48317);

return statearr_48397;
})();
var statearr_48398_50226 = state_48371__$1;
(statearr_48398_50226[(2)] = null);

(statearr_48398_50226[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (3))){
var inst_48368 = (state_48371[(2)]);
var state_48371__$1 = state_48371;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48371__$1,inst_48368);
} else {
if((state_val_48372 === (12))){
var inst_48356 = (state_48371[(2)]);
var state_48371__$1 = state_48371;
var statearr_48399_50235 = state_48371__$1;
(statearr_48399_50235[(2)] = inst_48356);

(statearr_48399_50235[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (2))){
var state_48371__$1 = state_48371;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48371__$1,(4),in$);
} else {
if((state_val_48372 === (23))){
var inst_48364 = (state_48371[(2)]);
var state_48371__$1 = state_48371;
var statearr_48400_50249 = state_48371__$1;
(statearr_48400_50249[(2)] = inst_48364);

(statearr_48400_50249[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (19))){
var inst_48351 = (state_48371[(2)]);
var state_48371__$1 = state_48371;
var statearr_48401_50256 = state_48371__$1;
(statearr_48401_50256[(2)] = inst_48351);

(statearr_48401_50256[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (11))){
var inst_48316 = (state_48371[(9)]);
var inst_48333 = (state_48371[(7)]);
var inst_48333__$1 = cljs.core.seq(inst_48316);
var state_48371__$1 = (function (){var statearr_48406 = state_48371;
(statearr_48406[(7)] = inst_48333__$1);

return statearr_48406;
})();
if(inst_48333__$1){
var statearr_48408_50263 = state_48371__$1;
(statearr_48408_50263[(1)] = (14));

} else {
var statearr_48409_50265 = state_48371__$1;
(statearr_48409_50265[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (9))){
var inst_48358 = (state_48371[(2)]);
var inst_48359 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_48371__$1 = (function (){var statearr_48412 = state_48371;
(statearr_48412[(15)] = inst_48358);

return statearr_48412;
})();
if(cljs.core.truth_(inst_48359)){
var statearr_48413_50280 = state_48371__$1;
(statearr_48413_50280[(1)] = (21));

} else {
var statearr_48414_50281 = state_48371__$1;
(statearr_48414_50281[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (5))){
var inst_48307 = cljs.core.async.close_BANG_(out);
var state_48371__$1 = state_48371;
var statearr_48416_50282 = state_48371__$1;
(statearr_48416_50282[(2)] = inst_48307);

(statearr_48416_50282[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (14))){
var inst_48333 = (state_48371[(7)]);
var inst_48337 = cljs.core.chunked_seq_QMARK_(inst_48333);
var state_48371__$1 = state_48371;
if(inst_48337){
var statearr_48419_50287 = state_48371__$1;
(statearr_48419_50287[(1)] = (17));

} else {
var statearr_48421_50289 = state_48371__$1;
(statearr_48421_50289[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (16))){
var inst_48354 = (state_48371[(2)]);
var state_48371__$1 = state_48371;
var statearr_48425_50290 = state_48371__$1;
(statearr_48425_50290[(2)] = inst_48354);

(statearr_48425_50290[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (10))){
var inst_48319 = (state_48371[(11)]);
var inst_48317 = (state_48371[(12)]);
var inst_48327 = cljs.core._nth(inst_48317,inst_48319);
var state_48371__$1 = state_48371;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48371__$1,(13),out,inst_48327);
} else {
if((state_val_48372 === (18))){
var inst_48333 = (state_48371[(7)]);
var inst_48345 = cljs.core.first(inst_48333);
var state_48371__$1 = state_48371;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48371__$1,(20),out,inst_48345);
} else {
if((state_val_48372 === (8))){
var inst_48318 = (state_48371[(10)]);
var inst_48319 = (state_48371[(11)]);
var inst_48324 = (inst_48319 < inst_48318);
var inst_48325 = inst_48324;
var state_48371__$1 = state_48371;
if(cljs.core.truth_(inst_48325)){
var statearr_48426_50303 = state_48371__$1;
(statearr_48426_50303[(1)] = (10));

} else {
var statearr_48427_50305 = state_48371__$1;
(statearr_48427_50305[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__46108__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__46108__auto____0 = (function (){
var statearr_48428 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48428[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__46108__auto__);

(statearr_48428[(1)] = (1));

return statearr_48428;
});
var cljs$core$async$mapcat_STAR__$_state_machine__46108__auto____1 = (function (state_48371){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_48371);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e48429){var ex__46111__auto__ = e48429;
var statearr_48430_50312 = state_48371;
(statearr_48430_50312[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_48371[(4)]))){
var statearr_48431_50313 = state_48371;
(statearr_48431_50313[(1)] = cljs.core.first((state_48371[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50318 = state_48371;
state_48371 = G__50318;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__46108__auto__ = function(state_48371){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__46108__auto____1.call(this,state_48371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__46108__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__46108__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_48436 = f__46309__auto__();
(statearr_48436[(6)] = c__46308__auto__);

return statearr_48436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));

return c__46308__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__48442 = arguments.length;
switch (G__48442) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__48444 = arguments.length;
switch (G__48444) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__48448 = arguments.length;
switch (G__48448) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46308__auto___50330 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_48475){
var state_val_48476 = (state_48475[(1)]);
if((state_val_48476 === (7))){
var inst_48470 = (state_48475[(2)]);
var state_48475__$1 = state_48475;
var statearr_48477_50332 = state_48475__$1;
(statearr_48477_50332[(2)] = inst_48470);

(statearr_48477_50332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48476 === (1))){
var inst_48452 = null;
var state_48475__$1 = (function (){var statearr_48478 = state_48475;
(statearr_48478[(7)] = inst_48452);

return statearr_48478;
})();
var statearr_48479_50333 = state_48475__$1;
(statearr_48479_50333[(2)] = null);

(statearr_48479_50333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48476 === (4))){
var inst_48455 = (state_48475[(8)]);
var inst_48455__$1 = (state_48475[(2)]);
var inst_48456 = (inst_48455__$1 == null);
var inst_48457 = cljs.core.not(inst_48456);
var state_48475__$1 = (function (){var statearr_48480 = state_48475;
(statearr_48480[(8)] = inst_48455__$1);

return statearr_48480;
})();
if(inst_48457){
var statearr_48481_50336 = state_48475__$1;
(statearr_48481_50336[(1)] = (5));

} else {
var statearr_48482_50339 = state_48475__$1;
(statearr_48482_50339[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48476 === (6))){
var state_48475__$1 = state_48475;
var statearr_48483_50340 = state_48475__$1;
(statearr_48483_50340[(2)] = null);

(statearr_48483_50340[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48476 === (3))){
var inst_48472 = (state_48475[(2)]);
var inst_48473 = cljs.core.async.close_BANG_(out);
var state_48475__$1 = (function (){var statearr_48484 = state_48475;
(statearr_48484[(9)] = inst_48472);

return statearr_48484;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48475__$1,inst_48473);
} else {
if((state_val_48476 === (2))){
var state_48475__$1 = state_48475;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48475__$1,(4),ch);
} else {
if((state_val_48476 === (11))){
var inst_48455 = (state_48475[(8)]);
var inst_48464 = (state_48475[(2)]);
var inst_48452 = inst_48455;
var state_48475__$1 = (function (){var statearr_48485 = state_48475;
(statearr_48485[(10)] = inst_48464);

(statearr_48485[(7)] = inst_48452);

return statearr_48485;
})();
var statearr_48486_50342 = state_48475__$1;
(statearr_48486_50342[(2)] = null);

(statearr_48486_50342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48476 === (9))){
var inst_48455 = (state_48475[(8)]);
var state_48475__$1 = state_48475;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48475__$1,(11),out,inst_48455);
} else {
if((state_val_48476 === (5))){
var inst_48455 = (state_48475[(8)]);
var inst_48452 = (state_48475[(7)]);
var inst_48459 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48455,inst_48452);
var state_48475__$1 = state_48475;
if(inst_48459){
var statearr_48488_50350 = state_48475__$1;
(statearr_48488_50350[(1)] = (8));

} else {
var statearr_48489_50351 = state_48475__$1;
(statearr_48489_50351[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48476 === (10))){
var inst_48467 = (state_48475[(2)]);
var state_48475__$1 = state_48475;
var statearr_48490_50352 = state_48475__$1;
(statearr_48490_50352[(2)] = inst_48467);

(statearr_48490_50352[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48476 === (8))){
var inst_48452 = (state_48475[(7)]);
var tmp48487 = inst_48452;
var inst_48452__$1 = tmp48487;
var state_48475__$1 = (function (){var statearr_48491 = state_48475;
(statearr_48491[(7)] = inst_48452__$1);

return statearr_48491;
})();
var statearr_48492_50354 = state_48475__$1;
(statearr_48492_50354[(2)] = null);

(statearr_48492_50354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46108__auto__ = null;
var cljs$core$async$state_machine__46108__auto____0 = (function (){
var statearr_48493 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48493[(0)] = cljs$core$async$state_machine__46108__auto__);

(statearr_48493[(1)] = (1));

return statearr_48493;
});
var cljs$core$async$state_machine__46108__auto____1 = (function (state_48475){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_48475);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e48494){var ex__46111__auto__ = e48494;
var statearr_48495_50355 = state_48475;
(statearr_48495_50355[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_48475[(4)]))){
var statearr_48496_50356 = state_48475;
(statearr_48496_50356[(1)] = cljs.core.first((state_48475[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50357 = state_48475;
state_48475 = G__50357;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$state_machine__46108__auto__ = function(state_48475){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46108__auto____1.call(this,state_48475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46108__auto____0;
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46108__auto____1;
return cljs$core$async$state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_48497 = f__46309__auto__();
(statearr_48497[(6)] = c__46308__auto___50330);

return statearr_48497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__48500 = arguments.length;
switch (G__48500) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46308__auto___50360 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_48541){
var state_val_48542 = (state_48541[(1)]);
if((state_val_48542 === (7))){
var inst_48537 = (state_48541[(2)]);
var state_48541__$1 = state_48541;
var statearr_48543_50361 = state_48541__$1;
(statearr_48543_50361[(2)] = inst_48537);

(statearr_48543_50361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48542 === (1))){
var inst_48501 = (new Array(n));
var inst_48502 = inst_48501;
var inst_48503 = (0);
var state_48541__$1 = (function (){var statearr_48544 = state_48541;
(statearr_48544[(7)] = inst_48502);

(statearr_48544[(8)] = inst_48503);

return statearr_48544;
})();
var statearr_48545_50362 = state_48541__$1;
(statearr_48545_50362[(2)] = null);

(statearr_48545_50362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48542 === (4))){
var inst_48506 = (state_48541[(9)]);
var inst_48506__$1 = (state_48541[(2)]);
var inst_48510 = (inst_48506__$1 == null);
var inst_48511 = cljs.core.not(inst_48510);
var state_48541__$1 = (function (){var statearr_48546 = state_48541;
(statearr_48546[(9)] = inst_48506__$1);

return statearr_48546;
})();
if(inst_48511){
var statearr_48547_50363 = state_48541__$1;
(statearr_48547_50363[(1)] = (5));

} else {
var statearr_48548_50364 = state_48541__$1;
(statearr_48548_50364[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48542 === (15))){
var inst_48531 = (state_48541[(2)]);
var state_48541__$1 = state_48541;
var statearr_48549_50365 = state_48541__$1;
(statearr_48549_50365[(2)] = inst_48531);

(statearr_48549_50365[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48542 === (13))){
var state_48541__$1 = state_48541;
var statearr_48550_50380 = state_48541__$1;
(statearr_48550_50380[(2)] = null);

(statearr_48550_50380[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48542 === (6))){
var inst_48503 = (state_48541[(8)]);
var inst_48527 = (inst_48503 > (0));
var state_48541__$1 = state_48541;
if(cljs.core.truth_(inst_48527)){
var statearr_48552_50383 = state_48541__$1;
(statearr_48552_50383[(1)] = (12));

} else {
var statearr_48556_50384 = state_48541__$1;
(statearr_48556_50384[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48542 === (3))){
var inst_48539 = (state_48541[(2)]);
var state_48541__$1 = state_48541;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48541__$1,inst_48539);
} else {
if((state_val_48542 === (12))){
var inst_48502 = (state_48541[(7)]);
var inst_48529 = cljs.core.vec(inst_48502);
var state_48541__$1 = state_48541;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48541__$1,(15),out,inst_48529);
} else {
if((state_val_48542 === (2))){
var state_48541__$1 = state_48541;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48541__$1,(4),ch);
} else {
if((state_val_48542 === (11))){
var inst_48521 = (state_48541[(2)]);
var inst_48522 = (new Array(n));
var inst_48502 = inst_48522;
var inst_48503 = (0);
var state_48541__$1 = (function (){var statearr_48557 = state_48541;
(statearr_48557[(10)] = inst_48521);

(statearr_48557[(7)] = inst_48502);

(statearr_48557[(8)] = inst_48503);

return statearr_48557;
})();
var statearr_48558_50385 = state_48541__$1;
(statearr_48558_50385[(2)] = null);

(statearr_48558_50385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48542 === (9))){
var inst_48502 = (state_48541[(7)]);
var inst_48519 = cljs.core.vec(inst_48502);
var state_48541__$1 = state_48541;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48541__$1,(11),out,inst_48519);
} else {
if((state_val_48542 === (5))){
var inst_48506 = (state_48541[(9)]);
var inst_48502 = (state_48541[(7)]);
var inst_48514 = (state_48541[(11)]);
var inst_48503 = (state_48541[(8)]);
var inst_48513 = (inst_48502[inst_48503] = inst_48506);
var inst_48514__$1 = (inst_48503 + (1));
var inst_48515 = (inst_48514__$1 < n);
var state_48541__$1 = (function (){var statearr_48559 = state_48541;
(statearr_48559[(11)] = inst_48514__$1);

(statearr_48559[(12)] = inst_48513);

return statearr_48559;
})();
if(cljs.core.truth_(inst_48515)){
var statearr_48560_50392 = state_48541__$1;
(statearr_48560_50392[(1)] = (8));

} else {
var statearr_48561_50393 = state_48541__$1;
(statearr_48561_50393[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48542 === (14))){
var inst_48534 = (state_48541[(2)]);
var inst_48535 = cljs.core.async.close_BANG_(out);
var state_48541__$1 = (function (){var statearr_48563 = state_48541;
(statearr_48563[(13)] = inst_48534);

return statearr_48563;
})();
var statearr_48564_50394 = state_48541__$1;
(statearr_48564_50394[(2)] = inst_48535);

(statearr_48564_50394[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48542 === (10))){
var inst_48525 = (state_48541[(2)]);
var state_48541__$1 = state_48541;
var statearr_48565_50396 = state_48541__$1;
(statearr_48565_50396[(2)] = inst_48525);

(statearr_48565_50396[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48542 === (8))){
var inst_48502 = (state_48541[(7)]);
var inst_48514 = (state_48541[(11)]);
var tmp48562 = inst_48502;
var inst_48502__$1 = tmp48562;
var inst_48503 = inst_48514;
var state_48541__$1 = (function (){var statearr_48566 = state_48541;
(statearr_48566[(7)] = inst_48502__$1);

(statearr_48566[(8)] = inst_48503);

return statearr_48566;
})();
var statearr_48567_50397 = state_48541__$1;
(statearr_48567_50397[(2)] = null);

(statearr_48567_50397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46108__auto__ = null;
var cljs$core$async$state_machine__46108__auto____0 = (function (){
var statearr_48568 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48568[(0)] = cljs$core$async$state_machine__46108__auto__);

(statearr_48568[(1)] = (1));

return statearr_48568;
});
var cljs$core$async$state_machine__46108__auto____1 = (function (state_48541){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_48541);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e48569){var ex__46111__auto__ = e48569;
var statearr_48570_50401 = state_48541;
(statearr_48570_50401[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_48541[(4)]))){
var statearr_48571_50402 = state_48541;
(statearr_48571_50402[(1)] = cljs.core.first((state_48541[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50403 = state_48541;
state_48541 = G__50403;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$state_machine__46108__auto__ = function(state_48541){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46108__auto____1.call(this,state_48541);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46108__auto____0;
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46108__auto____1;
return cljs$core$async$state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_48572 = f__46309__auto__();
(statearr_48572[(6)] = c__46308__auto___50360);

return statearr_48572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__48574 = arguments.length;
switch (G__48574) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46308__auto___50411 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_48636){
var state_val_48637 = (state_48636[(1)]);
if((state_val_48637 === (7))){
var inst_48626 = (state_48636[(2)]);
var state_48636__$1 = state_48636;
var statearr_48638_50412 = state_48636__$1;
(statearr_48638_50412[(2)] = inst_48626);

(statearr_48638_50412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (1))){
var inst_48583 = [];
var inst_48584 = inst_48583;
var inst_48585 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_48636__$1 = (function (){var statearr_48639 = state_48636;
(statearr_48639[(7)] = inst_48584);

(statearr_48639[(8)] = inst_48585);

return statearr_48639;
})();
var statearr_48640_50413 = state_48636__$1;
(statearr_48640_50413[(2)] = null);

(statearr_48640_50413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (4))){
var inst_48588 = (state_48636[(9)]);
var inst_48588__$1 = (state_48636[(2)]);
var inst_48589 = (inst_48588__$1 == null);
var inst_48590 = cljs.core.not(inst_48589);
var state_48636__$1 = (function (){var statearr_48647 = state_48636;
(statearr_48647[(9)] = inst_48588__$1);

return statearr_48647;
})();
if(inst_48590){
var statearr_48650_50415 = state_48636__$1;
(statearr_48650_50415[(1)] = (5));

} else {
var statearr_48651_50416 = state_48636__$1;
(statearr_48651_50416[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (15))){
var inst_48620 = (state_48636[(2)]);
var state_48636__$1 = state_48636;
var statearr_48658_50417 = state_48636__$1;
(statearr_48658_50417[(2)] = inst_48620);

(statearr_48658_50417[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (13))){
var state_48636__$1 = state_48636;
var statearr_48659_50418 = state_48636__$1;
(statearr_48659_50418[(2)] = null);

(statearr_48659_50418[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (6))){
var inst_48584 = (state_48636[(7)]);
var inst_48615 = inst_48584.length;
var inst_48616 = (inst_48615 > (0));
var state_48636__$1 = state_48636;
if(cljs.core.truth_(inst_48616)){
var statearr_48666_50421 = state_48636__$1;
(statearr_48666_50421[(1)] = (12));

} else {
var statearr_48667_50423 = state_48636__$1;
(statearr_48667_50423[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (3))){
var inst_48628 = (state_48636[(2)]);
var state_48636__$1 = state_48636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48636__$1,inst_48628);
} else {
if((state_val_48637 === (12))){
var inst_48584 = (state_48636[(7)]);
var inst_48618 = cljs.core.vec(inst_48584);
var state_48636__$1 = state_48636;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48636__$1,(15),out,inst_48618);
} else {
if((state_val_48637 === (2))){
var state_48636__$1 = state_48636;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48636__$1,(4),ch);
} else {
if((state_val_48637 === (11))){
var inst_48588 = (state_48636[(9)]);
var inst_48598 = (state_48636[(10)]);
var inst_48608 = (state_48636[(2)]);
var inst_48609 = [];
var inst_48610 = inst_48609.push(inst_48588);
var inst_48584 = inst_48609;
var inst_48585 = inst_48598;
var state_48636__$1 = (function (){var statearr_48668 = state_48636;
(statearr_48668[(11)] = inst_48610);

(statearr_48668[(12)] = inst_48608);

(statearr_48668[(7)] = inst_48584);

(statearr_48668[(8)] = inst_48585);

return statearr_48668;
})();
var statearr_48671_50430 = state_48636__$1;
(statearr_48671_50430[(2)] = null);

(statearr_48671_50430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (9))){
var inst_48584 = (state_48636[(7)]);
var inst_48606 = cljs.core.vec(inst_48584);
var state_48636__$1 = state_48636;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48636__$1,(11),out,inst_48606);
} else {
if((state_val_48637 === (5))){
var inst_48588 = (state_48636[(9)]);
var inst_48598 = (state_48636[(10)]);
var inst_48585 = (state_48636[(8)]);
var inst_48598__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_48588) : f.call(null,inst_48588));
var inst_48599 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48598__$1,inst_48585);
var inst_48600 = cljs.core.keyword_identical_QMARK_(inst_48585,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_48601 = ((inst_48599) || (inst_48600));
var state_48636__$1 = (function (){var statearr_48672 = state_48636;
(statearr_48672[(10)] = inst_48598__$1);

return statearr_48672;
})();
if(cljs.core.truth_(inst_48601)){
var statearr_48673_50435 = state_48636__$1;
(statearr_48673_50435[(1)] = (8));

} else {
var statearr_48674_50436 = state_48636__$1;
(statearr_48674_50436[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (14))){
var inst_48623 = (state_48636[(2)]);
var inst_48624 = cljs.core.async.close_BANG_(out);
var state_48636__$1 = (function (){var statearr_48677 = state_48636;
(statearr_48677[(13)] = inst_48623);

return statearr_48677;
})();
var statearr_48678_50437 = state_48636__$1;
(statearr_48678_50437[(2)] = inst_48624);

(statearr_48678_50437[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (10))){
var inst_48613 = (state_48636[(2)]);
var state_48636__$1 = state_48636;
var statearr_48679_50441 = state_48636__$1;
(statearr_48679_50441[(2)] = inst_48613);

(statearr_48679_50441[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (8))){
var inst_48588 = (state_48636[(9)]);
var inst_48584 = (state_48636[(7)]);
var inst_48598 = (state_48636[(10)]);
var inst_48603 = inst_48584.push(inst_48588);
var tmp48675 = inst_48584;
var inst_48584__$1 = tmp48675;
var inst_48585 = inst_48598;
var state_48636__$1 = (function (){var statearr_48680 = state_48636;
(statearr_48680[(7)] = inst_48584__$1);

(statearr_48680[(8)] = inst_48585);

(statearr_48680[(14)] = inst_48603);

return statearr_48680;
})();
var statearr_48681_50445 = state_48636__$1;
(statearr_48681_50445[(2)] = null);

(statearr_48681_50445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46108__auto__ = null;
var cljs$core$async$state_machine__46108__auto____0 = (function (){
var statearr_48682 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48682[(0)] = cljs$core$async$state_machine__46108__auto__);

(statearr_48682[(1)] = (1));

return statearr_48682;
});
var cljs$core$async$state_machine__46108__auto____1 = (function (state_48636){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_48636);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e48683){var ex__46111__auto__ = e48683;
var statearr_48684_50449 = state_48636;
(statearr_48684_50449[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_48636[(4)]))){
var statearr_48685_50452 = state_48636;
(statearr_48685_50452[(1)] = cljs.core.first((state_48636[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50453 = state_48636;
state_48636 = G__50453;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
cljs$core$async$state_machine__46108__auto__ = function(state_48636){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46108__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46108__auto____1.call(this,state_48636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46108__auto____0;
cljs$core$async$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46108__auto____1;
return cljs$core$async$state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_48686 = f__46309__auto__();
(statearr_48686[(6)] = c__46308__auto___50411);

return statearr_48686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
