goog.provide('re_frame.fx');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed, other than that
 *   `:db` is guaranteed to be executed first.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__53265 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__53266 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__53266);

try{try{var effects = new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context);
var effects_without_db = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(effects,new cljs.core.Keyword(null,"db","db",993250759));
var temp__5754__auto___53400 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(effects);
if(cljs.core.truth_(temp__5754__auto___53400)){
var new_db_53401 = temp__5754__auto___53400;
var fexpr__53272_53402 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,new cljs.core.Keyword(null,"db","db",993250759),false);
(fexpr__53272_53402.cljs$core$IFn$_invoke$arity$1 ? fexpr__53272_53402.cljs$core$IFn$_invoke$arity$1(new_db_53401) : fexpr__53272_53402.call(null,new_db_53401));
} else {
}

var seq__53274 = cljs.core.seq(effects_without_db);
var chunk__53275 = null;
var count__53276 = (0);
var i__53277 = (0);
while(true){
if((i__53277 < count__53276)){
var vec__53291 = chunk__53275.cljs$core$IIndexed$_nth$arity$2(null,i__53277);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53291,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53291,(1),null);
var temp__5752__auto___53405 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___53405)){
var effect_fn_53406 = temp__5752__auto___53405;
(effect_fn_53406.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53406.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53406.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__53409 = seq__53274;
var G__53410 = chunk__53275;
var G__53411 = count__53276;
var G__53412 = (i__53277 + (1));
seq__53274 = G__53409;
chunk__53275 = G__53410;
count__53276 = G__53411;
i__53277 = G__53412;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__53274);
if(temp__5754__auto__){
var seq__53274__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53274__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__53274__$1);
var G__53413 = cljs.core.chunk_rest(seq__53274__$1);
var G__53414 = c__4591__auto__;
var G__53415 = cljs.core.count(c__4591__auto__);
var G__53416 = (0);
seq__53274 = G__53413;
chunk__53275 = G__53414;
count__53276 = G__53415;
i__53277 = G__53416;
continue;
} else {
var vec__53295 = cljs.core.first(seq__53274__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53295,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53295,(1),null);
var temp__5752__auto___53417 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___53417)){
var effect_fn_53418 = temp__5752__auto___53417;
(effect_fn_53418.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53418.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53418.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__53419 = cljs.core.next(seq__53274__$1);
var G__53420 = null;
var G__53421 = (0);
var G__53422 = (0);
seq__53274 = G__53419;
chunk__53275 = G__53420;
count__53276 = G__53421;
i__53277 = G__53422;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__52946__auto___53423 = re_frame.interop.now();
var duration__52947__auto___53424 = (end__52946__auto___53423 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__52947__auto___53424,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__52946__auto___53423);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__53265);
}} else {
var effects = new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context);
var effects_without_db = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(effects,new cljs.core.Keyword(null,"db","db",993250759));
var temp__5754__auto___53428 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(effects);
if(cljs.core.truth_(temp__5754__auto___53428)){
var new_db_53429 = temp__5754__auto___53428;
var fexpr__53304_53430 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,new cljs.core.Keyword(null,"db","db",993250759),false);
(fexpr__53304_53430.cljs$core$IFn$_invoke$arity$1 ? fexpr__53304_53430.cljs$core$IFn$_invoke$arity$1(new_db_53429) : fexpr__53304_53430.call(null,new_db_53429));
} else {
}

var seq__53305 = cljs.core.seq(effects_without_db);
var chunk__53306 = null;
var count__53307 = (0);
var i__53308 = (0);
while(true){
if((i__53308 < count__53307)){
var vec__53322 = chunk__53306.cljs$core$IIndexed$_nth$arity$2(null,i__53308);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53322,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53322,(1),null);
var temp__5752__auto___53431 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___53431)){
var effect_fn_53432 = temp__5752__auto___53431;
(effect_fn_53432.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53432.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53432.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__53433 = seq__53305;
var G__53434 = chunk__53306;
var G__53435 = count__53307;
var G__53436 = (i__53308 + (1));
seq__53305 = G__53433;
chunk__53306 = G__53434;
count__53307 = G__53435;
i__53308 = G__53436;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__53305);
if(temp__5754__auto__){
var seq__53305__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53305__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__53305__$1);
var G__53437 = cljs.core.chunk_rest(seq__53305__$1);
var G__53438 = c__4591__auto__;
var G__53439 = cljs.core.count(c__4591__auto__);
var G__53440 = (0);
seq__53305 = G__53437;
chunk__53306 = G__53438;
count__53307 = G__53439;
i__53308 = G__53440;
continue;
} else {
var vec__53327 = cljs.core.first(seq__53305__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53327,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53327,(1),null);
var temp__5752__auto___53446 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___53446)){
var effect_fn_53447 = temp__5752__auto___53446;
(effect_fn_53447.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53447.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53447.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__53448 = cljs.core.next(seq__53305__$1);
var G__53449 = null;
var G__53450 = (0);
var G__53451 = (0);
seq__53305 = G__53448;
chunk__53306 = G__53449;
count__53307 = G__53450;
i__53308 = G__53451;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.dispatch_later = (function re_frame$fx$dispatch_later(p__53330){
var map__53331 = p__53330;
var map__53331__$1 = cljs.core.__destructure_map(map__53331);
var effect = map__53331__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53331__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53331__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
return re_frame.interop.set_timeout_BANG_((function (){
return re_frame.router.dispatch(dispatch);
}),ms);
}
});
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
if(cljs.core.map_QMARK_(value)){
return re_frame.fx.dispatch_later(value);
} else {
var seq__53336 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__53337 = null;
var count__53338 = (0);
var i__53339 = (0);
while(true){
if((i__53339 < count__53338)){
var effect = chunk__53337.cljs$core$IIndexed$_nth$arity$2(null,i__53339);
re_frame.fx.dispatch_later(effect);


var G__53457 = seq__53336;
var G__53458 = chunk__53337;
var G__53459 = count__53338;
var G__53460 = (i__53339 + (1));
seq__53336 = G__53457;
chunk__53337 = G__53458;
count__53338 = G__53459;
i__53339 = G__53460;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__53336);
if(temp__5754__auto__){
var seq__53336__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53336__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__53336__$1);
var G__53461 = cljs.core.chunk_rest(seq__53336__$1);
var G__53462 = c__4591__auto__;
var G__53463 = cljs.core.count(c__4591__auto__);
var G__53464 = (0);
seq__53336 = G__53461;
chunk__53337 = G__53462;
count__53338 = G__53463;
i__53339 = G__53464;
continue;
} else {
var effect = cljs.core.first(seq__53336__$1);
re_frame.fx.dispatch_later(effect);


var G__53465 = cljs.core.next(seq__53336__$1);
var G__53466 = null;
var G__53467 = (0);
var G__53468 = (0);
seq__53336 = G__53465;
chunk__53337 = G__53466;
count__53338 = G__53467;
i__53339 = G__53468;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"fx","fx",-1237829572),(function (seq_of_effects){
if((!(cljs.core.sequential_QMARK_(seq_of_effects)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect expects a seq, but was given ",cljs.core.type(seq_of_effects)], 0));
} else {
var seq__53343 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,seq_of_effects));
var chunk__53344 = null;
var count__53345 = (0);
var i__53346 = (0);
while(true){
if((i__53346 < count__53345)){
var vec__53359 = chunk__53344.cljs$core$IIndexed$_nth$arity$2(null,i__53346);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53359,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53359,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"db","db",993250759),effect_key)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect should not contain a :db effect"], 0));
} else {
}

var temp__5752__auto___53472 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___53472)){
var effect_fn_53473 = temp__5752__auto___53472;
(effect_fn_53473.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53473.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53473.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: in \":fx\" effect found ",effect_key," which has no associated handler. Ignoring."], 0));
}


var G__53474 = seq__53343;
var G__53475 = chunk__53344;
var G__53476 = count__53345;
var G__53477 = (i__53346 + (1));
seq__53343 = G__53474;
chunk__53344 = G__53475;
count__53345 = G__53476;
i__53346 = G__53477;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__53343);
if(temp__5754__auto__){
var seq__53343__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53343__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__53343__$1);
var G__53478 = cljs.core.chunk_rest(seq__53343__$1);
var G__53479 = c__4591__auto__;
var G__53480 = cljs.core.count(c__4591__auto__);
var G__53481 = (0);
seq__53343 = G__53478;
chunk__53344 = G__53479;
count__53345 = G__53480;
i__53346 = G__53481;
continue;
} else {
var vec__53365 = cljs.core.first(seq__53343__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53365,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53365,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"db","db",993250759),effect_key)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect should not contain a :db effect"], 0));
} else {
}

var temp__5752__auto___53484 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___53484)){
var effect_fn_53485 = temp__5752__auto___53484;
(effect_fn_53485.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53485.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53485.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: in \":fx\" effect found ",effect_key," which has no associated handler. Ignoring."], 0));
}


var G__53486 = cljs.core.next(seq__53343__$1);
var G__53487 = null;
var G__53488 = (0);
var G__53489 = (0);
seq__53343 = G__53486;
chunk__53344 = G__53487;
count__53345 = G__53488;
i__53346 = G__53489;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__53370 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__53371 = null;
var count__53372 = (0);
var i__53373 = (0);
while(true){
if((i__53373 < count__53372)){
var event = chunk__53371.cljs$core$IIndexed$_nth$arity$2(null,i__53373);
re_frame.router.dispatch(event);


var G__53492 = seq__53370;
var G__53493 = chunk__53371;
var G__53494 = count__53372;
var G__53495 = (i__53373 + (1));
seq__53370 = G__53492;
chunk__53371 = G__53493;
count__53372 = G__53494;
i__53373 = G__53495;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__53370);
if(temp__5754__auto__){
var seq__53370__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53370__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__53370__$1);
var G__53497 = cljs.core.chunk_rest(seq__53370__$1);
var G__53498 = c__4591__auto__;
var G__53499 = cljs.core.count(c__4591__auto__);
var G__53500 = (0);
seq__53370 = G__53497;
chunk__53371 = G__53498;
count__53372 = G__53499;
i__53373 = G__53500;
continue;
} else {
var event = cljs.core.first(seq__53370__$1);
re_frame.router.dispatch(event);


var G__53501 = cljs.core.next(seq__53370__$1);
var G__53502 = null;
var G__53503 = (0);
var G__53504 = (0);
seq__53370 = G__53501;
chunk__53371 = G__53502;
count__53372 = G__53503;
i__53373 = G__53504;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__53382 = cljs.core.seq(value);
var chunk__53383 = null;
var count__53384 = (0);
var i__53385 = (0);
while(true){
if((i__53385 < count__53384)){
var event = chunk__53383.cljs$core$IIndexed$_nth$arity$2(null,i__53385);
clear_event(event);


var G__53507 = seq__53382;
var G__53508 = chunk__53383;
var G__53509 = count__53384;
var G__53510 = (i__53385 + (1));
seq__53382 = G__53507;
chunk__53383 = G__53508;
count__53384 = G__53509;
i__53385 = G__53510;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__53382);
if(temp__5754__auto__){
var seq__53382__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53382__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__53382__$1);
var G__53511 = cljs.core.chunk_rest(seq__53382__$1);
var G__53512 = c__4591__auto__;
var G__53513 = cljs.core.count(c__4591__auto__);
var G__53514 = (0);
seq__53382 = G__53511;
chunk__53383 = G__53512;
count__53384 = G__53513;
i__53385 = G__53514;
continue;
} else {
var event = cljs.core.first(seq__53382__$1);
clear_event(event);


var G__53515 = cljs.core.next(seq__53382__$1);
var G__53516 = null;
var G__53517 = (0);
var G__53518 = (0);
seq__53382 = G__53515;
chunk__53383 = G__53516;
count__53384 = G__53517;
i__53385 = G__53518;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
