goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e55104){var e = e55104;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4777__auto__ = [];
var len__4771__auto___55244 = arguments.length;
var i__4772__auto___55245 = (0);
while(true){
if((i__4772__auto___55245 < len__4771__auto___55244)){
args__4777__auto__.push((arguments[i__4772__auto___55245]));

var G__55246 = (i__4772__auto___55245 + (1));
i__4772__auto___55245 = G__55246;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__55112){
var vec__55113 = p__55112;
var map__55116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55113,(0),null);
var map__55116__$1 = cljs.core.__destructure_map(map__55116);
var opts = map__55116__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55116__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55116__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55116__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55116__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__55117 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4160__auto__ = read_ch;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4160__auto__ = write_ch;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__55117__$1 = cljs.core.__destructure_map(map__55117);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55117__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55117__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__55105_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__55105_SHARP_);
}));

(web_socket.onclose = (function (p1__55106_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__55106_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__46308__auto___55248 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_55194){
var state_val_55195 = (state_55194[(1)]);
if((state_val_55195 === (7))){
var inst_55190 = (state_55194[(2)]);
var state_55194__$1 = state_55194;
var statearr_55199_55249 = state_55194__$1;
(statearr_55199_55249[(2)] = inst_55190);

(statearr_55199_55249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (20))){
var state_55194__$1 = state_55194;
var statearr_55200_55250 = state_55194__$1;
(statearr_55200_55250[(2)] = null);

(statearr_55200_55250[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (1))){
var inst_55119 = false;
var state_55194__$1 = (function (){var statearr_55201 = state_55194;
(statearr_55201[(7)] = inst_55119);

return statearr_55201;
})();
var statearr_55205_55251 = state_55194__$1;
(statearr_55205_55251[(2)] = null);

(statearr_55205_55251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (4))){
var inst_55138 = (state_55194[(8)]);
var inst_55130 = (state_55194[(9)]);
var inst_55136 = (state_55194[(10)]);
var inst_55136__$1 = (state_55194[(2)]);
var inst_55137 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55136__$1,(0),null);
var inst_55138__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55136__$1,(1),null);
var inst_55141 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_55138__$1,inst_55130);
var state_55194__$1 = (function (){var statearr_55206 = state_55194;
(statearr_55206[(8)] = inst_55138__$1);

(statearr_55206[(10)] = inst_55136__$1);

(statearr_55206[(11)] = inst_55137);

return statearr_55206;
})();
if(inst_55141){
var statearr_55207_55254 = state_55194__$1;
(statearr_55207_55254[(1)] = (5));

} else {
var statearr_55208_55255 = state_55194__$1;
(statearr_55208_55255[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (15))){
var inst_55175 = (state_55194[(2)]);
var state_55194__$1 = state_55194;
var statearr_55209_55259 = state_55194__$1;
(statearr_55209_55259[(2)] = inst_55175);

(statearr_55209_55259[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (21))){
var inst_55186 = (state_55194[(2)]);
var state_55194__$1 = state_55194;
var statearr_55210_55260 = state_55194__$1;
(statearr_55210_55260[(2)] = inst_55186);

(statearr_55210_55260[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (13))){
var state_55194__$1 = state_55194;
var statearr_55212_55261 = state_55194__$1;
(statearr_55212_55261[(2)] = null);

(statearr_55212_55261[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (6))){
var inst_55131 = (state_55194[(12)]);
var inst_55138 = (state_55194[(8)]);
var inst_55157 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_55138,inst_55131);
var state_55194__$1 = state_55194;
if(inst_55157){
var statearr_55213_55262 = state_55194__$1;
(statearr_55213_55262[(1)] = (9));

} else {
var statearr_55214_55263 = state_55194__$1;
(statearr_55214_55263[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (17))){
var state_55194__$1 = state_55194;
var statearr_55215_55264 = state_55194__$1;
(statearr_55215_55264[(2)] = initial_ch);

(statearr_55215_55264[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (3))){
var inst_55192 = (state_55194[(2)]);
var state_55194__$1 = state_55194;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55194__$1,inst_55192);
} else {
if((state_val_55195 === (12))){
var inst_55119 = (state_55194[(7)]);
var state_55194__$1 = state_55194;
if(cljs.core.truth_(inst_55119)){
var statearr_55216_55265 = state_55194__$1;
(statearr_55216_55265[(1)] = (16));

} else {
var statearr_55218_55266 = state_55194__$1;
(statearr_55218_55266[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (2))){
var inst_55131 = (state_55194[(12)]);
var inst_55130 = (state_55194[(9)]);
var inst_55130__$1 = open_ch;
var inst_55131__$1 = close_ch;
var inst_55132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55133 = [inst_55130__$1,inst_55131__$1];
var inst_55134 = (new cljs.core.PersistentVector(null,2,(5),inst_55132,inst_55133,null));
var state_55194__$1 = (function (){var statearr_55222 = state_55194;
(statearr_55222[(12)] = inst_55131__$1);

(statearr_55222[(9)] = inst_55130__$1);

return statearr_55222;
})();
return cljs.core.async.ioc_alts_BANG_(state_55194__$1,(4),inst_55134);
} else {
if((state_val_55195 === (19))){
var inst_55137 = (state_55194[(11)]);
var state_55194__$1 = state_55194;
var statearr_55223_55267 = state_55194__$1;
(statearr_55223_55267[(2)] = inst_55137);

(statearr_55223_55267[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (11))){
var inst_55188 = (state_55194[(2)]);
var state_55194__$1 = state_55194;
var statearr_55224_55268 = state_55194__$1;
(statearr_55224_55268[(2)] = inst_55188);

(statearr_55224_55268[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (9))){
var inst_55136 = (state_55194[(10)]);
var inst_55165 = (state_55194[(13)]);
var inst_55164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55136,(0),null);
var inst_55165__$1 = chord.client.close_event__GT_maybe_error(inst_55164);
var state_55194__$1 = (function (){var statearr_55225 = state_55194;
(statearr_55225[(13)] = inst_55165__$1);

return statearr_55225;
})();
if(cljs.core.truth_(inst_55165__$1)){
var statearr_55226_55273 = state_55194__$1;
(statearr_55226_55273[(1)] = (12));

} else {
var statearr_55227_55274 = state_55194__$1;
(statearr_55227_55274[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (5))){
var inst_55136 = (state_55194[(10)]);
var inst_55146 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55136,(0),null);
var inst_55147 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_55150 = [ws_chan];
var inst_55151 = cljs.core.PersistentHashMap.fromArrays(inst_55147,inst_55150);
var state_55194__$1 = (function (){var statearr_55228 = state_55194;
(statearr_55228[(14)] = inst_55146);

return statearr_55228;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_55194__$1,(8),initial_ch,inst_55151);
} else {
if((state_val_55195 === (14))){
var inst_55178 = (state_55194[(2)]);
var inst_55179 = cljs.core.async.close_BANG_(ws_chan);
var inst_55180 = cljs.core.async.close_BANG_(initial_ch);
var state_55194__$1 = (function (){var statearr_55229 = state_55194;
(statearr_55229[(15)] = inst_55179);

(statearr_55229[(16)] = inst_55178);

return statearr_55229;
})();
var statearr_55230_55275 = state_55194__$1;
(statearr_55230_55275[(2)] = inst_55180);

(statearr_55230_55275[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (16))){
var state_55194__$1 = state_55194;
var statearr_55231_55276 = state_55194__$1;
(statearr_55231_55276[(2)] = read_ch__$1);

(statearr_55231_55276[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (10))){
var inst_55138 = (state_55194[(8)]);
var inst_55182 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_55138,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_55194__$1 = state_55194;
if(inst_55182){
var statearr_55234_55278 = state_55194__$1;
(statearr_55234_55278[(1)] = (19));

} else {
var statearr_55235_55279 = state_55194__$1;
(statearr_55235_55279[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55195 === (18))){
var inst_55165 = (state_55194[(13)]);
var inst_55170 = (state_55194[(2)]);
var inst_55171 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_55172 = [inst_55165];
var inst_55173 = cljs.core.PersistentHashMap.fromArrays(inst_55171,inst_55172);
var state_55194__$1 = state_55194;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_55194__$1,(15),inst_55170,inst_55173);
} else {
if((state_val_55195 === (8))){
var inst_55153 = (state_55194[(2)]);
var inst_55154 = cljs.core.async.close_BANG_(initial_ch);
var inst_55119 = true;
var state_55194__$1 = (function (){var statearr_55236 = state_55194;
(statearr_55236[(17)] = inst_55153);

(statearr_55236[(18)] = inst_55154);

(statearr_55236[(7)] = inst_55119);

return statearr_55236;
})();
var statearr_55237_55287 = state_55194__$1;
(statearr_55237_55287[(2)] = null);

(statearr_55237_55287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__46108__auto__ = null;
var chord$client$state_machine__46108__auto____0 = (function (){
var statearr_55238 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55238[(0)] = chord$client$state_machine__46108__auto__);

(statearr_55238[(1)] = (1));

return statearr_55238;
});
var chord$client$state_machine__46108__auto____1 = (function (state_55194){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_55194);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e55240){var ex__46111__auto__ = e55240;
var statearr_55241_55292 = state_55194;
(statearr_55241_55292[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_55194[(4)]))){
var statearr_55242_55295 = state_55194;
(statearr_55242_55295[(1)] = cljs.core.first((state_55194[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55296 = state_55194;
state_55194 = G__55296;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
chord$client$state_machine__46108__auto__ = function(state_55194){
switch(arguments.length){
case 0:
return chord$client$state_machine__46108__auto____0.call(this);
case 1:
return chord$client$state_machine__46108__auto____1.call(this,state_55194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__46108__auto____0;
chord$client$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__46108__auto____1;
return chord$client$state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_55243 = f__46309__auto__();
(statearr_55243[(6)] = c__46308__auto___55248);

return statearr_55243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq55107){
var G__55108 = cljs.core.first(seq55107);
var seq55107__$1 = cljs.core.next(seq55107);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55108,seq55107__$1);
}));


//# sourceMappingURL=chord.client.js.map
