goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_49451 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_49451(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_49456 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_49456(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__48718 = coll;
var G__48719 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__48718,G__48719) : shadow.dom.lazy_native_coll_seq.call(null,G__48718,G__48719));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4160__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__48731 = arguments.length;
switch (G__48731) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__48739 = arguments.length;
switch (G__48739) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__48742 = arguments.length;
switch (G__48742) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__48749 = arguments.length;
switch (G__48749) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__48760 = arguments.length;
switch (G__48760) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__48766 = arguments.length;
switch (G__48766) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4160__auto__ = (!((typeof document !== 'undefined')));
if(or__4160__auto__){
return or__4160__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e48773){if((e48773 instanceof Object)){
var e = e48773;
return console.log("didnt support attachEvent",el,e);
} else {
throw e48773;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4160__auto__ = (!((typeof document !== 'undefined')));
if(or__4160__auto__){
return or__4160__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__48784 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__48785 = null;
var count__48786 = (0);
var i__48787 = (0);
while(true){
if((i__48787 < count__48786)){
var el = chunk__48785.cljs$core$IIndexed$_nth$arity$2(null,i__48787);
var handler_49500__$1 = ((function (seq__48784,chunk__48785,count__48786,i__48787,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__48784,chunk__48785,count__48786,i__48787,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49500__$1);


var G__49501 = seq__48784;
var G__49502 = chunk__48785;
var G__49503 = count__48786;
var G__49504 = (i__48787 + (1));
seq__48784 = G__49501;
chunk__48785 = G__49502;
count__48786 = G__49503;
i__48787 = G__49504;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__48784);
if(temp__5754__auto__){
var seq__48784__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48784__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__48784__$1);
var G__49506 = cljs.core.chunk_rest(seq__48784__$1);
var G__49507 = c__4591__auto__;
var G__49508 = cljs.core.count(c__4591__auto__);
var G__49509 = (0);
seq__48784 = G__49506;
chunk__48785 = G__49507;
count__48786 = G__49508;
i__48787 = G__49509;
continue;
} else {
var el = cljs.core.first(seq__48784__$1);
var handler_49510__$1 = ((function (seq__48784,chunk__48785,count__48786,i__48787,el,seq__48784__$1,temp__5754__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__48784,chunk__48785,count__48786,i__48787,el,seq__48784__$1,temp__5754__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49510__$1);


var G__49512 = cljs.core.next(seq__48784__$1);
var G__49513 = null;
var G__49514 = (0);
var G__49515 = (0);
seq__48784 = G__49512;
chunk__48785 = G__49513;
count__48786 = G__49514;
i__48787 = G__49515;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__48802 = arguments.length;
switch (G__48802) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__48808 = cljs.core.seq(events);
var chunk__48809 = null;
var count__48810 = (0);
var i__48811 = (0);
while(true){
if((i__48811 < count__48810)){
var vec__48823 = chunk__48809.cljs$core$IIndexed$_nth$arity$2(null,i__48811);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48823,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48823,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49527 = seq__48808;
var G__49528 = chunk__48809;
var G__49529 = count__48810;
var G__49530 = (i__48811 + (1));
seq__48808 = G__49527;
chunk__48809 = G__49528;
count__48810 = G__49529;
i__48811 = G__49530;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__48808);
if(temp__5754__auto__){
var seq__48808__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48808__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__48808__$1);
var G__49531 = cljs.core.chunk_rest(seq__48808__$1);
var G__49532 = c__4591__auto__;
var G__49533 = cljs.core.count(c__4591__auto__);
var G__49534 = (0);
seq__48808 = G__49531;
chunk__48809 = G__49532;
count__48810 = G__49533;
i__48811 = G__49534;
continue;
} else {
var vec__48828 = cljs.core.first(seq__48808__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48828,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48828,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49535 = cljs.core.next(seq__48808__$1);
var G__49536 = null;
var G__49537 = (0);
var G__49538 = (0);
seq__48808 = G__49535;
chunk__48809 = G__49536;
count__48810 = G__49537;
i__48811 = G__49538;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__48833 = cljs.core.seq(styles);
var chunk__48834 = null;
var count__48835 = (0);
var i__48836 = (0);
while(true){
if((i__48836 < count__48835)){
var vec__48848 = chunk__48834.cljs$core$IIndexed$_nth$arity$2(null,i__48836);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48848,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48848,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49541 = seq__48833;
var G__49542 = chunk__48834;
var G__49543 = count__48835;
var G__49544 = (i__48836 + (1));
seq__48833 = G__49541;
chunk__48834 = G__49542;
count__48835 = G__49543;
i__48836 = G__49544;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__48833);
if(temp__5754__auto__){
var seq__48833__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48833__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__48833__$1);
var G__49545 = cljs.core.chunk_rest(seq__48833__$1);
var G__49546 = c__4591__auto__;
var G__49547 = cljs.core.count(c__4591__auto__);
var G__49548 = (0);
seq__48833 = G__49545;
chunk__48834 = G__49546;
count__48835 = G__49547;
i__48836 = G__49548;
continue;
} else {
var vec__48851 = cljs.core.first(seq__48833__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48851,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48851,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49551 = cljs.core.next(seq__48833__$1);
var G__49552 = null;
var G__49553 = (0);
var G__49554 = (0);
seq__48833 = G__49551;
chunk__48834 = G__49552;
count__48835 = G__49553;
i__48836 = G__49554;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__48864_49555 = key;
var G__48864_49556__$1 = (((G__48864_49555 instanceof cljs.core.Keyword))?G__48864_49555.fqn:null);
switch (G__48864_49556__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_49561 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4160__auto__ = goog.string.startsWith(ks_49561,"data-");
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return goog.string.startsWith(ks_49561,"aria-");
}
})())){
el.setAttribute(ks_49561,value);
} else {
(el[ks_49561] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__48916){
var map__48917 = p__48916;
var map__48917__$1 = cljs.core.__destructure_map(map__48917);
var props = map__48917__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48917__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__48919 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48919,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48919,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48919,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__48923 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__48923,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__48923;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__48929 = arguments.length;
switch (G__48929) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5754__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5754__auto__)){
var n = temp__5754__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5754__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5754__auto__)){
var n = temp__5754__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__48933){
var vec__48934 = p__48933;
var seq__48935 = cljs.core.seq(vec__48934);
var first__48936 = cljs.core.first(seq__48935);
var seq__48935__$1 = cljs.core.next(seq__48935);
var nn = first__48936;
var first__48936__$1 = cljs.core.first(seq__48935__$1);
var seq__48935__$2 = cljs.core.next(seq__48935__$1);
var np = first__48936__$1;
var nc = seq__48935__$2;
var node = vec__48934;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__48937 = nn;
var G__48938 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__48937,G__48938) : create_fn.call(null,G__48937,G__48938));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__48939 = nn;
var G__48940 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__48939,G__48940) : create_fn.call(null,G__48939,G__48940));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__48942 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48942,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48942,(1),null);
var seq__48945_49574 = cljs.core.seq(node_children);
var chunk__48946_49575 = null;
var count__48947_49576 = (0);
var i__48948_49577 = (0);
while(true){
if((i__48948_49577 < count__48947_49576)){
var child_struct_49580 = chunk__48946_49575.cljs$core$IIndexed$_nth$arity$2(null,i__48948_49577);
var children_49581 = shadow.dom.dom_node(child_struct_49580);
if(cljs.core.seq_QMARK_(children_49581)){
var seq__48972_49583 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49581));
var chunk__48974_49584 = null;
var count__48975_49585 = (0);
var i__48976_49586 = (0);
while(true){
if((i__48976_49586 < count__48975_49585)){
var child_49587 = chunk__48974_49584.cljs$core$IIndexed$_nth$arity$2(null,i__48976_49586);
if(cljs.core.truth_(child_49587)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49587);


var G__49589 = seq__48972_49583;
var G__49590 = chunk__48974_49584;
var G__49591 = count__48975_49585;
var G__49592 = (i__48976_49586 + (1));
seq__48972_49583 = G__49589;
chunk__48974_49584 = G__49590;
count__48975_49585 = G__49591;
i__48976_49586 = G__49592;
continue;
} else {
var G__49594 = seq__48972_49583;
var G__49595 = chunk__48974_49584;
var G__49596 = count__48975_49585;
var G__49597 = (i__48976_49586 + (1));
seq__48972_49583 = G__49594;
chunk__48974_49584 = G__49595;
count__48975_49585 = G__49596;
i__48976_49586 = G__49597;
continue;
}
} else {
var temp__5754__auto___49600 = cljs.core.seq(seq__48972_49583);
if(temp__5754__auto___49600){
var seq__48972_49603__$1 = temp__5754__auto___49600;
if(cljs.core.chunked_seq_QMARK_(seq__48972_49603__$1)){
var c__4591__auto___49605 = cljs.core.chunk_first(seq__48972_49603__$1);
var G__49607 = cljs.core.chunk_rest(seq__48972_49603__$1);
var G__49608 = c__4591__auto___49605;
var G__49609 = cljs.core.count(c__4591__auto___49605);
var G__49610 = (0);
seq__48972_49583 = G__49607;
chunk__48974_49584 = G__49608;
count__48975_49585 = G__49609;
i__48976_49586 = G__49610;
continue;
} else {
var child_49611 = cljs.core.first(seq__48972_49603__$1);
if(cljs.core.truth_(child_49611)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49611);


var G__49612 = cljs.core.next(seq__48972_49603__$1);
var G__49613 = null;
var G__49614 = (0);
var G__49615 = (0);
seq__48972_49583 = G__49612;
chunk__48974_49584 = G__49613;
count__48975_49585 = G__49614;
i__48976_49586 = G__49615;
continue;
} else {
var G__49616 = cljs.core.next(seq__48972_49603__$1);
var G__49617 = null;
var G__49618 = (0);
var G__49619 = (0);
seq__48972_49583 = G__49616;
chunk__48974_49584 = G__49617;
count__48975_49585 = G__49618;
i__48976_49586 = G__49619;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49581);
}


var G__49620 = seq__48945_49574;
var G__49621 = chunk__48946_49575;
var G__49622 = count__48947_49576;
var G__49623 = (i__48948_49577 + (1));
seq__48945_49574 = G__49620;
chunk__48946_49575 = G__49621;
count__48947_49576 = G__49622;
i__48948_49577 = G__49623;
continue;
} else {
var temp__5754__auto___49624 = cljs.core.seq(seq__48945_49574);
if(temp__5754__auto___49624){
var seq__48945_49625__$1 = temp__5754__auto___49624;
if(cljs.core.chunked_seq_QMARK_(seq__48945_49625__$1)){
var c__4591__auto___49626 = cljs.core.chunk_first(seq__48945_49625__$1);
var G__49627 = cljs.core.chunk_rest(seq__48945_49625__$1);
var G__49628 = c__4591__auto___49626;
var G__49629 = cljs.core.count(c__4591__auto___49626);
var G__49630 = (0);
seq__48945_49574 = G__49627;
chunk__48946_49575 = G__49628;
count__48947_49576 = G__49629;
i__48948_49577 = G__49630;
continue;
} else {
var child_struct_49633 = cljs.core.first(seq__48945_49625__$1);
var children_49634 = shadow.dom.dom_node(child_struct_49633);
if(cljs.core.seq_QMARK_(children_49634)){
var seq__48985_49636 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49634));
var chunk__48987_49637 = null;
var count__48988_49638 = (0);
var i__48989_49639 = (0);
while(true){
if((i__48989_49639 < count__48988_49638)){
var child_49640 = chunk__48987_49637.cljs$core$IIndexed$_nth$arity$2(null,i__48989_49639);
if(cljs.core.truth_(child_49640)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49640);


var G__49642 = seq__48985_49636;
var G__49643 = chunk__48987_49637;
var G__49644 = count__48988_49638;
var G__49645 = (i__48989_49639 + (1));
seq__48985_49636 = G__49642;
chunk__48987_49637 = G__49643;
count__48988_49638 = G__49644;
i__48989_49639 = G__49645;
continue;
} else {
var G__49646 = seq__48985_49636;
var G__49647 = chunk__48987_49637;
var G__49648 = count__48988_49638;
var G__49649 = (i__48989_49639 + (1));
seq__48985_49636 = G__49646;
chunk__48987_49637 = G__49647;
count__48988_49638 = G__49648;
i__48989_49639 = G__49649;
continue;
}
} else {
var temp__5754__auto___49650__$1 = cljs.core.seq(seq__48985_49636);
if(temp__5754__auto___49650__$1){
var seq__48985_49651__$1 = temp__5754__auto___49650__$1;
if(cljs.core.chunked_seq_QMARK_(seq__48985_49651__$1)){
var c__4591__auto___49652 = cljs.core.chunk_first(seq__48985_49651__$1);
var G__49653 = cljs.core.chunk_rest(seq__48985_49651__$1);
var G__49654 = c__4591__auto___49652;
var G__49655 = cljs.core.count(c__4591__auto___49652);
var G__49656 = (0);
seq__48985_49636 = G__49653;
chunk__48987_49637 = G__49654;
count__48988_49638 = G__49655;
i__48989_49639 = G__49656;
continue;
} else {
var child_49658 = cljs.core.first(seq__48985_49651__$1);
if(cljs.core.truth_(child_49658)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49658);


var G__49660 = cljs.core.next(seq__48985_49651__$1);
var G__49661 = null;
var G__49662 = (0);
var G__49663 = (0);
seq__48985_49636 = G__49660;
chunk__48987_49637 = G__49661;
count__48988_49638 = G__49662;
i__48989_49639 = G__49663;
continue;
} else {
var G__49665 = cljs.core.next(seq__48985_49651__$1);
var G__49666 = null;
var G__49667 = (0);
var G__49668 = (0);
seq__48985_49636 = G__49665;
chunk__48987_49637 = G__49666;
count__48988_49638 = G__49667;
i__48989_49639 = G__49668;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49634);
}


var G__49669 = cljs.core.next(seq__48945_49625__$1);
var G__49670 = null;
var G__49671 = (0);
var G__49672 = (0);
seq__48945_49574 = G__49669;
chunk__48946_49575 = G__49670;
count__48947_49576 = G__49671;
i__48948_49577 = G__49672;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__49013 = cljs.core.seq(node);
var chunk__49014 = null;
var count__49015 = (0);
var i__49016 = (0);
while(true){
if((i__49016 < count__49015)){
var n = chunk__49014.cljs$core$IIndexed$_nth$arity$2(null,i__49016);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__49680 = seq__49013;
var G__49681 = chunk__49014;
var G__49682 = count__49015;
var G__49683 = (i__49016 + (1));
seq__49013 = G__49680;
chunk__49014 = G__49681;
count__49015 = G__49682;
i__49016 = G__49683;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__49013);
if(temp__5754__auto__){
var seq__49013__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49013__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__49013__$1);
var G__49684 = cljs.core.chunk_rest(seq__49013__$1);
var G__49685 = c__4591__auto__;
var G__49686 = cljs.core.count(c__4591__auto__);
var G__49687 = (0);
seq__49013 = G__49684;
chunk__49014 = G__49685;
count__49015 = G__49686;
i__49016 = G__49687;
continue;
} else {
var n = cljs.core.first(seq__49013__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__49688 = cljs.core.next(seq__49013__$1);
var G__49689 = null;
var G__49690 = (0);
var G__49691 = (0);
seq__49013 = G__49688;
chunk__49014 = G__49689;
count__49015 = G__49690;
i__49016 = G__49691;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__49022 = arguments.length;
switch (G__49022) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__49027 = arguments.length;
switch (G__49027) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__49032 = arguments.length;
switch (G__49032) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4160__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4777__auto__ = [];
var len__4771__auto___49715 = arguments.length;
var i__4772__auto___49716 = (0);
while(true){
if((i__4772__auto___49716 < len__4771__auto___49715)){
args__4777__auto__.push((arguments[i__4772__auto___49716]));

var G__49717 = (i__4772__auto___49716 + (1));
i__4772__auto___49716 = G__49717;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__49050_49723 = cljs.core.seq(nodes);
var chunk__49051_49724 = null;
var count__49052_49725 = (0);
var i__49053_49726 = (0);
while(true){
if((i__49053_49726 < count__49052_49725)){
var node_49727 = chunk__49051_49724.cljs$core$IIndexed$_nth$arity$2(null,i__49053_49726);
fragment.appendChild(shadow.dom._to_dom(node_49727));


var G__49729 = seq__49050_49723;
var G__49730 = chunk__49051_49724;
var G__49731 = count__49052_49725;
var G__49732 = (i__49053_49726 + (1));
seq__49050_49723 = G__49729;
chunk__49051_49724 = G__49730;
count__49052_49725 = G__49731;
i__49053_49726 = G__49732;
continue;
} else {
var temp__5754__auto___49734 = cljs.core.seq(seq__49050_49723);
if(temp__5754__auto___49734){
var seq__49050_49736__$1 = temp__5754__auto___49734;
if(cljs.core.chunked_seq_QMARK_(seq__49050_49736__$1)){
var c__4591__auto___49737 = cljs.core.chunk_first(seq__49050_49736__$1);
var G__49738 = cljs.core.chunk_rest(seq__49050_49736__$1);
var G__49739 = c__4591__auto___49737;
var G__49740 = cljs.core.count(c__4591__auto___49737);
var G__49741 = (0);
seq__49050_49723 = G__49738;
chunk__49051_49724 = G__49739;
count__49052_49725 = G__49740;
i__49053_49726 = G__49741;
continue;
} else {
var node_49742 = cljs.core.first(seq__49050_49736__$1);
fragment.appendChild(shadow.dom._to_dom(node_49742));


var G__49744 = cljs.core.next(seq__49050_49736__$1);
var G__49745 = null;
var G__49746 = (0);
var G__49747 = (0);
seq__49050_49723 = G__49744;
chunk__49051_49724 = G__49745;
count__49052_49725 = G__49746;
i__49053_49726 = G__49747;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq49039){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq49039));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__49061_49750 = cljs.core.seq(scripts);
var chunk__49062_49751 = null;
var count__49063_49752 = (0);
var i__49064_49753 = (0);
while(true){
if((i__49064_49753 < count__49063_49752)){
var vec__49075_49755 = chunk__49062_49751.cljs$core$IIndexed$_nth$arity$2(null,i__49064_49753);
var script_tag_49756 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49075_49755,(0),null);
var script_body_49757 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49075_49755,(1),null);
eval(script_body_49757);


var G__49758 = seq__49061_49750;
var G__49759 = chunk__49062_49751;
var G__49760 = count__49063_49752;
var G__49761 = (i__49064_49753 + (1));
seq__49061_49750 = G__49758;
chunk__49062_49751 = G__49759;
count__49063_49752 = G__49760;
i__49064_49753 = G__49761;
continue;
} else {
var temp__5754__auto___49767 = cljs.core.seq(seq__49061_49750);
if(temp__5754__auto___49767){
var seq__49061_49768__$1 = temp__5754__auto___49767;
if(cljs.core.chunked_seq_QMARK_(seq__49061_49768__$1)){
var c__4591__auto___49769 = cljs.core.chunk_first(seq__49061_49768__$1);
var G__49771 = cljs.core.chunk_rest(seq__49061_49768__$1);
var G__49772 = c__4591__auto___49769;
var G__49773 = cljs.core.count(c__4591__auto___49769);
var G__49774 = (0);
seq__49061_49750 = G__49771;
chunk__49062_49751 = G__49772;
count__49063_49752 = G__49773;
i__49064_49753 = G__49774;
continue;
} else {
var vec__49079_49775 = cljs.core.first(seq__49061_49768__$1);
var script_tag_49776 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49079_49775,(0),null);
var script_body_49777 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49079_49775,(1),null);
eval(script_body_49777);


var G__49779 = cljs.core.next(seq__49061_49768__$1);
var G__49780 = null;
var G__49781 = (0);
var G__49782 = (0);
seq__49061_49750 = G__49779;
chunk__49062_49751 = G__49780;
count__49063_49752 = G__49781;
i__49064_49753 = G__49782;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__49082){
var vec__49083 = p__49082;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49083,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49083,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__49099 = arguments.length;
switch (G__49099) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__49114 = cljs.core.seq(style_keys);
var chunk__49115 = null;
var count__49116 = (0);
var i__49117 = (0);
while(true){
if((i__49117 < count__49116)){
var it = chunk__49115.cljs$core$IIndexed$_nth$arity$2(null,i__49117);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__49805 = seq__49114;
var G__49806 = chunk__49115;
var G__49807 = count__49116;
var G__49808 = (i__49117 + (1));
seq__49114 = G__49805;
chunk__49115 = G__49806;
count__49116 = G__49807;
i__49117 = G__49808;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__49114);
if(temp__5754__auto__){
var seq__49114__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49114__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__49114__$1);
var G__49812 = cljs.core.chunk_rest(seq__49114__$1);
var G__49813 = c__4591__auto__;
var G__49814 = cljs.core.count(c__4591__auto__);
var G__49815 = (0);
seq__49114 = G__49812;
chunk__49115 = G__49813;
count__49116 = G__49814;
i__49117 = G__49815;
continue;
} else {
var it = cljs.core.first(seq__49114__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__49816 = cljs.core.next(seq__49114__$1);
var G__49817 = null;
var G__49818 = (0);
var G__49819 = (0);
seq__49114 = G__49816;
chunk__49115 = G__49817;
count__49116 = G__49818;
i__49117 = G__49819;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k49121,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__49133 = k49121;
var G__49133__$1 = (((G__49133 instanceof cljs.core.Keyword))?G__49133.fqn:null);
switch (G__49133__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49121,else__4418__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__49134){
var vec__49135 = p__49134;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49135,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49135,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49120){
var self__ = this;
var G__49120__$1 = this;
return (new cljs.core.RecordIter((0),G__49120__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (coll__4412__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
})(this__4411__auto____$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49122,other49123){
var self__ = this;
var this49122__$1 = this;
return (((!((other49123 == null)))) && ((this49122__$1.constructor === other49123.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49122__$1.x,other49123.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49122__$1.y,other49123.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49122__$1.__extmap,other49123.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__49120){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__49161 = cljs.core.keyword_identical_QMARK_;
var expr__49162 = k__4423__auto__;
if(cljs.core.truth_((pred__49161.cljs$core$IFn$_invoke$arity$2 ? pred__49161.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__49162) : pred__49161.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__49162)))){
return (new shadow.dom.Coordinate(G__49120,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__49161.cljs$core$IFn$_invoke$arity$2 ? pred__49161.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__49162) : pred__49161.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__49162)))){
return (new shadow.dom.Coordinate(self__.x,G__49120,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__49120),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__49120){
var self__ = this;
var this__4414__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__49120,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4421__auto__,(0)),cljs.core._nth(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__49124){
var extmap__4454__auto__ = (function (){var G__49176 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49124,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__49124)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49176);
} else {
return G__49176;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__49124),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__49124),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k49187,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__49192 = k49187;
var G__49192__$1 = (((G__49192 instanceof cljs.core.Keyword))?G__49192.fqn:null);
switch (G__49192__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49187,else__4418__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__49195){
var vec__49197 = p__49195;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49197,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49197,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#shadow.dom.Size{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49186){
var self__ = this;
var G__49186__$1 = this;
return (new cljs.core.RecordIter((0),G__49186__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (coll__4412__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
})(this__4411__auto____$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49188,other49189){
var self__ = this;
var this49188__$1 = this;
return (((!((other49189 == null)))) && ((this49188__$1.constructor === other49189.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49188__$1.w,other49189.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49188__$1.h,other49189.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49188__$1.__extmap,other49189.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__49186){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__49216 = cljs.core.keyword_identical_QMARK_;
var expr__49217 = k__4423__auto__;
if(cljs.core.truth_((pred__49216.cljs$core$IFn$_invoke$arity$2 ? pred__49216.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__49217) : pred__49216.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__49217)))){
return (new shadow.dom.Size(G__49186,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__49216.cljs$core$IFn$_invoke$arity$2 ? pred__49216.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__49217) : pred__49216.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__49217)))){
return (new shadow.dom.Size(self__.w,G__49186,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__49186),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__49186){
var self__ = this;
var this__4414__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__49186,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4421__auto__,(0)),cljs.core._nth(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__49190){
var extmap__4454__auto__ = (function (){var G__49225 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49190,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__49190)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49225);
} else {
return G__49225;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__49190),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__49190),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4645__auto__ = opts;
var l__4646__auto__ = a__4645__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4646__auto__)){
var G__49938 = (i + (1));
var G__49939 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__49938;
ret = G__49939;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__49244){
var vec__49246 = p__49244;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49246,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49246,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__49253 = arguments.length;
switch (G__49253) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5752__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5752__auto__)){
var child = temp__5752__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__49997 = ps;
var G__49998 = (i + (1));
el__$1 = G__49997;
i = G__49998;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__49299 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49299,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49299,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49299,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__49304_50033 = cljs.core.seq(props);
var chunk__49305_50034 = null;
var count__49306_50035 = (0);
var i__49307_50036 = (0);
while(true){
if((i__49307_50036 < count__49306_50035)){
var vec__49318_50037 = chunk__49305_50034.cljs$core$IIndexed$_nth$arity$2(null,i__49307_50036);
var k_50038 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49318_50037,(0),null);
var v_50039 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49318_50037,(1),null);
el.setAttributeNS((function (){var temp__5754__auto__ = cljs.core.namespace(k_50038);
if(cljs.core.truth_(temp__5754__auto__)){
var ns = temp__5754__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_50038),v_50039);


var G__50055 = seq__49304_50033;
var G__50056 = chunk__49305_50034;
var G__50057 = count__49306_50035;
var G__50058 = (i__49307_50036 + (1));
seq__49304_50033 = G__50055;
chunk__49305_50034 = G__50056;
count__49306_50035 = G__50057;
i__49307_50036 = G__50058;
continue;
} else {
var temp__5754__auto___50065 = cljs.core.seq(seq__49304_50033);
if(temp__5754__auto___50065){
var seq__49304_50066__$1 = temp__5754__auto___50065;
if(cljs.core.chunked_seq_QMARK_(seq__49304_50066__$1)){
var c__4591__auto___50067 = cljs.core.chunk_first(seq__49304_50066__$1);
var G__50073 = cljs.core.chunk_rest(seq__49304_50066__$1);
var G__50074 = c__4591__auto___50067;
var G__50075 = cljs.core.count(c__4591__auto___50067);
var G__50076 = (0);
seq__49304_50033 = G__50073;
chunk__49305_50034 = G__50074;
count__49306_50035 = G__50075;
i__49307_50036 = G__50076;
continue;
} else {
var vec__49322_50077 = cljs.core.first(seq__49304_50066__$1);
var k_50078 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49322_50077,(0),null);
var v_50079 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49322_50077,(1),null);
el.setAttributeNS((function (){var temp__5754__auto____$1 = cljs.core.namespace(k_50078);
if(cljs.core.truth_(temp__5754__auto____$1)){
var ns = temp__5754__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_50078),v_50079);


var G__50093 = cljs.core.next(seq__49304_50066__$1);
var G__50094 = null;
var G__50095 = (0);
var G__50096 = (0);
seq__49304_50033 = G__50093;
chunk__49305_50034 = G__50094;
count__49306_50035 = G__50095;
i__49307_50036 = G__50096;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__49338 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49338,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49338,(1),null);
var seq__49341_50103 = cljs.core.seq(node_children);
var chunk__49343_50104 = null;
var count__49344_50105 = (0);
var i__49345_50106 = (0);
while(true){
if((i__49345_50106 < count__49344_50105)){
var child_struct_50107 = chunk__49343_50104.cljs$core$IIndexed$_nth$arity$2(null,i__49345_50106);
if((!((child_struct_50107 == null)))){
if(typeof child_struct_50107 === 'string'){
var text_50115 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50115),child_struct_50107].join(''));
} else {
var children_50116 = shadow.dom.svg_node(child_struct_50107);
if(cljs.core.seq_QMARK_(children_50116)){
var seq__49375_50117 = cljs.core.seq(children_50116);
var chunk__49377_50118 = null;
var count__49378_50119 = (0);
var i__49379_50120 = (0);
while(true){
if((i__49379_50120 < count__49378_50119)){
var child_50121 = chunk__49377_50118.cljs$core$IIndexed$_nth$arity$2(null,i__49379_50120);
if(cljs.core.truth_(child_50121)){
node.appendChild(child_50121);


var G__50123 = seq__49375_50117;
var G__50124 = chunk__49377_50118;
var G__50125 = count__49378_50119;
var G__50126 = (i__49379_50120 + (1));
seq__49375_50117 = G__50123;
chunk__49377_50118 = G__50124;
count__49378_50119 = G__50125;
i__49379_50120 = G__50126;
continue;
} else {
var G__50128 = seq__49375_50117;
var G__50129 = chunk__49377_50118;
var G__50130 = count__49378_50119;
var G__50131 = (i__49379_50120 + (1));
seq__49375_50117 = G__50128;
chunk__49377_50118 = G__50129;
count__49378_50119 = G__50130;
i__49379_50120 = G__50131;
continue;
}
} else {
var temp__5754__auto___50133 = cljs.core.seq(seq__49375_50117);
if(temp__5754__auto___50133){
var seq__49375_50136__$1 = temp__5754__auto___50133;
if(cljs.core.chunked_seq_QMARK_(seq__49375_50136__$1)){
var c__4591__auto___50137 = cljs.core.chunk_first(seq__49375_50136__$1);
var G__50138 = cljs.core.chunk_rest(seq__49375_50136__$1);
var G__50139 = c__4591__auto___50137;
var G__50140 = cljs.core.count(c__4591__auto___50137);
var G__50141 = (0);
seq__49375_50117 = G__50138;
chunk__49377_50118 = G__50139;
count__49378_50119 = G__50140;
i__49379_50120 = G__50141;
continue;
} else {
var child_50143 = cljs.core.first(seq__49375_50136__$1);
if(cljs.core.truth_(child_50143)){
node.appendChild(child_50143);


var G__50144 = cljs.core.next(seq__49375_50136__$1);
var G__50145 = null;
var G__50146 = (0);
var G__50147 = (0);
seq__49375_50117 = G__50144;
chunk__49377_50118 = G__50145;
count__49378_50119 = G__50146;
i__49379_50120 = G__50147;
continue;
} else {
var G__50148 = cljs.core.next(seq__49375_50136__$1);
var G__50149 = null;
var G__50150 = (0);
var G__50151 = (0);
seq__49375_50117 = G__50148;
chunk__49377_50118 = G__50149;
count__49378_50119 = G__50150;
i__49379_50120 = G__50151;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50116);
}
}


var G__50153 = seq__49341_50103;
var G__50154 = chunk__49343_50104;
var G__50155 = count__49344_50105;
var G__50156 = (i__49345_50106 + (1));
seq__49341_50103 = G__50153;
chunk__49343_50104 = G__50154;
count__49344_50105 = G__50155;
i__49345_50106 = G__50156;
continue;
} else {
var G__50160 = seq__49341_50103;
var G__50161 = chunk__49343_50104;
var G__50162 = count__49344_50105;
var G__50163 = (i__49345_50106 + (1));
seq__49341_50103 = G__50160;
chunk__49343_50104 = G__50161;
count__49344_50105 = G__50162;
i__49345_50106 = G__50163;
continue;
}
} else {
var temp__5754__auto___50164 = cljs.core.seq(seq__49341_50103);
if(temp__5754__auto___50164){
var seq__49341_50170__$1 = temp__5754__auto___50164;
if(cljs.core.chunked_seq_QMARK_(seq__49341_50170__$1)){
var c__4591__auto___50171 = cljs.core.chunk_first(seq__49341_50170__$1);
var G__50173 = cljs.core.chunk_rest(seq__49341_50170__$1);
var G__50174 = c__4591__auto___50171;
var G__50175 = cljs.core.count(c__4591__auto___50171);
var G__50176 = (0);
seq__49341_50103 = G__50173;
chunk__49343_50104 = G__50174;
count__49344_50105 = G__50175;
i__49345_50106 = G__50176;
continue;
} else {
var child_struct_50182 = cljs.core.first(seq__49341_50170__$1);
if((!((child_struct_50182 == null)))){
if(typeof child_struct_50182 === 'string'){
var text_50184 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50184),child_struct_50182].join(''));
} else {
var children_50187 = shadow.dom.svg_node(child_struct_50182);
if(cljs.core.seq_QMARK_(children_50187)){
var seq__49385_50192 = cljs.core.seq(children_50187);
var chunk__49387_50193 = null;
var count__49388_50194 = (0);
var i__49389_50195 = (0);
while(true){
if((i__49389_50195 < count__49388_50194)){
var child_50204 = chunk__49387_50193.cljs$core$IIndexed$_nth$arity$2(null,i__49389_50195);
if(cljs.core.truth_(child_50204)){
node.appendChild(child_50204);


var G__50207 = seq__49385_50192;
var G__50208 = chunk__49387_50193;
var G__50209 = count__49388_50194;
var G__50210 = (i__49389_50195 + (1));
seq__49385_50192 = G__50207;
chunk__49387_50193 = G__50208;
count__49388_50194 = G__50209;
i__49389_50195 = G__50210;
continue;
} else {
var G__50214 = seq__49385_50192;
var G__50215 = chunk__49387_50193;
var G__50216 = count__49388_50194;
var G__50217 = (i__49389_50195 + (1));
seq__49385_50192 = G__50214;
chunk__49387_50193 = G__50215;
count__49388_50194 = G__50216;
i__49389_50195 = G__50217;
continue;
}
} else {
var temp__5754__auto___50218__$1 = cljs.core.seq(seq__49385_50192);
if(temp__5754__auto___50218__$1){
var seq__49385_50219__$1 = temp__5754__auto___50218__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49385_50219__$1)){
var c__4591__auto___50220 = cljs.core.chunk_first(seq__49385_50219__$1);
var G__50221 = cljs.core.chunk_rest(seq__49385_50219__$1);
var G__50222 = c__4591__auto___50220;
var G__50223 = cljs.core.count(c__4591__auto___50220);
var G__50224 = (0);
seq__49385_50192 = G__50221;
chunk__49387_50193 = G__50222;
count__49388_50194 = G__50223;
i__49389_50195 = G__50224;
continue;
} else {
var child_50225 = cljs.core.first(seq__49385_50219__$1);
if(cljs.core.truth_(child_50225)){
node.appendChild(child_50225);


var G__50227 = cljs.core.next(seq__49385_50219__$1);
var G__50228 = null;
var G__50229 = (0);
var G__50230 = (0);
seq__49385_50192 = G__50227;
chunk__49387_50193 = G__50228;
count__49388_50194 = G__50229;
i__49389_50195 = G__50230;
continue;
} else {
var G__50231 = cljs.core.next(seq__49385_50219__$1);
var G__50232 = null;
var G__50233 = (0);
var G__50234 = (0);
seq__49385_50192 = G__50231;
chunk__49387_50193 = G__50232;
count__49388_50194 = G__50233;
i__49389_50195 = G__50234;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50187);
}
}


var G__50236 = cljs.core.next(seq__49341_50170__$1);
var G__50237 = null;
var G__50238 = (0);
var G__50239 = (0);
seq__49341_50103 = G__50236;
chunk__49343_50104 = G__50237;
count__49344_50105 = G__50238;
i__49345_50106 = G__50239;
continue;
} else {
var G__50240 = cljs.core.next(seq__49341_50170__$1);
var G__50241 = null;
var G__50242 = (0);
var G__50243 = (0);
seq__49341_50103 = G__50240;
chunk__49343_50104 = G__50241;
count__49344_50105 = G__50242;
i__49345_50106 = G__50243;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4777__auto__ = [];
var len__4771__auto___50266 = arguments.length;
var i__4772__auto___50267 = (0);
while(true){
if((i__4772__auto___50267 < len__4771__auto___50266)){
args__4777__auto__.push((arguments[i__4772__auto___50267]));

var G__50273 = (i__4772__auto___50267 + (1));
i__4772__auto___50267 = G__50273;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq49417){
var G__49418 = cljs.core.first(seq49417);
var seq49417__$1 = cljs.core.next(seq49417);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49418,seq49417__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__49424 = arguments.length;
switch (G__49424) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4149__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4149__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4149__auto__;
}
})())){
var c__46308__auto___50307 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46309__auto__ = (function (){var switch__46107__auto__ = (function (state_49435){
var state_val_49436 = (state_49435[(1)]);
if((state_val_49436 === (1))){
var state_49435__$1 = state_49435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49435__$1,(2),once_or_cleanup);
} else {
if((state_val_49436 === (2))){
var inst_49432 = (state_49435[(2)]);
var inst_49433 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_49435__$1 = (function (){var statearr_49439 = state_49435;
(statearr_49439[(7)] = inst_49432);

return statearr_49439;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_49435__$1,inst_49433);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__46108__auto__ = null;
var shadow$dom$state_machine__46108__auto____0 = (function (){
var statearr_49441 = [null,null,null,null,null,null,null,null];
(statearr_49441[(0)] = shadow$dom$state_machine__46108__auto__);

(statearr_49441[(1)] = (1));

return statearr_49441;
});
var shadow$dom$state_machine__46108__auto____1 = (function (state_49435){
while(true){
var ret_value__46109__auto__ = (function (){try{while(true){
var result__46110__auto__ = switch__46107__auto__(state_49435);
if(cljs.core.keyword_identical_QMARK_(result__46110__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46110__auto__;
}
break;
}
}catch (e49442){var ex__46111__auto__ = e49442;
var statearr_49443_50319 = state_49435;
(statearr_49443_50319[(2)] = ex__46111__auto__);


if(cljs.core.seq((state_49435[(4)]))){
var statearr_49444_50325 = state_49435;
(statearr_49444_50325[(1)] = cljs.core.first((state_49435[(4)])));

} else {
throw ex__46111__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46109__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50327 = state_49435;
state_49435 = G__50327;
continue;
} else {
return ret_value__46109__auto__;
}
break;
}
});
shadow$dom$state_machine__46108__auto__ = function(state_49435){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__46108__auto____0.call(this);
case 1:
return shadow$dom$state_machine__46108__auto____1.call(this,state_49435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__46108__auto____0;
shadow$dom$state_machine__46108__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__46108__auto____1;
return shadow$dom$state_machine__46108__auto__;
})()
})();
var state__46310__auto__ = (function (){var statearr_49446 = f__46309__auto__();
(statearr_49446[(6)] = c__46308__auto___50307);

return statearr_49446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46310__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
