goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_41283 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_41283(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_41284 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_41284(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__40606 = coll;
var G__40607 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__40606,G__40607) : shadow.dom.lazy_native_coll_seq.call(null,G__40606,G__40607));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__40630 = arguments.length;
switch (G__40630) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__40640 = arguments.length;
switch (G__40640) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__40644 = arguments.length;
switch (G__40644) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__40648 = arguments.length;
switch (G__40648) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__40660 = arguments.length;
switch (G__40660) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__40668 = arguments.length;
switch (G__40668) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e40682){if((e40682 instanceof Object)){
var e = e40682;
return console.log("didnt support attachEvent",el,e);
} else {
throw e40682;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__40686 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__40687 = null;
var count__40688 = (0);
var i__40689 = (0);
while(true){
if((i__40689 < count__40688)){
var el = chunk__40687.cljs$core$IIndexed$_nth$arity$2(null,i__40689);
var handler_41306__$1 = ((function (seq__40686,chunk__40687,count__40688,i__40689,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__40686,chunk__40687,count__40688,i__40689,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_41306__$1);


var G__41307 = seq__40686;
var G__41308 = chunk__40687;
var G__41309 = count__40688;
var G__41310 = (i__40689 + (1));
seq__40686 = G__41307;
chunk__40687 = G__41308;
count__40688 = G__41309;
i__40689 = G__41310;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40686);
if(temp__5720__auto__){
var seq__40686__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40686__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40686__$1);
var G__41311 = cljs.core.chunk_rest(seq__40686__$1);
var G__41312 = c__4556__auto__;
var G__41313 = cljs.core.count(c__4556__auto__);
var G__41314 = (0);
seq__40686 = G__41311;
chunk__40687 = G__41312;
count__40688 = G__41313;
i__40689 = G__41314;
continue;
} else {
var el = cljs.core.first(seq__40686__$1);
var handler_41315__$1 = ((function (seq__40686,chunk__40687,count__40688,i__40689,el,seq__40686__$1,temp__5720__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__40686,chunk__40687,count__40688,i__40689,el,seq__40686__$1,temp__5720__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_41315__$1);


var G__41316 = cljs.core.next(seq__40686__$1);
var G__41317 = null;
var G__41318 = (0);
var G__41319 = (0);
seq__40686 = G__41316;
chunk__40687 = G__41317;
count__40688 = G__41318;
i__40689 = G__41319;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__40697 = arguments.length;
switch (G__40697) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__40699 = cljs.core.seq(events);
var chunk__40700 = null;
var count__40701 = (0);
var i__40702 = (0);
while(true){
if((i__40702 < count__40701)){
var vec__40709 = chunk__40700.cljs$core$IIndexed$_nth$arity$2(null,i__40702);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40709,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40709,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__41322 = seq__40699;
var G__41323 = chunk__40700;
var G__41324 = count__40701;
var G__41325 = (i__40702 + (1));
seq__40699 = G__41322;
chunk__40700 = G__41323;
count__40701 = G__41324;
i__40702 = G__41325;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40699);
if(temp__5720__auto__){
var seq__40699__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40699__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40699__$1);
var G__41327 = cljs.core.chunk_rest(seq__40699__$1);
var G__41328 = c__4556__auto__;
var G__41329 = cljs.core.count(c__4556__auto__);
var G__41330 = (0);
seq__40699 = G__41327;
chunk__40700 = G__41328;
count__40701 = G__41329;
i__40702 = G__41330;
continue;
} else {
var vec__40712 = cljs.core.first(seq__40699__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40712,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40712,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__41331 = cljs.core.next(seq__40699__$1);
var G__41332 = null;
var G__41333 = (0);
var G__41334 = (0);
seq__40699 = G__41331;
chunk__40700 = G__41332;
count__40701 = G__41333;
i__40702 = G__41334;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__40715 = cljs.core.seq(styles);
var chunk__40716 = null;
var count__40717 = (0);
var i__40718 = (0);
while(true){
if((i__40718 < count__40717)){
var vec__40725 = chunk__40716.cljs$core$IIndexed$_nth$arity$2(null,i__40718);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40725,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40725,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__41335 = seq__40715;
var G__41336 = chunk__40716;
var G__41337 = count__40717;
var G__41338 = (i__40718 + (1));
seq__40715 = G__41335;
chunk__40716 = G__41336;
count__40717 = G__41337;
i__40718 = G__41338;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40715);
if(temp__5720__auto__){
var seq__40715__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40715__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40715__$1);
var G__41339 = cljs.core.chunk_rest(seq__40715__$1);
var G__41340 = c__4556__auto__;
var G__41341 = cljs.core.count(c__4556__auto__);
var G__41342 = (0);
seq__40715 = G__41339;
chunk__40716 = G__41340;
count__40717 = G__41341;
i__40718 = G__41342;
continue;
} else {
var vec__40728 = cljs.core.first(seq__40715__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40728,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40728,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__41343 = cljs.core.next(seq__40715__$1);
var G__41344 = null;
var G__41345 = (0);
var G__41346 = (0);
seq__40715 = G__41343;
chunk__40716 = G__41344;
count__40717 = G__41345;
i__40718 = G__41346;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__40731_41347 = key;
var G__40731_41348__$1 = (((G__40731_41347 instanceof cljs.core.Keyword))?G__40731_41347.fqn:null);
switch (G__40731_41348__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_41351 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_41351,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_41351,"aria-");
}
})())){
el.setAttribute(ks_41351,value);
} else {
(el[ks_41351] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__40737){
var map__40738 = p__40737;
var map__40738__$1 = (((((!((map__40738 == null))))?(((((map__40738.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40738.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40738):map__40738);
var props = map__40738__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40738__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__40742 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40742,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40742,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40742,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__40746 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__40746,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__40746;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__40753 = arguments.length;
switch (G__40753) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__40757){
var vec__40758 = p__40757;
var seq__40759 = cljs.core.seq(vec__40758);
var first__40760 = cljs.core.first(seq__40759);
var seq__40759__$1 = cljs.core.next(seq__40759);
var nn = first__40760;
var first__40760__$1 = cljs.core.first(seq__40759__$1);
var seq__40759__$2 = cljs.core.next(seq__40759__$1);
var np = first__40760__$1;
var nc = seq__40759__$2;
var node = vec__40758;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__40772 = nn;
var G__40773 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__40772,G__40773) : create_fn.call(null,G__40772,G__40773));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__40774 = nn;
var G__40775 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__40774,G__40775) : create_fn.call(null,G__40774,G__40775));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__40776 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40776,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40776,(1),null);
var seq__40779_41364 = cljs.core.seq(node_children);
var chunk__40780_41365 = null;
var count__40781_41366 = (0);
var i__40782_41367 = (0);
while(true){
if((i__40782_41367 < count__40781_41366)){
var child_struct_41369 = chunk__40780_41365.cljs$core$IIndexed$_nth$arity$2(null,i__40782_41367);
var children_41370 = shadow.dom.dom_node(child_struct_41369);
if(cljs.core.seq_QMARK_(children_41370)){
var seq__40823_41372 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_41370));
var chunk__40825_41373 = null;
var count__40826_41374 = (0);
var i__40827_41375 = (0);
while(true){
if((i__40827_41375 < count__40826_41374)){
var child_41379 = chunk__40825_41373.cljs$core$IIndexed$_nth$arity$2(null,i__40827_41375);
if(cljs.core.truth_(child_41379)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_41379);


var G__41380 = seq__40823_41372;
var G__41381 = chunk__40825_41373;
var G__41382 = count__40826_41374;
var G__41383 = (i__40827_41375 + (1));
seq__40823_41372 = G__41380;
chunk__40825_41373 = G__41381;
count__40826_41374 = G__41382;
i__40827_41375 = G__41383;
continue;
} else {
var G__41384 = seq__40823_41372;
var G__41385 = chunk__40825_41373;
var G__41386 = count__40826_41374;
var G__41387 = (i__40827_41375 + (1));
seq__40823_41372 = G__41384;
chunk__40825_41373 = G__41385;
count__40826_41374 = G__41386;
i__40827_41375 = G__41387;
continue;
}
} else {
var temp__5720__auto___41388 = cljs.core.seq(seq__40823_41372);
if(temp__5720__auto___41388){
var seq__40823_41389__$1 = temp__5720__auto___41388;
if(cljs.core.chunked_seq_QMARK_(seq__40823_41389__$1)){
var c__4556__auto___41390 = cljs.core.chunk_first(seq__40823_41389__$1);
var G__41391 = cljs.core.chunk_rest(seq__40823_41389__$1);
var G__41392 = c__4556__auto___41390;
var G__41393 = cljs.core.count(c__4556__auto___41390);
var G__41394 = (0);
seq__40823_41372 = G__41391;
chunk__40825_41373 = G__41392;
count__40826_41374 = G__41393;
i__40827_41375 = G__41394;
continue;
} else {
var child_41395 = cljs.core.first(seq__40823_41389__$1);
if(cljs.core.truth_(child_41395)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_41395);


var G__41399 = cljs.core.next(seq__40823_41389__$1);
var G__41400 = null;
var G__41401 = (0);
var G__41402 = (0);
seq__40823_41372 = G__41399;
chunk__40825_41373 = G__41400;
count__40826_41374 = G__41401;
i__40827_41375 = G__41402;
continue;
} else {
var G__41403 = cljs.core.next(seq__40823_41389__$1);
var G__41404 = null;
var G__41405 = (0);
var G__41406 = (0);
seq__40823_41372 = G__41403;
chunk__40825_41373 = G__41404;
count__40826_41374 = G__41405;
i__40827_41375 = G__41406;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_41370);
}


var G__41410 = seq__40779_41364;
var G__41411 = chunk__40780_41365;
var G__41412 = count__40781_41366;
var G__41413 = (i__40782_41367 + (1));
seq__40779_41364 = G__41410;
chunk__40780_41365 = G__41411;
count__40781_41366 = G__41412;
i__40782_41367 = G__41413;
continue;
} else {
var temp__5720__auto___41414 = cljs.core.seq(seq__40779_41364);
if(temp__5720__auto___41414){
var seq__40779_41416__$1 = temp__5720__auto___41414;
if(cljs.core.chunked_seq_QMARK_(seq__40779_41416__$1)){
var c__4556__auto___41418 = cljs.core.chunk_first(seq__40779_41416__$1);
var G__41419 = cljs.core.chunk_rest(seq__40779_41416__$1);
var G__41420 = c__4556__auto___41418;
var G__41421 = cljs.core.count(c__4556__auto___41418);
var G__41422 = (0);
seq__40779_41364 = G__41419;
chunk__40780_41365 = G__41420;
count__40781_41366 = G__41421;
i__40782_41367 = G__41422;
continue;
} else {
var child_struct_41427 = cljs.core.first(seq__40779_41416__$1);
var children_41428 = shadow.dom.dom_node(child_struct_41427);
if(cljs.core.seq_QMARK_(children_41428)){
var seq__40835_41429 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_41428));
var chunk__40837_41430 = null;
var count__40838_41431 = (0);
var i__40839_41432 = (0);
while(true){
if((i__40839_41432 < count__40838_41431)){
var child_41434 = chunk__40837_41430.cljs$core$IIndexed$_nth$arity$2(null,i__40839_41432);
if(cljs.core.truth_(child_41434)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_41434);


var G__41436 = seq__40835_41429;
var G__41437 = chunk__40837_41430;
var G__41438 = count__40838_41431;
var G__41439 = (i__40839_41432 + (1));
seq__40835_41429 = G__41436;
chunk__40837_41430 = G__41437;
count__40838_41431 = G__41438;
i__40839_41432 = G__41439;
continue;
} else {
var G__41440 = seq__40835_41429;
var G__41441 = chunk__40837_41430;
var G__41442 = count__40838_41431;
var G__41443 = (i__40839_41432 + (1));
seq__40835_41429 = G__41440;
chunk__40837_41430 = G__41441;
count__40838_41431 = G__41442;
i__40839_41432 = G__41443;
continue;
}
} else {
var temp__5720__auto___41444__$1 = cljs.core.seq(seq__40835_41429);
if(temp__5720__auto___41444__$1){
var seq__40835_41445__$1 = temp__5720__auto___41444__$1;
if(cljs.core.chunked_seq_QMARK_(seq__40835_41445__$1)){
var c__4556__auto___41446 = cljs.core.chunk_first(seq__40835_41445__$1);
var G__41447 = cljs.core.chunk_rest(seq__40835_41445__$1);
var G__41448 = c__4556__auto___41446;
var G__41449 = cljs.core.count(c__4556__auto___41446);
var G__41450 = (0);
seq__40835_41429 = G__41447;
chunk__40837_41430 = G__41448;
count__40838_41431 = G__41449;
i__40839_41432 = G__41450;
continue;
} else {
var child_41451 = cljs.core.first(seq__40835_41445__$1);
if(cljs.core.truth_(child_41451)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_41451);


var G__41452 = cljs.core.next(seq__40835_41445__$1);
var G__41453 = null;
var G__41454 = (0);
var G__41455 = (0);
seq__40835_41429 = G__41452;
chunk__40837_41430 = G__41453;
count__40838_41431 = G__41454;
i__40839_41432 = G__41455;
continue;
} else {
var G__41456 = cljs.core.next(seq__40835_41445__$1);
var G__41457 = null;
var G__41458 = (0);
var G__41459 = (0);
seq__40835_41429 = G__41456;
chunk__40837_41430 = G__41457;
count__40838_41431 = G__41458;
i__40839_41432 = G__41459;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_41428);
}


var G__41460 = cljs.core.next(seq__40779_41416__$1);
var G__41461 = null;
var G__41462 = (0);
var G__41463 = (0);
seq__40779_41364 = G__41460;
chunk__40780_41365 = G__41461;
count__40781_41366 = G__41462;
i__40782_41367 = G__41463;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__40862 = cljs.core.seq(node);
var chunk__40863 = null;
var count__40864 = (0);
var i__40865 = (0);
while(true){
if((i__40865 < count__40864)){
var n = chunk__40863.cljs$core$IIndexed$_nth$arity$2(null,i__40865);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__41470 = seq__40862;
var G__41471 = chunk__40863;
var G__41472 = count__40864;
var G__41473 = (i__40865 + (1));
seq__40862 = G__41470;
chunk__40863 = G__41471;
count__40864 = G__41472;
i__40865 = G__41473;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40862);
if(temp__5720__auto__){
var seq__40862__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40862__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40862__$1);
var G__41477 = cljs.core.chunk_rest(seq__40862__$1);
var G__41478 = c__4556__auto__;
var G__41479 = cljs.core.count(c__4556__auto__);
var G__41480 = (0);
seq__40862 = G__41477;
chunk__40863 = G__41478;
count__40864 = G__41479;
i__40865 = G__41480;
continue;
} else {
var n = cljs.core.first(seq__40862__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__41481 = cljs.core.next(seq__40862__$1);
var G__41482 = null;
var G__41483 = (0);
var G__41484 = (0);
seq__40862 = G__41481;
chunk__40863 = G__41482;
count__40864 = G__41483;
i__40865 = G__41484;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__40873 = arguments.length;
switch (G__40873) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__40883 = arguments.length;
switch (G__40883) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__40891 = arguments.length;
switch (G__40891) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41505 = arguments.length;
var i__4737__auto___41506 = (0);
while(true){
if((i__4737__auto___41506 < len__4736__auto___41505)){
args__4742__auto__.push((arguments[i__4737__auto___41506]));

var G__41508 = (i__4737__auto___41506 + (1));
i__4737__auto___41506 = G__41508;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__40903_41509 = cljs.core.seq(nodes);
var chunk__40904_41510 = null;
var count__40905_41511 = (0);
var i__40906_41512 = (0);
while(true){
if((i__40906_41512 < count__40905_41511)){
var node_41515 = chunk__40904_41510.cljs$core$IIndexed$_nth$arity$2(null,i__40906_41512);
fragment.appendChild(shadow.dom._to_dom(node_41515));


var G__41516 = seq__40903_41509;
var G__41517 = chunk__40904_41510;
var G__41518 = count__40905_41511;
var G__41519 = (i__40906_41512 + (1));
seq__40903_41509 = G__41516;
chunk__40904_41510 = G__41517;
count__40905_41511 = G__41518;
i__40906_41512 = G__41519;
continue;
} else {
var temp__5720__auto___41520 = cljs.core.seq(seq__40903_41509);
if(temp__5720__auto___41520){
var seq__40903_41521__$1 = temp__5720__auto___41520;
if(cljs.core.chunked_seq_QMARK_(seq__40903_41521__$1)){
var c__4556__auto___41522 = cljs.core.chunk_first(seq__40903_41521__$1);
var G__41524 = cljs.core.chunk_rest(seq__40903_41521__$1);
var G__41525 = c__4556__auto___41522;
var G__41526 = cljs.core.count(c__4556__auto___41522);
var G__41527 = (0);
seq__40903_41509 = G__41524;
chunk__40904_41510 = G__41525;
count__40905_41511 = G__41526;
i__40906_41512 = G__41527;
continue;
} else {
var node_41529 = cljs.core.first(seq__40903_41521__$1);
fragment.appendChild(shadow.dom._to_dom(node_41529));


var G__41530 = cljs.core.next(seq__40903_41521__$1);
var G__41531 = null;
var G__41532 = (0);
var G__41533 = (0);
seq__40903_41509 = G__41530;
chunk__40904_41510 = G__41531;
count__40905_41511 = G__41532;
i__40906_41512 = G__41533;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq40898){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40898));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__40931_41535 = cljs.core.seq(scripts);
var chunk__40932_41536 = null;
var count__40933_41537 = (0);
var i__40934_41538 = (0);
while(true){
if((i__40934_41538 < count__40933_41537)){
var vec__40944_41539 = chunk__40932_41536.cljs$core$IIndexed$_nth$arity$2(null,i__40934_41538);
var script_tag_41540 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40944_41539,(0),null);
var script_body_41541 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40944_41539,(1),null);
eval(script_body_41541);


var G__41545 = seq__40931_41535;
var G__41546 = chunk__40932_41536;
var G__41547 = count__40933_41537;
var G__41548 = (i__40934_41538 + (1));
seq__40931_41535 = G__41545;
chunk__40932_41536 = G__41546;
count__40933_41537 = G__41547;
i__40934_41538 = G__41548;
continue;
} else {
var temp__5720__auto___41549 = cljs.core.seq(seq__40931_41535);
if(temp__5720__auto___41549){
var seq__40931_41551__$1 = temp__5720__auto___41549;
if(cljs.core.chunked_seq_QMARK_(seq__40931_41551__$1)){
var c__4556__auto___41552 = cljs.core.chunk_first(seq__40931_41551__$1);
var G__41553 = cljs.core.chunk_rest(seq__40931_41551__$1);
var G__41554 = c__4556__auto___41552;
var G__41555 = cljs.core.count(c__4556__auto___41552);
var G__41556 = (0);
seq__40931_41535 = G__41553;
chunk__40932_41536 = G__41554;
count__40933_41537 = G__41555;
i__40934_41538 = G__41556;
continue;
} else {
var vec__40947_41559 = cljs.core.first(seq__40931_41551__$1);
var script_tag_41560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40947_41559,(0),null);
var script_body_41561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40947_41559,(1),null);
eval(script_body_41561);


var G__41562 = cljs.core.next(seq__40931_41551__$1);
var G__41563 = null;
var G__41564 = (0);
var G__41565 = (0);
seq__40931_41535 = G__41562;
chunk__40932_41536 = G__41563;
count__40933_41537 = G__41564;
i__40934_41538 = G__41565;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__40950){
var vec__40951 = p__40950;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40951,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40951,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__40956 = arguments.length;
switch (G__40956) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__40967 = cljs.core.seq(style_keys);
var chunk__40968 = null;
var count__40969 = (0);
var i__40970 = (0);
while(true){
if((i__40970 < count__40969)){
var it = chunk__40968.cljs$core$IIndexed$_nth$arity$2(null,i__40970);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__41583 = seq__40967;
var G__41584 = chunk__40968;
var G__41585 = count__40969;
var G__41586 = (i__40970 + (1));
seq__40967 = G__41583;
chunk__40968 = G__41584;
count__40969 = G__41585;
i__40970 = G__41586;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40967);
if(temp__5720__auto__){
var seq__40967__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40967__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40967__$1);
var G__41590 = cljs.core.chunk_rest(seq__40967__$1);
var G__41591 = c__4556__auto__;
var G__41592 = cljs.core.count(c__4556__auto__);
var G__41593 = (0);
seq__40967 = G__41590;
chunk__40968 = G__41591;
count__40969 = G__41592;
i__40970 = G__41593;
continue;
} else {
var it = cljs.core.first(seq__40967__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__41596 = cljs.core.next(seq__40967__$1);
var G__41597 = null;
var G__41598 = (0);
var G__41599 = (0);
seq__40967 = G__41596;
chunk__40968 = G__41597;
count__40969 = G__41598;
i__40970 = G__41599;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k40976,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__40986 = k40976;
var G__40986__$1 = (((G__40986 instanceof cljs.core.Keyword))?G__40986.fqn:null);
switch (G__40986__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k40976,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__40992){
var vec__40999 = p__40992;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40999,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40999,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__40975){
var self__ = this;
var G__40975__$1 = this;
return (new cljs.core.RecordIter((0),G__40975__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this40977,other40978){
var self__ = this;
var this40977__$1 = this;
return (((!((other40978 == null)))) && ((this40977__$1.constructor === other40978.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40977__$1.x,other40978.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40977__$1.y,other40978.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40977__$1.__extmap,other40978.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__40975){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__41025 = cljs.core.keyword_identical_QMARK_;
var expr__41026 = k__4388__auto__;
if(cljs.core.truth_((pred__41025.cljs$core$IFn$_invoke$arity$2 ? pred__41025.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__41026) : pred__41025.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__41026)))){
return (new shadow.dom.Coordinate(G__40975,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__41025.cljs$core$IFn$_invoke$arity$2 ? pred__41025.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__41026) : pred__41025.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__41026)))){
return (new shadow.dom.Coordinate(self__.x,G__40975,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__40975),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__40975){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__40975,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__40979){
var extmap__4419__auto__ = (function (){var G__41034 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__40979,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__40979)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__41034);
} else {
return G__41034;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__40979),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__40979),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k41039,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__41048 = k41039;
var G__41048__$1 = (((G__41048 instanceof cljs.core.Keyword))?G__41048.fqn:null);
switch (G__41048__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k41039,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__41050){
var vec__41052 = p__41050;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41052,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41052,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__41038){
var self__ = this;
var G__41038__$1 = this;
return (new cljs.core.RecordIter((0),G__41038__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this41040,other41041){
var self__ = this;
var this41040__$1 = this;
return (((!((other41041 == null)))) && ((this41040__$1.constructor === other41041.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41040__$1.w,other41041.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41040__$1.h,other41041.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41040__$1.__extmap,other41041.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__41038){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__41063 = cljs.core.keyword_identical_QMARK_;
var expr__41064 = k__4388__auto__;
if(cljs.core.truth_((pred__41063.cljs$core$IFn$_invoke$arity$2 ? pred__41063.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__41064) : pred__41063.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__41064)))){
return (new shadow.dom.Size(G__41038,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__41063.cljs$core$IFn$_invoke$arity$2 ? pred__41063.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__41064) : pred__41063.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__41064)))){
return (new shadow.dom.Size(self__.w,G__41038,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__41038),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__41038){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__41038,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__41042){
var extmap__4419__auto__ = (function (){var G__41068 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__41042,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__41042)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__41068);
} else {
return G__41068;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__41042),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__41042),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__41647 = (i + (1));
var G__41648 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__41647;
ret = G__41648;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__41080){
var vec__41081 = p__41080;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41081,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41081,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__41088 = arguments.length;
switch (G__41088) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__41657 = ps;
var G__41658 = (i + (1));
el__$1 = G__41657;
i = G__41658;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__41111 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41111,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41111,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41111,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__41115_41663 = cljs.core.seq(props);
var chunk__41116_41664 = null;
var count__41117_41665 = (0);
var i__41118_41666 = (0);
while(true){
if((i__41118_41666 < count__41117_41665)){
var vec__41129_41670 = chunk__41116_41664.cljs$core$IIndexed$_nth$arity$2(null,i__41118_41666);
var k_41671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41129_41670,(0),null);
var v_41672 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41129_41670,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace(k_41671);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_41671),v_41672);


var G__41675 = seq__41115_41663;
var G__41676 = chunk__41116_41664;
var G__41677 = count__41117_41665;
var G__41678 = (i__41118_41666 + (1));
seq__41115_41663 = G__41675;
chunk__41116_41664 = G__41676;
count__41117_41665 = G__41677;
i__41118_41666 = G__41678;
continue;
} else {
var temp__5720__auto___41679 = cljs.core.seq(seq__41115_41663);
if(temp__5720__auto___41679){
var seq__41115_41680__$1 = temp__5720__auto___41679;
if(cljs.core.chunked_seq_QMARK_(seq__41115_41680__$1)){
var c__4556__auto___41681 = cljs.core.chunk_first(seq__41115_41680__$1);
var G__41682 = cljs.core.chunk_rest(seq__41115_41680__$1);
var G__41683 = c__4556__auto___41681;
var G__41684 = cljs.core.count(c__4556__auto___41681);
var G__41685 = (0);
seq__41115_41663 = G__41682;
chunk__41116_41664 = G__41683;
count__41117_41665 = G__41684;
i__41118_41666 = G__41685;
continue;
} else {
var vec__41138_41686 = cljs.core.first(seq__41115_41680__$1);
var k_41687 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41138_41686,(0),null);
var v_41688 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41138_41686,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace(k_41687);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_41687),v_41688);


var G__41691 = cljs.core.next(seq__41115_41680__$1);
var G__41692 = null;
var G__41693 = (0);
var G__41694 = (0);
seq__41115_41663 = G__41691;
chunk__41116_41664 = G__41692;
count__41117_41665 = G__41693;
i__41118_41666 = G__41694;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__41145 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41145,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41145,(1),null);
var seq__41148_41697 = cljs.core.seq(node_children);
var chunk__41150_41698 = null;
var count__41151_41699 = (0);
var i__41152_41700 = (0);
while(true){
if((i__41152_41700 < count__41151_41699)){
var child_struct_41701 = chunk__41150_41698.cljs$core$IIndexed$_nth$arity$2(null,i__41152_41700);
if((!((child_struct_41701 == null)))){
if(typeof child_struct_41701 === 'string'){
var text_41702 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_41702),child_struct_41701].join(''));
} else {
var children_41703 = shadow.dom.svg_node(child_struct_41701);
if(cljs.core.seq_QMARK_(children_41703)){
var seq__41179_41704 = cljs.core.seq(children_41703);
var chunk__41181_41705 = null;
var count__41182_41706 = (0);
var i__41183_41707 = (0);
while(true){
if((i__41183_41707 < count__41182_41706)){
var child_41708 = chunk__41181_41705.cljs$core$IIndexed$_nth$arity$2(null,i__41183_41707);
if(cljs.core.truth_(child_41708)){
node.appendChild(child_41708);


var G__41710 = seq__41179_41704;
var G__41711 = chunk__41181_41705;
var G__41712 = count__41182_41706;
var G__41713 = (i__41183_41707 + (1));
seq__41179_41704 = G__41710;
chunk__41181_41705 = G__41711;
count__41182_41706 = G__41712;
i__41183_41707 = G__41713;
continue;
} else {
var G__41714 = seq__41179_41704;
var G__41715 = chunk__41181_41705;
var G__41716 = count__41182_41706;
var G__41717 = (i__41183_41707 + (1));
seq__41179_41704 = G__41714;
chunk__41181_41705 = G__41715;
count__41182_41706 = G__41716;
i__41183_41707 = G__41717;
continue;
}
} else {
var temp__5720__auto___41718 = cljs.core.seq(seq__41179_41704);
if(temp__5720__auto___41718){
var seq__41179_41719__$1 = temp__5720__auto___41718;
if(cljs.core.chunked_seq_QMARK_(seq__41179_41719__$1)){
var c__4556__auto___41720 = cljs.core.chunk_first(seq__41179_41719__$1);
var G__41721 = cljs.core.chunk_rest(seq__41179_41719__$1);
var G__41722 = c__4556__auto___41720;
var G__41723 = cljs.core.count(c__4556__auto___41720);
var G__41724 = (0);
seq__41179_41704 = G__41721;
chunk__41181_41705 = G__41722;
count__41182_41706 = G__41723;
i__41183_41707 = G__41724;
continue;
} else {
var child_41727 = cljs.core.first(seq__41179_41719__$1);
if(cljs.core.truth_(child_41727)){
node.appendChild(child_41727);


var G__41729 = cljs.core.next(seq__41179_41719__$1);
var G__41730 = null;
var G__41731 = (0);
var G__41732 = (0);
seq__41179_41704 = G__41729;
chunk__41181_41705 = G__41730;
count__41182_41706 = G__41731;
i__41183_41707 = G__41732;
continue;
} else {
var G__41733 = cljs.core.next(seq__41179_41719__$1);
var G__41734 = null;
var G__41735 = (0);
var G__41736 = (0);
seq__41179_41704 = G__41733;
chunk__41181_41705 = G__41734;
count__41182_41706 = G__41735;
i__41183_41707 = G__41736;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_41703);
}
}


var G__41737 = seq__41148_41697;
var G__41738 = chunk__41150_41698;
var G__41739 = count__41151_41699;
var G__41740 = (i__41152_41700 + (1));
seq__41148_41697 = G__41737;
chunk__41150_41698 = G__41738;
count__41151_41699 = G__41739;
i__41152_41700 = G__41740;
continue;
} else {
var G__41741 = seq__41148_41697;
var G__41743 = chunk__41150_41698;
var G__41744 = count__41151_41699;
var G__41745 = (i__41152_41700 + (1));
seq__41148_41697 = G__41741;
chunk__41150_41698 = G__41743;
count__41151_41699 = G__41744;
i__41152_41700 = G__41745;
continue;
}
} else {
var temp__5720__auto___41748 = cljs.core.seq(seq__41148_41697);
if(temp__5720__auto___41748){
var seq__41148_41749__$1 = temp__5720__auto___41748;
if(cljs.core.chunked_seq_QMARK_(seq__41148_41749__$1)){
var c__4556__auto___41750 = cljs.core.chunk_first(seq__41148_41749__$1);
var G__41751 = cljs.core.chunk_rest(seq__41148_41749__$1);
var G__41752 = c__4556__auto___41750;
var G__41753 = cljs.core.count(c__4556__auto___41750);
var G__41754 = (0);
seq__41148_41697 = G__41751;
chunk__41150_41698 = G__41752;
count__41151_41699 = G__41753;
i__41152_41700 = G__41754;
continue;
} else {
var child_struct_41755 = cljs.core.first(seq__41148_41749__$1);
if((!((child_struct_41755 == null)))){
if(typeof child_struct_41755 === 'string'){
var text_41756 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_41756),child_struct_41755].join(''));
} else {
var children_41757 = shadow.dom.svg_node(child_struct_41755);
if(cljs.core.seq_QMARK_(children_41757)){
var seq__41197_41758 = cljs.core.seq(children_41757);
var chunk__41199_41759 = null;
var count__41200_41760 = (0);
var i__41201_41761 = (0);
while(true){
if((i__41201_41761 < count__41200_41760)){
var child_41763 = chunk__41199_41759.cljs$core$IIndexed$_nth$arity$2(null,i__41201_41761);
if(cljs.core.truth_(child_41763)){
node.appendChild(child_41763);


var G__41765 = seq__41197_41758;
var G__41767 = chunk__41199_41759;
var G__41768 = count__41200_41760;
var G__41769 = (i__41201_41761 + (1));
seq__41197_41758 = G__41765;
chunk__41199_41759 = G__41767;
count__41200_41760 = G__41768;
i__41201_41761 = G__41769;
continue;
} else {
var G__41770 = seq__41197_41758;
var G__41771 = chunk__41199_41759;
var G__41772 = count__41200_41760;
var G__41773 = (i__41201_41761 + (1));
seq__41197_41758 = G__41770;
chunk__41199_41759 = G__41771;
count__41200_41760 = G__41772;
i__41201_41761 = G__41773;
continue;
}
} else {
var temp__5720__auto___41774__$1 = cljs.core.seq(seq__41197_41758);
if(temp__5720__auto___41774__$1){
var seq__41197_41775__$1 = temp__5720__auto___41774__$1;
if(cljs.core.chunked_seq_QMARK_(seq__41197_41775__$1)){
var c__4556__auto___41776 = cljs.core.chunk_first(seq__41197_41775__$1);
var G__41777 = cljs.core.chunk_rest(seq__41197_41775__$1);
var G__41778 = c__4556__auto___41776;
var G__41779 = cljs.core.count(c__4556__auto___41776);
var G__41780 = (0);
seq__41197_41758 = G__41777;
chunk__41199_41759 = G__41778;
count__41200_41760 = G__41779;
i__41201_41761 = G__41780;
continue;
} else {
var child_41781 = cljs.core.first(seq__41197_41775__$1);
if(cljs.core.truth_(child_41781)){
node.appendChild(child_41781);


var G__41782 = cljs.core.next(seq__41197_41775__$1);
var G__41783 = null;
var G__41784 = (0);
var G__41785 = (0);
seq__41197_41758 = G__41782;
chunk__41199_41759 = G__41783;
count__41200_41760 = G__41784;
i__41201_41761 = G__41785;
continue;
} else {
var G__41786 = cljs.core.next(seq__41197_41775__$1);
var G__41787 = null;
var G__41788 = (0);
var G__41789 = (0);
seq__41197_41758 = G__41786;
chunk__41199_41759 = G__41787;
count__41200_41760 = G__41788;
i__41201_41761 = G__41789;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_41757);
}
}


var G__41790 = cljs.core.next(seq__41148_41749__$1);
var G__41791 = null;
var G__41792 = (0);
var G__41793 = (0);
seq__41148_41697 = G__41790;
chunk__41150_41698 = G__41791;
count__41151_41699 = G__41792;
i__41152_41700 = G__41793;
continue;
} else {
var G__41794 = cljs.core.next(seq__41148_41749__$1);
var G__41795 = null;
var G__41796 = (0);
var G__41797 = (0);
seq__41148_41697 = G__41794;
chunk__41150_41698 = G__41795;
count__41151_41699 = G__41796;
i__41152_41700 = G__41797;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41802 = arguments.length;
var i__4737__auto___41803 = (0);
while(true){
if((i__4737__auto___41803 < len__4736__auto___41802)){
args__4742__auto__.push((arguments[i__4737__auto___41803]));

var G__41804 = (i__4737__auto___41803 + (1));
i__4737__auto___41803 = G__41804;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq41223){
var G__41224 = cljs.core.first(seq41223);
var seq41223__$1 = cljs.core.next(seq41223);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41224,seq41223__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__41234 = arguments.length;
switch (G__41234) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__40473__auto___41828 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__40474__auto__ = (function (){var switch__40387__auto__ = (function (state_41271){
var state_val_41272 = (state_41271[(1)]);
if((state_val_41272 === (1))){
var state_41271__$1 = state_41271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41271__$1,(2),once_or_cleanup);
} else {
if((state_val_41272 === (2))){
var inst_41268 = (state_41271[(2)]);
var inst_41269 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_41271__$1 = (function (){var statearr_41276 = state_41271;
(statearr_41276[(7)] = inst_41268);

return statearr_41276;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_41271__$1,inst_41269);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__40388__auto__ = null;
var shadow$dom$state_machine__40388__auto____0 = (function (){
var statearr_41277 = [null,null,null,null,null,null,null,null];
(statearr_41277[(0)] = shadow$dom$state_machine__40388__auto__);

(statearr_41277[(1)] = (1));

return statearr_41277;
});
var shadow$dom$state_machine__40388__auto____1 = (function (state_41271){
while(true){
var ret_value__40389__auto__ = (function (){try{while(true){
var result__40390__auto__ = switch__40387__auto__(state_41271);
if(cljs.core.keyword_identical_QMARK_(result__40390__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__40390__auto__;
}
break;
}
}catch (e41279){var ex__40391__auto__ = e41279;
var statearr_41280_41832 = state_41271;
(statearr_41280_41832[(2)] = ex__40391__auto__);


if(cljs.core.seq((state_41271[(4)]))){
var statearr_41281_41837 = state_41271;
(statearr_41281_41837[(1)] = cljs.core.first((state_41271[(4)])));

} else {
throw ex__40391__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__40389__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41839 = state_41271;
state_41271 = G__41839;
continue;
} else {
return ret_value__40389__auto__;
}
break;
}
});
shadow$dom$state_machine__40388__auto__ = function(state_41271){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__40388__auto____0.call(this);
case 1:
return shadow$dom$state_machine__40388__auto____1.call(this,state_41271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__40388__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__40388__auto____0;
shadow$dom$state_machine__40388__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__40388__auto____1;
return shadow$dom$state_machine__40388__auto__;
})()
})();
var state__40475__auto__ = (function (){var statearr_41282 = f__40474__auto__();
(statearr_41282[(6)] = c__40473__auto___41828);

return statearr_41282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__40475__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
