(ns gorilla-notes.components.quil
  (:require
   [pinkie.jsrender :refer [render-js]]
   [quil.core :as quil]))

(defn init [width height]
  (fn []
    {:width   width
     :height  height
     :circles []}))

(defn draw [{:keys [circles]}]
  (quil.core/background 255)
  (doseq [{[x y] :pos [r g b] :color} circles]
    (quil.core/fill r g b)
    (quil.core/ellipse x y 10 10)))

(defn update-state [{:keys [width height] :as state}]
  (update state :circles conj {:pos   [(+ 20 (rand-int (- width 40)))
                                       (+ 20 (rand-int (- height 40)))]
                               :color (repeatedly 3 #(rand-int 250))}))

(defn canvas []
  (let [width  500
        height 500]
    (reagent.core/create-class
     {:component-did-mount
      (fn [component]
        (quil.core/sketch
           :host       (reagent.core/dom-node component)
           :draw       draw
           :setup      (init width height)
           :update     update-state
           :size       [width height]
           :middleware [quil.middleware/fun-mode]))
      :render
      (fn []
        [:div])})))

(defn ^{:category :ui}
  quil
  "interpret code"
  [code]
  [canvas])
