(ns gorilla-notes.state
  (:require [reagent.core :as reagent]))

(def *state
  (reagent/atom
   {:mode->ids {}
    :id->content {}
    :options {}
    :mode :notes}))

(defn cleanup-content [state]
  (let [existing-ids (->> state
                          :mode->ids
                          vals
                          (apply concat)
                          set)
        obsolete-ids (->> state
                          :id->content
                          keys
                          (filter (complement existing-ids)))]
    (-> state
        (update :id->content #(apply dissoc % obsolete-ids)))))

(defn reset-ids! [mode ids]
  (swap! *state
         (fn [state]
           (-> state
               (assoc-in [:mode->ids mode] ids)
               ;; cleanup-content
               ))))

(defn set-uid! [uid]
  (swap! *state assoc :uid uid))

(defn reset-options! [options]
  (swap! *state assoc :options options))

(defn update-content! [i id content]
  (swap! *state
         (fn [state]
           (-> state
               (assoc-in [:id->content id]
                         content)))))

(defn cleanup-content! []
  (swap! *state cleanup-content))

(defn port []
  (-> @*state :options :port))

(defn set-mode! [mode]
  (swap! *state
         assoc :mode mode))

(defn mode! []
  (if-let [mode (:mode @*state)]
    mode
    (do (swap! *state
               (fn [state]
                 (assoc state :mode
                        (-> state :mode->ids keys first)))))))
