goog.provide('re_frame.trace');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});
/**
 * @define {boolean}
 */
re_frame.trace.trace_enabled_QMARK_ = goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__53353){
var map__53354 = p__53353;
var map__53354__$1 = cljs.core.__destructure_map(map__53354);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53354__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53354__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53354__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53354__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id(),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__4160__auto__ = child_of;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__53360_53389 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__53361_53390 = null;
var count__53362_53391 = (0);
var i__53363_53392 = (0);
while(true){
if((i__53363_53392 < count__53362_53391)){
var vec__53375_53393 = chunk__53361_53390.cljs$core$IIndexed$_nth$arity$2(null,i__53363_53392);
var k_53394 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53375_53393,(0),null);
var cb_53395 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53375_53393,(1),null);
try{var G__53379_53396 = cljs.core.deref(re_frame.trace.traces);
(cb_53395.cljs$core$IFn$_invoke$arity$1 ? cb_53395.cljs$core$IFn$_invoke$arity$1(G__53379_53396) : cb_53395.call(null,G__53379_53396));
}catch (e53378){var e_53397 = e53378;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_53394,"while storing",cljs.core.deref(re_frame.trace.traces),e_53397], 0));
}

var G__53398 = seq__53360_53389;
var G__53399 = chunk__53361_53390;
var G__53400 = count__53362_53391;
var G__53401 = (i__53363_53392 + (1));
seq__53360_53389 = G__53398;
chunk__53361_53390 = G__53399;
count__53362_53391 = G__53400;
i__53363_53392 = G__53401;
continue;
} else {
var temp__5754__auto___53402 = cljs.core.seq(seq__53360_53389);
if(temp__5754__auto___53402){
var seq__53360_53403__$1 = temp__5754__auto___53402;
if(cljs.core.chunked_seq_QMARK_(seq__53360_53403__$1)){
var c__4591__auto___53404 = cljs.core.chunk_first(seq__53360_53403__$1);
var G__53405 = cljs.core.chunk_rest(seq__53360_53403__$1);
var G__53406 = c__4591__auto___53404;
var G__53407 = cljs.core.count(c__4591__auto___53404);
var G__53408 = (0);
seq__53360_53389 = G__53405;
chunk__53361_53390 = G__53406;
count__53362_53391 = G__53407;
i__53363_53392 = G__53408;
continue;
} else {
var vec__53380_53409 = cljs.core.first(seq__53360_53403__$1);
var k_53410 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53380_53409,(0),null);
var cb_53411 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53380_53409,(1),null);
try{var G__53385_53412 = cljs.core.deref(re_frame.trace.traces);
(cb_53411.cljs$core$IFn$_invoke$arity$1 ? cb_53411.cljs$core$IFn$_invoke$arity$1(G__53385_53412) : cb_53411.call(null,G__53385_53412));
}catch (e53384){var e_53413 = e53384;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_53410,"while storing",cljs.core.deref(re_frame.trace.traces),e_53413], 0));
}

var G__53414 = cljs.core.next(seq__53360_53403__$1);
var G__53415 = null;
var G__53416 = (0);
var G__53417 = (0);
seq__53360_53389 = G__53414;
chunk__53361_53390 = G__53415;
count__53362_53391 = G__53416;
i__53363_53392 = G__53417;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=re_frame.trace.js.map
