(ns gorilla-notes.view
  (:require
   [gorilla-notes.state :as state]
   [gorilla-notes.components] ;; This is necessary for components registraion.
   [gorilla-notes.components.notes :as notes]
   [gorilla-notes.components.code :as code]
   [pinkie.pinkie :refer [tag-inject]]
   [cljsjs.highlight]
   [cljsjs.highlight.langs.clojure]))


(defn main []
  (let [{:keys [modes mode->ids id->content options]} @state/*state
        {:keys [reverse-notes? header? notes-in-cards?
                buttons? dropdown?
                custom-header custom-footer auto-scroll?
                main-div-class]} options]
    (let [mode (state/mode!)
          actual-modes (-> mode->ids
                           keys
                           (or modes)
                           (or []))
          mode-str->mode (->> actual-modes
                              (map (fn [m]
                                     [(name m) m]))
                              (into {}))
          notes (map (juxt identity
                           id->content)
                     (mode->ids mode))]
      [:div
       [:div.bg-light
        (tag-inject custom-header)
        (when dropdown?
          (->> modes
               (map (fn [amode]
                      [:option {:value amode
                                :selected (= mode amode)}
                       (name amode)]))
               (into [:select
                      {:style {:border "6px solid transparent"}
                       :on-change (fn [event]
                                    (-> event
                                        .-target
                                        .-value
                                        mode-str->mode
                                        state/set-mode!))}])))
        (when buttons?
          (->> modes
                 (map (fn [amode]
                        (let [mode-str (name amode)]
                          [:button
                           {:class    (if (= mode amode)
                                        "btn btn-dark btn-lg"
                                        "btn btn-secondary")
                            :on-click #(state/set-mode! amode)}
                           (name mode-str)])))
                 (into [:div])))
        (tag-inject (when header?
                      [notes/Header {:notes notes}]))]
       [:br]
       [:div
        (when main-div-class
          {:class main-div-class})
        (->> notes
            (map-indexed
             (fn [idx [id note]]
               (when note
                 (let [panel-id (str "panel#" id)]
                   ^{:key panel-id}
                   [:div
                    [:div {:ref #(when (and auto-scroll? %)
                                   (.scrollIntoView %))}
                     (if notes-in-cards?
                       [notes/NoteCard {:id   id
                                        :idx  idx
                                        :note note}]
                       [notes/Note {:note note}])]]))))
            ((if reverse-notes?
               reverse
               identity))
            (into [:div {:style {:overflow   "auto"
                                 :max-height "90vh"}}]))
       (tag-inject custom-footer)]])))

