(ns scicloj.notespace.v4.frontend.clerk
  (:require [scicloj.notespace.v4.frontend.protocol :as prot]
            [nextjournal.clerk.webserver :as webserver]
            [clojure.java.browse :as browse]))

(intern 'nextjournal.clerk.webserver
        'help-doc
        [{:type :markdown :text "...."}])

(defn sync-widgets! [id-fn widget-fn widgets-data]
  ;; (webserver/update-doc!
  ;;  [{:type :markdown,
  ;;    :text "hi!!"}])
  (->> widgets-data
       (mapv (fn [datum]
              (let [id (id-fn datum)
                    widget (widget-fn datum)]
                {:type :code
                 :text "..."
                 :result {:result widget
                          :blob-id (str id)}})))
       webserver/update-doc!)
  ;; (let [id->widget (meta @webserver/!doc)]
  ;;   (doseq [datum widgets-data]
  ;;     (let [id (str (id-fn datum))]
  ;;       (when-not (id->widget id)
  ;;         (swap! webserver/!doc
  ;;                vary-meta
  ;;                assoc-in id (widget-fn datum)))))
  ;;   (webserver/broadcast!
  ;;    {:nextjournal/viewer :clerk/notebook
  ;;     :nextjournal/value  (->> widgets-data
  ;;                              (mapv (fn [datum]
  ;;                                      {:nextjournal/viewer :hiccup
  ;;                                       :nextjournal/value {:blob-id (-> datum id-fn str)}})))}))
  )

(deftype ClerkFrontend []

  prot/Frontend

  (start! [this options]
    (webserver/start! options))

  (stop! [this server])

  (reset-header! [this header])

  (sync-widgets! [this id-fn widget-fn widgets-data]
    (sync-widgets! id-fn widgets-data widgets-data))

  (browse! [this])

  (render-as-html! [this html-path]))




;; # Hiccup Format Demo
(require '[nextjournal.clerk :as clerk]
         '[nextjournal.clerk.viewer :as v]
         '[clojure.walk :as walk])

(def data
  [:div
   [:h2 "plot 1"]
   ['vega {:width 650 :height 400 :data {:url "https://vega.github.io/vega-datasets/data/us-10m.json"
                                         :format {:type "topojson" :feature "counties"}}
           :transform [{:lookup "id" :from {:data {:url "https://vega.github.io/vega-datasets/data/unemployment.tsv"}
                                            :key "id" :fields ["rate"]}}]
           :projection {:type "albersUsa"} :mark "geoshape" :encoding {:color {:field "rate" :type "quantitative"}}}]
   [:h2 "plot 2"]
   ['plotly {:data [{:z [[1 2 3] [3 2 1]]
                     :type "surface"}]}]])



(clerk/with-viewer
  (fn [hiccup]
    (let [symbols->viewers {'plotly :plotly
                            'vega :vega-lite}
          vectors->viewers (fn [x]
                             (if (and (vector? x)
                                      (= 2 (count x))
                                      (symbols->viewers (first x)))
                               [v/inspect (v/with-viewer (symbols->viewers (first x)) (second x))]
                               x))]
      (v/with-viewer :reagent (clojure.walk/postwalk vectors->viewers hiccup))))
  data)







