(ns scicloj.notespace.v4.frontend.goldsmith.server
  (:require [goldly.app]))


(goldly.app/goldly-server-run!
 '{:profile "jetty"
   :config {:timbre-loglevel
            [[#{"pinkgorilla.nrepl.*"} :warn]
             [#{"org.eclipse.jetty.*"} :warn]
             [#{"webly.*"} :info]
             [#{"goldly.service.*"} :warn]
             [#{"*"} :info]]
            :goldly { ;; :autoload-clj-ns [fortune-cookie]
                     :autoload-cljs-dir ["src/page"]
                     :routes {:app {"" :user/main
                                        ; user
                                    ;; "bmi" :user/bmi
                                    ;; "fortune" :user/fortune
                                    ;; "iss" :user/iss
                                    ;; "vega" :user/vega
                                    ;; "daniel" :user/daniel
                                    ;; "aggrid" :user/aggrid

                                    ;;     ; will go to goldly dev tools
                                    "artefacts" :user/artefact
                                    "about" :user/about

                                        ; devtools
                                    "devtools/pages" :pages
                                    "devtools/help" :devtools
                                    "devtools/scratchpad" :scratchpad
                                    "devtools/viewer" :viewer
                                    "devtools/environment" :environment}}}

            :devtools {:rdocument  {:storage-root "rdocument/"
                                    :url-root "/api/rdocument/file/"}
                       :collections {:my-notebooks [:clj "notebook/"]
                                     :demo [:clj "demo/notebook/"]}}}})
