(ns scicloj.notespace.v4.frontend.clerk
  (:require [scicloj.notespace.v4.frontend.protocol :as prot]
            [nextjournal.clerk.webserver :as webserver]
            [nextjournal.clerk :as clerk]
            [nextjournal.clerk.viewer :as v]
            [clojure.java.browse :as browse]
            [clojure.walk :as walk]))

(comment
  (require '[scicloj.notespace.v4.api :as notespace])
  (notespace/restart!))

(reset! webserver/!doc
        [{:type :markdown :text "Notespace is ready."}])

(defn view-by-pinkie-tags [extended-hiccup]
  (clerk/with-viewer
    (fn [hiccup]
      (let [vector-of? (fn [k x] (and (vector? x)
                                      (= k (count x))))
            pinkie-tag? (fn [x]
                          (and (keyword? x)
                               (-> x namespace (= "p"))))
            unpinkie (fn [pinkie-tag]
                       (-> pinkie-tag
                           name
                           keyword))
            vectors->viewers (fn [x]
                               (or (when (vector-of? 2 x)
                                     (let [fx (first x)
                                           sx (second x)]
                                       (when (pinkie-tag? fx)
                                         [v/inspect (v/with-viewer (unpinkie fx)
                                                      (cond ;;
                                                        (= fx :p/code)
                                                        (if (map? sx) (:code sx) sx)
                                                        ;;
                                                        :else
                                                        sx))])))
                                   x))]
        (v/with-viewer :reagent
          (clojure.walk/postwalk vectors->viewers hiccup))))
    extended-hiccup))

(defn sync-widgets! [id-fn widget-fn widgets-data]
  (when-not @webserver/!doc
    (reset! webserver/!doc []))
  (when-not (meta @webserver/!doc)
    (swap! webserver/!doc with-meta {}))
  (swap! webserver/!doc vary-meta assoc :ns *ns*)
  (let [id->widget (meta @webserver/!doc)
        datum->id (comp str id-fn)]
    (doseq [datum widgets-data]
      (let [id (datum->id datum)]
        (when-not (id->widget id)
          (let [widget (-> datum
                           widget-fn
                           view-by-pinkie-tags)]
            (swap! webserver/!doc
                   vary-meta
                   assoc id widget)))))
    (webserver/broadcast!
     {:nextjournal/viewer :clerk/notebook
      :nextjournal/value  (->> widgets-data
                               (mapv (fn [datum]
                                      {:nextjournal/viewer :clerk/result
                                        :nextjournal/value  {:blob-id (datum->id datum)}})))})))




(deftype ClerkFrontend []

  prot/Frontend

  (start! [this options]
    (webserver/start! options))

  (stop! [this server])

  (reset-header! [this header])

  (sync-widgets! [this id-fn widget-fn widgets-data]
    (sync-widgets! id-fn widget-fn widgets-data))

  (browse! [this])

  (render-as-html! [this html-path]))



