(ns tablecloth.api.missing
  (:require [tech.ml.dataset :as ds]
            
            [tablecloth.api.utils :refer [column-names]]
            [tablecloth.api.columns :refer [select-columns]]
            [tablecloth.api.group-by :refer [grouped? process-group-data]]))

(defn- select-or-drop-missing
  "Select rows with missing values"
  ([f ds] (select-or-drop-missing f ds nil))
  ([f ds columns-selector]
   (if (grouped? ds)
     (process-group-data ds #(select-or-drop-missing f % columns-selector))

     (let [ds- (if columns-selector
                 (select-columns ds columns-selector)
                 ds)]
       (f ds (ds/missing ds-))))))

(defn- select-or-drop-missing-docstring
  [op]
  (str op " rows with missing values

 `columns-selector` selects columns to look at missing values"))

(def ^{:doc (select-or-drop-missing-docstring "Select")}
  select-missing (partial select-or-drop-missing ds/select-rows))

(def ^{:doc (select-or-drop-missing-docstring "Drop")}
  drop-missing (partial select-or-drop-missing ds/drop-rows))

(defn replace-missing
  ([ds] (replace-missing ds :mid))
  ([ds strategy] (replace-missing ds :all strategy))
  ([ds columns-selector strategy] (replace-missing ds columns-selector strategy nil))
  ([ds columns-selector strategy value]

   (if (grouped? ds)

     (process-group-data ds #(replace-missing % columns-selector value strategy))
     
     (let [cols (column-names ds columns-selector)]
       (ds/replace-missing ds cols strategy value)))))

(defn fill-range-replace
  ([ds colname max-span] (fill-range-replace ds colname max-span :down))
  ([ds colname max-span missing-strategy] (fill-range-replace ds colname max-span missing-strategy nil))
  ([ds colname max-span missing-strategy missing-value]
   (if (grouped? ds)
     (process-group-data ds #(fill-range-replace % colname max-span missing-strategy missing-value))
     (ds/fill-range-replace ds colname max-span missing-strategy missing-value))))


