(ns tablecloth.api
  ;;Autogenerated from tablecloth.api.api-template-- DO NOT EDIT
  "Tablecloth API"
  (:require [tablecloth.api.api-template]
            [tablecloth.api.aggregate]
            [tablecloth.api.columns]
            [tablecloth.api.dataset]
            [tablecloth.api.fold-unroll]
            [tablecloth.api.group-by]
            [tablecloth.api.join-concat-ds]
            [tablecloth.api.join-separate]
            [tablecloth.api.missing]
            [tablecloth.api.operators]
            [tablecloth.api.order-by]
            [tablecloth.api.reshape]
            [tablecloth.api.rows]
            [tablecloth.api.split]
            [tablecloth.api.unique-by]
            [tablecloth.api.utils]
            [tech.v3.dataset]
            [tech.v3.dataset.print]
            [tech.v3.datatype])
  (:refer-clojure :exclude [group-by drop concat rand-nth first last shuffle * + - / < <= >= > abs and bit-and bit-and-not bit-clear bit-flip bit-not bit-or bit-set bit-shift-left bit-shift-right bit-xor even? identity infinite? max min neg? not odd? or pos? quot rem unsigned-bit-shift-right zero?]))

(defn *
  "Applies the operation tablecloth.column.api.operators/* to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/* ds target-col columns-selector)))


(defn +
  "Applies the operation tablecloth.column.api.operators/+ to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/+ ds target-col columns-selector)))


(defn -
  "Applies the operation tablecloth.column.api.operators/- to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/- ds target-col columns-selector)))


(defn ->array
  "Convert numerical column(s) to java array"
  ([ds colname]
  (tablecloth.api.columns/->array ds colname))
  ([ds colname datatype]
  (tablecloth.api.columns/->array ds colname datatype)))


(defn /
  "Applies the operation tablecloth.column.api.operators// to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators// ds target-col columns-selector)))


(defn <
  "Applies the operation tablecloth.column.api.operators/< to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 3 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/< ds target-col columns-selector)))


(defn <=
  "Applies the operation tablecloth.column.api.operators/<= to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 3 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/<= ds target-col columns-selector)))


(defn >
  "Applies the operation tablecloth.column.api.operators/> to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 3 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/> ds target-col columns-selector)))


(defn >=
  "Applies the operation tablecloth.column.api.operators/>= to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 3 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/>= ds target-col columns-selector)))


(defn abs
  "Applies the operation tablecloth.column.api.operators/abs to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/abs ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/abs ds target-col columns-selector)))


(defn acos
  "Applies the operation tablecloth.column.api.operators/acos to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/acos ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/acos ds target-col columns-selector)))


(defn add-column
  "Add or update (modify) column under `column-name`.

  `column` can be sequence of values or generator function (which gets `ds` as input).

  * `ds` - a dataset
  * `column-name` - if it's existing column name, column will be replaced
  * `column` - can be column (from other dataset), sequence, single value or function (taking a dataset). Too big columns are always trimmed. Too small are cycled or extended with missing values (according to `size-strategy` argument)
  * `size-strategy` (optional) - when new column is shorter than dataset row count, following strategies are applied:
    - `:cycle` - repeat data
    - `:na` - append missing values
    - `:strict` - (default) throws an exception when sizes mismatch"
  ([ds column-name column]
  (tablecloth.api.columns/add-column ds column-name column))
  ([ds column-name column size-strategy]
  (tablecloth.api.columns/add-column ds column-name column size-strategy)))


(defn add-columns
  "Add or updade (modify) columns defined in `columns-map` (mapping: name -> column) "
  ([ds columns-map]
  (tablecloth.api.columns/add-columns ds columns-map))
  ([ds columns-map size-strategy]
  (tablecloth.api.columns/add-columns ds columns-map size-strategy)))


(defn add-or-replace-column
  ([ds column-name column]
  (tablecloth.api.columns/add-or-replace-column ds column-name column))
  ([ds column-name column size-strategy]
  (tablecloth.api.columns/add-or-replace-column ds column-name column size-strategy)))


(defn add-or-replace-columns
  ([ds columns-map]
  (tablecloth.api.columns/add-or-replace-columns ds columns-map))
  ([ds columns-map size-strategy]
  (tablecloth.api.columns/add-or-replace-columns ds columns-map size-strategy)))


(defn aggregate
  "Aggregate dataset by providing:

  - aggregation function
  - map with column names and functions
  - sequence of aggregation functions

  Aggregation functions can return:
  - single value
  - seq of values
  - map of values with column names"
  ([ds aggregator]
  (tablecloth.api.aggregate/aggregate ds aggregator))
  ([ds aggregator options]
  (tablecloth.api.aggregate/aggregate ds aggregator options)))


(defn aggregate-columns
  "Aggregates each column separately"
  ([ds columns-aggregators]
  (tablecloth.api.aggregate/aggregate-columns ds columns-aggregators))
  ([ds columns-selector column-aggregators]
  (tablecloth.api.aggregate/aggregate-columns ds columns-selector column-aggregators))
  ([ds columns-selector column-aggregators options]
  (tablecloth.api.aggregate/aggregate-columns ds columns-selector column-aggregators options)))


(defn and
  "Applies the operation tablecloth.column.api.operators/and to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 2 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/and ds target-col columns-selector)))


(defn anti-join
  ([ds-left ds-right columns-selector]
  (tablecloth.api.join-concat-ds/anti-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api.join-concat-ds/anti-join ds-left ds-right columns-selector options)))


(defn append
  "Concats columns of several datasets"
  ([ds & args]
  (apply tablecloth.api.join-concat-ds/append ds args)))


(defn array-column->columns
  "Converts a column of type java array into several columns,
  one for each element of the array of all rows. The source column is dropped afterwards.
  The function assumes that arrays in all rows have same type and length and are numeric.

  `ds` Datset to operate on.
  `src-column` The (array) column to convert
  `opts` can contain:
    `prefix` newly created column will get prefix before column number
  "
  ([ds src-column opts]
  (tablecloth.api.join-separate/array-column->columns ds src-column opts))
  ([ds src-column]
  (tablecloth.api.join-separate/array-column->columns ds src-column)))


(defn as-regular-dataset
  "Remove grouping tag"
  ([ds]
  (tablecloth.api.utils/as-regular-dataset ds)))


(defn asin
  "Applies the operation tablecloth.column.api.operators/asin to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/asin ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/asin ds target-col columns-selector)))


(defn asof-join
  ([ds-left ds-right columns-selector]
  (tablecloth.api.join-concat-ds/asof-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api.join-concat-ds/asof-join ds-left ds-right columns-selector options)))


(defn atan
  "Applies the operation tablecloth.column.api.operators/atan to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/atan ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/atan ds target-col columns-selector)))


(defn atan2
  "Applies the operation tablecloth.column.api.operators/atan2 to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/atan2 ds target-col columns-selector)))


(defn bind
  ([ds & args]
  (apply tablecloth.api.join-concat-ds/bind ds args)))


(defn bit-and
  "Applies the operation tablecloth.column.api.operators/bit-and to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/bit-and ds target-col columns-selector)))


(defn bit-and-not
  "Applies the operation tablecloth.column.api.operators/bit-and-not to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/bit-and-not ds target-col columns-selector)))


(defn bit-clear
  "Applies the operation tablecloth.column.api.operators/bit-clear to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/bit-clear ds target-col columns-selector)))


(defn bit-flip
  "Applies the operation tablecloth.column.api.operators/bit-flip to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/bit-flip ds target-col columns-selector)))


(defn bit-not
  "Applies the operation tablecloth.column.api.operators/bit-not to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/bit-not ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/bit-not ds target-col columns-selector)))


(defn bit-or
  "Applies the operation tablecloth.column.api.operators/bit-or to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/bit-or ds target-col columns-selector)))


(defn bit-set
  "Applies the operation tablecloth.column.api.operators/bit-set to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/bit-set ds target-col columns-selector)))


(defn bit-shift-left
  "Applies the operation tablecloth.column.api.operators/bit-shift-left to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/bit-shift-left ds target-col columns-selector)))


(defn bit-shift-right
  "Applies the operation tablecloth.column.api.operators/bit-shift-right to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/bit-shift-right ds target-col columns-selector)))


(defn bit-xor
  "Applies the operation tablecloth.column.api.operators/bit-xor to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/bit-xor ds target-col columns-selector)))


(defn by-rank
  "Select rows using `rank` on a column, ties are resolved using `:dense` method.

  See [R docs](https://www.rdocumentation.org/packages/base/versions/3.6.1/topics/rank).
  Rank uses 0 based indexing.
  
  Possible `:ties` strategies: `:average`, `:first`, `:last`, `:random`, `:min`, `:max`, `:dense`.
  `:dense` is the same as in `data.table::frank` from R

  `:desc?` set to true (default) order descending before calculating rank"
  ([ds columns-selector rank-predicate]
  (tablecloth.api.rows/by-rank ds columns-selector rank-predicate))
  ([ds columns-selector rank-predicate options]
  (tablecloth.api.rows/by-rank ds columns-selector rank-predicate options)))


(defn cbrt
  "Applies the operation tablecloth.column.api.operators/cbrt to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/cbrt ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/cbrt ds target-col columns-selector)))


(defn ceil
  "Applies the operation tablecloth.column.api.operators/ceil to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/ceil ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/ceil ds target-col columns-selector)))


(defn clone
  "Clone an object.  Can clone anything convertible to a reader."
  ([item]
  (tech.v3.datatype/clone item)))


(defn column
  ([dataset colname]
  (tech.v3.dataset/column dataset colname)))


(defn column-count
  (^{:tag long} [dataset]
  (tech.v3.dataset/column-count dataset)))


(defn column-names
  "Returns column names, given a selector.
  Columns-selector can be one of the following:

  * :all keyword - selects all columns
  * column name - for single column
  * sequence of column names - for collection of columns
  * regex - to apply pattern on column names or datatype
  * filter predicate - to filter column names or datatype
  * type namespaced keyword for specific datatype or group of datatypes

  Column name can be anything.

column-names function returns names according to columns-selector
  and optional meta-field. meta-field is one of the following:

  * `:name` (default) - to operate on column names
  * `:datatype` - to operated on column types
  * `:all` - if you want to process all metadata

  Datatype groups are:

  * `:type/numerical` - any numerical type
  * `:type/float` - floating point number (:float32 and :float64)
  * `:type/integer` - any integer
  * `:type/datetime` - any datetime type

  If qualified keyword starts with :!type, complement set is used.


  "
  ([ds]
  (tablecloth.api.utils/column-names ds))
  ([ds columns-selector]
  (tablecloth.api.utils/column-names ds columns-selector))
  ([ds columns-selector meta-field]
  (tablecloth.api.utils/column-names ds columns-selector meta-field)))


(defn columns
  "Returns columns of dataset. Result type can be any of:
  * `:as-map`
  * `:as-double-arrays`
  * `:as-seqs`
  "
  ([ds]
  (tablecloth.api.dataset/columns ds))
  ([ds result-type]
  (tablecloth.api.dataset/columns ds result-type)))


(defn columns->array-column
  "Converts several columns to a single column of type array.
   The src columns are dropped afterwards.

  `ds` Dataset to operate on.
  `column-selector` anything supported by [[select-columns]]
  `new-column` new column to create
  "
  ([ds column-selector new-column]
  (tablecloth.api.join-separate/columns->array-column ds column-selector new-column)))


(defn complete
  "TidyR complete.

  Fills a dataset with all possible combinations of selected columns. When a given combination doesn't exist, missing values are created."
  ([ds columns-selector & args]
  (apply tablecloth.api.join-concat-ds/complete ds columns-selector args)))


(defn concat
  "Joins rows from other datasets"
  ([dataset & args]
  (apply tablecloth.api.dataset/concat dataset args)))


(defn concat-copying
  "Joins rows from other datasets via a copy of data"
  ([dataset & args]
  (apply tablecloth.api.dataset/concat-copying dataset args)))


(defn convert-types
  "Convert type of the column to the other type."
  ([ds coltype-map-or-columns-selector]
  (tablecloth.api.columns/convert-types ds coltype-map-or-columns-selector))
  ([ds columns-selector new-types]
  (tablecloth.api.columns/convert-types ds columns-selector new-types)))


(defn cos
  "Applies the operation tablecloth.column.api.operators/cos to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/cos ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/cos ds target-col columns-selector)))


(defn cosh
  "Applies the operation tablecloth.column.api.operators/cosh to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/cosh ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/cosh ds target-col columns-selector)))


(defn cross-join
  "Cross product from selected columns"
  ([ds-left ds-right]
  (tablecloth.api.join-concat-ds/cross-join ds-left ds-right))
  ([ds-left ds-right columns-selector]
  (tablecloth.api.join-concat-ds/cross-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api.join-concat-ds/cross-join ds-left ds-right columns-selector options)))


(defn crosstab
  "Cross tabulation of two sets of columns.

  Creates grouped dataset by [row-selector, col-selector] pairs and calls aggregation on each group.

  Options:

  * pivot? - create pivot table or just flat structure (default: true)
  * replace-missing? - replace missing values? (default: true)
  * missing-value - a missing value (default: 0)
  * aggregator - aggregating function (default: row-count)
  * marginal-rows, marginal-cols - adds row and/or cols, it's a sum if true. Can be a custom fn."
  ([ds row-selector col-selector]
  (tablecloth.api.aggregate/crosstab ds row-selector col-selector))
  ([ds row-selector col-selector options]
  (tablecloth.api.aggregate/crosstab ds row-selector col-selector options)))


(defn cummax
  "Applies the operation tablecloth.column.api.operators/cummax to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/cummax ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/cummax ds target-col columns-selector)))


(defn cummin
  "Applies the operation tablecloth.column.api.operators/cummin to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/cummin ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/cummin ds target-col columns-selector)))


(defn cumprod
  "Applies the operation tablecloth.column.api.operators/cumprod to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/cumprod ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/cumprod ds target-col columns-selector)))


(defn cumsum
  "Applies the operation tablecloth.column.api.operators/cumsum to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/cumsum ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/cumsum ds target-col columns-selector)))


(defn dataset
  "Create a `dataset`.

  Dataset can be created from:

  * map of values and/or sequences
  * sequence of maps
  * sequence of columns
  * file or url
  * array of arrays
  * single value

  Single value is set only when it's not possible to find a path for given data. If tech.ml.dataset throws an exception, it's won;t be printed. To print a stack trace, set `stack-trace?` option to `true`.

  ds/->dataset documentation:

  Create a dataset from either csv/tsv or a sequence of maps.

   * A `String` be interpreted as a file (or gzipped file if it
     ends with .gz) of tsv or csv data.  The system will attempt to autodetect if this
     is csv or tsv and then engineering around detecting datatypes all of which can
     be overridden.

  * InputStreams have no file type and thus a `file-type` must be provided in the
    options.

  * A sequence of maps may be passed in in which case the first N maps are scanned in
    order to derive the column datatypes before the actual columns are created.

  Parquet, xlsx, and xls formats require that you require the appropriate libraries
  which are `tech.v3.libs.parquet` for parquet, `tech.v3.libs.fastexcel` for xlsx,
  and `tech.v3.libs.poi` for xls.


  Arrow support is provided via the tech.v3.libs.Arrow namespace not via a file-type
  overload as the Arrow project current has 3 different file types and it is not clear
  what their final suffix will be or which of the three file types it will indicate.
  Please see documentation in the `tech.v3.libs.arrow` namespace for further information
  on Arrow file types.

  Options:

  - `:dataset-name` - set the name of the dataset.
  - `:file-type` - Override filetype discovery mechanism for strings or force a particular
      parser for an input stream.  Note that parquet must have paths on disk
      and cannot currently load from input stream.  Acceptible file types are:
      #{:csv :tsv :xlsx :xls :parquet}.
  - `:gzipped?` - for file formats that support it, override autodetection and force
     creation of a gzipped input stream as opposed to a normal input stream.
  - `:column-allowlist` - either sequence of string column names or sequence of column
     indices of columns to allowlist. This is preferred to `:column-whitelist`
  - `:column-blocklist` - either sequence of string column names or sequence of column
     indices of columns to blocklist. This is preferred to `:column-blacklist`
  - `:num-rows` - Number of rows to read
  - `:header-row?` - Defaults to true, indicates the first row is a header.
  - `:key-fn` - function to be applied to column names.  Typical use is:
     `:key-fn keyword`.
  - `:separator` - Add a character separator to the list of separators to auto-detect.
  - `:csv-parser` - Implementation of univocity's AbstractParser to use.  If not
     provided a default permissive parser is used.  This way you parse anything that
     univocity supports (so flat files and such).
  - `:bad-row-policy` - One of three options: :skip, :error, :carry-on.  Defaults to
     :carry-on.  Some csv data has ragged rows and in this case we have several
     options. If the option is :carry-on then we either create a new column or add
     missing values for columns that had no data for that row.
  - `:skip-bad-rows?` - Legacy option.  Use :bad-row-policy.
  - `:disable-comment-skipping?` - As default, the `#` character is recognised as a
     line comment when found in the beginning of a line of text in a CSV file,
     and the row will be ignored. Set `true` to disable this behavior.
  - `:max-chars-per-column` - Defaults to 4096.  Columns with more characters that this
     will result in an exception.
  - `:max-num-columns` - Defaults to 8192.  CSV,TSV files with more columns than this
     will fail to parse.  For more information on this option, please visit:
     https://github.com/uniVocity/univocity-parsers/issues/301
  - `:text-temp-dir` - The temporary directory to use for file-backed text.  Setting
    this value to boolean 'false' turns off file backed text which is the default.  If a
    tech.v3.resource stack context is opened the file will be deleted when the context
    closes else it will be deleted when the gc cleans up the dataset.  A shutdown hook is
    added as a last resort to ensure the file is cleaned up.
  - `:n-initial-skip-rows` - Skip N rows initially.  This currently may include the
     header row.  Works across both csv and spreadsheet datasets.
  - `:parser-type` - Default parser to use if no parser-fn is specified for that column.
     For csv files, the default parser type is `:string` which indicates a promotional
     string parser.  For sequences of maps, the default parser type is :object.  It can
     be useful in some contexts to use the `:string` parser with sequences of maps or
     maps of columns.
  - `:parser-fn` -
      - `keyword?` - all columns parsed to this datatype. For example:
        `{:parser-fn :string}`
      - `map?` - `{column-name parse-method}` parse each column with specified
        `parse-method`.
        The `parse-method` can be:
          - `keyword?` - parse the specified column to this datatype. For example:
            `{:parser-fn {:answer :boolean :id :int32}}`
          - tuple - pair of `[datatype parse-data]` in which case container of type
            `[datatype]` will be created. `parse-data` can be one of:
              - `:relaxed?` - data will be parsed such that parse failures of the standard
                 parse functions do not stop the parsing process.  :unparsed-values and
                 :unparsed-indexes are available in the metadata of the column that tell
                 you the values that failed to parse and their respective indexes.
              - `fn?` - function from str-> one of `:tech.v3.dataset/missing`,
                 `:tech.v3.dataset/parse-failure`, or the parsed value.
                 Exceptions here always kill the parse process.  :missing will get marked
                 in the missing indexes, and :parse-failure will result in the index being
                 added to missing, the unparsed the column's :unparsed-values and
                 :unparsed-indexes will be updated.
              - `string?` - for datetime types, this will turned into a DateTimeFormatter via
                 DateTimeFormatter/ofPattern.  For `:text` you can specify the backing file
                 to use.
              - `DateTimeFormatter` - use with the appropriate temporal parse static function
                 to parse the value.

   - `map?` - the header-name-or-idx is used to lookup value.  If not nil, then
           value can be any of the above options.  Else the default column parser
           is used.

  Returns a new dataset"
  ([]
  (tablecloth.api.dataset/dataset ))
  ([data]
  (tablecloth.api.dataset/dataset data))
  ([data options]
  (tablecloth.api.dataset/dataset data options)))


(defn dataset->str
  "Convert a dataset to a string.  Prints a single line header and then calls
  dataset-data->str.

  For options documentation see dataset-data->str."
  ([ds options]
  (tech.v3.dataset.print/dataset->str ds options))
  ([ds]
  (tech.v3.dataset.print/dataset->str ds)))


(defn dataset-name
  ([dataset]
  (tech.v3.dataset/dataset-name dataset)))


(defn dataset?
  "Is `ds` a `dataset` type?"
  ([ds]
  (tablecloth.api.dataset/dataset? ds)))


(defn difference
  ([ds-left ds-right]
  (tablecloth.api.join-concat-ds/difference ds-left ds-right))
  ([ds-left ds-right options]
  (tablecloth.api.join-concat-ds/difference ds-left ds-right options)))


(defn distance
  "Applies the operation tablecloth.column.api.operators/distance to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 2 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector]
  (tablecloth.api.operators/distance ds columns-selector)))


(defn distance-squared
  "Applies the operation tablecloth.column.api.operators/distance-squared to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 2 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector]
  (tablecloth.api.operators/distance-squared ds columns-selector)))


(defn dot-product
  "Applies the operation tablecloth.column.api.operators/dot-product to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 2 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector]
  (tablecloth.api.operators/dot-product ds columns-selector)))


(defn drop
  "Drop columns and rows."
  ([ds columns-selector rows-selector]
  (tablecloth.api.api-template/drop ds columns-selector rows-selector)))


(defn drop-columns
  "Drop columns by (returns dataset):

  - name
  - sequence of names
  - map of names with new names (rename)
  - function which filter names (via column metadata)"
  ([ds]
  (tablecloth.api.columns/drop-columns ds))
  ([ds columns-selector]
  (tablecloth.api.columns/drop-columns ds columns-selector))
  ([ds columns-selector meta-field]
  (tablecloth.api.columns/drop-columns ds columns-selector meta-field)))


(defn drop-missing
  "Drop rows with missing values

 `columns-selector` selects columns to look at missing values"
  ([ds]
  (tablecloth.api.missing/drop-missing ds))
  ([ds columns-selector]
  (tablecloth.api.missing/drop-missing ds columns-selector)))


(defn drop-rows
  "Drop rows using:

  - row id
  - seq of row ids
  - seq of true/false
  - fn with predicate"
  ([ds]
  (tablecloth.api.rows/drop-rows ds))
  ([ds rows-selector]
  (tablecloth.api.rows/drop-rows ds rows-selector))
  ([ds rows-selector options]
  (tablecloth.api.rows/drop-rows ds rows-selector options)))


(defn empty-ds?
  ([ds]
  (tablecloth.api.dataset/empty-ds? ds)))


(defn eq
  "Applies the operation tablecloth.column.api.operators/eq to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 2 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/eq ds target-col columns-selector)))


(defn even?
  "Applies the operation tablecloth.column.api.operators/even? to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/even? ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/even? ds target-col columns-selector)))


(defn exp
  "Applies the operation tablecloth.column.api.operators/exp to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/exp ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/exp ds target-col columns-selector)))


(defn expand
  "TidyR expand.

  Creates all possible combinations of selected columns."
  ([ds columns-selector & args]
  (apply tablecloth.api.join-concat-ds/expand ds columns-selector args)))


(defn expm1
  "Applies the operation tablecloth.column.api.operators/expm1 to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/expm1 ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/expm1 ds target-col columns-selector)))


(defn fill-range-replace
  "Fill missing up with lacking values. Accepts
  * dataset
  * column name
  * expected step (max-span, milliseconds in case of datetime column)
  * (optional) missing-strategy - how to replace missing, default :down (set to nil if none)
  * (optional) missing-value - optional value for replace missing
"
  ([ds colname max-span]
  (tablecloth.api.missing/fill-range-replace ds colname max-span))
  ([ds colname max-span missing-strategy]
  (tablecloth.api.missing/fill-range-replace ds colname max-span missing-strategy))
  ([ds colname max-span missing-strategy missing-value]
  (tablecloth.api.missing/fill-range-replace ds colname max-span missing-strategy missing-value)))


(defn finite?
  "Applies the operation tablecloth.column.api.operators/finite? to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/finite? ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/finite? ds target-col columns-selector)))


(defn first
  "First row"
  ([ds]
  (tablecloth.api.rows/first ds)))


(defn floor
  "Applies the operation tablecloth.column.api.operators/floor to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/floor ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/floor ds target-col columns-selector)))


(defn fold-by
  "Group-by and pack columns into vector - the output data set has a row for each unique combination
  of the provided columns while each remaining column has its valu(es) collected into a vector, similar
  to how clojure.core/group-by works.
  See https://scicloj.github.io/tablecloth/index.html#Fold-by"
  ([ds columns-selector]
  (tablecloth.api.fold-unroll/fold-by ds columns-selector))
  ([ds columns-selector folding-function]
  (tablecloth.api.fold-unroll/fold-by ds columns-selector folding-function)))


(defn full-join
  "Join keeping all rows"
  ([ds-left ds-right columns-selector]
  (tablecloth.api.join-concat-ds/full-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api.join-concat-ds/full-join ds-left ds-right columns-selector options)))


(defn get-entry
  "Returns a single value from given column and row"
  ([ds column row]
  (tablecloth.api.dataset/get-entry ds column row)))


(defn get-significand
  "Applies the operation tablecloth.column.api.operators/get-significand to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/get-significand ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/get-significand ds target-col columns-selector)))


(defn group-by
  "Group dataset by:

  - column name
  - list of columns
  - map of keys and row indexes
  - function getting map of values

  Options are:

  - select-keys - when grouping is done by function, you can limit fields to a `select-keys` seq.
  - result-type - return results as dataset (`:as-dataset`, default) or as map of datasets (`:as-map`) or as map of row indexes (`:as-indexes`) or as sequence of (sub)datasets
  - other parameters which are passed to `dataset` fn

  When dataset is returned, meta contains `:grouped?` set to true. Columns in dataset:

  - name - group name
  - group-id - id of the group (int)
  - data - group as dataset"
  ([ds grouping-selector]
  (tablecloth.api.group-by/group-by ds grouping-selector))
  ([ds grouping-selector options]
  (tablecloth.api.group-by/group-by ds grouping-selector options)))


(defn grouped?
  "Is `dataset` represents grouped dataset (result of `group-by`)?"
  ([ds]
  (tablecloth.api.utils/grouped? ds)))


(defn groups->map
  "Convert grouped dataset to the map of groups"
  ([ds]
  (tablecloth.api.group-by/groups->map ds)))


(defn groups->seq
  "Convert grouped dataset to seq of the groups"
  ([ds]
  (tablecloth.api.group-by/groups->seq ds)))


(defn has-column?
  ([dataset column-name]
  (tech.v3.dataset/has-column? dataset column-name)))


(defn head
  "First n rows (default 5)"
  ([ds]
  (tablecloth.api.rows/head ds))
  ([ds n]
  (tablecloth.api.rows/head ds n)))


(defn hypot
  "Applies the operation tablecloth.column.api.operators/hypot to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/hypot ds target-col columns-selector)))


(defn identity
  "Applies the operation tablecloth.column.api.operators/identity to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/identity ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/identity ds target-col columns-selector)))


(defn ieee-remainder
  "Applies the operation tablecloth.column.api.operators/ieee-remainder to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/ieee-remainder ds target-col columns-selector)))


(defn infinite?
  "Applies the operation tablecloth.column.api.operators/infinite? to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/infinite? ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/infinite? ds target-col columns-selector)))


(defn info
  "Returns a statistcial information about the columns of a dataset.
  `result-type ` can be :descriptive or :columns"
  ([ds]
  (tablecloth.api.dataset/info ds))
  ([ds result-type]
  (tablecloth.api.dataset/info ds result-type)))


(defn inner-join
  ([ds-left ds-right columns-selector]
  (tablecloth.api.join-concat-ds/inner-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api.join-concat-ds/inner-join ds-left ds-right columns-selector options)))


(defn intersect
  ([ds-left ds-right]
  (tablecloth.api.join-concat-ds/intersect ds-left ds-right))
  ([ds-left ds-right options]
  (tablecloth.api.join-concat-ds/intersect ds-left ds-right options)))


(defn join-columns
  "Join clumns of dataset. Accepts:
  dataset
  column selector (as in select-columns)
  options
  `:separator` (default \"-\")
  `:drop-columns?` - whether to drop source columns or not (default true)
  `:result-type`
     `:map` - packs data into map
     `:seq` - packs data into sequence
     `:string` - join strings with separator (default)
     or custom function which gets row as a vector
  `:missing-subst` - substitution for missing value"
  ([ds target-column columns-selector]
  (tablecloth.api.join-separate/join-columns ds target-column columns-selector))
  ([ds target-column columns-selector conf]
  (tablecloth.api.join-separate/join-columns ds target-column columns-selector conf)))


(defn kurtosis
  "Applies the operation tablecloth.column.api.operators/kurtosis to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector options]
  (tablecloth.api.operators/kurtosis ds columns-selector options))
  ([ds columns-selector]
  (tablecloth.api.operators/kurtosis ds columns-selector)))


(defn last
  "Last row"
  ([ds]
  (tablecloth.api.rows/last ds)))


(defn left-join
  ([ds-left ds-right columns-selector]
  (tablecloth.api.join-concat-ds/left-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api.join-concat-ds/left-join ds-left ds-right columns-selector options)))


(defmacro let-dataset
  ([bindings]
  `(tablecloth.api.api-template/let-dataset ~bindings))
  ([bindings options]
  `(tablecloth.api.api-template/let-dataset ~bindings ~options)))


(defn log
  "Applies the operation tablecloth.column.api.operators/log to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/log ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/log ds target-col columns-selector)))


(defn log10
  "Applies the operation tablecloth.column.api.operators/log10 to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/log10 ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/log10 ds target-col columns-selector)))


(defn log1p
  "Applies the operation tablecloth.column.api.operators/log1p to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/log1p ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/log1p ds target-col columns-selector)))


(defn logistic
  "Applies the operation tablecloth.column.api.operators/logistic to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/logistic ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/logistic ds target-col columns-selector)))


(defn magnitude
  "Applies the operation tablecloth.column.api.operators/magnitude to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector]
  (tablecloth.api.operators/magnitude ds columns-selector)))


(defn magnitude-squared
  "Applies the operation tablecloth.column.api.operators/magnitude-squared to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector]
  (tablecloth.api.operators/magnitude-squared ds columns-selector)))


(defn map-columns
  "Map over rows using a map function. The arity should match the columns selected."
  ([ds column-name map-fn]
  (tablecloth.api.columns/map-columns ds column-name map-fn))
  ([ds column-name columns-selector map-fn]
  (tablecloth.api.columns/map-columns ds column-name columns-selector map-fn))
  ([ds column-name new-type columns-selector map-fn]
  (tablecloth.api.columns/map-columns ds column-name new-type columns-selector map-fn)))


(defn map-rows
  "Map a function across the rows of the dataset producing a new dataset that is merged back into the original potentially replacing existing columns."
  ([ds map-fn]
  (tablecloth.api.rows/map-rows ds map-fn))
  ([ds map-fn options]
  (tablecloth.api.rows/map-rows ds map-fn options)))


(defn mark-as-group
  "Add grouping tag"
  ([ds]
  (tablecloth.api.utils/mark-as-group ds)))


(defn mathematical-integer?
  "Applies the operation tablecloth.column.api.operators/mathematical-integer? to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/mathematical-integer? ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/mathematical-integer? ds target-col columns-selector)))


(defn max
  "Applies the operation tablecloth.column.api.operators/max to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/max ds target-col columns-selector)))


(defn mean
  "Applies the operation tablecloth.column.api.operators/mean to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector options]
  (tablecloth.api.operators/mean ds columns-selector options))
  ([ds columns-selector]
  (tablecloth.api.operators/mean ds columns-selector)))


(defn mean-fast
  "Applies the operation tablecloth.column.api.operators/mean-fast to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector]
  (tablecloth.api.operators/mean-fast ds columns-selector)))


(defn median
  "Applies the operation tablecloth.column.api.operators/median to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector options]
  (tablecloth.api.operators/median ds columns-selector options))
  ([ds columns-selector]
  (tablecloth.api.operators/median ds columns-selector)))


(defn min
  "Applies the operation tablecloth.column.api.operators/min to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/min ds target-col columns-selector)))


(defn nan?
  "Applies the operation tablecloth.column.api.operators/nan? to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/nan? ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/nan? ds target-col columns-selector)))


(defn neg?
  "Applies the operation tablecloth.column.api.operators/neg? to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/neg? ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/neg? ds target-col columns-selector)))


(defn next-down
  "Applies the operation tablecloth.column.api.operators/next-down to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/next-down ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/next-down ds target-col columns-selector)))


(defn next-up
  "Applies the operation tablecloth.column.api.operators/next-up to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/next-up ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/next-up ds target-col columns-selector)))


(defn normalize
  "Applies the operation tablecloth.column.api.operators/normalize to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/normalize ds target-col columns-selector)))


(defn not
  "Applies the operation tablecloth.column.api.operators/not to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/not ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/not ds target-col columns-selector)))


(defn not-eq
  "Applies the operation tablecloth.column.api.operators/not-eq to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 2 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/not-eq ds target-col columns-selector)))


(defn odd?
  "Applies the operation tablecloth.column.api.operators/odd? to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/odd? ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/odd? ds target-col columns-selector)))


(defn or
  "Applies the operation tablecloth.column.api.operators/or to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 2 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/or ds target-col columns-selector)))


(defn order-by
  "Order dataset by:
  - column name
  - columns (as sequence of names)
  - key-fn
  - sequence of columns / key-fn
  Additionally you can ask the order by:
  - :asc
  - :desc
  - custom comparator function"
  ([ds columns-or-fn]
  (tablecloth.api.order-by/order-by ds columns-or-fn))
  ([ds columns-or-fn comparators]
  (tablecloth.api.order-by/order-by ds columns-or-fn comparators))
  ([ds columns-or-fn comparators options]
  (tablecloth.api.order-by/order-by ds columns-or-fn comparators options)))


(defn percentiles
  "Applies the operation tablecloth.column.api.operators/percentiles to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector percentages options]
  (tablecloth.api.operators/percentiles ds target-col columns-selector percentages options))
  ([ds target-col columns-selector percentages]
  (tablecloth.api.operators/percentiles ds target-col columns-selector percentages)))


(defn pivot->longer
  "`tidyr` pivot_longer api"
  ([ds]
  (tablecloth.api.reshape/pivot->longer ds))
  ([ds columns-selector]
  (tablecloth.api.reshape/pivot->longer ds columns-selector))
  ([ds columns-selector options]
  (tablecloth.api.reshape/pivot->longer ds columns-selector options)))


(defn pivot->wider
  "Converts columns to rows. Arguments:
  * dataset
  * columns selector
  * options:
    `:target-columns` - names of the columns created or columns pattern (see below) (default: :$column)
    `:value-column-name` - name of the column for values (default: :$value)
    `:splitter` - string, regular expression or function which splits source column names into data
    `:drop-missing?` - remove rows with missing? (default: true)
    `:datatypes` - map of target columns data types
    `:coerce-to-number` - try to convert extracted values to numbers if possible (default: true)

  * target-columns - can be:

    * column name - source columns names are put there as a data
    * column names as seqence - source columns names after split are put separately into :target-columns as data
    * pattern - is a sequence of names, where some of the names are nil. nil is replaced by a name taken from splitter and such column is used for values.
  "
  ([ds columns-selector value-columns]
  (tablecloth.api.reshape/pivot->wider ds columns-selector value-columns))
  ([ds columns-selector value-columns options]
  (tablecloth.api.reshape/pivot->wider ds columns-selector value-columns options)))


(defn pos?
  "Applies the operation tablecloth.column.api.operators/pos? to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/pos? ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/pos? ds target-col columns-selector)))


(defn pow
  "Applies the operation tablecloth.column.api.operators/pow to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/pow ds target-col columns-selector)))


(defn print-dataset
  "Prints dataset into console. For options see
  tech.v3.dataset.print/dataset-data->str"
  ([ds]
  (tablecloth.api.dataset/print-dataset ds))
  ([ds options]
  (tablecloth.api.dataset/print-dataset ds options)))


(defn process-group-data
  "Internal: The passed-in function is applied on all groups"
  ([ds f]
  (tablecloth.api.utils/process-group-data ds f))
  ([ds f parallel?]
  (tablecloth.api.utils/process-group-data ds f parallel?)))


(defn quartile-1
  "Applies the operation tablecloth.column.api.operators/quartile-1 to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector options]
  (tablecloth.api.operators/quartile-1 ds columns-selector options))
  ([ds columns-selector]
  (tablecloth.api.operators/quartile-1 ds columns-selector)))


(defn quartile-3
  "Applies the operation tablecloth.column.api.operators/quartile-3 to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector options]
  (tablecloth.api.operators/quartile-3 ds columns-selector options))
  ([ds columns-selector]
  (tablecloth.api.operators/quartile-3 ds columns-selector)))


(defn quot
  "Applies the operation tablecloth.column.api.operators/quot to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/quot ds target-col columns-selector)))


(defn rand-nth
  "Returns single random row"
  ([ds]
  (tablecloth.api.rows/rand-nth ds))
  ([ds options]
  (tablecloth.api.rows/rand-nth ds options)))


(defn random
  "Returns (n) random rows with repetition"
  ([ds]
  (tablecloth.api.rows/random ds))
  ([ds n]
  (tablecloth.api.rows/random ds n))
  ([ds n options]
  (tablecloth.api.rows/random ds n options)))


(defn read-nippy
  ([filename]
  (tablecloth.api.utils/read-nippy filename)))


(defn reduce-*
  "Applies the operation tablecloth.column.api.operators/reduce-* to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector]
  (tablecloth.api.operators/reduce-* ds columns-selector)))


(defn reduce-+
  "Applies the operation tablecloth.column.api.operators/reduce-+ to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector]
  (tablecloth.api.operators/reduce-+ ds columns-selector)))


(defn reduce-max
  "Applies the operation tablecloth.column.api.operators/reduce-max to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector]
  (tablecloth.api.operators/reduce-max ds columns-selector)))


(defn reduce-min
  "Applies the operation tablecloth.column.api.operators/reduce-min to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector]
  (tablecloth.api.operators/reduce-min ds columns-selector)))


(defn rem
  "Applies the operation tablecloth.column.api.operators/rem to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/rem ds target-col columns-selector)))


(defn rename-columns
  "Rename columns with provided old -> new name map"
  ([ds columns-selector columns-map-fn]
  (tablecloth.api.columns/rename-columns ds columns-selector columns-map-fn))
  ([ds columns-mapping]
  (tablecloth.api.columns/rename-columns ds columns-mapping)))


(defn reorder-columns
  "Reorder columns using column selector(s). When column names are incomplete, the missing will be attached at the end."
  ([ds columns-selector & args]
  (apply tablecloth.api.columns/reorder-columns ds columns-selector args)))


(defn replace-missing
  "Replaces missing values. Accepts

  * dataset
  * column selector, default: :all
  * strategy, default: :nearest
  * value (optional)
  * single value
  * sequence of values (cycled)
  * function, applied on column(s) with stripped missings

  Strategies are:

  `:value` - replace with given value
  `:up` - copy values up
  `:down` - copy values down
  `:updown` - copy values up and then down for missing values at the end
  `:downup` - copy values down and then up for missing values at the beginning
  `:mid` or `:nearest` - copy values around known values
  `:midpoint` - use average value from previous and next non-missing
  `:lerp` - trying to lineary approximate values, works for numbers and datetime, otherwise applies :nearest. For numbers always results in float datatype.
  "
  ([ds]
  (tablecloth.api.missing/replace-missing ds))
  ([ds strategy]
  (tablecloth.api.missing/replace-missing ds strategy))
  ([ds columns-selector strategy]
  (tablecloth.api.missing/replace-missing ds columns-selector strategy))
  ([ds columns-selector strategy value]
  (tablecloth.api.missing/replace-missing ds columns-selector strategy value)))


(defn right-join
  ([ds-left ds-right columns-selector]
  (tablecloth.api.join-concat-ds/right-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api.join-concat-ds/right-join ds-left ds-right columns-selector options)))


(defn rint
  "Applies the operation tablecloth.column.api.operators/rint to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/rint ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/rint ds target-col columns-selector)))


(defn round
  "Applies the operation tablecloth.column.api.operators/round to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/round ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/round ds target-col columns-selector)))


(defn row-count
  (^{:tag long} [dataset-or-col]
  (tech.v3.dataset/row-count dataset-or-col)))


(defn rows
  "Returns rows of dataset. Result type can be any of:
  * `:as-maps` - maps
  * `:as-double-arrays` - double arrays
  * `:as-seqs` - reader (sequence, default)
  * `:as-vecs` - vectors

  If you want to elide nils in maps set `:nil-missing?` option to false (default: `true`).
  Another option - `:copying?` - when true row values are copied on read (default: `false`)."
  ([ds]
  (tablecloth.api.dataset/rows ds))
  ([ds result-type]
  (tablecloth.api.dataset/rows ds result-type))
  ([ds result-type options]
  (tablecloth.api.dataset/rows ds result-type options)))


(defn select
  "Select columns and rows."
  ([ds columns-selector rows-selector]
  (tablecloth.api.api-template/select ds columns-selector rows-selector)))


(defn select-columns
  "Select columns by (returns dataset):

  - name
  - sequence of names
  - map of names with new names (rename)
  - function which filter names (via column metadata)"
  ([ds]
  (tablecloth.api.columns/select-columns ds))
  ([ds columns-selector]
  (tablecloth.api.columns/select-columns ds columns-selector))
  ([ds columns-selector meta-field]
  (tablecloth.api.columns/select-columns ds columns-selector meta-field)))


(defn select-missing
  "Select rows with missing values

 `columns-selector` selects columns to look at missing values"
  ([ds]
  (tablecloth.api.missing/select-missing ds))
  ([ds columns-selector]
  (tablecloth.api.missing/select-missing ds columns-selector)))


(defn select-rows
  "Select rows using:

  - row id
  - seq of row ids
  - seq of true/false
  - fn with predicate"
  ([ds]
  (tablecloth.api.rows/select-rows ds))
  ([ds rows-selector]
  (tablecloth.api.rows/select-rows ds rows-selector))
  ([ds rows-selector options]
  (tablecloth.api.rows/select-rows ds rows-selector options)))


(defn semi-join
  ([ds-left ds-right columns-selector]
  (tablecloth.api.join-concat-ds/semi-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api.join-concat-ds/semi-join ds-left ds-right columns-selector options)))


(defn separate-column
  ([ds column]
  (tablecloth.api.join-separate/separate-column ds column))
  ([ds column separator]
  (tablecloth.api.join-separate/separate-column ds column separator))
  ([ds column target-columns separator]
  (tablecloth.api.join-separate/separate-column ds column target-columns separator))
  ([ds column target-columns separator conf]
  (tablecloth.api.join-separate/separate-column ds column target-columns separator conf)))


(defn set-dataset-name
  ([dataset ds-name]
  (tech.v3.dataset/set-dataset-name dataset ds-name)))


(defn shape
  "Returns shape of the dataset [rows, cols]"
  ([ds]
  (tablecloth.api.dataset/shape ds)))


(defn shift
  "Applies the operation tablecloth.column.api.operators/shift to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector n]
  (tablecloth.api.operators/shift ds target-col columns-selector n)))


(defn shuffle
  "Shuffle dataset (with seed)"
  ([ds]
  (tablecloth.api.rows/shuffle ds))
  ([ds options]
  (tablecloth.api.rows/shuffle ds options)))


(defn signum
  "Applies the operation tablecloth.column.api.operators/signum to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/signum ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/signum ds target-col columns-selector)))


(defn sin
  "Applies the operation tablecloth.column.api.operators/sin to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/sin ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/sin ds target-col columns-selector)))


(defn sinh
  "Applies the operation tablecloth.column.api.operators/sinh to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/sinh ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/sinh ds target-col columns-selector)))


(defn skew
  "Applies the operation tablecloth.column.api.operators/skew to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector options]
  (tablecloth.api.operators/skew ds columns-selector options))
  ([ds columns-selector]
  (tablecloth.api.operators/skew ds columns-selector)))


(defn split
  "Split given dataset into 2 or more (holdout) splits

  As the result two new columns are added:

  * `:$split-name` - with subgroup name
  * `:$split-id` - fold id/repetition id

  `split-type` can be one of the following:

  * `:kfold` - k-fold strategy, `:k` defines number of folds (defaults to `5`), produces `k` splits
  * `:bootstrap` - `:ratio` defines ratio of observations put into result (defaults to `1.0`), produces `1` split
  * `:holdout` - split into two parts with given ratio (defaults to `2/3`), produces `1` split
  * `:loo` - leave one out, produces the same number of splits as number of observations

  `:holdout` can accept also probabilites or ratios and can split to more than 2 subdatasets
  
  Additionally you can provide:

  * `:seed` - for random number generator
  * `:repeats` - repeat procedure `:repeats` times
  * `:partition-selector` - same as in `group-by` for stratified splitting to reflect dataset structure in splits.
  * `:split-names` names of subdatasets different than default, ie. `[:train :test :split-2 ...]`
  * `:split-col-name` - a column where name of split is stored, either `:train` or `:test` values (default: `:$split-name`)
  * `:split-id-col-name` - a column where id of the train/test pair is stored (default: `:$split-id`)
  * `:ratio` - specify a list of split ratios for `:holdout`. Need to have same size then `:split-names` (example: [0.2 0.2 0.6])

  Rows are shuffled before splitting.
  
  In case of grouped dataset each group is processed separately.

  See [more](https://www.mitpressjournals.org/doi/pdf/10.1162/EVCO_a_00069)"
  ([ds]
  (tablecloth.api.split/split ds))
  ([ds split-type]
  (tablecloth.api.split/split ds split-type))
  ([ds split-type options]
  (tablecloth.api.split/split ds split-type options)))


(defn split->seq
  "Returns split as a sequence of train/test datasets or map of sequences (grouped dataset)"
  ([ds]
  (tablecloth.api.split/split->seq ds))
  ([ds split-type]
  (tablecloth.api.split/split->seq ds split-type))
  ([ds split-type options]
  (tablecloth.api.split/split->seq ds split-type options)))


(defn sq
  "Applies the operation tablecloth.column.api.operators/sq to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/sq ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/sq ds target-col columns-selector)))


(defn sqrt
  "Applies the operation tablecloth.column.api.operators/sqrt to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/sqrt ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/sqrt ds target-col columns-selector)))


(defn sum
  "Applies the operation tablecloth.column.api.operators/sum to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector options]
  (tablecloth.api.operators/sum ds columns-selector options))
  ([ds columns-selector]
  (tablecloth.api.operators/sum ds columns-selector)))


(defn sum-fast
  "Applies the operation tablecloth.column.api.operators/sum-fast to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector]
  (tablecloth.api.operators/sum-fast ds columns-selector)))


(defn tail
  "Last n rows (default 5)"
  ([ds]
  (tablecloth.api.rows/tail ds))
  ([ds n]
  (tablecloth.api.rows/tail ds n)))


(defn tan
  "Applies the operation tablecloth.column.api.operators/tan to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/tan ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/tan ds target-col columns-selector)))


(defn tanh
  "Applies the operation tablecloth.column.api.operators/tanh to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/tanh ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/tanh ds target-col columns-selector)))


(defn to-degrees
  "Applies the operation tablecloth.column.api.operators/to-degrees to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/to-degrees ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/to-degrees ds target-col columns-selector)))


(defn to-radians
  "Applies the operation tablecloth.column.api.operators/to-radians to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/to-radians ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/to-radians ds target-col columns-selector)))


(defn ulp
  "Applies the operation tablecloth.column.api.operators/ulp to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/ulp ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/ulp ds target-col columns-selector)))


(defn ungroup
  "Concat groups into dataset.

  When `add-group-as-column` or `add-group-id-as-column` is set to `true` or name(s), columns with group name(s) or group id is added to the result.

  Before joining the groups groups can be sorted by group name."
  ([ds]
  (tablecloth.api.group-by/ungroup ds))
  ([ds options]
  (tablecloth.api.group-by/ungroup ds options)))


(defn union
  ([ds & args]
  (apply tablecloth.api.join-concat-ds/union ds args)))


(defn unique-by
  "Remove rows which contains the same data
  `column-selector` Select columns for uniqueness
  `strategy` There are 4 strategies defined to handle duplicates

    `:first` - select first row (default)
    `:last` - select last row
    `:random` - select random row
    any function - apply function to a columns which are subject of uniqueness"
  ([ds]
  (tablecloth.api.unique-by/unique-by ds))
  ([ds columns-selector]
  (tablecloth.api.unique-by/unique-by ds columns-selector))
  ([ds columns-selector options]
  (tablecloth.api.unique-by/unique-by ds columns-selector options)))


(defn unmark-group
  "Remove grouping tag"
  ([ds]
  (tablecloth.api.utils/unmark-group ds)))


(defn unroll
  "Unfolds sequences stored inside a column(s), turning it into multiple columns. Opposite of [[fold-by]].
  Add each of the provided columns to the set that defines the \"uniqe key\" of each row.
  Thus there will be a new row for each value inside the target column(s)' value sequence.
  If you want instead to split the content of the columns into a set of new _columns_, look at [[separate-column]].
  See https://scicloj.github.io/tablecloth/index.html#Unroll"
  ([ds columns-selector]
  (tablecloth.api.fold-unroll/unroll ds columns-selector))
  ([ds columns-selector options]
  (tablecloth.api.fold-unroll/unroll ds columns-selector options)))


(defn unsigned-bit-shift-right
  "Applies the operation tablecloth.column.api.operators/unsigned-bit-shift-right to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. null
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector]
  (tablecloth.api.operators/unsigned-bit-shift-right ds target-col columns-selector)))


(defn update-columns
  ([ds columns-map]
  (tablecloth.api.columns/update-columns ds columns-map))
  ([ds columns-selector update-functions]
  (tablecloth.api.columns/update-columns ds columns-selector update-functions)))


(defn variance
  "Applies the operation tablecloth.column.api.operators/variance to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds columns-selector options]
  (tablecloth.api.operators/variance ds columns-selector options))
  ([ds columns-selector]
  (tablecloth.api.operators/variance ds columns-selector)))


(defmacro without-grouping->
  ([ds & args]
  `(tablecloth.api.api-template/without-grouping-> ~ds ~@args)))


(defn write!
  "Write a dataset out to a file.  Supported forms are:

```clojure
(ds/write! test-ds \"test.csv\")
(ds/write! test-ds \"test.tsv\")
(ds/write! test-ds \"test.tsv.gz\")
(ds/write! test-ds \"test.nippy\")
(ds/write! test-ds out-stream)
```

Options:

  * `:max-chars-per-column` - csv,tsv specific, defaults to 65536 - values longer than this will
     cause an exception during serialization.
  * `:max-num-columns` - csv,tsv specific, defaults to 8192 - If the dataset has more than this number of
     columns an exception will be thrown during serialization.
  * `:quoted-columns` - csv specific - sequence of columns names that you would like to always have quoted.
  * `:file-type` - Manually specify the file type.  This is usually inferred from the filename but if you
     pass in an output stream then you will need to specify the file type.
  * `:headers?` - if csv headers are written, defaults to true."
  ([dataset output-path options]
  (tech.v3.dataset/write! dataset output-path options))
  ([dataset output-path]
  (tech.v3.dataset/write! dataset output-path)))


(def write-csv! tablecloth.api.api-template/write-csv!)
(defn write-nippy!
  ([ds filename]
  (tablecloth.api.utils/write-nippy! ds filename)))


(defn zero?
  "Applies the operation tablecloth.column.api.operators/zero? to the columns selected by
      `columns-selector` and returns a new ds with the the result in
      `target-col`. This operation takes a maximum of 1 columns, so
         `columns-selector` can yield no more than that many columns.
      
      `columns-selector can be:
      - name
      - sequence of names
      - map of names with new names (rename)
      - function which filter names (via column metadata)"
  ([ds target-col columns-selector options]
  (tablecloth.api.operators/zero? ds target-col columns-selector options))
  ([ds target-col columns-selector]
  (tablecloth.api.operators/zero? ds target-col columns-selector)))


