/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors.dom.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.dom.DOMHelper;
import se.fishtank.css.selectors.dom.internal.NodeTraversalChecker;
import se.fishtank.css.selectors.specifier.PseudoClassSpecifier;
import se.fishtank.css.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoClassSpecifierChecker
extends NodeTraversalChecker {
    private final PseudoClassSpecifier specifier;
    private Set<Node> nodes;
    private Node root;
    private Set<Node> result;

    public PseudoClassSpecifierChecker(PseudoClassSpecifier specifier) {
        Assert.notNull(specifier, "specifier is null!");
        this.specifier = specifier;
    }

    @Override
    public Set<Node> check(Set<Node> nodes, Node root) throws NodeSelectorException {
        Assert.notNull(nodes, "nodes is null!");
        Assert.notNull(root, "root is null!");
        this.nodes = nodes;
        this.root = root;
        this.result = new LinkedHashSet<Node>();
        String value = this.specifier.getValue();
        if ("empty".equals(value)) {
            this.addEmptyElements();
        } else if ("first-child".equals(value)) {
            this.addFirstChildElements();
        } else if ("first-of-type".equals(value)) {
            this.addFirstOfType();
        } else if ("last-child".equals(value)) {
            this.addLastChildElements();
        } else if ("last-of-type".equals(value)) {
            this.addLastOfType();
        } else if ("only-child".equals(value)) {
            this.addOnlyChildElements();
        } else if ("only-of-type".equals(value)) {
            this.addOnlyOfTypeElements();
        } else if ("root".equals(value)) {
            this.addRootElement();
        } else {
            throw new NodeSelectorException("Unknown pseudo class: " + value);
        }
        return this.result;
    }

    private void addEmptyElements() {
        for (Node node : this.nodes) {
            boolean empty = true;
            NodeList nl = node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                String value;
                Node n = nl.item(i);
                if (n.getNodeType() == 1) {
                    empty = false;
                    break;
                }
                if (n.getNodeType() != 3 || (value = n.getNodeValue()).length() <= 0) continue;
                empty = false;
                break;
            }
            if (!empty) continue;
            this.result.add(node);
        }
    }

    private void addFirstChildElements() {
        for (Node node : this.nodes) {
            if (DOMHelper.getPreviousSiblingElement(node) != null) continue;
            this.result.add(node);
        }
    }

    private void addFirstOfType() {
        for (Node node : this.nodes) {
            Element n = DOMHelper.getPreviousSiblingElement(node);
            while (n != null && !n.getNodeName().equals(node.getNodeName())) {
                n = DOMHelper.getPreviousSiblingElement(n);
            }
            if (n != null) continue;
            this.result.add(node);
        }
    }

    private void addLastChildElements() {
        for (Node node : this.nodes) {
            if (DOMHelper.getNextSiblingElement(node) != null) continue;
            this.result.add(node);
        }
    }

    private void addLastOfType() {
        for (Node node : this.nodes) {
            Element n = DOMHelper.getNextSiblingElement(node);
            while (n != null && !n.getNodeName().equals(node.getNodeName())) {
                n = DOMHelper.getNextSiblingElement(n);
            }
            if (n != null) continue;
            this.result.add(node);
        }
    }

    private void addOnlyChildElements() {
        for (Node node : this.nodes) {
            if (DOMHelper.getPreviousSiblingElement(node) != null || DOMHelper.getNextSiblingElement(node) != null) continue;
            this.result.add(node);
        }
    }

    private void addOnlyOfTypeElements() {
        for (Node node : this.nodes) {
            Element n = DOMHelper.getPreviousSiblingElement(node);
            while (n != null && !n.getNodeName().equals(node.getNodeName())) {
                n = DOMHelper.getPreviousSiblingElement(n);
            }
            if (n != null) continue;
            n = DOMHelper.getNextSiblingElement(node);
            while (n != null && !n.getNodeName().equals(node.getNodeName())) {
                n = DOMHelper.getNextSiblingElement(n);
            }
            if (n != null) continue;
            this.result.add(node);
        }
    }

    private void addRootElement() {
        if (this.root.getNodeType() == 9) {
            Element element = DOMHelper.getFirstChildElement(this.root);
            Assert.notNull(element, "there should be a root element!");
            this.result.add(element);
        } else {
            Assert.isTrue(this.root.getNodeType() == 1, "root must be a document or element node!");
            this.result.add(this.root);
        }
    }
}

