/*
 * Decompiled with CFR 0.152.
 */
package se.raek.charset;

import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.ArrayList;
import java.util.Iterator;
import se.raek.charset.Utf8WithIso88591FallbackCharset;
import se.raek.charset.Utf8WithWindows1252FallbackCharset;

public final class Utf8WithFallbackCharsetProvider
extends CharsetProvider {
    private static final ArrayList<Charset> providedCharsets = new ArrayList();

    static {
        providedCharsets.add(new Utf8WithIso88591FallbackCharset());
        providedCharsets.add(new Utf8WithWindows1252FallbackCharset());
    }

    @Override
    public Charset charsetForName(String charsetName) {
        for (Charset providedCharset : providedCharsets) {
            if (providedCharset.name().equalsIgnoreCase(charsetName)) {
                return providedCharset;
            }
            for (String providedName : providedCharset.aliases()) {
                if (!providedName.equalsIgnoreCase(charsetName)) continue;
                return providedCharset;
            }
        }
        return null;
    }

    @Override
    public Iterator<Charset> charsets() {
        return providedCharsets.iterator();
    }
}

