/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.gui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class DotDiagram
extends JComponent {
    public static final int NORMAL = 0;
    public static final int ADDITIVE = 1;
    public static final int FILLED_ADDITIVE = 2;
    private int[][] data;
    private int[] dataLen;
    private int[] start;
    private int[] maxData;
    private int[] minData;
    private int totMax;
    private int totMin;
    private boolean lockMinMax = false;
    private int maxDataLen;
    private double factor;
    private int[] constantY;
    private Color[] constantColor;
    private int sizeX;
    private int sizeY;
    private int lowerY;
    private double xspace;
    private int ySpacing = 0;
    private int xSpacing = 0;
    private boolean rescale = false;
    private boolean gridVisible = false;
    private String yLabel = null;
    private String xLabel = null;
    private boolean isAdditive = false;
    private boolean isFilled = false;
    private Insets insets;
    private Color[] lineColor;

    public DotDiagram(int diagrams) {
        this(diagrams, 0);
    }

    public DotDiagram(int diagrams, int mode) {
        this.data = new int[diagrams][];
        this.lineColor = new Color[diagrams];
        this.dataLen = new int[diagrams];
        this.start = new int[diagrams];
        this.maxData = new int[diagrams];
        this.minData = new int[diagrams];
        for (int i = 0; i < diagrams; ++i) {
            this.lineColor[i] = Color.black;
        }
        this.setOpaque(true);
        this.isFilled = mode == 2;
        this.isAdditive = this.isFilled || mode == 1;
    }

    public void setShowGrid(boolean on) {
        this.gridVisible = on;
    }

    public void setGridYSpacing(int spacing) {
        this.ySpacing = spacing;
    }

    public void setYLabel(String yLabel) {
        this.yLabel = yLabel;
    }

    public void setXLabel(String xLabel) {
        this.xLabel = xLabel;
    }

    public void setName(int index, String name) {
    }

    public void setToolTipVisible(boolean showToolTip) {
    }

    public void addConstant(Color color, int y) {
        int index;
        if (this.constantY == null) {
            index = 0;
            this.constantY = new int[1];
            this.constantColor = new Color[1];
        } else {
            index = this.constantY.length;
            int[] tmpY = new int[index + 1];
            Color[] tmpC = new Color[index + 1];
            for (int i = 0; i < index; ++i) {
                tmpY[i] = this.constantY[i];
                tmpC[i] = this.constantColor[i];
            }
            this.constantY = tmpY;
            this.constantColor = tmpC;
        }
        this.constantY[index] = y;
        this.constantColor[index] = color == null ? Color.black : color;
        this.rescale = true;
        this.repaint();
    }

    public void setMinMax(int min, int max) {
        this.totMax = max;
        this.totMin = min;
        this.lockMinMax = true;
        this.rescale = true;
    }

    public void setData(int diag, int[] data, int start, int len) {
        int maxData = Integer.MIN_VALUE;
        int minData = Integer.MAX_VALUE;
        if (len > 0) {
            int totLen = data.length;
            int n = start + len;
            for (int i = start; i < n; ++i) {
                int val = data[i % totLen];
                if (maxData < val) {
                    maxData = val;
                }
                if (minData <= val) continue;
                minData = val;
            }
        }
        if (minData > 0) {
            minData = 0;
        }
        if (maxData < minData) {
            maxData = minData;
        }
        this.dataLen[diag] = len;
        this.start[diag] = start;
        this.data[diag] = data;
        this.maxData[diag] = maxData;
        this.minData[diag] = minData;
        this.rescale = true;
        this.repaint();
    }

    public void setDotColor(int diag, Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.lineColor[diag] = color;
        if (this.dataLen[diag] > 0) {
            this.repaint();
        }
    }

    protected void paintComponent(Graphics g0) {
        int i;
        int n;
        Graphics2D g = (Graphics2D)g0;
        Color oldColor = g.getColor();
        int width = this.getWidth();
        int height = this.getHeight();
        int yLabelSize = 0;
        if (this.yLabel != null || this.xLabel != null) {
            FontMetrics fm = g.getFontMetrics();
            yLabelSize = fm.stringWidth(this.yLabel);
        }
        if (this.isOpaque()) {
            g.setColor(Color.white);
            g.fillRect(0, 0, width, height);
        }
        this.insets = this.getInsets(this.insets);
        int reserveX = this.yLabel != null ? 12 * width / 200 : 0;
        int x = this.insets.left + reserveX;
        int y = this.insets.top;
        width = width - this.insets.left - this.insets.right - reserveX;
        height = height - this.insets.top - this.insets.bottom;
        if (this.rescale || width != this.sizeX || height != this.sizeY) {
            if (this.rescale) {
                this.rescale = false;
                this.maxDataLen = 0;
                if (this.lockMinMax) {
                    int n2 = this.data.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (this.dataLen[i2] <= this.maxDataLen) continue;
                        this.maxDataLen = this.dataLen[i2];
                    }
                } else {
                    this.totMin = Integer.MAX_VALUE;
                    this.totMax = Integer.MIN_VALUE;
                    if (this.constantY != null) {
                        for (int cy : this.constantY) {
                            if (cy < this.totMin) {
                                this.totMin = cy;
                            }
                            if (cy <= this.totMax) continue;
                            this.totMax = cy;
                        }
                    }
                    int sum = 0;
                    n = this.data.length;
                    for (i = 0; i < n; ++i) {
                        if (this.dataLen[i] <= 0) continue;
                        int min = this.minData[i];
                        int max = this.maxData[i];
                        if (min < this.totMin) {
                            this.totMin = min;
                        }
                        if (max > this.totMax) {
                            this.totMax = max;
                        }
                        if (this.dataLen[i] > this.maxDataLen) {
                            this.maxDataLen = this.dataLen[i];
                        }
                        sum += max;
                    }
                    if (this.isAdditive && sum > this.totMax) {
                        this.totMax = sum;
                    }
                    if (this.totMin > 0) {
                        this.totMin = 0;
                    }
                    if (this.totMax < this.totMin) {
                        this.totMax = this.totMin;
                    }
                }
            }
            this.sizeY = height;
            this.sizeX = width - 2;
            this.factor = this.totMax < 0 ? (double)(this.sizeY - 15) / (double)(0 - this.totMin) : (this.totMax == this.totMin ? 1.0 : (double)(this.sizeY - 15) / (double)(this.totMax - this.totMin));
            this.lowerY = this.sizeY - 5;
            this.xspace = this.maxDataLen == 0 ? 1.0 : (double)this.sizeX / (double)this.maxDataLen;
        }
        x += 2;
        int zero = y + this.lowerY - (int)(this.factor * (double)(0 - this.totMin));
        if (this.gridVisible) {
            double i3;
            g.setColor(Color.lightGray);
            n = 10;
            for (i = 0; i < n; ++i) {
                g.drawLine(x + i * this.sizeX / 10, y, x + i * this.sizeX / 10, y + this.sizeY - 1);
            }
            int z0 = zero - y;
            int z1 = zero - (y + this.sizeY);
            double tot = (double)this.ySpacing * this.factor == 0.0 ? (double)this.sizeY / 10.0 : this.factor * (double)this.ySpacing;
            for (i3 = 0.0; i3 < (double)z0; i3 += tot) {
                g.drawLine(x + 1, (int)((double)zero - i3), x + this.sizeX, (int)((double)zero - i3));
            }
            for (i3 = 0.0; i3 > (double)z1; i3 -= tot) {
                g.drawLine(x + 1, (int)((double)zero - i3), x + this.sizeX, (int)((double)zero - i3));
            }
        }
        if (this.isAdditive) {
            if (this.isFilled) {
                int delta = (int)(this.xspace + 1.0);
                int n3 = this.maxDataLen;
                for (int i4 = 0; i4 < n3; ++i4) {
                    int lastY = zero;
                    int m = this.data.length;
                    for (int j = 0; j < m; ++j) {
                        int pos;
                        int[] drawData;
                        int y0;
                        if (this.dataLen[j] <= i4 || (y0 = (int)(this.factor * (double)(drawData = this.data[j])[(pos = this.start[j] + i4) % drawData.length])) <= 0) continue;
                        g.setColor(this.lineColor[j]);
                        g.fillRect(x + (int)((double)i4 * this.xspace), lastY - y0, delta, y0);
                        lastY -= y0;
                    }
                }
            } else {
                n = this.maxDataLen;
                for (i = 0; i < n; ++i) {
                    int lastY = zero;
                    int m = this.data.length;
                    for (int j = 0; j < m; ++j) {
                        int pos;
                        int[] drawData;
                        int y0;
                        if (this.dataLen[j] <= i || (y0 = (int)(this.factor * (double)(drawData = this.data[j])[(pos = this.start[j] + i) % drawData.length])) <= 0) continue;
                        g.setColor(this.lineColor[j]);
                        g.drawLine(x + (int)((double)(i - 1) * this.xspace), lastY - y0, x + (int)((double)i * this.xspace), lastY - y0);
                        lastY -= y0;
                    }
                }
            }
        } else {
            int m = this.data.length;
            for (int j = 0; j < m; ++j) {
                if (this.dataLen[j] <= 0) continue;
                int[] drawData = this.data[j];
                int maxLen = drawData.length;
                int startData = this.start[j];
                int lastY = (int)(this.factor * (double)(drawData[startData % maxLen] - this.totMin));
                g.setColor(this.lineColor[j]);
                int n4 = this.dataLen[j];
                for (int i5 = 1; i5 < n4; ++i5) {
                    int pos = startData + i5;
                    int y0 = (int)(this.factor * (double)(drawData[pos % maxLen] - this.totMin));
                    g.drawLine(x + (int)((double)(i5 - 1) * this.xspace), y + this.lowerY - lastY, x + (int)((double)i5 * this.xspace), y + this.lowerY - y0);
                    lastY = y0;
                }
            }
        }
        if (this.constantY != null) {
            n = this.constantY.length;
            for (i = 0; i < n; ++i) {
                int cy = y + this.lowerY - (int)(this.factor * (double)(this.constantY[i] - this.totMin));
                g.setColor(this.constantColor[i]);
                g.drawLine(x, cy, x + this.sizeX, cy);
            }
        }
        g.setColor(Color.black);
        g.drawLine(x -= 2, zero, x + this.sizeX, zero);
        g.drawLine(x + 1, y, x + 1, y + this.sizeY - 1);
        if (this.yLabel != null) {
            g.rotate(-1.57075);
            g.scale((double)height / 200.0, (double)width / 200.0);
            g.drawString(this.yLabel, -100 - yLabelSize / 2, 10);
        }
    }

    public static void main(String[] args) throws Exception {
        JFrame jf = new JFrame("DotDiagram - Test");
        int[] data = new int[100];
        int[] data2 = new int[100];
        int[] data3 = new int[100];
        boolean neg = true;
        int pos = 100;
        int pos2 = 50;
        int pos3 = 0;
        int s = neg ? -10 : 0;
        for (int i = 0; i < 60; ++i) {
            data[i] = pos += (int)((double)s + 20.0 * Math.random());
            data2[i] = pos2 += (int)((double)s + 20.0 * Math.random());
            data3[i] = pos3 += (int)((double)s + 20.0 * Math.random());
        }
        DotDiagram bd = DotDiagram.setupDiagram(10, data, data2, data3, 0);
        DotDiagram bd2 = DotDiagram.setupDiagram(10, data, data2, data3, 1);
        DotDiagram bd3 = DotDiagram.setupDiagram(10, data, data2, data3, 2);
        jf.setDefaultCloseOperation(3);
        jf.setSize(600, 200);
        jf.getContentPane().setLayout(new GridLayout(0, 3));
        jf.getContentPane().add(bd);
        jf.getContentPane().add(bd2);
        jf.getContentPane().add(bd3);
        jf.setVisible(true);
        for (int i = 0; i < 20000; ++i) {
            Thread.sleep(100L);
            pos2 += (int)(5.0 - 10.0 * Math.random());
            pos3 += (int)(5.0 - 10.0 * Math.random());
            if ((pos += (int)(5.0 - 10.0 * Math.random())) < 0) {
                pos = 0;
            }
            if (pos3 < 0) {
                pos3 = 0;
            }
            data[(60 + i) % data.length] = pos;
            data2[(60 + i) % data2.length] = pos2;
            data3[(60 + i) % data3.length] = pos3;
            bd.setData(0, data, i % data.length, 60);
            bd.setData(1, data2, i % data2.length, 60);
            bd.setData(2, data3, i % data3.length, 60);
            bd2.setData(0, data, i % data.length, 60);
            bd2.setData(1, data2, i % data2.length, 60);
            bd2.setData(2, data3, i % data3.length, 60);
            bd3.setData(0, data, i % data.length, 60);
            bd3.setData(1, data2, i % data2.length, 60);
            bd3.setData(2, data3, i % data3.length, 60);
        }
    }

    private static DotDiagram setupDiagram(int v, int[] d1, int[] d2, int[] d3, int mode) {
        DotDiagram bd = new DotDiagram(v, mode);
        bd.setDotColor(0, Color.red);
        bd.setDotColor(1, Color.green);
        bd.setDotColor(2, Color.blue);
        bd.addConstant(Color.yellow, 100);
        bd.setShowGrid(true);
        bd.setYLabel("The Y-Axis (" + (mode == 0 ? "normal" : "additive") + ')');
        bd.setData(0, d1, 0, 60);
        bd.setData(1, d2, 0, 60);
        bd.setData(2, d3, 0, 60);
        return bd;
    }
}

