/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.is.common;

import java.io.File;
import se.sics.tasim.is.common.Competition;
import se.sics.tasim.is.common.CompetitionParticipant;

public abstract class ScoreGenerator {
    private String serverName;
    private String competitionPath;

    public final void init(String serverName, String competitionPath) {
        if (this.serverName != null) {
            throw new IllegalStateException("already initialized");
        }
        this.serverName = serverName;
        this.competitionPath = competitionPath;
    }

    protected String getServerName() {
        return this.serverName;
    }

    protected String getScoreFileName() {
        return this.competitionPath + File.separatorChar + "index.html";
    }

    protected CompetitionParticipant[] getCombinedParticipants(Competition competition) {
        CompetitionParticipant[] parts = competition.getParticipants();
        if (!competition.hasParentCompetition() || parts == null) {
            return parts;
        }
        CompetitionParticipant[] participants = new CompetitionParticipant[parts.length];
        int n = parts.length;
        for (int i = 0; i < n; ++i) {
            participants[i] = new CompetitionParticipant(parts[i]);
        }
        for (Competition parentCompetition = competition.getParentCompetition(); parentCompetition != null; parentCompetition = parentCompetition.getParentCompetition()) {
            int n2 = participants.length;
            for (int i = 0; i < n2; ++i) {
                CompetitionParticipant cpart = parentCompetition.getParticipantByID(participants[i].getID());
                if (cpart == null) continue;
                participants[i].addScore(cpart);
            }
        }
        return participants;
    }

    public abstract boolean createScoreTable(Competition var1, int var2);
}

