(ns leiningen.new.sean-web-app
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(defn web-app
  "Creates a new web application"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}
        render #((renderer "sean-web-app") % data)]

    (main/info "Generating a lovely web-app project.")
    (->files data
             [".gitignore"]
             ["README.md"]
             ["project.clj" (render "project-template.clj")]
             ["src/{{sanitized}}/server.clj" (render "server.clj")]
             ["src/{{sanitized}}/routes.clj" (render "routes.clj")]
             ["src/{{sanitized}}/layouts.clj" (render "layouts.clj")]
             "resources/public/js"
             "resources/public/css")))
