(ns {{name}}.server
  (require [ring.adapter.jetty :as jetty]
           [compojure.handler :as handler]))

(def application (handler/site myroutes/all-routes))

(defn start [port]
  (jetty/run-jetty application {:port port :join? false}))

(defn -main []
  (let [port (or (System/getenv "PORT") "8080")]
    (start port)))
