(ns boot.generate.defn
  (:require [boot.generate.ns :as gen-ns]
            [boot.new.templates :as tmpl]
            [clojure.java.io :as io]
            [clojure.string :as str]))

(defn generate
  "Append the specified function to the specified namespace.
  Create the namespace if necessary. The fn-name should be
  fully-qualified: my.ns/my-func"
  [prefix fn-name]
  (let [[ns-name the-fn] (str/split fn-name #"/")
        path (tmpl/name-to-path ns-name)
        ns-file (io/file (str prefix "/" path ".clj"))]
    (when-not (.exists ns-file)
      (gen-ns/generate prefix ns-name))
    (tmpl/->files {:prefix prefix :path path}
                  ["{{prefix}}/{{path}}.clj"
                   (str "\n(defn " the-fn
                        "\n  \"Generated by Boot\""
                        "\n  [args]"
                        "\n  (println \"WRITEME\"))\n")
                   :append true])))
