(ns boot.generate.ns
  (:require [boot.new.templates :as tmpl]))

(defn generate
  "Generate a new namespace relative to the prefix."
  [prefix ns-name]
  (tmpl/->files {:prefix prefix :path (tmpl/name-to-path ns-name)}
                ["{{prefix}}/{{path}}.clj" (str "(ns " ns-name "\n  \"Generated by Boot\")\n")]))
