(ns sgr-db.utils
  (:require [monger.operators :refer :all]

            [sgr-db.record :as record]
            [sgr-db.user   :as user]))

(defn number-of-users
  [dbname users-coll] (count (user/get-users-maps dbname users-coll)))

(defn number-of-records
  [dbname records-coll] (count (record/get-records-maps dbname records-coll)))

(defn number-of-<gender>-converted-records
  [dbname users-coll records-coll gender]
  (let [users  (user/get-users-maps dbname users-coll {:gender gender} ["records"])
        records (mapcat (fn [user]
                          (keep #(if (:converted? %) true) (:records user))) users)]
    (count records)))

(defn number-of-<gender>-records
  [dbname users-coll records-coll gender]
  (let [users  (user/get-users-maps dbname users-coll {:gender gender} ["records"])
        records (map (fn [user] (count (:records user))) users)]
    (apply #'+ records)))

(defn number-of-converted-records
  [dbname records-coll]
  (count (keep #(if (:converted? %) %) (record/get-records-maps dbname records-coll))))

(defn number-of-SVM?-records
  [dbname records-coll]
  (count (keep #(if (:SVM? %) %) (record/get-records-maps dbname records-coll))))

(defn get-all-<gender&mfcc>
  {:doc "genders : '('male', 'female', ...)"}
  [dbname users-coll records-coll genders]
  (let [users (user/get-users-maps dbname users-coll {$or (map (fn[%] {:gender %}) genders)} ["records" "gender"])]
    (mapcat (fn [user]
              (keep #(if-not (empty? (:mfcc %))
                       {:gender (:gender user) :mfcc (:mfcc %)}) (:records user))) users)))

(defn get-all-<gender&genderSVM&SVM?>
  [dbname users-coll]
  (let [users (user/get-users-maps dbname users-coll)]
    (map (fn [user]
           {:gender (:gender user) :genderSVM (:genderSVM user) :SVM? (:SVM? user)}) users)))

(defn create-user<-add-records
   {:doc "
user:
    {:name      'unknown' || '...'
     :gender    'male' || 'female' || 'unknown'
     :genderSVM 'male' || 'female' || 'unknown'
     :SVM?      true||false}
records:
    '({:path     path-to-record
       :converted?  true||false
       :mfcc        mfcc||false}
      ...)"}
  [dbname users-coll records-coll user records]
  (try
    (let [u  (user/create-user dbname users-coll
                               :name      (:name      user)
                               :gender    (:gender    user)
                               :genderSVM (:genderSVM user)
                               :SVM?      (:SVM?      user))
          rs (map #(record/create-record dbname records-coll %) records)]
      (user/push-user-records dbname users-coll u rs))
      ;;(map #(user/push-user-record dbname users-coll u %) rs))
    (catch Exception e
      (do
        (println (str "Exception SGR-db.utils.create-user<-add-records: " (.getMessage e)))
        false))))


(create-user<-add-records "sgr" "users" "records"
                          {:name "unknown"
                           :gender "male"
                           :genderSVM "male"
                           :SVM? true}
                          '(
                            {:path "/home/ivan/Documents/gridfs.wav"
                             :converted? true
                             :mfcc false}
                            {:path "/home/ivan/Documents/target.wav"
                             :converted? false
                             :mfcc [1 12.4 -13.4 14 15 16 17 18 19 20 21 22 23 24 25 26]}))




