(ns sgr-db.gridfs
  (:require [monger.core       :as     mg]
            [monger.collection :as     mc]
            [monger.gridfs     :as gfs :refer [store-file make-input-file filename content-type metadata]]

            [sgr-db.config     :refer :all]
            [sgr-db.models     :as  models]))

(defn gridfs-store
  {:doc
   "return (.toString (:_id ...))."}
  [filePath dbname]
  (let [db   (mg/get-db     conn dbname)
        fs   (mg/get-gridfs conn dbname)]
    (.toString (:_id (store-file (make-input-file fs filePath))))))

(defn gridfs-find
  {:doc
   "query examples:
   {:filename 'source.wav'}, {:md5 '1942f1e69c1d7354f93e2cf805894a9c'}
   "}
  [dbname query]
  (let [db   (mg/get-db conn dbname)
        fs   (mg/get-gridfs conn dbname)]
    (gfs/find fs query)))

(defn gridfs-find-one
  {:doc
   "query examples:
   {:filename 'source.wav'}, {:md5 '1942f1e69c1d7354f93e2cf805894a9c'}
   "}
  [dbname query]
  (let [db   (mg/get-db conn dbname)
        fs   (mg/get-gridfs conn dbname)]
    (gfs/find-one fs query)))

(defn gridfs-find-maps
  {:doc
   "query examples:
   {:filename 'image.png'}, {:md5 '1942f1e69c1d7354f93e2cf805894a9c'}
   "}
  [dbname query]
  (let [db   (mg/get-db conn dbname)
        fs   (mg/get-gridfs conn dbname)]
    (gfs/find-maps fs query)))

(defn gridfs-find-one-as-map
  {:doc
   "query examples:
   {:filename 'image.png'}, {:md5 '1942f1e69c1d7354f93e2cf805894a9c'}
   "}
  [dbname query]
  (let [db   (mg/get-db conn dbname)
        fs   (mg/get-gridfs conn dbname)]
    (gfs/find-one-as-map fs query)))

(defn gridfs-remove
  {:doc
   "query examples:
   {:filename 'source.wav'}, {:md5 '1942f1e69c1d7354f93e2cf805894a9c'}
   "}
  [dbname query]
  (let [db   (mg/get-db conn dbname)
        fs   (mg/get-gridfs conn dbname)]
    (gfs/remove fs query)))

(defn gridfs-writeTo
  [gridFSDBFile path]
  (.writeTo gridFSDBFile path))

