(ns sgr-db.utils
  (:require [monger.operators :refer :all]

            [sgr-db.config :refer :all]
            [sgr-db.record :as  record]
            [sgr-db.user   :as  user]))

(defn number-of-users
  [& {:keys [dbname users-coll] :or {dbname (:db db-config) users-coll (:users-coll db-config)}}]
  (count (user/get-users-maps dbname users-coll)))

(defn number-of-records
  [& {:keys [dbname records-coll] :or {dbname (:db db-config) records-coll (:records-coll db-config)}}]
  (count (record/get-records-maps dbname records-coll)))

(defn number-of-<gender>-converted-records
  [gender
   & {:keys [dbname records-coll users-coll] :or {dbname (:db db-config) users-coll (:users-coll db-config) records-coll (:records-coll db-config)}}]
  (let [users  (user/get-users-maps dbname users-coll {:gender gender} ["records"])
        records (mapcat (fn [user]
                          (keep #(if (:converted? %) true) (:records user))) users)]
    (count records)))

(defn number-of-<gender>-records
  [gender
   & {:keys [dbname records-coll users-coll] :or {dbname (:db db-config) users-coll (:users-coll db-config) records-coll (:records-coll db-config)}}]
  (let [users  (user/get-users-maps dbname users-coll {:gender gender} ["records"])
        records (map (fn [user] (count (:records user))) users)]
    (apply #'+ records)))

(defn number-of-converted-records
  [& {:keys [dbname records-coll] :or {dbname (:db db-config) records-coll (:records-coll db-config)}}]
  (count (keep #(if (:converted? %) %) (record/get-records-maps dbname records-coll))))

(defn number-of-SVM?-records
  [& {:keys [dbname records-coll] :or {dbname (:db db-config) records-coll (:records-coll db-config)}}]
  (count (keep #(if (:SVM? %) %) (record/get-records-maps dbname records-coll))))

(defn get-all-<gender&mfcc>
  {:doc "genders : '('male', 'female', ...)"}
  [genders
   & {:keys [dbname records-coll users-coll] :or {dbname (:db db-config) users-coll (:users-coll db-config) records-coll (:records-coll db-config)}}]
  (let [users (user/get-users-maps dbname users-coll {$or (map (fn[%] {:gender %}) genders)} ["records" "gender"])]
    (mapcat (fn [user]
              (keep #(if-not (empty? (:mfcc %))
                       {:gender (:gender user) :mfcc (:mfcc %)}) (:records user))) users)))

(defn get-all-<gender&genderSVM&SVM?>
  [& {:keys [dbname users-coll] :or {dbname (:db db-config) users-coll (:users-coll db-config)}}]
  (let [users (user/get-users-maps dbname users-coll)]
    (map (fn [user]
           {:gender (:gender user) :genderSVM (:genderSVM user) :SVM? (:SVM? user)}) users)))

(defn create-user<-add-records
   {:doc "
user:
    {:name      'unknown' || '...'
     :gender    'male' || 'female' || 'unknown'
     :genderSVM 'male' || 'female' || 'unknown'
     :SVM?      true||false}
records:
    '({:path     path-to-record
       :converted?  true||false
       :mfcc        mfcc||false}
      ...)"}
  [user records
   & {:keys [dbname records-coll users-coll] :or {dbname (:db db-config) users-coll (:users-coll db-config) records-coll (:records-coll db-config)}}]
  (try
    (let [u  (user/create-user dbname users-coll
                               :name      (:name      user)
                               :gender    (:gender    user)
                               :genderSVM (:genderSVM user)
                               :SVM?      (:SVM?      user))
          rs (map #(record/create-record dbname records-coll %) records)]
      (user/push-user-records dbname users-coll u rs))
    (catch Exception e
      (do
        (println (str "Exception SGR-db.utils.create-user<-add-records: " (.getMessage e)))
        false))))
