(ns sgr-mfcc.mfcc
  (:require [clj-mfcc.mfcc :as mfcc]))

(def NUMBERS_OF_COEFF   27)
(def WINDOW_SIZE       512)
(def USE_FIRST_COEFF false)
(def MIN_FREQ         20.0)
(def MAX_FREQ      16000.0)
(def NUMBER_OF_FILTERS 250)

(defn mfcc
  ([file]
   (mfcc/MFCC file WINDOW_SIZE NUMBERS_OF_COEFF USE_FIRST_COEFF MIN_FREQ MAX_FREQ NUMBER_OF_FILTERS))
  ([file windowSize numberOfCoeff useFirstCoeff minFreq maxFreq numberOfFilters]
   (mfcc/MFCC file windowSize numberOfCoeff useFirstCoeff minFreq maxFreq numberOfFilters)))

(defn average-mfcc
  [mfcc]
  (mfcc/averageMFCC mfcc))




