// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async14412 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14412 = (function (fn_handler,f,meta14413){
this.fn_handler = fn_handler;
this.f = f;
this.meta14413 = meta14413;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14412.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14414,meta14413__$1){
var self__ = this;
var _14414__$1 = this;
return (new cljs.core.async.t_cljs$core$async14412(self__.fn_handler,self__.f,meta14413__$1));
});

cljs.core.async.t_cljs$core$async14412.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14414){
var self__ = this;
var _14414__$1 = this;
return self__.meta14413;
});

cljs.core.async.t_cljs$core$async14412.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14412.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14412.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async14412.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$fn_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)))], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$meta14413], null);
});

cljs.core.async.t_cljs$core$async14412.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14412.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14412";

cljs.core.async.t_cljs$core$async14412.cljs$lang$ctorPrWriter = (function (this__6634__auto__,writer__6635__auto__,opt__6636__auto__){
return cljs.core._write(writer__6635__auto__,"cljs.core.async/t_cljs$core$async14412");
});

cljs.core.async.__GT_t_cljs$core$async14412 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async14412(fn_handler__$1,f__$1,meta14413){
return (new cljs.core.async.t_cljs$core$async14412(fn_handler__$1,f__$1,meta14413));
});

}

return (new cljs.core.async.t_cljs$core$async14412(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args14417 = [];
var len__7094__auto___14420 = arguments.length;
var i__7095__auto___14421 = (0);
while(true){
if((i__7095__auto___14421 < len__7094__auto___14420)){
args14417.push((arguments[i__7095__auto___14421]));

var G__14422 = (i__7095__auto___14421 + (1));
i__7095__auto___14421 = G__14422;
continue;
} else {
}
break;
}

var G__14419 = args14417.length;
switch (G__14419) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14417.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$sym$buf_DASH_or_DASH_n], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args14424 = [];
var len__7094__auto___14427 = arguments.length;
var i__7095__auto___14428 = (0);
while(true){
if((i__7095__auto___14428 < len__7094__auto___14427)){
args14424.push((arguments[i__7095__auto___14428]));

var G__14429 = (i__7095__auto___14428 + (1));
i__7095__auto___14428 = G__14429;
continue;
} else {
}
break;
}

var G__14426 = args14424.length;
switch (G__14426) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14424.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_14431 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_14431) : fn1.call(null,val_14431));
} else {
cljs.core.async.impl.dispatch.run(((function (val_14431,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_14431) : fn1.call(null,val_14431));
});})(val_14431,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args14432 = [];
var len__7094__auto___14435 = arguments.length;
var i__7095__auto___14436 = (0);
while(true){
if((i__7095__auto___14436 < len__7094__auto___14435)){
args14432.push((arguments[i__7095__auto___14436]));

var G__14437 = (i__7095__auto___14436 + (1));
i__7095__auto___14436 = G__14437;
continue;
} else {
}
break;
}

var G__14434 = args14432.length;
switch (G__14434) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14432.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4423__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__6939__auto___14439 = n;
var x_14440 = (0);
while(true){
if((x_14440 < n__6939__auto___14439)){
(a[x_14440] = (0));

var G__14441 = (x_14440 + (1));
x_14440 = G__14441;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__14442 = (i + (1));
i = G__14442;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async14446 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14446 = (function (alt_flag,flag,meta14447){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta14447 = meta14447;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14446.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_14448,meta14447__$1){
var self__ = this;
var _14448__$1 = this;
return (new cljs.core.async.t_cljs$core$async14446(self__.alt_flag,self__.flag,meta14447__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async14446.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_14448){
var self__ = this;
var _14448__$1 = this;
return self__.meta14447;
});})(flag))
;

cljs.core.async.t_cljs$core$async14446.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14446.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async14446.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14446.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta14447], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async14446.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14446.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14446";

cljs.core.async.t_cljs$core$async14446.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6634__auto__,writer__6635__auto__,opt__6636__auto__){
return cljs.core._write(writer__6635__auto__,"cljs.core.async/t_cljs$core$async14446");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async14446 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14446(alt_flag__$1,flag__$1,meta14447){
return (new cljs.core.async.t_cljs$core$async14446(alt_flag__$1,flag__$1,meta14447));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async14446(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async14452 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14452 = (function (alt_handler,flag,cb,meta14453){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta14453 = meta14453;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14452.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14454,meta14453__$1){
var self__ = this;
var _14454__$1 = this;
return (new cljs.core.async.t_cljs$core$async14452(self__.alt_handler,self__.flag,self__.cb,meta14453__$1));
});

cljs.core.async.t_cljs$core$async14452.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14454){
var self__ = this;
var _14454__$1 = this;
return self__.meta14453;
});

cljs.core.async.t_cljs$core$async14452.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14452.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async14452.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async14452.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta14453], null);
});

cljs.core.async.t_cljs$core$async14452.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14452.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14452";

cljs.core.async.t_cljs$core$async14452.cljs$lang$ctorPrWriter = (function (this__6634__auto__,writer__6635__auto__,opt__6636__auto__){
return cljs.core._write(writer__6635__auto__,"cljs.core.async/t_cljs$core$async14452");
});

cljs.core.async.__GT_t_cljs$core$async14452 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14452(alt_handler__$1,flag__$1,cb__$1,meta14453){
return (new cljs.core.async.t_cljs$core$async14452(alt_handler__$1,flag__$1,cb__$1,meta14453));
});

}

return (new cljs.core.async.t_cljs$core$async14452(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14455_SHARP_){
var G__14459 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14455_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__14459) : fret.call(null,G__14459));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14456_SHARP_){
var G__14460 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14456_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__14460) : fret.call(null,G__14460));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6036__auto__ = wport;
if(cljs.core.truth_(or__6036__auto__)){
return or__6036__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14461 = (i + (1));
i = G__14461;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6036__auto__ = ret;
if(cljs.core.truth_(or__6036__auto__)){
return or__6036__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4425__auto__ = (function (){var and__6024__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6024__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6024__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7101__auto__ = [];
var len__7094__auto___14467 = arguments.length;
var i__7095__auto___14468 = (0);
while(true){
if((i__7095__auto___14468 < len__7094__auto___14467)){
args__7101__auto__.push((arguments[i__7095__auto___14468]));

var G__14469 = (i__7095__auto___14468 + (1));
i__7095__auto___14468 = G__14469;
continue;
} else {
}
break;
}

var argseq__7102__auto__ = ((((1) < args__7101__auto__.length))?(new cljs.core.IndexedSeq(args__7101__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7102__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14464){
var map__14465 = p__14464;
var map__14465__$1 = ((((!((map__14465 == null)))?((((map__14465.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14465.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14465):map__14465);
var opts = map__14465__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14462){
var G__14463 = cljs.core.first(seq14462);
var seq14462__$1 = cljs.core.next(seq14462);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14463,seq14462__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args14470 = [];
var len__7094__auto___14520 = arguments.length;
var i__7095__auto___14521 = (0);
while(true){
if((i__7095__auto___14521 < len__7094__auto___14520)){
args14470.push((arguments[i__7095__auto___14521]));

var G__14522 = (i__7095__auto___14521 + (1));
i__7095__auto___14521 = G__14522;
continue;
} else {
}
break;
}

var G__14472 = args14470.length;
switch (G__14472) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14470.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14364__auto___14524 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto___14524){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto___14524){
return (function (state_14496){
var state_val_14497 = (state_14496[(1)]);
if((state_val_14497 === (7))){
var inst_14492 = (state_14496[(2)]);
var state_14496__$1 = state_14496;
var statearr_14498_14525 = state_14496__$1;
(statearr_14498_14525[(2)] = inst_14492);

(statearr_14498_14525[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14497 === (1))){
var state_14496__$1 = state_14496;
var statearr_14499_14526 = state_14496__$1;
(statearr_14499_14526[(2)] = null);

(statearr_14499_14526[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14497 === (4))){
var inst_14475 = (state_14496[(7)]);
var inst_14475__$1 = (state_14496[(2)]);
var inst_14476 = (inst_14475__$1 == null);
var state_14496__$1 = (function (){var statearr_14500 = state_14496;
(statearr_14500[(7)] = inst_14475__$1);

return statearr_14500;
})();
if(cljs.core.truth_(inst_14476)){
var statearr_14501_14527 = state_14496__$1;
(statearr_14501_14527[(1)] = (5));

} else {
var statearr_14502_14528 = state_14496__$1;
(statearr_14502_14528[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14497 === (13))){
var state_14496__$1 = state_14496;
var statearr_14503_14529 = state_14496__$1;
(statearr_14503_14529[(2)] = null);

(statearr_14503_14529[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14497 === (6))){
var inst_14475 = (state_14496[(7)]);
var state_14496__$1 = state_14496;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14496__$1,(11),to,inst_14475);
} else {
if((state_val_14497 === (3))){
var inst_14494 = (state_14496[(2)]);
var state_14496__$1 = state_14496;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14496__$1,inst_14494);
} else {
if((state_val_14497 === (12))){
var state_14496__$1 = state_14496;
var statearr_14504_14530 = state_14496__$1;
(statearr_14504_14530[(2)] = null);

(statearr_14504_14530[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14497 === (2))){
var state_14496__$1 = state_14496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14496__$1,(4),from);
} else {
if((state_val_14497 === (11))){
var inst_14485 = (state_14496[(2)]);
var state_14496__$1 = state_14496;
if(cljs.core.truth_(inst_14485)){
var statearr_14505_14531 = state_14496__$1;
(statearr_14505_14531[(1)] = (12));

} else {
var statearr_14506_14532 = state_14496__$1;
(statearr_14506_14532[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14497 === (9))){
var state_14496__$1 = state_14496;
var statearr_14507_14533 = state_14496__$1;
(statearr_14507_14533[(2)] = null);

(statearr_14507_14533[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14497 === (5))){
var state_14496__$1 = state_14496;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14508_14534 = state_14496__$1;
(statearr_14508_14534[(1)] = (8));

} else {
var statearr_14509_14535 = state_14496__$1;
(statearr_14509_14535[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14497 === (14))){
var inst_14490 = (state_14496[(2)]);
var state_14496__$1 = state_14496;
var statearr_14510_14536 = state_14496__$1;
(statearr_14510_14536[(2)] = inst_14490);

(statearr_14510_14536[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14497 === (10))){
var inst_14482 = (state_14496[(2)]);
var state_14496__$1 = state_14496;
var statearr_14511_14537 = state_14496__$1;
(statearr_14511_14537[(2)] = inst_14482);

(statearr_14511_14537[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14497 === (8))){
var inst_14479 = cljs.core.async.close_BANG_(to);
var state_14496__$1 = state_14496;
var statearr_14512_14538 = state_14496__$1;
(statearr_14512_14538[(2)] = inst_14479);

(statearr_14512_14538[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto___14524))
;
return ((function (switch__14250__auto__,c__14364__auto___14524){
return (function() {
var cljs$core$async$state_machine__14251__auto__ = null;
var cljs$core$async$state_machine__14251__auto____0 = (function (){
var statearr_14516 = [null,null,null,null,null,null,null,null];
(statearr_14516[(0)] = cljs$core$async$state_machine__14251__auto__);

(statearr_14516[(1)] = (1));

return statearr_14516;
});
var cljs$core$async$state_machine__14251__auto____1 = (function (state_14496){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_14496);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e14517){if((e14517 instanceof Object)){
var ex__14254__auto__ = e14517;
var statearr_14518_14539 = state_14496;
(statearr_14518_14539[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14496);

return cljs.core.cst$kw$recur;
} else {
throw e14517;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__14540 = state_14496;
state_14496 = G__14540;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$state_machine__14251__auto__ = function(state_14496){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14251__auto____1.call(this,state_14496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14251__auto____0;
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14251__auto____1;
return cljs$core$async$state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto___14524))
})();
var state__14366__auto__ = (function (){var statearr_14519 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_14519[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___14524);

return statearr_14519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto___14524))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$pos_QMARK_,cljs.core.cst$sym$n)], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__14724){
var vec__14725 = p__14724;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14725,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14725,(1),null);
var job = vec__14725;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__14364__auto___14907 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto___14907,res,vec__14725,v,p,job,jobs,results){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto___14907,res,vec__14725,v,p,job,jobs,results){
return (function (state_14730){
var state_val_14731 = (state_14730[(1)]);
if((state_val_14731 === (1))){
var state_14730__$1 = state_14730;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14730__$1,(2),res,v);
} else {
if((state_val_14731 === (2))){
var inst_14727 = (state_14730[(2)]);
var inst_14728 = cljs.core.async.close_BANG_(res);
var state_14730__$1 = (function (){var statearr_14732 = state_14730;
(statearr_14732[(7)] = inst_14727);

return statearr_14732;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14730__$1,inst_14728);
} else {
return null;
}
}
});})(c__14364__auto___14907,res,vec__14725,v,p,job,jobs,results))
;
return ((function (switch__14250__auto__,c__14364__auto___14907,res,vec__14725,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0 = (function (){
var statearr_14736 = [null,null,null,null,null,null,null,null];
(statearr_14736[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__);

(statearr_14736[(1)] = (1));

return statearr_14736;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1 = (function (state_14730){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_14730);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e14737){if((e14737 instanceof Object)){
var ex__14254__auto__ = e14737;
var statearr_14738_14908 = state_14730;
(statearr_14738_14908[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14730);

return cljs.core.cst$kw$recur;
} else {
throw e14737;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__14909 = state_14730;
state_14730 = G__14909;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__ = function(state_14730){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1.call(this,state_14730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto___14907,res,vec__14725,v,p,job,jobs,results))
})();
var state__14366__auto__ = (function (){var statearr_14739 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_14739[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___14907);

return statearr_14739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto___14907,res,vec__14725,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14740){
var vec__14741 = p__14740;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14741,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14741,(1),null);
var job = vec__14741;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__6939__auto___14910 = n;
var __14911 = (0);
while(true){
if((__14911 < n__6939__auto___14910)){
var G__14742_14912 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14742_14912) {
case "compute":
var c__14364__auto___14914 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__14911,c__14364__auto___14914,G__14742_14912,n__6939__auto___14910,jobs,results,process,async){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (__14911,c__14364__auto___14914,G__14742_14912,n__6939__auto___14910,jobs,results,process,async){
return (function (state_14755){
var state_val_14756 = (state_14755[(1)]);
if((state_val_14756 === (1))){
var state_14755__$1 = state_14755;
var statearr_14757_14915 = state_14755__$1;
(statearr_14757_14915[(2)] = null);

(statearr_14757_14915[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14756 === (2))){
var state_14755__$1 = state_14755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14755__$1,(4),jobs);
} else {
if((state_val_14756 === (3))){
var inst_14753 = (state_14755[(2)]);
var state_14755__$1 = state_14755;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14755__$1,inst_14753);
} else {
if((state_val_14756 === (4))){
var inst_14745 = (state_14755[(2)]);
var inst_14746 = process(inst_14745);
var state_14755__$1 = state_14755;
if(cljs.core.truth_(inst_14746)){
var statearr_14758_14916 = state_14755__$1;
(statearr_14758_14916[(1)] = (5));

} else {
var statearr_14759_14917 = state_14755__$1;
(statearr_14759_14917[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14756 === (5))){
var state_14755__$1 = state_14755;
var statearr_14760_14918 = state_14755__$1;
(statearr_14760_14918[(2)] = null);

(statearr_14760_14918[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14756 === (6))){
var state_14755__$1 = state_14755;
var statearr_14761_14919 = state_14755__$1;
(statearr_14761_14919[(2)] = null);

(statearr_14761_14919[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14756 === (7))){
var inst_14751 = (state_14755[(2)]);
var state_14755__$1 = state_14755;
var statearr_14762_14920 = state_14755__$1;
(statearr_14762_14920[(2)] = inst_14751);

(statearr_14762_14920[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__14911,c__14364__auto___14914,G__14742_14912,n__6939__auto___14910,jobs,results,process,async))
;
return ((function (__14911,switch__14250__auto__,c__14364__auto___14914,G__14742_14912,n__6939__auto___14910,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0 = (function (){
var statearr_14766 = [null,null,null,null,null,null,null];
(statearr_14766[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__);

(statearr_14766[(1)] = (1));

return statearr_14766;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1 = (function (state_14755){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_14755);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e14767){if((e14767 instanceof Object)){
var ex__14254__auto__ = e14767;
var statearr_14768_14921 = state_14755;
(statearr_14768_14921[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14755);

return cljs.core.cst$kw$recur;
} else {
throw e14767;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__14922 = state_14755;
state_14755 = G__14922;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__ = function(state_14755){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1.call(this,state_14755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__;
})()
;})(__14911,switch__14250__auto__,c__14364__auto___14914,G__14742_14912,n__6939__auto___14910,jobs,results,process,async))
})();
var state__14366__auto__ = (function (){var statearr_14769 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_14769[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___14914);

return statearr_14769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(__14911,c__14364__auto___14914,G__14742_14912,n__6939__auto___14910,jobs,results,process,async))
);


break;
case "async":
var c__14364__auto___14923 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__14911,c__14364__auto___14923,G__14742_14912,n__6939__auto___14910,jobs,results,process,async){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (__14911,c__14364__auto___14923,G__14742_14912,n__6939__auto___14910,jobs,results,process,async){
return (function (state_14782){
var state_val_14783 = (state_14782[(1)]);
if((state_val_14783 === (1))){
var state_14782__$1 = state_14782;
var statearr_14784_14924 = state_14782__$1;
(statearr_14784_14924[(2)] = null);

(statearr_14784_14924[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14783 === (2))){
var state_14782__$1 = state_14782;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14782__$1,(4),jobs);
} else {
if((state_val_14783 === (3))){
var inst_14780 = (state_14782[(2)]);
var state_14782__$1 = state_14782;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14782__$1,inst_14780);
} else {
if((state_val_14783 === (4))){
var inst_14772 = (state_14782[(2)]);
var inst_14773 = async(inst_14772);
var state_14782__$1 = state_14782;
if(cljs.core.truth_(inst_14773)){
var statearr_14785_14925 = state_14782__$1;
(statearr_14785_14925[(1)] = (5));

} else {
var statearr_14786_14926 = state_14782__$1;
(statearr_14786_14926[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14783 === (5))){
var state_14782__$1 = state_14782;
var statearr_14787_14927 = state_14782__$1;
(statearr_14787_14927[(2)] = null);

(statearr_14787_14927[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14783 === (6))){
var state_14782__$1 = state_14782;
var statearr_14788_14928 = state_14782__$1;
(statearr_14788_14928[(2)] = null);

(statearr_14788_14928[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14783 === (7))){
var inst_14778 = (state_14782[(2)]);
var state_14782__$1 = state_14782;
var statearr_14789_14929 = state_14782__$1;
(statearr_14789_14929[(2)] = inst_14778);

(statearr_14789_14929[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__14911,c__14364__auto___14923,G__14742_14912,n__6939__auto___14910,jobs,results,process,async))
;
return ((function (__14911,switch__14250__auto__,c__14364__auto___14923,G__14742_14912,n__6939__auto___14910,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0 = (function (){
var statearr_14793 = [null,null,null,null,null,null,null];
(statearr_14793[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__);

(statearr_14793[(1)] = (1));

return statearr_14793;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1 = (function (state_14782){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_14782);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e14794){if((e14794 instanceof Object)){
var ex__14254__auto__ = e14794;
var statearr_14795_14930 = state_14782;
(statearr_14795_14930[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14782);

return cljs.core.cst$kw$recur;
} else {
throw e14794;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__14931 = state_14782;
state_14782 = G__14931;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__ = function(state_14782){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1.call(this,state_14782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__;
})()
;})(__14911,switch__14250__auto__,c__14364__auto___14923,G__14742_14912,n__6939__auto___14910,jobs,results,process,async))
})();
var state__14366__auto__ = (function (){var statearr_14796 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_14796[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___14923);

return statearr_14796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(__14911,c__14364__auto___14923,G__14742_14912,n__6939__auto___14910,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__14932 = (__14911 + (1));
__14911 = G__14932;
continue;
} else {
}
break;
}

var c__14364__auto___14933 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto___14933,jobs,results,process,async){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto___14933,jobs,results,process,async){
return (function (state_14818){
var state_val_14819 = (state_14818[(1)]);
if((state_val_14819 === (1))){
var state_14818__$1 = state_14818;
var statearr_14820_14934 = state_14818__$1;
(statearr_14820_14934[(2)] = null);

(statearr_14820_14934[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14819 === (2))){
var state_14818__$1 = state_14818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14818__$1,(4),from);
} else {
if((state_val_14819 === (3))){
var inst_14816 = (state_14818[(2)]);
var state_14818__$1 = state_14818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14818__$1,inst_14816);
} else {
if((state_val_14819 === (4))){
var inst_14799 = (state_14818[(7)]);
var inst_14799__$1 = (state_14818[(2)]);
var inst_14800 = (inst_14799__$1 == null);
var state_14818__$1 = (function (){var statearr_14821 = state_14818;
(statearr_14821[(7)] = inst_14799__$1);

return statearr_14821;
})();
if(cljs.core.truth_(inst_14800)){
var statearr_14822_14935 = state_14818__$1;
(statearr_14822_14935[(1)] = (5));

} else {
var statearr_14823_14936 = state_14818__$1;
(statearr_14823_14936[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14819 === (5))){
var inst_14802 = cljs.core.async.close_BANG_(jobs);
var state_14818__$1 = state_14818;
var statearr_14824_14937 = state_14818__$1;
(statearr_14824_14937[(2)] = inst_14802);

(statearr_14824_14937[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14819 === (6))){
var inst_14804 = (state_14818[(8)]);
var inst_14799 = (state_14818[(7)]);
var inst_14804__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_14805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14806 = [inst_14799,inst_14804__$1];
var inst_14807 = (new cljs.core.PersistentVector(null,2,(5),inst_14805,inst_14806,null));
var state_14818__$1 = (function (){var statearr_14825 = state_14818;
(statearr_14825[(8)] = inst_14804__$1);

return statearr_14825;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14818__$1,(8),jobs,inst_14807);
} else {
if((state_val_14819 === (7))){
var inst_14814 = (state_14818[(2)]);
var state_14818__$1 = state_14818;
var statearr_14826_14938 = state_14818__$1;
(statearr_14826_14938[(2)] = inst_14814);

(statearr_14826_14938[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14819 === (8))){
var inst_14804 = (state_14818[(8)]);
var inst_14809 = (state_14818[(2)]);
var state_14818__$1 = (function (){var statearr_14827 = state_14818;
(statearr_14827[(9)] = inst_14809);

return statearr_14827;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14818__$1,(9),results,inst_14804);
} else {
if((state_val_14819 === (9))){
var inst_14811 = (state_14818[(2)]);
var state_14818__$1 = (function (){var statearr_14828 = state_14818;
(statearr_14828[(10)] = inst_14811);

return statearr_14828;
})();
var statearr_14829_14939 = state_14818__$1;
(statearr_14829_14939[(2)] = null);

(statearr_14829_14939[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__14364__auto___14933,jobs,results,process,async))
;
return ((function (switch__14250__auto__,c__14364__auto___14933,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0 = (function (){
var statearr_14833 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14833[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__);

(statearr_14833[(1)] = (1));

return statearr_14833;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1 = (function (state_14818){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_14818);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e14834){if((e14834 instanceof Object)){
var ex__14254__auto__ = e14834;
var statearr_14835_14940 = state_14818;
(statearr_14835_14940[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14818);

return cljs.core.cst$kw$recur;
} else {
throw e14834;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__14941 = state_14818;
state_14818 = G__14941;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__ = function(state_14818){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1.call(this,state_14818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto___14933,jobs,results,process,async))
})();
var state__14366__auto__ = (function (){var statearr_14836 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_14836[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___14933);

return statearr_14836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto___14933,jobs,results,process,async))
);


var c__14364__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto__,jobs,results,process,async){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto__,jobs,results,process,async){
return (function (state_14874){
var state_val_14875 = (state_14874[(1)]);
if((state_val_14875 === (7))){
var inst_14870 = (state_14874[(2)]);
var state_14874__$1 = state_14874;
var statearr_14876_14942 = state_14874__$1;
(statearr_14876_14942[(2)] = inst_14870);

(statearr_14876_14942[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (20))){
var state_14874__$1 = state_14874;
var statearr_14877_14943 = state_14874__$1;
(statearr_14877_14943[(2)] = null);

(statearr_14877_14943[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (1))){
var state_14874__$1 = state_14874;
var statearr_14878_14944 = state_14874__$1;
(statearr_14878_14944[(2)] = null);

(statearr_14878_14944[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (4))){
var inst_14839 = (state_14874[(7)]);
var inst_14839__$1 = (state_14874[(2)]);
var inst_14840 = (inst_14839__$1 == null);
var state_14874__$1 = (function (){var statearr_14879 = state_14874;
(statearr_14879[(7)] = inst_14839__$1);

return statearr_14879;
})();
if(cljs.core.truth_(inst_14840)){
var statearr_14880_14945 = state_14874__$1;
(statearr_14880_14945[(1)] = (5));

} else {
var statearr_14881_14946 = state_14874__$1;
(statearr_14881_14946[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (15))){
var inst_14852 = (state_14874[(8)]);
var state_14874__$1 = state_14874;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14874__$1,(18),to,inst_14852);
} else {
if((state_val_14875 === (21))){
var inst_14865 = (state_14874[(2)]);
var state_14874__$1 = state_14874;
var statearr_14882_14947 = state_14874__$1;
(statearr_14882_14947[(2)] = inst_14865);

(statearr_14882_14947[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (13))){
var inst_14867 = (state_14874[(2)]);
var state_14874__$1 = (function (){var statearr_14883 = state_14874;
(statearr_14883[(9)] = inst_14867);

return statearr_14883;
})();
var statearr_14884_14948 = state_14874__$1;
(statearr_14884_14948[(2)] = null);

(statearr_14884_14948[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (6))){
var inst_14839 = (state_14874[(7)]);
var state_14874__$1 = state_14874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14874__$1,(11),inst_14839);
} else {
if((state_val_14875 === (17))){
var inst_14860 = (state_14874[(2)]);
var state_14874__$1 = state_14874;
if(cljs.core.truth_(inst_14860)){
var statearr_14885_14949 = state_14874__$1;
(statearr_14885_14949[(1)] = (19));

} else {
var statearr_14886_14950 = state_14874__$1;
(statearr_14886_14950[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (3))){
var inst_14872 = (state_14874[(2)]);
var state_14874__$1 = state_14874;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14874__$1,inst_14872);
} else {
if((state_val_14875 === (12))){
var inst_14849 = (state_14874[(10)]);
var state_14874__$1 = state_14874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14874__$1,(14),inst_14849);
} else {
if((state_val_14875 === (2))){
var state_14874__$1 = state_14874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14874__$1,(4),results);
} else {
if((state_val_14875 === (19))){
var state_14874__$1 = state_14874;
var statearr_14887_14951 = state_14874__$1;
(statearr_14887_14951[(2)] = null);

(statearr_14887_14951[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (11))){
var inst_14849 = (state_14874[(2)]);
var state_14874__$1 = (function (){var statearr_14888 = state_14874;
(statearr_14888[(10)] = inst_14849);

return statearr_14888;
})();
var statearr_14889_14952 = state_14874__$1;
(statearr_14889_14952[(2)] = null);

(statearr_14889_14952[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (9))){
var state_14874__$1 = state_14874;
var statearr_14890_14953 = state_14874__$1;
(statearr_14890_14953[(2)] = null);

(statearr_14890_14953[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (5))){
var state_14874__$1 = state_14874;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14891_14954 = state_14874__$1;
(statearr_14891_14954[(1)] = (8));

} else {
var statearr_14892_14955 = state_14874__$1;
(statearr_14892_14955[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (14))){
var inst_14854 = (state_14874[(11)]);
var inst_14852 = (state_14874[(8)]);
var inst_14852__$1 = (state_14874[(2)]);
var inst_14853 = (inst_14852__$1 == null);
var inst_14854__$1 = cljs.core.not(inst_14853);
var state_14874__$1 = (function (){var statearr_14893 = state_14874;
(statearr_14893[(11)] = inst_14854__$1);

(statearr_14893[(8)] = inst_14852__$1);

return statearr_14893;
})();
if(inst_14854__$1){
var statearr_14894_14956 = state_14874__$1;
(statearr_14894_14956[(1)] = (15));

} else {
var statearr_14895_14957 = state_14874__$1;
(statearr_14895_14957[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (16))){
var inst_14854 = (state_14874[(11)]);
var state_14874__$1 = state_14874;
var statearr_14896_14958 = state_14874__$1;
(statearr_14896_14958[(2)] = inst_14854);

(statearr_14896_14958[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (10))){
var inst_14846 = (state_14874[(2)]);
var state_14874__$1 = state_14874;
var statearr_14897_14959 = state_14874__$1;
(statearr_14897_14959[(2)] = inst_14846);

(statearr_14897_14959[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (18))){
var inst_14857 = (state_14874[(2)]);
var state_14874__$1 = state_14874;
var statearr_14898_14960 = state_14874__$1;
(statearr_14898_14960[(2)] = inst_14857);

(statearr_14898_14960[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14875 === (8))){
var inst_14843 = cljs.core.async.close_BANG_(to);
var state_14874__$1 = state_14874;
var statearr_14899_14961 = state_14874__$1;
(statearr_14899_14961[(2)] = inst_14843);

(statearr_14899_14961[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto__,jobs,results,process,async))
;
return ((function (switch__14250__auto__,c__14364__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0 = (function (){
var statearr_14903 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14903[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__);

(statearr_14903[(1)] = (1));

return statearr_14903;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1 = (function (state_14874){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_14874);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e14904){if((e14904 instanceof Object)){
var ex__14254__auto__ = e14904;
var statearr_14905_14962 = state_14874;
(statearr_14905_14962[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14874);

return cljs.core.cst$kw$recur;
} else {
throw e14904;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__14963 = state_14874;
state_14874 = G__14963;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__ = function(state_14874){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1.call(this,state_14874);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto__,jobs,results,process,async))
})();
var state__14366__auto__ = (function (){var statearr_14906 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_14906[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto__);

return statearr_14906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto__,jobs,results,process,async))
);

return c__14364__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args14964 = [];
var len__7094__auto___14967 = arguments.length;
var i__7095__auto___14968 = (0);
while(true){
if((i__7095__auto___14968 < len__7094__auto___14967)){
args14964.push((arguments[i__7095__auto___14968]));

var G__14969 = (i__7095__auto___14968 + (1));
i__7095__auto___14968 = G__14969;
continue;
} else {
}
break;
}

var G__14966 = args14964.length;
switch (G__14966) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14964.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args14971 = [];
var len__7094__auto___14974 = arguments.length;
var i__7095__auto___14975 = (0);
while(true){
if((i__7095__auto___14975 < len__7094__auto___14974)){
args14971.push((arguments[i__7095__auto___14975]));

var G__14976 = (i__7095__auto___14975 + (1));
i__7095__auto___14975 = G__14976;
continue;
} else {
}
break;
}

var G__14973 = args14971.length;
switch (G__14973) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14971.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args14978 = [];
var len__7094__auto___15031 = arguments.length;
var i__7095__auto___15032 = (0);
while(true){
if((i__7095__auto___15032 < len__7094__auto___15031)){
args14978.push((arguments[i__7095__auto___15032]));

var G__15033 = (i__7095__auto___15032 + (1));
i__7095__auto___15032 = G__15033;
continue;
} else {
}
break;
}

var G__14980 = args14978.length;
switch (G__14980) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14978.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__14364__auto___15035 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto___15035,tc,fc){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto___15035,tc,fc){
return (function (state_15006){
var state_val_15007 = (state_15006[(1)]);
if((state_val_15007 === (7))){
var inst_15002 = (state_15006[(2)]);
var state_15006__$1 = state_15006;
var statearr_15008_15036 = state_15006__$1;
(statearr_15008_15036[(2)] = inst_15002);

(statearr_15008_15036[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15007 === (1))){
var state_15006__$1 = state_15006;
var statearr_15009_15037 = state_15006__$1;
(statearr_15009_15037[(2)] = null);

(statearr_15009_15037[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15007 === (4))){
var inst_14983 = (state_15006[(7)]);
var inst_14983__$1 = (state_15006[(2)]);
var inst_14984 = (inst_14983__$1 == null);
var state_15006__$1 = (function (){var statearr_15010 = state_15006;
(statearr_15010[(7)] = inst_14983__$1);

return statearr_15010;
})();
if(cljs.core.truth_(inst_14984)){
var statearr_15011_15038 = state_15006__$1;
(statearr_15011_15038[(1)] = (5));

} else {
var statearr_15012_15039 = state_15006__$1;
(statearr_15012_15039[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15007 === (13))){
var state_15006__$1 = state_15006;
var statearr_15013_15040 = state_15006__$1;
(statearr_15013_15040[(2)] = null);

(statearr_15013_15040[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15007 === (6))){
var inst_14983 = (state_15006[(7)]);
var inst_14989 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_14983) : p.call(null,inst_14983));
var state_15006__$1 = state_15006;
if(cljs.core.truth_(inst_14989)){
var statearr_15014_15041 = state_15006__$1;
(statearr_15014_15041[(1)] = (9));

} else {
var statearr_15015_15042 = state_15006__$1;
(statearr_15015_15042[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15007 === (3))){
var inst_15004 = (state_15006[(2)]);
var state_15006__$1 = state_15006;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15006__$1,inst_15004);
} else {
if((state_val_15007 === (12))){
var state_15006__$1 = state_15006;
var statearr_15016_15043 = state_15006__$1;
(statearr_15016_15043[(2)] = null);

(statearr_15016_15043[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15007 === (2))){
var state_15006__$1 = state_15006;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15006__$1,(4),ch);
} else {
if((state_val_15007 === (11))){
var inst_14983 = (state_15006[(7)]);
var inst_14993 = (state_15006[(2)]);
var state_15006__$1 = state_15006;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15006__$1,(8),inst_14993,inst_14983);
} else {
if((state_val_15007 === (9))){
var state_15006__$1 = state_15006;
var statearr_15017_15044 = state_15006__$1;
(statearr_15017_15044[(2)] = tc);

(statearr_15017_15044[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15007 === (5))){
var inst_14986 = cljs.core.async.close_BANG_(tc);
var inst_14987 = cljs.core.async.close_BANG_(fc);
var state_15006__$1 = (function (){var statearr_15018 = state_15006;
(statearr_15018[(8)] = inst_14986);

return statearr_15018;
})();
var statearr_15019_15045 = state_15006__$1;
(statearr_15019_15045[(2)] = inst_14987);

(statearr_15019_15045[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15007 === (14))){
var inst_15000 = (state_15006[(2)]);
var state_15006__$1 = state_15006;
var statearr_15020_15046 = state_15006__$1;
(statearr_15020_15046[(2)] = inst_15000);

(statearr_15020_15046[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15007 === (10))){
var state_15006__$1 = state_15006;
var statearr_15021_15047 = state_15006__$1;
(statearr_15021_15047[(2)] = fc);

(statearr_15021_15047[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15007 === (8))){
var inst_14995 = (state_15006[(2)]);
var state_15006__$1 = state_15006;
if(cljs.core.truth_(inst_14995)){
var statearr_15022_15048 = state_15006__$1;
(statearr_15022_15048[(1)] = (12));

} else {
var statearr_15023_15049 = state_15006__$1;
(statearr_15023_15049[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto___15035,tc,fc))
;
return ((function (switch__14250__auto__,c__14364__auto___15035,tc,fc){
return (function() {
var cljs$core$async$state_machine__14251__auto__ = null;
var cljs$core$async$state_machine__14251__auto____0 = (function (){
var statearr_15027 = [null,null,null,null,null,null,null,null,null];
(statearr_15027[(0)] = cljs$core$async$state_machine__14251__auto__);

(statearr_15027[(1)] = (1));

return statearr_15027;
});
var cljs$core$async$state_machine__14251__auto____1 = (function (state_15006){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_15006);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e15028){if((e15028 instanceof Object)){
var ex__14254__auto__ = e15028;
var statearr_15029_15050 = state_15006;
(statearr_15029_15050[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15006);

return cljs.core.cst$kw$recur;
} else {
throw e15028;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__15051 = state_15006;
state_15006 = G__15051;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$state_machine__14251__auto__ = function(state_15006){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14251__auto____1.call(this,state_15006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14251__auto____0;
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14251__auto____1;
return cljs$core$async$state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto___15035,tc,fc))
})();
var state__14366__auto__ = (function (){var statearr_15030 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_15030[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___15035);

return statearr_15030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto___15035,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14364__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto__){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto__){
return (function (state_15098){
var state_val_15099 = (state_15098[(1)]);
if((state_val_15099 === (1))){
var inst_15084 = init;
var state_15098__$1 = (function (){var statearr_15100 = state_15098;
(statearr_15100[(7)] = inst_15084);

return statearr_15100;
})();
var statearr_15101_15116 = state_15098__$1;
(statearr_15101_15116[(2)] = null);

(statearr_15101_15116[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15099 === (2))){
var state_15098__$1 = state_15098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15098__$1,(4),ch);
} else {
if((state_val_15099 === (3))){
var inst_15096 = (state_15098[(2)]);
var state_15098__$1 = state_15098;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15098__$1,inst_15096);
} else {
if((state_val_15099 === (4))){
var inst_15087 = (state_15098[(8)]);
var inst_15087__$1 = (state_15098[(2)]);
var inst_15088 = (inst_15087__$1 == null);
var state_15098__$1 = (function (){var statearr_15102 = state_15098;
(statearr_15102[(8)] = inst_15087__$1);

return statearr_15102;
})();
if(cljs.core.truth_(inst_15088)){
var statearr_15103_15117 = state_15098__$1;
(statearr_15103_15117[(1)] = (5));

} else {
var statearr_15104_15118 = state_15098__$1;
(statearr_15104_15118[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15099 === (5))){
var inst_15084 = (state_15098[(7)]);
var state_15098__$1 = state_15098;
var statearr_15105_15119 = state_15098__$1;
(statearr_15105_15119[(2)] = inst_15084);

(statearr_15105_15119[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15099 === (6))){
var inst_15087 = (state_15098[(8)]);
var inst_15084 = (state_15098[(7)]);
var inst_15091 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_15084,inst_15087) : f.call(null,inst_15084,inst_15087));
var inst_15084__$1 = inst_15091;
var state_15098__$1 = (function (){var statearr_15106 = state_15098;
(statearr_15106[(7)] = inst_15084__$1);

return statearr_15106;
})();
var statearr_15107_15120 = state_15098__$1;
(statearr_15107_15120[(2)] = null);

(statearr_15107_15120[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15099 === (7))){
var inst_15094 = (state_15098[(2)]);
var state_15098__$1 = state_15098;
var statearr_15108_15121 = state_15098__$1;
(statearr_15108_15121[(2)] = inst_15094);

(statearr_15108_15121[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__14364__auto__))
;
return ((function (switch__14250__auto__,c__14364__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__14251__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14251__auto____0 = (function (){
var statearr_15112 = [null,null,null,null,null,null,null,null,null];
(statearr_15112[(0)] = cljs$core$async$reduce_$_state_machine__14251__auto__);

(statearr_15112[(1)] = (1));

return statearr_15112;
});
var cljs$core$async$reduce_$_state_machine__14251__auto____1 = (function (state_15098){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_15098);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e15113){if((e15113 instanceof Object)){
var ex__14254__auto__ = e15113;
var statearr_15114_15122 = state_15098;
(statearr_15114_15122[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15098);

return cljs.core.cst$kw$recur;
} else {
throw e15113;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__15123 = state_15098;
state_15098 = G__15123;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14251__auto__ = function(state_15098){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14251__auto____1.call(this,state_15098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14251__auto____0;
cljs$core$async$reduce_$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14251__auto____1;
return cljs$core$async$reduce_$_state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto__))
})();
var state__14366__auto__ = (function (){var statearr_15115 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_15115[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto__);

return statearr_15115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto__))
);

return c__14364__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args15124 = [];
var len__7094__auto___15176 = arguments.length;
var i__7095__auto___15177 = (0);
while(true){
if((i__7095__auto___15177 < len__7094__auto___15176)){
args15124.push((arguments[i__7095__auto___15177]));

var G__15178 = (i__7095__auto___15177 + (1));
i__7095__auto___15177 = G__15178;
continue;
} else {
}
break;
}

var G__15126 = args15124.length;
switch (G__15126) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15124.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14364__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto__){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto__){
return (function (state_15151){
var state_val_15152 = (state_15151[(1)]);
if((state_val_15152 === (7))){
var inst_15133 = (state_15151[(2)]);
var state_15151__$1 = state_15151;
var statearr_15153_15180 = state_15151__$1;
(statearr_15153_15180[(2)] = inst_15133);

(statearr_15153_15180[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15152 === (1))){
var inst_15127 = cljs.core.seq(coll);
var inst_15128 = inst_15127;
var state_15151__$1 = (function (){var statearr_15154 = state_15151;
(statearr_15154[(7)] = inst_15128);

return statearr_15154;
})();
var statearr_15155_15181 = state_15151__$1;
(statearr_15155_15181[(2)] = null);

(statearr_15155_15181[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15152 === (4))){
var inst_15128 = (state_15151[(7)]);
var inst_15131 = cljs.core.first(inst_15128);
var state_15151__$1 = state_15151;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15151__$1,(7),ch,inst_15131);
} else {
if((state_val_15152 === (13))){
var inst_15145 = (state_15151[(2)]);
var state_15151__$1 = state_15151;
var statearr_15156_15182 = state_15151__$1;
(statearr_15156_15182[(2)] = inst_15145);

(statearr_15156_15182[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15152 === (6))){
var inst_15136 = (state_15151[(2)]);
var state_15151__$1 = state_15151;
if(cljs.core.truth_(inst_15136)){
var statearr_15157_15183 = state_15151__$1;
(statearr_15157_15183[(1)] = (8));

} else {
var statearr_15158_15184 = state_15151__$1;
(statearr_15158_15184[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15152 === (3))){
var inst_15149 = (state_15151[(2)]);
var state_15151__$1 = state_15151;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15151__$1,inst_15149);
} else {
if((state_val_15152 === (12))){
var state_15151__$1 = state_15151;
var statearr_15159_15185 = state_15151__$1;
(statearr_15159_15185[(2)] = null);

(statearr_15159_15185[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15152 === (2))){
var inst_15128 = (state_15151[(7)]);
var state_15151__$1 = state_15151;
if(cljs.core.truth_(inst_15128)){
var statearr_15160_15186 = state_15151__$1;
(statearr_15160_15186[(1)] = (4));

} else {
var statearr_15161_15187 = state_15151__$1;
(statearr_15161_15187[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15152 === (11))){
var inst_15142 = cljs.core.async.close_BANG_(ch);
var state_15151__$1 = state_15151;
var statearr_15162_15188 = state_15151__$1;
(statearr_15162_15188[(2)] = inst_15142);

(statearr_15162_15188[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15152 === (9))){
var state_15151__$1 = state_15151;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15163_15189 = state_15151__$1;
(statearr_15163_15189[(1)] = (11));

} else {
var statearr_15164_15190 = state_15151__$1;
(statearr_15164_15190[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15152 === (5))){
var inst_15128 = (state_15151[(7)]);
var state_15151__$1 = state_15151;
var statearr_15165_15191 = state_15151__$1;
(statearr_15165_15191[(2)] = inst_15128);

(statearr_15165_15191[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15152 === (10))){
var inst_15147 = (state_15151[(2)]);
var state_15151__$1 = state_15151;
var statearr_15166_15192 = state_15151__$1;
(statearr_15166_15192[(2)] = inst_15147);

(statearr_15166_15192[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15152 === (8))){
var inst_15128 = (state_15151[(7)]);
var inst_15138 = cljs.core.next(inst_15128);
var inst_15128__$1 = inst_15138;
var state_15151__$1 = (function (){var statearr_15167 = state_15151;
(statearr_15167[(7)] = inst_15128__$1);

return statearr_15167;
})();
var statearr_15168_15193 = state_15151__$1;
(statearr_15168_15193[(2)] = null);

(statearr_15168_15193[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto__))
;
return ((function (switch__14250__auto__,c__14364__auto__){
return (function() {
var cljs$core$async$state_machine__14251__auto__ = null;
var cljs$core$async$state_machine__14251__auto____0 = (function (){
var statearr_15172 = [null,null,null,null,null,null,null,null];
(statearr_15172[(0)] = cljs$core$async$state_machine__14251__auto__);

(statearr_15172[(1)] = (1));

return statearr_15172;
});
var cljs$core$async$state_machine__14251__auto____1 = (function (state_15151){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_15151);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e15173){if((e15173 instanceof Object)){
var ex__14254__auto__ = e15173;
var statearr_15174_15194 = state_15151;
(statearr_15174_15194[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15151);

return cljs.core.cst$kw$recur;
} else {
throw e15173;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__15195 = state_15151;
state_15151 = G__15195;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$state_machine__14251__auto__ = function(state_15151){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14251__auto____1.call(this,state_15151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14251__auto____0;
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14251__auto____1;
return cljs$core$async$state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto__))
})();
var state__14366__auto__ = (function (){var statearr_15175 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_15175[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto__);

return statearr_15175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto__))
);

return c__14364__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6691__auto__ = (((_ == null))?null:_);
var m__6692__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6691__auto__)]);
if(!((m__6692__auto__ == null))){
return (m__6692__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6692__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__6692__auto__.call(null,_));
} else {
var m__6692__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6692__auto____$1 == null))){
return (m__6692__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6692__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__6692__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6691__auto__ = (((m == null))?null:m);
var m__6692__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6691__auto__)]);
if(!((m__6692__auto__ == null))){
return (m__6692__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6692__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__6692__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__6692__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6692__auto____$1 == null))){
return (m__6692__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6692__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__6692__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6691__auto__ = (((m == null))?null:m);
var m__6692__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6691__auto__)]);
if(!((m__6692__auto__ == null))){
return (m__6692__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6692__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6692__auto__.call(null,m,ch));
} else {
var m__6692__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6692__auto____$1 == null))){
return (m__6692__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6692__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6692__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6691__auto__ = (((m == null))?null:m);
var m__6692__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6691__auto__)]);
if(!((m__6692__auto__ == null))){
return (m__6692__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6692__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__6692__auto__.call(null,m));
} else {
var m__6692__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6692__auto____$1 == null))){
return (m__6692__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6692__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__6692__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__15420 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__15420) : cljs.core.atom.call(null,G__15420));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15421 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15421 = (function (mult,ch,cs,meta15422){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta15422 = meta15422;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_15423,meta15422__$1){
var self__ = this;
var _15423__$1 = this;
return (new cljs.core.async.t_cljs$core$async15421(self__.mult,self__.ch,self__.cs,meta15422__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_15423){
var self__ = this;
var _15423__$1 = this;
return self__.meta15422;
});})(cs))
;

cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__15424_15644 = self__.cs;
var G__15425_15645 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__15424_15644,G__15425_15645) : cljs.core.reset_BANG_.call(null,G__15424_15644,G__15425_15645));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15421.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta15422], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async15421.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15421.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15421";

cljs.core.async.t_cljs$core$async15421.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6634__auto__,writer__6635__auto__,opt__6636__auto__){
return cljs.core._write(writer__6635__auto__,"cljs.core.async/t_cljs$core$async15421");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async15421 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async15421(mult__$1,ch__$1,cs__$1,meta15422){
return (new cljs.core.async.t_cljs$core$async15421(mult__$1,ch__$1,cs__$1,meta15422));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async15421(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__14364__auto___15646 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto___15646,cs,m,dchan,dctr,done){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto___15646,cs,m,dchan,dctr,done){
return (function (state_15556){
var state_val_15557 = (state_15556[(1)]);
if((state_val_15557 === (7))){
var inst_15552 = (state_15556[(2)]);
var state_15556__$1 = state_15556;
var statearr_15558_15647 = state_15556__$1;
(statearr_15558_15647[(2)] = inst_15552);

(statearr_15558_15647[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (20))){
var inst_15457 = (state_15556[(7)]);
var inst_15467 = cljs.core.first(inst_15457);
var inst_15468 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15467,(0),null);
var inst_15469 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15467,(1),null);
var state_15556__$1 = (function (){var statearr_15559 = state_15556;
(statearr_15559[(8)] = inst_15468);

return statearr_15559;
})();
if(cljs.core.truth_(inst_15469)){
var statearr_15560_15648 = state_15556__$1;
(statearr_15560_15648[(1)] = (22));

} else {
var statearr_15561_15649 = state_15556__$1;
(statearr_15561_15649[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (27))){
var inst_15497 = (state_15556[(9)]);
var inst_15499 = (state_15556[(10)]);
var inst_15504 = (state_15556[(11)]);
var inst_15428 = (state_15556[(12)]);
var inst_15504__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_15497,inst_15499);
var inst_15505 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_15504__$1,inst_15428,done);
var state_15556__$1 = (function (){var statearr_15562 = state_15556;
(statearr_15562[(11)] = inst_15504__$1);

return statearr_15562;
})();
if(cljs.core.truth_(inst_15505)){
var statearr_15563_15650 = state_15556__$1;
(statearr_15563_15650[(1)] = (30));

} else {
var statearr_15564_15651 = state_15556__$1;
(statearr_15564_15651[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (1))){
var state_15556__$1 = state_15556;
var statearr_15565_15652 = state_15556__$1;
(statearr_15565_15652[(2)] = null);

(statearr_15565_15652[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (24))){
var inst_15457 = (state_15556[(7)]);
var inst_15474 = (state_15556[(2)]);
var inst_15475 = cljs.core.next(inst_15457);
var inst_15437 = inst_15475;
var inst_15438 = null;
var inst_15439 = (0);
var inst_15440 = (0);
var state_15556__$1 = (function (){var statearr_15566 = state_15556;
(statearr_15566[(13)] = inst_15439);

(statearr_15566[(14)] = inst_15438);

(statearr_15566[(15)] = inst_15440);

(statearr_15566[(16)] = inst_15474);

(statearr_15566[(17)] = inst_15437);

return statearr_15566;
})();
var statearr_15567_15653 = state_15556__$1;
(statearr_15567_15653[(2)] = null);

(statearr_15567_15653[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (39))){
var state_15556__$1 = state_15556;
var statearr_15571_15654 = state_15556__$1;
(statearr_15571_15654[(2)] = null);

(statearr_15571_15654[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (4))){
var inst_15428 = (state_15556[(12)]);
var inst_15428__$1 = (state_15556[(2)]);
var inst_15429 = (inst_15428__$1 == null);
var state_15556__$1 = (function (){var statearr_15572 = state_15556;
(statearr_15572[(12)] = inst_15428__$1);

return statearr_15572;
})();
if(cljs.core.truth_(inst_15429)){
var statearr_15573_15655 = state_15556__$1;
(statearr_15573_15655[(1)] = (5));

} else {
var statearr_15574_15656 = state_15556__$1;
(statearr_15574_15656[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (15))){
var inst_15439 = (state_15556[(13)]);
var inst_15438 = (state_15556[(14)]);
var inst_15440 = (state_15556[(15)]);
var inst_15437 = (state_15556[(17)]);
var inst_15453 = (state_15556[(2)]);
var inst_15454 = (inst_15440 + (1));
var tmp15568 = inst_15439;
var tmp15569 = inst_15438;
var tmp15570 = inst_15437;
var inst_15437__$1 = tmp15570;
var inst_15438__$1 = tmp15569;
var inst_15439__$1 = tmp15568;
var inst_15440__$1 = inst_15454;
var state_15556__$1 = (function (){var statearr_15575 = state_15556;
(statearr_15575[(18)] = inst_15453);

(statearr_15575[(13)] = inst_15439__$1);

(statearr_15575[(14)] = inst_15438__$1);

(statearr_15575[(15)] = inst_15440__$1);

(statearr_15575[(17)] = inst_15437__$1);

return statearr_15575;
})();
var statearr_15576_15657 = state_15556__$1;
(statearr_15576_15657[(2)] = null);

(statearr_15576_15657[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (21))){
var inst_15478 = (state_15556[(2)]);
var state_15556__$1 = state_15556;
var statearr_15580_15658 = state_15556__$1;
(statearr_15580_15658[(2)] = inst_15478);

(statearr_15580_15658[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (31))){
var inst_15504 = (state_15556[(11)]);
var inst_15508 = done(null);
var inst_15509 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_15504);
var state_15556__$1 = (function (){var statearr_15581 = state_15556;
(statearr_15581[(19)] = inst_15508);

return statearr_15581;
})();
var statearr_15582_15659 = state_15556__$1;
(statearr_15582_15659[(2)] = inst_15509);

(statearr_15582_15659[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (32))){
var inst_15497 = (state_15556[(9)]);
var inst_15496 = (state_15556[(20)]);
var inst_15499 = (state_15556[(10)]);
var inst_15498 = (state_15556[(21)]);
var inst_15511 = (state_15556[(2)]);
var inst_15512 = (inst_15499 + (1));
var tmp15577 = inst_15497;
var tmp15578 = inst_15496;
var tmp15579 = inst_15498;
var inst_15496__$1 = tmp15578;
var inst_15497__$1 = tmp15577;
var inst_15498__$1 = tmp15579;
var inst_15499__$1 = inst_15512;
var state_15556__$1 = (function (){var statearr_15583 = state_15556;
(statearr_15583[(9)] = inst_15497__$1);

(statearr_15583[(22)] = inst_15511);

(statearr_15583[(20)] = inst_15496__$1);

(statearr_15583[(10)] = inst_15499__$1);

(statearr_15583[(21)] = inst_15498__$1);

return statearr_15583;
})();
var statearr_15584_15660 = state_15556__$1;
(statearr_15584_15660[(2)] = null);

(statearr_15584_15660[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (40))){
var inst_15524 = (state_15556[(23)]);
var inst_15528 = done(null);
var inst_15529 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_15524);
var state_15556__$1 = (function (){var statearr_15585 = state_15556;
(statearr_15585[(24)] = inst_15528);

return statearr_15585;
})();
var statearr_15586_15661 = state_15556__$1;
(statearr_15586_15661[(2)] = inst_15529);

(statearr_15586_15661[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (33))){
var inst_15515 = (state_15556[(25)]);
var inst_15517 = cljs.core.chunked_seq_QMARK_(inst_15515);
var state_15556__$1 = state_15556;
if(inst_15517){
var statearr_15587_15662 = state_15556__$1;
(statearr_15587_15662[(1)] = (36));

} else {
var statearr_15588_15663 = state_15556__$1;
(statearr_15588_15663[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (13))){
var inst_15447 = (state_15556[(26)]);
var inst_15450 = cljs.core.async.close_BANG_(inst_15447);
var state_15556__$1 = state_15556;
var statearr_15589_15664 = state_15556__$1;
(statearr_15589_15664[(2)] = inst_15450);

(statearr_15589_15664[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (22))){
var inst_15468 = (state_15556[(8)]);
var inst_15471 = cljs.core.async.close_BANG_(inst_15468);
var state_15556__$1 = state_15556;
var statearr_15590_15665 = state_15556__$1;
(statearr_15590_15665[(2)] = inst_15471);

(statearr_15590_15665[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (36))){
var inst_15515 = (state_15556[(25)]);
var inst_15519 = cljs.core.chunk_first(inst_15515);
var inst_15520 = cljs.core.chunk_rest(inst_15515);
var inst_15521 = cljs.core.count(inst_15519);
var inst_15496 = inst_15520;
var inst_15497 = inst_15519;
var inst_15498 = inst_15521;
var inst_15499 = (0);
var state_15556__$1 = (function (){var statearr_15591 = state_15556;
(statearr_15591[(9)] = inst_15497);

(statearr_15591[(20)] = inst_15496);

(statearr_15591[(10)] = inst_15499);

(statearr_15591[(21)] = inst_15498);

return statearr_15591;
})();
var statearr_15592_15666 = state_15556__$1;
(statearr_15592_15666[(2)] = null);

(statearr_15592_15666[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (41))){
var inst_15515 = (state_15556[(25)]);
var inst_15531 = (state_15556[(2)]);
var inst_15532 = cljs.core.next(inst_15515);
var inst_15496 = inst_15532;
var inst_15497 = null;
var inst_15498 = (0);
var inst_15499 = (0);
var state_15556__$1 = (function (){var statearr_15593 = state_15556;
(statearr_15593[(9)] = inst_15497);

(statearr_15593[(27)] = inst_15531);

(statearr_15593[(20)] = inst_15496);

(statearr_15593[(10)] = inst_15499);

(statearr_15593[(21)] = inst_15498);

return statearr_15593;
})();
var statearr_15594_15667 = state_15556__$1;
(statearr_15594_15667[(2)] = null);

(statearr_15594_15667[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (43))){
var state_15556__$1 = state_15556;
var statearr_15595_15668 = state_15556__$1;
(statearr_15595_15668[(2)] = null);

(statearr_15595_15668[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (29))){
var inst_15540 = (state_15556[(2)]);
var state_15556__$1 = state_15556;
var statearr_15596_15669 = state_15556__$1;
(statearr_15596_15669[(2)] = inst_15540);

(statearr_15596_15669[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (44))){
var inst_15549 = (state_15556[(2)]);
var state_15556__$1 = (function (){var statearr_15597 = state_15556;
(statearr_15597[(28)] = inst_15549);

return statearr_15597;
})();
var statearr_15598_15670 = state_15556__$1;
(statearr_15598_15670[(2)] = null);

(statearr_15598_15670[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (6))){
var inst_15488 = (state_15556[(29)]);
var inst_15487 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_15488__$1 = cljs.core.keys(inst_15487);
var inst_15489 = cljs.core.count(inst_15488__$1);
var inst_15490 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_15489) : cljs.core.reset_BANG_.call(null,dctr,inst_15489));
var inst_15495 = cljs.core.seq(inst_15488__$1);
var inst_15496 = inst_15495;
var inst_15497 = null;
var inst_15498 = (0);
var inst_15499 = (0);
var state_15556__$1 = (function (){var statearr_15599 = state_15556;
(statearr_15599[(9)] = inst_15497);

(statearr_15599[(29)] = inst_15488__$1);

(statearr_15599[(20)] = inst_15496);

(statearr_15599[(10)] = inst_15499);

(statearr_15599[(21)] = inst_15498);

(statearr_15599[(30)] = inst_15490);

return statearr_15599;
})();
var statearr_15600_15671 = state_15556__$1;
(statearr_15600_15671[(2)] = null);

(statearr_15600_15671[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (28))){
var inst_15515 = (state_15556[(25)]);
var inst_15496 = (state_15556[(20)]);
var inst_15515__$1 = cljs.core.seq(inst_15496);
var state_15556__$1 = (function (){var statearr_15601 = state_15556;
(statearr_15601[(25)] = inst_15515__$1);

return statearr_15601;
})();
if(inst_15515__$1){
var statearr_15602_15672 = state_15556__$1;
(statearr_15602_15672[(1)] = (33));

} else {
var statearr_15603_15673 = state_15556__$1;
(statearr_15603_15673[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (25))){
var inst_15499 = (state_15556[(10)]);
var inst_15498 = (state_15556[(21)]);
var inst_15501 = (inst_15499 < inst_15498);
var inst_15502 = inst_15501;
var state_15556__$1 = state_15556;
if(cljs.core.truth_(inst_15502)){
var statearr_15604_15674 = state_15556__$1;
(statearr_15604_15674[(1)] = (27));

} else {
var statearr_15605_15675 = state_15556__$1;
(statearr_15605_15675[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (34))){
var state_15556__$1 = state_15556;
var statearr_15606_15676 = state_15556__$1;
(statearr_15606_15676[(2)] = null);

(statearr_15606_15676[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (17))){
var state_15556__$1 = state_15556;
var statearr_15607_15677 = state_15556__$1;
(statearr_15607_15677[(2)] = null);

(statearr_15607_15677[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (3))){
var inst_15554 = (state_15556[(2)]);
var state_15556__$1 = state_15556;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15556__$1,inst_15554);
} else {
if((state_val_15557 === (12))){
var inst_15483 = (state_15556[(2)]);
var state_15556__$1 = state_15556;
var statearr_15608_15678 = state_15556__$1;
(statearr_15608_15678[(2)] = inst_15483);

(statearr_15608_15678[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (2))){
var state_15556__$1 = state_15556;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15556__$1,(4),ch);
} else {
if((state_val_15557 === (23))){
var state_15556__$1 = state_15556;
var statearr_15609_15679 = state_15556__$1;
(statearr_15609_15679[(2)] = null);

(statearr_15609_15679[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (35))){
var inst_15538 = (state_15556[(2)]);
var state_15556__$1 = state_15556;
var statearr_15610_15680 = state_15556__$1;
(statearr_15610_15680[(2)] = inst_15538);

(statearr_15610_15680[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (19))){
var inst_15457 = (state_15556[(7)]);
var inst_15461 = cljs.core.chunk_first(inst_15457);
var inst_15462 = cljs.core.chunk_rest(inst_15457);
var inst_15463 = cljs.core.count(inst_15461);
var inst_15437 = inst_15462;
var inst_15438 = inst_15461;
var inst_15439 = inst_15463;
var inst_15440 = (0);
var state_15556__$1 = (function (){var statearr_15611 = state_15556;
(statearr_15611[(13)] = inst_15439);

(statearr_15611[(14)] = inst_15438);

(statearr_15611[(15)] = inst_15440);

(statearr_15611[(17)] = inst_15437);

return statearr_15611;
})();
var statearr_15612_15681 = state_15556__$1;
(statearr_15612_15681[(2)] = null);

(statearr_15612_15681[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (11))){
var inst_15457 = (state_15556[(7)]);
var inst_15437 = (state_15556[(17)]);
var inst_15457__$1 = cljs.core.seq(inst_15437);
var state_15556__$1 = (function (){var statearr_15613 = state_15556;
(statearr_15613[(7)] = inst_15457__$1);

return statearr_15613;
})();
if(inst_15457__$1){
var statearr_15614_15682 = state_15556__$1;
(statearr_15614_15682[(1)] = (16));

} else {
var statearr_15615_15683 = state_15556__$1;
(statearr_15615_15683[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (9))){
var inst_15485 = (state_15556[(2)]);
var state_15556__$1 = state_15556;
var statearr_15616_15684 = state_15556__$1;
(statearr_15616_15684[(2)] = inst_15485);

(statearr_15616_15684[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (5))){
var inst_15435 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_15436 = cljs.core.seq(inst_15435);
var inst_15437 = inst_15436;
var inst_15438 = null;
var inst_15439 = (0);
var inst_15440 = (0);
var state_15556__$1 = (function (){var statearr_15617 = state_15556;
(statearr_15617[(13)] = inst_15439);

(statearr_15617[(14)] = inst_15438);

(statearr_15617[(15)] = inst_15440);

(statearr_15617[(17)] = inst_15437);

return statearr_15617;
})();
var statearr_15618_15685 = state_15556__$1;
(statearr_15618_15685[(2)] = null);

(statearr_15618_15685[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (14))){
var state_15556__$1 = state_15556;
var statearr_15619_15686 = state_15556__$1;
(statearr_15619_15686[(2)] = null);

(statearr_15619_15686[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (45))){
var inst_15546 = (state_15556[(2)]);
var state_15556__$1 = state_15556;
var statearr_15620_15687 = state_15556__$1;
(statearr_15620_15687[(2)] = inst_15546);

(statearr_15620_15687[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (26))){
var inst_15488 = (state_15556[(29)]);
var inst_15542 = (state_15556[(2)]);
var inst_15543 = cljs.core.seq(inst_15488);
var state_15556__$1 = (function (){var statearr_15621 = state_15556;
(statearr_15621[(31)] = inst_15542);

return statearr_15621;
})();
if(inst_15543){
var statearr_15622_15688 = state_15556__$1;
(statearr_15622_15688[(1)] = (42));

} else {
var statearr_15623_15689 = state_15556__$1;
(statearr_15623_15689[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (16))){
var inst_15457 = (state_15556[(7)]);
var inst_15459 = cljs.core.chunked_seq_QMARK_(inst_15457);
var state_15556__$1 = state_15556;
if(inst_15459){
var statearr_15624_15690 = state_15556__$1;
(statearr_15624_15690[(1)] = (19));

} else {
var statearr_15625_15691 = state_15556__$1;
(statearr_15625_15691[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (38))){
var inst_15535 = (state_15556[(2)]);
var state_15556__$1 = state_15556;
var statearr_15626_15692 = state_15556__$1;
(statearr_15626_15692[(2)] = inst_15535);

(statearr_15626_15692[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (30))){
var state_15556__$1 = state_15556;
var statearr_15627_15693 = state_15556__$1;
(statearr_15627_15693[(2)] = null);

(statearr_15627_15693[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (10))){
var inst_15438 = (state_15556[(14)]);
var inst_15440 = (state_15556[(15)]);
var inst_15446 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_15438,inst_15440);
var inst_15447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15446,(0),null);
var inst_15448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15446,(1),null);
var state_15556__$1 = (function (){var statearr_15628 = state_15556;
(statearr_15628[(26)] = inst_15447);

return statearr_15628;
})();
if(cljs.core.truth_(inst_15448)){
var statearr_15629_15694 = state_15556__$1;
(statearr_15629_15694[(1)] = (13));

} else {
var statearr_15630_15695 = state_15556__$1;
(statearr_15630_15695[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (18))){
var inst_15481 = (state_15556[(2)]);
var state_15556__$1 = state_15556;
var statearr_15631_15696 = state_15556__$1;
(statearr_15631_15696[(2)] = inst_15481);

(statearr_15631_15696[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (42))){
var state_15556__$1 = state_15556;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15556__$1,(45),dchan);
} else {
if((state_val_15557 === (37))){
var inst_15515 = (state_15556[(25)]);
var inst_15524 = (state_15556[(23)]);
var inst_15428 = (state_15556[(12)]);
var inst_15524__$1 = cljs.core.first(inst_15515);
var inst_15525 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_15524__$1,inst_15428,done);
var state_15556__$1 = (function (){var statearr_15632 = state_15556;
(statearr_15632[(23)] = inst_15524__$1);

return statearr_15632;
})();
if(cljs.core.truth_(inst_15525)){
var statearr_15633_15697 = state_15556__$1;
(statearr_15633_15697[(1)] = (39));

} else {
var statearr_15634_15698 = state_15556__$1;
(statearr_15634_15698[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15557 === (8))){
var inst_15439 = (state_15556[(13)]);
var inst_15440 = (state_15556[(15)]);
var inst_15442 = (inst_15440 < inst_15439);
var inst_15443 = inst_15442;
var state_15556__$1 = state_15556;
if(cljs.core.truth_(inst_15443)){
var statearr_15635_15699 = state_15556__$1;
(statearr_15635_15699[(1)] = (10));

} else {
var statearr_15636_15700 = state_15556__$1;
(statearr_15636_15700[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto___15646,cs,m,dchan,dctr,done))
;
return ((function (switch__14250__auto__,c__14364__auto___15646,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__14251__auto__ = null;
var cljs$core$async$mult_$_state_machine__14251__auto____0 = (function (){
var statearr_15640 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15640[(0)] = cljs$core$async$mult_$_state_machine__14251__auto__);

(statearr_15640[(1)] = (1));

return statearr_15640;
});
var cljs$core$async$mult_$_state_machine__14251__auto____1 = (function (state_15556){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_15556);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e15641){if((e15641 instanceof Object)){
var ex__14254__auto__ = e15641;
var statearr_15642_15701 = state_15556;
(statearr_15642_15701[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15556);

return cljs.core.cst$kw$recur;
} else {
throw e15641;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__15702 = state_15556;
state_15556 = G__15702;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14251__auto__ = function(state_15556){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14251__auto____1.call(this,state_15556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14251__auto____0;
cljs$core$async$mult_$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14251__auto____1;
return cljs$core$async$mult_$_state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto___15646,cs,m,dchan,dctr,done))
})();
var state__14366__auto__ = (function (){var statearr_15643 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_15643[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___15646);

return statearr_15643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto___15646,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15703 = [];
var len__7094__auto___15706 = arguments.length;
var i__7095__auto___15707 = (0);
while(true){
if((i__7095__auto___15707 < len__7094__auto___15706)){
args15703.push((arguments[i__7095__auto___15707]));

var G__15708 = (i__7095__auto___15707 + (1));
i__7095__auto___15707 = G__15708;
continue;
} else {
}
break;
}

var G__15705 = args15703.length;
switch (G__15705) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15703.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6691__auto__ = (((m == null))?null:m);
var m__6692__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6691__auto__)]);
if(!((m__6692__auto__ == null))){
return (m__6692__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6692__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6692__auto__.call(null,m,ch));
} else {
var m__6692__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6692__auto____$1 == null))){
return (m__6692__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6692__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6692__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6691__auto__ = (((m == null))?null:m);
var m__6692__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6691__auto__)]);
if(!((m__6692__auto__ == null))){
return (m__6692__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6692__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6692__auto__.call(null,m,ch));
} else {
var m__6692__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6692__auto____$1 == null))){
return (m__6692__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6692__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6692__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6691__auto__ = (((m == null))?null:m);
var m__6692__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6691__auto__)]);
if(!((m__6692__auto__ == null))){
return (m__6692__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6692__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__6692__auto__.call(null,m));
} else {
var m__6692__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6692__auto____$1 == null))){
return (m__6692__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6692__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__6692__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6691__auto__ = (((m == null))?null:m);
var m__6692__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6691__auto__)]);
if(!((m__6692__auto__ == null))){
return (m__6692__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6692__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__6692__auto__.call(null,m,state_map));
} else {
var m__6692__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6692__auto____$1 == null))){
return (m__6692__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6692__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__6692__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6691__auto__ = (((m == null))?null:m);
var m__6692__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6691__auto__)]);
if(!((m__6692__auto__ == null))){
return (m__6692__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6692__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__6692__auto__.call(null,m,mode));
} else {
var m__6692__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6692__auto____$1 == null))){
return (m__6692__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6692__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__6692__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7101__auto__ = [];
var len__7094__auto___15720 = arguments.length;
var i__7095__auto___15721 = (0);
while(true){
if((i__7095__auto___15721 < len__7094__auto___15720)){
args__7101__auto__.push((arguments[i__7095__auto___15721]));

var G__15722 = (i__7095__auto___15721 + (1));
i__7095__auto___15721 = G__15722;
continue;
} else {
}
break;
}

var argseq__7102__auto__ = ((((3) < args__7101__auto__.length))?(new cljs.core.IndexedSeq(args__7101__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7102__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15714){
var map__15715 = p__15714;
var map__15715__$1 = ((((!((map__15715 == null)))?((((map__15715.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15715.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15715):map__15715);
var opts = map__15715__$1;
var statearr_15717_15723 = state;
(statearr_15717_15723[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts(((function (map__15715,map__15715__$1,opts){
return (function (val){
var statearr_15718_15724 = state;
(statearr_15718_15724[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__15715,map__15715__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_15719_15725 = state;
(statearr_15719_15725[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15710){
var G__15711 = cljs.core.first(seq15710);
var seq15710__$1 = cljs.core.next(seq15710);
var G__15712 = cljs.core.first(seq15710__$1);
var seq15710__$2 = cljs.core.next(seq15710__$1);
var G__15713 = cljs.core.first(seq15710__$2);
var seq15710__$3 = cljs.core.next(seq15710__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15711,G__15712,G__15713,seq15710__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__15892 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__15892) : cljs.core.atom.call(null,G__15892));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute) : cljs.core.atom.call(null,cljs.core.cst$kw$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15893 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15893 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta15894){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta15894 = meta15894;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15893.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_15895,meta15894__$1){
var self__ = this;
var _15895__$1 = this;
return (new cljs.core.async.t_cljs$core$async15893(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta15894__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15893.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_15895){
var self__ = this;
var _15895__$1 = this;
return self__.meta15894;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15893.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15893.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15893.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async15893.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15893.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15893.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__15896_16058 = self__.cs;
var G__15897_16059 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__15896_16058,G__15897_16059) : cljs.core.reset_BANG_.call(null,G__15896_16058,G__15897_16059));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15893.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15893.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$mode)], 0)))].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15893.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta15894], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15893.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15893.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15893";

cljs.core.async.t_cljs$core$async15893.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6634__auto__,writer__6635__auto__,opt__6636__auto__){
return cljs.core._write(writer__6635__auto__,"cljs.core.async/t_cljs$core$async15893");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async15893 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async15893(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta15894){
return (new cljs.core.async.t_cljs$core$async15893(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta15894));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async15893(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14364__auto___16060 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto___16060,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto___16060,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_15995){
var state_val_15996 = (state_15995[(1)]);
if((state_val_15996 === (7))){
var inst_15913 = (state_15995[(2)]);
var state_15995__$1 = state_15995;
var statearr_15997_16061 = state_15995__$1;
(statearr_15997_16061[(2)] = inst_15913);

(statearr_15997_16061[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (20))){
var inst_15925 = (state_15995[(7)]);
var state_15995__$1 = state_15995;
var statearr_15998_16062 = state_15995__$1;
(statearr_15998_16062[(2)] = inst_15925);

(statearr_15998_16062[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (27))){
var state_15995__$1 = state_15995;
var statearr_15999_16063 = state_15995__$1;
(statearr_15999_16063[(2)] = null);

(statearr_15999_16063[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (1))){
var inst_15901 = (state_15995[(8)]);
var inst_15901__$1 = calc_state();
var inst_15903 = (inst_15901__$1 == null);
var inst_15904 = cljs.core.not(inst_15903);
var state_15995__$1 = (function (){var statearr_16000 = state_15995;
(statearr_16000[(8)] = inst_15901__$1);

return statearr_16000;
})();
if(inst_15904){
var statearr_16001_16064 = state_15995__$1;
(statearr_16001_16064[(1)] = (2));

} else {
var statearr_16002_16065 = state_15995__$1;
(statearr_16002_16065[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (24))){
var inst_15955 = (state_15995[(9)]);
var inst_15969 = (state_15995[(10)]);
var inst_15948 = (state_15995[(11)]);
var inst_15969__$1 = (inst_15948.cljs$core$IFn$_invoke$arity$1 ? inst_15948.cljs$core$IFn$_invoke$arity$1(inst_15955) : inst_15948.call(null,inst_15955));
var state_15995__$1 = (function (){var statearr_16003 = state_15995;
(statearr_16003[(10)] = inst_15969__$1);

return statearr_16003;
})();
if(cljs.core.truth_(inst_15969__$1)){
var statearr_16004_16066 = state_15995__$1;
(statearr_16004_16066[(1)] = (29));

} else {
var statearr_16005_16067 = state_15995__$1;
(statearr_16005_16067[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (4))){
var inst_15916 = (state_15995[(2)]);
var state_15995__$1 = state_15995;
if(cljs.core.truth_(inst_15916)){
var statearr_16006_16068 = state_15995__$1;
(statearr_16006_16068[(1)] = (8));

} else {
var statearr_16007_16069 = state_15995__$1;
(statearr_16007_16069[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (15))){
var inst_15942 = (state_15995[(2)]);
var state_15995__$1 = state_15995;
if(cljs.core.truth_(inst_15942)){
var statearr_16008_16070 = state_15995__$1;
(statearr_16008_16070[(1)] = (19));

} else {
var statearr_16009_16071 = state_15995__$1;
(statearr_16009_16071[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (21))){
var inst_15947 = (state_15995[(12)]);
var inst_15947__$1 = (state_15995[(2)]);
var inst_15948 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15947__$1,cljs.core.cst$kw$solos);
var inst_15949 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15947__$1,cljs.core.cst$kw$mutes);
var inst_15950 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15947__$1,cljs.core.cst$kw$reads);
var state_15995__$1 = (function (){var statearr_16010 = state_15995;
(statearr_16010[(12)] = inst_15947__$1);

(statearr_16010[(11)] = inst_15948);

(statearr_16010[(13)] = inst_15949);

return statearr_16010;
})();
return cljs.core.async.ioc_alts_BANG_(state_15995__$1,(22),inst_15950);
} else {
if((state_val_15996 === (31))){
var inst_15977 = (state_15995[(2)]);
var state_15995__$1 = state_15995;
if(cljs.core.truth_(inst_15977)){
var statearr_16011_16072 = state_15995__$1;
(statearr_16011_16072[(1)] = (32));

} else {
var statearr_16012_16073 = state_15995__$1;
(statearr_16012_16073[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (32))){
var inst_15954 = (state_15995[(14)]);
var state_15995__$1 = state_15995;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15995__$1,(35),out,inst_15954);
} else {
if((state_val_15996 === (33))){
var inst_15947 = (state_15995[(12)]);
var inst_15925 = inst_15947;
var state_15995__$1 = (function (){var statearr_16013 = state_15995;
(statearr_16013[(7)] = inst_15925);

return statearr_16013;
})();
var statearr_16014_16074 = state_15995__$1;
(statearr_16014_16074[(2)] = null);

(statearr_16014_16074[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (13))){
var inst_15925 = (state_15995[(7)]);
var inst_15932 = inst_15925.cljs$lang$protocol_mask$partition0$;
var inst_15933 = (inst_15932 & (64));
var inst_15934 = inst_15925.cljs$core$ISeq$;
var inst_15935 = (inst_15933) || (inst_15934);
var state_15995__$1 = state_15995;
if(cljs.core.truth_(inst_15935)){
var statearr_16015_16075 = state_15995__$1;
(statearr_16015_16075[(1)] = (16));

} else {
var statearr_16016_16076 = state_15995__$1;
(statearr_16016_16076[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (22))){
var inst_15955 = (state_15995[(9)]);
var inst_15954 = (state_15995[(14)]);
var inst_15953 = (state_15995[(2)]);
var inst_15954__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15953,(0),null);
var inst_15955__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15953,(1),null);
var inst_15956 = (inst_15954__$1 == null);
var inst_15957 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15955__$1,change);
var inst_15958 = (inst_15956) || (inst_15957);
var state_15995__$1 = (function (){var statearr_16017 = state_15995;
(statearr_16017[(9)] = inst_15955__$1);

(statearr_16017[(14)] = inst_15954__$1);

return statearr_16017;
})();
if(cljs.core.truth_(inst_15958)){
var statearr_16018_16077 = state_15995__$1;
(statearr_16018_16077[(1)] = (23));

} else {
var statearr_16019_16078 = state_15995__$1;
(statearr_16019_16078[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (36))){
var inst_15947 = (state_15995[(12)]);
var inst_15925 = inst_15947;
var state_15995__$1 = (function (){var statearr_16020 = state_15995;
(statearr_16020[(7)] = inst_15925);

return statearr_16020;
})();
var statearr_16021_16079 = state_15995__$1;
(statearr_16021_16079[(2)] = null);

(statearr_16021_16079[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (29))){
var inst_15969 = (state_15995[(10)]);
var state_15995__$1 = state_15995;
var statearr_16022_16080 = state_15995__$1;
(statearr_16022_16080[(2)] = inst_15969);

(statearr_16022_16080[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (6))){
var state_15995__$1 = state_15995;
var statearr_16023_16081 = state_15995__$1;
(statearr_16023_16081[(2)] = false);

(statearr_16023_16081[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (28))){
var inst_15965 = (state_15995[(2)]);
var inst_15966 = calc_state();
var inst_15925 = inst_15966;
var state_15995__$1 = (function (){var statearr_16024 = state_15995;
(statearr_16024[(7)] = inst_15925);

(statearr_16024[(15)] = inst_15965);

return statearr_16024;
})();
var statearr_16025_16082 = state_15995__$1;
(statearr_16025_16082[(2)] = null);

(statearr_16025_16082[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (25))){
var inst_15991 = (state_15995[(2)]);
var state_15995__$1 = state_15995;
var statearr_16026_16083 = state_15995__$1;
(statearr_16026_16083[(2)] = inst_15991);

(statearr_16026_16083[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (34))){
var inst_15989 = (state_15995[(2)]);
var state_15995__$1 = state_15995;
var statearr_16027_16084 = state_15995__$1;
(statearr_16027_16084[(2)] = inst_15989);

(statearr_16027_16084[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (17))){
var state_15995__$1 = state_15995;
var statearr_16028_16085 = state_15995__$1;
(statearr_16028_16085[(2)] = false);

(statearr_16028_16085[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (3))){
var state_15995__$1 = state_15995;
var statearr_16029_16086 = state_15995__$1;
(statearr_16029_16086[(2)] = false);

(statearr_16029_16086[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (12))){
var inst_15993 = (state_15995[(2)]);
var state_15995__$1 = state_15995;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15995__$1,inst_15993);
} else {
if((state_val_15996 === (2))){
var inst_15901 = (state_15995[(8)]);
var inst_15906 = inst_15901.cljs$lang$protocol_mask$partition0$;
var inst_15907 = (inst_15906 & (64));
var inst_15908 = inst_15901.cljs$core$ISeq$;
var inst_15909 = (inst_15907) || (inst_15908);
var state_15995__$1 = state_15995;
if(cljs.core.truth_(inst_15909)){
var statearr_16030_16087 = state_15995__$1;
(statearr_16030_16087[(1)] = (5));

} else {
var statearr_16031_16088 = state_15995__$1;
(statearr_16031_16088[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (23))){
var inst_15954 = (state_15995[(14)]);
var inst_15960 = (inst_15954 == null);
var state_15995__$1 = state_15995;
if(cljs.core.truth_(inst_15960)){
var statearr_16032_16089 = state_15995__$1;
(statearr_16032_16089[(1)] = (26));

} else {
var statearr_16033_16090 = state_15995__$1;
(statearr_16033_16090[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (35))){
var inst_15980 = (state_15995[(2)]);
var state_15995__$1 = state_15995;
if(cljs.core.truth_(inst_15980)){
var statearr_16034_16091 = state_15995__$1;
(statearr_16034_16091[(1)] = (36));

} else {
var statearr_16035_16092 = state_15995__$1;
(statearr_16035_16092[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (19))){
var inst_15925 = (state_15995[(7)]);
var inst_15944 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_15925);
var state_15995__$1 = state_15995;
var statearr_16036_16093 = state_15995__$1;
(statearr_16036_16093[(2)] = inst_15944);

(statearr_16036_16093[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (11))){
var inst_15925 = (state_15995[(7)]);
var inst_15929 = (inst_15925 == null);
var inst_15930 = cljs.core.not(inst_15929);
var state_15995__$1 = state_15995;
if(inst_15930){
var statearr_16037_16094 = state_15995__$1;
(statearr_16037_16094[(1)] = (13));

} else {
var statearr_16038_16095 = state_15995__$1;
(statearr_16038_16095[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (9))){
var inst_15901 = (state_15995[(8)]);
var state_15995__$1 = state_15995;
var statearr_16039_16096 = state_15995__$1;
(statearr_16039_16096[(2)] = inst_15901);

(statearr_16039_16096[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (5))){
var state_15995__$1 = state_15995;
var statearr_16040_16097 = state_15995__$1;
(statearr_16040_16097[(2)] = true);

(statearr_16040_16097[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (14))){
var state_15995__$1 = state_15995;
var statearr_16041_16098 = state_15995__$1;
(statearr_16041_16098[(2)] = false);

(statearr_16041_16098[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (26))){
var inst_15955 = (state_15995[(9)]);
var inst_15962 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_15955);
var state_15995__$1 = state_15995;
var statearr_16042_16099 = state_15995__$1;
(statearr_16042_16099[(2)] = inst_15962);

(statearr_16042_16099[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (16))){
var state_15995__$1 = state_15995;
var statearr_16043_16100 = state_15995__$1;
(statearr_16043_16100[(2)] = true);

(statearr_16043_16100[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (38))){
var inst_15985 = (state_15995[(2)]);
var state_15995__$1 = state_15995;
var statearr_16044_16101 = state_15995__$1;
(statearr_16044_16101[(2)] = inst_15985);

(statearr_16044_16101[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (30))){
var inst_15955 = (state_15995[(9)]);
var inst_15948 = (state_15995[(11)]);
var inst_15949 = (state_15995[(13)]);
var inst_15972 = cljs.core.empty_QMARK_(inst_15948);
var inst_15973 = (inst_15949.cljs$core$IFn$_invoke$arity$1 ? inst_15949.cljs$core$IFn$_invoke$arity$1(inst_15955) : inst_15949.call(null,inst_15955));
var inst_15974 = cljs.core.not(inst_15973);
var inst_15975 = (inst_15972) && (inst_15974);
var state_15995__$1 = state_15995;
var statearr_16045_16102 = state_15995__$1;
(statearr_16045_16102[(2)] = inst_15975);

(statearr_16045_16102[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (10))){
var inst_15901 = (state_15995[(8)]);
var inst_15921 = (state_15995[(2)]);
var inst_15922 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15921,cljs.core.cst$kw$solos);
var inst_15923 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15921,cljs.core.cst$kw$mutes);
var inst_15924 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15921,cljs.core.cst$kw$reads);
var inst_15925 = inst_15901;
var state_15995__$1 = (function (){var statearr_16046 = state_15995;
(statearr_16046[(16)] = inst_15923);

(statearr_16046[(17)] = inst_15922);

(statearr_16046[(7)] = inst_15925);

(statearr_16046[(18)] = inst_15924);

return statearr_16046;
})();
var statearr_16047_16103 = state_15995__$1;
(statearr_16047_16103[(2)] = null);

(statearr_16047_16103[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (18))){
var inst_15939 = (state_15995[(2)]);
var state_15995__$1 = state_15995;
var statearr_16048_16104 = state_15995__$1;
(statearr_16048_16104[(2)] = inst_15939);

(statearr_16048_16104[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (37))){
var state_15995__$1 = state_15995;
var statearr_16049_16105 = state_15995__$1;
(statearr_16049_16105[(2)] = null);

(statearr_16049_16105[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15996 === (8))){
var inst_15901 = (state_15995[(8)]);
var inst_15918 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_15901);
var state_15995__$1 = state_15995;
var statearr_16050_16106 = state_15995__$1;
(statearr_16050_16106[(2)] = inst_15918);

(statearr_16050_16106[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto___16060,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__14250__auto__,c__14364__auto___16060,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__14251__auto__ = null;
var cljs$core$async$mix_$_state_machine__14251__auto____0 = (function (){
var statearr_16054 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16054[(0)] = cljs$core$async$mix_$_state_machine__14251__auto__);

(statearr_16054[(1)] = (1));

return statearr_16054;
});
var cljs$core$async$mix_$_state_machine__14251__auto____1 = (function (state_15995){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_15995);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e16055){if((e16055 instanceof Object)){
var ex__14254__auto__ = e16055;
var statearr_16056_16107 = state_15995;
(statearr_16056_16107[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15995);

return cljs.core.cst$kw$recur;
} else {
throw e16055;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__16108 = state_15995;
state_15995 = G__16108;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14251__auto__ = function(state_15995){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14251__auto____1.call(this,state_15995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14251__auto____0;
cljs$core$async$mix_$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14251__auto____1;
return cljs$core$async$mix_$_state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto___16060,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__14366__auto__ = (function (){var statearr_16057 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_16057[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___16060);

return statearr_16057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto___16060,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6691__auto__ = (((p == null))?null:p);
var m__6692__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6691__auto__)]);
if(!((m__6692__auto__ == null))){
return (m__6692__auto__.cljs$core$IFn$_invoke$arity$4 ? m__6692__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__6692__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__6692__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6692__auto____$1 == null))){
return (m__6692__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__6692__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__6692__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6691__auto__ = (((p == null))?null:p);
var m__6692__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6691__auto__)]);
if(!((m__6692__auto__ == null))){
return (m__6692__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6692__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__6692__auto__.call(null,p,v,ch));
} else {
var m__6692__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6692__auto____$1 == null))){
return (m__6692__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6692__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__6692__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args16109 = [];
var len__7094__auto___16112 = arguments.length;
var i__7095__auto___16113 = (0);
while(true){
if((i__7095__auto___16113 < len__7094__auto___16112)){
args16109.push((arguments[i__7095__auto___16113]));

var G__16114 = (i__7095__auto___16113 + (1));
i__7095__auto___16113 = G__16114;
continue;
} else {
}
break;
}

var G__16111 = args16109.length;
switch (G__16111) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16109.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6691__auto__ = (((p == null))?null:p);
var m__6692__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6691__auto__)]);
if(!((m__6692__auto__ == null))){
return (m__6692__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6692__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__6692__auto__.call(null,p));
} else {
var m__6692__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6692__auto____$1 == null))){
return (m__6692__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6692__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__6692__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6691__auto__ = (((p == null))?null:p);
var m__6692__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6691__auto__)]);
if(!((m__6692__auto__ == null))){
return (m__6692__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6692__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__6692__auto__.call(null,p,v));
} else {
var m__6692__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6692__auto____$1 == null))){
return (m__6692__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6692__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__6692__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args16117 = [];
var len__7094__auto___16245 = arguments.length;
var i__7095__auto___16246 = (0);
while(true){
if((i__7095__auto___16246 < len__7094__auto___16245)){
args16117.push((arguments[i__7095__auto___16246]));

var G__16247 = (i__7095__auto___16246 + (1));
i__7095__auto___16246 = G__16247;
continue;
} else {
}
break;
}

var G__16119 = args16117.length;
switch (G__16119) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16117.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__16120 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16120) : cljs.core.atom.call(null,G__16120));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6036__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6036__auto__)){
return or__6036__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6036__auto__,mults){
return (function (p1__16116_SHARP_){
if(cljs.core.truth_((p1__16116_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16116_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__16116_SHARP_.call(null,topic)))){
return p1__16116_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__16116_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6036__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async16121 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16121 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16122){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16122 = meta16122;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16121.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_16123,meta16122__$1){
var self__ = this;
var _16123__$1 = this;
return (new cljs.core.async.t_cljs$core$async16121(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16122__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16121.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_16123){
var self__ = this;
var _16123__$1 = this;
return self__.meta16122;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16121.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16121.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16121.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async16121.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16121.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16121.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__16124 = self__.mults;
var G__16125 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__16124,G__16125) : cljs.core.reset_BANG_.call(null,G__16124,G__16125));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16121.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16121.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta16122], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16121.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16121.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16121";

cljs.core.async.t_cljs$core$async16121.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6634__auto__,writer__6635__auto__,opt__6636__auto__){
return cljs.core._write(writer__6635__auto__,"cljs.core.async/t_cljs$core$async16121");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async16121 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async16121(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16122){
return (new cljs.core.async.t_cljs$core$async16121(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16122));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async16121(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14364__auto___16249 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto___16249,mults,ensure_mult,p){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto___16249,mults,ensure_mult,p){
return (function (state_16197){
var state_val_16198 = (state_16197[(1)]);
if((state_val_16198 === (7))){
var inst_16193 = (state_16197[(2)]);
var state_16197__$1 = state_16197;
var statearr_16199_16250 = state_16197__$1;
(statearr_16199_16250[(2)] = inst_16193);

(statearr_16199_16250[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (20))){
var state_16197__$1 = state_16197;
var statearr_16200_16251 = state_16197__$1;
(statearr_16200_16251[(2)] = null);

(statearr_16200_16251[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (1))){
var state_16197__$1 = state_16197;
var statearr_16201_16252 = state_16197__$1;
(statearr_16201_16252[(2)] = null);

(statearr_16201_16252[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (24))){
var inst_16176 = (state_16197[(7)]);
var inst_16185 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_16176);
var state_16197__$1 = state_16197;
var statearr_16202_16253 = state_16197__$1;
(statearr_16202_16253[(2)] = inst_16185);

(statearr_16202_16253[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (4))){
var inst_16128 = (state_16197[(8)]);
var inst_16128__$1 = (state_16197[(2)]);
var inst_16129 = (inst_16128__$1 == null);
var state_16197__$1 = (function (){var statearr_16203 = state_16197;
(statearr_16203[(8)] = inst_16128__$1);

return statearr_16203;
})();
if(cljs.core.truth_(inst_16129)){
var statearr_16204_16254 = state_16197__$1;
(statearr_16204_16254[(1)] = (5));

} else {
var statearr_16205_16255 = state_16197__$1;
(statearr_16205_16255[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (15))){
var inst_16170 = (state_16197[(2)]);
var state_16197__$1 = state_16197;
var statearr_16206_16256 = state_16197__$1;
(statearr_16206_16256[(2)] = inst_16170);

(statearr_16206_16256[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (21))){
var inst_16190 = (state_16197[(2)]);
var state_16197__$1 = (function (){var statearr_16207 = state_16197;
(statearr_16207[(9)] = inst_16190);

return statearr_16207;
})();
var statearr_16208_16257 = state_16197__$1;
(statearr_16208_16257[(2)] = null);

(statearr_16208_16257[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (13))){
var inst_16152 = (state_16197[(10)]);
var inst_16154 = cljs.core.chunked_seq_QMARK_(inst_16152);
var state_16197__$1 = state_16197;
if(inst_16154){
var statearr_16209_16258 = state_16197__$1;
(statearr_16209_16258[(1)] = (16));

} else {
var statearr_16210_16259 = state_16197__$1;
(statearr_16210_16259[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (22))){
var inst_16182 = (state_16197[(2)]);
var state_16197__$1 = state_16197;
if(cljs.core.truth_(inst_16182)){
var statearr_16211_16260 = state_16197__$1;
(statearr_16211_16260[(1)] = (23));

} else {
var statearr_16212_16261 = state_16197__$1;
(statearr_16212_16261[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (6))){
var inst_16176 = (state_16197[(7)]);
var inst_16178 = (state_16197[(11)]);
var inst_16128 = (state_16197[(8)]);
var inst_16176__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_16128) : topic_fn.call(null,inst_16128));
var inst_16177 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_16178__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16177,inst_16176__$1);
var state_16197__$1 = (function (){var statearr_16213 = state_16197;
(statearr_16213[(7)] = inst_16176__$1);

(statearr_16213[(11)] = inst_16178__$1);

return statearr_16213;
})();
if(cljs.core.truth_(inst_16178__$1)){
var statearr_16214_16262 = state_16197__$1;
(statearr_16214_16262[(1)] = (19));

} else {
var statearr_16215_16263 = state_16197__$1;
(statearr_16215_16263[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (25))){
var inst_16187 = (state_16197[(2)]);
var state_16197__$1 = state_16197;
var statearr_16216_16264 = state_16197__$1;
(statearr_16216_16264[(2)] = inst_16187);

(statearr_16216_16264[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (17))){
var inst_16152 = (state_16197[(10)]);
var inst_16161 = cljs.core.first(inst_16152);
var inst_16162 = cljs.core.async.muxch_STAR_(inst_16161);
var inst_16163 = cljs.core.async.close_BANG_(inst_16162);
var inst_16164 = cljs.core.next(inst_16152);
var inst_16138 = inst_16164;
var inst_16139 = null;
var inst_16140 = (0);
var inst_16141 = (0);
var state_16197__$1 = (function (){var statearr_16217 = state_16197;
(statearr_16217[(12)] = inst_16138);

(statearr_16217[(13)] = inst_16139);

(statearr_16217[(14)] = inst_16163);

(statearr_16217[(15)] = inst_16141);

(statearr_16217[(16)] = inst_16140);

return statearr_16217;
})();
var statearr_16218_16265 = state_16197__$1;
(statearr_16218_16265[(2)] = null);

(statearr_16218_16265[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (3))){
var inst_16195 = (state_16197[(2)]);
var state_16197__$1 = state_16197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16197__$1,inst_16195);
} else {
if((state_val_16198 === (12))){
var inst_16172 = (state_16197[(2)]);
var state_16197__$1 = state_16197;
var statearr_16219_16266 = state_16197__$1;
(statearr_16219_16266[(2)] = inst_16172);

(statearr_16219_16266[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (2))){
var state_16197__$1 = state_16197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16197__$1,(4),ch);
} else {
if((state_val_16198 === (23))){
var state_16197__$1 = state_16197;
var statearr_16220_16267 = state_16197__$1;
(statearr_16220_16267[(2)] = null);

(statearr_16220_16267[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (19))){
var inst_16178 = (state_16197[(11)]);
var inst_16128 = (state_16197[(8)]);
var inst_16180 = cljs.core.async.muxch_STAR_(inst_16178);
var state_16197__$1 = state_16197;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16197__$1,(22),inst_16180,inst_16128);
} else {
if((state_val_16198 === (11))){
var inst_16152 = (state_16197[(10)]);
var inst_16138 = (state_16197[(12)]);
var inst_16152__$1 = cljs.core.seq(inst_16138);
var state_16197__$1 = (function (){var statearr_16221 = state_16197;
(statearr_16221[(10)] = inst_16152__$1);

return statearr_16221;
})();
if(inst_16152__$1){
var statearr_16222_16268 = state_16197__$1;
(statearr_16222_16268[(1)] = (13));

} else {
var statearr_16223_16269 = state_16197__$1;
(statearr_16223_16269[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (9))){
var inst_16174 = (state_16197[(2)]);
var state_16197__$1 = state_16197;
var statearr_16224_16270 = state_16197__$1;
(statearr_16224_16270[(2)] = inst_16174);

(statearr_16224_16270[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (5))){
var inst_16135 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_16136 = cljs.core.vals(inst_16135);
var inst_16137 = cljs.core.seq(inst_16136);
var inst_16138 = inst_16137;
var inst_16139 = null;
var inst_16140 = (0);
var inst_16141 = (0);
var state_16197__$1 = (function (){var statearr_16225 = state_16197;
(statearr_16225[(12)] = inst_16138);

(statearr_16225[(13)] = inst_16139);

(statearr_16225[(15)] = inst_16141);

(statearr_16225[(16)] = inst_16140);

return statearr_16225;
})();
var statearr_16226_16271 = state_16197__$1;
(statearr_16226_16271[(2)] = null);

(statearr_16226_16271[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (14))){
var state_16197__$1 = state_16197;
var statearr_16230_16272 = state_16197__$1;
(statearr_16230_16272[(2)] = null);

(statearr_16230_16272[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (16))){
var inst_16152 = (state_16197[(10)]);
var inst_16156 = cljs.core.chunk_first(inst_16152);
var inst_16157 = cljs.core.chunk_rest(inst_16152);
var inst_16158 = cljs.core.count(inst_16156);
var inst_16138 = inst_16157;
var inst_16139 = inst_16156;
var inst_16140 = inst_16158;
var inst_16141 = (0);
var state_16197__$1 = (function (){var statearr_16231 = state_16197;
(statearr_16231[(12)] = inst_16138);

(statearr_16231[(13)] = inst_16139);

(statearr_16231[(15)] = inst_16141);

(statearr_16231[(16)] = inst_16140);

return statearr_16231;
})();
var statearr_16232_16273 = state_16197__$1;
(statearr_16232_16273[(2)] = null);

(statearr_16232_16273[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (10))){
var inst_16138 = (state_16197[(12)]);
var inst_16139 = (state_16197[(13)]);
var inst_16141 = (state_16197[(15)]);
var inst_16140 = (state_16197[(16)]);
var inst_16146 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16139,inst_16141);
var inst_16147 = cljs.core.async.muxch_STAR_(inst_16146);
var inst_16148 = cljs.core.async.close_BANG_(inst_16147);
var inst_16149 = (inst_16141 + (1));
var tmp16227 = inst_16138;
var tmp16228 = inst_16139;
var tmp16229 = inst_16140;
var inst_16138__$1 = tmp16227;
var inst_16139__$1 = tmp16228;
var inst_16140__$1 = tmp16229;
var inst_16141__$1 = inst_16149;
var state_16197__$1 = (function (){var statearr_16233 = state_16197;
(statearr_16233[(12)] = inst_16138__$1);

(statearr_16233[(13)] = inst_16139__$1);

(statearr_16233[(17)] = inst_16148);

(statearr_16233[(15)] = inst_16141__$1);

(statearr_16233[(16)] = inst_16140__$1);

return statearr_16233;
})();
var statearr_16234_16274 = state_16197__$1;
(statearr_16234_16274[(2)] = null);

(statearr_16234_16274[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (18))){
var inst_16167 = (state_16197[(2)]);
var state_16197__$1 = state_16197;
var statearr_16235_16275 = state_16197__$1;
(statearr_16235_16275[(2)] = inst_16167);

(statearr_16235_16275[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16198 === (8))){
var inst_16141 = (state_16197[(15)]);
var inst_16140 = (state_16197[(16)]);
var inst_16143 = (inst_16141 < inst_16140);
var inst_16144 = inst_16143;
var state_16197__$1 = state_16197;
if(cljs.core.truth_(inst_16144)){
var statearr_16236_16276 = state_16197__$1;
(statearr_16236_16276[(1)] = (10));

} else {
var statearr_16237_16277 = state_16197__$1;
(statearr_16237_16277[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto___16249,mults,ensure_mult,p))
;
return ((function (switch__14250__auto__,c__14364__auto___16249,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__14251__auto__ = null;
var cljs$core$async$state_machine__14251__auto____0 = (function (){
var statearr_16241 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16241[(0)] = cljs$core$async$state_machine__14251__auto__);

(statearr_16241[(1)] = (1));

return statearr_16241;
});
var cljs$core$async$state_machine__14251__auto____1 = (function (state_16197){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_16197);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e16242){if((e16242 instanceof Object)){
var ex__14254__auto__ = e16242;
var statearr_16243_16278 = state_16197;
(statearr_16243_16278[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16197);

return cljs.core.cst$kw$recur;
} else {
throw e16242;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__16279 = state_16197;
state_16197 = G__16279;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$state_machine__14251__auto__ = function(state_16197){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14251__auto____1.call(this,state_16197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14251__auto____0;
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14251__auto____1;
return cljs$core$async$state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto___16249,mults,ensure_mult,p))
})();
var state__14366__auto__ = (function (){var statearr_16244 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_16244[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___16249);

return statearr_16244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto___16249,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args16280 = [];
var len__7094__auto___16283 = arguments.length;
var i__7095__auto___16284 = (0);
while(true){
if((i__7095__auto___16284 < len__7094__auto___16283)){
args16280.push((arguments[i__7095__auto___16284]));

var G__16285 = (i__7095__auto___16284 + (1));
i__7095__auto___16284 = G__16285;
continue;
} else {
}
break;
}

var G__16282 = args16280.length;
switch (G__16282) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16280.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args16287 = [];
var len__7094__auto___16290 = arguments.length;
var i__7095__auto___16291 = (0);
while(true){
if((i__7095__auto___16291 < len__7094__auto___16290)){
args16287.push((arguments[i__7095__auto___16291]));

var G__16292 = (i__7095__auto___16291 + (1));
i__7095__auto___16291 = G__16292;
continue;
} else {
}
break;
}

var G__16289 = args16287.length;
switch (G__16289) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16287.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args16294 = [];
var len__7094__auto___16365 = arguments.length;
var i__7095__auto___16366 = (0);
while(true){
if((i__7095__auto___16366 < len__7094__auto___16365)){
args16294.push((arguments[i__7095__auto___16366]));

var G__16367 = (i__7095__auto___16366 + (1));
i__7095__auto___16366 = G__16367;
continue;
} else {
}
break;
}

var G__16296 = args16294.length;
switch (G__16296) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16294.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__14364__auto___16369 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto___16369,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto___16369,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_16335){
var state_val_16336 = (state_16335[(1)]);
if((state_val_16336 === (7))){
var state_16335__$1 = state_16335;
var statearr_16337_16370 = state_16335__$1;
(statearr_16337_16370[(2)] = null);

(statearr_16337_16370[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16336 === (1))){
var state_16335__$1 = state_16335;
var statearr_16338_16371 = state_16335__$1;
(statearr_16338_16371[(2)] = null);

(statearr_16338_16371[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16336 === (4))){
var inst_16299 = (state_16335[(7)]);
var inst_16301 = (inst_16299 < cnt);
var state_16335__$1 = state_16335;
if(cljs.core.truth_(inst_16301)){
var statearr_16339_16372 = state_16335__$1;
(statearr_16339_16372[(1)] = (6));

} else {
var statearr_16340_16373 = state_16335__$1;
(statearr_16340_16373[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16336 === (15))){
var inst_16331 = (state_16335[(2)]);
var state_16335__$1 = state_16335;
var statearr_16341_16374 = state_16335__$1;
(statearr_16341_16374[(2)] = inst_16331);

(statearr_16341_16374[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16336 === (13))){
var inst_16324 = cljs.core.async.close_BANG_(out);
var state_16335__$1 = state_16335;
var statearr_16342_16375 = state_16335__$1;
(statearr_16342_16375[(2)] = inst_16324);

(statearr_16342_16375[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16336 === (6))){
var state_16335__$1 = state_16335;
var statearr_16343_16376 = state_16335__$1;
(statearr_16343_16376[(2)] = null);

(statearr_16343_16376[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16336 === (3))){
var inst_16333 = (state_16335[(2)]);
var state_16335__$1 = state_16335;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16335__$1,inst_16333);
} else {
if((state_val_16336 === (12))){
var inst_16321 = (state_16335[(8)]);
var inst_16321__$1 = (state_16335[(2)]);
var inst_16322 = cljs.core.some(cljs.core.nil_QMARK_,inst_16321__$1);
var state_16335__$1 = (function (){var statearr_16344 = state_16335;
(statearr_16344[(8)] = inst_16321__$1);

return statearr_16344;
})();
if(cljs.core.truth_(inst_16322)){
var statearr_16345_16377 = state_16335__$1;
(statearr_16345_16377[(1)] = (13));

} else {
var statearr_16346_16378 = state_16335__$1;
(statearr_16346_16378[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16336 === (2))){
var inst_16298 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_16299 = (0);
var state_16335__$1 = (function (){var statearr_16347 = state_16335;
(statearr_16347[(9)] = inst_16298);

(statearr_16347[(7)] = inst_16299);

return statearr_16347;
})();
var statearr_16348_16379 = state_16335__$1;
(statearr_16348_16379[(2)] = null);

(statearr_16348_16379[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16336 === (11))){
var inst_16299 = (state_16335[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_16335,(10),Object,null,(9));
var inst_16308 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_16299) : chs__$1.call(null,inst_16299));
var inst_16309 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_16299) : done.call(null,inst_16299));
var inst_16310 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_16308,inst_16309);
var state_16335__$1 = state_16335;
var statearr_16349_16380 = state_16335__$1;
(statearr_16349_16380[(2)] = inst_16310);


cljs.core.async.impl.ioc_helpers.process_exception(state_16335__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_16336 === (9))){
var inst_16299 = (state_16335[(7)]);
var inst_16312 = (state_16335[(2)]);
var inst_16313 = (inst_16299 + (1));
var inst_16299__$1 = inst_16313;
var state_16335__$1 = (function (){var statearr_16350 = state_16335;
(statearr_16350[(10)] = inst_16312);

(statearr_16350[(7)] = inst_16299__$1);

return statearr_16350;
})();
var statearr_16351_16381 = state_16335__$1;
(statearr_16351_16381[(2)] = null);

(statearr_16351_16381[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16336 === (5))){
var inst_16319 = (state_16335[(2)]);
var state_16335__$1 = (function (){var statearr_16352 = state_16335;
(statearr_16352[(11)] = inst_16319);

return statearr_16352;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16335__$1,(12),dchan);
} else {
if((state_val_16336 === (14))){
var inst_16321 = (state_16335[(8)]);
var inst_16326 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_16321);
var state_16335__$1 = state_16335;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16335__$1,(16),out,inst_16326);
} else {
if((state_val_16336 === (16))){
var inst_16328 = (state_16335[(2)]);
var state_16335__$1 = (function (){var statearr_16353 = state_16335;
(statearr_16353[(12)] = inst_16328);

return statearr_16353;
})();
var statearr_16354_16382 = state_16335__$1;
(statearr_16354_16382[(2)] = null);

(statearr_16354_16382[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16336 === (10))){
var inst_16303 = (state_16335[(2)]);
var inst_16304 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_16335__$1 = (function (){var statearr_16355 = state_16335;
(statearr_16355[(13)] = inst_16303);

return statearr_16355;
})();
var statearr_16356_16383 = state_16335__$1;
(statearr_16356_16383[(2)] = inst_16304);


cljs.core.async.impl.ioc_helpers.process_exception(state_16335__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_16336 === (8))){
var inst_16317 = (state_16335[(2)]);
var state_16335__$1 = state_16335;
var statearr_16357_16384 = state_16335__$1;
(statearr_16357_16384[(2)] = inst_16317);

(statearr_16357_16384[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto___16369,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__14250__auto__,c__14364__auto___16369,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__14251__auto__ = null;
var cljs$core$async$state_machine__14251__auto____0 = (function (){
var statearr_16361 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16361[(0)] = cljs$core$async$state_machine__14251__auto__);

(statearr_16361[(1)] = (1));

return statearr_16361;
});
var cljs$core$async$state_machine__14251__auto____1 = (function (state_16335){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_16335);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e16362){if((e16362 instanceof Object)){
var ex__14254__auto__ = e16362;
var statearr_16363_16385 = state_16335;
(statearr_16363_16385[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16335);

return cljs.core.cst$kw$recur;
} else {
throw e16362;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__16386 = state_16335;
state_16335 = G__16386;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$state_machine__14251__auto__ = function(state_16335){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14251__auto____1.call(this,state_16335);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14251__auto____0;
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14251__auto____1;
return cljs$core$async$state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto___16369,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__14366__auto__ = (function (){var statearr_16364 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_16364[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___16369);

return statearr_16364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto___16369,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args16388 = [];
var len__7094__auto___16444 = arguments.length;
var i__7095__auto___16445 = (0);
while(true){
if((i__7095__auto___16445 < len__7094__auto___16444)){
args16388.push((arguments[i__7095__auto___16445]));

var G__16446 = (i__7095__auto___16445 + (1));
i__7095__auto___16445 = G__16446;
continue;
} else {
}
break;
}

var G__16390 = args16388.length;
switch (G__16390) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16388.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14364__auto___16448 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto___16448,out){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto___16448,out){
return (function (state_16420){
var state_val_16421 = (state_16420[(1)]);
if((state_val_16421 === (7))){
var inst_16399 = (state_16420[(7)]);
var inst_16400 = (state_16420[(8)]);
var inst_16399__$1 = (state_16420[(2)]);
var inst_16400__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16399__$1,(0),null);
var inst_16401 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16399__$1,(1),null);
var inst_16402 = (inst_16400__$1 == null);
var state_16420__$1 = (function (){var statearr_16422 = state_16420;
(statearr_16422[(7)] = inst_16399__$1);

(statearr_16422[(9)] = inst_16401);

(statearr_16422[(8)] = inst_16400__$1);

return statearr_16422;
})();
if(cljs.core.truth_(inst_16402)){
var statearr_16423_16449 = state_16420__$1;
(statearr_16423_16449[(1)] = (8));

} else {
var statearr_16424_16450 = state_16420__$1;
(statearr_16424_16450[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16421 === (1))){
var inst_16391 = cljs.core.vec(chs);
var inst_16392 = inst_16391;
var state_16420__$1 = (function (){var statearr_16425 = state_16420;
(statearr_16425[(10)] = inst_16392);

return statearr_16425;
})();
var statearr_16426_16451 = state_16420__$1;
(statearr_16426_16451[(2)] = null);

(statearr_16426_16451[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16421 === (4))){
var inst_16392 = (state_16420[(10)]);
var state_16420__$1 = state_16420;
return cljs.core.async.ioc_alts_BANG_(state_16420__$1,(7),inst_16392);
} else {
if((state_val_16421 === (6))){
var inst_16416 = (state_16420[(2)]);
var state_16420__$1 = state_16420;
var statearr_16427_16452 = state_16420__$1;
(statearr_16427_16452[(2)] = inst_16416);

(statearr_16427_16452[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16421 === (3))){
var inst_16418 = (state_16420[(2)]);
var state_16420__$1 = state_16420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16420__$1,inst_16418);
} else {
if((state_val_16421 === (2))){
var inst_16392 = (state_16420[(10)]);
var inst_16394 = cljs.core.count(inst_16392);
var inst_16395 = (inst_16394 > (0));
var state_16420__$1 = state_16420;
if(cljs.core.truth_(inst_16395)){
var statearr_16429_16453 = state_16420__$1;
(statearr_16429_16453[(1)] = (4));

} else {
var statearr_16430_16454 = state_16420__$1;
(statearr_16430_16454[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16421 === (11))){
var inst_16392 = (state_16420[(10)]);
var inst_16409 = (state_16420[(2)]);
var tmp16428 = inst_16392;
var inst_16392__$1 = tmp16428;
var state_16420__$1 = (function (){var statearr_16431 = state_16420;
(statearr_16431[(11)] = inst_16409);

(statearr_16431[(10)] = inst_16392__$1);

return statearr_16431;
})();
var statearr_16432_16455 = state_16420__$1;
(statearr_16432_16455[(2)] = null);

(statearr_16432_16455[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16421 === (9))){
var inst_16400 = (state_16420[(8)]);
var state_16420__$1 = state_16420;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16420__$1,(11),out,inst_16400);
} else {
if((state_val_16421 === (5))){
var inst_16414 = cljs.core.async.close_BANG_(out);
var state_16420__$1 = state_16420;
var statearr_16433_16456 = state_16420__$1;
(statearr_16433_16456[(2)] = inst_16414);

(statearr_16433_16456[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16421 === (10))){
var inst_16412 = (state_16420[(2)]);
var state_16420__$1 = state_16420;
var statearr_16434_16457 = state_16420__$1;
(statearr_16434_16457[(2)] = inst_16412);

(statearr_16434_16457[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16421 === (8))){
var inst_16399 = (state_16420[(7)]);
var inst_16392 = (state_16420[(10)]);
var inst_16401 = (state_16420[(9)]);
var inst_16400 = (state_16420[(8)]);
var inst_16404 = (function (){var cs = inst_16392;
var vec__16397 = inst_16399;
var v = inst_16400;
var c = inst_16401;
return ((function (cs,vec__16397,v,c,inst_16399,inst_16392,inst_16401,inst_16400,state_val_16421,c__14364__auto___16448,out){
return (function (p1__16387_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__16387_SHARP_);
});
;})(cs,vec__16397,v,c,inst_16399,inst_16392,inst_16401,inst_16400,state_val_16421,c__14364__auto___16448,out))
})();
var inst_16405 = cljs.core.filterv(inst_16404,inst_16392);
var inst_16392__$1 = inst_16405;
var state_16420__$1 = (function (){var statearr_16435 = state_16420;
(statearr_16435[(10)] = inst_16392__$1);

return statearr_16435;
})();
var statearr_16436_16458 = state_16420__$1;
(statearr_16436_16458[(2)] = null);

(statearr_16436_16458[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto___16448,out))
;
return ((function (switch__14250__auto__,c__14364__auto___16448,out){
return (function() {
var cljs$core$async$state_machine__14251__auto__ = null;
var cljs$core$async$state_machine__14251__auto____0 = (function (){
var statearr_16440 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16440[(0)] = cljs$core$async$state_machine__14251__auto__);

(statearr_16440[(1)] = (1));

return statearr_16440;
});
var cljs$core$async$state_machine__14251__auto____1 = (function (state_16420){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_16420);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e16441){if((e16441 instanceof Object)){
var ex__14254__auto__ = e16441;
var statearr_16442_16459 = state_16420;
(statearr_16442_16459[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16420);

return cljs.core.cst$kw$recur;
} else {
throw e16441;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__16460 = state_16420;
state_16420 = G__16460;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$state_machine__14251__auto__ = function(state_16420){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14251__auto____1.call(this,state_16420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14251__auto____0;
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14251__auto____1;
return cljs$core$async$state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto___16448,out))
})();
var state__14366__auto__ = (function (){var statearr_16443 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_16443[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___16448);

return statearr_16443;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto___16448,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args16461 = [];
var len__7094__auto___16510 = arguments.length;
var i__7095__auto___16511 = (0);
while(true){
if((i__7095__auto___16511 < len__7094__auto___16510)){
args16461.push((arguments[i__7095__auto___16511]));

var G__16512 = (i__7095__auto___16511 + (1));
i__7095__auto___16511 = G__16512;
continue;
} else {
}
break;
}

var G__16463 = args16461.length;
switch (G__16463) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16461.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14364__auto___16514 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto___16514,out){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto___16514,out){
return (function (state_16487){
var state_val_16488 = (state_16487[(1)]);
if((state_val_16488 === (7))){
var inst_16469 = (state_16487[(7)]);
var inst_16469__$1 = (state_16487[(2)]);
var inst_16470 = (inst_16469__$1 == null);
var inst_16471 = cljs.core.not(inst_16470);
var state_16487__$1 = (function (){var statearr_16489 = state_16487;
(statearr_16489[(7)] = inst_16469__$1);

return statearr_16489;
})();
if(inst_16471){
var statearr_16490_16515 = state_16487__$1;
(statearr_16490_16515[(1)] = (8));

} else {
var statearr_16491_16516 = state_16487__$1;
(statearr_16491_16516[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16488 === (1))){
var inst_16464 = (0);
var state_16487__$1 = (function (){var statearr_16492 = state_16487;
(statearr_16492[(8)] = inst_16464);

return statearr_16492;
})();
var statearr_16493_16517 = state_16487__$1;
(statearr_16493_16517[(2)] = null);

(statearr_16493_16517[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16488 === (4))){
var state_16487__$1 = state_16487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16487__$1,(7),ch);
} else {
if((state_val_16488 === (6))){
var inst_16482 = (state_16487[(2)]);
var state_16487__$1 = state_16487;
var statearr_16494_16518 = state_16487__$1;
(statearr_16494_16518[(2)] = inst_16482);

(statearr_16494_16518[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16488 === (3))){
var inst_16484 = (state_16487[(2)]);
var inst_16485 = cljs.core.async.close_BANG_(out);
var state_16487__$1 = (function (){var statearr_16495 = state_16487;
(statearr_16495[(9)] = inst_16484);

return statearr_16495;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16487__$1,inst_16485);
} else {
if((state_val_16488 === (2))){
var inst_16464 = (state_16487[(8)]);
var inst_16466 = (inst_16464 < n);
var state_16487__$1 = state_16487;
if(cljs.core.truth_(inst_16466)){
var statearr_16496_16519 = state_16487__$1;
(statearr_16496_16519[(1)] = (4));

} else {
var statearr_16497_16520 = state_16487__$1;
(statearr_16497_16520[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16488 === (11))){
var inst_16464 = (state_16487[(8)]);
var inst_16474 = (state_16487[(2)]);
var inst_16475 = (inst_16464 + (1));
var inst_16464__$1 = inst_16475;
var state_16487__$1 = (function (){var statearr_16498 = state_16487;
(statearr_16498[(10)] = inst_16474);

(statearr_16498[(8)] = inst_16464__$1);

return statearr_16498;
})();
var statearr_16499_16521 = state_16487__$1;
(statearr_16499_16521[(2)] = null);

(statearr_16499_16521[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16488 === (9))){
var state_16487__$1 = state_16487;
var statearr_16500_16522 = state_16487__$1;
(statearr_16500_16522[(2)] = null);

(statearr_16500_16522[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16488 === (5))){
var state_16487__$1 = state_16487;
var statearr_16501_16523 = state_16487__$1;
(statearr_16501_16523[(2)] = null);

(statearr_16501_16523[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16488 === (10))){
var inst_16479 = (state_16487[(2)]);
var state_16487__$1 = state_16487;
var statearr_16502_16524 = state_16487__$1;
(statearr_16502_16524[(2)] = inst_16479);

(statearr_16502_16524[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16488 === (8))){
var inst_16469 = (state_16487[(7)]);
var state_16487__$1 = state_16487;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16487__$1,(11),out,inst_16469);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto___16514,out))
;
return ((function (switch__14250__auto__,c__14364__auto___16514,out){
return (function() {
var cljs$core$async$state_machine__14251__auto__ = null;
var cljs$core$async$state_machine__14251__auto____0 = (function (){
var statearr_16506 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16506[(0)] = cljs$core$async$state_machine__14251__auto__);

(statearr_16506[(1)] = (1));

return statearr_16506;
});
var cljs$core$async$state_machine__14251__auto____1 = (function (state_16487){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_16487);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e16507){if((e16507 instanceof Object)){
var ex__14254__auto__ = e16507;
var statearr_16508_16525 = state_16487;
(statearr_16508_16525[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16487);

return cljs.core.cst$kw$recur;
} else {
throw e16507;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__16526 = state_16487;
state_16487 = G__16526;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$state_machine__14251__auto__ = function(state_16487){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14251__auto____1.call(this,state_16487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14251__auto____0;
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14251__auto____1;
return cljs$core$async$state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto___16514,out))
})();
var state__14366__auto__ = (function (){var statearr_16509 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_16509[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___16514);

return statearr_16509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto___16514,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16536 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16536 = (function (map_LT_,f,ch,meta16537){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16537 = meta16537;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16536.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16538,meta16537__$1){
var self__ = this;
var _16538__$1 = this;
return (new cljs.core.async.t_cljs$core$async16536(self__.map_LT_,self__.f,self__.ch,meta16537__$1));
});

cljs.core.async.t_cljs$core$async16536.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16538){
var self__ = this;
var _16538__$1 = this;
return self__.meta16537;
});

cljs.core.async.t_cljs$core$async16536.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16536.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async16536.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async16536.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16536.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async16539 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16539 = (function (map_LT_,f,ch,meta16537,_,fn1,meta16540){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16537 = meta16537;
this._ = _;
this.fn1 = fn1;
this.meta16540 = meta16540;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16539.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16541,meta16540__$1){
var self__ = this;
var _16541__$1 = this;
return (new cljs.core.async.t_cljs$core$async16539(self__.map_LT_,self__.f,self__.ch,self__.meta16537,self__._,self__.fn1,meta16540__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async16539.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16541){
var self__ = this;
var _16541__$1 = this;
return self__.meta16540;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16539.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16539.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16539.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__16527_SHARP_){
var G__16542 = (((p1__16527_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__16527_SHARP_) : self__.f.call(null,p1__16527_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__16542) : f1.call(null,G__16542));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async16539.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16537,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async16536], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta16540], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16539.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16539.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16539";

cljs.core.async.t_cljs$core$async16539.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6634__auto__,writer__6635__auto__,opt__6636__auto__){
return cljs.core._write(writer__6635__auto__,"cljs.core.async/t_cljs$core$async16539");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async16539 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16539(map_LT___$1,f__$1,ch__$1,meta16537__$1,___$2,fn1__$1,meta16540){
return (new cljs.core.async.t_cljs$core$async16539(map_LT___$1,f__$1,ch__$1,meta16537__$1,___$2,fn1__$1,meta16540));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async16539(self__.map_LT_,self__.f,self__.ch,self__.meta16537,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6024__auto__ = ret;
if(cljs.core.truth_(and__6024__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6024__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__16543 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__16543) : self__.f.call(null,G__16543));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async16536.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16536.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async16536.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16537], null);
});

cljs.core.async.t_cljs$core$async16536.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16536.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16536";

cljs.core.async.t_cljs$core$async16536.cljs$lang$ctorPrWriter = (function (this__6634__auto__,writer__6635__auto__,opt__6636__auto__){
return cljs.core._write(writer__6635__auto__,"cljs.core.async/t_cljs$core$async16536");
});

cljs.core.async.__GT_t_cljs$core$async16536 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16536(map_LT___$1,f__$1,ch__$1,meta16537){
return (new cljs.core.async.t_cljs$core$async16536(map_LT___$1,f__$1,ch__$1,meta16537));
});

}

return (new cljs.core.async.t_cljs$core$async16536(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16547 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16547 = (function (map_GT_,f,ch,meta16548){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta16548 = meta16548;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16547.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16549,meta16548__$1){
var self__ = this;
var _16549__$1 = this;
return (new cljs.core.async.t_cljs$core$async16547(self__.map_GT_,self__.f,self__.ch,meta16548__$1));
});

cljs.core.async.t_cljs$core$async16547.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16549){
var self__ = this;
var _16549__$1 = this;
return self__.meta16548;
});

cljs.core.async.t_cljs$core$async16547.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16547.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async16547.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16547.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16547.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16547.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async16547.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16548], null);
});

cljs.core.async.t_cljs$core$async16547.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16547.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16547";

cljs.core.async.t_cljs$core$async16547.cljs$lang$ctorPrWriter = (function (this__6634__auto__,writer__6635__auto__,opt__6636__auto__){
return cljs.core._write(writer__6635__auto__,"cljs.core.async/t_cljs$core$async16547");
});

cljs.core.async.__GT_t_cljs$core$async16547 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16547(map_GT___$1,f__$1,ch__$1,meta16548){
return (new cljs.core.async.t_cljs$core$async16547(map_GT___$1,f__$1,ch__$1,meta16548));
});

}

return (new cljs.core.async.t_cljs$core$async16547(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async16553 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16553 = (function (filter_GT_,p,ch,meta16554){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta16554 = meta16554;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16553.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16555,meta16554__$1){
var self__ = this;
var _16555__$1 = this;
return (new cljs.core.async.t_cljs$core$async16553(self__.filter_GT_,self__.p,self__.ch,meta16554__$1));
});

cljs.core.async.t_cljs$core$async16553.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16555){
var self__ = this;
var _16555__$1 = this;
return self__.meta16554;
});

cljs.core.async.t_cljs$core$async16553.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16553.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async16553.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async16553.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16553.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16553.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16553.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async16553.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16554], null);
});

cljs.core.async.t_cljs$core$async16553.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16553.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16553";

cljs.core.async.t_cljs$core$async16553.cljs$lang$ctorPrWriter = (function (this__6634__auto__,writer__6635__auto__,opt__6636__auto__){
return cljs.core._write(writer__6635__auto__,"cljs.core.async/t_cljs$core$async16553");
});

cljs.core.async.__GT_t_cljs$core$async16553 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async16553(filter_GT___$1,p__$1,ch__$1,meta16554){
return (new cljs.core.async.t_cljs$core$async16553(filter_GT___$1,p__$1,ch__$1,meta16554));
});

}

return (new cljs.core.async.t_cljs$core$async16553(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args16556 = [];
var len__7094__auto___16600 = arguments.length;
var i__7095__auto___16601 = (0);
while(true){
if((i__7095__auto___16601 < len__7094__auto___16600)){
args16556.push((arguments[i__7095__auto___16601]));

var G__16602 = (i__7095__auto___16601 + (1));
i__7095__auto___16601 = G__16602;
continue;
} else {
}
break;
}

var G__16558 = args16556.length;
switch (G__16558) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16556.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14364__auto___16604 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto___16604,out){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto___16604,out){
return (function (state_16579){
var state_val_16580 = (state_16579[(1)]);
if((state_val_16580 === (7))){
var inst_16575 = (state_16579[(2)]);
var state_16579__$1 = state_16579;
var statearr_16581_16605 = state_16579__$1;
(statearr_16581_16605[(2)] = inst_16575);

(statearr_16581_16605[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16580 === (1))){
var state_16579__$1 = state_16579;
var statearr_16582_16606 = state_16579__$1;
(statearr_16582_16606[(2)] = null);

(statearr_16582_16606[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16580 === (4))){
var inst_16561 = (state_16579[(7)]);
var inst_16561__$1 = (state_16579[(2)]);
var inst_16562 = (inst_16561__$1 == null);
var state_16579__$1 = (function (){var statearr_16583 = state_16579;
(statearr_16583[(7)] = inst_16561__$1);

return statearr_16583;
})();
if(cljs.core.truth_(inst_16562)){
var statearr_16584_16607 = state_16579__$1;
(statearr_16584_16607[(1)] = (5));

} else {
var statearr_16585_16608 = state_16579__$1;
(statearr_16585_16608[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16580 === (6))){
var inst_16561 = (state_16579[(7)]);
var inst_16566 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_16561) : p.call(null,inst_16561));
var state_16579__$1 = state_16579;
if(cljs.core.truth_(inst_16566)){
var statearr_16586_16609 = state_16579__$1;
(statearr_16586_16609[(1)] = (8));

} else {
var statearr_16587_16610 = state_16579__$1;
(statearr_16587_16610[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16580 === (3))){
var inst_16577 = (state_16579[(2)]);
var state_16579__$1 = state_16579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16579__$1,inst_16577);
} else {
if((state_val_16580 === (2))){
var state_16579__$1 = state_16579;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16579__$1,(4),ch);
} else {
if((state_val_16580 === (11))){
var inst_16569 = (state_16579[(2)]);
var state_16579__$1 = state_16579;
var statearr_16588_16611 = state_16579__$1;
(statearr_16588_16611[(2)] = inst_16569);

(statearr_16588_16611[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16580 === (9))){
var state_16579__$1 = state_16579;
var statearr_16589_16612 = state_16579__$1;
(statearr_16589_16612[(2)] = null);

(statearr_16589_16612[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16580 === (5))){
var inst_16564 = cljs.core.async.close_BANG_(out);
var state_16579__$1 = state_16579;
var statearr_16590_16613 = state_16579__$1;
(statearr_16590_16613[(2)] = inst_16564);

(statearr_16590_16613[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16580 === (10))){
var inst_16572 = (state_16579[(2)]);
var state_16579__$1 = (function (){var statearr_16591 = state_16579;
(statearr_16591[(8)] = inst_16572);

return statearr_16591;
})();
var statearr_16592_16614 = state_16579__$1;
(statearr_16592_16614[(2)] = null);

(statearr_16592_16614[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16580 === (8))){
var inst_16561 = (state_16579[(7)]);
var state_16579__$1 = state_16579;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16579__$1,(11),out,inst_16561);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto___16604,out))
;
return ((function (switch__14250__auto__,c__14364__auto___16604,out){
return (function() {
var cljs$core$async$state_machine__14251__auto__ = null;
var cljs$core$async$state_machine__14251__auto____0 = (function (){
var statearr_16596 = [null,null,null,null,null,null,null,null,null];
(statearr_16596[(0)] = cljs$core$async$state_machine__14251__auto__);

(statearr_16596[(1)] = (1));

return statearr_16596;
});
var cljs$core$async$state_machine__14251__auto____1 = (function (state_16579){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_16579);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e16597){if((e16597 instanceof Object)){
var ex__14254__auto__ = e16597;
var statearr_16598_16615 = state_16579;
(statearr_16598_16615[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16579);

return cljs.core.cst$kw$recur;
} else {
throw e16597;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__16616 = state_16579;
state_16579 = G__16616;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$state_machine__14251__auto__ = function(state_16579){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14251__auto____1.call(this,state_16579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14251__auto____0;
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14251__auto____1;
return cljs$core$async$state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto___16604,out))
})();
var state__14366__auto__ = (function (){var statearr_16599 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_16599[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___16604);

return statearr_16599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto___16604,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args16617 = [];
var len__7094__auto___16620 = arguments.length;
var i__7095__auto___16621 = (0);
while(true){
if((i__7095__auto___16621 < len__7094__auto___16620)){
args16617.push((arguments[i__7095__auto___16621]));

var G__16622 = (i__7095__auto___16621 + (1));
i__7095__auto___16621 = G__16622;
continue;
} else {
}
break;
}

var G__16619 = args16617.length;
switch (G__16619) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16617.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14364__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto__){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto__){
return (function (state_16789){
var state_val_16790 = (state_16789[(1)]);
if((state_val_16790 === (7))){
var inst_16785 = (state_16789[(2)]);
var state_16789__$1 = state_16789;
var statearr_16791_16832 = state_16789__$1;
(statearr_16791_16832[(2)] = inst_16785);

(statearr_16791_16832[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (20))){
var inst_16755 = (state_16789[(7)]);
var inst_16766 = (state_16789[(2)]);
var inst_16767 = cljs.core.next(inst_16755);
var inst_16741 = inst_16767;
var inst_16742 = null;
var inst_16743 = (0);
var inst_16744 = (0);
var state_16789__$1 = (function (){var statearr_16792 = state_16789;
(statearr_16792[(8)] = inst_16741);

(statearr_16792[(9)] = inst_16744);

(statearr_16792[(10)] = inst_16766);

(statearr_16792[(11)] = inst_16743);

(statearr_16792[(12)] = inst_16742);

return statearr_16792;
})();
var statearr_16793_16833 = state_16789__$1;
(statearr_16793_16833[(2)] = null);

(statearr_16793_16833[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (1))){
var state_16789__$1 = state_16789;
var statearr_16794_16834 = state_16789__$1;
(statearr_16794_16834[(2)] = null);

(statearr_16794_16834[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (4))){
var inst_16730 = (state_16789[(13)]);
var inst_16730__$1 = (state_16789[(2)]);
var inst_16731 = (inst_16730__$1 == null);
var state_16789__$1 = (function (){var statearr_16795 = state_16789;
(statearr_16795[(13)] = inst_16730__$1);

return statearr_16795;
})();
if(cljs.core.truth_(inst_16731)){
var statearr_16796_16835 = state_16789__$1;
(statearr_16796_16835[(1)] = (5));

} else {
var statearr_16797_16836 = state_16789__$1;
(statearr_16797_16836[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (15))){
var state_16789__$1 = state_16789;
var statearr_16801_16837 = state_16789__$1;
(statearr_16801_16837[(2)] = null);

(statearr_16801_16837[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (21))){
var state_16789__$1 = state_16789;
var statearr_16802_16838 = state_16789__$1;
(statearr_16802_16838[(2)] = null);

(statearr_16802_16838[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (13))){
var inst_16741 = (state_16789[(8)]);
var inst_16744 = (state_16789[(9)]);
var inst_16743 = (state_16789[(11)]);
var inst_16742 = (state_16789[(12)]);
var inst_16751 = (state_16789[(2)]);
var inst_16752 = (inst_16744 + (1));
var tmp16798 = inst_16741;
var tmp16799 = inst_16743;
var tmp16800 = inst_16742;
var inst_16741__$1 = tmp16798;
var inst_16742__$1 = tmp16800;
var inst_16743__$1 = tmp16799;
var inst_16744__$1 = inst_16752;
var state_16789__$1 = (function (){var statearr_16803 = state_16789;
(statearr_16803[(8)] = inst_16741__$1);

(statearr_16803[(9)] = inst_16744__$1);

(statearr_16803[(11)] = inst_16743__$1);

(statearr_16803[(14)] = inst_16751);

(statearr_16803[(12)] = inst_16742__$1);

return statearr_16803;
})();
var statearr_16804_16839 = state_16789__$1;
(statearr_16804_16839[(2)] = null);

(statearr_16804_16839[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (22))){
var state_16789__$1 = state_16789;
var statearr_16805_16840 = state_16789__$1;
(statearr_16805_16840[(2)] = null);

(statearr_16805_16840[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (6))){
var inst_16730 = (state_16789[(13)]);
var inst_16739 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_16730) : f.call(null,inst_16730));
var inst_16740 = cljs.core.seq(inst_16739);
var inst_16741 = inst_16740;
var inst_16742 = null;
var inst_16743 = (0);
var inst_16744 = (0);
var state_16789__$1 = (function (){var statearr_16806 = state_16789;
(statearr_16806[(8)] = inst_16741);

(statearr_16806[(9)] = inst_16744);

(statearr_16806[(11)] = inst_16743);

(statearr_16806[(12)] = inst_16742);

return statearr_16806;
})();
var statearr_16807_16841 = state_16789__$1;
(statearr_16807_16841[(2)] = null);

(statearr_16807_16841[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (17))){
var inst_16755 = (state_16789[(7)]);
var inst_16759 = cljs.core.chunk_first(inst_16755);
var inst_16760 = cljs.core.chunk_rest(inst_16755);
var inst_16761 = cljs.core.count(inst_16759);
var inst_16741 = inst_16760;
var inst_16742 = inst_16759;
var inst_16743 = inst_16761;
var inst_16744 = (0);
var state_16789__$1 = (function (){var statearr_16808 = state_16789;
(statearr_16808[(8)] = inst_16741);

(statearr_16808[(9)] = inst_16744);

(statearr_16808[(11)] = inst_16743);

(statearr_16808[(12)] = inst_16742);

return statearr_16808;
})();
var statearr_16809_16842 = state_16789__$1;
(statearr_16809_16842[(2)] = null);

(statearr_16809_16842[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (3))){
var inst_16787 = (state_16789[(2)]);
var state_16789__$1 = state_16789;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16789__$1,inst_16787);
} else {
if((state_val_16790 === (12))){
var inst_16775 = (state_16789[(2)]);
var state_16789__$1 = state_16789;
var statearr_16810_16843 = state_16789__$1;
(statearr_16810_16843[(2)] = inst_16775);

(statearr_16810_16843[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (2))){
var state_16789__$1 = state_16789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16789__$1,(4),in$);
} else {
if((state_val_16790 === (23))){
var inst_16783 = (state_16789[(2)]);
var state_16789__$1 = state_16789;
var statearr_16811_16844 = state_16789__$1;
(statearr_16811_16844[(2)] = inst_16783);

(statearr_16811_16844[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (19))){
var inst_16770 = (state_16789[(2)]);
var state_16789__$1 = state_16789;
var statearr_16812_16845 = state_16789__$1;
(statearr_16812_16845[(2)] = inst_16770);

(statearr_16812_16845[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (11))){
var inst_16741 = (state_16789[(8)]);
var inst_16755 = (state_16789[(7)]);
var inst_16755__$1 = cljs.core.seq(inst_16741);
var state_16789__$1 = (function (){var statearr_16813 = state_16789;
(statearr_16813[(7)] = inst_16755__$1);

return statearr_16813;
})();
if(inst_16755__$1){
var statearr_16814_16846 = state_16789__$1;
(statearr_16814_16846[(1)] = (14));

} else {
var statearr_16815_16847 = state_16789__$1;
(statearr_16815_16847[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (9))){
var inst_16777 = (state_16789[(2)]);
var inst_16778 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_16789__$1 = (function (){var statearr_16816 = state_16789;
(statearr_16816[(15)] = inst_16777);

return statearr_16816;
})();
if(cljs.core.truth_(inst_16778)){
var statearr_16817_16848 = state_16789__$1;
(statearr_16817_16848[(1)] = (21));

} else {
var statearr_16818_16849 = state_16789__$1;
(statearr_16818_16849[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (5))){
var inst_16733 = cljs.core.async.close_BANG_(out);
var state_16789__$1 = state_16789;
var statearr_16819_16850 = state_16789__$1;
(statearr_16819_16850[(2)] = inst_16733);

(statearr_16819_16850[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (14))){
var inst_16755 = (state_16789[(7)]);
var inst_16757 = cljs.core.chunked_seq_QMARK_(inst_16755);
var state_16789__$1 = state_16789;
if(inst_16757){
var statearr_16820_16851 = state_16789__$1;
(statearr_16820_16851[(1)] = (17));

} else {
var statearr_16821_16852 = state_16789__$1;
(statearr_16821_16852[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (16))){
var inst_16773 = (state_16789[(2)]);
var state_16789__$1 = state_16789;
var statearr_16822_16853 = state_16789__$1;
(statearr_16822_16853[(2)] = inst_16773);

(statearr_16822_16853[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16790 === (10))){
var inst_16744 = (state_16789[(9)]);
var inst_16742 = (state_16789[(12)]);
var inst_16749 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16742,inst_16744);
var state_16789__$1 = state_16789;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16789__$1,(13),out,inst_16749);
} else {
if((state_val_16790 === (18))){
var inst_16755 = (state_16789[(7)]);
var inst_16764 = cljs.core.first(inst_16755);
var state_16789__$1 = state_16789;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16789__$1,(20),out,inst_16764);
} else {
if((state_val_16790 === (8))){
var inst_16744 = (state_16789[(9)]);
var inst_16743 = (state_16789[(11)]);
var inst_16746 = (inst_16744 < inst_16743);
var inst_16747 = inst_16746;
var state_16789__$1 = state_16789;
if(cljs.core.truth_(inst_16747)){
var statearr_16823_16854 = state_16789__$1;
(statearr_16823_16854[(1)] = (10));

} else {
var statearr_16824_16855 = state_16789__$1;
(statearr_16824_16855[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto__))
;
return ((function (switch__14250__auto__,c__14364__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14251__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14251__auto____0 = (function (){
var statearr_16828 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16828[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14251__auto__);

(statearr_16828[(1)] = (1));

return statearr_16828;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14251__auto____1 = (function (state_16789){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_16789);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e16829){if((e16829 instanceof Object)){
var ex__14254__auto__ = e16829;
var statearr_16830_16856 = state_16789;
(statearr_16830_16856[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16789);

return cljs.core.cst$kw$recur;
} else {
throw e16829;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__16857 = state_16789;
state_16789 = G__16857;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14251__auto__ = function(state_16789){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14251__auto____1.call(this,state_16789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14251__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14251__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto__))
})();
var state__14366__auto__ = (function (){var statearr_16831 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_16831[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto__);

return statearr_16831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto__))
);

return c__14364__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args16858 = [];
var len__7094__auto___16861 = arguments.length;
var i__7095__auto___16862 = (0);
while(true){
if((i__7095__auto___16862 < len__7094__auto___16861)){
args16858.push((arguments[i__7095__auto___16862]));

var G__16863 = (i__7095__auto___16862 + (1));
i__7095__auto___16862 = G__16863;
continue;
} else {
}
break;
}

var G__16860 = args16858.length;
switch (G__16860) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16858.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args16865 = [];
var len__7094__auto___16868 = arguments.length;
var i__7095__auto___16869 = (0);
while(true){
if((i__7095__auto___16869 < len__7094__auto___16868)){
args16865.push((arguments[i__7095__auto___16869]));

var G__16870 = (i__7095__auto___16869 + (1));
i__7095__auto___16869 = G__16870;
continue;
} else {
}
break;
}

var G__16867 = args16865.length;
switch (G__16867) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16865.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args16872 = [];
var len__7094__auto___16923 = arguments.length;
var i__7095__auto___16924 = (0);
while(true){
if((i__7095__auto___16924 < len__7094__auto___16923)){
args16872.push((arguments[i__7095__auto___16924]));

var G__16925 = (i__7095__auto___16924 + (1));
i__7095__auto___16924 = G__16925;
continue;
} else {
}
break;
}

var G__16874 = args16872.length;
switch (G__16874) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16872.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14364__auto___16927 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto___16927,out){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto___16927,out){
return (function (state_16898){
var state_val_16899 = (state_16898[(1)]);
if((state_val_16899 === (7))){
var inst_16893 = (state_16898[(2)]);
var state_16898__$1 = state_16898;
var statearr_16900_16928 = state_16898__$1;
(statearr_16900_16928[(2)] = inst_16893);

(statearr_16900_16928[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16899 === (1))){
var inst_16875 = null;
var state_16898__$1 = (function (){var statearr_16901 = state_16898;
(statearr_16901[(7)] = inst_16875);

return statearr_16901;
})();
var statearr_16902_16929 = state_16898__$1;
(statearr_16902_16929[(2)] = null);

(statearr_16902_16929[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16899 === (4))){
var inst_16878 = (state_16898[(8)]);
var inst_16878__$1 = (state_16898[(2)]);
var inst_16879 = (inst_16878__$1 == null);
var inst_16880 = cljs.core.not(inst_16879);
var state_16898__$1 = (function (){var statearr_16903 = state_16898;
(statearr_16903[(8)] = inst_16878__$1);

return statearr_16903;
})();
if(inst_16880){
var statearr_16904_16930 = state_16898__$1;
(statearr_16904_16930[(1)] = (5));

} else {
var statearr_16905_16931 = state_16898__$1;
(statearr_16905_16931[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16899 === (6))){
var state_16898__$1 = state_16898;
var statearr_16906_16932 = state_16898__$1;
(statearr_16906_16932[(2)] = null);

(statearr_16906_16932[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16899 === (3))){
var inst_16895 = (state_16898[(2)]);
var inst_16896 = cljs.core.async.close_BANG_(out);
var state_16898__$1 = (function (){var statearr_16907 = state_16898;
(statearr_16907[(9)] = inst_16895);

return statearr_16907;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16898__$1,inst_16896);
} else {
if((state_val_16899 === (2))){
var state_16898__$1 = state_16898;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16898__$1,(4),ch);
} else {
if((state_val_16899 === (11))){
var inst_16878 = (state_16898[(8)]);
var inst_16887 = (state_16898[(2)]);
var inst_16875 = inst_16878;
var state_16898__$1 = (function (){var statearr_16908 = state_16898;
(statearr_16908[(10)] = inst_16887);

(statearr_16908[(7)] = inst_16875);

return statearr_16908;
})();
var statearr_16909_16933 = state_16898__$1;
(statearr_16909_16933[(2)] = null);

(statearr_16909_16933[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16899 === (9))){
var inst_16878 = (state_16898[(8)]);
var state_16898__$1 = state_16898;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16898__$1,(11),out,inst_16878);
} else {
if((state_val_16899 === (5))){
var inst_16875 = (state_16898[(7)]);
var inst_16878 = (state_16898[(8)]);
var inst_16882 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16878,inst_16875);
var state_16898__$1 = state_16898;
if(inst_16882){
var statearr_16911_16934 = state_16898__$1;
(statearr_16911_16934[(1)] = (8));

} else {
var statearr_16912_16935 = state_16898__$1;
(statearr_16912_16935[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16899 === (10))){
var inst_16890 = (state_16898[(2)]);
var state_16898__$1 = state_16898;
var statearr_16913_16936 = state_16898__$1;
(statearr_16913_16936[(2)] = inst_16890);

(statearr_16913_16936[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16899 === (8))){
var inst_16875 = (state_16898[(7)]);
var tmp16910 = inst_16875;
var inst_16875__$1 = tmp16910;
var state_16898__$1 = (function (){var statearr_16914 = state_16898;
(statearr_16914[(7)] = inst_16875__$1);

return statearr_16914;
})();
var statearr_16915_16937 = state_16898__$1;
(statearr_16915_16937[(2)] = null);

(statearr_16915_16937[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto___16927,out))
;
return ((function (switch__14250__auto__,c__14364__auto___16927,out){
return (function() {
var cljs$core$async$state_machine__14251__auto__ = null;
var cljs$core$async$state_machine__14251__auto____0 = (function (){
var statearr_16919 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16919[(0)] = cljs$core$async$state_machine__14251__auto__);

(statearr_16919[(1)] = (1));

return statearr_16919;
});
var cljs$core$async$state_machine__14251__auto____1 = (function (state_16898){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_16898);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e16920){if((e16920 instanceof Object)){
var ex__14254__auto__ = e16920;
var statearr_16921_16938 = state_16898;
(statearr_16921_16938[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16898);

return cljs.core.cst$kw$recur;
} else {
throw e16920;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__16939 = state_16898;
state_16898 = G__16939;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$state_machine__14251__auto__ = function(state_16898){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14251__auto____1.call(this,state_16898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14251__auto____0;
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14251__auto____1;
return cljs$core$async$state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto___16927,out))
})();
var state__14366__auto__ = (function (){var statearr_16922 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_16922[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___16927);

return statearr_16922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto___16927,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args16940 = [];
var len__7094__auto___17010 = arguments.length;
var i__7095__auto___17011 = (0);
while(true){
if((i__7095__auto___17011 < len__7094__auto___17010)){
args16940.push((arguments[i__7095__auto___17011]));

var G__17012 = (i__7095__auto___17011 + (1));
i__7095__auto___17011 = G__17012;
continue;
} else {
}
break;
}

var G__16942 = args16940.length;
switch (G__16942) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16940.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14364__auto___17014 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto___17014,out){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto___17014,out){
return (function (state_16980){
var state_val_16981 = (state_16980[(1)]);
if((state_val_16981 === (7))){
var inst_16976 = (state_16980[(2)]);
var state_16980__$1 = state_16980;
var statearr_16982_17015 = state_16980__$1;
(statearr_16982_17015[(2)] = inst_16976);

(statearr_16982_17015[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16981 === (1))){
var inst_16943 = (new Array(n));
var inst_16944 = inst_16943;
var inst_16945 = (0);
var state_16980__$1 = (function (){var statearr_16983 = state_16980;
(statearr_16983[(7)] = inst_16944);

(statearr_16983[(8)] = inst_16945);

return statearr_16983;
})();
var statearr_16984_17016 = state_16980__$1;
(statearr_16984_17016[(2)] = null);

(statearr_16984_17016[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16981 === (4))){
var inst_16948 = (state_16980[(9)]);
var inst_16948__$1 = (state_16980[(2)]);
var inst_16949 = (inst_16948__$1 == null);
var inst_16950 = cljs.core.not(inst_16949);
var state_16980__$1 = (function (){var statearr_16985 = state_16980;
(statearr_16985[(9)] = inst_16948__$1);

return statearr_16985;
})();
if(inst_16950){
var statearr_16986_17017 = state_16980__$1;
(statearr_16986_17017[(1)] = (5));

} else {
var statearr_16987_17018 = state_16980__$1;
(statearr_16987_17018[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16981 === (15))){
var inst_16970 = (state_16980[(2)]);
var state_16980__$1 = state_16980;
var statearr_16988_17019 = state_16980__$1;
(statearr_16988_17019[(2)] = inst_16970);

(statearr_16988_17019[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16981 === (13))){
var state_16980__$1 = state_16980;
var statearr_16989_17020 = state_16980__$1;
(statearr_16989_17020[(2)] = null);

(statearr_16989_17020[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16981 === (6))){
var inst_16945 = (state_16980[(8)]);
var inst_16966 = (inst_16945 > (0));
var state_16980__$1 = state_16980;
if(cljs.core.truth_(inst_16966)){
var statearr_16990_17021 = state_16980__$1;
(statearr_16990_17021[(1)] = (12));

} else {
var statearr_16991_17022 = state_16980__$1;
(statearr_16991_17022[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16981 === (3))){
var inst_16978 = (state_16980[(2)]);
var state_16980__$1 = state_16980;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16980__$1,inst_16978);
} else {
if((state_val_16981 === (12))){
var inst_16944 = (state_16980[(7)]);
var inst_16968 = cljs.core.vec(inst_16944);
var state_16980__$1 = state_16980;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16980__$1,(15),out,inst_16968);
} else {
if((state_val_16981 === (2))){
var state_16980__$1 = state_16980;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16980__$1,(4),ch);
} else {
if((state_val_16981 === (11))){
var inst_16960 = (state_16980[(2)]);
var inst_16961 = (new Array(n));
var inst_16944 = inst_16961;
var inst_16945 = (0);
var state_16980__$1 = (function (){var statearr_16992 = state_16980;
(statearr_16992[(7)] = inst_16944);

(statearr_16992[(10)] = inst_16960);

(statearr_16992[(8)] = inst_16945);

return statearr_16992;
})();
var statearr_16993_17023 = state_16980__$1;
(statearr_16993_17023[(2)] = null);

(statearr_16993_17023[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16981 === (9))){
var inst_16944 = (state_16980[(7)]);
var inst_16958 = cljs.core.vec(inst_16944);
var state_16980__$1 = state_16980;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16980__$1,(11),out,inst_16958);
} else {
if((state_val_16981 === (5))){
var inst_16944 = (state_16980[(7)]);
var inst_16953 = (state_16980[(11)]);
var inst_16948 = (state_16980[(9)]);
var inst_16945 = (state_16980[(8)]);
var inst_16952 = (inst_16944[inst_16945] = inst_16948);
var inst_16953__$1 = (inst_16945 + (1));
var inst_16954 = (inst_16953__$1 < n);
var state_16980__$1 = (function (){var statearr_16994 = state_16980;
(statearr_16994[(11)] = inst_16953__$1);

(statearr_16994[(12)] = inst_16952);

return statearr_16994;
})();
if(cljs.core.truth_(inst_16954)){
var statearr_16995_17024 = state_16980__$1;
(statearr_16995_17024[(1)] = (8));

} else {
var statearr_16996_17025 = state_16980__$1;
(statearr_16996_17025[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16981 === (14))){
var inst_16973 = (state_16980[(2)]);
var inst_16974 = cljs.core.async.close_BANG_(out);
var state_16980__$1 = (function (){var statearr_16998 = state_16980;
(statearr_16998[(13)] = inst_16973);

return statearr_16998;
})();
var statearr_16999_17026 = state_16980__$1;
(statearr_16999_17026[(2)] = inst_16974);

(statearr_16999_17026[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16981 === (10))){
var inst_16964 = (state_16980[(2)]);
var state_16980__$1 = state_16980;
var statearr_17000_17027 = state_16980__$1;
(statearr_17000_17027[(2)] = inst_16964);

(statearr_17000_17027[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16981 === (8))){
var inst_16944 = (state_16980[(7)]);
var inst_16953 = (state_16980[(11)]);
var tmp16997 = inst_16944;
var inst_16944__$1 = tmp16997;
var inst_16945 = inst_16953;
var state_16980__$1 = (function (){var statearr_17001 = state_16980;
(statearr_17001[(7)] = inst_16944__$1);

(statearr_17001[(8)] = inst_16945);

return statearr_17001;
})();
var statearr_17002_17028 = state_16980__$1;
(statearr_17002_17028[(2)] = null);

(statearr_17002_17028[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto___17014,out))
;
return ((function (switch__14250__auto__,c__14364__auto___17014,out){
return (function() {
var cljs$core$async$state_machine__14251__auto__ = null;
var cljs$core$async$state_machine__14251__auto____0 = (function (){
var statearr_17006 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17006[(0)] = cljs$core$async$state_machine__14251__auto__);

(statearr_17006[(1)] = (1));

return statearr_17006;
});
var cljs$core$async$state_machine__14251__auto____1 = (function (state_16980){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_16980);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e17007){if((e17007 instanceof Object)){
var ex__14254__auto__ = e17007;
var statearr_17008_17029 = state_16980;
(statearr_17008_17029[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16980);

return cljs.core.cst$kw$recur;
} else {
throw e17007;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__17030 = state_16980;
state_16980 = G__17030;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$state_machine__14251__auto__ = function(state_16980){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14251__auto____1.call(this,state_16980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14251__auto____0;
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14251__auto____1;
return cljs$core$async$state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto___17014,out))
})();
var state__14366__auto__ = (function (){var statearr_17009 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_17009[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___17014);

return statearr_17009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto___17014,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args17031 = [];
var len__7094__auto___17105 = arguments.length;
var i__7095__auto___17106 = (0);
while(true){
if((i__7095__auto___17106 < len__7094__auto___17105)){
args17031.push((arguments[i__7095__auto___17106]));

var G__17107 = (i__7095__auto___17106 + (1));
i__7095__auto___17106 = G__17107;
continue;
} else {
}
break;
}

var G__17033 = args17031.length;
switch (G__17033) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17031.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14364__auto___17109 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14364__auto___17109,out){
return (function (){
var f__14365__auto__ = (function (){var switch__14250__auto__ = ((function (c__14364__auto___17109,out){
return (function (state_17075){
var state_val_17076 = (state_17075[(1)]);
if((state_val_17076 === (7))){
var inst_17071 = (state_17075[(2)]);
var state_17075__$1 = state_17075;
var statearr_17077_17110 = state_17075__$1;
(statearr_17077_17110[(2)] = inst_17071);

(statearr_17077_17110[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17076 === (1))){
var inst_17034 = [];
var inst_17035 = inst_17034;
var inst_17036 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_17075__$1 = (function (){var statearr_17078 = state_17075;
(statearr_17078[(7)] = inst_17036);

(statearr_17078[(8)] = inst_17035);

return statearr_17078;
})();
var statearr_17079_17111 = state_17075__$1;
(statearr_17079_17111[(2)] = null);

(statearr_17079_17111[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17076 === (4))){
var inst_17039 = (state_17075[(9)]);
var inst_17039__$1 = (state_17075[(2)]);
var inst_17040 = (inst_17039__$1 == null);
var inst_17041 = cljs.core.not(inst_17040);
var state_17075__$1 = (function (){var statearr_17080 = state_17075;
(statearr_17080[(9)] = inst_17039__$1);

return statearr_17080;
})();
if(inst_17041){
var statearr_17081_17112 = state_17075__$1;
(statearr_17081_17112[(1)] = (5));

} else {
var statearr_17082_17113 = state_17075__$1;
(statearr_17082_17113[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17076 === (15))){
var inst_17065 = (state_17075[(2)]);
var state_17075__$1 = state_17075;
var statearr_17083_17114 = state_17075__$1;
(statearr_17083_17114[(2)] = inst_17065);

(statearr_17083_17114[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17076 === (13))){
var state_17075__$1 = state_17075;
var statearr_17084_17115 = state_17075__$1;
(statearr_17084_17115[(2)] = null);

(statearr_17084_17115[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17076 === (6))){
var inst_17035 = (state_17075[(8)]);
var inst_17060 = inst_17035.length;
var inst_17061 = (inst_17060 > (0));
var state_17075__$1 = state_17075;
if(cljs.core.truth_(inst_17061)){
var statearr_17085_17116 = state_17075__$1;
(statearr_17085_17116[(1)] = (12));

} else {
var statearr_17086_17117 = state_17075__$1;
(statearr_17086_17117[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17076 === (3))){
var inst_17073 = (state_17075[(2)]);
var state_17075__$1 = state_17075;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17075__$1,inst_17073);
} else {
if((state_val_17076 === (12))){
var inst_17035 = (state_17075[(8)]);
var inst_17063 = cljs.core.vec(inst_17035);
var state_17075__$1 = state_17075;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17075__$1,(15),out,inst_17063);
} else {
if((state_val_17076 === (2))){
var state_17075__$1 = state_17075;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17075__$1,(4),ch);
} else {
if((state_val_17076 === (11))){
var inst_17043 = (state_17075[(10)]);
var inst_17039 = (state_17075[(9)]);
var inst_17053 = (state_17075[(2)]);
var inst_17054 = [];
var inst_17055 = inst_17054.push(inst_17039);
var inst_17035 = inst_17054;
var inst_17036 = inst_17043;
var state_17075__$1 = (function (){var statearr_17087 = state_17075;
(statearr_17087[(7)] = inst_17036);

(statearr_17087[(11)] = inst_17055);

(statearr_17087[(12)] = inst_17053);

(statearr_17087[(8)] = inst_17035);

return statearr_17087;
})();
var statearr_17088_17118 = state_17075__$1;
(statearr_17088_17118[(2)] = null);

(statearr_17088_17118[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17076 === (9))){
var inst_17035 = (state_17075[(8)]);
var inst_17051 = cljs.core.vec(inst_17035);
var state_17075__$1 = state_17075;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17075__$1,(11),out,inst_17051);
} else {
if((state_val_17076 === (5))){
var inst_17036 = (state_17075[(7)]);
var inst_17043 = (state_17075[(10)]);
var inst_17039 = (state_17075[(9)]);
var inst_17043__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_17039) : f.call(null,inst_17039));
var inst_17044 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17043__$1,inst_17036);
var inst_17045 = cljs.core.keyword_identical_QMARK_(inst_17036,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_17046 = (inst_17044) || (inst_17045);
var state_17075__$1 = (function (){var statearr_17089 = state_17075;
(statearr_17089[(10)] = inst_17043__$1);

return statearr_17089;
})();
if(cljs.core.truth_(inst_17046)){
var statearr_17090_17119 = state_17075__$1;
(statearr_17090_17119[(1)] = (8));

} else {
var statearr_17091_17120 = state_17075__$1;
(statearr_17091_17120[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17076 === (14))){
var inst_17068 = (state_17075[(2)]);
var inst_17069 = cljs.core.async.close_BANG_(out);
var state_17075__$1 = (function (){var statearr_17093 = state_17075;
(statearr_17093[(13)] = inst_17068);

return statearr_17093;
})();
var statearr_17094_17121 = state_17075__$1;
(statearr_17094_17121[(2)] = inst_17069);

(statearr_17094_17121[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17076 === (10))){
var inst_17058 = (state_17075[(2)]);
var state_17075__$1 = state_17075;
var statearr_17095_17122 = state_17075__$1;
(statearr_17095_17122[(2)] = inst_17058);

(statearr_17095_17122[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17076 === (8))){
var inst_17043 = (state_17075[(10)]);
var inst_17039 = (state_17075[(9)]);
var inst_17035 = (state_17075[(8)]);
var inst_17048 = inst_17035.push(inst_17039);
var tmp17092 = inst_17035;
var inst_17035__$1 = tmp17092;
var inst_17036 = inst_17043;
var state_17075__$1 = (function (){var statearr_17096 = state_17075;
(statearr_17096[(7)] = inst_17036);

(statearr_17096[(8)] = inst_17035__$1);

(statearr_17096[(14)] = inst_17048);

return statearr_17096;
})();
var statearr_17097_17123 = state_17075__$1;
(statearr_17097_17123[(2)] = null);

(statearr_17097_17123[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14364__auto___17109,out))
;
return ((function (switch__14250__auto__,c__14364__auto___17109,out){
return (function() {
var cljs$core$async$state_machine__14251__auto__ = null;
var cljs$core$async$state_machine__14251__auto____0 = (function (){
var statearr_17101 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17101[(0)] = cljs$core$async$state_machine__14251__auto__);

(statearr_17101[(1)] = (1));

return statearr_17101;
});
var cljs$core$async$state_machine__14251__auto____1 = (function (state_17075){
while(true){
var ret_value__14252__auto__ = (function (){try{while(true){
var result__14253__auto__ = switch__14250__auto__(state_17075);
if(cljs.core.keyword_identical_QMARK_(result__14253__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14253__auto__;
}
break;
}
}catch (e17102){if((e17102 instanceof Object)){
var ex__14254__auto__ = e17102;
var statearr_17103_17124 = state_17075;
(statearr_17103_17124[(5)] = ex__14254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17075);

return cljs.core.cst$kw$recur;
} else {
throw e17102;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14252__auto__,cljs.core.cst$kw$recur)){
var G__17125 = state_17075;
state_17075 = G__17125;
continue;
} else {
return ret_value__14252__auto__;
}
break;
}
});
cljs$core$async$state_machine__14251__auto__ = function(state_17075){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14251__auto____1.call(this,state_17075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14251__auto____0;
cljs$core$async$state_machine__14251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14251__auto____1;
return cljs$core$async$state_machine__14251__auto__;
})()
;})(switch__14250__auto__,c__14364__auto___17109,out))
})();
var state__14366__auto__ = (function (){var statearr_17104 = (f__14365__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14365__auto__.cljs$core$IFn$_invoke$arity$0() : f__14365__auto__.call(null));
(statearr_17104[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14364__auto___17109);

return statearr_17104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14366__auto__);
});})(c__14364__auto___17109,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
