(ns lein-git-version.plugin
  (:require
    [clojure.pprint]
    [leiningen.git-version :refer [get-git-version get-git-ref get-git-last-message]]))

(defn middleware
  [project]
  (let [code (str
               ";; Do not edit.  Generated by lein-git-version plugin.\n"
               "(ns " (:name project) ".version)\n"
               "(def version \"" (get-git-version) "\")\n"
               "(def gitref \"" (get-git-ref) "\")\n"
               "(def gitmsg \"" (get-git-last-message) "\")\n")
        proj-dir (.toLowerCase (.replace (:name project) \- \_))
        filename (if (:git-version-path project)
                   (str (:git-version-path project) "/version.clj")
                   (str (or (first (:source-paths project)) "src") "/"
                        proj-dir "/version.clj"))]
    (spit filename code)
    (assoc project :version (get-git-version))))
