# signal-logging

Logging is hard - <https://signal-ai.getoutline.com/doc/logging-oiwQo3JNFl>

This library attempts to pave a road so you have less to do.

It includes

-   [timbre](https://github.com/ptaoussanis/timbre)
-   a JSON appender for timbre
-   changes to the default console appender to support timbre context and log thread names
-   libraries to setup a bridge for JVM based logging libraries -> SLF4J -> Timbre so it can collect library logs

## Usage

[![Clojars Project](https://img.shields.io/clojars/v/signal-ai/logging.svg)](https://clojars.org/signal-ai/logging)

1. Include this libary in your project.clj

```project.clj
[signal-ai/logging "0.2.0-SNAPSHOT"]
```

2. Exclude any transitive dependencies you might have on logging libraries by [adding these exlusions to your project.clj](https://github.com/signal-ai/signal-logging-clj/blob/master/project.clj#L16)

3. Then when you need to log something, call out to timbre as you normally would:

```clj
(require '[taoensso.timbre :as log])
(require '[signal.logging :as logging])

(logging/init! {:ns (logging/get-namespace-prefix)
                :json (= config/environment "production"))

(log/error (IllegalStateException. "Not logged in") "Oh No!" :some-arg "hello" :some-other-arg "world")
```

alternatively, to always log json but prettify it in development, call `logging/init!` with

```clojure
(logging/init! {:ns (logging/get-namespace-prefix)
                :json {:pretty true}})
```

## License

Copyright © 2021 Signal AI

This program and the accompanying materials are made available under the
terms of the Eclipse Public License 2.0 which is available at
http://www.eclipse.org/legal/epl-2.0.

This Source Code may also be made available under the following Secondary
Licenses when the conditions for such availability set forth in the Eclipse
Public License, v. 2.0 are satisfied: GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or (at your
option) any later version, with the GNU Classpath Exception which is available
at https://www.gnu.org/software/classpath/license.html.
